// extract.cpp -- A program that extracts strings from KDE *.desktop files
//
// 2001 by Niels Reedijk <n.reedijk@planet.nl>
//
// This file is subject to the terms and conditions of the GNU General
// Public License Version 2.  See the file COPYING in the main directory of the
// package for more details.

#include <iostream>
#include <qfile.h>
#include <qstring.h>
#include <qtextstream.h>
#include <qstringlist.h>
#include <qdir.h>
#include <qregexp.h>
#include <qdatetime.h>

QString parseFile ( QString file );

int main( int argc , const char *argv[] )
{
  // We need at least one argument
  if ( argc == 1 )
  {
    cout << "Usage: desktop.cpp DESCRIPTION_FILE\n";
    return 1;
  }
  QFile descriptionFile( QDir::currentDirPath() + "/" + argv[1] );
  //What we want in the output file
  QDateTime qdt = QDateTime::currentDateTime();
  QString output( "# SOME DESCRIPTIVE TITLE.\n# Copyright (C) YEAR OWNER.\n# FIRST AUTHOR <EMAIL@ADDRESS>, YEAR.\n#\n#, fuzzy\nmsgid \"\"\nmsgstr \"\"\n\"Project-Id-Version: PACKAGE VERSION\\n\"\n\"POT-Creation-Date: " + qdt.toString() + "\\n\"\n\"PO-Revision-Date: YEAR-MO-DA HO:MI+ZONE\\n\"\n\"Last-Translator: FULL NAME <EMAIL@ADDRESS>\\n\"\n\"Language-Team: LANGUAGE <LL@li.org>\\n\"\n\"MIME-Version: 1.0\\n\"\n\"Content-Type: text/plain; charset=CHARSET\\n\"\n\"Content-Transfer-Encoding: ENCODING\\n\"\n\n" );
  //file opened succesful
  if ( descriptionFile.open(IO_ReadOnly) )
  {
     QTextStream t( &descriptionFile );
     QStringList files;
     while ( !t.eof() )
       files << t.readLine();
     //finished
     descriptionFile.close();
     for ( int i = 0 ; i < files.count() ; i++ )
       output += parseFile( files[i] );
   }
   else
   {
     cout << "Error parsing the description file ... Quitting\n";
     return 1;
   }
   //TODO, add the option of the output file
   QFile outputFile( "desktop.pot" );
   if ( outputFile.open( IO_WriteOnly ) )
   {
     QTextStream t( &outputFile );
     t << output;
     outputFile.close();
   }
   else
   {
     cout << "An error occured during the creation of the outputfile\n";
     return 1;
   }
  cout << output.latin1() << endl;
  cout << "desktop.pot written. Thank you!\n";
  return 0;
}

QString parseFile ( QString file )
{
  file = QDir::currentDirPath() + "/" + file;
  QFile f( file );
  if ( f.open(IO_ReadOnly) )
  {
    QTextStream t( &f );
    QStringList list;
    //Get all entries
    while ( !t.eof() )
      list << t.readLine();
    //Store the lines ...
    QString name = QString::null , comment = QString::null;
    //... and their linenumbers
    QString nameNumber = QString::null;
    QString commentNumber = QString::null;
    //Check for the name and the comment entries...
    for ( int i = 0; i < list.count() ; i++ )
    {
      if ( (list[i]).find( QRegExp( "^Name=*" ) ) != -1 )
      {
        name = list[i].replace( QRegExp("\"") , "\\\"" );
        nameNumber = nameNumber.setNum( i + 1 );
      }
      if ( list[i].find( QRegExp( "^Comment=*" ) ) != -1 )
      {
        comment = list[i].replace( QRegExp("\"") , "\\\"" );
        commentNumber = commentNumber.setNum( i + 1 );
      }
    }
    //Nothing found? Futile to continue!
    if ( comment == QString::null && name == QString::null )
      return QString::null;

    //What we are going to return
    QString Items;
    if ( comment != QString::null )
      Items = "#: " + file + ":" + commentNumber + "\nmsgid \"" + comment + "\"\nmsgstr \"\"\n\n";
    if ( name != QString::null )
      Items = Items + "#: " + file + ":" + nameNumber + "\nmsgid \"" + name + "\"\nmsgstr \"\"\n\n";
    return Items;
  }
}

