/*
    KSocrat
    Version 3.1.2, 28 April 2003    
    (C) 2000-2003 Zavolzhsky Alexandr <zavolzhsky@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
*/

#include <qaccel.h>
#include <kconfig.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kfontdialog.h>
#include <kstddirs.h>
#include <kmessagebox.h>
#include "sconfigure.h"

SConfigure::SConfigure(QWidget *parent, const char *name) : QDialog(parent,name,true){
    initDialog();
    setCaption(i18n("Setup"));

    connect(btBrowse1,SIGNAL(clicked()),this,SLOT(browseEnRu()));	
    connect(btBrowse2,SIGNAL(clicked()),this,SLOT(browseRuEn()));		
    connect(btFont,SIGNAL(clicked()),this,SLOT(changeFont()));
    connect(btOk,SIGNAL(clicked()),this,SLOT(save()));
    connect(btCancel,SIGNAL(clicked()),this,SLOT(cancel()));
    connect(btClrHist,SIGNAL(clicked()),this,SLOT(clearHistory()));	

    QAccel *skey = new QAccel(this);
    skey->connectItem(skey->insertItem(ALT+Key_O),this,SLOT(save()));
    skey->connectItem(skey->insertItem(ALT+Key_C),this,SLOT(cancel()));	
    skey->connectItem(skey->insertItem(ALT+Key_B),this,SLOT(browseEnRu()));	
    skey->connectItem(skey->insertItem(ALT+Key_W),this,SLOT(browseRuEn()));	

    config = kapp->config();
    config->setGroup("Dictionary");
    KStandardDirs *dataDir = new KStandardDirs();
    QString sEnRuDic = config->readEntry("EnRuPath","");
    if (sEnRuDic.isNull()) {
       sEnRuDic = dataDir->findResource("data","ksocrat/enru.dic");
    }
    edEnRuPath->setText(sEnRuDic);
    QString sRuEnDic = config->readEntry("RuEnPath","");
    if (sRuEnDic.isNull()) {
       sRuEnDic = dataDir->findResource("data","ksocrat/ruen.dic");
    }
    edRuEnPath->setText(sRuEnDic);
    
    config->setGroup("General");
    bool bHideOnStartUp = config->readBoolEntry("HideOnStartUp",false);
    cbHideOnStartUp->setChecked(bHideOnStartUp);
}

SConfigure::~SConfigure(){
}

void SConfigure::save(){
    config = kapp->config();
    config->setGroup("Dictionary");
    config->writeEntry("EnRuPath",edEnRuPath->text());
    config->writeEntry("RuEnPath",edRuEnPath->text());
    config->setGroup("General");
    config->writeEntry("Font",lbFont->font());
    config->writeEntry("HideOnStartUp",cbHideOnStartUp->isChecked());
    config->sync();
    accept();
}

void SConfigure::cancel(){
    reject();
}

void SConfigure::browseEnRu(){
    QString sEnRu = KFileDialog::getOpenFileName("/");
    if (!sEnRu.isEmpty()) {
        edEnRuPath->setText(sEnRu);
    }
}

void SConfigure::browseRuEn(){
    QString sRuEn = KFileDialog::getOpenFileName("/");
    if (!sRuEn.isEmpty()) {
        edRuEnPath->setText(sRuEn);
    }
}

void SConfigure::changeFont(){
    QFont uiFont;
    int res = KFontDialog::getFont(uiFont);
    if(res == KFontDialog::Accepted) {
      kapp->setFont(uiFont,true);
    }
}

void SConfigure::clearHistory() {
  if(KMessageBox::questionYesNo(this,i18n("Clear translation history?"),
    i18n("Question")) == KMessageBox::No) {
    return;
    }
  
  config = kapp->config();
  config->setGroup("General");
  
  QStringList slHistory;
  config->writeEntry("History",slHistory);
  config->sync();
}
