/***************************************************************************
                       kstgraphdialog_i.h  -  Part of KST
                             -------------------
    begin                :
    copyright            : (C) 2003 The University of Toronto
                           (C) 2003 C. Barth Netterfield
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KSTGRAPHFILEDIALOGI_H
#define KSTGRAPHFILEDIALOGI_H

#include "graphfiledialog.h"

class KstGraphFileDialogI : public KstGraphFileDialog {
  Q_OBJECT
  public:
    KstGraphFileDialogI(QWidget* parent = 0, const char* name = 0,
        bool modal = false, WFlags fl = 0 );
    virtual ~KstGraphFileDialogI();

    bool autoSaving() const;
    int autoSaveTimer() const;

    void setAutoSaveTimer(int time);
    void setAutoSave(bool on);

    KURL url() const;
    void setURL(const QString&);

    void setFormat(const QString&);
    QString format() const;

    void setSquare(bool on);
    bool isSquare() const;

    void setImageSize(int xsize, int ysize);
    int imageXSize() const;
    int imageYSize() const;

  public slots:
    /** shows/raises the dialog */
    void showGraphFileDialog();
    void reqGraphFile();
    void saveProperties();
    void loadProperties();
    
  private slots:
    void xsizeChanged(int x);
    void setAutoSave();
    void square();

  private:
    QTimer *_autoSaveTimer;

  signals:
    void graphFileReq(const QString &filename, const QString &format, int w, int h, bool all);
};

#endif
// vim: ts=2 sw=2 et
