/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Fri Apr 27 18:22:15 CEST 2001
    copyright            : (C) 2001 by Brachet Pascal
    email                : pascal.brachet@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kapp.h>
#include <kiconloader.h>
#include <qpixmap.h>
#include "ktexmaker2.h"

static KCmdLineOptions options[] =
{
  { "+[File]", I18N_NOOP("file to open"), 0 },
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char *argv[])
{

  KAboutData aboutData( "ktexmaker2", I18N_NOOP("Ktexmaker2"),
    "1.7", "Integrated LaTeX Environment for KDE", KAboutData::License_GPL,
    "(c) 2001, Brachet Pascal", 0, "http://xm1.net.free.fr/linux/");
  aboutData.addAuthor("Brachet Pascal",0, "pascal.brachet@free.fr");
 	aboutData.addCredit("David Ishee (Xgfe)");
  aboutData.addCredit("Jochen Wilhelmy (Kwrite)");
  aboutData.addCredit("Lars Doelle (Konsole)");
  aboutData.addCredit("Hans Kottman Hagnau (german translation)");
  aboutData.addCredit("Quique (spanish translation)");
  aboutData.addCredit("Salvatore Vassalo (italian translation)");
  aboutData.addCredit("Jeluen Tzeng (traditional chinese translation)");
  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  KApplication a;

	QFrame *f = new QFrame( 0L, QString("Ktexmaker2"),
													QWidget::WStyle_NoBorder | QWidget::WStyle_Customize );

  QPixmap pm( UserIcon("logo") );

  f->setBackgroundPixmap(pm);
  f->setGeometry( QApplication::desktop()->width ()/2-150,
                  QApplication::desktop()->height()/2-75,
  						     300, 130 );
  f->setLineWidth(0);
  f->show();

  if (a.isRestored())
  {
    RESTORE(Ktexmaker2);
  }
  else
  {
  Ktexmaker2 *ktexmaker2 = new Ktexmaker2();
  a.setMainWidget(ktexmaker2);
  ktexmaker2->show();
  delete f;
  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
		if (args->count())
		{
    QString sa = args->arg(0);
    if ( sa.left(5) == "file:" ) sa = sa.remove(0, 5);

    ktexmaker2->Loader(sa);
		}
		args->clear();
  }


  return a.exec();
}
