//
//   File : kvi_mdicaption.cpp (/usr/build/NEW_kvirc/kvirc/src/kvilib/kvi_mdicaption.cpp)
//   Last major modification : Sat Mar 27 1999 13:48:37 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//   Opaque window movement code by Falk Brettschneider (gigafalk@geocities.com)
//

#define _KVI_MDI_CAPTION_CPP_

#include "kvi_mdicaption.h"
#include "kvi_locale.h"
#include "kvi_mdi.h"
#include "kvi_defines.h"

#include <qpainter.h>
#include <qnamespace.h>

//////////////////////////////////////////////////////////////////////////////
// Class   : KviMdiCaption
// Purpose : A Mdi label that draws the icon and the title
//
//
//////////////////////////////////////////////////////////////////////////////

//============== KviMdiCaption =============//

KviMdiCaption::KviMdiCaption(KviMdiChild *parent,const char * name)
:QWidget(parent,name)
{
	m_szCaption       = __tr("Unnamed");
	m_bActive         = false;
	m_pIcon           = 0;
	m_bCanMove        = false;
	m_pParent         = parent;
	m_iMoveResistence = 0;
	setBackgroundMode(NoBackground);
	setFocusPolicy(ClickFocus); //Huh ?
}

//============== ~KviMdiCaption =============//

KviMdiCaption::~KviMdiCaption()
{
}

//============= mousePressEvent ==============//

void KviMdiCaption::mousePressEvent(QMouseEvent *e)
{
	if(e->button() & LeftButton){
		m_bCanMove=true;
		m_iMoveResistence = ((m_pParent->state() == KviMdiChild::Maximized) ? KVI_MDI_CHILD_MOVE_RESISTENCE : 0);
		if(m_pParent->m_pManager->m_bOpaqueMove){
			m_relativeMousePos = e->pos() - pos() + QPoint(KVI_MDI_CHILD_BORDER,KVI_MDI_CHILD_BORDER);
			grabMouse(Qt::sizeAllCursor);
		}
	}
}

//============= leaveEvent ================//

void KviMdiCaption::leaveEvent(QEvent *)
{
	if(!(m_pParent->m_pManager->m_bOpaqueMove))m_bCanMove=false;
}

//============= mouseReleaseEvent ============//

void KviMdiCaption::mouseReleaseEvent(QMouseEvent *e)
{
	if(e->button() & LeftButton){
		if(m_pParent->m_pManager->m_bOpaqueMove)releaseMouse();
	}
	m_bCanMove=false;
}

//============== mouseMoveEvent =============//

void KviMdiCaption::mouseMoveEvent(QMouseEvent *e)
{
//	debug("mouse move cursor : %d,%d - mouse %d,%d",mapFromGlobal(QCursor::pos()).x(),mapFromGlobal(QCursor::pos()).y(),e->pos().x(),e->pos().y());
	if(m_bCanMove){
		if(m_iMoveResistence > 0){
			m_iMoveResistence--;
			return;
		}
		if(e->state() & LeftButton){
			if(m_pParent->m_pManager->m_bOpaqueMove){
				// global cursor pos works better than e->pos()
				// on slow systems and with large areas to be moved
				// often e->pos() is not in sync with QCursor::pos()!
				QPoint diff = (mapFromGlobal(QCursor::pos()) - m_relativeMousePos);
				m_pParent->moveWindowOpaque(diff);
			} else {
				m_pParent->moveWindow();
				m_bCanMove = false;
			}
		}
	}
//	debug("mouse move exit");
}
//=============== setActive ===============//

void KviMdiCaption::setActive(bool bActive)
{
	if(m_bActive==bActive)return;
	m_bActive=bActive;
	repaint(false);
}

//=============== setCaption ===============//

void KviMdiCaption::setCaption(const char *text)
{
	m_szCaption=text;
	repaint(false);
}

//============== heightHint ===============//

int KviMdiCaption::heightHint()
{
	int hght=m_pParent->m_pManager->m_captionFontLineSpacing+2;
	if(hght<18)hght=18;
	return hght;
}

//=============== paintEvent ==============//

void KviMdiCaption::paintEvent(QPaintEvent *)
{
	QPainter p(this);
	QRect r=rect();
	p.setFont(m_pParent->m_pManager->m_captionFont);
	if(m_bActive){
		p.fillRect(r,m_pParent->m_pManager->m_captionActiveBackColor);
		p.setPen(m_pParent->m_pManager->m_captionActiveForeColor);
	} else {
		p.fillRect(r,m_pParent->m_pManager->m_captionInactiveBackColor);
		p.setPen(m_pParent->m_pManager->m_captionInactiveForeColor);
	}
	if(m_pIcon){ //Paint the icon on the left (if there is an icon :) 16x16
		p.drawPixmap(1,1,(*m_pIcon),0,0,16,16);
	}
	r.setLeft(r.left()+19); //Shift the after the icon
	p.drawText(r,AlignVCenter|AlignLeft|SingleLine,_CHAR_2_QSTRING(m_szCaption.ptr()));
}

//============= mouseDoubleClickEvent ===========//

void KviMdiCaption::mouseDoubleClickEvent(QMouseEvent *)
{
	m_pParent->maximizePressed();
}

#include "m_kvi_mdicaption.moc"
