//
//   File : kvi_splash.cpp (/usr/build/NEW_kvirc/kvirc/src/kvilib/kvi_splash.cpp)
//   Last major modification : Fri Mar 5 1999 02:13:06 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

//#define _KVI_DEBUG_CHECK_RANGE_

#include "kvi_debug.h"
#include "kvi_string.h"
#include "kvi_splash.h"
#include "kvi_defines.h"
#include "kvi_locale.h"

#include <qcolor.h>
#include <qframe.h>
#include <qapplication.h>
#include <qlayout.h>

//============ KviSplashScreen ============//

KviSplashScreen::KviSplashScreen(const QPixmap &pix)
:QFrame(0,0,WStyle_Customize | WStyle_NoBorder | WStyle_Tool)
{
	init(pix);
}

KviSplashScreen::KviSplashScreen()
:QFrame(0,0,WStyle_Customize | WStyle_NoBorder | WStyle_Tool)
{
	QPixmap pix(256,256); //cool memory map :)
	init(pix);
}

void KviSplashScreen::init(const QPixmap &pix)
{
	setFrameStyle(QFrame::Panel|QFrame::Raised);

	QGridLayout * g = new QGridLayout(this,5,1,3,2);

	m_pPixLabel = new QLabel("...",this);
	m_pPixLabel->setMinimumSize(pix.size());
	m_pPixLabel->setMaximumSize(pix.size());
	__range_invalid(pix.isNull());
	m_pPixLabel->setBackgroundColor(black);
	m_pPixLabel->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	m_pPixLabel->setPixmap(pix);
	m_pPixLabel->setAlignment(AlignCenter);
	g->addWidget(m_pPixLabel,0,0);

	QLabel * l = new QLabel(_CHAR_2_QSTRING(KVI_SPLASHSCREEN_FIXED_TEXT),this);
	l->setAlignment(AlignCenter);
	g->addWidget(l,1,0);

	QFrame * r = new QFrame(this);
	r->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	r->setMinimumHeight(r->frameWidth() * 2);
	g->addWidget(r,2,0);

	m_pLabel = new QLabel(_CHAR_2_QSTRING(__tr("Initiating startup sequence...")),this);
	m_pLabel->setAlignment(AlignCenter);
	g->addWidget(m_pLabel,3,0);

	m_pProgress = new QProgressBar(100,this);

	g->addWidget(m_pProgress,4,0);

	g->setResizeMode(QLayout::Fixed);
}

//============ ~KviSplashScreen ============//

KviSplashScreen::~KviSplashScreen()
{
}

void KviSplashScreen::showEvent(QShowEvent *e)
{
	move((qApp->desktop()->width() - width())/2,
		(qApp->desktop()->height() - height())/2);
}

void KviSplashScreen::setProgress(int progress)
{
	m_pProgress->setProgress(progress);
	if(progress == 0){
		m_pPixLabel->repaint(false); // The label seems to need it! ... why? Qt knows..
	}
	m_pProgress->repaint(false); //give it a kick :)
	qApp->processEvents(); //damn...
}

void KviSplashScreen::setText(const char *text)
{
	m_pLabel->setText(_CHAR_2_QSTRING(text));
}

#include "m_kvi_splash.moc"
