//
//   File : kvi_asyncdialogs.cpp (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_asyncdialogs.cpp)
//   Last major modification : Tue Mar 2 1999 04:56:55 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//#define _KVI_DEBUG_CLASS_NAME_ "KviAsyncDialogs"
//#define _KVI_DEBUG_CHECK_RANGE_
#include "kvi_debug.h"
#include "kvi_app.h"
#include "kvi_asyncdialogs.h"
#include "kvi_window.h"
#include "kvi_uparser.h"
#include "kvi_locale.h"
#include "kvi_console.h"


#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>

//#warning "TODO : ExistingFileS (multiple selection) do not work with Qt1.4..fix it with 2.0"
//#warning "TODO : KDE kfiledialog Implementation"

KviAsyncDialogCore::KviAsyncDialogCore(KviUserParser * parser,KviWindow * pWnd)
{
	m_pParser = parser;
	m_pWnd = pWnd;
	m_pParser->addAsyncDialog(this);
}
KviAsyncDialogCore::~KviAsyncDialogCore()
{
	__debug(">>> KviAsyncDialogCore::destruktor");
	m_pParser->removeAsyncDialog(this);
	__debug("<<< KviAsyncDialogCore::destruktor");
}
void KviAsyncDialogCore::setJob(const char *beginptr,const char *endptr)
{
	if(endptr == 0)m_szJob = beginptr;
	else m_szJob.setStr(beginptr,endptr-beginptr);
}
void KviAsyncDialogCore::runJob(const char *dialogresult)
{
	m_pParser->m_szLastDialogResult = dialogresult;
	m_pParser->m_szLastDialogMagic = m_szMagic;
	m_pParser->parseAsyncDialogCallback(m_szJob,m_pWnd);
}

//===========================================================================//
// 
// AsyncFileDialog
//

KviAsyncFileDialog::KviAsyncFileDialog(KviUserParser * parser,KviWindow *pWnd)
:QFileDialog(QString::null,QString::null,0,0) , KviAsyncDialogCore(parser,pWnd)
{
}
KviAsyncFileDialog::~KviAsyncFileDialog()
{
	__debug("DESTROYED::KviAsyncFileDialog");
}
void KviAsyncFileDialog::openFileName(){ setMode(ExistingFile); show(); }
void KviAsyncFileDialog::saveFileName(){ setMode(AnyFile); show(); }
void KviAsyncFileDialog::openFileNames(){ setMode(ExistingFiles); show(); }
void KviAsyncFileDialog::openDirectory(){ setMode(Directory); show(); }

void KviAsyncFileDialog::done(int r)
{
	QFileDialog::done(r);
	KviStr tmp = selectedFile();
	runJob(((result() == Accepted) ? tmp.ptr() : ""));
//#warning "THIS DELETE IS UNSAFE......FIND A BETTER WAY ???..Other dialogs in this file too!"
//	delete this;
	g_pApp->destroyLater(this);
}

//===========================================================================//
// 
// AsyncMessageBox
//

KviAsyncMessageBox::KviAsyncMessageBox(KviUserParser * parser,KviWindow *pWnd,
	const char *caption,const char *text,const char *icon,
	const char *btn1)
:QMessageBox(caption,text,QMessageBox::NoIcon,QMessageBox::Ok,0,0,0,0,false),
	KviAsyncDialogCore(parser,pWnd)
{
	setButtonText(QMessageBox::Ok,btn1);
	doSetIcon(icon);
}

KviAsyncMessageBox::KviAsyncMessageBox(KviUserParser * parser,KviWindow *pWnd,
	const char *caption,const char *text,const char *icon,
	const char *btn1,const char *btn2)
:QMessageBox(caption,text,QMessageBox::NoIcon,
	QMessageBox::Ok,QMessageBox::No,0,0,0,false),
	KviAsyncDialogCore(parser,pWnd)
{
	setButtonText(QMessageBox::Ok,btn1);
	setButtonText(QMessageBox::No,btn2);
	doSetIcon(icon);
}

KviAsyncMessageBox::KviAsyncMessageBox(KviUserParser * parser,KviWindow *pWnd,
	const char *caption,const char *text,const char *icon,
	const char *btn1,const char *btn2,const char *btn3)
:QMessageBox(caption,text,QMessageBox::NoIcon,
	QMessageBox::Ok,QMessageBox::No,QMessageBox::Cancel,0,0,false),
	KviAsyncDialogCore(parser,pWnd)
{
	setButtonText(QMessageBox::Ok,btn1);
	setButtonText(QMessageBox::No,btn2);
	setButtonText(QMessageBox::Cancel,btn3);
	doSetIcon(icon);
}
KviAsyncMessageBox::~KviAsyncMessageBox()
{
	__debug("DESTROYED::KviAsyncMessageBox");
}
void KviAsyncMessageBox::done(int r)
{
	QMessageBox::done(r);
	KviStr szRes = "1";
	if(r == QMessageBox::No)szRes = "2";
	else if(r == QMessageBox::Cancel)szRes = "3";
	runJob(szRes.ptr());
//	delete this;
	g_pApp->destroyLater(this);
}
void KviAsyncMessageBox::doSetIcon(const char *iconDescription)
{
	if(kvi_strEqualCIN(iconDescription,"info",4)){ //information
		setIcon(QMessageBox::Information);
		return;
	}
	if(kvi_strEqualCIN(iconDescription,"warn",4)){ //warning
		setIcon(QMessageBox::Warning);
		return;
	}
	if(kvi_strEqualCIN(iconDescription,"crit",4)){ //critical
		setIcon(QMessageBox::Critical);
		return;
	}
}

//===========================================================================//
// 
// AsyncInputBox
//

KviAsyncInputBox::KviAsyncInputBox(KviUserParser *parser,KviWindow *pWnd,
		const char *caption,const char *text,const char *initialtext, bool passwd)
	:QDialog() , KviAsyncDialogCore(parser,pWnd)
{
	setCaption(caption);
	QGridLayout *g = new QGridLayout(this,3,2,4,4);
	QLabel *l = new QLabel(text,this);
	l->adjustSize();
	l->setMinimumSize(l->sizeHint());
	g->addMultiCellWidget(l,0,0,0,1);
	
	m_pLined = new QLineEdit(this);
	m_pLined->setText(initialtext);
	m_pLined->adjustSize();
	m_pLined->setMinimumSize(m_pLined->sizeHint());
	if(passwd)
		m_pLined->setEchoMode(QLineEdit::Password);
	g->addMultiCellWidget(m_pLined,1,1,0,1);

	QPushButton *b = new QPushButton(_i18n_("Ok"),this);
	b->adjustSize();
	b->setMinimumSize(b->sizeHint());
	b->setDefault(true);
	g->addWidget(b,2,0);
	connect(b,SIGNAL(clicked()),this,SLOT(accept()));

	b = new QPushButton(__tr("Cancel"),this);
	b->adjustSize();
	b->setMinimumSize(b->sizeHint());
	g->addWidget(b,2,1);
	connect(b,SIGNAL(clicked()),this,SLOT(reject()));

	g->setRowStretch(0,1);

	g->activate();
	QSize s(l->sizeHint());
	s.setWidth(s.width()+15);
	resize(s); //Do minimum resizing
}
KviAsyncInputBox::~KviAsyncInputBox()
{
	__debug("DESTROYED::KviAsyncInputBox");
}
void KviAsyncInputBox::done(int r)
{
	QDialog::done(r);
	KviStr data = m_pLined->text();
	runJob((result() == Accepted) ? data.ptr() : "" );
	g_pApp->destroyLater(this);
//	delete this;
}

#include "m_kvi_asyncdialogs.moc"
