#ifndef _KVI_FRAME_H_INCLUDED_
#define _KVI_FRAME_H_INCLUDED_

//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qmainwindow.h>
#include <qlist.h>
#include <qrect.h>
#include <qpopupmenu.h>
#include <qaccel.h>

#include "kvi_settings.h"
#include "kvi_string.h"
#include "kvi_dns.h"

class QTimer;
class QSplitter;

class KviMenuBar;
class KviToolBar;
class KviMdiToolBar;
class KviUserToolBar;
class KviStatusBar;
class KviTaskBar;
class KviTaskBarButton;
class KviMdiManager;
class KviWindow;
class KviConsole;
class KviIrcSocket;
class KviIrcView;
class KviServerParser;
class KviUserParser;
class KviIrcUserList;
class KviChannel;
class KviQuery;
class KviUWindow;
class KviDccChat;
class KviDccManager;
class KviDccSend;
class KviDccVoice;
class KviLinksWindow;
class KviListWindow;
class KviSysTrayIoLed;
class KviSysTrayOnLineTimer;
class KviMdiCaptionButton;
class KviDirectoryBrowser;
class KviDirectoryBrowserWidget;
class KviHelpWindow;
class KviSysTrayBar;
class KviConfig;

typedef struct KviGlobalStuff
{
	KviStr szCurrentNick;
	KviStr szCurrentUserName;
	KviStr szCurrentRealName;
	KviStr szCurrentServerHost;
	KviStr szCurrentServerPort;
	KviStr szCurrentServerIp;
	KviStr szCurrentNetwork;
	KviStr szCurrentPassword;
	KviStr szCurrentMaskFromServer;
	KviStr szLocalHostIp;         // Looked up at connection time
	KviStr szLocalHostName;       // Received from server in our mask ASAP
	KviStr szCurrentProxyHost;
	KviStr szCurrentProxyIp;
	KviStr szCurrentProxyPort;
	KviStr szCurrentProxyPassword;
	KviStr szCurrentProxyUsername;
	KviStr szConnectServerHost;
	KviStr szConnectServerPort;
	KviStr szConnectServerIp;
	KviStr szConnectNetwork;
	KviStr szConnectPassword;
	KviStr szConnectProxyHost;
	KviStr szConnectProxyIp;
	KviStr szConnectProxyPort;
	KviStr szConnectProxyPassword;
	KviStr szConnectProxyUsername;

	KviStr szNotifyListString;

	bool bServerSupportsWatchList;
	bool bServerSupportsEMode;    // True if the server supports MODE <channe> e BanException list
	bool bUserHostInProgress;
	bool bSentQuit;

	KviStr szCurrentUserMode;

	KviStr szCurrentSelectionText;
	KviStr szCurrentSelectionToken;
	KviWindow *pCurrentSelectionWindow;

	KviWindow *pCurrentActiveWindow;
	QList<KviStr> * pDnsWhoisPending;
	QList<KviStr> * pMultimediaFileOfferts;

#ifdef COMPILE_NEED_IPV6
	bool bIpV6Mode;
	bool bCIpV6Mode;
#endif
};

class KviFrame : public QMainWindow
{
	friend class KviApp;
	friend class KviWindow;
	friend class KviTaskBar;
	friend class KviIrcSocket;
	friend class KviIrcView;
	friend class KviServerParser;
	friend class KviUserParser;
	friend class KviConsole;
	Q_OBJECT
public:		// Consruction & Destruction
	KviFrame();
	~KviFrame();
public:		// Fields //why don't try to make it private?
	KviMenuBar           * m_pMenuBar;
	KviToolBar           * m_pToolBar;
	KviMdiToolBar        * m_pMdiToolBar;
	KviStatusBar         * m_pStatusBar;
	KviTaskBar           * m_pTaskBar;
	KviSysTrayBar        * m_pSysTrayBar;
	QSplitter            * m_pSplitter;                     // Central widget
	KviMdiManager        * m_pMdi;                          // MDI manager : child of the splitter
	QList<KviWindow>     * m_pWinList;                      // Main list of windows
	KviConsole           * m_pConsole;                      // Console window (always there)
	KviIrcSocket         * m_pSocket;                       // IRC Sokke
	KviDccManager        * m_pDccManager;
	bool                   m_bInSDIMode;

	enum KviIrcConnectionState { Ready , WaitingForDns , WaitingForConnect , LoggingIn , Connected , WaitingForReconnect };
	KviIrcConnectionState m_state;
	//Dns resolver...usually 0 , if not resolving any host
	KviAsyncDns           * m_pDns;
	//Global stuff
	KviGlobalStuff          m_global;
	KviServerParser       * m_pServerParser;
	KviUserParser         * m_pUserParser;
	KviIrcUserList        * m_pUserList;
	int                     m_iUserListUpdateTimer;
	int                     m_iNotifyListUpdateTimer;
	QPopupMenu            * m_pRecentServersPopup;
	QPopupMenu            * m_pRecentChannelsPopup;
	QPopupMenu            * m_pRecentNicknamesPopup;
	QTimer                * m_pReconnectTimer;
	QTimer                * m_pMultimediaFileOffertTimer;
	KviUserToolBar        * m_pUserToolBar;
	KviSysTrayIoLed       * m_pSysTrayIoLed;
	KviSysTrayOnLineTimer * m_pSysTrayOnLineTimer;
	KviMdiCaptionButton   * m_pSDICloseButton;
	KviMdiCaptionButton   * m_pSDIRestoreButton;
	KviMdiCaptionButton   * m_pSDIMinimizeButton;
	KviDirectoryBrowserWidget * m_pDirBrowser;
	KviHelpWindow         * m_pHelpWindow;
	QAccel                * m_pAccel;
	QList<KviStr>         * m_pChannelsBeforeDisconnect;
protected:
	bool			  m_userIdle;
	QTimer			* m_pIdleTimer;
public:
	bool			userIdle() const	{ return m_userIdle; }
	void			stopIdleTimer()		{ m_pIdleTimer->stop();}
	void			restartIdleTimer();
//	void inputKeyPressed();        // KviInput uses this
	void textInput(KviStr *);      // KviInput uses this
	// Window management
	bool dirBrowserOpen();
	void addWindow(KviWindow *pWnd,bool bShow = true);
	void attachWindow(KviWindow *pWnd,bool bShow = true,bool overrideGeometry = true,QRect *r = 0);
	void detachWindow(KviWindow *pWnd);
	void closeWindow(KviWindow *pWnd);
	KviWindow * activeWindow();
	QPopupMenu * taskBarPopup(KviWindow *pWnd,bool bIncludeWindowPopup = false);
	QPopupMenu * windowPopup(KviIrcView *pView,KviWindow *pWnd,bool bIncludeTaskbarPopup = true);
	void forceUpdateToAllMdiChildren();
	void applyMdiOptions();
	void applyOptions();
	KviWindow * findWindow(const char *caption);
	KviChannel * findChannel(const char *chanName);
	KviLinksWindow * getLinksWindow();
	KviListWindow * getListWindow();
	KviQuery * findQuery(const char * queryName);
	KviUWindow * findUWindow(const char *uwindowName);
	KviDccSend * findWaitingDccSend(unsigned short uPort,const char *nick);
	KviDccSend * findListeningDccSend(unsigned short uPort,const char *nick);
	bool windowExists(KviWindow *pWnd);
	KviChannel * createChannel(const char *name);
	KviQuery * createQuery(const char *name, bool isRemote);
	KviQuery * raiseOrCreateQuery(const char *name);
	KviLinksWindow * createLinksWindow();
	KviListWindow * createListWindow();
	KviDccChat * createDccChat(const char *name);
	KviDccSend * createDccSend(const char *name);
	KviDccVoice * createDccVoice(const char *name);
	KviUWindow * createUWindow(const char *name);
	KviDirectoryBrowser * createDirectoryBrowser(const char *dirname);
	void userModeChange(const char *umode);
	void outputPrivmsg(KviWindow *wnd,int type,const char * talker,const char *talker_mask,const char *msg);
	void updateCaption();
	void startUpdatingUserList();
	void stopUpdatingUserList();
	bool isUpdatingUserList(){ return m_iUserListUpdateTimer != 0; };
	void doAsyncServerCommandCall();
	void startWatchList();
	void startNotifyList();
	void startNotifyOrWatchList();
	void stopNotifyList();
	void stopWatchList();
	void stopNotifyOrWatchList();
	void updateNotifyOrWatchList();
	void clearConsoleListBox();
	void switchWindows(bool bRight);
	void fillRecentServersPopup();
	void fillRecentNicknamesPopup();
	void fillRecentChannelsPopup();
	void fillRecentPopup(QPopupMenu * popup,KviStr &data);
	void addRecentServer(KviStr &serverName,KviStr &port);
	void addRecentChannel(const char *chan);
	void addRecentNickname(KviStr &nickname);
	bool addRecentEntry(KviStr &list,KviStr &entry);
	void actionForCurrentlySelectedTextToken(const char *action);
	void updateUserToolBar();
	void addMultimediaFileOffert(const KviStr &offert);
	void findMultimediaFileOffert(KviStr &retPath,KviStr &filename);
	bool isLoggingIn(){ return m_state == LoggingIn; };
	bool isConnected(){ return m_state == Connected; };
	KviIrcConnectionState state(){ return m_state; };
	void helpForObject(QObject *w);
	void requestHelpOn(const char *topic);
	void requestHelpSearchOn(const char *topic);
	void zeroHelpWindowPointer()	{ m_pHelpWindow = NULL; }	// erh... this is a nasty hack, but I have no other idea how to do this
									// (I == Kristoff :))
public slots:
	// toolbar slots
	void slot_connectToServer();
	void slot_toggleStatusBar();
	void slot_toggleTaskBar();
	void slot_toggleMdiToolBar();
	void slot_toggleToolBar();
	void slot_toggleSysTrayBar();
	void slot_requestLinks();
	void slot_whatIsThisRequest();
	void slot_showScriptCenter();
	void slot_toggleUserToolBar();
	void slot_lineUpToolBarsNormal();
	void slot_lineUpToolBarsCompact();
//	void createNewDirBrowser();
	void connectToRecentServer(int id);
	void joinRecentChannel(int id);
	void setRecentNickname(int id);
	// Dns slot..server name resolved
	void serverNameResolved(KviDnsStruct * dns);
	void proxyNameResolved(KviDnsStruct * dns);
	void copyCurrentSelectionTextToClipboard();
	void doHelpOnCurrentlySelectedTextToken();
	void doHelpSearchOnCurrentlySelectedTextToken();
	void whoisCurrentlySelectedToken();
	void queryCurrentlySelectedToken();
	void hostCurrentlySelectedToken();
	void dnsCurrentlySelectedToken();
	void joinCurrentlySelectedToken();
	void topicCurrentlySelectedToken();
	void dccChatCurrentlySelectedToken();
	void execCurrentlySelectedText();
	void activateListWindow();
	void partChannel(KviWindow *pWnd);
	void asyncServerCommand();
	void reconnectToServer();
	void cleanupMultimediaFileOffertList();
	void mdiManagerSDIModeChange(bool bEntering);
	void toggleHelpWindow();
	void toggleDirBrowser();
protected:
	//Connection management
	bool isValidStringIp(const char *szIp);
	void applyToolbarOptions();
	bool checkHighlight(const char *msg);
	void setState(KviIrcConnectionState state);
	void haveServerIp();
	void haveProxyIp();
	void connectToServer();
	void disconnectFromServer();
	void connectionAttemptFailed(int errNum);
	void abortDns();
	void abortConnection();
	void abortReconnect();
	void resolveLocalHost();
	void getArtificialNickname(KviStr &nickToChange);
	bool findCurrentServerToContact();
	bool findNextServerToContact();
	bool findCurrentProxyHost();
	void lookupServerHostname();
	void lookupProxyHostname();
	void handleConnectedToIrcServer();
	void handleDisconnectedFromServer();
	void loginToIrcServer();
	void loginNickRefused();
	void ircLoginSuccesful(KviStr &szAcceptedNickname);
	//Socket events
	void socketEvent(int sockEventId);
	virtual void closeEvent(QCloseEvent *e);
	virtual void focusInEvent(QFocusEvent *);
	virtual void timerEvent(QTimerEvent *e);
	virtual bool focusNextPrevChild(bool next);
	void resetGlobals();
	void resetProxyGlobals();
	void childWindowGainFocus(KviWindow *pWnd);
	void childWindowCloseRequest(KviWindow *pWnd);
	void taskbarButtonLeftClicked(KviWindow *pWnd,KviTaskBarButton *btn);
	void taskbarButtonRightClicked(KviWindow *pWnd,KviTaskBarButton *btn);
	void ircViewTextSelected(KviIrcView *pView,KviWindow *pWnd,const char *text);
	void windowPopupRequested(KviIrcView *pView,KviWindow *pWnd);
	void resizeEvent(QResizeEvent *e);
	void adjustSDIButtons();
	// Creation
	void createSplitter();
	void createConsole();
	void createMenuBar();
	void createToolBar();
	void createMdiToolBar();
	void createTaskBar();
	void createStatusBar();
	void createMdiManager();
	void createSDIModeButtons();
	void createUserToolBar();
	void createSysTrayBar();
//	void saveTaskBarPosition();
//	void saveToolBarPosition();
//	void saveUserToolBarPosition();
//	void saveSysTrayBarPosition();

	void saveToolBarPositions();
	void restoreToolBarPositions();

	void saveToolBarState(QToolBar * t,KviConfig * cfg);
	void restoreToolBarState(QToolBar * t,KviConfig * cfg,QMainWindow::ToolBarDock defDock,int defIndex,bool bDefNewline,int defExtra);

	QAccel * installAccelerators(QWidget *w);
protected slots:
	void accelActivated(int id);
	void triggerOnIdleEvent();

};

#endif //_KVI_FRAME_H_INCLUDED_
