#ifndef _KVI_UPARSER_H_INCLUDED_
#define _KVI_UPARSER_H_INCLUDED_

//
//   File : kvi_uparser.h (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_uparser.h)
//   Last major modification : Fri Feb 12 1999 04:25:17 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_string.h"
#include "kvi_varcache.h"

class KviFrame;
class KviIrcSocket;
class KviWindow;
class KviConsole;
class KviInput;
class KviCommand;
class KviUserParser;
class KviExprTree;
class KviAlias;
class KviScriptObject;
class KviScriptObjectController;

typedef struct KviPluginCommandHandler;
typedef struct KviPluginFunctionHandler;

typedef struct KviWindowTimer
{
	KviStr      job;
	KviStr      name;
	int         id;
	int         timeout;
	KviWindow * window;
	KviStr      magic;
	bool        singleShot;
};

typedef bool (KviUserParser::*commandParseProc) (KviCommand *);
typedef bool (KviUserParser::*identParseProc) (KviCommand *,KviStr &);

typedef struct KviCommandEntry
{
	const char *     cmdName;
	int              cmdLen;
	commandParseProc cmdProc;
};

typedef struct KviIdentifierEntry
{
	const char *     idnName;
	identParseProc   idnProc;
};

typedef struct KviFunctionEntry
{
	const char *     fncName;
	identParseProc   fncProc;
};

//typedef struct KviCommandParams
//{
//	KviStr buffer;
//	KviStr param0;
//	const char * paramPtr[9];
//	int paramLen[9];
//	int numParams;
//};

#include <qlist.h>

#define KVI_COMMAND_FLAG_RECOGNIZE_OBJECT_SCOPE_OPERATOR 1
#define KVI_COMMAND_FLAG_BREAK_PENDING 2

class KviCommand 
{
public:
	KviCommand(const char *pBuf,KviWindow *pWnd);
	~KviCommand();
public:
	const char * m_ptr;
	KviWindow  * m_wnd;

	int          m_err;
	KviStr       m_szErrorToken;
	KviStr       m_szErrorLocation;

	KviStr       m_buffer;
	KviStr       m_retBuffer;
	KviVariableCache * m_pLocalVarCache;
private:
	KviScriptObject  * m_pScopeObject;
	KviStr             m_szThisId;

	QList<KviStr>    * m_pParamList;
	int                m_flags;
public:
	bool hasError();
	void skipWhitespace();
	void setThisId(const char *tid);
	const char * thisId();
	bool hasThisId(){ return (*(m_szThisId.ptr()) != '\0'); };
	// returns ALWAYS false
	bool setError(int iError,const char *szLocation,const char *szErrToken = 0);
	void clearBuffer();
	void skipSpace();
	bool hasParams();
	void setParams(const KviStr &param0,const char * paramBuffer);
	void setParams(const KviStr &param0,QList<KviStr> * pList);
	bool setParamsFromCommand(const KviStr &param0,KviCommand *c,KviUserParser *u);
	void getParamCount(KviStr &buffer);
	void getSingleParam(int param,KviStr &buffer);
	void getParam(int fromParam,int toParam,KviStr &buffer);
	// returns ALWAYS true
	bool warning(const char *format,...);
	QList<KviStr> * m_switchList;
	bool hasSwitch(char letter);
	bool getSwitchValue(char letter,KviStr &buffer);
	void clearSwitchList();
	void setReturnValue(const char *retBuffer);
	KviScriptObject * scopeObject();
	void setScopeObject(KviScriptObject *o);
	void setRecognizeObjectScopeOperator(bool bRec);
	bool recognizeObjectScopeOperator();
	void setBreakPending(bool bPending);
	bool breakPending();
};

//inline void KviCommand::clearParamList(){ while(m_paramList->first())m_paramList->removeFirst(); };
inline void KviCommand::clearSwitchList(){ while(m_switchList->first())m_switchList->removeFirst(); };

//inline bool KviCommand::hasParams(){ return m_pParams != 0; };
inline bool KviCommand::hasParams(){ return m_pParamList != 0; };
inline void KviCommand::clearBuffer(){ m_buffer = ""; }

inline void KviCommand::setThisId(const char *tid){ m_szThisId = tid; };
inline const char * KviCommand::thisId(){ return m_szThisId.ptr(); };

inline KviScriptObject * KviCommand::scopeObject(){ return m_pScopeObject; };
inline void KviCommand::setScopeObject(KviScriptObject *o){ m_pScopeObject = o; };

inline void KviCommand::setRecognizeObjectScopeOperator(bool bRec){
	if(bRec)m_flags |= KVI_COMMAND_FLAG_RECOGNIZE_OBJECT_SCOPE_OPERATOR;
	else m_flags &= (~KVI_COMMAND_FLAG_RECOGNIZE_OBJECT_SCOPE_OPERATOR);
};
inline bool KviCommand::recognizeObjectScopeOperator(){ return (m_flags & KVI_COMMAND_FLAG_RECOGNIZE_OBJECT_SCOPE_OPERATOR); };

inline void KviCommand::setBreakPending(bool bPending){
	if(bPending)m_flags |= KVI_COMMAND_FLAG_BREAK_PENDING;
	else m_flags &= (~KVI_COMMAND_FLAG_BREAK_PENDING);
};
inline bool KviCommand::breakPending(){ return (m_flags & KVI_COMMAND_FLAG_BREAK_PENDING); };


class KviAsyncDialogCore;
class KviPopupMenu;
class KviSlaveIO;
class KviAsyncWhois;

#include "kvi_dns.h"


typedef struct _KviCommandErrorInfo
{
	int iLineNum;
	int iCharNum;
	KviStr szLineStr;
} KviCommandErrorInfo;

class KviUserParser : public QObject
{
	Q_OBJECT
	friend class KviFrame; //only KviFrame can construct it
	friend class KviCommand;
	friend class KviAsyncDialogCore; //only this can access m_szLastDialogMagic & co.
	friend class KviAsyncWhois;
	friend class KviApp; //access to m_bLastIsRemoteExec etc...
	friend class KviScriptObject; // accesses the m_pConsole member
	friend class KviScriptObjectController;
	friend class KviInput; // accesses the KviCommandEntry tables
protected:
	KviUserParser(KviFrame *pFrm);
	~KviUserParser();
protected:
	KviConsole               *m_pConsole;
	KviFrame                 *m_pFrm;
	KviIrcSocket             *m_pSocket;
	static KviCommandEntry    cmdTable_A_G[];
	static KviCommandEntry    cmdTable_H_N[];
	static KviCommandEntry    cmdTable_O_S[];
	static KviCommandEntry    cmdTable_T_Z[];

	static KviIdentifierEntry idnTable_A_G[];
	static KviIdentifierEntry idnTable_H_N[];
	static KviIdentifierEntry idnTable_O_S[];
	static KviIdentifierEntry idnTable_T_Z[];

	static KviFunctionEntry   fncTable_A_G[];
	static KviFunctionEntry   fncTable_H_N[];
	static KviFunctionEntry   fncTable_O_S[];
	static KviFunctionEntry   fncTable_T_Z[];

	KviStr m_szLastDialogResult;
	KviStr m_szLastDialogMagic;
	KviStr m_szLastTimerMagic;
	KviStr m_szLastTimerName;

	KviStr m_szLastProcCommandline;
	KviStr m_szLastProcMagic;
	KviStr m_szLastProcStdout;
	KviStr m_szLastProcStderr;
	KviStr m_szLastProcPid;
	KviStr m_szLastProcWindow;
	KviStr m_szLastProcExitCode;

	KviStr m_szLastAsyncWhoisNick;
	KviStr m_szLastAsyncWhoisUsername;
	KviStr m_szLastAsyncWhoisHost;
	KviStr m_szLastAsyncWhoisRealName;
	KviStr m_szLastAsyncWhoisServer;
	KviStr m_szLastAsyncWhoisIdleTime;
	KviStr m_szLastAsyncWhoisStatus;
	KviStr m_szLastAsyncWhoisIrcOp;
	KviStr m_szLastAsyncWhoisChannels;
	KviStr m_szLastAsyncWhoisWindow;
	KviStr m_szLastAsyncWhoisMagic;
	KviStr m_szLastAsyncWhoisSuccess;

	KviStr m_szLastTryResult;

	KviStr m_szLastSignalSender;

//	KviStr m_szLastObjThisId;

	KviStr m_szLastExecFilename;
	bool   m_bLastIsRemoteExec;

	QList<KviAsyncDialogCore> *m_pAsyncDialogList;
	QList<KviAsyncDns> *m_pAsyncDnsList;
	QList<KviWindowTimer> * m_pTimerList;
	KviSlaveIO * m_pSlaveIOController;

public:
	KviScriptObjectController * m_pScriptObjectController;
	KviAsyncWhois * m_pAsyncWhoisController;

public:
//	#warning "is this ok ?" Yes :)
	// need to use this in sparser
	// kvi_uparser.cpp
	void setLastSignalSender(const char * lss);
	void unregisterTimersFor(KviWindow * wnd);
	int completeCommand(KviStr &word,KviStr &match,KviStr &multiple);
	int completeFunctionOrIdentifier(KviStr &word,KviStr &match,KviStr &multiple);
	void setup(KviIrcSocket *pSock,KviConsole *pConsole);
	void parseUserCommand(KviStr &str,KviWindow *pWnd);
	bool parseCommand(const char *ptr,KviWindow *pWnd,const char * params = 0);
	void parseAsyncDialogCallback(KviStr &str,KviWindow *pWnd);
	bool processString(const char *ptr,KviWindow *pWnd,KviStr &buffer);
	bool callEvent(int index,KviWindow * pWnd,const KviStr &params);
	bool callRawEvent(const KviStr &szCommand,const KviStr &szPrefix,const KviStr &szBuffer,const KviStr &szParams,const KviStr &szSourceMask,KviStr &retValue);
	bool doAsyncDnsCallForHost(const char *host,const char *data = 0);
//	bool doAsyncWhoisCall(const char *nick);
	void slaveAsyncProcessExited(KviStr &job,KviStr &commandline,KviStr &stdoutBuf,KviStr &stderrBuf,KviStr &magic,KviStr &window,unsigned int uPid,int iExitCode);
	void asyncWhoisEnd(KviStr &asyncCmd,KviStr &magic,KviStr &window,KviStr &nick,KviStr &user,
			KviStr &host,KviStr &realName,KviStr &server,KviStr &idle,KviStr &status,bool bIrcOp, KviStr &chans,bool bSuccess);
	bool triggerObjectEvent(KviScriptObject *o,const char *eventName,const char *eventBuf,const KviStr &params);
	bool callObjectFunction(KviScriptObject *o,const char *fncName,const char *fncBuf,QList<KviStr> * params,KviStr &buffer);
public slots:
	void asyncDnsFinished(KviDnsStruct *dns);
protected:
	bool notConnectedToServer(KviCommand *c,const char *inCommand);
	bool recoverableError(KviCommand *c,int error,const char * cmdName,const char *additionalData = 0);

	static bool skipCommand(KviCommand *c);
	static bool skipCommandBlock(KviCommand *c);
	static bool skipSingleCommand(KviCommand *c);
	static bool skipIdentifier(KviCommand *c);
	static bool skipExpressionBody(KviCommand *c);
	static bool skipIf(KviCommand *c);
	static bool skipWhile(KviCommand *c);
	static bool skipDo(KviCommand *c);
	static bool skipSwitch(KviCommand *c);
	static bool skipAlias(KviCommand *c);
	static bool skipDialog(KviCommand *c);
	static bool skipPopup(KviCommand *c);
	static bool skipPopupBuffer(KviCommand *c);
	static bool skipForeach(KviCommand *c);
	static bool skipTimer(KviCommand *c);
	static bool skipExecv(KviCommand *c);
	static bool skipAwhois(KviCommand *c);
	static bool skipUtoolbar(KviCommand *c);
	static bool skipVariable(KviCommand *c);
	static bool skipVariableKey(KviCommand *c);
	static bool skipSwitches(KviCommand *c);
	static bool skipSingleSwitch(KviCommand *c);
	static bool skipTry(KviCommand *c);
	static bool skipObj_setEvent(KviCommand *c);
	static bool skipClass(KviCommand *c);
	static bool skipObjectScopeRValue(KviCommand *c);
	static bool skipLValue(KviCommand *c);
	static bool skipComment(KviCommand *c);

	bool execCommandBuffer(KviCommand *c);
	bool execCommandBlock(KviCommand *c);
	bool execSingleCommand(KviCommand *c);

	bool extractSwitches(KviCommand * c);
	bool extractSingleSwitch(KviCommand *c);

	void getErrorInfo(KviCommand *c,const char *bufferBegin,KviCommandErrorInfo * inf);
	void printError(KviCommand *c,const char *bufferBegin);

	bool processVariable(KviCommand *c,KviStr &buffer);
	bool processVariableKey(KviCommand *c,KviStr &buffer);
	bool processIdentifier(KviCommand *c,KviStr &buffer);
	bool processParameterIdentifier(KviCommand *c,KviStr &buffer);

	bool processFncSingleParamInternal(KviCommand *c,KviStr &buffer);
	bool processFncSingleParam(KviCommand *c,KviStr &buffer);
	bool processFncFinalPart(KviCommand *c,KviStr &buffer);
	bool processCmdSingleToken(KviCommand *c);
	bool processCmdFinalPart(KviCommand *c);
	bool processCmdFinalPartNoIdent(KviCommand *c);

	bool processObjectScopeRValue(KviScriptObject *o,KviCommand *c,KviStr &buffer);

	// kvi_popupmenu.cpp
	bool generatePopupFromBuffer(KviPopupMenu *m,KviCommand *c,bool bAppend);

	// kvi_command.cpp
	bool processOperator(KviCommand *c,KviVariableCache *cache,KviStr &szVariable,KviStr &szKey);

	bool parseCmd_LVALUE(KviCommand *c);
	bool parseCmd_ECHO(KviCommand *c);
	bool parseCmd_ECHOPRIVMSG(KviCommand *c);
	bool parseCmd_HELP(KviCommand *c);
	bool parseCmd_PARSE(KviCommand *c);
	bool parseCmd_HALT(KviCommand *c);
	bool parseCmd_IF(KviCommand *c);
	bool parseCmd_WHILE(KviCommand *c);
	bool parseCmd_DO(KviCommand *c);
	bool parseCmd_DIALOG(KviCommand *c);
	bool parseCmd_ALIAS(KviCommand *c);
	bool parseCmd_DEBUG(KviCommand *c);
	bool parseCmd_SWITCH(KviCommand *c);
	bool parseCmd_QUIT(KviCommand *c);
	bool parseCmd_NICK(KviCommand *c);
	bool parseCmd_USER(KviCommand *c);
	bool parseCmd_POPUP(KviCommand *c);
	bool parseCmd_UTOOLBAR(KviCommand *c);
	bool parseCmd_RAW(KviCommand *c);
	bool parseCmd_FOREACH(KviCommand *c);
	bool parseCmd_QUERY(KviCommand *c);
	bool parseCmd_TOPIC(KviCommand *c);
	bool parseCmd_AME(KviCommand *c);
	bool parseCmd_AMSG(KviCommand *c);
	bool parseCmd_ANOTICE(KviCommand *c);
	bool parseCmd_ONOTICE(KviCommand *c);
	bool parseCmd_STATUS(KviCommand *c);
	bool parseCmd_TIMER(KviCommand *c);
	bool parseCmd_KILLTIMER(KviCommand *c);
	bool parseCmd_CONFIG(KviCommand *c);
	bool parseCmd_DIRBROWSER(KviCommand *c);
	bool parseCmd_BREAK(KviCommand *c);
	bool parseCmd_SAVEOPTIONS(KviCommand *c);

	bool parseCmd_JOIN(KviCommand *c);
	bool parseCmd_PART(KviCommand *c);
	bool parseCmd_MODE(KviCommand *c);
	bool parseCmd_UMODE(KviCommand *c);

	bool parseCmd_OP(KviCommand *c);
	bool parseCmd_DEOP(KviCommand *c);
	bool parseCmd_VOICE(KviCommand *c);
	bool parseCmd_DEVOICE(KviCommand *c);
	bool parseCmd_HALFOP(KviCommand *c);
	bool parseCmd_DEHALFOP(KviCommand *c);
	bool parseCmd_USEROP(KviCommand *c);
	bool parseCmd_DEUSEROP(KviCommand *c);
	bool parseCmd_OWNER(KviCommand *c);
	bool parseCmd_DEOWNER(KviCommand *c);
	bool parseCmd_BAN(KviCommand *c);
	bool parseCmd_UNBAN(KviCommand *c);
	bool parseCmd_EXCEPT(KviCommand *c);
	bool parseCmd_UNEXCEPT(KviCommand *c);

	bool parseCmd_LOG(KviCommand *c);
	bool parseCmd_OPTION(KviCommand *c);
	bool parseCmd_LOADCONF(KviCommand *c);
	bool parseCmd_CLEAR(KviCommand *c);

	bool parseCmd_KILL(KviCommand *c);
	bool parseCmd_OPER(KviCommand *c);
	bool parseCmd_SETHOST(KviCommand *c);
	bool parseCmd_REHASH(KviCommand *c);

	bool parseCmd_OPENURL(KviCommand *c);

	bool parseCmd_DESTROY(KviCommand *c);
//	bool parseCmd_OBJ_SETFIELD(KviCommand *c);
	bool parseCmd_OBJ_SETEVENT(KviCommand *c);
	bool parseCmd_OBJ_CLEAREVENT(KviCommand *c);
	bool parseCmd_OBJ_TRIGGEREVENT(KviCommand *c);
	bool parseCmd_CLEAROBJECTS(KviCommand *c);
	bool parseCmd_CLASS(KviCommand *c);

	bool parseCmd_PLAY(KviCommand *c);
	bool parseCmd_MULTIMEDIA(KviCommand *c);
	bool parseCmd_SOUND(KviCommand *c);
	bool parseCmd_MULTIMEDIAORSOUND(KviCommand *c,const char *ctcpName);

	bool parseCmd_WHOIS(KviCommand *c);
	bool parseCmd_AWHOIS(KviCommand *c);
	bool parseCmd_WHOWAS(KviCommand *c);
	bool parseCmd_WHO(KviCommand *c);
	bool parseCmd_USERHOST(KviCommand *c);
	bool parseCmd_NAMES(KviCommand *c);
	bool parseCmd_BEEP(KviCommand *c);

	bool parseCmd_MSG(KviCommand *c);
	bool parseCmd_NOTICE(KviCommand *c);
	bool parseCmd_SAY(KviCommand *c);

	bool parseCmd_HELPOP(KviCommand *c);
	bool parseCmd_LOCOPS(KviCommand *c);
	bool parseCmd_GLOBOPS(KviCommand *c);
	bool parseCmd_WALLOPS(KviCommand *c);

	bool parseCmd_CTCP(KviCommand *c);
	bool parseCmd_CTCPREPLY(KviCommand *c);

	bool parseCmd_KICK(KviCommand *c);

	bool parseCmd_SERVER(KviCommand *c);
	bool parseCmd_NEWSWINDOW(KviCommand *c);
	bool parseCmd_ME(KviCommand *c);
	bool parseCmd_HOST(KviCommand *c);
	bool parseCmd_DCC(KviCommand *c);
	bool parseCmd_PLUGIN(KviCommand *c);
	bool parseCmd_FINDTEXT(KviCommand *c);

	bool parseCmd_DNS(KviCommand *c);
	bool parseCmd_SETRETURN(KviCommand *c);

	bool parseCmd_REGISTER(KviCommand *c);
	bool parseCmd_UNREGISTER(KviCommand *c);
	bool parseCmd_IGNORE(KviCommand *c);
	bool parseCmd_NOTIFY(KviCommand *c);
	bool parseCmd_SETCOMMENT(KviCommand *c);
	bool parseCmd_SETFLAGS(KviCommand *c);
	bool parseCmd_SETPASS(KviCommand *c);

	bool parseCmd_LINKS(KviCommand *c);
	bool parseCmd_MAP(KviCommand *c);
	bool parseCmd_LIST(KviCommand *c);
	bool parseCmd_MOTD(KviCommand *c);
	bool parseCmd_LUSERS(KviCommand *c);
	bool parseCmd_INFO(KviCommand *c);
	bool parseCmd_STATS(KviCommand *c);
	bool parseCmd_ADMIN(KviCommand *c);
	bool parseCmd_TIME(KviCommand *c);
	bool parseCmd_VERSION(KviCommand *c);
	bool parseCmd_LAG(KviCommand *c);

	bool parseCmd_CHANSERV(KviCommand *c);
	bool parseCmd_NICKSERV(KviCommand *c);
	bool parseCmd_MEMOSERV(KviCommand *c);
	bool parseCmd_OPERSERV(KviCommand *c);
	bool parseCmd_HELPSERV(KviCommand *c);
	bool parseCmd_STATSERV(KviCommand *c);

	bool parseCmd_DIR(KviCommand *c);
	bool parseCmd_CD(KviCommand *c);

	bool parseCmd_INVITE(KviCommand *c);

	bool parseCmd_RUN(KviCommand *c);
	bool parseCmd_WINDOW(KviCommand *c);
	bool parseCmd_GEOMETRY(KviCommand *c);

	bool parseCmd_EXEC(KviCommand *c);
	bool parseCmd_PROCLIST(KviCommand *c);
	bool parseCmd_KILLPROC(KviCommand *c);
	bool parseCmd_WRITEPROC(KviCommand *c);
	bool parseCmd_EXECV(KviCommand *c);

	bool parseCmd_TRY(KviCommand *c);

	bool parseCmd_WRITEFILE(KviCommand *c);

	bool parseCmd_CONNECT(KviCommand *c);
	bool parseCmd_DISCONNECT(KviCommand *c);

	bool parseMultipleModeCommand(KviCommand *c,const char *cmdName,bool bModeAdd,char flag);

	bool parseAlias(KviCommand *c,KviAlias *a);
	bool parsePluginCommand(KviPluginCommandHandler * h,KviCommand *c);
	bool parsePluginFunction(KviPluginFunctionHandler *h,KviCommand *c,KviStr &buffer);
	bool parsePluginIdentifier(KviPluginFunctionHandler *h,KviCommand *c,KviStr &buffer);
	bool parseUnknownCommand(KviStr &cmd,KviCommand *c);

	// kvi_identifiers.cpp
	bool parseIdn_ISCONNECTED(KviCommand *c,KviStr &buffer);
	bool parseIdn_WINDOW(KviCommand *c,KviStr &buffer);
	bool parseIdn_DIALOGRESULT(KviCommand *c,KviStr &buffer);
	bool parseIdn_DIALOGMAGIC(KviCommand *c,KviStr &buffer);
	bool parseIdn_TIMERMAGIC(KviCommand *c,KviStr &buffer);
	bool parseIdn_TIMERNAME(KviCommand *c,KviStr &buffer);
	bool parseIdn_CR(KviCommand *c,KviStr &buffer);
	bool parseIdn_LF(KviCommand *c,KviStr &buffer);
	bool parseIdn_K(KviCommand *c,KviStr &buffer);
	bool parseIdn_B(KviCommand *c,KviStr &buffer);
	bool parseIdn_U(KviCommand *c,KviStr &buffer);
	bool parseIdn_R(KviCommand *c,KviStr &buffer);
	bool parseIdn_O(KviCommand *c,KviStr &buffer);
	bool parseIdn_TIME(KviCommand *c,KviStr &buffer);
	bool parseIdn_DATE(KviCommand *c,KviStr &buffer);
	bool parseIdn_DAY(KviCommand *c,KviStr &buffer);
	bool parseIdn_MONTH(KviCommand *c,KviStr &buffer);
	bool parseIdn_YEAR(KviCommand *c,KviStr &buffer);
	bool parseIdn_ME(KviCommand *c,KviStr &buffer);
	bool parseIdn_MYUSERNAME(KviCommand *c,KviStr &buffer);
	bool parseIdn_MYREALNAME(KviCommand *c,KviStr &buffer);
	bool parseIdn_MYHOSTNAME(KviCommand *c,KviStr &buffer);
	bool parseIdn_MYIP(KviCommand *c,KviStr &buffer);
	bool parseIdn_MYMASK(KviCommand *c,KviStr &buffer);
	bool parseIdn_SERVERHOSTNAME(KviCommand *c,KviStr &buffer);
	bool parseIdn_SERVERIP(KviCommand *c,KviStr &buffer);
	bool parseIdn_SERVERPORT(KviCommand *c,KviStr &buffer);
	bool parseIdn_SERVERNETWORK(KviCommand *c,KviStr &buffer);
	bool parseIdn_VERSION(KviCommand *c,KviStr &buffer);
	bool parseIdn_CONSOLE(KviCommand *c,KviStr &buffer);
	bool parseIdn_MYUMODE(KviCommand *c,KviStr &buffer);
	bool parseIdn_SELECTED(KviCommand *c,KviStr &buffer);
	bool parseIdn_SELECTEDMASKS(KviCommand *c,KviStr &buffer);
	bool parseIdn_SELECTEDHOSTS(KviCommand *c,KviStr &buffer);
	bool parseIdn_SELECTEDUSERNAMES(KviCommand *c,KviStr &buffer);
	bool parseIdn_KVIRCDIR(KviCommand *c,KviStr &buffer);
	bool parseIdn_KVIRCLOGDIR(KviCommand *c,KviStr &buffer);
	bool parseIdn_KVIRCSCRIPTDIR(KviCommand *c,KviStr &buffer);
	bool parseIdn_CHAN(KviCommand *c,KviStr &buffer);
	bool parseIdn_QUERY(KviCommand *c,KviStr &buffer);
	bool parseIdn_CHAT(KviCommand *c,KviStr &buffer);
	bool parseIdn_ALLWINDOWS(KviCommand *c,KviStr &buffer);
	bool parseIdn_ALLQUERIES(KviCommand *c,KviStr &buffer);
	bool parseIdn_ALLCHANNELS(KviCommand *c,KviStr &buffer);
	bool parseIdn_ALLCHATS(KviCommand *c,KviStr &buffer);
	bool parseIdn_PROCCMDLINE(KviCommand *c,KviStr &buffer);
	bool parseIdn_PROCPID(KviCommand *c,KviStr &buffer);
	bool parseIdn_PROCSTDERR(KviCommand *c,KviStr &buffer);
	bool parseIdn_PROCSTDOUT(KviCommand *c,KviStr &buffer);
	bool parseIdn_PROCMAGIC(KviCommand *c,KviStr &buffer);
	bool parseIdn_PROCWINDOW(KviCommand *c,KviStr &buffer);
	bool parseIdn_PROCEXITCODE(KviCommand *c,KviStr &buffer);
	bool parseIdn_CONNTIME(KviCommand *c,KviStr &buffer);
	bool parseIdn_CONNTIMES(KviCommand *c,KviStr &buffer);
	bool parseIdn_ACTIVEWINDOW(KviCommand *cmd,KviStr &buffer);
	bool parseIdn_ISREMOTEEXEC(KviCommand *cmd,KviStr &buffer);
	bool parseIdn_EXECFILENAME(KviCommand *cmd,KviStr &buffer);
	bool parseIdn_GETRETURN(KviCommand *cmd,KviStr &buffer);
	bool parseIdn_SIGNALSENDER(KviCommand *cmd,KviStr &buffer);
	bool parseIdn_MDISIZE(KviCommand *cmd,KviStr &buffer);


	bool parseIdn_WHOISNICK(KviCommand * c,KviStr &buffer);
	bool parseIdn_WHOISUSER(KviCommand * c,KviStr &buffer);
	bool parseIdn_WHOISHOST(KviCommand * c,KviStr &buffer);
	bool parseIdn_WHOISREAL(KviCommand * c,KviStr &buffer);
	bool parseIdn_WHOISSERVER(KviCommand * c,KviStr &buffer);
	bool parseIdn_WHOISIRCOP(KviCommand * c,KviStr &buffer);
	bool parseIdn_WHOISIDLE(KviCommand * c,KviStr &buffer);
	bool parseIdn_WHOISSTATUS(KviCommand * c,KviStr &buffer);
	bool parseIdn_WHOISCHANNELS(KviCommand * c,KviStr &buffer);
	bool parseIdn_WHOISMAGIC(KviCommand * c,KviStr &buffer);
	bool parseIdn_WHOISSUCCESS(KviCommand *c,KviStr &buffer);
	bool parseIdn_TRYRESULT(KviCommand *c,KviStr &buffer);
	bool parseIdn_TIMES(KviCommand *c,KviStr &buffer);
	bool parseIdn_UPTIME(KviCommand *c,KviStr &buffer);
	bool parseIdn_CONNSTARTTIME(KviCommand *c,KviStr &buffer);
	bool parseIdn_THIS(KviCommand *c,KviStr &buffer);
	bool parseIdn_ROOT(KviCommand *c,KviStr &buffer);

	// kvi_functions.cpp
	bool parseFnc_HOSTNAME(KviCommand *c,KviStr &buffer);
	bool parseFnc_USERNAME(KviCommand *c,KviStr &buffer);
	bool parseFnc_ISWELLKNOWN(KviCommand *c,KviStr &buffer);
	bool parseFnc_STRLEN(KviCommand *c,KviStr &buffer);
	bool parseFnc_STRCAT(KviCommand *c,KviStr &buffer);
	bool parseFnc_CALC(KviCommand *c,KviStr &buffer);
	bool parseFnc_ISNUMBER(KviCommand *c,KviStr &buffer);
	bool parseFnc_GETENV(KviCommand *c,KviStr &buffer);
	bool parseFnc_ISON(KviCommand *c,KviStr &buffer);
	bool parseFnc_ISOWNER(KviCommand *c,KviStr &buffer);
	bool parseFnc_ISOP(KviCommand *c,KviStr &buffer);
	bool parseFnc_ISHALFOP(KviCommand *c,KviStr &buffer);
	bool parseFnc_ISVOICE(KviCommand *c,KviStr &buffer);
	bool parseFnc_ISUSEROP(KviCommand *c,KviStr &buffer);
	bool parseFnc_ITEMCOUNT(KviCommand *c,KviStr &buffer);
	bool parseFnc_SELECTED(KviCommand *c,KviStr &buffer);
	bool parseFnc_SELECTEDMASKS(KviCommand *c,KviStr &buffer);
	bool parseFnc_SELECTEDHOSTS(KviCommand *c,KviStr &buffer);
	bool parseFnc_SELECTEDUSERNAMES(KviCommand *c,KviStr &buffer);
	bool parseFnc_ICON(KviCommand *c,KviStr &buffer);
	bool parseFnc_DEFLOGFILE(KviCommand *c,KviStr &buffer);
	bool parseFnc_ISME(KviCommand *c,KviStr &buffer);
	bool parseFnc_ISREG(KviCommand *c,KviStr &buffer);
	bool parseFnc_RAND(KviCommand *c,KviStr &buffer);
	bool parseFnc_UNAME(KviCommand *c,KviStr &buffer);
	bool parseFnc_CLASSDEFINED(KviCommand *c,KviStr &buffer);
	bool parseFnc_CHANMODE(KviCommand *c,KviStr &buffer);
	bool parseFnc_CHANLIMIT(KviCommand *c,KviStr &buffer);
	bool parseFnc_CHANKEY(KviCommand *c,KviStr &buffer);

	bool parseFnc_NEW(KviCommand *c,KviStr &buffer);
//	bool parseFnc_OBJ_GETFIELD(KviCommand *c,KviStr &buffer);
//	bool parseFnc_OBJ_CLASS(KviCommand *c,KviStr &buffer);
//	bool parseFnc_OBJ_NAME(KviCommand *c,KviStr &buffer);
	bool parseFnc_HASEVENTHANDLER(KviCommand *c,KviStr &buffer);

	bool parseFnc_HEXTOSTR(KviCommand *c,KviStr &buffer);
	bool parseFnc_STRTOHEX(KviCommand *c,KviStr &buffer);

	bool parseFnc_STRLEFT(KviCommand *c,KviStr &buffer);
	bool parseFnc_STRRIGHT(KviCommand *c,KviStr &buffer);
	bool parseFnc_STRCUTLEFT(KviCommand *c,KviStr &buffer);
	bool parseFnc_STRCUTRIGHT(KviCommand *c,KviStr &buffer);
	bool parseFnc_STRMID(KviCommand *c,KviStr &buffer);
	bool parseFnc_STRFIND(KviCommand *c,KviStr &buffer);
	bool parseFnc_STRFINDCS(KviCommand *c,KviStr &buffer);
	bool parseFnc_STRREVFIND(KviCommand *c,KviStr &buffer);
	bool parseFnc_STRREVFINDCS(KviCommand *c,KviStr &buffer);
	bool parseFnc_STRLEFTTOFIRST(KviCommand *c,KviStr &buffer);
	bool parseFnc_STRLEFTTOLAST(KviCommand *c,KviStr &buffer);
	bool parseFnc_STRRIGHTFROMFIRST(KviCommand *c,KviStr &buffer);
	bool parseFnc_STRRIGHTFROMLAST(KviCommand *c,KviStr &buffer);
	bool parseFnc_STRLEFTTOFIRSTCS(KviCommand *c,KviStr &buffer);
	bool parseFnc_STRLEFTTOLASTCS(KviCommand *c,KviStr &buffer);
	bool parseFnc_STRRIGHTFROMFIRSTCS(KviCommand *c,KviStr &buffer);
	bool parseFnc_STRRIGHTFROMLASTCS(KviCommand *c,KviStr &buffer);
	bool parseFnc_STRMATCH(KviCommand *c,KviStr &buffer);
	bool parseFnc_STRMATCHCS(KviCommand *c,KviStr &buffer);
	bool parseFnc_NUMTIMETOSTRING(KviCommand *c,KviStr &buffer);
	bool parseFnc_DURATIONTOSTRING(KviCommand *c,KviStr &buffer);

	bool parseFnc_OPTION(KviCommand *c,KviStr &buffer);
	bool parseFnc_ISWINDOW(KviCommand *c,KviStr &buffer);
	bool parseFnc_RANGE(KviCommand *c,KviStr &buffer);
	bool parseFnc_UPCASE(KviCommand *c,KviStr &buffer);
	bool parseFnc_LOWCASE(KviCommand *c,KviStr &buffer);
	bool parseFnc_STRREPLACE(KviCommand *c,KviStr &buffer);
	bool parseFnc_STRREPLACECS(KviCommand *c,KviStr &buffer);
	bool parseFnc_ISDOCKED(KviCommand *c,KviStr &buffer);
	bool parseFnc_MASK(KviCommand *c,KviStr &buffer);
	bool parseFnc_ISKNOWN(KviCommand *c,KviStr &buffer);
	bool parseFnc_CHAR(KviCommand *c,KviStr &buffer);
	bool parseFnc_ASCII(KviCommand *c,KviStr &buffer);
	bool parseFnc_ISVALIDIP(KviCommand *c,KviStr &buffer);
	bool parseFnc_INETATON(KviCommand *c,KviStr &buffer);
	bool parseFnc_INETNTOA(KviCommand *c,KviStr &buffer);
	bool parseFnc_COMMANDLINE(KviCommand *c,KviStr &buffer);
	bool parseFnc_ALLONCHAN(KviCommand *c,KviStr &buffer);
	bool parseFnc_OPONCHAN(KviCommand *c,KviStr &buffer);
	bool parseFnc_VOICEONCHAN(KviCommand *c,KviStr &buffer);
	bool parseFnc_NOPONCHAN(KviCommand *c,KviStr &buffer);
	bool parseFnc_TOPIC(KviCommand *c,KviStr &buffer);
	bool parseFnc_READFILE(KviCommand *c,KviStr &buffer);
	bool parseFnc_FILEEXISTS(KviCommand *c,KviStr &buffer);
	bool parseFnc_DIREXISTS(KviCommand *c,KviStr &buffer);
	bool parseFnc_FILESIZE(KviCommand *c,KviStr &buffer);
	bool parseFnc_DICTLIST(KviCommand *c,KviStr &buffer);
	bool parseFnc_DICTCOUNT(KviCommand *c,KviStr &buffer);
	bool parseFnc_GETFLAGS(KviCommand *c,KviStr &buffer);
	bool parseFnc_GETPASS(KviCommand *c,KviStr &buffer);
	bool parseFnc_GETCOMMENT(KviCommand *c,KviStr &buffer);
	bool parseFnc_GETFLAGSEXACT(KviCommand *c,KviStr &buffer);
	bool parseFnc_CONFIG(KviCommand *c,KviStr &buffer);
	bool parseFnc_PLUGINLOADED(KviCommand *c,KviStr &buffer);
	bool parseFnc_ISTIMER(KviCommand *c,KviStr &buffer);
	bool parseFnc_BANLIST(KviCommand *c,KviStr &buffer);
	bool parseFnc_BANEXCEPTIONLIST(KviCommand *c,KviStr &buffer);
	bool parseFnc_INVITEEXCEPTIONLIST(KviCommand *c,KviStr &buffer);

	bool evaluateExpr(KviCommand *c,long * result);
	KviExprTree * evaluateExpression(KviCommand *c);
	KviExprTree * evaluateOperand(KviCommand *c);
	KviExprTree * evaluateSimpleOperand(KviCommand *c);
	KviExprTree * evaluateStringOperand(KviCommand *c);
	KviExprTree * evaluateExpression_RightOperand(KviExprTree * curTopOperator,KviCommand *c);
	KviExprTree * evaluateOperator(KviCommand *c);

	void addAsyncDialog(KviAsyncDialogCore *dlg);
	void removeAsyncDialog(KviAsyncDialogCore *dlg);

	void dumpChildObjects(KviWindow *pWnd,QObject * parent,const char *spacing,bool bWidgetsOnly);

	KviWindowTimer * findTimerById(int id);
	KviWindowTimer * findTimerByName(const char *name);
	bool removeTimer(const char * name);
	void addTimer(KviWindowTimer * t);
	virtual void timerEvent(QTimerEvent *e);
};

inline void KviUserParser::setLastSignalSender(const char * lss){ m_szLastSignalSender = lss; };


#define KVI_GLOBAL_VAR_CHAR '%'
#define KVI_COMMENT_BEGIN_CHAR '#'

//==================================================================================================
// NEW RATIONAL UPARSER , ACTUALLY UNUSED
//==================================================================================================

//
//typedef bool (KviUserParser::*commandNewParseProc) (KviCommand *);
//
//typedef struct KviNewCommandEntry
//{
//	const char *        cmdName;           // Command name        ex:"ALIAS"
//	int                 cmdLen;            // Command name length ex:5
//	commandNewParseProc cmdSkipProc;       // Procedure that skips the command
//	commandNewParseProc cmdPrepProc;       // Procedure that preprocesses the command and substitutes identifiers & variables
//	commandNewParseProc cmdExecProc;       // Procedure that executes the command
//};
//
//class KviNewCommand 
//{
//public:
//	KviNewCommand(const char *pBuf,KviWindow *pWnd);
//	~KviNewCommand();
//private:
//	const char       * m_ptr;             // pointer to the original command buffer (not owned by the command)
//	KviWindow        * m_wnd;             // window that this command is bound to
//	int                m_err;             // last error code
//	KviStr             m_buffer;          // peprocessed command buffer
//	KviVariableCache * m_pLocalVarCache;  // local variable cache
//	KviCommandParams * m_pParams;         // current parameters
//public:
//	bool hasParams();
//};
//
//inline bool KviNewCommand::hasParams(){ return m_pParams != 0; };
//
//KviNewCommand::KviNewCommand(const char *pBuf,KviWindow *pWnd)
//{
//	m_ptr            = pBuf;
//	m_wnd            = pWnd;
//	m_err            = KVI_ERROR_NoError;
//	m_pLocalVarCache = new KviVariableCache();
//	m_pParams        = 0;
//	//m_buffer is ""
//}
//
//KviNewCommand::~KviNewCommand()
//{
//	if(m_pParams)delete m_pParams;
//	delete m_pLocalVarCache;
//}
//
//void KviNewCommand::setError(int errCode,
//
//bool KviNewUserParser::parseCommand(const char *ptr,KviWindow *pWnd)
//{
//	KviNewCommand cmd(ptr,pWnd);
//
//	if(!preprocessCommandBuffer(&cmd)){
//		if(cmd.hasError()){
//			printPreprocessingError(&cmd,ptr);
//			return false;
//		}
//	}
//
//	if(!execCommandBuffer(&cmd)){
//		// stop the execution
//		// if there is no error then we simply halt
//		// if there is an error so spit it out
//		if(cmd.hasError()){
//			printError(&cmd,ptr);
//			return false;
//		}
//	}
//
//	return true;
//}
//
//// there will be a standard command skip proc
//// there will be a standard command extract proc

//class KviNewUserParser : public QObject
//{
//	Q_OBJECT
//
//};

//
// <command_buffer> ::= <command>[<command_list>] | { [command_list] } [command_list]
//
// <command> ::= [<whitespace>][<command_body>]<terminator>
//
// <whitespace> ::= <LF|SPACE|TAB|ESCAPED_SPACE|ESCAPED_LF|ESCAPED_TAB>[whitespace]
//
// <terminator> ::= <LF>|;|<NULL>
//
// <command_body> ::= %<variable_name>[space]<operator>[space]<free_text>
// <command_body> ::= <literal_async>[parameters](<
// <command_body> ::= <alias_call>[space]<parameter_list>
//
//
//
/*
class KviUserParser : public QObject
{
	friend class KviFrame;
	Q_OBJECT
protected:
	KviUserParser(KviFrame *pFrm);
	~KviUserParser();
private:
	KviFrame                * m_pFrm;
	KviIrcSocket            * m_pSocket;
	KviConsole              * m_pConsole;
protected:
	void setup(KviIrcSocket *pSock,KviConsole *pConsole); //KviFrame calls this
	bool parseCommand(const char *ptr,KviWindow *pWnd);
public:
	void parseUserCommand(KviStr &str,KviWindow *pWnd);   //KviInput calls this
};
*/
/*
class KviNewUserParser;

class KviNewCommand
{
	friend class KviNewUserParser;
public:
	KviNewCommand(const char *pBuffer,KviWindow * pWnd);
	~KviNewCommand();
protected:
	const char * m_ptr;      // buffer position
	const char * m_wnd;      // the window that this command is bound to
	int          m_err;      // last error
protected:
	bool hasError();
};

class KviNewUserParser : public QObject
{
	friend class KviFrame;
	Q_OBJECT
protected:
	KviNewUserParser(KviFrame * pFrm);
	KviNewUserParser();
private:
	KviFrame     * m_pFrm;
	KviConsole   * m_pSocket;
	KviIrcSocket * m_pConsole;
public:
	void setup(KviIrcSocket *pSock,KviConsole *pConsole); //KviFrame calls this
	bool parseCommand(const char *ptr,KviWindow * pWnd);
private:
	bool execCommandBuffer(KviNewCommand * c);
};

*/


#endif //!_KVI_UPARSER_H_INCLUDED_
