#ifndef _KVI_USERTOOLBAREDITOR_H_INCLUDED_
#define _KVI_USERTOOLBAREDITOR_H_INCLUDED_

// =============================================================================
//
//      --- kvi_usertoolbareditor.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//   Copyright (C) 1999-2000 Till Busch (buti@geocities.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qwidget.h>

#include "kvi_string.h"

class QToolButton;

class KviLineEdit;
class KviListView;
class KviPopupMenu;
class KviScriptEditor;
class KviToolBarListViewItem;
class KviUserPopupMenu;
class KviUserToolBar;

class KviUserToolBarEditor : public QWidget
{
	Q_OBJECT
public:
	KviUserToolBarEditor(QWidget *parent, const char *name = 0);
	~KviUserToolBarEditor();

	void commit();
	bool eventFilter(QObject *, QEvent *);
protected:
	KviUserToolBar         *m_pToolBar;
	KviUserToolBar         *m_pEditedToolBar;
	KviListView            *m_pToolBarView;
	KviLineEdit            *m_pToolBarIconEditor;
	KviLineEdit            *m_pToolBarNameEditor;
	KviLineEdit            *m_pToolBarStatusBarEditor;
	KviPopupMenu           *m_pToolBarPopup;
	KviScriptEditor        *m_pToolBarEditor;
	KviToolBarListViewItem *m_pEditedToolButton;
	KviPopupMenu           *m_pIconPopup;
	KviPushButton          *m_pBrowseButton;
	QToolButton            *m_pIconButton;
	KviStr                  m_szClipboardItemBuffer;
	KviStr                  m_szClipboardItemIcon;
	KviStr                  m_szClipboardItemName;
	KviStr                  m_szClipboardItemSbar;

	void startEditToolBar(KviUserToolBar *);
	void appendToolButton(KviUserToolBar *);
	void appendToolBarMenu(KviToolBarListViewItem *, KviUserPopupMenu *);
	void disableToolBarEditors();
	void saveToolButton(KviToolBarListViewItem *);
	void saveToolBar(KviUserToolBar *);
	void updateToolBar(KviUserToolBar *, KviToolBarListViewItem *parent);
	void saveToolBarMenu(KviUserPopupMenu *, KviToolBarListViewItem *parent);
protected slots:
	void iconPopupActivated(int id);
	void toolButtonSelected(KviListViewItem *);
	void toolBarViewRightButtonPressed(KviListViewItem *, const QPoint &, int);
	void removeEditedToolButton();
	void clearToolBar();
	void addToolBarMenu();
	void addToolBarMenuAbove();
	void addEmptyToolButton();           // Below
	void addToolBarSeparatorItem();      // Below
	void addEmptyToolButtonAbove();
	void addToolBarSeparatorItemAbove();
	void copyToolButton();
	void pasteToolButtonBelow();
	void pasteToolButtonAbove();
	bool selectToolButtonById(KviToolBarListViewItem *parent, int id);
	void iconLostFocus();
	void nameChanged(const QString &);
	void pickIconFilename();
	void popupIconMenu();
private:
	QString m_iconString;
};

#endif // _KVI_USERTOOLBAREDITOR_H_INCLUDED_
