// =============================================================================
//
//      --- kvi_variableseditor.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//   Copyright (C) 1999-2000 Till Busch (buti@geocities.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviVariablesEditor"

#include <qlayout.h>

#include "kvi_app.h"
#include "kvi_console.h"
#include "kvi_frame.h"
#include "kvi_script_editor.h"
#include "kvi_script_editorwidget.h"
#include "kvi_string.h"
#include "kvi_userparser.h"
#include "kvi_variablecache.h"
#include "kvi_variableseditor.h"

// TODO: Totally missing quick help!

// Declared in kvi_app.cpp:
extern KviVariableCache *g_pVarCache;

/*
	@quickhelp: KviVariablesEditor
	@widget: Variables tab
		This tab displays an automatically generated script buffer.<br>
		It contains all the currently set global variables.<br>
		You can edit it to set the variable contents to match your test needs.<br>
		This script buffer will only be executed if you click on "OK" while in the dialog.<br>
		Please note that if you want to unset a variable, you have to
		remove the part after the '=' sign, but NOT remove the variable name.<br>
*/

/**
 *
 * VARIABLES EDITOR
 *
 * This widget allows editing of the global variables
 *
 */
KviVariablesEditor::KviVariablesEditor(QWidget *parent, const char *name)
	: QWidget(parent, name)
{
	QGridLayout *g = new QGridLayout(this, 1, 1, 4, 2);

	m_pVariablesEditor = new KviScriptEditor(this);
	g->addWidget(m_pVariablesEditor, 0, 0);
	fillVariablesEditor();
	m_bVariablesChanged = false;
	connect(m_pVariablesEditor->editor(), SIGNAL(textChanged()), this, SLOT(variablesTextChanged()));
}

KviVariablesEditor::~KviVariablesEditor()
{
	// Nothing here
}

void KviVariablesEditor::fillVariablesEditor()
{
	KviStr tmp;
	for( KviVariable *v = g_pVarCache->m_pVarList->first(); v; v = g_pVarCache->m_pVarList->next() ) {
		tmp.append('%');
		tmp.append(v->szName);
		tmp.append(" = ");
		tmp.append(v->szValue);
		tmp.append('\n');
	}
	for( KviDictionary *d = g_pVarCache->m_pDictList->first(); d; d = g_pVarCache->m_pDictList->next() ) {
		for( KviVariable *var = d->m_pVarCache->m_pVarList->first(); var; var = d->m_pVarCache->m_pVarList->next() ) {
			tmp.append('%');
			tmp.append(d->szName);
			tmp.append('[');
			tmp.append(var->szName);
			tmp.append(']');
			tmp.append(" = ");
			tmp.append(var->szValue);
			tmp.append('\n');
		}
	}
	m_pVariablesEditor->setText(tmp.ptr());
}

void KviVariablesEditor::variablesTextChanged()
{
	m_bVariablesChanged = true;
}

void KviVariablesEditor::commit()
{
	if( m_bVariablesChanged ) {
		KviStr tmp = m_pVariablesEditor->text();
		// Any frame can parse this
		KviFrame *aFrame = g_pApp->m_pFrameList->first();
		if( aFrame )
			aFrame->m_pUserParser->parseCommand(tmp.ptr(), aFrame->m_pConsole);
	}
}

#include "m_kvi_variableseditor.moc"
