//
//   File : kvi_up_skip.cpp
//   Creation date : Mon Jul 03 2000 12:22:01 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#define __KVIRC__
#define _KVI_DEBUG_CHECK_RANGE_

#include "kvi_debug.h"
#include "kvi_uparser.h"
#include "kvi_command.h"
#include "kvi_error.h"
#include "kvi_locale.h"

void KviUserParser::skipComment(KviCommand *c)
{
/*
	__range_valid(*(c->m_ptr) == '#');

	++(c->m_ptr);
	while(*(c->m_ptr) && (*(c->m_ptr) != '\n'))++(c->m_ptr);
	if(*(c->m_ptr) == '\n')++(c->m_ptr);
*/
}

bool KviUserParser::skipNormalCommand(KviCommand *c)
{
/*
	ENTER_STACK_FRAME(c,"skipNormalCommand");
	for(;;){
		// Now skip all the non interesting chars
		while(*(c->m_ptr) && (*(c->m_ptr) != '\\') && (*(c->m_ptr) != '\n') &&
				(*(c->m_ptr) != '%') && (*(c->m_ptr) != ';') &&
				(*(c->m_ptr) != '$'))++(c->m_ptr);
		// Interesting char
		switch(*(c->m_ptr)){
			case '\0': return c->leaveStackFrame(); break;
			case '\n': // end of command
			case ';' : ++(c->m_ptr); return c->leaveStackFrame(); break;
			case '$' : if(!skipIdentifier(c))return false; break;
			case '%' : if(!skipVariable(c))return false; break;
			case '\\': //escape character: append the last block to the processed buffer...
				++(c->m_ptr);
				switch(*(c->m_ptr)){
					case '\0': return c->leaveStackFrame(); break; //escaped nothing...
					default: ++(c->m_ptr); break;
				}
			break;
		}
	}
	return c->leaveStackFrame();
*/
	return true;
}

bool KviUserParser::skipCommand(KviCommand *c)
{
	/*
	ENTER_STACK_FRAME(c,"skipCommand");
	if(*(c->m_ptr) == '{'){
		if(!skipCommandBlock(c))return false;
		// Here c->m_ptr points to the char immediately after the closing brace
	} else {
		if(!skipSingleCommand(c))return false;
		// Here c->m_ptr points to the char immediately after the separator...
	}
	return c->leaveStackFrame();
	*/
	return true;
}

bool KviUserParser::skipCommandBlock(KviCommand *c)
{
	/*
	ENTER_STACK_FRAME(c,"skipCommandBlock");

	__range_valid(*(c->m_ptr)=='{');
	++(c->m_ptr);
	c->skipWhiteSpace();
	while(*(c->m_ptr)){
		switch(*(c->m_ptr)){
			case '}': ++(c->m_ptr);            return c->leaveStackFrame();  break;
			case '{': if(!skipCommandBlock(c)) return false;              break;
			default : if(!skipSingleCommand(c))return false;              break;
		}
		c->skipWhiteSpace();
	}
	// We should newer reach this point
	return c->error(KviError_missingClosingBrace);
	*/
	return false;
}

bool KviUserParser::skipSingleCommand(KviCommand *c)
{
	/*
	ENTER_STACK_FRAME(c,"skipSingleCommand");

	if(*(c->m_ptr) == '#')
	{
		skipComment(c);
		return c->leaveStackFrame();
	}

	if(*(c->m_ptr) == '@')
	{
		++(c->m_ptr);
		if((*(c->m_ptr) != '%') && (*(c->m_ptr) != '$'))return c->error(KviError_variableOrIdentifierExpected);

		return (skipLValueCommand(c) ? c->leaveStackFrame() : false);
	}

	if((*(c->m_ptr) == '%') || (*(c->m_ptr) == '$'))
	{
		return (skipLValueCommand(c) ? c->leaveStackFrame() : false);
	}

	if(*(c->m_ptr) == ';'){
		++(c->m_ptr);
		return c->leaveStackFrame();
	}


	char * end = c->m_ptr;
	char * begin = end;
	end++;
	while(isalnum(*end) || (*end == '_'))end++;

	// Check for module commands!
	if(*end == '.')
	{
#ifdef COMPILE_PERL_SUPPORT
		if(*begin == 'p')
		{
			if(kvi_strEqualCIN("perl.begin",begin,10))
			{
				// perl.begin has a really special syntax!
				c->m_ptr = begin + 10;
				skipSwitches(c);
				if(*(c->m_ptr) == '(')
					if(!skipExpressionBody(c))return false;
				c->skipWhiteSpace();
				if(*(c->m_ptr) == ';')(c->m_ptr)++;

				while(*(c->m_ptr))
				{
					if(*(c->m_ptr)=='p')
					{
						if(kvi_strEqualCIN("perl.end",c->m_ptr,8))
						{
							(c->m_ptr) += 8;
							if(*(c->m_ptr))
							{
								if((*(c->m_ptr) == ' ') || (*(c->m_ptr) == '\n') ||
									(*(c->m_ptr) == ';') || (*(c->m_ptr) == '\t') || (*(c->m_ptr) == '\r'))
									break;
							} else {
								break;
							}
						}
					}
					(c->m_ptr)++;
				}
				return skipNormalCommand(c);
			}
		}
#endif
		end++;
		c->m_ptr = end;
		while(isalnum(*(c->m_ptr)) || (*(c->m_ptr) == '_'))++(c->m_ptr);
		skipSwitches(c);
		if(*(c->m_ptr) == '(')
		{
			return skipCallbackCommand(c) ? c->leaveStackFrame() : false;
		} else {
			return skipNormalCommand(c) ? c->leaveStackFrame() : false;
		}
		c->m_ptr = end;
		return skipNormalCommand(c) ? c->leaveStackFrame() : false;
	}

	// not a module command
	KviStr tmp(c->m_ptr,end);
	tmp.toUpper();

	// normal command ?
	KviCommandParseProc * proc = m_pCommandSkipDict->find(tmp.ptr());

	if(proc)
	{
		c->m_ptr = end;
		if(!skipSwitches(c))return false;
		if(! ((this->*(proc->proc))(c)) )return false;
//		return c->leaveStackFrame();
	} else {
		// There is no skip proc... this is either an alias ,or an unknown command
		if(!skipNormalCommand(c))return false;
	}

//	return c->error(KviError_unknownCommand);
	return c->leaveStackFrame();
	*/
	return false;
}

bool KviUserParser::skipLValueCommand(KviCommand *c,bool bStopAtParenthesis)
{
	/*
	ENTER_STACK_FRAME(c,"skipLValueCommand");
	__range_valid((*(c->m_ptr)=='%') || (*(c->m_ptr) == '$'));

	do {
		if(*(c->m_ptr) == '%')
		{
			if(!skipVariable(c))return false;
		} else if(*(c->m_ptr) == '$')
		{
			if(!skipIdentifier(c))return false;
		} else return c->error(KviError_variableOrIdentifierExpected);
	} while((*(c->m_ptr) == '%') || (*(c->m_ptr) == '$'));

	bool bInString = false;

	for(;;)
	{
		// Now skip all the non interesting chars
		while(*(c->m_ptr) && (*(c->m_ptr) != '\\') && (*(c->m_ptr) != '\n') && (*(c->m_ptr) != '%') &&
				(*(c->m_ptr) != ';') && (*(c->m_ptr) != '$') && (*(c->m_ptr) != ')') && (*(c->m_ptr) != '"'))
					++(c->m_ptr);
		// Interesting char
		switch(*(c->m_ptr)){
			case '\0': return c->leaveStackFrame(); break;
			case '\n': // end of command
			case ';' : ++(c->m_ptr); return c->leaveStackFrame(); break;
			case '$' : if(!skipIdentifier(c))return false; break;
			case '%' : if(!skipVariable(c))return false; break;
			case ')' : if(bStopAtParenthesis && !bInString)return c->leaveStackFrame(); ++(c->m_ptr); break;
			case '"' : bInString = !bInString; ++(c->m_ptr); break;
			case '\\': //escape character: append the last block to the processed buffer...
				++(c->m_ptr);
				switch(*(c->m_ptr))
				{
					case '\0': return c->leaveStackFrame(); break; //escaped nothing...
					default: ++(c->m_ptr); break;
				}
			break;
		}
	}
	// never here

	return c->error(KviError_internalError);
	*/
	return false;
}

bool KviUserParser::skipSwitches(KviCommand *c)
{
	/*
	ENTER_STACK_FRAME(c,"skipSwitches");
	// This one 
	c->skipSpace();
	while(*(c->m_ptr) == '-'){
		if(!skipSingleSwitch(c))return false;
		c->skipSpace();
	}
	return c->leaveStackFrame();
	*/
	return false;
}

bool KviUserParser::skipSingleSwitch(KviCommand *c)
{
	/*
	ENTER_STACK_FRAME(c,"skipSingleSwitch");

	__range_valid(*(c->m_ptr) == '-');

	++(c->m_ptr); // skip the - char

	// now a LETTER is required
	if( (!(*(c->m_ptr))) || (!isalpha(*(c->m_ptr))) )
	{
		return c->error(KviError_switchDashWithoutSwitchLetter);
	}

	++(c->m_ptr); // skip the switch letter

	c->skipSpace();

	// now if we have a '=' , a token follows the switch

	if(*(c->m_ptr) == '='){
		// a token follows the switch
		++(c->m_ptr);
		c->skipSpace();
		bool bInString = false;

		for(;;){
			// Now skip all the non interesting chars
			while(*(c->m_ptr) && (*(c->m_ptr)!='\\') && (*(c->m_ptr)!='\n') &&
					(*(c->m_ptr)!=' ') && (*(c->m_ptr)!='\t') && (*(c->m_ptr)!=';') &&
					(*(c->m_ptr)!='$') && (*(c->m_ptr)!='\"') &&
					(*(c->m_ptr)!='%'))++(c->m_ptr);
			// Interesting char
			switch(*(c->m_ptr)){
				case ' ' :
				case '\t':
				case ';' :
					if(!bInString)return c->leaveStackFrame();
					else while((*(c->m_ptr) == ' ')||(*(c->m_ptr) == '\t')||
								(*(c->m_ptr) == ';'))c->m_ptr++; //In string...must skip it
				break;
				case '\n': // end of command
				case '\0': // end of command buffer...append the last block to the buffer and return
					if(bInString)return c->error(KviError_unexpectedEndInString);
					// else it is the end of the command
					return c->leaveStackFrame();
				break;
				case '\"': // beginning or end of a string
					bInString = !bInString;
					++(c->m_ptr);
				break;
				case '%': //variable: append the last block to the buffer and process the var
					if(!skipVariable(c))return false;
				break;
				case '$': //system identifier: append the last block to the buffer and process the ident
					if(!skipIdentifier(c))return false;
				break;
				case '\\': //escape character: append the last block to the processed buffer...
					++(c->m_ptr);
					switch(*(c->m_ptr)){
						case '\0':
							if(bInString)return c->error(KviError_unexpectedEndInString);
							return c->leaveStackFrame();
						break;
						case '\n':  //escaped newline
							++(c->m_ptr); //skip it
							c->skipSpace();       //skip leading spaces
						break;
						default: // Must be copied to the buffer without modification
							++(c->m_ptr);
						break;
					}
				break;
			}
		}
	}

	return c->leaveStackFrame();
	*/
	return false;
}


bool KviUserParser::skipVariable(KviCommand *c)
{
	/*
	ENTER_STACK_FRAME(c,"skipVariable");

	__range_valid(*c->m_ptr == '%');
	++(c->m_ptr);

	if(*(c->m_ptr) == ':')++(c->m_ptr); // valid (special scope)

	while(*(c->m_ptr) && (isalnum(*(c->m_ptr))||(*(c->m_ptr) == '.')||(*(c->m_ptr) == '_')))++(c->m_ptr);

	if(*(c->m_ptr) == '[')
	{
		c->m_ptr++;
		if(!skipVariableIndex(c))return false;
	} else if(*(c->m_ptr) == '{')
	{
		c->m_ptr++;
		if(!skipVariableKey(c))return false;
	}

	if((*(c->m_ptr) == '#') || (*(c->m_ptr) == '@'))++(c->m_ptr);

	if(*(c->m_ptr) == '-')
	{
		// scope object ?
		char * aux = c->m_ptr;
		++aux;
		if(*aux == '>')
		{
			// yup...it looks as!
			++aux;
			// ok..we expect a variable or function call now
			if((*aux == '%') || (*aux == '$'))
			{
				c->m_ptr = aux;
				// yup...object scope operator
			} // else just a "->"....? :)
		}
	}

	return c->leaveStackFrame();
	*/
	return false;
}




bool KviUserParser::skipVariableKey(KviCommand *c)
{
	/*
	ENTER_STACK_FRAME(c,"skipVariableKey");

	c->skipSpace();

	bool inString      = false;

	for(;;){
		// First skip all the non interesting chars
		while(	*(c->m_ptr)         && (*(c->m_ptr)!='%') &&
				(*(c->m_ptr)!='\n') && (*(c->m_ptr)!='}')  && (*(c->m_ptr)!='$')  && 
				(*(c->m_ptr)!=' ')  && (*(c->m_ptr)!='"')  && (*(c->m_ptr)!='\\') &&
				(*(c->m_ptr)!='\t'))(c->m_ptr)++;
		// Interesting char
		switch(*(c->m_ptr)){
			case '\0':
			case '\n': // End of the string ('\n' is not escaped)...fail here
				if(inString)return c->error(KviError_unexpectedEndInString);
				else return c->error(KviError_unexpectedEndInDictionaryKey);
			break;
			case ' ': // Spaces...need to reduce it to one...
			case '\t':
				if(!inString){
					// skip the other spaces including escaped ones
					c->skipSpace();
				} else while((*(c->m_ptr) == ' ')||(*(c->m_ptr) == '\t'))(c->m_ptr)++;
			break;
			case '"': // Not escaped '"'...enter or exit the string (skip the '"')
				++(c->m_ptr);
				inString = !inString;
			break;
			case '}': // If not in string , exit
				if(!inString){
					++(c->m_ptr);
					return c->leaveStackFrame();
				}
				++(c->m_ptr);
			break;
			case '%': //variable: append the last block to the buffer and process the var
				if(!skipVariable(c))return false;
			break;
			case '$': //system identifier: append the last block to the buffer and process the ident
				if(!skipIdentifier(c))return false;
			break;
			case '\\': //escape character: append the last block to the processed buffer...
				++(c->m_ptr);
				switch(*(c->m_ptr)){
					case '\0':
						if(inString)return c->error(KviError_unexpectedEndInString);
						else return c->error(KviError_unexpectedEndInDictionaryKey);
					break;
					case '\n':  //escaped newline
						++(c->m_ptr); //skip it
						c->skipSpace();       //skip leading spaces
					break;
					default: // Must be copied to the buffer without modification
						++(c->m_ptr);
					break;
				}
			break;
		}
	}
	// Newer arrive here...
	return c->error(KviError_internalError);
	*/
	return false;
}


bool KviUserParser::skipVariableIndex(KviCommand *c)
{
	/*
	ENTER_STACK_FRAME(c,"skipVariableIndex");

	c->skipSpace();

	for(;;){
		// First skip all the non interesting chars
		while(	*(c->m_ptr)         && (*(c->m_ptr)!='%') &&
				(*(c->m_ptr)!='\n') && (*(c->m_ptr)!=']')  && (*(c->m_ptr)!='$')  && 
				(*(c->m_ptr)!=' ')  && (*(c->m_ptr)!='\\') &&
				(*(c->m_ptr)!='\t'))(c->m_ptr)++;
		// Interesting char
		switch(*(c->m_ptr)){
			case '\0':
			case '\n': // End of the string ('\n' is not escaped)...fail here
				return c->error(KviError_unexpectedEndInArrayIndex);
			break;
			case ' ': // Spaces...need to reduce it to one...
			case '\t':
				c->skipSpace();
			break;
			case ']': // If not in string , exit
				++(c->m_ptr);
				return c->leaveStackFrame();
			break;
			case '%': //variable: append the last block to the buffer and process the var
				if(!skipVariable(c))return false;
			break;
			case '$': //system identifier: append the last block to the buffer and process the ident
				if(!skipIdentifier(c))return false;
			break;
			case '\\': //escape character: append the last block to the processed buffer...
				++(c->m_ptr);
				switch(*(c->m_ptr)){
					case '\0':
						return c->error(KviError_unexpectedEndInArrayIndex);
					break;
					case '\n':  //escaped newline
						++(c->m_ptr); //skip it
						c->skipSpace();       //skip leading spaces
					break;
					default: // Must be copied to the buffer without modification
						++(c->m_ptr);
					break;
				}
			break;
		}
	}
	// Newer arrive here...
	return c->error(KviError_internalError);
	*/
	return false;
}

bool KviUserParser::skipForCondition(KviCommand *c)
{
	/*
	ENTER_STACK_FRAME(c,"skipForCondition");
	// strips an expression body that is in the for(*;<condition>;*)form
	bool inString =false;

	c->skipSpace();

	for(;;){
		// Now skip all the non interesting chars
		while(*(c->m_ptr) && (*(c->m_ptr) != '\\') && (*(c->m_ptr) != '%') &&
			 (*(c->m_ptr) != '\n') && (*(c->m_ptr) != '$') &&
			 (*(c->m_ptr) != '"') && (*(c->m_ptr) != ';'))(c->m_ptr)++;
		// Interesting char
		switch(*(c->m_ptr)){
			case '\0':
			case '\n': // error...
				return c->error(KviError_unexpectedEndInExpression);
			break;
			case '"': ++(c->m_ptr); inString = !inString; break;
			case ';' :
				if(!inString)return c->leaveStackFrame();
				++(c->m_ptr);
			break;
			case '%': if(!skipVariable(c))return false; break;
			case '$': if(!skipIdentifier(c))return false; break;
			case '\\': //escape character
				++(c->m_ptr);
				switch(*(c->m_ptr)){
					case '\0':
						c->error(KviError_unexpectedEndInExpression);
						return false;
					default: ++(c->m_ptr); break;
				}
			break;
		}
	}
	// newer here...
	return c->error(KviError_internalError);
	*/
	return false;
}

bool KviUserParser::skipExpressionBody(KviCommand *c)
{
	/*
	ENTER_STACK_FRAME(c,"skipExpressionBody");
	// skips a thing like '( <expression like for calc> )'
	// we never skip unterminated expressions (like in popup conditions)
	// we always skip it in a bigger buffer of data
	__range_valid(*(c->m_ptr) == '(');

	++(c->m_ptr);

	int parLevel = 0;
	bool inString =false;

	for(;;){
		// Now skip all the non interesting chars
		while(*(c->m_ptr) && (*(c->m_ptr) != '\\') && (*(c->m_ptr) != '%') &&
			 (*(c->m_ptr) != '\n') && (*(c->m_ptr) != '(') &&
			 (*(c->m_ptr) != ')') && (*(c->m_ptr) != '$') &&
			 (*(c->m_ptr) != '"'))(c->m_ptr)++;
		// Interesting char
		switch(*(c->m_ptr)){
			case '\0':
			case '\n': // error...
				return c->error(KviError_unexpectedEndInParenthesis);
			break;
			case '"': ++(c->m_ptr); inString = !inString; break;
			case '(': ++(c->m_ptr); if(!inString)++parLevel; break;
			case ')' :
				if(!inString)
				{
					if(parLevel == 0)
					{
						++(c->m_ptr);
						return c->leaveStackFrame();
					} else {
						++(c->m_ptr); --parLevel;
					}
				} else ++(c->m_ptr);
			break;
			case '%': if(!skipVariable(c))return false; break;
			case '$': if(!skipIdentifier(c))return false; break;
			case '\\': //escape character
				++(c->m_ptr);
				switch(*(c->m_ptr)){
					case '\0':
						c->error(KviError_unexpectedEndInParenthesis);
						return false;
					default: ++(c->m_ptr); break;
				}
			break;
		}
	}
	// newer here...
	return c->error(KviError_internalError);
	*/
	return false;
}

bool KviUserParser::skipIdentifier(KviCommand *c)
{
	/*
	ENTER_STACK_FRAME(c,"skipIdentifier");

	__range_valid(*c->m_ptr == '$');
	++(c->m_ptr);              // skip the $

	if((*(c->m_ptr) == '#') || (*(c->m_ptr) == '$'))c->m_ptr ++;
	else if(isdigit(*(c->m_ptr)))
	{
		while(isdigit(*(c->m_ptr)))c->m_ptr++;
		if(*(c->m_ptr) == '-')
		{
			++(c->m_ptr);
			if(isdigit(*(c->m_ptr)))
			{
				while(isdigit(*(c->m_ptr)))++(c->m_ptr);
			} else --(c->m_ptr); // object scope operator ?
		}
	} else {
		if(*(c->m_ptr) == '{'){
			if(!skipCommand(c))return false;
		} else if(*(c->m_ptr) == '('){
			//++(c->m_ptr);
			if(!skipExpressionBody(c))return false;
		} else {
			// Normal identifier
			while(*(c->m_ptr) && (isalnum(*(c->m_ptr))||
					(*(c->m_ptr) == '.')||(*(c->m_ptr) == '_'))||
					(*(c->m_ptr) == ':'))(c->m_ptr)++;

			if(*(c->m_ptr) == '(')
			{
				if(!skipExpressionBody(c))return false;
			}
		}
	}

	if(*(c->m_ptr) == '-')
	{
		// scope object ?
		char * aux = c->m_ptr;
		++aux;
		if(*aux == '>')
		{
			// yup...it looks as!
			++aux;
			// ok..we expect a variable or function call now
			if((*aux == '%') || (*aux == '$'))
			{
				c->m_ptr = aux;
				// yup...object scope operator
			} // else just a "->"....? :)
		}
	}

	return c->leaveStackFrame();
	*/
	return false;
}

bool KviUserParser::skipClass(KviCommand *c)
{
	/*
	ENTER_STACK_FRAME(c,"skipClass");
	c->skipWhiteSpace();
	if(*(c->m_ptr) != '(')return c->error(KviError_openParenthesisExpected);
	if(!skipExpressionBody(c))return false;
	c->skipWhiteSpace();
	if(*(c->m_ptr) != '{')return c->error(KviError_openBraceExpected);
	++(c->m_ptr);

	while(*(c->m_ptr) && (*(c->m_ptr) != '}'))
	{
		c->skipWhiteSpace();
		if(*(c->m_ptr) == '}')break;
		if(*(c->m_ptr) == '#')skipComment(c);
		else {
			if(isalpha(*(c->m_ptr)) || (*(c->m_ptr) == '_'))
			{
				while(*(c->m_ptr) && (isalnum(*(c->m_ptr)) || (*(c->m_ptr) == '_')))++(c->m_ptr);
				c->skipWhiteSpace();
				if(*(c->m_ptr) == '(')
				{
					// parameter reminder
					if(!skipExpressionBody(c))return false;
					c->skipWhiteSpace();
				}
				if(*(c->m_ptr) != '{')return c->error(KviError_openBraceExpected);
				if(!skipCommand(c))return false;
			} else return c->error(KviError_unexpectedCharacter,__tr("Function name expected"));
		}
	}
	if(!(*(c->m_ptr)))return c->error(KviError_missingClosingBrace);
	++(c->m_ptr);
	return c->leaveStackFrame();
	*/
	return false;
}

bool KviUserParser::skipCallbackCommand(KviCommand *c)
{
	/*
	ENTER_STACK_FRAME(c,"skipCallbackCommand");
//	if(!skipSwitches(c))return false;
	c->skipWhiteSpace();
	if(*(c->m_ptr) != '(')return c->error(KviError_openParenthesisExpected);
	if(!skipExpressionBody(c))return false;
	c->skipWhiteSpace();
	//if(*(c->m_ptr) != '{')return c->error(KviError_openBraceExpected);
	if(!skipCommand(c))return false;
	return c->leaveStackFrame();
	*/
	return false;
}

bool KviUserParser::skipIterationCommand(KviCommand *c)
{
	/*
	ENTER_STACK_FRAME(c,"skipIterationCommand");
	c->skipWhiteSpace();
//	if(!skipSwitches(c))return false;
	if(*(c->m_ptr) != '(')return c->error(KviError_openParenthesisExpected);
	if(!skipExpressionBody(c))return false;
	c->skipWhiteSpace();
	if(!skipCommand(c))return false;
	return c->leaveStackFrame();
	*/
	return false;
}


bool KviUserParser::skipIf(KviCommand *c)
{
	/*
	ENTER_STACK_FRAME(c,"skipIf");
	c->skipWhiteSpace();
	if(*(c->m_ptr) != '(')return c->error(KviError_openParenthesisExpected);
	if(!skipExpressionBody(c))return false;
	c->skipWhiteSpace();
	if(!skipCommand(c))return false;
	char * aux = c->m_ptr;
	c->skipWhiteSpace();
	if(kvi_strEqualCIN(c->m_ptr,"else",4))
	{
		c->m_ptr += 4;
		c->skipWhiteSpace();
		if(!skipCommand(c))return false;
	} else c->m_ptr = aux;
	return c->leaveStackFrame();
	*/
	return false;
}

bool KviUserParser::skipDefpopup(KviCommand *c)
{
	/*
	ENTER_STACK_FRAME(c,"skipDefpopup");
	c->skipWhiteSpace();
	if(*(c->m_ptr) != '(')return c->error(KviError_openParenthesisExpected);
	if(!skipExpressionBody(c))return false;
	c->skipWhiteSpace();
	if(*(c->m_ptr) != '{')return c->error(KviError_openBraceExpected);
	if(!skipPopupBody(c))return false;
	return c->leaveStackFrame();
	*/
	return false;
}


bool KviUserParser::skipPopupBody(KviCommand *c)
{
	/*
	ENTER_STACK_FRAME(c,"skipPopupBody");
	__range_valid(*(c->m_ptr) == '{');

	++(c->m_ptr);
	c->skipWhiteSpace();

	while(*(c->m_ptr) && (*(c->m_ptr) != '}'))
	{
		if(*(c->m_ptr) == '#')skipComment(c);
		else {
			if(kvi_strEqualCIN(c->m_ptr,"item",4))
			{
				c->m_ptr += 4;
				c->skipWhiteSpace();
				if(*(c->m_ptr) != '(')return c->error(KviError_openParenthesisExpected);
				if(!skipExpressionBody(c))return false;
				c->skipWhiteSpace();
				if(*(c->m_ptr) == '(')
				{
					if(!skipExpressionBody(c))return false;
					c->skipWhiteSpace();
				}
				if(!skipCommand(c))return false;
			} else if(kvi_strEqualCIN(c->m_ptr,"label",5))
			{
				c->m_ptr += 5;
				c->skipWhiteSpace();
				if(*(c->m_ptr) != '(')return c->error(KviError_openParenthesisExpected);
				if(!skipExpressionBody(c))return false;
				c->skipWhiteSpace();
				if(*(c->m_ptr) == '(')
				{
					if(!skipExpressionBody(c))return false;
					c->skipWhiteSpace();
				}
				if(*(c->m_ptr) == ';')++(c->m_ptr);
			} else if(kvi_strEqualCIN(c->m_ptr,"extpopup",8))
			{
				c->m_ptr += 8;
				c->skipWhiteSpace();
				if(*(c->m_ptr) != '(')return c->error(KviError_openParenthesisExpected);
				if(!skipExpressionBody(c))return false;
				c->skipWhiteSpace();
				if(*(c->m_ptr) == '(')
				{
					if(!skipExpressionBody(c))return false;
					c->skipWhiteSpace();
				}
				if(*(c->m_ptr) == ';')++(c->m_ptr);
			} else if(kvi_strEqualCIN(c->m_ptr,"popup",5))
			{
				c->m_ptr += 5;
				c->skipWhiteSpace();
				if(*(c->m_ptr) != '(')return c->error(KviError_openParenthesisExpected);
				if(!skipExpressionBody(c))return false;
				c->skipWhiteSpace();
				if(*(c->m_ptr) == '(')
				{
					if(!skipExpressionBody(c))return false;
					c->skipWhiteSpace();
				}
				if(*(c->m_ptr) != '{')return c->error(KviError_openBraceExpected);
				if(!skipPopupBody(c))return false;
			} else if(kvi_strEqualCIN(c->m_ptr,"prologue",8))
			{
				c->m_ptr += 8;
				c->skipWhiteSpace();
				if(!skipCommand(c))return false;
			} else if(kvi_strEqualCIN(c->m_ptr,"epilogue",8))
			{
				c->m_ptr += 8;
				c->skipWhiteSpace();
				if(!skipCommand(c))return false;
			} else if(kvi_strEqualCIN(c->m_ptr,"separator",9))
			{
				c->m_ptr += 9;
				c->skipSpace();
				if(*(c->m_ptr) == ';')++(c->m_ptr);
			} else return c->error(KviError_itemPopupOrSeparatorExpected);
		}
		c->skipWhiteSpace();
	}

	if(!(*(c->m_ptr)))return c->error(KviError_missingClosingBrace);
	++(c->m_ptr);
	return c->leaveStackFrame();
	*/
	return false;
}

bool KviUserParser::skipCaseLabel(KviCommand *c)
{
	/*
	ENTER_STACK_FRAME(c,"skipCaseLabel");
	c->skipWhiteSpace();
	if(*(c->m_ptr) != '(')return c->error(KviError_openParenthesisExpected);
	if(!skipExpressionBody(c))return false;
	c->skipWhiteSpace();
	if(*(c->m_ptr) == ':')
	{
		++(c->m_ptr);
		c->skipWhiteSpace();
	}
	if(!skipCommand(c))return false;
	return c->leaveStackFrame();
	*/
	return false;
}

bool KviUserParser::skipDefaultLabel(KviCommand *c)
{
	/*
	ENTER_STACK_FRAME(c,"skipDefaultLabel");
	c->skipWhiteSpace();
	if(*(c->m_ptr) == ':')
	{
		++(c->m_ptr);
		c->skipWhiteSpace();
	}
	if(!skipCommand(c))return false;
	return c->leaveStackFrame();
	*/
	return false;
}

bool KviUserParser::skipSwitch(KviCommand *c)
{
	/*
	ENTER_STACK_FRAME(c,"skipSwitch");

	c->skipWhiteSpace();
	if(*(c->m_ptr) != '(')return c->error(KviError_openParenthesisExpected);
	if(!skipExpressionBody(c))return false;
	c->skipWhiteSpace();
	if(*(c->m_ptr) != '{')return c->error(KviError_openBraceExpected);
	++(c->m_ptr);
	c->skipWhiteSpace();

	while(*(c->m_ptr) && (*(c->m_ptr) != '}'))
	{
		if(kvi_strEqualCIN(c->m_ptr,"case",4))
		{
			c->m_ptr += 4;
			if(!skipCaseLabel(c))return false;
		} else if(kvi_strEqualCIN(c->m_ptr,"match",5))
		{
			c->m_ptr += 5;
			if(!skipCaseLabel(c))return false;
		} else if(kvi_strEqualCIN(c->m_ptr,"regexp",6))
		{
			c->m_ptr += 6;
			if(!skipCaseLabel(c))return false;
		} else if(kvi_strEqualCIN(c->m_ptr,"default",7))
		{
			c->m_ptr += 7;
			if(!skipDefaultLabel(c))return false;
		} else if(kvi_strEqualCIN(c->m_ptr,"break",5))
		{
			c->m_ptr += 5;
			if(!skipNormalCommand(c))return false;
			c->skipWhiteSpace();
		} else if(*(c->m_ptr) == '#')
		{
			// A comment
			skipComment(c);
		} else return c->error(KviError_caseMatchRegexpDefaultOrBreakExpected);
		c->skipWhiteSpace();
	}

	if(!(*(c->m_ptr)))return c->error(KviError_missingClosingBrace);
	++(c->m_ptr);

	return c->leaveStackFrame();
	*/
	return false;
}


bool KviUserParser::skipFor(KviCommand *c)
{
	/*
	ENTER_STACK_FRAME(c,"skipFor");
	c->skipWhiteSpace();
	if(*(c->m_ptr) != '(')return c->error(KviError_openParenthesisExpected);
	++(c->m_ptr);
	c->skipWhiteSpace();
	if(!skipSingleCommand(c))return false;
	c->skipWhiteSpace();
	if(!skipForCondition(c))return false;
	if(!(*(c->m_ptr)))return c->error(KviError_unexpectedEndInExpression);
	++(c->m_ptr);
	c->skipWhiteSpace();
	if(*(c->m_ptr) == ')')++(c->m_ptr);
	else if(!skipLValueCommand(c,true))return false;
	if(!(*(c->m_ptr)))return c->error(KviError_unexpectedEndInExpression);
	++(c->m_ptr);
	c->skipWhiteSpace();
	if(!skipCommand(c))return false;
	return c->leaveStackFrame();
	*/
	return false;
}
