//=============================================================================
//
//   File : dialog.cpp
//   Created on Fri 10 Feb 2006 18:52:18 by Szymon Stefanek
//   Based on dlg_options.cpp: Tue Jun 11 2000 02:39:12 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC Client distribution
//   Copyright (C) 2000-2006 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#include "dialog.h"

#include "kvi_app.h"
#include "kvi_options.h"
#include "kvi_locale.h"
#include "kvi_iconmanager.h"
#include "kvi_module.h"
#include "kvi_styled_controls.h"

#include <qlayout.h>
#include <qaccel.h>
#include <qlabel.h>
#include <qvbox.h>
#include <qsplitter.h>
#include <qwidgetstack.h>
#include <qpushbutton.h>
#include <qtooltip.h>
#include <qheader.h>
#include <qpopupmenu.h>
#include <qtoolbutton.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qtooltip.h>
#include <qobjectlist.h>
#include <qpainter.h>
#include <qfont.h>

//extern KviModule * g_pOptionsModule;
extern QDict<KviOptionsDialog> * g_pOptionsDialogDict;

extern KVIRC_API KviApp * g_pApp;
extern KviOptionsInstanceManager * g_pOptionsInstanceManager;

KviGeneralOptionsFrontWidget::KviGeneralOptionsFrontWidget(QWidget *parent)
:KviOptionsWidget(parent,"general_options_front_widget")
{
	createLayout(1,1);
#ifdef COMPILE_INFO_TIPS
	QLabel * l = new QLabel(__tr2qs_ctx(
					"<table width=\"100%\"><tr><td bgcolor=\"#303030\">" \
					"<center><h1><font color=\"#FFFFFF\">General Preferences</font></h1></center>" \
					"</td></tr><tr><td><br><br>" \
					"<center><b>These sections contain various settings for KVIrc</b></center><br><br>" \
					"<p>When you have finished, click \"<b>OK</b>\" to accept your changes " \
					"or \"<b>Cancel</b>\" to discard them. Clicking \"<b>Apply</b>\" will commit your " \
					"changes without closing the window." \
					"</td></tr><tr><td>" \
					"Many settings have tooltips that can be shown " \
					"by holding the cursor over their label for a few seconds." \
					"</p></td></tr></table>","options"),this);
#else
	QLabel * l = new QLabel(__tr2qs_ctx(
					"<table width=\"100%\"><tr><td bgcolor=\"#303030\">" \
					"<center><h1><font color=\"#FFFFFF\">General Preferences</font></h1></center>" \
					"</td></tr><tr><td><br><br>" \
					"Select a category in the list view on the left " \
					"to view the related settings. " \
					"When you have finished, click \"<b>OK</b>\" to accept your changes " \
					"or \"<b>Cancel</b>\" to discard them. Clicking \"<b>Apply</b>\" will commit your " \
					"changes without closing this window.<br><br>" \
					"</td></tr></table>","options"),this);
#endif
//	l->setAlignment(AlignCenter);
	layout()->addWidget(l,0,0);
}

KviGeneralOptionsFrontWidget::~KviGeneralOptionsFrontWidget()
{
}




KviOptionsListViewItem::KviOptionsListViewItem(QListView *parent,KviOptionsWidgetInstanceEntry * e)
:QListViewItem(parent,e->szName)
{
	m_pInstanceEntry = e;
	m_pOptionsWidget = 0;
	m_bHighlighted = false;
	setPixmap(0,*(g_pIconManager->getSmallIcon(e->iIcon)));
}

KviOptionsListViewItem::KviOptionsListViewItem(QListViewItem *parent,KviOptionsWidgetInstanceEntry * e)
:QListViewItem(parent,e->szName)
{
	m_pInstanceEntry = e;
	m_pOptionsWidget = 0;
	m_bHighlighted = false;
	setPixmap(0,*(g_pIconManager->getSmallIcon(e->iIcon)));
}

KviOptionsListViewItem::~KviOptionsListViewItem()
{
}

void KviOptionsListViewItem::paintCell(QPainter * p,const QColorGroup & cg,int column,int width,int align)
{
	if(m_bHighlighted)
	{
		QColorGroup tmp(cg);
		tmp.setColor(QColorGroup::Base,Qt::red);
		tmp.setColor(QColorGroup::Background,Qt::red);
		tmp.setColor(QColorGroup::Text,Qt::yellow);
		QListViewItem::paintCell(p,tmp,column,width,align);
	} else {
		QListViewItem::paintCell(p,cg,column,width,align);
	}
}


KviOptionsDialog::KviOptionsDialog(QWidget * par,const QString &szGroup)
: QDialog(par,"general_options_dialog")
{
	setCaption(__tr2qs_ctx("Preferences - KVIrc","options"));
	setIcon(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_KVIRC)));

	m_szGroup = szGroup;

	QGridLayout * g1 = new QGridLayout(this,2,5,8,8);
	QSplitter * spl = new QSplitter(QSplitter::Horizontal,this);

	g1->addMultiCellWidget(spl,0,0,0,4);

	QVBox * vbox = new QVBox(spl);
	vbox->setSpacing(2);
	vbox->setMargin(0);

	// Controlling list view
	m_pListView = new QListView(vbox);
	m_pListView->addColumn("");
	m_pListView->header()->hide();
	m_pListView->setRootIsDecorated(true);
	m_pListView->setSorting(-1);
	connect(m_pListView,SIGNAL(selectionChanged(QListViewItem *)),this,SLOT(listViewItemSelectionChanged(QListViewItem *)));

	QHBox * hbox = new QHBox(vbox);
	vbox->setSpacing(2);
	vbox->setMargin(0);

	m_pSearchLineEdit = new QLineEdit(hbox);
	connect(m_pSearchLineEdit,SIGNAL(returnPressed()),this,SLOT(searchClicked()));
	m_pSearchButton = new KviStyledToolButton(hbox);
	m_pSearchButton->setUsesBigPixmap(false);
	m_pSearchButton->setIconSet(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_SEARCH)));
	connect(m_pSearchButton,SIGNAL(clicked()),this,SLOT(searchClicked()));
	connect(m_pSearchLineEdit,SIGNAL(textChanged(const QString &)),this,SLOT(searchLineEditTextChanged(const QString &)));

	vbox = new QVBox(spl);
	vbox->setSpacing(2);
	vbox->setMargin(0);

	m_pCategoryLabel = new QLabel("<b>" + __tr2qs_ctx("General Preferences","options") + "</b>",vbox,"labgeneraloptions");
	//m_pCategoryLabel->setMargin(3);

	QFrame * f = new QFrame(vbox);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);

	// Widget stack
	m_pWidgetStack = new QWidgetStack(vbox);
	vbox->setStretchFactor(m_pWidgetStack,1);

	// First widget visible
	m_pFrontWidget = new KviGeneralOptionsFrontWidget(m_pWidgetStack);
	m_pWidgetStack->addWidget(m_pFrontWidget,0);
	m_pWidgetStack->raiseWidget(m_pFrontWidget);

//  Ok,Cancel,Help

	QPushButton * b = new QPushButton(__tr2qs_ctx("&OK","options"),this,"btnok");
	QToolTip::add(b,__tr2qs_ctx("Close this dialog, accepting all changes.","options"));
	connect(b,SIGNAL(clicked()),this,SLOT(okClicked()));
	//b->setMinimumWidth(whatIsThisWidth);
	b->setIconSet(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_ACCEPT)));
	g1->addWidget(b,1,2);	

	b = new QPushButton(__tr2qs_ctx("&Apply","options"),this,"btnapply");
	QToolTip::add(b,__tr2qs_ctx("Commit all changes immediately.","options"));
	connect(b,SIGNAL(clicked()),this,SLOT(applyClicked()));
	b->setIconSet(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_ACCEPT)));
	g1->addWidget(b,1,3);

	b = new QPushButton(__tr2qs_ctx("Cancel","options"),this,"btncancel");
	QToolTip::add(b,__tr2qs_ctx("Close this dialog, discarding all changes.","options"));
	b->setDefault(true);
	//b->setMinimumWidth(whatIsThisWidth);
	connect(b,SIGNAL(clicked()),this,SLOT(cancelClicked()));
	b->setIconSet(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_DISCARD)));
	g1->addWidget(b,1,4);

	g1->setRowStretch(0,1);
	g1->setColStretch(1,1);


	fillListView(0,g_pOptionsInstanceManager->instanceEntryTree(),szGroup);


	if(!parent())
	{

		if(KVI_OPTION_RECT(KviOption_rectGeneralOptionsDialogGeometry).y() < 5)
		{
			KVI_OPTION_RECT(KviOption_rectGeneralOptionsDialogGeometry).setY(5);
		}
		//setGeometry(KVI_OPTION_RECT(KviOption_rectGeneralOptionsDialogGeometry));
		resize(KVI_OPTION_RECT(KviOption_rectGeneralOptionsDialogGeometry).width(),
			KVI_OPTION_RECT(KviOption_rectGeneralOptionsDialogGeometry).height());
		move(KVI_OPTION_RECT(KviOption_rectGeneralOptionsDialogGeometry).x(),
			KVI_OPTION_RECT(KviOption_rectGeneralOptionsDialogGeometry).y());
	}
	QAccel *a = new QAccel( this );
        a->connectItem( a->insertItem(Key_Escape), this,SLOT(close()) );
	
}

KviOptionsDialog::~KviOptionsDialog()
{
	if(!parent())KVI_OPTION_RECT(KviOption_rectGeneralOptionsDialogGeometry) = QRect(pos().x(),pos().y(),
			size().width(),size().height());
	if(g_pOptionsDialogDict)
		g_pOptionsDialogDict->remove(m_szGroup);
//	g_pOptionsModule->unlock();
}


/*
void KviOptionsDialog::refreshListView(void)
{
	bool bChangeWidget=0;
	KviOptionsListViewItem *i = (KviOptionsListViewItem *)m_pListView->currentItem();
	if(i->m_pInstanceEntry)
	{
		if(i->m_pInstanceEntry->iMinimalUserExperienceLevel > KVI_OPTION_UINT(KviOption_uintUserExperienceLevel))
			bChangeWidget=1;
	}
	m_pListView->clear();
	fillListView(0,g_pOptionsInstanceManager->instanceEntryTree());
	if(bChangeWidget)
	{
		m_pListView->setCurrentItem(m_pListView->firstChild());
		listViewItemSelectionChanged(m_pListView->firstChild());
	}
}
*/

void KviOptionsDialog::searchLineEditTextChanged(const QString &)
{
	QString txt = m_pSearchLineEdit->text().stripWhiteSpace();
	m_pSearchButton->setEnabled(txt.length() > 0);
}

bool KviOptionsDialog::recursiveSearch(KviOptionsListViewItem * pItem,const QStringList &lKeywords)
{
	if(!pItem)return false;

	if(!pItem->m_pOptionsWidget)
	{
		pItem->m_pOptionsWidget = g_pOptionsInstanceManager->getInstance(pItem->m_pInstanceEntry,m_pWidgetStack);
		m_pWidgetStack->addWidget(pItem->m_pOptionsWidget,0);
	}

	bool bFoundSomethingHere = false;
	
	QObjectList * ol = pItem->m_pOptionsWidget->queryList();
	if(ol)
	{
		QObjectListIt it(*ol);
		QObject * o;
		while((o = it.current())/* && (!bFoundSomethingHere)*/)
		{
			QString szText;
			if(o->inherits("QLabel"))szText = ((QLabel *)o)->text();
			else if(o->inherits("QCheckBox"))szText = ((QCheckBox *)o)->text();
			else if(o->inherits("QGroupBox"))szText = ((QGroupBox *)o)->title();
#ifdef COMPILE_INFO_TIPS
			if(o->inherits("QWidget"))
				szText.append(QToolTip::textFor((QWidget*)o));
#endif
			if(!szText.isEmpty())
			{
				bool bOk = true;
				for(QStringList::ConstIterator it = lKeywords.begin();it != lKeywords.end();++it)
				{
					if(szText.find(*it,0,false) == -1)
					{
						bOk = false;
						break;
					}
				}
				if(bOk)
				{
					bFoundSomethingHere = true;
				}
				
				if(o->inherits("QWidget"))
				{
					QWidget* pWidget=(QWidget*)o;
					QFont font = pWidget->font();
					font.setBold(bOk);
					font.setUnderline(bOk);
					pWidget->setFont(font);
				}
			}
			
			++it;
		}
		delete ol;
	}

	pItem->setHighlighted(bFoundSomethingHere);

	KviOptionsListViewItem * pChild = (KviOptionsListViewItem *)pItem->firstChild();
	bool bFoundSomethingInside = false;
	while(pChild)
	{
		bool bRet = recursiveSearch(pChild,lKeywords);
		if(bRet)bFoundSomethingInside = true;
		pChild = (KviOptionsListViewItem *)(pChild->nextSibling());
	}
	pItem->setSelected(false);
	m_pListView->setOpen(pItem,bFoundSomethingInside);
	return (bFoundSomethingInside || bFoundSomethingHere);
}

void KviOptionsDialog::search(const QStringList &lKeywords)
{
	m_pListView->setUpdatesEnabled(false);

	KviOptionsListViewItem * pChild = (KviOptionsListViewItem *)(m_pListView->firstChild());
	bool bFoundSomethingInside = false;
	while(pChild)
	{
		bFoundSomethingInside = recursiveSearch(pChild,lKeywords);
		pChild = (KviOptionsListViewItem *)(pChild->nextSibling());
	}
	m_pListView->setUpdatesEnabled(true);
	m_pListView->triggerUpdate();
}

void KviOptionsDialog::search(const QString &szKeywords)
{
	QStringList lKeywords = QStringList::split(" ",szKeywords,false);
	search(lKeywords);
}

void KviOptionsDialog::searchClicked()
{
	QString szTxt = m_pSearchLineEdit->text().stripWhiteSpace();
	if(!szTxt.isEmpty())
		search(szTxt);
}

void KviOptionsDialog::fillListView(QListViewItem * p,KviPtrList<KviOptionsWidgetInstanceEntry> * l,const QString &szGroup)
{
	if(!l)return;

	KviOptionsListViewItem * it;
	KviOptionsWidgetInstanceEntry * e;

	KviPtrList<KviOptionsWidgetInstanceEntry> tmp;
	tmp.setAutoDelete(false);


	for(e = l->first();e;e = l->next())
	{
		e->bDoInsert = KviQString::equalCI(szGroup,e->szGroup);
		KviOptionsWidgetInstanceEntry * ee = tmp.first();
		int idx = 0;
		while(ee)
		{
			if(ee->iPriority >= e->iPriority)break;
			idx++;
			ee = tmp.next();
		}
		tmp.insert(idx,e);
	}

	for(e = tmp.first();e;e = tmp.next())
	{
		if(e->bDoInsert)
		{
			if(p)it = new KviOptionsListViewItem(p,e);
			else it = new KviOptionsListViewItem(m_pListView,e);
		} else {
			it = (KviOptionsListViewItem *)p;
		}
		if(e->pChildList && (!e->bIsContainer))
			fillListView(it,e->pChildList,szGroup);
	}
}

void KviOptionsDialog::listViewItemSelectionChanged(QListViewItem *it)
{
	if(it)
	{
		QString str = it->text(0);
		QListViewItem * par = it->parent();

		while(par)
		{
			str.prepend(" :: ");
			str.prepend(par->text(0));
			par = par->parent();
		}
		str.prepend("<b>");
		str += "</b>";

		KviOptionsListViewItem *i = (KviOptionsListViewItem *)it;
		if(!i->m_pOptionsWidget)
		{
			i->m_pOptionsWidget = g_pOptionsInstanceManager->getInstance(i->m_pInstanceEntry,m_pWidgetStack);
			m_pWidgetStack->addWidget(i->m_pOptionsWidget,0);
		}

		m_pWidgetStack->raiseWidget(i->m_pOptionsWidget);
		m_pCategoryLabel->setText(str);
	}
}

KviOptionsListViewItem * KviOptionsDialog::findItemByPage(KviOptionsListViewItem *it,KviOptionsWidget * pPage)
{
	if(!it)return 0;
	if(it->m_pOptionsWidget == pPage)return it;

	KviOptionsListViewItem *i;
	// run through the children
	i = (KviOptionsListViewItem *)(it->firstChild());
	if(i)
	{
		i = findItemByPage(i,pPage);
		if(i)return i;
	}
	
	// not found in the children tree.. look in the next sibling
	i = (KviOptionsListViewItem *)(it->nextSibling());
	if(i)
	{
		i = findItemByPage(i,pPage);
		if(i)return i;
	}
	return 0;
}

/*
KviOptionsListViewItem * KviOptionsDialog::showHiddenChildren(QListViewItem * p,KviPtrList<KviOptionsWidgetInstanceEntry> * l)
{
	if(!l)return 0;
	if(!p)return 0;


	KviOptionsListViewItem * pFirstHiddenChild = 0;

	KviOptionsListViewItem * it;
	KviOptionsWidgetInstanceEntry * e;

	KviPtrList<KviOptionsWidgetInstanceEntry> tmp;
	tmp.setAutoDelete(false);	

	for(e = l->first();e;e = l->next())
	{
		bool bFound = false;
		it = (KviOptionsListViewItem *)(p->firstChild());
		while(it && (!bFound))
		{
			if(it->m_pInstanceEntry == e)
			{
				// already there
				if((!pFirstHiddenChild) && e->bHidden )pFirstHiddenChild = it;
					bFound = true;
			}
			it = (KviOptionsListViewItem *)(it->nextSibling());
		}
		KviOptionsWidgetInstanceEntry * ee = tmp.first();
		if(!bFound)
		{
			int idx = 0;
			while(ee)
			{
				if(ee->iPriority >= e->iPriority)break;
				idx++;
				ee = tmp.next();
			}
			tmp.insert(idx,e);
		}
	}

	//KviOptionsListViewItem * prev = 0;
	for(e = tmp.first();e;e = tmp.next())
	{
		it = new KviOptionsListViewItem(p,e);
		pFirstHiddenChild = it;
		KviOptionsDialog::showHiddenChildren(it,e->pChildList);
	}
	return pFirstHiddenChild;
}
*/

void KviOptionsDialog::pageWantsToSwitchToAdvancedPage(KviOptionsWidget * pPage)
{
	/*
	// find the item that has this page
	KviOptionsListViewItem *i = findItemByPage((KviOptionsListViewItem *)(m_pListView->firstChild()),pPage);
	if(!i)return; // oops...
	
	// got the item that has requested to switch
	
	
	KviOptionsListViewItem *pFirstHiddenChild = 0;
	// show its hidden children
	if(i->m_pInstanceEntry->pChildList)
		pFirstHiddenChild = showHiddenChildren(i,i->m_pInstanceEntry->pChildList);
	
	if(!pFirstHiddenChild)
	{
		debug("A page wanted to switch to the Advanced child but there was none...");
		return; // ooops
	}

	i->setOpen(true);

	// jump to the first child
	m_pListView->setSelected(pFirstHiddenChild,true);
	*/
}

void KviOptionsDialog::applyClicked()
{
	apply(false);
}

void KviOptionsDialog::apply(bool bDialogAboutToClose)
{
	KviOptionsListViewItem *it = (KviOptionsListViewItem *)m_pListView->firstChild();
	while(it)
	{
		recursiveCommit(it);
		it = (KviOptionsListViewItem *)it->nextSibling();
	}
	
	if(!bDialogAboutToClose)
	{
		// bring up the current widget again!
		it = (KviOptionsListViewItem *)m_pListView->currentItem();
		if(it)listViewItemSelectionChanged(it);
	}

	g_pApp->saveConfiguration();
}

void KviOptionsDialog::okClicked()
{
	apply(true);
	delete this;
}

void KviOptionsDialog::cancelClicked()
{
	delete this;
}

void KviOptionsDialog::closeEvent(QCloseEvent *e)
{
	e->ignore();
	delete this;
}

void KviOptionsDialog::recursiveCommit(KviOptionsListViewItem *it)
{
	// First commit the children
	if(!it) return;
	KviOptionsListViewItem *it2 = (KviOptionsListViewItem *)it->firstChild();
	while(it2)
	{
		recursiveCommit(it2);
		it2 = (KviOptionsListViewItem *)it2->nextSibling();
	}
	// then the parents
	if(it->m_pOptionsWidget)
	{
		it->m_pOptionsWidget->commit();
		delete it->m_pOptionsWidget;
		it->m_pOptionsWidget = 0;
	}
	//refreshListView(); // <-- this tends to jump into infinite recursion
}
void  KviOptionsDialog::keyPressEvent( QKeyEvent * e )
{
	if(e->key()==Qt::Key_Return)
		e->accept();
	else
		e->ignore();
}

#include "m_dialog.moc"
