//=============================================================================
//
//   File : optw_messages.cpp
//   Creation date : Sat Aug 11 2001 18:12:00 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001-2004 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#define _WANT_OPTION_FLAGS_

#include "optw_messages.h"

#include <qlayout.h>
#include <qpushbutton.h>
#include <qvbox.h>
#include <qcursor.h>
#include <qpainter.h>
#include "kvi_styled_controls.h"

#include "kvi_settings.h"

#ifndef COMPILE_ON_WINDOWS
	#include <unistd.h> // symlink()
#endif

#include "kvi_options.h"
#include "kvi_app.h"
#include "kvi_locale.h"
#include "kvi_iconmanager.h"
#include "kvi_mirccntrl.h"
#include "kvi_config.h"
#include "kvi_filedialog.h"

//#warning "Info tips"

#ifdef COMPILE_PSEUDO_TRANSPARENCY
	extern KVIRC_API QPixmap * g_pShadedChildGlobalDesktopBackground;
#endif



KviStandardColorsOptionsWidget::KviStandardColorsOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"stdcolors")
{
	createLayout(5,4);
	
	addColorSelector(0,0,0,0,"0:",&(KVI_OPTION_MIRCCOLOR(0)));
	addColorSelector(1,0,1,0,"1:",&(KVI_OPTION_MIRCCOLOR(1)));
	addColorSelector(2,0,2,0,"2:",&(KVI_OPTION_MIRCCOLOR(2)));
	addColorSelector(3,0,3,0,"3:",&(KVI_OPTION_MIRCCOLOR(3)));
	addColorSelector(0,1,0,1,"4:",&(KVI_OPTION_MIRCCOLOR(4)));
	addColorSelector(1,1,1,1,"5:",&(KVI_OPTION_MIRCCOLOR(5)));
	addColorSelector(2,1,2,1,"6:",&(KVI_OPTION_MIRCCOLOR(6)));
	addColorSelector(3,1,3,1,"7:",&(KVI_OPTION_MIRCCOLOR(7)));
	addColorSelector(0,2,0,2,"8:",&(KVI_OPTION_MIRCCOLOR(8)));
	addColorSelector(1,2,1,2,"9:",&(KVI_OPTION_MIRCCOLOR(9)));
	addColorSelector(2,2,2,2,"10:",&(KVI_OPTION_MIRCCOLOR(10)));
	addColorSelector(3,2,3,2,"11:",&(KVI_OPTION_MIRCCOLOR(11)));
	addColorSelector(0,3,0,3,"12:",&(KVI_OPTION_MIRCCOLOR(12)));
	addColorSelector(1,3,1,3,"13:",&(KVI_OPTION_MIRCCOLOR(13)));
	addColorSelector(2,3,2,3,"14:",&(KVI_OPTION_MIRCCOLOR(14)));
	addColorSelector(3,3,3,3,"15:",&(KVI_OPTION_MIRCCOLOR(15)));

	addRowSpacer(0,4,3,4);
	
	layout()->setRowStretch(4,1);
}

KviStandardColorsOptionsWidget::~KviStandardColorsOptionsWidget()
{
}





KviMessageListView::KviMessageListView(QWidget * par)
: QListView(par)
{
	setItemMargin(2);
}

KviMessageListView::~KviMessageListView()
{
}


void KviMessageListView::paintEmptyAreaInternal(QPainter * p,const QRect &viewportRect,const QRect &painterRect)
{
#ifdef COMPILE_PSEUDO_TRANSPARENCY
	if(g_pShadedChildGlobalDesktopBackground)
	{
		QPoint pnt = viewport()->mapToGlobal(viewportRect.topLeft());
		p->drawTiledPixmap(painterRect.x(),painterRect.y(),painterRect.width(),painterRect.height(),*g_pShadedChildGlobalDesktopBackground,pnt.x(),pnt.y());
	} else {
#endif
		QPixmap * pix = KVI_OPTION_PIXMAP(KviOption_pixmapIrcViewBackground).pixmap();
		if(pix)
		{
			QPoint pnt = viewportToContents(viewportRect.topLeft());
			p->drawTiledPixmap(painterRect.x(),painterRect.y(),painterRect.width(),painterRect.height(),*pix,pnt.x(),pnt.y());
		} else {
			p->fillRect(painterRect.x(),painterRect.y(),painterRect.width(),painterRect.height(),KVI_OPTION_COLOR(KviOption_colorIrcViewBackground));
		}
#ifdef COMPILE_PSEUDO_TRANSPARENCY
	}
#endif
}

void KviMessageListView::paintEmptyArea(QPainter * p,const QRect &rct)
{
	paintEmptyAreaInternal(p,rct,rct);
}






KviMessageListViewItem::KviMessageListViewItem(QListView * l,int optId)
: QListViewItem(l)
{
	m_iOptId = optId;
	setText(0,"WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW");
	m_pMsgType = new KviMsgType(KVI_OPTION_MSGTYPE(optId));
	setPixmap(0,*(g_pIconManager->getSmallIcon(0))); // just a dummy one to ensure that the size of the item is at least 20 pixels (16 + 2 * margin)
}

KviMessageListViewItem::~KviMessageListViewItem()
{
	delete m_pMsgType;
}

void KviMessageListViewItem::paintCell(QPainter * p,const QColorGroup &,int,int w,int)
{
#ifdef COMPILE_PSEUDO_TRANSPARENCY
	if(g_pShadedChildGlobalDesktopBackground)
	{
		QPoint pnt = listView()->viewport()->mapToGlobal(QPoint(int(p->worldMatrix().dx()),int(p->worldMatrix().dy())));
		p->drawTiledPixmap(0,0,w,height(),*g_pShadedChildGlobalDesktopBackground,pnt.x(),pnt.y());
	} else {
#endif
		QPixmap * pix = KVI_OPTION_PIXMAP(KviOption_pixmapIrcViewBackground).pixmap();
		if(pix)
		{
			QPoint pnt = listView()->viewportToContents(QPoint(int(p->worldMatrix().dx()),int(p->worldMatrix().dy())));
			p->drawTiledPixmap(0,0,w,height(),*pix,pnt.x(),pnt.y());
		} else {
			p->fillRect(0,0,w,height(),KVI_OPTION_COLOR(KviOption_colorIrcViewBackground));
		}
#ifdef COMPILE_PSEUDO_TRANSPARENCY
	}
#endif


	p->drawPixmap(listView()->itemMargin(),(height() - 16) / 2,*(g_pIconManager->getSmallIcon(m_pMsgType->pixId())));
	// draw the background
	if(m_pMsgType->back() < 16)
	{
		QColor bColor = KVI_OPTION_MIRCCOLOR(m_pMsgType->back());
		p->fillRect(22,listView()->itemMargin(),w - 24,height() - (listView()->itemMargin() * 2),bColor);
	}
	unsigned char ucFore = m_pMsgType->fore();
	if(ucFore > 15)ucFore = 0;
	p->setPen(QPen(KVI_OPTION_MIRCCOLOR(ucFore)));
	// skip the msgtype prefix
	QString txt = (g_msgtypeOptionsTable[m_iOptId].name + 7);
	txt += " (";
	txt += __tr2qs_no_xgettext(QString::fromUtf8(m_pMsgType->type()));
	txt += ")";
	p->drawText(24,listView()->itemMargin(),w - 24,height() - (listView()->itemMargin() * 2),Qt::AlignLeft | Qt::AlignVCenter,txt);
	if(isSelected())
	{
		p->drawWinFocusRect(0,0,w,height(),KVI_OPTION_COLOR(KviOption_colorIrcViewBackground));
		p->drawWinFocusRect(1,1,w - 2,height() - 2,KVI_OPTION_COLOR(KviOption_colorIrcViewBackground));
	}
}


KviMessageColorListBoxItem::KviMessageColorListBoxItem(QListBox * b,const QColor &clr,int idx)
: QListBoxText(b,QString::null)
{
	m_clr = clr;
	m_iClrIdx = idx;
	if((idx < 0) || (idx > 15))setText(__tr2qs_ctx("Transparent","options"));
}

KviMessageColorListBoxItem::~KviMessageColorListBoxItem()
{
}

void KviMessageColorListBoxItem::paint(QPainter * p)
{
	QColor clr;

	if((m_iClrIdx >= 0) && (m_iClrIdx <= 15))
	{
		clr = listBox()->isEnabled() ? KVI_OPTION_MIRCCOLOR(m_iClrIdx) : Qt::gray;
		p->fillRect(0,0,width(listBox()),height(listBox()),clr);
	} else {
		clr = listBox()->colorGroup().background();
		QListBoxText::paint(p);
	}
#if QT_VERSION >= 300
	if(isSelected())
#else
	if(selected())
#endif
	{
		p->drawWinFocusRect(0,0,width(listBox()),height(listBox()),clr);
		p->drawWinFocusRect(1,1,width(listBox()) - 2,height(listBox()) - 2,clr);
		p->drawWinFocusRect(2,2,width(listBox()) - 4,height(listBox()) - 4,clr);
	}
}
/*
int KviMessageColorListBoxItem::width(const QListBox * lb) const
{
	int w = lb->width();
	if(w < 30)w = 30;
	if(w > 150)w = 150;
	return w;
}

int KviMessageColorListBoxItem::height(const QListBox *) const 
{
	return 30;
}
*/

/*
KviIrcColorsOptionsWidget::KviIrcColorsOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"irccolors","options")
{
	createLayout(5,4);

	addRowSpacer(0,4,3,4);
}

KviIrcColorsOptionsWidget::~KviIrcColorsOptionsWidget()
{
}
*/

KviMessageOptionsWidget::KviMessageOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"messages")
{
	int i;

	createLayout(2,4);

	m_pLastItem = 0;


	m_pListView = new KviMessageListView(this);
	m_pListView->addColumn(__tr2qs_ctx("Message Type","options"));
	m_pListView->setAllColumnsShowFocus(true);
	m_pListView->setSelectionMode(QListView::Single);
	m_pListView->setFont(KVI_OPTION_FONT(KviOption_fontIrcView));
	m_pListView->setStaticBackground(true);
	m_pListView->viewport()->setBackgroundMode(QWidget::NoBackground);

	addWidgetToLayout(m_pListView,0,0,2,0);

	QVBox * box = new QVBox(this);
	addWidgetToLayout(box,3,0,3,0);

	QLabel * l = new QLabel(__tr2qs_ctx("Background:","options"),box);

	m_pBackListBox = new QListBox(box);
	m_pBackItems[16] = new KviMessageColorListBoxItem(m_pBackListBox,Qt::gray,KVI_TRANSPARENT);
	for(i=0;i<16;i++)
	{
		m_pBackItems[i] = new KviMessageColorListBoxItem(m_pBackListBox,KVI_OPTION_MIRCCOLOR(i),i);
	}

	l = new QLabel(__tr2qs_ctx("Foreground:","options"),box);

	m_pForeListBox = new QListBox(box);
	for(i=0;i<16;i++)
	{
		m_pForeItems[i] = new KviMessageColorListBoxItem(m_pForeListBox,KVI_OPTION_MIRCCOLOR(i),i);
	}

	l = new QLabel(__tr2qs_ctx("Alert level:","options"),box);

	m_pLevelListBox = new QListBox(box);
	QListBoxText * lbt;
	for(i=0;i<6;i++)
	{
		QString tmpn;
		tmpn.setNum(i);
		lbt = new QListBoxText(m_pLevelListBox,tmpn);
	}

	m_pIconButton = new KviStyledToolButton(box);
	connect(m_pIconButton,SIGNAL(clicked()),this,SLOT(iconButtonClicked()));

	m_pIconPopup = new QPopupMenu(this);
	KviIconWidget * iw = new KviIconWidget(m_pIconPopup);
	connect(iw,SIGNAL(selected(int)),this,SLOT(newIconSelected(int)));
	m_pIconPopup->insertItem(iw);


	m_pEnableLogging = new KviStyledCheckBox(__tr2qs_ctx("Log this","options"),box);

	QHBox * h = new QHBox(this);
	addWidgetToLayout(h,0,1,3,1);
	QPushButton * b = new QPushButton(__tr2qs_ctx("Load From...","options"),h);
	connect(b,SIGNAL(clicked()),this,SLOT(load()));
	b = new QPushButton(__tr2qs_ctx("Save As...","options"),h);
	connect(b,SIGNAL(clicked()),this,SLOT(save()));


	KviMessageListViewItem * it;

	for(i=0;i<KVI_NUM_MSGTYPE_OPTIONS;i++)
	{
		it = new KviMessageListViewItem(m_pListView,i);
	}

	layout()->setRowStretch(0,1);
	layout()->setColStretch(0,1);

	connect(m_pListView,SIGNAL(selectionChanged(QListViewItem *)),this,SLOT(itemChanged(QListViewItem *)));
	connect(m_pForeListBox,SIGNAL(selectionChanged(QListBoxItem *)),this,SLOT(colorChanged(QListBoxItem *)));
	connect(m_pBackListBox,SIGNAL(selectionChanged(QListBoxItem *)),this,SLOT(colorChanged(QListBoxItem *)));

	itemChanged(0);
}

KviMessageOptionsWidget::~KviMessageOptionsWidget()
{
}

void KviMessageOptionsWidget::newIconSelected(int iconId)
{
	if(!m_pLastItem)return;
	if(iconId >= KVI_NUM_SMALL_ICONS)return;
	m_pLastItem->msgType()->setPixId(iconId);
	m_pIconButton->setIconSet(*(g_pIconManager->getSmallIcon(iconId)));
	m_pListView->repaintItem(m_pLastItem);
}

void KviMessageOptionsWidget::saveLastItem()
{
	if(!m_pLastItem)return;

	int curIt = m_pForeListBox->currentItem();
	if(curIt != -1)
	{
		//debug("Setting fore %d",curIt);
		KviMessageColorListBoxItem * fore = (KviMessageColorListBoxItem *)m_pForeListBox->item(curIt);
		//debug("And is %d",fore);
		if(fore)m_pLastItem->msgType()->setFore(fore->m_iClrIdx);
	}
	curIt = m_pBackListBox->currentItem();
	if(curIt != -1)
	{
		KviMessageColorListBoxItem * back = (KviMessageColorListBoxItem *)m_pBackListBox->item(curIt);
		if(back)m_pLastItem->msgType()->setBack(back->m_iClrIdx);
	}
	m_pLastItem->msgType()->enableLogging(m_pEnableLogging->isChecked());
	//debug("Updating","options");
	curIt = m_pLevelListBox->currentItem();
	if(curIt < 0 || curIt > 5)curIt = 1;
	m_pLastItem->msgType()->setLevel(curIt);
	m_pListView->repaintItem(m_pLastItem);
}

void KviMessageOptionsWidget::itemChanged(QListViewItem * it)
{
	//debug("Item changed","options");
	if(m_pLastItem)saveLastItem();

	m_pLastItem = 0; // do NOT save in this routine

	m_pForeListBox->setEnabled(it);
	m_pBackListBox->setEnabled(it);
	m_pEnableLogging->setEnabled(it);
	m_pIconButton->setEnabled(it);
	m_pLevelListBox->setEnabled(it);

	if(it)
	{
		int back = ((KviMessageListViewItem *)it)->msgType()->back();
		int fore = ((KviMessageListViewItem *)it)->msgType()->fore();
		if(fore >= 0 && fore <= 15)
		{
			m_pForeListBox->setCurrentItem(m_pForeItems[fore]);
		}
		if(back >= 0 && back <= 15)
		{
			m_pBackListBox->setCurrentItem(m_pBackItems[back]);
		} else {
			m_pBackListBox->setCurrentItem(m_pBackItems[16]);
		}
		m_pLevelListBox->setCurrentItem(((KviMessageListViewItem *)it)->msgType()->level());
		m_pEnableLogging->setChecked(((KviMessageListViewItem *)it)->msgType()->logEnabled());
		m_pIconButton->setIconSet(*(g_pIconManager->getSmallIcon(((KviMessageListViewItem *)it)->msgType()->pixId())));
	}

	// Ok...can save from now on
	m_pLastItem = (KviMessageListViewItem *)it;

}

void KviMessageOptionsWidget::colorChanged(QListBoxItem *)
{
	if(m_pLastItem)saveLastItem();
}

void KviMessageOptionsWidget::iconButtonClicked()
{
	m_pIconPopup->popup(QCursor::pos());
}

void KviMessageOptionsWidget::commit()
{
	saveLastItem();

	mergeResetFlag(KviOption_resetUpdateGui);

	KviMessageListViewItem * it = (KviMessageListViewItem *)m_pListView->firstChild();
	while(it)
	{
		KVI_OPTION_MSGTYPE(it->optionId()) = *(it->msgType());
		it = (KviMessageListViewItem *)(it->nextSibling());
	}

	KviOptionsWidget::commit();
}

void KviMessageOptionsWidget::save()
{
	KviStr szName;
	KviStr szInit;
	g_pApp->getLocalKvircDirectory(szInit,KviApp::MsgColors);

	if(KviFileDialog::askForSaveFileName(szName,__tr2qs_ctx("Choose a Filename - KVIrc","options"),szInit))
	{
		if(m_pLastItem)saveLastItem();

		KviConfig cfg(szName.ptr(),KviConfig::Write);

		cfg.setGroup("Messages");

		KviStr tmp;

	
		KviMessageListViewItem * it = (KviMessageListViewItem *)m_pListView->firstChild();

		while(it)
		{
			tmp.sprintf("Fore%d",it->optionId());
			cfg.writeEntry(tmp.ptr(),it->msgType()->fore());
			tmp.sprintf("Back%d",it->optionId());
			cfg.writeEntry(tmp.ptr(),it->msgType()->back());
			tmp.sprintf("Icon%d",it->optionId());
			cfg.writeEntry(tmp.ptr(),it->msgType()->pixId());
			tmp.sprintf("Log%d",it->optionId());
			cfg.writeEntry(tmp.ptr(),it->msgType()->logEnabled());
			tmp.sprintf("Level%d",it->optionId());
			cfg.writeEntry(tmp.ptr(),it->msgType()->level());
			it = (KviMessageListViewItem *)(it->nextSibling());
		}

	}
}

//#include <errno.h>

void KviMessageOptionsWidget::load()
{

	//KviStr szName;
	QString szName;
	//KviStr szInit;
	QString szInit;
	g_pApp->getLocalKvircDirectory(szInit,KviApp::MsgColors);

#ifndef COMPILE_ON_WINDOWS
	// symlink local to global
	//KviStr szGlobal;
	QString szGlobal;
	g_pApp->getGlobalKvircDirectory(szGlobal,KviApp::MsgColors);
	//KviStr szLocal;
	QString szLocal;
	g_pApp->getLocalKvircDirectory(szLocal,KviApp::MsgColors,"presets");
	//debug("SYMLINKING %s to %s",szGlobal.ptr(),szLocal.ptr());
	//debug("SYMLINK RETURNS %d (%d)",::symlink(szGlobal.ptr(),szLocal.ptr()));
	//debug("ERRNO (%d)",errno);
	symlink(szGlobal,szLocal);
	// FIXME: Do it also on windows...
#endif

	if(KviFileDialog::askForOpenFileName(szName,__tr2qs_ctx("Choose a Filename - KVIrc ","options"),szInit))
	{

		itemChanged(0);
		

		KviConfig cfg(szName,KviConfig::Read);

		cfg.setGroup("Messages");

		//KviStr tmp;
		QString tmp;
		KviMessageListViewItem * it = (KviMessageListViewItem *)m_pListView->firstChild();

		while(it)
		{
			tmp.sprintf("Fore%d",it->optionId());
			int fore = cfg.readIntEntry(tmp,it->msgType()->fore());
			if(fore < 0 || fore > 15)fore = 0;
			it->msgType()->setFore(fore);

			tmp.sprintf("Back%d",it->optionId());
			int back = cfg.readIntEntry(tmp,it->msgType()->back());
			if(back < 0 || back > 15)back = KVI_TRANSPARENT;
			it->msgType()->setBack(back);

			tmp.sprintf("Icon%d",it->optionId());
			int ico = cfg.readIntEntry(tmp,it->msgType()->pixId());
			if(ico < 0 || ico >= KVI_NUM_SMALL_ICONS)ico = 0;
			it->msgType()->setPixId(ico);

			tmp.sprintf("Log%d",it->optionId());
			bool bLog = cfg.readBoolEntry(tmp,it->msgType()->logEnabled());
			it->msgType()->enableLogging(bLog);

			tmp.sprintf("Level%d",it->optionId());
			int iLevel = cfg.readIntEntry(tmp,it->msgType()->level());
			it->msgType()->setLevel(iLevel);

			m_pListView->repaintItem(it);

			it = (KviMessageListViewItem *)(it->nextSibling());
		}

	}
}

#include "m_optw_messages.moc"
