/***************************************************************************
                          wwidget.h  -  description
                             -------------------
    begin                : Die Nov 12 2002
    copyright            : (C) 2002 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef WWIDGET_H
#define WWIDGET_H

#include <stdlib.h>

#include <qwidget.h>
#include <qlabel.h>
#include <qpainter.h>
#include <qimage.h>
#include <kprogress.h>
#include <kpushbutton.h>
#include <ktabctl.h>

#include "options.h"
#include "wcard.h"
#include "config.h"

#include "ktabwidget.h"
#include "kwcentrylabel.h"
#include "kwcentryedit.h"
#include "kwcentrybar.h"
#include "kwcentryselection.h"
#include "kwcentryspin.h"

/**
  *@author Matthias Reif
  */

class WWidget : public QWidget  {
   Q_OBJECT
public: 
	WWidget(WCard *pCard, Options *pOptions, QWidget *parent=0, const char *name=0);
	~WWidget();
  
  KTabCtl *tab;

private:
  Options         *options;
  WCard						*card;
  KPushButton     *closeButton;

protected:
	KTabWidget			*firstTab;
	KTabWidget			*secondTab;
	KTabWidget			*thirdTab;
	KTabWidget			*infoTab;

	KWCEntryEdit			*deviceEdit;			
	KWCEntryLabel			*IPLabel;

  KWCEntryLabel			*nickLabel;
	
	KWCEntrySelection	*modeSelection;
	KWCEntryBar				*linkBar;
	KWCEntryBar				*signalBar;
	KWCEntryBar				*noiseBar;
	KWCEntryLabel			*encodingLabel;

  KWCEntrySpin			*pollingSpin;
	
	KWCEntryLabel			*protocolLabel;
	KWCEntrySelection	*bitrateSelection;
	KWCEntryLabel			*frequencyLabel;
	KWCEntryLabel			*channelLabel;
	KWCEntryLabel			*txPowerLabel;
	KWCEntrySelection *sensitivitySelection;
	KWCEntryEdit			*essidEdit;
	KWCEntryLabel			*sentLabel;
	KWCEntryLabel			*recvLabel;

	KWCEntryLabel			*macAPLabel;


	KWCEntryLabel			*authorLabel;
	KWCEntryLabel			*homepageLabel;
	KWCEntryLabel			*versionLabel;
	KWCEntryLabel			*licenseLabel;
	QLabel						*emailLabel;
	QImage						*logoImage;

	int		link, signal, noise, avg;
  BitRates *bitRates;
	char	*buffer;
	char	*eh;

	bool	isWave;
	
  
public slots: // Public slots
  /** when the close/ok button was clicked */
  void slotClose();
  /** No descriptions */
  void basicTimerSlot();
  /** No descriptions */
  void shortTimerSlot();

  /** when another tab was selected */
  void tabSelectedSlot(int index);
  
  /** when the device was changed */
  void deviceSlot(const QString & text);
  
  /** when the essid was changed */
  void essidSlot(const QString & text);
  
  /** when the bitrate was changed */
  void bitrateSlot(int index);
  
  /** when the mode was changed*/
  void modeSlot(int index);
  
  /** when the sensitivity was changed */
  void sensitivitySlot(int index);

  /** set isWave true, if the card is a wavelan device */
  void setWave(bool is = true);
  
  /** when the logo has to repaint */
  void infoRepaintSlot();

};

#endif
