/***************************************************************************
 *   Copyright (C) 2004 by Matthias Reif                                   *
 *   matthias.reif@informatik.tu-chemnitz.de                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KTHRESHOLDGROUP_H
#define KTHRESHOLDGROUP_H

#include <qcheckbox.h>
#include <klocale.h>
#include <knuminput.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qbuttongroup.h>
#include <qtoolbutton.h>
#include <kglobal.h>
#include <kiconloader.h>


#include "kwavecontrol.h"

/**
@author Matthias Reif
*/
class KThresholdGroup : public QButtonGroup
{
Q_OBJECT
public:
	KThresholdGroup( QString title, QWidget *parent = 0, const char *name = 0 );
	~KThresholdGroup();
	void set( bool enabled, int value );
	bool hasFocus();
	void clearFocus();
	bool hasChanged();
	void clearChanged();

protected:
	QCheckBox* enableBox;
	KIntSpinBox* thresholdSpin;
	QToolButton *applyButton;
	bool changed;
protected slots:
	void applySlot();
	void enableClickedSlot();
signals:
	void applied( bool enabled, int value );
};

#endif
