#ifndef KDIALUPCLASS_H
#define KDIALUPCLASS_H
/** KWlan
 *
 *  This File is part of KWlan, a network Manager for KDE.
 *  KWlan is distributed under LGPL license.
 *
 *	@author Thomas Michel <tom.michel@arcor.de>
 */

#include "dialup.h"

#include <qobject.h>

class QString;
class SuProcessBase;

class dialupClass : public QObject
{
    Q_OBJECT
    public:
        dialupClass(QObject *parent = 0, const char *name = 0);
        ~dialupClass();
        bool readData(QString profile);
        bool writeData(QString profile);
        void parseConfigLine( QString line);
        dialupData* getData()
        {
            return &m_data;
        }
    signals:
        void dataWritten();
                
    public slots:
        void slotWriteProcessExited(SuProcessBase *);
        
    private:
        dialupData m_data;
};

#endif
