

#include "kdialupstatusdlg.h"

#include <qlistview.h>
#include <qstring.h>
#include <kprocess.h>
#include <kdebug.h>
#include <qstringlist.h>

KDialupStatusDlg::KDialupStatusDlg(QWidget* parent, const char* name, bool modal, WFlags fl)
: KDialupStatus(parent,name, modal,fl)
{
}

KDialupStatusDlg::~KDialupStatusDlg()
{
}

/*$SPECIALIZATION$*/
void KDialupStatusDlg::init(QString network, KProcess *tail)
{
    m_network = network;
    m_tailProcess = tail;
}

void KDialupStatusDlg::cancelConnect()
{
    emit disconnectNetwork(m_network);
    if (m_tailProcess) m_tailProcess->kill();
    close();
}

void KDialupStatusDlg::addEvent(QString event)
{
    //kdDebug() << "Log event: " << event << endl;
    //sometimes tail gives back mor than on line
    QListViewItem *item;
    item = new QListViewItem(lvEventHistory,event);
    if (item == NULL)
        return;
    lvEventHistory->ensureItemVisible(item);
    lvEventHistory->setSelected(item, false);

}



#include "kdialupstatusdlg.moc"

