

#include "kuserdatarequestdlg.h"
#include "wpa_ctrl.h"
#include "kwlanmainwin.h"
#include "kwlaninterface.h"

#include <qlabel.h>
#include <qlineedit.h>
#include <klocale.h>

KUserDataRequestDlg::KUserDataRequestDlg(QWidget* parent, const char* name, bool modal, WFlags fl)
    : KUserDataRequest(parent,name, modal,fl)
{}

KUserDataRequestDlg::~KUserDataRequestDlg()
{}

/*$SPECIALIZATION$*/
int KUserDataRequestDlg::setParams( KWlanInterface *interface, const char * requestMessage )
{
    char *tmp, *pos, *pos2;
    m_interface = interface;
    tmp = strdup(requestMessage);
    if (tmp == NULL)
        return -1;
    pos = strchr(tmp, '-');
    if (pos == NULL) {
        free(tmp);
        return -1;
    }
    *pos++ = '\0';
    m_field = tmp;
    pos2 = strchr(pos, ':');
    if (pos2 == NULL) {
        free(tmp);
        return -1;
    }
    *pos2++ = '\0';
    
    m_networkId = atoi(pos);
    queryInfo->setText(pos2);
    if (strcmp(tmp, "PASSWORD") == 0) {
        queryField->setText(i18n("Password: "));
        queryEdit->setEchoMode(QLineEdit::Password);
    } else if (strcmp(tmp, "NEW_PASSWORD") == 0) {
        queryField->setText(i18n("New password: "));
        queryEdit->setEchoMode(QLineEdit::Password);
    } else if (strcmp(tmp, "IDENTITY") == 0)
        queryField->setText(i18n("Identity: "));
    else if (strcmp(tmp, "PASSPHRASE") == 0) {
        queryField->setText(i18n("Private key passphrase: "));
        queryEdit->setEchoMode(QLineEdit::Password);
    } else
        queryField->setText(m_field + ":");
    free(tmp);
    return 0;
}

void KUserDataRequestDlg::sendReply()
{ 
    if (m_interface == NULL) {
        reject();
        return;
    }
    char reply[10];
    size_t reply_len = sizeof(reply);
    
    
    QString cmd = QString(WPA_CTRL_RSP) + m_field + '-' +
            QString::number(m_networkId) + ':' +
            queryEdit->text();
    //TODO: Add ctrlRequest to parent
    m_interface->ctrlRequest(cmd.ascii(), reply, &reply_len);
    accept();
}



#include "kuserdatarequestdlg.moc"

