/***************************************************************************
 *
 *  $Id: jukebox.h,v 1.2 2005/06/15 10:24:23 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef JUKEBOX_H
#define JUKEBOX_H

#include <libnjb.h>

#include <qstring.h>

/**
@author Andreas Mussgiller
*/
class Jukebox
{
 public:

  virtual ~Jukebox();
  static Jukebox * get();

  void                        setNJB(njb_t *);

  uint                        jukeboxType() { return fJukeboxType; }
  const QString &             jukeboxTypeName() { return fJukeboxTypeName; }
  const QString &             productName() { return fProductName; }
  uint                        hardwareMajor() { return fHardwareMajor; }
  uint                        hardwareMinor() { return fHardwareMinor; }
  uint                        hardwareRelease() { return fHardwareRelease; }
  uint                        firmwareMajor() { return fFirmwareMajor; }
  uint                        firmwareMinor() { return fFirmwareMinor; }
  uint                        firmwareRelease() { return fFirmwareRelease; }
  unsigned long long          libraryCount() { return fLibraryCount; }

 protected:

  uint                        fJukeboxType;
  QString                     fJukeboxTypeName;
  QString                     fProductName;
  uint                        fHardwareMajor;
  uint                        fHardwareMinor;
  uint                        fHardwareRelease;
  uint                        fFirmwareMajor;
  uint                        fFirmwareMinor;
  uint                        fFirmwareRelease;
  unsigned long long          fLibraryCount;

  Jukebox();
  static Jukebox             *fgJukebox;
};

#endif
