/***************************************************************************
 *
 *  $Id: kzenratingwidget.cpp,v 1.7 2005/06/15 11:13:18 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <iostream>

#include <qpainter.h>

#include "kzenratingwidget.h"

KZenRatingWidget::KZenRatingWidget(QWidget *parent, const char *name)
  :QWidget(parent, name)
{
  fValue = 0;
}

KZenRatingWidget::~KZenRatingWidget()
{

}

int KZenRatingWidget::value() const
{
  return fValue;
}

QSize KZenRatingWidget::minimumSizeHint() const
{
  return QSize(90, 20);
}

QSize KZenRatingWidget::sizeHint() const
{
  return QSize(90, 20);
}

void KZenRatingWidget::setValue(int value)
{
  if (value<0 || value>5) return;
  if (fValue!=value) {
    fValue = value;
    repaint();
    valueChanged(fValue);
  }
}

void KZenRatingWidget::resizeEvent(QResizeEvent * e) 
{
  QWidget::resizeEvent(e);
}

void KZenRatingWidget::paintEvent(QPaintEvent * e) 
{
  repaintScreen(&e->rect());
}

void KZenRatingWidget::keyPressEvent(QKeyEvent * e) 
{
  switch (e->key()) {
  case Key_Left: 
  case Key_Down:
    setValue(value()-1);
    break;
  case Key_Right: 
  case Key_Up:
    setValue(value()+1);
    break;
  case Key_Home:
    setValue(0);
    break;
  case Key_End:
    setValue(5);
    break;
  default:
    e->ignore();
    break;
  }
}

int KZenRatingWidget::valueFromPoint(const QPoint & pnt)
{
  int newRating = 0;
  if (pnt.x()<8) {
    newRating = 0;
//   } else if (pnt.x()>5*15) {
//     newRating = 5;
  } else {
    newRating = (pnt.x()+8)/15;
  }

  return newRating;
}

void KZenRatingWidget::mousePressEvent(QMouseEvent * e) 
{
  setValue(valueFromPoint(e->pos()));
}

void KZenRatingWidget::mouseReleaseEvent(QMouseEvent * e) 
{
  setValue(valueFromPoint(e->pos()));
}

void KZenRatingWidget::mouseMoveEvent(QMouseEvent * e) 
{
  setValue(valueFromPoint(e->pos()));
}

#ifndef QT_NO_WHEELEVENT
void KZenRatingWidget::wheelEvent(QWheelEvent * e) 
{
  setValue(value()-e->delta()/120);
}
#endif

void KZenRatingWidget::focusInEvent(QFocusEvent *) 
{

}

void KZenRatingWidget::focusOutEvent(QFocusEvent *) 
{

}

void KZenRatingWidget::repaintScreen(const QRect *)
{
  QPainter p;
  p.begin(this);

  p.fillRect(0,0,width(),height(),colorGroup().brush(QColorGroup::Background));

  p.setPen(colorGroup().color(QColorGroup::Mid));
  p.drawRoundRect(0,(height()-20)/2,90,20);
  
  for (int i=0;i<5;i++) {
    if (i<fValue) {
      p.setPen(colorGroup().color(QColorGroup::Dark));
      p.setBrush(colorGroup().brush(QColorGroup::Dark));
      p.drawPie(15 + 15 * i - 5, height()/2 - 5, 11, 11, 0*16, 360*16);
    } else {
      p.setPen(colorGroup().color(QColorGroup::Light));
      p.setBrush(colorGroup().brush(QColorGroup::Light));
      p.drawPie(15 + 15 * i - 5, height()/2 - 5, 11, 11, 0*16, 360*16);
      p.setPen(colorGroup().color(QColorGroup::Dark));
      p.drawEllipse(15 + 15 * i - 5, height()/2 - 5, 11, 11);
    }
  }

  p.end();
}

#include "kzenratingwidget.moc"
