//LabPlot : GraphListView.cc

#include <iostream>
#include <qlabel.h>
#include <kdebug.h>
#include "GraphListView.h"
#include "Plot2DSurface.h"

using namespace std;

GraphListView::GraphListView(QWidget *p)
	: KListView(p)
{
	addColumn(i18n("Name"));
	addColumn(i18n("Type"));
	addColumn(i18n("Shown"));
	
	addColumn(i18n("Rows"));
	addColumn(i18n("Columns"));
	
	addColumn(i18n("X Range"));
	addColumn(i18n("Y Range"));
	
/*	lv->addColumn(i18n("Style"));
	lv->addColumn(i18n("Style Color"));
	lv->addColumn(i18n("Style Filled"));
	lv->addColumn(i18n("Style Fillcolor"));
	lv->addColumn(i18n("Symbol"));
	lv->addColumn(i18n("Symbol Color"));
	lv->addColumn(i18n("Symbol Size"));
	lv->addColumn(i18n("Symbol Filled"));
	lv->addColumn(i18n("Symbol Fillcolor"));
*/
	
	for (int i=0;i<columns();i++)
		setColumnAlignment(i,Qt::AlignHCenter);
	
	setAllColumnsShowFocus(true);

	// multi selection with CTRL and SHIFT
	setSelectionMode(QListView::Extended);
	
	setMinimumWidth(500);
	setMinimumHeight(150);
}
