// LabPlot : LTable.h
#include <qtable.h>
#ifndef LTABLE_H
#define LTABLE_H

#include <vector>
#include <cstdlib>
#include <qlineedit.h>

using namespace std;

class LTable : public QTable
{
	Q_OBJECT
public:
	LTable(int r=100, int c=2, QWidget *parent = 0, const char *name = 0);
    
	QString text(int row, int col);
	void setText(int row, int col, const QString &text);
	QWidget *createEditor(int row, int col, bool initFromCell) const;
	void setCellContentFromEditor(int row, int col);
	QWidget *cellWidget(int row, int col) const;
	void endEdit(int row, int col, bool accept, bool replace);
	void paintCell(QPainter *painter, int row, int col, const QRect &cr, bool selected, const QColorGroup &cg);
    
	void resizeData(int) {}
	QTableItem *item(int, int) { return 0; }
	void setItem(int, int, QTableItem *) {}
	void clearCell(int, int) {}
	void insertWidget(int, int, QWidget *) {}
	void clearCellWidget(int, int) {}

	void updateTable();
private slots:
	void updateContents() {QTable::updateContents();}
private:
	int size;
	double *array;
	mutable QLineEdit *editor;
};

#endif

