//LabPlot : NoiseListDialog.cc

#include "NoiseListDialog.h"
#include "noise.h"

#ifdef HAVE_GSL
#include <gsl/gsl_rng.h>
#include <gsl/gsl_randist.h>
#endif

NoiseListDialog::NoiseListDialog(MainWin *m, const char *name)
	: ListDialog(m, name)
{
	kdDebug()<<"NoiseListDialog()"<<endl;
	setCaption(i18n("Noise Dialog"));
	KConfig *config = mw->Config();
	config->setGroup( "Noise" );

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	QHBox *hb = new QHBox(tab1);
	new QLabel(i18n("Type of random distribution : "),hb);
	typecb = new KComboBox(hb);
	int i=0;
	while(noisetypes[i] != 0) typecb->insertItem(i18n(noisetypes[i++]));
	typecb->setCurrentItem(config->readNumEntry("Type",0));
	QObject::connect(typecb,SIGNAL(activated (int)),SLOT(updateType(int)));

	hb = new QHBox(tab1);
	label1 = new QLabel("",hb);
	par1le = new KLineEdit(config->readEntry("Parameter1","1"),hb);
	par1le->setValidator(new QDoubleValidator(par1le));

	hb = new QHBox(tab1);
	label2 = new QLabel("",hb);
	par2le = new KLineEdit(config->readEntry("Parameter2","1"),hb);
	par2le->setValidator(new QDoubleValidator(par2le));

	hb = new QHBox(tab1);
	label3 = new QLabel("",hb);
	par3le = new KLineEdit(config->readEntry("Parameter3","1"),hb);
	par3le->setValidator(new QDoubleValidator(par3le));

	updateType(0);

	Style *style=0;
	Symbol *symbol=0;
	QVBox *styletab;
	if(p && p->getPlot(p->API())->Type() == PSURFACE) {
		styletab = surfaceStyle(tw,true);
	}
	else {
		styletab = simpleStyle(tw, style, symbol);
	}

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	QObject::connect(save,SIGNAL(clicked()),SLOT(saveSettings()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void NoiseListDialog::saveSettings() {
	KConfig *config = mw->Config();
	config->setGroup( "Noise" );

	config->writeEntry("Type",typecb->currentItem());
	config->writeEntry("Parameter1",par1le->text());
	config->writeEntry("Parameter2",par2le->text());
	config->writeEntry("Parameter3",par3le->text());
}

void NoiseListDialog::updateType(int ntype) {
	label1->show();par1le->show();
	label2->hide();par2le->hide();
	label3->hide();par3le->hide();
	switch(ntype) {
	case GAUSSIAN: label1->setText(i18n("Standard Deviation : ")); break;
	case GAUSSIAN_TAIL: case RAYLEIGH_TAIL:
		label1->setText(i18n("a : ")); label2->setText(i18n("sigma : ")); label2->show(); par2le->show(); break;
	case EXPONENTIAL: case POISSON: label1->setText(i18n("mu : ")); break;
	case LAPLACE: case CAUCHY: case LOGISTIC : label1->setText(i18n("a : ")); break;
	case EXPONENTIAL_POWER: case NGAMMA: case FLAT: case BETA: case PARETO: case WEIBULL: case GUMBEL1:
	case GUMBEL2:
		label1->setText(i18n("a : ")); label2->setText(i18n("b : ")); label2->show(); par2le->show(); break;
	case RAYLEIGH: label1->setText(i18n("sigma : ")); break;
	case LANDAU: label1->hide(); par1le->hide(); break;
	case LEVY: label1->setText(i18n("c : ")); label2->setText(i18n("alpha : ")); label2->show(); par2le->show(); break;
	case LEVY_SKEW: label1->setText(i18n("c : ")); label2->setText(i18n("alpha : ")); label2->setText(i18n("beta : "));
		label2->show(); par2le->show(); label3->show(); par3le->show(); break;
	case LOGNORMAL: label1->setText(i18n("zeta : ")); label2->setText(i18n("sigma : ")); label2->show(); par2le->show(); break;
	case CHISQ: case TDIST: label1->setText(i18n("nu : ")); break;
	case FDIST: label1->setText(i18n("nu1 : ")); label2->setText(i18n("nu2 : ")); label2->show(); par2le->show(); break;
	case BERNOULLI: label1->setText(i18n("p : ")); break;
	case BINOMIAL: case BINOMIAL_NEG: case PASCAL:
		label1->setText(i18n("p : ")); label2->setText(i18n("n : ")); label2->show(); par2le->show(); break;
	case GEOMETRIC: case LOGARITHMIC: label1->setText(i18n("p : ")); break;
	case HYPERGEOMETRIC: label1->setText(i18n("n1 : ")); label2->setText(i18n("n2 : ")); label2->setText(i18n("t : "));
		label2->show(); par2le->show(); label3->show(); par3le->show(); break;
	}
}

int NoiseListDialog::apply_clicked() {
	kdDebug()<<"NoiseListDialog::apply_clicked()"<<endl;

	// get data
	int n=0;
	QString label;
	Point *ptr = 0;
	double *zdata=0, *tdata=0;
	if(s) {
		Graph2D *g = s->getGraph2D();
		n = g->Number();
		ptr = new Point[n];
		for(int i=0;i<n;i++)
			ptr[i].setPoint(g->Data()[i].X(),g->Data()[i].Y());
		label = g->getLabel()->simpleTitle();
	}
	else if(p) {
		GraphList *gl = p->getPlot(p->API())->getGraphList();
		int item = (int) (lv->itemPos(lv->currentItem())/lv->currentItem()->height());
		GRAPHType st = gl->getType(item);

		Graph *g = gl->getGraph(item);
		n = g->Number();
		label = g->getLabel()->simpleTitle();
		ptr = new Point[n];
		if (st == GRAPH2D) {
			Graph2D *g = gl->getGraph2D(item);
			for(int i=0;i<n;i++)
				ptr[i].setPoint(g->Data()[i].X(),g->Data()[i].Y());
		}
		else if (st == GRAPH3D) {
			Graph3D *g = gl->getGraph3D(item);
			zdata = new double[n];
			for(int i=0;i<n;i++) {
				ptr[i].setPoint(g->Data()[i].X(),g->Data()[i].Y());
				zdata[i] = g->Data()[i].Z();
			}
		}
		else if (st == GRAPH4D) {
			Graph4D *g = gl->getGraph4D(item);
			zdata = new double[n];
			tdata = new double[n];
			for(int i=0;i<n;i++) {
				ptr[i].setPoint(g->Data()[i].X(),g->Data()[i].Y());
				zdata[i] = g->Data()[i].Z();
				tdata[i] = g->Data()[i].T();
			}
		}
	}

	if(ptr == 0) {
		KMessageBox::error(this,i18n("Sorry. This function is not yet implemented!"));
		return -1;
	}

#ifdef HAVE_GSL
	int type = typecb->currentItem();
	double par1 = par1le->text().toDouble();
	double par2 = par2le->text().toDouble();
	double par3 = par3le->text().toDouble();
	const gsl_rng_type* rngtype = gsl_rng_default;
	gsl_rng* rng = gsl_rng_alloc(rngtype);

	if( rng != NULL ) {
		for(int i=0; i<n; i++ ) {
			//TODO
			switch(type) {
			case GAUSSIAN: ptr[i].setY(ptr[i].Y() + gsl_ran_gaussian(rng,par1)); break;
			case GAUSSIAN_TAIL: ptr[i].setY(ptr[i].Y() + gsl_ran_gaussian_tail(rng,par1,par2)); break;
			case EXPONENTIAL: ptr[i].setY(ptr[i].Y() + gsl_ran_exponential(rng,par1)); break;
			case LAPLACE: ptr[i].setY(ptr[i].Y() + gsl_ran_laplace(rng,par1)); break;
			case EXPONENTIAL_POWER: ptr[i].setY(ptr[i].Y() + gsl_ran_exppow(rng,par1,par2)); break;
			case CAUCHY: ptr[i].setY(ptr[i].Y() + gsl_ran_cauchy(rng,par1)); break;
			case RAYLEIGH: ptr[i].setY(ptr[i].Y() + gsl_ran_rayleigh(rng,par1)); break;
			case RAYLEIGH_TAIL: ptr[i].setY(ptr[i].Y() + gsl_ran_rayleigh_tail(rng,par1,par2)); break;
			case LANDAU: ptr[i].setY(ptr[i].Y() + gsl_ran_landau(rng)); break;
			case LEVY: ptr[i].setY(ptr[i].Y() + gsl_ran_levy(rng,par1,par2)); break;
			case LEVY_SKEW: ptr[i].setY(ptr[i].Y() + gsl_ran_levy_skew(rng,par1,par2,par3)); break;
			case NGAMMA: ptr[i].setY(ptr[i].Y() + gsl_ran_gamma(rng,par1,par2)); break;
			case FLAT: ptr[i].setY(ptr[i].Y() + gsl_ran_flat(rng,par1,par2)); break;
			case LOGNORMAL: ptr[i].setY(ptr[i].Y() + gsl_ran_lognormal(rng,par1,par2)); break;
			case CHISQ: ptr[i].setY(ptr[i].Y() + gsl_ran_chisq(rng,par1)); break;
			case FDIST: ptr[i].setY(ptr[i].Y() + gsl_ran_fdist(rng,par1,par2)); break;
			case TDIST: ptr[i].setY(ptr[i].Y() + gsl_ran_tdist(rng,par1)); break;
			case BETA: ptr[i].setY(ptr[i].Y() + gsl_ran_beta(rng,par1,par2)); break;
			case LOGISTIC: ptr[i].setY(ptr[i].Y() + gsl_ran_logistic(rng,par1)); break;
			case PARETO: ptr[i].setY(ptr[i].Y() + gsl_ran_pareto(rng,par1,par2)); break;
			case WEIBULL: ptr[i].setY(ptr[i].Y() + gsl_ran_weibull(rng,par1,par2)); break;
			case GUMBEL1: ptr[i].setY(ptr[i].Y() + gsl_ran_gumbel1(rng,par1,par2)); break;
			case GUMBEL2: ptr[i].setY(ptr[i].Y() + gsl_ran_gumbel2(rng,par1,par2)); break;
			case POISSON: ptr[i].setY(ptr[i].Y() + gsl_ran_poisson(rng,par1)); break;
			case BERNOULLI: ptr[i].setY(ptr[i].Y() + gsl_ran_bernoulli(rng,par1)); break;
			case BINOMIAL: ptr[i].setY(ptr[i].Y() + gsl_ran_binomial(rng,par1,(unsigned int) par2)); break;
			case BINOMIAL_NEG: ptr[i].setY(ptr[i].Y() + gsl_ran_negative_binomial(rng,par1,par2)); break;
			case PASCAL: ptr[i].setY(ptr[i].Y() + gsl_ran_pascal(rng,par1,(unsigned int) par2)); break;
			case GEOMETRIC: ptr[i].setY(ptr[i].Y() + gsl_ran_geometric(rng,par1)); break;
			case HYPERGEOMETRIC: ptr[i].setY(ptr[i].Y() +
				gsl_ran_hypergeometric(rng,(unsigned int) par1,(unsigned int) par2,(unsigned int) par3)); break;
			case LOGARITHMIC: ptr[i].setY(ptr[i].Y() + gsl_ran_logarithmic(rng,par1)); break;
			}
		}
	}
	gsl_rng_free( rng );

	QString fun = QString(i18n("Noise of ")+label);
	Style *style = 0;
	Symbol *symbol = 0;
	if(p) {
		style = new Style((StylesType)cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),
			width->value(),pencb->currentItem(),brushcb->currentItem());
		style->setBoxWidth(boxwidth->value());
		style->setAutoBoxWidth(autobox->isChecked());
		style->setPointsSorting(sortpointscb->isChecked());
		symbol = new Symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->value(),
			(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
	}

	// create new graph
	if(zdata == 0) {	// Graph2D
		double xmin=0, xmax=1, ymin=0, ymax=1;
		mw->calculateRanges2D(ptr,n,&xmin,&xmax,&ymin,&ymax);

		LRange range[2];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);

		Graph2D *ng = new Graph2D(fun,fun,range,SSPREADSHEET,P2D,style,symbol,ptr,n);
		//TODO : spreadsheet : select destination
		mw->addGraph2D(ng,p?sheetcb->currentItem():0);
	}
	else if (tdata == 0) {	// Graph3D
		Point3D *ptr3 = new Point3D[n];
		for(int i=0;i<n;i++)
			ptr3[i].setPoint(ptr[i].X(),ptr[i].Y(),zdata[i]);

		double xmin=0, xmax=1, ymin=0, ymax=1, zmin=0, zmax=1;
		mw->calculateRanges3D(ptr3,n,&xmin,&xmax,&ymin,&ymax,&zmin,&zmax);
		LRange range[3];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);
		range[2] = LRange(zmin,zmax);

		Graph3D *ng = new Graph3D(fun,fun,range,SSPREADSHEET,P2D,style,symbol,ptr3,n,1);
		//TODO : spreadsheet : select destination
		mw->addGraph3D(ng,p?sheetcb->currentItem():0,P2D);
	}
	else {	// Graph4D
		Point4D *ptr4 = new Point4D[n];
		for(int i=0;i<n;i++)
			ptr4[i].setPoint(ptr[i].X(),ptr[i].Y(),zdata[i],tdata[i]);

		double xmin=0, xmax=1, ymin=0, ymax=1, zmin=0, zmax=1,tmin=0,tmax=1;
		mw->calculateRanges4D(ptr4,n,&xmin,&xmax,&ymin,&ymax,&zmin,&zmax,&tmin,&tmax);
		LRange range[4];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);
		range[2] = LRange(zmin,zmax);
		range[3] = LRange(tmin,tmax);

		Graph4D *ng = new Graph4D(fun,fun,range,SSPREADSHEET,P2D,style,symbol,ptr4,n);
		//TODO : spreadsheet : select destination
		mw->addGraph4D(ng,p?sheetcb->currentItem():0);
	}
#endif
	if(p) updateList();

	return 0;
}
