dnl -*- shell-script -*-
dnl
dnl $Id: cxx_have_bool.m4,v 1.1 2000/10/17 12:05:16 jsquyres Exp $
dnl

define([LSC_CXX_HAVE_BOOL],[
#
# Arguments: prefix (optional)
#
# Dependencies: None
#
# Check to see if the C++ compiler has the bool type.  <sigh>
#
# Defines prefix_CXX_BOOL to be 1 or 0
# Sets prefix_CXX_BOOL to be 1 or 0
#

# Figure out what prefix to use
lsc_prefix="$1"
if test "$lsc_prefix" = ""; then
    lsc_prefix="LSC"
fi

# See if we've got it
if test "$?CXXFLAGS" = 0; then
    CXXFLAGS=""
fi
AC_MSG_CHECKING([for type bool])
rm -f conftest.cc conftest.o
cat > conftest.cc <<EOF
#include <stdio.h>
#include <sys/types.h>

int main(int argc, char* argv[]) {
  bool foo = (bool) 0;
  printf("so foo is used and the compiler wont complain: %d", (int) foo);
  return 0;
}
EOF
echo configure:__oline__: $CXX $CXXFLAGS conftest.cc -o conftest >&5 
$CXX $CXXFLAGS conftest.cc -o conftest >&5 2>&5
if test -f conftest; then
    lsc_result=1
    AC_MSG_RESULT([yes])
else
    echo configure:__oline__: here is the program that failed: >&5
    cat conftest.cc >&5
    lsc_result_CXX_BOOL=0
    AC_MSG_RESULT([no])
fi

# Set the results
lsc_name="${lsc_prefix}_CXX_BOOL"
lsc_str="${lsc_name}=$lsc_result"
eval $lsc_str
AC_DEFINE_UNQUOTED($lsc_name, $lsc_result)

# Clean up
rm -f conftest*
unset lsc_prefix lsc_name lsc_str lsc_result])dnl

