dnl -*- shell-script -*-

#
# $Id: lam_get_sizeof_fortran_type.m4,v 1.1.2.1 2001/11/09 20:53:13 brbarret Exp $
#
# This file is part of the University of Notre Dame implementation of
# LAM/MPI.  See the LICENSE file in the top-level directory for
# license and copyright details.

define(LAM_GET_SIZEOF_FORTRAN_TYPE,[
# Determine FORTRAN datatype size.
# First arg is type, 2nd (optional) arg is config var to define.
AC_MSG_CHECKING(size of FORTRAN $1)
lam_ac_size_fn=
if test "x$lam_ac_doubleunder" = xy || test "x$lam_ac_singleunder" = xy; then
    lam_ac_size_fn=size_
else
    if test "x$lam_ac_nounder" = xy; then
	    lam_ac_size_fn=size
    else 
	if test "x$lam_ac_caps" = xy; then
	    lam_ac_size_fn=SIZE
	else
	    AC_MSG_ERROR(FORTRAN external naming convention undefined)
	fi
    fi
fi
if test -n "$lam_ac_size_fn"; then
cat > conftestf.f <<EOF
       program fsize
       external SIZE
       $1 x(2)
       call SIZE(x(1),x(2))
       end
EOF
cat > conftest.c <<EOF
#include <stdio.h>
#ifdef __cplusplus
extern "C" {
void exit(int);
#endif
void $lam_ac_size_fn(char *a, char *b)
{
    int diff = (int) (b - a);
    FILE *f=fopen("conftestval", "w");
    if (!f) exit(1);
    fprintf(f, "%d\n", diff);
}
#ifdef __cplusplus
}
#endif
EOF
$CC $CFLAGS -c conftest.c 1>&5 2>&1
if test ! -s conftest.o; then
    AC_MSG_WARN(error compiling/running conftest)
else
    $F77 $FFLAGS conftestf.f conftest.o -o conftest  1>&5 2>&1
    if test -s conftest && (./conftest; exit) 2>/dev/null; then
	lam_ac_fortsize=`cat conftestval`
	AC_MSG_RESULT($lam_ac_fortsize)
	if test -n "$2"; then
	    AC_DEFINE_UNQUOTED($2,$lam_ac_fortsize)
	fi
    else
	AC_MSG_WARN(Error compiling/running conftest)
    fi
fi
fi
/bin/rm -f conftest*])dnl
