// $Id: signal.cc,v 1.1.1.1.2.1 2001/10/29 04:32:58 bbarrett Exp $
//
// Copyright 1997-2001, University of Notre Dame.
// Authors: Jeffrey M. Squyres, Jeremy G. Siek, Michael P. McNally, and
//          Andrew Lumsdaine
// 
// This file is part of the Notre Dame C++ bindings for MPI.
// 
// You should have received a copy of the License Agreement for the Notre
// Dame C++ bindings for MPI along with the software; see the file
// LICENSE.  If not, contact Office of Research, University of Notre
// Dame, Notre Dame, IN 46556.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted subject to the conditions specified in the
// LICENSE file.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
// IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
// 
// Additional copyrights may follow.
//

#include <signal.h>
#include <iostream.h>
#include "mpi2c++_test.h"


//
// Local variables
//

struct signal_map {
  int number;
  const char *name;
  struct sigaction *old_action;
};

struct signal_map block_me[] = {
  { SIGHUP, "Hangup", 0 },
  { SIGINT, "Interrupt",0  },
  { SIGQUIT, "Quit", 0 },
  { SIGTRAP, "IOT Trap", 0 },
  { SIGFPE, "Floating point exception", 0 },
  { SIGBUS, "Bus error", 0 },
  { SIGSEGV, "Segmentation fault", 0 },
  { SIGTERM, "Terminate", 0 },
  { SIGSTOP, "Stop", 0 },
  { SIGIOT, "IOT instruction", 0 },
  { SIGABRT, "Signal abort", 0 },
  { -1, (char *) -1, (struct sigaction *) -1 },
};


//
// Local functions
//

extern "C" {
#if MPI2CPP_BSD_SIGNAL
typedef void (*signal_handler)(...);
void handler(int sig, int code, struct sigcontext *scp, char *addr);
#elif MPI2CPP_SYSV_SIGNAL
typedef void (*signal_handler)(int);
void handler(int sig);
#endif
}


//
// init_signals
//
void
signal_init()
{
#if MPI2CPP_BSD_SIGNAL
  int i;
  struct sigaction n;

  n.sa_handler= (signal_handler) handler;
  n.sa_mask= 0;
  n.sa_flags= 0;

  for (i= 0; block_me[i].number >= 0; i++) {
    // some compilers are very picky...
    block_me[i].old_action= (struct sigaction *) new 
      char[sizeof(struct sigaction)];
    sigaction(block_me[i].number, &n, block_me[i].old_action);
  }
#elif MPI2CPP_SYSV_SIGNAL
  int i;

  for (i= 0; block_me[i].number >= 0; i++)
    signal(block_me[i].number, handler);
#endif
}


//
// handler
//
#if MPI2CPP_BSD_SIGNAL
void 
handler(int sig, int code, struct sigcontext *scp, char *addr)
#elif MPI2CPP_SYSV_SIGNAL
void 
handler(int sig)
#endif
{
  int i;

  // So that g++ -Wall won't complain

#if MPI2CPP_BSD_SIGNAL
  i= code;
  i= (int) scp;
  i= (int) addr;
#endif

  // Find the name

  for (i= 0; block_me[i].number >= 0; i++)
    if (block_me[i].number == sig)
      break;
  
  cout << endl << endl << "MPI2C++ test suite (rank " << my_rank << "): ";
  if (block_me[i].number == -1)
    cout << "Unknown signal (" << sig << ") caught";
  else
    cout << block_me[i].name;
  cout << endl << "MPI2C++ test suite: aborting..." << endl;
  cout.flush();
    
  // Try to abort
  
  MPI::COMM_WORLD.Abort(MPI::ERR_OTHER);
  
  // Should never get here

  if (my_rank <= 0)
    cerr << "MPI2C++ test suite: terminated" << endl << endl;

  exit(MPI::ERR_OTHER);
}

