// -*- c++ -*-
//
// $Id: perrhandler.h,v 1.1.1.1.2.1 2001/10/29 04:33:21 bbarrett Exp $
//
// Copyright 1997-2001, University of Notre Dame.
// Authors: Jeffrey M. Squyres, Jeremy G. Siek, Michael P. McNally, and
//          Andrew Lumsdaine
// 
// This file is part of the Notre Dame C++ bindings for MPI.
// 
// You should have received a copy of the License Agreement for the Notre
// Dame C++ bindings for MPI along with the software; see the file
// LICENSE.  If not, contact Office of Research, University of Notre
// Dame, Notre Dame, IN 46556.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted subject to the conditions specified in the
// LICENSE file.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
// IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
// 
// Additional copyrights may follow.
//

class Errhandler {
public:
  // construction
  inline Errhandler()
    : mpi_errhandler(MPI_ERRHANDLER_NULL) {}
  // inter-language operability
  inline Errhandler(const MPI_Errhandler &i)
    : mpi_errhandler(i) {}
  // copy
  inline Errhandler(const Errhandler& e);

  inline virtual ~Errhandler() {}

  inline Errhandler& operator=(const Errhandler& e);

  // comparison
  inline MPI2CPP_BOOL_T operator==(const Errhandler &a);

  inline MPI2CPP_BOOL_T operator!=(const Errhandler &a) {
    return (MPI2CPP_BOOL_T)!(*this == a); }

  // inter-language operability
  inline Errhandler& operator= (const MPI_Errhandler &i) {
    mpi_errhandler = i; return *this; }
 
  inline operator MPI_Errhandler() const { return mpi_errhandler; }
 
  inline operator MPI_Errhandler*() { return &mpi_errhandler; }
  
  //
  // Errhandler access functions
  //
  
  inline virtual void Free(void);

  Comm::Errhandler_fn* handler_fn;

protected:
  MPI_Errhandler mpi_errhandler;

public:
  //this is for ERRORS_THROW_EXCEPTIONS
  //this is called from MPI::Real_init
  // g++ doesn't understand friends so this must be public :(
  inline void init() const {
    (void)MPI_Errhandler_create(&throw_excptn_fctn,
				(MPI_Errhandler *)&mpi_errhandler); 
  }
};
