/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.28
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

/***********************************************************************
 *
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 *
 ************************************************************************/

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC)
#   if (__SUNPRO_CC <= 0x560)
#     define SWIGTEMPLATEDISAMBIGUATOR template
#   else
#     define SWIGTEMPLATEDISAMBIGUATOR 
#   endif
# else
#   define SWIGTEMPLATEDISAMBIGUATOR 
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__)) 
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__)) 
# else
#   define SWIGUNUSED 
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods for Windows DLLs */
#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   define SWIGEXPORT
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif


/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTELC__)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" } };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  (*jenv)->ExceptionClear(jenv);
  excep = (*jenv)->FindClass(jenv, except_ptr->java_exception);
  if (excep)
    (*jenv)->ThrowNew(jenv, excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else

/*  Errors in SWIG */
#define  SWIG_UnknownError    	   -1 
#define  SWIG_IOError        	   -2 
#define  SWIG_RuntimeError   	   -3 
#define  SWIG_IndexError     	   -4 
#define  SWIG_TypeError      	   -5 
#define  SWIG_DivisionByZero 	   -6 
#define  SWIG_OverflowError  	   -7 
#define  SWIG_SyntaxError    	   -8 
#define  SWIG_ValueError     	   -9 
#define  SWIG_SystemError    	   -10
#define  SWIG_AttributeError 	   -11
#define  SWIG_MemoryError    	   -12 
#define  SWIG_NullReferenceError   -13




SWIGINTERN void SWIG_JavaException(JNIEnv *jenv, int code, const char *msg) {
  SWIG_JavaExceptionCodes exception_code = SWIG_JavaUnknownError;
  switch(code) {
  case SWIG_MemoryError:
    exception_code = SWIG_JavaOutOfMemoryError;
    break;
  case SWIG_IOError:
    exception_code = SWIG_JavaIOException;
    break;
  case SWIG_SystemError:
  case SWIG_RuntimeError:
    exception_code = SWIG_JavaRuntimeException;
    break;
  case SWIG_OverflowError:
  case SWIG_IndexError:
    exception_code = SWIG_JavaIndexOutOfBoundsException;
    break;
  case SWIG_DivisionByZero:
    exception_code = SWIG_JavaArithmeticException;
    break;
  case SWIG_SyntaxError:
  case SWIG_ValueError:
  case SWIG_TypeError:
    exception_code = SWIG_JavaIllegalArgumentException;
    break;
  case SWIG_UnknownError:
  default:
    exception_code = SWIG_JavaUnknownError;
    break;
  }
  SWIG_JavaThrowException(jenv, exception_code, msg);
}



#if defined(SWIGRUBY) || defined (PHP_VERSION)
/* Ruby and PHP pollute the #define space with these names */
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#undef PACKAGE_BUGREPORT
#endif

#include <lasso/lasso_config.h>
#include <lasso/lasso.h>
#include <lasso/xml/lib_assertion.h>
#include <lasso/xml/saml_attribute_value.h>

#ifdef LASSO_WSF_ENABLED
#include <lasso/xml/disco_resource_id.h>
#include <lasso/xml/disco_encrypted_resource_id.h>
#endif



#define bool int
#define false 0
#define true 1



/* 
 * Thanks to the patch in this Debian bug for the solution
 * to the crash inside vsnprintf on some architectures.
 *
 * "reuse of args inside the while(1) loop is in violation of the
 * specs and only happens to work by accident on other systems."
 *
 * http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=104325 
 */

#ifndef va_copy
#ifdef __va_copy
#define va_copy(dest,src) __va_copy(dest,src)
#else
#define va_copy(dest,src) (dest) = (src)
#endif
#endif




static void build_exception_msg(int errorCode, char *errorMsg) {
	if (errorCode > 0) {
		sprintf(errorMsg, "%d / Lasso Warning: %s", errorCode, lasso_strerror(errorCode));
	} else {
		sprintf(errorMsg, "%d / Lasso Error: %s", errorCode, lasso_strerror(errorCode));
	}
}




typedef struct {
void *fix;} DowncastableNode;

DowncastableNode *downcast_node(LassoNode *node) {
	return (DowncastableNode *) node;
}



#include <lasso/errors.h>



static void add_key_to_array(char *key, gpointer pointer, GPtrArray *array)
{
        g_ptr_array_add(array, g_strdup(key));
}

static void add_node_to_array(gpointer node, GPtrArray *array)
{
	if (node != NULL) {
		g_object_ref(node);
	}
        g_ptr_array_add(array, node);
}

static void add_string_to_array(char *string, GPtrArray *array)
{
	if (string != NULL) {
		string = g_strdup(string);
	}
        g_ptr_array_add(array, string);
}

static void add_xml_to_array(xmlNode *xmlnode, GPtrArray *array)
{
	xmlOutputBufferPtr buf;
	gchar *xmlString;

	buf = xmlAllocOutputBuffer(NULL);
	if (buf == NULL) {
		xmlString = NULL;
	} else {
		xmlNodeDumpOutput(buf, NULL, xmlnode, 0, 1, NULL);
		xmlOutputBufferFlush(buf);
		if (buf->conv == NULL) {
			xmlString = g_strdup(buf->buffer->content);
		} else {
			xmlString = g_strdup(buf->conv->content);
		}
		xmlOutputBufferClose(buf);
	}
	g_ptr_array_add(array, xmlString);
}

static void free_node_array_item(gpointer node, gpointer unused)
{
	if (node != NULL) {
		/* Test added to help debugging. */
		if (LASSO_IS_NODE(node)) {
			lasso_node_destroy(LASSO_NODE(node));
		} else {
			g_object_unref(node);
		}
	}
}

static void free_node_list_item(gpointer node, gpointer unused)
{
	if (node != NULL) {
		/* Test added to help debugging. */
		if (LASSO_IS_NODE(node)) {
			lasso_node_destroy(LASSO_NODE(node));
		} else {
			g_object_unref(node);
		}
	}
}

static void free_string_list_item(char *string, gpointer unused)
{
	if (string != NULL) {
		g_free(string);
	}
}

static void free_xml_list_item(xmlNode *xmlnode, gpointer unused)
{
	if (xmlnode != NULL) {
		xmlFreeNode(xmlnode);
	}
}

static gpointer get_node(gpointer node)
{
	return node == NULL ? NULL : g_object_ref(node);
}

static GPtrArray *get_node_list(GList *nodeList) {
	GPtrArray *nodeArray;

	if (nodeList == NULL) {
		return NULL;
	}
	nodeArray = g_ptr_array_sized_new(g_list_length(nodeList));
	g_list_foreach(nodeList, (GFunc) add_node_to_array, nodeArray);
	return nodeArray;
}

static GPtrArray *get_string_list(GList *stringList) {
	GPtrArray *stringArray;

	if (stringList == NULL) {
		return NULL;
	}
	stringArray = g_ptr_array_sized_new(g_list_length(stringList));
	g_list_foreach(stringList, (GFunc) add_string_to_array, stringArray);
	return stringArray;
}

static GPtrArray *get_xml_list(GList *xmlList) {
	GPtrArray *xmlArray;

	if (xmlList == NULL) {
		return NULL;
	}
	xmlArray = g_ptr_array_sized_new(g_list_length(xmlList));
	g_list_foreach(xmlList, (GFunc) add_xml_to_array, xmlArray);
	return xmlArray;
}

static char* get_xml_string(xmlNode *xmlnode)
{
	xmlOutputBufferPtr buf;
	char *xmlString;

	if (xmlnode == NULL) {
		return NULL;
	}

	buf = xmlAllocOutputBuffer(NULL);
	if (buf == NULL) {
		xmlString = NULL;
	} else {
		xmlNodeDumpOutput(buf, NULL, xmlnode, 0, 1, NULL);
		xmlOutputBufferFlush(buf);
		if (buf->conv == NULL) {
			xmlString = g_strdup(buf->buffer->content);
		} else {
			xmlString = g_strdup(buf->conv->content);
		}
		xmlOutputBufferClose(buf);
	}
	xmlFreeNode(xmlnode);
	return xmlString;
}

static xmlNode *get_string_xml(const char *string) {
	xmlDoc *doc;
	xmlNode *node;

	doc = xmlReadDoc(string, NULL, NULL, XML_PARSE_NONET);
	node = xmlDocGetRootElement(doc);
	if (node != NULL) {
		node = xmlCopyNode(node, 1);
	}
	xmlFreeDoc(doc);

	return node;
}

static void set_node(gpointer *nodePointer, gpointer value)
{
	if (*nodePointer == value) {
		return;
	}
	
	if (*nodePointer != NULL) {
		/* Test added to help debugging. */
		if (LASSO_IS_NODE(*nodePointer)) {
			lasso_node_destroy(LASSO_NODE(*nodePointer));
		} else {
			g_object_unref(*nodePointer);
		}
	}
	*nodePointer = value == NULL ? NULL : g_object_ref(value);
}

static void set_node_list(GList **nodeListPointer, GPtrArray *nodeArray) {
	if (*nodeListPointer != NULL) {
		g_list_foreach(*nodeListPointer, (GFunc) free_node_list_item, NULL);
		g_list_free(*nodeListPointer);
	}

	if (nodeArray == NULL) {
		*nodeListPointer = NULL;
	} else {
		gpointer node;
		int index;

		for (index = 0; index < nodeArray->len; index ++) {
			node = g_ptr_array_index(nodeArray, index);
			if (node != NULL) {
				g_object_ref(node);
			}
			*nodeListPointer = g_list_append(*nodeListPointer, node);
		}
	}
}

static void set_string(char **pointer, char *value)
{
	if (*pointer != NULL) {
		g_free(*pointer);
	}
	*pointer = value == NULL ? NULL : strdup(value);
}

static void set_string_list(GList **stringListPointer, GPtrArray *stringArray) {
	if (*stringListPointer != NULL) {
		g_list_foreach(*stringListPointer, (GFunc) free_string_list_item, NULL);
		g_list_free(*stringListPointer);
	}
	if (stringArray == NULL) {
		*stringListPointer = NULL;
	} else {
		char *string;
		int index;

		for (index = 0; index < stringArray->len; index ++) {
			string = g_ptr_array_index(stringArray, index);
			if (string != NULL) {
				string = g_strdup(string);
			}
			*stringListPointer = g_list_append(*stringListPointer, string);
		}
	}
}

static void set_xml_list(GList **xmlListPointer, GPtrArray *xmlArray) {
	if (*xmlListPointer != NULL) {
		g_list_foreach(*xmlListPointer, (GFunc) free_xml_list_item, NULL);
		g_list_free(*xmlListPointer);
	}
	if (xmlArray == NULL) {
		*xmlListPointer = NULL;
	} else {
		xmlDoc *doc;
		int index;
		xmlNode *node;
		char *xmlString;

		for (index = 0; index < xmlArray->len; index ++) {
			xmlString = g_ptr_array_index(xmlArray, index);
			if (xmlString == NULL) {
				node = NULL;
			} else {
				doc = xmlReadDoc(g_ptr_array_index(xmlArray, index), NULL, NULL,
						 XML_PARSE_NONET);
				if (doc == NULL) {
					continue;
				}
				node = xmlDocGetRootElement(doc);
				if (node != NULL) {
					node = xmlCopyNode(node, 1);
				}
				xmlFreeDoc(doc);
			}
			*xmlListPointer = g_list_append(*xmlListPointer, node);
		}
	}
}

static void set_xml_string(xmlNode **xmlnode, const char* string)
{
	xmlDoc *doc;
	xmlNode *node;

	doc = xmlReadDoc(string, NULL, NULL, XML_PARSE_NONET);
	node = xmlDocGetRootElement(doc);
	if (node != NULL) {
		node = xmlCopyNode(node, 1);
	}
	xmlFreeDoc(doc);

	if (*xmlnode) {
		xmlFreeNode(*xmlnode);
	}

	*xmlnode = node;
}






/* Constructors, destructors & static methods implementations */

#define new_LassoNode lasso_node_new
#define delete_LassoNode lasso_node_destroy

/* Methods implementations */

#define LassoNode_dump(self) lasso_node_dump(LASSO_NODE(self))



typedef GPtrArray LassoNodeList;

SWIGINTERN void LassoNodeList_append(LassoNodeList *self,LassoNode *item){
			if (item != NULL)
				g_object_ref(item);
			g_ptr_array_add(self, item);
		}
SWIGINTERN void *LassoNodeList_cast(LassoNodeList *self){
			return self;
		}
SWIGINTERN LassoNodeList *LassoNodeList_frompointer(void *nodeArray){
			return (LassoNodeList *) nodeArray;
		}
SWIGINTERN LassoNode *LassoNodeList_getItem(LassoNodeList *self,int index){
			LassoNode *item;

			item = g_ptr_array_index(self, index);
			if (item != NULL)
				g_object_ref(item);
			return item;
		}
SWIGINTERN int LassoNodeList_length(LassoNodeList *self){
			return self->len;
		}
SWIGINTERN void LassoNodeList_setItem(LassoNodeList *self,int index,LassoNode *item){
			LassoNode **itemPointer = (LassoNode **) &g_ptr_array_index(self, index);
			if (*itemPointer == item)
				return;

			if (*itemPointer != NULL) {
				/* Test added to help debugging. */
				if (LASSO_IS_NODE(*itemPointer)) {
					lasso_node_destroy(LASSO_NODE(*itemPointer));
				} else {
					g_object_unref(*itemPointer);
				}
			}
			if (item == NULL) {
				*itemPointer = NULL;
			} else {
				*itemPointer = g_object_ref(item);
			}
		}


/* Constructors, destructors & static methods implementations */

#define new_LassoNodeList g_ptr_array_new

void delete_LassoNodeList(GPtrArray *self) {
	g_ptr_array_foreach(self, (GFunc) free_node_array_item, NULL);
	g_ptr_array_free(self, false);
}



typedef GPtrArray LassoStringList;

SWIGINTERN void LassoStringList_append(LassoStringList *self,char *item){
			if (item != NULL)
				item = g_strdup(item);
			g_ptr_array_add(self, item);
		}
SWIGINTERN void *LassoStringList_cast(LassoStringList *self){
			return self;
		}
SWIGINTERN LassoStringList *LassoStringList_frompointer(void *stringArray){
			return (LassoStringList *) stringArray;
		}
SWIGINTERN char *LassoStringList_getItem(LassoStringList *self,int index){
			return g_ptr_array_index(self, index);
		}
SWIGINTERN int LassoStringList_length(LassoStringList *self){
			return self->len;
		}
SWIGINTERN void LassoStringList_setItem(LassoStringList *self,int index,char *item){
			char **itemPointer = (char **) &g_ptr_array_index(self, index);
			if (*itemPointer != NULL) {
				g_free(*itemPointer);
			}
			if (item == NULL) {
				*itemPointer = NULL;
			} else {
				*itemPointer = g_strdup(item);
			}
		}


/* Constructors, destructors & static methods implementations */

#define new_LassoStringList g_ptr_array_new
#define delete_LassoStringList(self) g_ptr_array_free(self, true)




/* Attributes implementations */
/* Assertion */
#define LassoSamlAdvice_get_Assertion(self) get_node((self)->Assertion)
#define LassoSamlAdvice_Assertion_get(self) get_node((self)->Assertion)
#define LassoSamlAdvice_set_Assertion(self, value) set_node((gpointer *) &(self)->Assertion, (value))
#define LassoSamlAdvice_Assertion_set(self, value) set_node((gpointer *) &(self)->Assertion, (value))

/* assertionIdReference */
#define LassoSamlAdvice_get_assertionIdReference(self) get_string_list((self)->AssertionIDReference)
#define LassoSamlAdvice_assertionIdReference_get(self) get_string_list((self)->AssertionIDReference)
#define LassoSamlAdvice_set_assertionIdReference(self, value) set_string_list(&(self)->AssertionIDReference, (value))
#define LassoSamlAdvice_assertionIdReference_set(self, value) set_string_list(&(self)->AssertionIDReference, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlAdvice lasso_saml_advice_new
#define delete_LassoSamlAdvice(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlAdvice_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Attributes Implementations */

/* Advice */
#define LassoSamlAssertion_get_Advice(self) get_node((self)->Advice)
#define LassoSamlAssertion_Advice_get(self) get_node((self)->Advice)
#define LassoSamlAssertion_set_Advice(self, value) set_node((gpointer *) &(self)->Advice, (value))
#define LassoSamlAssertion_Advice_set(self, value) set_node((gpointer *) &(self)->Advice, (value))

/* AttributeStatement */
#define LassoSamlAssertion_get_AttributeStatement(self) get_node((self)->AttributeStatement)
#define LassoSamlAssertion_AttributeStatement_get(self) get_node((self)->AttributeStatement)
#define LassoSamlAssertion_set_AttributeStatement(self, value) set_node((gpointer *) &(self)->AttributeStatement, (value))
#define LassoSamlAssertion_AttributeStatement_set(self, value) set_node((gpointer *) &(self)->AttributeStatement, (value))

/* AuthenticationStatement */
#define LassoSamlAssertion_get_AuthenticationStatement(self) get_node((self)->AuthenticationStatement)
#define LassoSamlAssertion_AuthenticationStatement_get(self) get_node((self)->AuthenticationStatement)
#define LassoSamlAssertion_set_AuthenticationStatement(self, value) set_node((gpointer *) &(self)->AuthenticationStatement, (value))
#define LassoSamlAssertion_AuthenticationStatement_set(self, value) set_node((gpointer *) &(self)->AuthenticationStatement, (value))

/* Conditions */
#define LassoSamlAssertion_get_Conditions(self) get_node((self)->Conditions)
#define LassoSamlAssertion_Conditions_get(self) get_node((self)->Conditions)
#define LassoSamlAssertion_set_Conditions(self, value) set_node((gpointer *) &(self)->Conditions, (value))
#define LassoSamlAssertion_Conditions_set(self, value) set_node((gpointer *) &(self)->Conditions, (value))

/* SubjectStatement */
#define LassoSamlAssertion_get_SubjectStatement(self) get_node((self)->SubjectStatement)
#define LassoSamlAssertion_SubjectStatement_get(self) get_node((self)->SubjectStatement)
#define LassoSamlAssertion_set_SubjectStatement(self, value) set_node((gpointer *) &(self)->SubjectStatement, (value))
#define LassoSamlAssertion_SubjectStatement_set(self, value) set_node((gpointer *) &(self)->SubjectStatement, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlAssertion lasso_saml_assertion_new
#define delete_LassoSamlAssertion(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlAssertion_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of attributes inherited from SamlAttributeDesignator */

/* AttributeName */
#define LassoSamlAttribute_get_AttributeName(self) LASSO_SAML_ATTRIBUTE_DESIGNATOR(self)->AttributeName
#define LassoSamlAttribute_AttributeName_get(self) LASSO_SAML_ATTRIBUTE_DESIGNATOR(self)->AttributeName
#define LassoSamlAttribute_set_AttributeName(self, value) set_string(&LASSO_SAML_ATTRIBUTE_DESIGNATOR(self)->AttributeName, (value))
#define LassoSamlAttribute_AttributeName_set(self, value) set_string(&LASSO_SAML_ATTRIBUTE_DESIGNATOR(self)->AttributeName, (value))

/* AttributeNamespace */
#define LassoSamlAttribute_get_AttributeNamespace(self) LASSO_SAML_ATTRIBUTE_DESIGNATOR(self)->AttributeNamespace
#define LassoSamlAttribute_AttributeNamespace_get(self) LASSO_SAML_ATTRIBUTE_DESIGNATOR(self)->AttributeNamespace
#define LassoSamlAttribute_set_AttributeNamespace(self, value) set_string(&LASSO_SAML_ATTRIBUTE_DESIGNATOR(self)->AttributeNamespace, (value))
#define LassoSamlAttribute_AttributeNamespace_set(self, value) set_string(&LASSO_SAML_ATTRIBUTE_DESIGNATOR(self)->AttributeNamespace, (value))

/* Attributes implementations */

/* AttributeValue */
#define LassoSamlAttribute_get_AttributeValue(self) get_node_list((self)->AttributeValue)
#define LassoSamlAttribute_AttributeValue_get(self) get_node_list((self)->AttributeValue)
#define LassoSamlAttribute_set_AttributeValue(self, value) set_node_list(&(self)->AttributeValue, (value))
#define LassoSamlAttribute_AttributeValue_set(self, value) set_node_list(&(self)->AttributeValue, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlAttribute lasso_saml_attribute_new
#define delete_LassoSamlAttribute(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlAttribute_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Constructors, destructors & static methods implementations */

#define new_LassoSamlAttributeDesignator lasso_saml_attribute_designator_new
#define delete_LassoSamlAttributeDesignator(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlAttributeDesignator_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of attributes inherited from SamlSubjectStatementAbstract */

/* Subject */
#define LassoSamlAttributeStatement_get_Subject(self) get_node(LASSO_SAML_SUBJECT_STATEMENT_ABSTRACT(self)->Subject)
#define LassoSamlAttributeStatement_Subject_get(self) get_node(LASSO_SAML_SUBJECT_STATEMENT_ABSTRACT(self)->Subject)
#define LassoSamlAttributeStatement_set_Subject(self, value) set_node((gpointer *) &LASSO_SAML_SUBJECT_STATEMENT_ABSTRACT(self)->Subject, (value))
#define LassoSamlAttributeStatement_Subject_set(self, value) set_node((gpointer *) &LASSO_SAML_SUBJECT_STATEMENT_ABSTRACT(self)->Subject, (value))

/* Attributes Implementations */

/* Attribute */
#define LassoSamlAttributeStatement_get_Attribute(self) get_node_list((self)->Attribute)
#define LassoSamlAttributeStatement_Attribute_get(self) get_node_list((self)->Attribute)
#define LassoSamlAttributeStatement_set_Attribute(self, value) set_node_list(&(self)->Attribute, (value))
#define LassoSamlAttributeStatement_Attribute_set(self, value) set_node_list(&(self)->Attribute, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlAttributeStatement lasso_saml_attribute_statement_new
#define delete_LassoSamlAttributeStatement(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlAttributeStatement_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Attributes Implementations */

/* any */
#define LassoSamlAttributeValue_get_any(self) get_node_list((self)->any)
#define LassoSamlAttributeValue_any_get(self) get_node_list((self)->any)
#define LassoSamlAttributeValue_set_any(self, value) set_node_list(&(self)->any, (value))
#define LassoSamlAttributeValue_any_set(self, value) set_node_list(&(self)->any, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlAttributeValue lasso_saml_attribute_value_new
#define delete_LassoSamlAttributeValue(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlAttributeValue_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Attributes implementations */

/* audience */
#define LassoSamlAudienceRestrictionCondition_get_audience(self) get_string_list((self)->Audience)
#define LassoSamlAudienceRestrictionCondition_audience_get(self) get_string_list((self)->Audience)
#define LassoSamlAudienceRestrictionCondition_set_audience(self, value) set_string_list(&(self)->Audience, (value))
#define LassoSamlAudienceRestrictionCondition_audience_set(self, value) set_string_list(&(self)->Audience, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlAudienceRestrictionCondition lasso_saml_audience_restriction_condition_new
#define delete_LassoSamlAudienceRestrictionCondition(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlAudienceRestrictionCondition_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Attributes Implementations */

/* AuthorityBinding */
#define LassoSamlAuthenticationStatement_get_AuthorityBinding(self) get_node_list((self)->AuthorityBinding)
#define LassoSamlAuthenticationStatement_AuthorityBinding_get(self) get_node_list((self)->AuthorityBinding)
#define LassoSamlAuthenticationStatement_set_AuthorityBinding(self, value) set_node_list(&(self)->AuthorityBinding, (value))
#define LassoSamlAuthenticationStatement_AuthorityBinding_set(self, value) set_node_list(&(self)->AuthorityBinding, (value))

/* SubjectLocality */
#define LassoSamlAuthenticationStatement_get_SubjectLocality(self) get_node((self)->SubjectLocality)
#define LassoSamlAuthenticationStatement_SubjectLocality_get(self) get_node((self)->SubjectLocality)
#define LassoSamlAuthenticationStatement_set_SubjectLocality(self, value) set_node((gpointer *) &(self)->SubjectLocality, (value))
#define LassoSamlAuthenticationStatement_SubjectLocality_set(self, value) set_node((gpointer *) &(self)->SubjectLocality, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlAuthenticationStatement lasso_saml_authentication_statement_new
#define delete_LassoSamlAuthenticationStatement(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlAuthenticationStatement_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Constructors, destructors & static methods implementations */

#define new_LassoSamlAuthorityBinding lasso_saml_authority_binding_new
#define delete_LassoSamlAuthorityBinding(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlAuthorityBinding_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of methods inherited from LassoNode */

#define LassoSamlConditionAbstract_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Attributes Implementations */

/* AudienceRestrictionCondition */
#define LassoSamlConditions_get_AudienceRestrictionCondition(self) get_node_list((self)->AudienceRestrictionCondition)
#define LassoSamlConditions_AudienceRestrictionCondition_get(self) get_node_list((self)->AudienceRestrictionCondition)
#define LassoSamlConditions_set_AudienceRestrictionCondition(self, value) set_node_list(&(self)->AudienceRestrictionCondition, (value))
#define LassoSamlConditions_AudienceRestrictionCondition_set(self, value) set_node_list(&(self)->AudienceRestrictionCondition, (value))

/* Condition */
#define LassoSamlConditions_get_Condition(self) get_node_list((self)->Condition)
#define LassoSamlConditions_Condition_get(self) get_node_list((self)->Condition)
#define LassoSamlConditions_set_Condition(self, value) set_node_list(&(self)->Condition, (value))
#define LassoSamlConditions_Condition_set(self, value) set_node_list(&(self)->Condition, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlConditions lasso_saml_conditions_new
#define delete_LassoSamlConditions(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlConditions_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Constructors, destructors & static methods implementations */

#define new_LassoSamlNameIdentifier lasso_saml_name_identifier_new
#define delete_LassoSamlNameIdentifier(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlNameIdentifier_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of methods inherited from LassoNode */

#define LassoSamlStatementAbstract_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Attributes implementations */

/* NameIdentifier */
#define LassoSamlSubject_get_NameIdentifier(self) get_node((self)->NameIdentifier)
#define LassoSamlSubject_NameIdentifier_get(self) get_node((self)->NameIdentifier)
#define LassoSamlSubject_set_NameIdentifier(self, value) set_node((gpointer *) &(self)->NameIdentifier, (value))
#define LassoSamlSubject_NameIdentifier_set(self, value) set_node((gpointer *) &(self)->NameIdentifier, (value))

/* SubjectConfirmation */
#define LassoSamlSubject_get_SubjectConfirmation(self) get_node((self)->SubjectConfirmation)
#define LassoSamlSubject_SubjectConfirmation_get(self) get_node((self)->SubjectConfirmation)
#define LassoSamlSubject_set_SubjectConfirmation(self, value) set_node((gpointer *) &(self)->SubjectConfirmation, (value))
#define LassoSamlSubject_SubjectConfirmation_set(self, value) set_node((gpointer *) &(self)->SubjectConfirmation, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlSubject lasso_saml_subject_new
#define delete_LassoSamlSubject(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlSubject_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Attributes implementations */

/* confirmationMethod */
#define LassoSamlSubjectConfirmation_get_confirmationMethod(self) get_string_list((self)->ConfirmationMethod)
#define LassoSamlSubjectConfirmation_confirmationMethod_get(self) get_string_list((self)->ConfirmationMethod)
#define LassoSamlSubjectConfirmation_set_confirmationMethod(self, value) set_string_list(&(self)->ConfirmationMethod, (value))
#define LassoSamlSubjectConfirmation_confirmationMethod_set(self, value) set_string_list(&(self)->ConfirmationMethod, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlSubjectConfirmation lasso_saml_subject_confirmation_new
#define delete_LassoSamlSubjectConfirmation(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlSubjectConfirmation_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Constructors, destructors & static methods implementations */

#define new_LassoSamlSubjectLocality lasso_saml_subject_locality_new
#define delete_LassoSamlSubjectLocality(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlSubjectLocality_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of attributes inherited from SamlSubjectStatementAbstract */

/* Subject */
#define LassoSamlSubjectStatement_get_Subject(self) get_node(LASSO_SAML_SUBJECT_STATEMENT_ABSTRACT(self)->Subject)
#define LassoSamlSubjectStatement_Subject_get(self) get_node(LASSO_SAML_SUBJECT_STATEMENT_ABSTRACT(self)->Subject)
#define LassoSamlSubjectStatement_set_Subject(self, value) set_node((gpointer *) &LASSO_SAML_SUBJECT_STATEMENT_ABSTRACT(self)->Subject, (value))
#define LassoSamlSubjectStatement_Subject_set(self, value) set_node((gpointer *) &LASSO_SAML_SUBJECT_STATEMENT_ABSTRACT(self)->Subject, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlSubjectStatement lasso_saml_subject_statement_new
#define delete_LassoSamlSubjectStatement(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlSubjectStatement_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Attributes implementations */

/* Subject */
#define LassoSamlSubjectStatementAbstract_get_Subject(self) get_node((self)->Subject)
#define LassoSamlSubjectStatementAbstract_Subject_get(self) get_node((self)->Subject)
#define LassoSamlSubjectStatementAbstract_set_Subject(self, value) set_node((gpointer *) &(self)->Subject, (value))
#define LassoSamlSubjectStatementAbstract_Subject_set(self, value) set_node((gpointer *) &(self)->Subject, (value))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlSubjectStatementAbstract_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of attributes inherited from SamlpRequestAbstract */

/* certificate_file */
#define LassoSamlpRequest_get_certificate_file(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file
#define LassoSamlpRequest_certificate_file_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file
#define LassoSamlpRequest_set_certificate_file(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file, (value))
#define LassoSamlpRequest_certificate_file_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file, (value))

/* IssueInstant */
#define LassoSamlpRequest_get_IssueInstant(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoSamlpRequest_IssueInstant_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoSamlpRequest_set_IssueInstant(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant, (value))
#define LassoSamlpRequest_IssueInstant_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant, (value))

/* MajorVersion */
#define LassoSamlpRequest_get_MajorVersion(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion
#define LassoSamlpRequest_MajorVersion_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion
#define LassoSamlpRequest_set_MajorVersion(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion = (value)
#define LassoSamlpRequest_MajorVersion_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion = (value)

/* MinorVersion */
#define LassoSamlpRequest_get_MinorVersion(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion
#define LassoSamlpRequest_MinorVersion_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion
#define LassoSamlpRequest_set_MinorVersion(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion = (value)
#define LassoSamlpRequest_MinorVersion_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion = (value)

/* private_key_file */
#define LassoSamlpRequest_get_private_key_file(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file
#define LassoSamlpRequest_private_key_file_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file
#define LassoSamlpRequest_set_private_key_file(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file, (value))
#define LassoSamlpRequest_private_key_file_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file, (value))

/* RequestID */
#define LassoSamlpRequest_get_RequestID(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID
#define LassoSamlpRequest_RequestID_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID
#define LassoSamlpRequest_set_RequestID(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID, (value))
#define LassoSamlpRequest_RequestID_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID, (value))

/* RespondWith */
#define LassoSamlpRequest_get_RespondWith(self) get_string_list(LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith)
#define LassoSamlpRequest_RespondWith_get(self) get_string_list(LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith)
#define LassoSamlpRequest_set_RespondWith(self, value) set_string_list(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith, (value))
#define LassoSamlpRequest_RespondWith_set(self, value) set_string_list(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith, (value))

/* sign_method */
#define LassoSamlpRequest_get_sign_method(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method
#define LassoSamlpRequest_sign_method_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method
#define LassoSamlpRequest_set_sign_method(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method = (value)
#define LassoSamlpRequest_sign_method_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method = (value)

/* sign_type */
#define LassoSamlpRequest_get_sign_type(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type
#define LassoSamlpRequest_sign_type_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type
#define LassoSamlpRequest_set_sign_type(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type = (value)
#define LassoSamlpRequest_sign_type_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type = (value)

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlpRequest lasso_samlp_request_new
#define delete_LassoSamlpRequest(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlpRequest_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Attributes implementations */

/* RespondWith */
#define LassoSamlpRequestAbstract_get_RespondWith(self) get_string_list((self)->RespondWith)
#define LassoSamlpRequestAbstract_RespondWith_get(self) get_string_list((self)->RespondWith)
#define LassoSamlpRequestAbstract_set_RespondWith(self, value) set_string_list(&(self)->RespondWith, (value))
#define LassoSamlpRequestAbstract_RespondWith_set(self, value) set_string_list(&(self)->RespondWith, (value))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlpRequestAbstract_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of attributes inherited from SamlpResponseAbstract */

/* certificate_file */
#define LassoSamlpResponse_get_certificate_file(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->certificate_file
#define LassoSamlpResponse_certificate_file_get(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->certificate_file
#define LassoSamlpResponse_set_certificate_file(self, value) set_string(&LASSO_SAMLP_RESPONSE_ABSTRACT(self)->certificate_file, (value))
#define LassoSamlpResponse_certificate_file_set(self, value) set_string(&LASSO_SAMLP_RESPONSE_ABSTRACT(self)->certificate_file, (value))

/* InResponseTo */
#define LassoSamlpResponse_get_InResponseTo(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->InResponseTo
#define LassoSamlpResponse_InResponseTo_get(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->InResponseTo
#define LassoSamlpResponse_set_InResponseTo(self, value) set_string(&LASSO_SAMLP_RESPONSE_ABSTRACT(self)->InResponseTo, (value))
#define LassoSamlpResponse_InResponseTo_set(self, value) set_string(&LASSO_SAMLP_RESPONSE_ABSTRACT(self)->InResponseTo, (value))

/* IssueInstant */
#define LassoSamlpResponse_get_IssueInstant(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->IssueInstant
#define LassoSamlpResponse_IssueInstant_get(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->IssueInstant
#define LassoSamlpResponse_set_IssueInstant(self, value) set_string(&LASSO_SAMLP_RESPONSE_ABSTRACT(self)->IssueInstant, (value))
#define LassoSamlpResponse_IssueInstant_set(self, value) set_string(&LASSO_SAMLP_RESPONSE_ABSTRACT(self)->IssueInstant, (value))

/* MajorVersion */
#define LassoSamlpResponse_get_MajorVersion(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->MajorVersion
#define LassoSamlpResponse_MajorVersion_get(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->MajorVersion
#define LassoSamlpResponse_set_MajorVersion(self, value) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->MajorVersion = (value)
#define LassoSamlpResponse_MajorVersion_set(self, value) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->MajorVersion = (value)

/* MinorVersion */
#define LassoSamlpResponse_get_MinorVersion(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->MinorVersion
#define LassoSamlpResponse_MinorVersion_get(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->MinorVersion
#define LassoSamlpResponse_set_MinorVersion(self, value) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->MinorVersion = (value)
#define LassoSamlpResponse_MinorVersion_set(self, value) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->MinorVersion = (value)

/* private_key_file */
#define LassoSamlpResponse_get_private_key_file(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->private_key_file
#define LassoSamlpResponse_private_key_file_get(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->private_key_file
#define LassoSamlpResponse_set_private_key_file(self, value) set_string(&LASSO_SAMLP_RESPONSE_ABSTRACT(self)->private_key_file, (value))
#define LassoSamlpResponse_private_key_file_set(self, value) set_string(&LASSO_SAMLP_RESPONSE_ABSTRACT(self)->private_key_file, (value))

/* Recipient */
#define LassoSamlpResponse_get_Recipient(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->Recipient
#define LassoSamlpResponse_Recipient_get(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->Recipient
#define LassoSamlpResponse_set_Recipient(self, value) set_string(&LASSO_SAMLP_RESPONSE_ABSTRACT(self)->Recipient, (value))
#define LassoSamlpResponse_Recipient_set(self, value) set_string(&LASSO_SAMLP_RESPONSE_ABSTRACT(self)->Recipient, (value))

/* ResponseID */
#define LassoSamlpResponse_get_ResponseID(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->ResponseID
#define LassoSamlpResponse_ResponseID_get(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->ResponseID
#define LassoSamlpResponse_set_ResponseID(self, value) set_string(&LASSO_SAMLP_RESPONSE_ABSTRACT(self)->ResponseID, (value))
#define LassoSamlpResponse_ResponseID_set(self, value) set_string(&LASSO_SAMLP_RESPONSE_ABSTRACT(self)->ResponseID, (value))

/* sign_method */
#define LassoSamlpResponse_get_sign_method(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->sign_method
#define LassoSamlpResponse_sign_method_get(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->sign_method
#define LassoSamlpResponse_set_sign_method(self, value) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->sign_method = (value)
#define LassoSamlpResponse_sign_method_set(self, value) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->sign_method = (value)

/* sign_type */
#define LassoSamlpResponse_get_sign_type(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->sign_type
#define LassoSamlpResponse_sign_type_get(self) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->sign_type
#define LassoSamlpResponse_set_sign_type(self, value) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->sign_type = (value)
#define LassoSamlpResponse_sign_type_set(self, value) LASSO_SAMLP_RESPONSE_ABSTRACT(self)->sign_type = (value)

/* Attributes Implementations */

/* Assertion */
#define LassoSamlpResponse_get_Assertion(self) get_node_list((self)->Assertion)
#define LassoSamlpResponse_Assertion_get(self) get_node_list((self)->Assertion)
#define LassoSamlpResponse_set_Assertion(self, value) set_node_list(&(self)->Assertion, (value))
#define LassoSamlpResponse_Assertion_set(self, value) set_node_list(&(self)->Assertion, (value))

/* Status */
#define LassoSamlpResponse_get_Status(self) get_node((self)->Status)
#define LassoSamlpResponse_Status_get(self) get_node((self)->Status)
#define LassoSamlpResponse_set_Status(self, value) set_node((gpointer *) &(self)->Status, (value))
#define LassoSamlpResponse_Status_set(self, value) set_node((gpointer *) &(self)->Status, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlpResponse lasso_samlp_response_new
#define delete_LassoSamlpResponse(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlpResponse_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of methods inherited from LassoNode */

#define LassoSamlpResponseAbstract_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Attributes Implementations */

/* StatusCode */
#define LassoSamlpStatus_get_StatusCode(self) get_node((self)->StatusCode)
#define LassoSamlpStatus_StatusCode_get(self) get_node((self)->StatusCode)
#define LassoSamlpStatus_set_StatusCode(self, value) set_node((gpointer *) &(self)->StatusCode, (value))
#define LassoSamlpStatus_StatusCode_set(self, value) set_node((gpointer *) &(self)->StatusCode, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlpStatus lasso_samlp_status_new
#define delete_LassoSamlpStatus(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlpStatus_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Attributes Implementations */

/* StatusCode */
#define LassoSamlpStatusCode_get_StatusCode(self) get_node((self)->StatusCode)
#define LassoSamlpStatusCode_StatusCode_get(self) get_node((self)->StatusCode)
#define LassoSamlpStatusCode_set_StatusCode(self, value) set_node((gpointer *) &(self)->StatusCode, (value))
#define LassoSamlpStatusCode_StatusCode_set(self, value) set_node((gpointer *) &(self)->StatusCode, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoSamlpStatusCode lasso_samlp_status_code_new
#define delete_LassoSamlpStatusCode(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlpStatusCode_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of attributes inherited from SamlAssertion */

/* Advice */
#define LassoLibAssertion_get_Advice(self) get_node(LASSO_SAML_ASSERTION(self)->Advice)
#define LassoLibAssertion_Advice_get(self) get_node(LASSO_SAML_ASSERTION(self)->Advice)
#define LassoLibAssertion_set_Advice(self, value) set_node((gpointer *) &LASSO_SAML_ASSERTION(self)->Advice, (value))
#define LassoLibAssertion_Advice_set(self, value) set_node((gpointer *) &LASSO_SAML_ASSERTION(self)->Advice, (value))

/* AssertionID */
#define LassoLibAssertion_get_AssertionID(self) LASSO_SAML_ASSERTION(self)->AssertionID
#define LassoLibAssertion_AssertionID_get(self) LASSO_SAML_ASSERTION(self)->AssertionID
#define LassoLibAssertion_set_AssertionID(self, value) set_string(&LASSO_SAML_ASSERTION(self)->AssertionID, (value))
#define LassoLibAssertion_AssertionID_set(self, value) set_string(&LASSO_SAML_ASSERTION(self)->AssertionID, (value))

/* AttributeStatement */
#define LassoLibAssertion_get_AttributeStatement(self) get_node(LASSO_SAML_ASSERTION(self)->AttributeStatement)
#define LassoLibAssertion_AttributeStatement_get(self) get_node(LASSO_SAML_ASSERTION(self)->AttributeStatement)
#define LassoLibAssertion_set_AttributeStatement(self, value) set_node((gpointer *) &LASSO_SAML_ASSERTION(self)->AttributeStatement, (value))
#define LassoLibAssertion_AttributeStatement_set(self, value) set_node((gpointer *) &LASSO_SAML_ASSERTION(self)->AttributeStatement, (value))

/* AuthenticationStatement */
#define LassoLibAssertion_get_AuthenticationStatement(self) get_node(LASSO_SAML_ASSERTION(self)->AuthenticationStatement)
#define LassoLibAssertion_AuthenticationStatement_get(self) get_node(LASSO_SAML_ASSERTION(self)->AuthenticationStatement)
#define LassoLibAssertion_set_AuthenticationStatement(self, value) set_node((gpointer *) &LASSO_SAML_ASSERTION(self)->AuthenticationStatement, (value))
#define LassoLibAssertion_AuthenticationStatement_set(self, value) set_node((gpointer *) &LASSO_SAML_ASSERTION(self)->AuthenticationStatement, (value))

/* certificate_file */
#define LassoLibAssertion_get_certificate_file(self) LASSO_SAML_ASSERTION(self)->certificate_file
#define LassoLibAssertion_certificate_file_get(self) LASSO_SAML_ASSERTION(self)->certificate_file
#define LassoLibAssertion_set_certificate_file(self, value) set_string(&LASSO_SAML_ASSERTION(self)->certificate_file, (value))
#define LassoLibAssertion_certificate_file_set(self, value) set_string(&LASSO_SAML_ASSERTION(self)->certificate_file, (value))

/* Conditions */
#define LassoLibAssertion_get_Conditions(self) get_node(LASSO_SAML_ASSERTION(self)->Conditions)
#define LassoLibAssertion_Conditions_get(self) get_node(LASSO_SAML_ASSERTION(self)->Conditions)
#define LassoLibAssertion_set_Conditions(self, value) set_node((gpointer *) &LASSO_SAML_ASSERTION(self)->Conditions, (value))
#define LassoLibAssertion_Conditions_set(self, value) set_node((gpointer *) &LASSO_SAML_ASSERTION(self)->Conditions, (value))

/* IssueInstant */
#define LassoLibAssertion_get_IssueInstant(self) LASSO_SAML_ASSERTION(self)->IssueInstant
#define LassoLibAssertion_IssueInstant_get(self) LASSO_SAML_ASSERTION(self)->IssueInstant
#define LassoLibAssertion_set_IssueInstant(self, value) set_string(&LASSO_SAML_ASSERTION(self)->IssueInstant, (value))
#define LassoLibAssertion_IssueInstant_set(self, value) set_string(&LASSO_SAML_ASSERTION(self)->IssueInstant, (value))

/* Issuer */
#define LassoLibAssertion_get_Issuer(self) LASSO_SAML_ASSERTION(self)->Issuer
#define LassoLibAssertion_Issuer_get(self) LASSO_SAML_ASSERTION(self)->Issuer
#define LassoLibAssertion_set_Issuer(self, value) set_string(&LASSO_SAML_ASSERTION(self)->Issuer, (value))
#define LassoLibAssertion_Issuer_set(self, value) set_string(&LASSO_SAML_ASSERTION(self)->Issuer, (value))

/* MajorVersion */
#define LassoLibAssertion_get_MajorVersion(self) LASSO_SAML_ASSERTION(self)->MajorVersion
#define LassoLibAssertion_MajorVersion_get(self) LASSO_SAML_ASSERTION(self)->MajorVersion
#define LassoLibAssertion_set_MajorVersion(self, value) LASSO_SAML_ASSERTION(self)->MajorVersion = (value)
#define LassoLibAssertion_MajorVersion_set(self, value) LASSO_SAML_ASSERTION(self)->MajorVersion = (value)

/* MinorVersion */
#define LassoLibAssertion_get_MinorVersion(self) LASSO_SAML_ASSERTION(self)->MinorVersion
#define LassoLibAssertion_MinorVersion_get(self) LASSO_SAML_ASSERTION(self)->MinorVersion
#define LassoLibAssertion_set_MinorVersion(self, value) LASSO_SAML_ASSERTION(self)->MinorVersion = (value)
#define LassoLibAssertion_MinorVersion_set(self, value) LASSO_SAML_ASSERTION(self)->MinorVersion = (value)

/* private_key_file */
#define LassoLibAssertion_get_private_key_file(self) LASSO_SAML_ASSERTION(self)->private_key_file
#define LassoLibAssertion_private_key_file_get(self) LASSO_SAML_ASSERTION(self)->private_key_file
#define LassoLibAssertion_set_private_key_file(self, value) set_string(&LASSO_SAML_ASSERTION(self)->private_key_file, (value))
#define LassoLibAssertion_private_key_file_set(self, value) set_string(&LASSO_SAML_ASSERTION(self)->private_key_file, (value))

/* sign_method */
#define LassoLibAssertion_get_sign_method(self) LASSO_SAML_ASSERTION(self)->sign_method
#define LassoLibAssertion_sign_method_get(self) LASSO_SAML_ASSERTION(self)->sign_method
#define LassoLibAssertion_set_sign_method(self, value) LASSO_SAML_ASSERTION(self)->sign_method = (value)
#define LassoLibAssertion_sign_method_set(self, value) LASSO_SAML_ASSERTION(self)->sign_method = (value)

/* sign_type */
#define LassoLibAssertion_get_sign_type(self) LASSO_SAML_ASSERTION(self)->sign_type
#define LassoLibAssertion_sign_type_get(self) LASSO_SAML_ASSERTION(self)->sign_type
#define LassoLibAssertion_set_sign_type(self, value) LASSO_SAML_ASSERTION(self)->sign_type = (value)
#define LassoLibAssertion_sign_type_set(self, value) LASSO_SAML_ASSERTION(self)->sign_type = (value)

/* SubjectStatement */
#define LassoLibAssertion_get_SubjectStatement(self) get_node(LASSO_SAML_ASSERTION(self)->SubjectStatement)
#define LassoLibAssertion_SubjectStatement_get(self) get_node(LASSO_SAML_ASSERTION(self)->SubjectStatement)
#define LassoLibAssertion_set_SubjectStatement(self, value) set_node((gpointer *) &LASSO_SAML_ASSERTION(self)->SubjectStatement, (value))
#define LassoLibAssertion_SubjectStatement_set(self, value) set_node((gpointer *) &LASSO_SAML_ASSERTION(self)->SubjectStatement, (value))

/* Implementations of methods inherited from SamlAssertion */

/* Constructors, destructors & static methods implementations */

#define new_LassoLibAssertion lasso_lib_assertion_new
#define delete_LassoLibAssertion(self) lasso_node_destroy(LASSO_NODE(self))
#define LassoLibAssertion_newFull lasso_lib_assertion_new_full

/* Implementations of methods inherited from LassoNode */

#define LassoLibAssertion_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of attributes inherited from SamlpRequestAbstract */

/* certificate_file */
#define LassoLibAuthnRequest_get_certificate_file(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file
#define LassoLibAuthnRequest_certificate_file_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file
#define LassoLibAuthnRequest_set_certificate_file(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file, (value))
#define LassoLibAuthnRequest_certificate_file_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file, (value))

/* IssueInstant */
#define LassoLibAuthnRequest_get_IssueInstant(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoLibAuthnRequest_IssueInstant_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoLibAuthnRequest_set_IssueInstant(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant, (value))
#define LassoLibAuthnRequest_IssueInstant_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant, (value))

/* MajorVersion */
#define LassoLibAuthnRequest_get_MajorVersion(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion
#define LassoLibAuthnRequest_MajorVersion_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion
#define LassoLibAuthnRequest_set_MajorVersion(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion = (value)
#define LassoLibAuthnRequest_MajorVersion_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion = (value)

/* MinorVersion */
#define LassoLibAuthnRequest_get_MinorVersion(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion
#define LassoLibAuthnRequest_MinorVersion_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion
#define LassoLibAuthnRequest_set_MinorVersion(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion = (value)
#define LassoLibAuthnRequest_MinorVersion_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion = (value)

/* private_key_file */
#define LassoLibAuthnRequest_get_private_key_file(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file
#define LassoLibAuthnRequest_private_key_file_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file
#define LassoLibAuthnRequest_set_private_key_file(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file, (value))
#define LassoLibAuthnRequest_private_key_file_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file, (value))

/* RequestID */
#define LassoLibAuthnRequest_get_RequestID(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID
#define LassoLibAuthnRequest_RequestID_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID
#define LassoLibAuthnRequest_set_RequestID(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID, (value))
#define LassoLibAuthnRequest_RequestID_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID, (value))

/* RespondWith */
#define LassoLibAuthnRequest_get_RespondWith(self) get_string_list(LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith)
#define LassoLibAuthnRequest_RespondWith_get(self) get_string_list(LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith)
#define LassoLibAuthnRequest_set_RespondWith(self, value) set_string_list(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith, (value))
#define LassoLibAuthnRequest_RespondWith_set(self, value) set_string_list(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith, (value))

/* sign_method */
#define LassoLibAuthnRequest_get_sign_method(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method
#define LassoLibAuthnRequest_sign_method_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method
#define LassoLibAuthnRequest_set_sign_method(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method = (value)
#define LassoLibAuthnRequest_sign_method_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method = (value)

/* sign_type */
#define LassoLibAuthnRequest_get_sign_type(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type
#define LassoLibAuthnRequest_sign_type_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type
#define LassoLibAuthnRequest_set_sign_type(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type = (value)
#define LassoLibAuthnRequest_sign_type_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type = (value)

/* Attributes Implementations */

/* Extension */
#define LassoLibAuthnRequest_get_Extension(self) get_xml_list((self)->Extension)
#define LassoLibAuthnRequest_Extension_get(self) get_xml_list((self)->Extension)
#define LassoLibAuthnRequest_set_Extension(self, value) set_xml_list(&(self)->Extension, (value))
#define LassoLibAuthnRequest_Extension_set(self, value) set_xml_list(&(self)->Extension, (value))

/* RequestAuthnContext */
#define LassoLibAuthnRequest_get_RequestAuthnContext(self) get_node((self)->RequestAuthnContext)
#define LassoLibAuthnRequest_RequestAuthnContext_get(self) get_node((self)->RequestAuthnContext)
#define LassoLibAuthnRequest_set_RequestAuthnContext(self, value) set_node((gpointer *) &(self)->RequestAuthnContext, (value))
#define LassoLibAuthnRequest_RequestAuthnContext_set(self, value) set_node((gpointer *) &(self)->RequestAuthnContext, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoLibAuthnRequest lasso_lib_authn_request_new
#define delete_LassoLibAuthnRequest(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoLibAuthnRequest_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of attributes inherited from SamlpResponse */

/* Extension */
#define LassoLibAuthnResponse_get_Extension(self) get_xml_list((self)->Extension)
#define LassoLibAuthnResponse_Extension_get(self) get_xml_list((self)->Extension)
#define LassoLibAuthnResponse_set_Extension(self, value) set_xml_list(&(self)->Extension, (value))
#define LassoLibAuthnResponse_Extension_set(self, value) set_xml_list(&(self)->Extension, (value))

/* Status */
#define LassoLibAuthnResponse_get_Status(self) get_node(LASSO_SAMLP_RESPONSE(self)->Status)
#define LassoLibAuthnResponse_Status_get(self) get_node(LASSO_SAMLP_RESPONSE(self)->Status)
#define LassoLibAuthnResponse_set_Status(self, value) set_node((gpointer *) &LASSO_SAMLP_RESPONSE(self)->Status, (value))
#define LassoLibAuthnResponse_Status_set(self, value) set_node((gpointer *) &LASSO_SAMLP_RESPONSE(self)->Status, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoLibAuthnResponse lasso_lib_authn_response_new
#define delete_LassoLibAuthnResponse(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoLibAuthnResponse_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of attributes inherited from SamlpRequestAbstract */

/* certificate_file */
#define LassoLibFederationTerminationNotification_get_certificate_file(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file
#define LassoLibFederationTerminationNotification_certificate_file_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file
#define LassoLibFederationTerminationNotification_set_certificate_file(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file, (value))
#define LassoLibFederationTerminationNotification_certificate_file_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file, (value))

/* IssueInstant */
#define LassoLibFederationTerminationNotification_get_IssueInstant(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoLibFederationTerminationNotification_IssueInstant_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoLibFederationTerminationNotification_set_IssueInstant(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant, (value))
#define LassoLibFederationTerminationNotification_IssueInstant_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant, (value))

/* MajorVersion */
#define LassoLibFederationTerminationNotification_get_MajorVersion(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion
#define LassoLibFederationTerminationNotification_MajorVersion_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion
#define LassoLibFederationTerminationNotification_set_MajorVersion(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion = (value)
#define LassoLibFederationTerminationNotification_MajorVersion_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion = (value)

/* MinorVersion */
#define LassoLibFederationTerminationNotification_get_MinorVersion(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion
#define LassoLibFederationTerminationNotification_MinorVersion_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion
#define LassoLibFederationTerminationNotification_set_MinorVersion(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion = (value)
#define LassoLibFederationTerminationNotification_MinorVersion_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion = (value)

/* private_key_file */
#define LassoLibFederationTerminationNotification_get_private_key_file(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file
#define LassoLibFederationTerminationNotification_private_key_file_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file
#define LassoLibFederationTerminationNotification_set_private_key_file(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file, (value))
#define LassoLibFederationTerminationNotification_private_key_file_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file, (value))

/* RequestID */
#define LassoLibFederationTerminationNotification_get_RequestID(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID
#define LassoLibFederationTerminationNotification_RequestID_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID
#define LassoLibFederationTerminationNotification_set_RequestID(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID, (value))
#define LassoLibFederationTerminationNotification_RequestID_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID, (value))

/* RespondWith */
#define LassoLibFederationTerminationNotification_get_RespondWith(self) get_string_list(LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith)
#define LassoLibFederationTerminationNotification_RespondWith_get(self) get_string_list(LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith)
#define LassoLibFederationTerminationNotification_set_RespondWith(self, value) set_string_list(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith, (value))
#define LassoLibFederationTerminationNotification_RespondWith_set(self, value) set_string_list(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith, (value))

/* sign_method */
#define LassoLibFederationTerminationNotification_get_sign_method(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method
#define LassoLibFederationTerminationNotification_sign_method_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method
#define LassoLibFederationTerminationNotification_set_sign_method(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method = (value)
#define LassoLibFederationTerminationNotification_sign_method_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method = (value)

/* sign_type */
#define LassoLibFederationTerminationNotification_get_sign_type(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type
#define LassoLibFederationTerminationNotification_sign_type_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type
#define LassoLibFederationTerminationNotification_set_sign_type(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type = (value)
#define LassoLibFederationTerminationNotification_sign_type_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type = (value)

/* Attributes implementations */

/* Extension */
#define LassoLibFederationTerminationNotification_get_Extension(self) get_xml_list((self)->Extension)
#define LassoLibFederationTerminationNotification_Extension_get(self) get_xml_list((self)->Extension)
#define LassoLibFederationTerminationNotification_set_Extension(self, value) set_xml_list(&(self)->Extension, (value))
#define LassoLibFederationTerminationNotification_Extension_set(self, value) set_xml_list(&(self)->Extension, (value))

/* NameIdentifier */
#define LassoLibFederationTerminationNotification_get_NameIdentifier(self) get_node((self)->NameIdentifier)
#define LassoLibFederationTerminationNotification_NameIdentifier_get(self) get_node((self)->NameIdentifier)
#define LassoLibFederationTerminationNotification_set_NameIdentifier(self, value) set_node((gpointer *) &(self)->NameIdentifier, (value))
#define LassoLibFederationTerminationNotification_NameIdentifier_set(self, value) set_node((gpointer *) &(self)->NameIdentifier, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoLibFederationTerminationNotification lasso_lib_federation_termination_notification_new
#define delete_LassoLibFederationTerminationNotification(self) lasso_node_destroy(LASSO_NODE(self))
#define LassoLibFederationTerminationNotification_newFull lasso_lib_federation_termination_notification_new_full

/* Implementations of methods inherited from LassoNode */

#define LassoLibFederationTerminationNotification_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of attributes inherited from SamlpRequestAbstract */

/* certificate_file */
#define LassoLibLogoutRequest_get_certificate_file(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file
#define LassoLibLogoutRequest_certificate_file_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file
#define LassoLibLogoutRequest_set_certificate_file(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file, (value))
#define LassoLibLogoutRequest_certificate_file_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file, (value))

/* IssueInstant */
#define LassoLibLogoutRequest_get_IssueInstant(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoLibLogoutRequest_IssueInstant_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoLibLogoutRequest_set_IssueInstant(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant, (value))
#define LassoLibLogoutRequest_IssueInstant_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant, (value))

/* MajorVersion */
#define LassoLibLogoutRequest_get_MajorVersion(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion
#define LassoLibLogoutRequest_MajorVersion_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion
#define LassoLibLogoutRequest_set_MajorVersion(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion = (value)
#define LassoLibLogoutRequest_MajorVersion_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion = (value)

/* MinorVersion */
#define LassoLibLogoutRequest_get_MinorVersion(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion
#define LassoLibLogoutRequest_MinorVersion_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion
#define LassoLibLogoutRequest_set_MinorVersion(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion = (value)
#define LassoLibLogoutRequest_MinorVersion_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion = (value)

/* private_key_file */
#define LassoLibLogoutRequest_get_private_key_file(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file
#define LassoLibLogoutRequest_private_key_file_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file
#define LassoLibLogoutRequest_set_private_key_file(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file, (value))
#define LassoLibLogoutRequest_private_key_file_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file, (value))

/* RequestID */
#define LassoLibLogoutRequest_get_RequestID(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID
#define LassoLibLogoutRequest_RequestID_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID
#define LassoLibLogoutRequest_set_RequestID(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID, (value))
#define LassoLibLogoutRequest_RequestID_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID, (value))

/* RespondWith */
#define LassoLibLogoutRequest_get_RespondWith(self) get_string_list(LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith)
#define LassoLibLogoutRequest_RespondWith_get(self) get_string_list(LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith)
#define LassoLibLogoutRequest_set_RespondWith(self, value) set_string_list(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith, (value))
#define LassoLibLogoutRequest_RespondWith_set(self, value) set_string_list(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith, (value))

/* sign_method */
#define LassoLibLogoutRequest_get_sign_method(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method
#define LassoLibLogoutRequest_sign_method_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method
#define LassoLibLogoutRequest_set_sign_method(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method = (value)
#define LassoLibLogoutRequest_sign_method_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method = (value)

/* sign_type */
#define LassoLibLogoutRequest_get_sign_type(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type
#define LassoLibLogoutRequest_sign_type_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type
#define LassoLibLogoutRequest_set_sign_type(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type = (value)
#define LassoLibLogoutRequest_sign_type_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type = (value)

/* Attributes implementations */

/* Extension */
#define LassoLibLogoutRequest_get_Extension(self) get_xml_list((self)->Extension)
#define LassoLibLogoutRequest_Extension_get(self) get_xml_list((self)->Extension)
#define LassoLibLogoutRequest_set_Extension(self, value) set_xml_list(&(self)->Extension, (value))
#define LassoLibLogoutRequest_Extension_set(self, value) set_xml_list(&(self)->Extension, (value))

/* nameIdentifier */
#define LassoLibLogoutRequest_get_NameIdentifier(self) get_node((self)->NameIdentifier)
#define LassoLibLogoutRequest_NameIdentifier_get(self) get_node((self)->NameIdentifier)
#define LassoLibLogoutRequest_set_NameIdentifier(self, value) set_node((gpointer *) &(self)->NameIdentifier, (value))
#define LassoLibLogoutRequest_NameIdentifier_set(self, value) set_node((gpointer *) &(self)->NameIdentifier, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoLibLogoutRequest lasso_lib_logout_request_new
#define delete_LassoLibLogoutRequest(self) lasso_node_destroy(LASSO_NODE(self))
#define LassoLibLogoutRequest_newFull lasso_lib_logout_request_new_full

/* Implementations of methods inherited from LassoNode */

#define LassoLibLogoutRequest_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of attributes inherited from LibStatusResponse */

/* Extension */
#define LassoLibLogoutResponse_get_Extension(self) get_xml_list(LASSO_LIB_STATUS_RESPONSE(self)->Extension)
#define LassoLibLogoutResponse_Extension_get(self) get_xml_list(LASSO_LIB_STATUS_RESPONSE(self)->Extension)
#define LassoLibLogoutResponse_set_Extension(self, value) set_xml_list(&LASSO_LIB_STATUS_RESPONSE(self)->Extension, (value))
#define LassoLibLogoutResponse_Extension_set(self, value) set_xml_list(&LASSO_LIB_STATUS_RESPONSE(self)->Extension, (value))

/* providerId */
#define LassoLibLogoutResponse_get_ProviderID(self) LASSO_LIB_STATUS_RESPONSE(self)->ProviderID
#define LassoLibLogoutResponse_ProviderID_get(self) LASSO_LIB_STATUS_RESPONSE(self)->ProviderID
#define LassoLibLogoutResponse_set_ProviderID(self, value) set_string(&LASSO_LIB_STATUS_RESPONSE(self)->ProviderID, (value))
#define LassoLibLogoutResponse_ProviderID_set(self, value) set_string(&LASSO_LIB_STATUS_RESPONSE(self)->ProviderID, (value))

/* RelayState */
#define LassoLibLogoutResponse_get_RelayState(self) LASSO_LIB_STATUS_RESPONSE(self)->RelayState
#define LassoLibLogoutResponse_RelayState_get(self) LASSO_LIB_STATUS_RESPONSE(self)->RelayState
#define LassoLibLogoutResponse_set_RelayState(self, value) set_string(&LASSO_LIB_STATUS_RESPONSE(self)->RelayState, (value))
#define LassoLibLogoutResponse_RelayState_set(self, value) set_string(&LASSO_LIB_STATUS_RESPONSE(self)->RelayState, (value))

/* Status */
#define LassoLibLogoutResponse_get_Status(self) get_node(LASSO_LIB_STATUS_RESPONSE(self)->Status)
#define LassoLibLogoutResponse_Status_get(self) get_node(LASSO_LIB_STATUS_RESPONSE(self)->Status)
#define LassoLibLogoutResponse_set_Status(self, value) set_node((gpointer *) &LASSO_LIB_STATUS_RESPONSE(self)->Status, (value))
#define LassoLibLogoutResponse_Status_set(self, value) set_node((gpointer *) &LASSO_LIB_STATUS_RESPONSE(self)->Status, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoLibLogoutResponse lasso_lib_logout_response_new
#define delete_LassoLibLogoutResponse(self) lasso_node_destroy(LASSO_NODE(self))
#define LassoLibLogoutResponse_newFull lasso_lib_logout_response_new_full

/* Implementations of methods inherited from LassoNode */

#define LassoLibLogoutResponse_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of attributes inherited from SamlpRequestAbstract */

/* certificate_file */
#define LassoLibRegisterNameIdentifierRequest_get_certificate_file(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file
#define LassoLibRegisterNameIdentifierRequest_certificate_file_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file
#define LassoLibRegisterNameIdentifierRequest_set_certificate_file(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file, (value))
#define LassoLibRegisterNameIdentifierRequest_certificate_file_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->certificate_file, (value))

/* IssueInstant */
#define LassoLibRegisterNameIdentifierRequest_get_IssueInstant(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoLibRegisterNameIdentifierRequest_IssueInstant_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoLibRegisterNameIdentifierRequest_set_IssueInstant(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant, (value))
#define LassoLibRegisterNameIdentifierRequest_IssueInstant_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->IssueInstant, (value))

/* MajorVersion */
#define LassoLibRegisterNameIdentifierRequest_get_MajorVersion(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion
#define LassoLibRegisterNameIdentifierRequest_MajorVersion_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion
#define LassoLibRegisterNameIdentifierRequest_set_MajorVersion(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion = (value)
#define LassoLibRegisterNameIdentifierRequest_MajorVersion_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MajorVersion = (value)

/* MinorVersion */
#define LassoLibRegisterNameIdentifierRequest_get_MinorVersion(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion
#define LassoLibRegisterNameIdentifierRequest_MinorVersion_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion
#define LassoLibRegisterNameIdentifierRequest_set_MinorVersion(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion = (value)
#define LassoLibRegisterNameIdentifierRequest_MinorVersion_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->MinorVersion = (value)

/* private_key_file */
#define LassoLibRegisterNameIdentifierRequest_get_private_key_file(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file
#define LassoLibRegisterNameIdentifierRequest_private_key_file_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file
#define LassoLibRegisterNameIdentifierRequest_set_private_key_file(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file, (value))
#define LassoLibRegisterNameIdentifierRequest_private_key_file_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->private_key_file, (value))

/* RequestID */
#define LassoLibRegisterNameIdentifierRequest_get_RequestID(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID
#define LassoLibRegisterNameIdentifierRequest_RequestID_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID
#define LassoLibRegisterNameIdentifierRequest_set_RequestID(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID, (value))
#define LassoLibRegisterNameIdentifierRequest_RequestID_set(self, value) set_string(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RequestID, (value))

/* RespondWith */
#define LassoLibRegisterNameIdentifierRequest_get_RespondWith(self) get_string_list(LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith)
#define LassoLibRegisterNameIdentifierRequest_RespondWith_get(self) get_string_list(LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith)
#define LassoLibRegisterNameIdentifierRequest_set_RespondWith(self, value) set_string_list(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith, (value))
#define LassoLibRegisterNameIdentifierRequest_RespondWith_set(self, value) set_string_list(&LASSO_SAMLP_REQUEST_ABSTRACT(self)->RespondWith, (value))

/* sign_method */
#define LassoLibRegisterNameIdentifierRequest_get_sign_method(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method
#define LassoLibRegisterNameIdentifierRequest_sign_method_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method
#define LassoLibRegisterNameIdentifierRequest_set_sign_method(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method = (value)
#define LassoLibRegisterNameIdentifierRequest_sign_method_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_method = (value)

/* sign_type */
#define LassoLibRegisterNameIdentifierRequest_get_sign_type(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type
#define LassoLibRegisterNameIdentifierRequest_sign_type_get(self) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type
#define LassoLibRegisterNameIdentifierRequest_set_sign_type(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type = (value)
#define LassoLibRegisterNameIdentifierRequest_sign_type_set(self, value) LASSO_SAMLP_REQUEST_ABSTRACT(self)->sign_type = (value)

/* Attributes implementations */

/* Extension */
#define LassoLibRegisterNameIdentifierRequest_get_Extension(self) get_xml_list((self)->Extension)
#define LassoLibRegisterNameIdentifierRequest_Extension_get(self) get_xml_list((self)->Extension)
#define LassoLibRegisterNameIdentifierRequest_set_Extension(self, value) set_xml_list(&(self)->Extension, (value))
#define LassoLibRegisterNameIdentifierRequest_Extension_set(self, value) set_xml_list(&(self)->Extension, (value))

/* idpProvidedNameIdentifier */
#define LassoLibRegisterNameIdentifierRequest_get_IDPProvidedNameIdentifier(self) get_node((self)->IDPProvidedNameIdentifier)
#define LassoLibRegisterNameIdentifierRequest_IDPProvidedNameIdentifier_get(self) get_node((self)->IDPProvidedNameIdentifier)
#define LassoLibRegisterNameIdentifierRequest_set_IDPProvidedNameIdentifier(self, value) set_node((gpointer *) &(self)->IDPProvidedNameIdentifier, (value))
#define LassoLibRegisterNameIdentifierRequest_IDPProvidedNameIdentifier_set(self, value) set_node((gpointer *) &(self)->IDPProvidedNameIdentifier, (value))

/* oldProvidedNameIdentifier */
#define LassoLibRegisterNameIdentifierRequest_get_OldProvidedNameIdentifier(self) get_node((self)->OldProvidedNameIdentifier)
#define LassoLibRegisterNameIdentifierRequest_OldProvidedNameIdentifier_get(self) get_node((self)->OldProvidedNameIdentifier)
#define LassoLibRegisterNameIdentifierRequest_set_OldProvidedNameIdentifier(self, value) set_node((gpointer *) &(self)->OldProvidedNameIdentifier, (value))
#define LassoLibRegisterNameIdentifierRequest_OldProvidedNameIdentifier_set(self, value) set_node((gpointer *) &(self)->OldProvidedNameIdentifier, (value))

/* spProvidedNameIdentifier */
#define LassoLibRegisterNameIdentifierRequest_get_SPProvidedNameIdentifier(self) get_node((self)->SPProvidedNameIdentifier)
#define LassoLibRegisterNameIdentifierRequest_SPProvidedNameIdentifier_get(self) get_node((self)->SPProvidedNameIdentifier)
#define LassoLibRegisterNameIdentifierRequest_set_SPProvidedNameIdentifier(self, value) set_node((gpointer *) &(self)->SPProvidedNameIdentifier, (value))
#define LassoLibRegisterNameIdentifierRequest_SPProvidedNameIdentifier_set(self, value) set_node((gpointer *) &(self)->SPProvidedNameIdentifier, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoLibRegisterNameIdentifierRequest lasso_lib_register_name_identifier_request_new
#define delete_LassoLibRegisterNameIdentifierRequest(self) lasso_node_destroy(LASSO_NODE(self))
#define LassoLibRegisterNameIdentifierRequest_newFull lasso_lib_register_name_identifier_request_new_full

/* Implementations of methods inherited from LassoNode */

#define LassoLibRegisterNameIdentifierRequest_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Implementations of attributes inherited from LibStatusResponse */

/* Extension */
#define LassoLibRegisterNameIdentifierResponse_get_Extension(self) get_xml_list(LASSO_LIB_STATUS_RESPONSE(self)->Extension)
#define LassoLibRegisterNameIdentifierResponse_Extension_get(self) get_xml_list(LASSO_LIB_STATUS_RESPONSE(self)->Extension)
#define LassoLibRegisterNameIdentifierResponse_set_Extension(self, value) set_xml_list(&LASSO_LIB_STATUS_RESPONSE(self)->Extension, (value))
#define LassoLibRegisterNameIdentifierResponse_Extension_set(self, value) set_xml_list(&LASSO_LIB_STATUS_RESPONSE(self)->Extension, (value))

/* providerId */
#define LassoLibRegisterNameIdentifierResponse_get_ProviderID(self) LASSO_LIB_STATUS_RESPONSE(self)->ProviderID
#define LassoLibRegisterNameIdentifierResponse_ProviderID_get(self) LASSO_LIB_STATUS_RESPONSE(self)->ProviderID
#define LassoLibRegisterNameIdentifierResponse_set_ProviderID(self, value) set_string(&LASSO_LIB_STATUS_RESPONSE(self)->ProviderID, (value))
#define LassoLibRegisterNameIdentifierResponse_ProviderID_set(self, value) set_string(&LASSO_LIB_STATUS_RESPONSE(self)->ProviderID, (value))

/* RelayState */
#define LassoLibRegisterNameIdentifierResponse_get_RelayState(self) LASSO_LIB_STATUS_RESPONSE(self)->RelayState
#define LassoLibRegisterNameIdentifierResponse_RelayState_get(self) LASSO_LIB_STATUS_RESPONSE(self)->RelayState
#define LassoLibRegisterNameIdentifierResponse_set_RelayState(self, value) set_string(&LASSO_LIB_STATUS_RESPONSE(self)->RelayState, (value))
#define LassoLibRegisterNameIdentifierResponse_RelayState_set(self, value) set_string(&LASSO_LIB_STATUS_RESPONSE(self)->RelayState, (value))

/* Status */
#define LassoLibRegisterNameIdentifierResponse_get_Status(self) get_node(LASSO_LIB_STATUS_RESPONSE(self)->Status)
#define LassoLibRegisterNameIdentifierResponse_Status_get(self) get_node(LASSO_LIB_STATUS_RESPONSE(self)->Status)
#define LassoLibRegisterNameIdentifierResponse_set_Status(self, value) set_node((gpointer *) &LASSO_LIB_STATUS_RESPONSE(self)->Status, (value))
#define LassoLibRegisterNameIdentifierResponse_Status_set(self, value) set_node((gpointer *) &LASSO_LIB_STATUS_RESPONSE(self)->Status, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoLibRegisterNameIdentifierResponse lasso_lib_register_name_identifier_response_new
#define delete_LassoLibRegisterNameIdentifierResponse(self) lasso_node_destroy(LASSO_NODE(self))
#define LassoLibRegisterNameIdentifierResponse_newFull lasso_lib_register_name_identifier_response_new_full

/* Implementations of methods inherited from LassoNode */

#define LassoLibRegisterNameIdentifierResponse_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Attributes implementations */

/* authnContextClassRef */
#define LassoLibRequestAuthnContext_get_authnContextClassRef(self) get_string_list((self)->AuthnContextClassRef)
#define LassoLibRequestAuthnContext_authnContextClassRef_get(self) get_string_list((self)->AuthnContextClassRef)
#define LassoLibRequestAuthnContext_set_authnContextClassRef(self, value) set_string_list(&(self)->AuthnContextClassRef, (value))
#define LassoLibRequestAuthnContext_authnContextClassRef_set(self, value) set_string_list(&(self)->AuthnContextClassRef, (value))

/* authnContextStatementRef */
#define LassoLibRequestAuthnContext_get_authnContextStatementRef(self) get_string_list((self)->AuthnContextStatementRef)
#define LassoLibRequestAuthnContext_authnContextStatementRef_get(self) get_string_list((self)->AuthnContextStatementRef)
#define LassoLibRequestAuthnContext_set_authnContextStatementRef(self, value) set_string_list(&(self)->AuthnContextStatementRef, (value))
#define LassoLibRequestAuthnContext_authnContextStatementRef_set(self, value) set_string_list(&(self)->AuthnContextStatementRef, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoLibRequestAuthnContext lasso_lib_request_authn_context_new
#define delete_LassoLibRequestAuthnContext(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoLibRequestAuthnContext_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Attributes implementations */

/* Extension */
#define LassoLibStatusResponse_get_Extension(self) get_xml_list((self)->Extension)
#define LassoLibStatusResponse_Extension_get(self) get_xml_list((self)->Extension)
#define LassoLibStatusResponse_set_Extension(self, value) set_xml_list(&(self)->Extension, (value))
#define LassoLibStatusResponse_Extension_set(self, value) set_xml_list(&(self)->Extension, (value))

/* Status */
#define LassoLibStatusResponse_get_Status(self) get_node((self)->Status)
#define LassoLibStatusResponse_Status_get(self) get_node((self)->Status)
#define LassoLibStatusResponse_set_Status(self, value) set_node((gpointer *) &(self)->Status, (value))
#define LassoLibStatusResponse_Status_set(self, value) set_node((gpointer *) &(self)->Status, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoLibStatusResponse lasso_lib_status_response_new
#define delete_LassoLibStatusResponse(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoLibStatusResponse_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Constructors, destructors & static methods implementations */

#define new_LassoProvider lasso_provider_new
#define delete_LassoProvider(self) lasso_node_destroy(LASSO_NODE(self))
#define LassoProvider_newFromDump lasso_provider_new_from_dump

/* Implementations of methods inherited from LassoNode */

#define LassoProvider_dump(self) lasso_node_dump(LASSO_NODE(self))

/* Methods implementations */

#define LassoProvider_acceptHttpMethod lasso_provider_accept_http_method
#define LassoProvider_getAssertionConsumerServiceUrl lasso_provider_get_assertion_consumer_service_url
#define LassoProvider_getBase64SuccinctId lasso_provider_get_base64_succinct_id
#define LassoProvider_getFirstHttpMethod lasso_provider_get_first_http_method
#define LassoProvider_getMetadataOne lasso_provider_get_metadata_one
#define LassoProvider_getProtocolConformance lasso_provider_get_protocol_conformance
#define LassoProvider_hasProtocolProfile lasso_provider_has_protocol_profile
#define LassoProvider_getOrganization(self) get_xml_string(lasso_provider_get_organization(self))





/* Implementations of attributes inherited from Provider */

/* providerId */
#define LassoServer_get_ProviderID(self) LASSO_PROVIDER(self)->ProviderID
#define LassoServer_ProviderID_get(self) LASSO_PROVIDER(self)->ProviderID
#define LassoServer_set_ProviderID(self, value) set_string(&LASSO_PROVIDER(self)->ProviderID, (value))
#define LassoServer_ProviderID_set(self, value) set_string(&LASSO_PROVIDER(self)->ProviderID, (value))

/* ca_cert_chain */
#define LassoServer_get_ca_cert_chain(self) LASSO_PROVIDER(self)->ca_cert_chain
#define LassoServer_ca_cert_chain_get(self) LASSO_PROVIDER(self)->ca_cert_chain
#define LassoServer_set_ca_cert_chain(self, value) set_string(&LASSO_PROVIDER(self)->ca_cert_chain, (value))
#define LassoServer_ca_cert_chain_set(self, value) set_string(&LASSO_PROVIDER(self)->ca_cert_chain, (value))

/* metadata_filename */
#define LassoServer_get_metadata_filename(self) LASSO_PROVIDER(self)->metadata_filename
#define LassoServer_metadata_filename_get(self) LASSO_PROVIDER(self)->metadata_filename
#define LassoServer_set_metadata_filename(self, value) set_string(&LASSO_PROVIDER(self)->metadata_filename, (value))
#define LassoServer_metadata_filename_set(self, value) set_string(&LASSO_PROVIDER(self)->metadata_filename, (value))

/* public_key */
#define LassoServer_get_public_key(self) LASSO_PROVIDER(self)->public_key
#define LassoServer_public_key_get(self) LASSO_PROVIDER(self)->public_key
#define LassoServer_set_public_key(self, value) set_string(&LASSO_PROVIDER(self)->public_key, (value))
#define LassoServer_public_key_set(self, value) set_string(&LASSO_PROVIDER(self)->public_key, (value))

/* role */
#define LassoServer_get_role(self) LASSO_PROVIDER(self)->role
#define LassoServer_role_get(self) LASSO_PROVIDER(self)->role
#define LassoServer_set_role(self, value) LASSO_PROVIDER(self)->role = value
#define LassoServer_role_set(self, value) LASSO_PROVIDER(self)->role = value

/* Attributes implementations */

/* providerIds */
#define LassoServer_get_providerIds LassoServer_providerIds_get
LassoStringList *LassoServer_providerIds_get(LassoServer *self) {
	GPtrArray *providerIds = g_ptr_array_sized_new(g_hash_table_size(self->providers));
	g_hash_table_foreach(self->providers, (GHFunc) add_key_to_array, providerIds);
	return providerIds;
}

/* Constructors, destructors & static methods implementations */

#define new_LassoServer lasso_server_new
#define delete_LassoServer(self) lasso_node_destroy(LASSO_NODE(self))
#define LassoServer_newFromDump lasso_server_new_from_dump

/* Implementations of methods inherited from Provider */

#define LassoServer_acceptHttpMethod(server, remote_provider, protocol_type, http_method, initiate_profile) lasso_provider_accept_http_method(LASSO_PROVIDER(server), remote_provider, protocol_type, http_method, initiate_profile)
#define LassoServer_getAssertionConsumerServiceUrl(server, service_id) lasso_provider_get_assertion_consumer_service_url(LASSO_PROVIDER(server), service_id)
#define LassoServer_getBase64SuccinctId(server) lasso_provider_get_base64_succinct_id(LASSO_PROVIDER(server))
#define LassoServer_getFirstHttpMethod(server, remote_provider, protocol_type) lasso_provider_get_first_http_method(LASSO_PROVIDER(server), remote_provider, protocol_type)
#define LassoServer_getMetadataOne(server, name) lasso_provider_get_metadata_one(LASSO_PROVIDER(server), name)
#define LassoServer_getProtocolConformance(server) lasso_provider_get_protocol_conformance(LASSO_PROVIDER(server))
#define LassoServer_hasProtocolProfile(server, protocol_type, protocol_profile) lasso_provider_has_protocol_profile(LASSO_PROVIDER(server), protocol_type, protocol_profile)
#define LassoServer_getOrganization(server) get_xml_string(lasso_provider_get_organization(LASSO_PROVIDER(server)))

/* Methods implementations */

#define LassoServer_addProvider lasso_server_add_provider
#define LassoServer_addService lasso_server_add_service
#define LassoServer_dump lasso_server_dump
#define LassoServer_getProvider lasso_server_get_provider
#define LassoServer_getService lasso_server_get_service




/* Attributes implementations */

/* localNameIdentifier */
#define LassoFederation_get_local_nameIdentifier(self) get_node((self)->local_nameIdentifier)
#define LassoFederation_local_nameIdentifier_get(self) get_node((self)->local_nameIdentifier)
#define LassoFederation_set_local_nameIdentifier(self, value) set_node((gpointer *) &(self)->local_nameIdentifier, (value))
#define LassoFederation_local_nameIdentifier_set(self, value) set_node((gpointer *) &(self)->local_nameIdentifier, (value))

/* remoteNameIdentifier */
#define LassoFederation_get_remote_nameIdentifier(self) get_node((self)->remote_nameIdentifier)
#define LassoFederation_remote_nameIdentifier_get(self) get_node((self)->remote_nameIdentifier)
#define LassoFederation_set_remote_nameIdentifier(self, value) set_node((gpointer *) &(self)->remote_nameIdentifier, (value))
#define LassoFederation_remote_nameIdentifier_set(self, value) set_node((gpointer *) &(self)->remote_nameIdentifier, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoFederation lasso_federation_new
#define delete_LassoFederation(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoFederation_dump(self) lasso_node_dump(LASSO_NODE(self))

/* Methods implementations */

#define LassoFederation_buildLocalNameIdentifier lasso_federation_build_local_name_identifier
#define LassoFederation_verifyNameIdentifier lasso_federation_verify_name_identifier




/* Attributes implementations */

/* providerIds */
#define LassoIdentity_get_providerIds LassoIdentity_providerIds_get
LassoStringList *LassoIdentity_providerIds_get(LassoIdentity *self) {
	GPtrArray *providerIds = g_ptr_array_sized_new(g_hash_table_size(self->federations));
	g_hash_table_foreach(self->federations, (GHFunc) add_key_to_array, providerIds);
	return providerIds;
}

/* Constructors, destructors & static methods implementations */

#define new_LassoIdentity lasso_identity_new
#define delete_LassoIdentity(self) lasso_node_destroy(LASSO_NODE(self))
#define LassoIdentity_newFromDump lasso_identity_new_from_dump

/* Methods implementations */

#define LassoIdentity_dump lasso_identity_dump
#define LassoIdentity_getFederation lasso_identity_get_federation

#ifdef LASSO_WSF_ENABLED
#define LassoIdentity_addResourceOffering lasso_identity_add_resource_offering
#define LassoIdentity_removeResourceOffering lasso_identity_remove_resource_offering

LassoNodeList *LassoIdentity_getOfferings(LassoIdentity *self, const char *service_type) {
	GPtrArray *array = NULL;
	GList *list;

	list = lasso_identity_get_offerings(self, service_type);
	if (list) {
		array = get_node_list(list);
		g_list_foreach(list, (GFunc) free_node_list_item, NULL);
		g_list_free(list);
	}
	return array;
}
#endif




/* Attributes implementations */

/* providerIds */
#define LassoSession_get_providerIds LassoSession_providerIds_get
LassoStringList *LassoSession_providerIds_get(LassoSession *self) {
	GPtrArray *providerIds = g_ptr_array_sized_new(g_hash_table_size(self->assertions));
	g_hash_table_foreach(self->assertions, (GHFunc) add_key_to_array, providerIds);
	return providerIds;
}

/* Constructors, destructors & static methods implementations */

#define new_LassoSession lasso_session_new
#define delete_LassoSession(self) lasso_node_destroy(LASSO_NODE(self))
#define LassoSession_newFromDump lasso_session_new_from_dump

/* Methods implementations */

#define LassoSession_dump lasso_session_dump

LassoNodeList *LassoSession_getAssertions(LassoSession *self, char *providerId) {
	GPtrArray *assertionsArray;
	GList *assertionsList;

	assertionsList = lasso_session_get_assertions(self, providerId);
	if (assertionsList) {
		assertionsArray = get_node_list(assertionsList);
		g_list_foreach(assertionsList, (GFunc) free_node_list_item, NULL);
		g_list_free(assertionsList);
	} else {
		assertionsArray = NULL;
	}
	return assertionsArray;
}




/* Implementations of attributes inherited from Profile */

/* identity */
#define LassoDefederation_get_identity(self) lasso_profile_get_identity(LASSO_PROFILE(self))
#define LassoDefederation_identity_get(self) lasso_profile_get_identity(LASSO_PROFILE(self))
#define LassoDefederation_set_identity(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->identity, (value))
#define LassoDefederation_identity_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->identity, (value))

/* artifact */
#define LassoDefederation_get_artifact(self) lasso_profile_get_artifact(LASSO_PROFILE(self))
#define LassoDefederation_artifact_get(self) lasso_profile_get_artifact(LASSO_PROFILE(self))

/* artifactMessage */
#define LassoDefederation_get_artifactMessage(self) lasso_profile_get_artifact_message(LASSO_PROFILE(self))
#define LassoDefederation_artifactMessage_get(self) lasso_profile_get_artifact_message(LASSO_PROFILE(self))
#define LassoDefederation_set_artifactMessage(self, value) lasso_profile_set_artifact_message(LASSO_PROFILE(self), value)
#define LassoDefederation_artifactMessage_set(self, value) lasso_profile_set_artifact_message(LASSO_PROFILE(self), value)

/* isIdentityDirty */
#define LassoDefederation_get_isIdentityDirty(self) lasso_profile_is_identity_dirty(LASSO_PROFILE(self))
#define LassoDefederation_isIdentityDirty_get(self) lasso_profile_is_identity_dirty(LASSO_PROFILE(self))

/* isSessionDirty */
#define LassoDefederation_get_isSessionDirty(self) lasso_profile_is_session_dirty(LASSO_PROFILE(self))
#define LassoDefederation_isSessionDirty_get(self) lasso_profile_is_session_dirty(LASSO_PROFILE(self))

/* msgBody */
#define LassoDefederation_get_msgBody(self) LASSO_PROFILE(self)->msg_body
#define LassoDefederation_msgBody_get(self) LASSO_PROFILE(self)->msg_body

/* msgRelayState */
#define LassoDefederation_get_msgRelayState(self) LASSO_PROFILE(self)->msg_relayState
#define LassoDefederation_msgRelayState_get(self) LASSO_PROFILE(self)->msg_relayState

/* msgUrl */
#define LassoDefederation_get_msgUrl(self) LASSO_PROFILE(self)->msg_url
#define LassoDefederation_msgUrl_get(self) LASSO_PROFILE(self)->msg_url

/* nameIdentifier */
#define LassoDefederation_get_nameIdentifier(self) get_node(LASSO_PROFILE(self)->nameIdentifier)
#define LassoDefederation_nameIdentifier_get(self) get_node(LASSO_PROFILE(self)->nameIdentifier)
#define LassoDefederation_set_nameIdentifier(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->nameIdentifier, (value))
#define LassoDefederation_nameIdentifier_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->nameIdentifier, (value))

/* remoteProviderId */
#define LassoDefederation_get_remoteProviderId(self) LASSO_PROFILE(self)->remote_providerID
#define LassoDefederation_remoteProviderId_get(self) LASSO_PROFILE(self)->remote_providerID
#define LassoDefederation_set_remoteProviderId(self, value) set_string(&LASSO_PROFILE(self)->remote_providerID, (value))
#define LassoDefederation_remoteProviderId_set(self, value) set_string(&LASSO_PROFILE(self)->remote_providerID, (value))

/* request */
#define LassoDefederation_get_request(self) get_node(LASSO_PROFILE(self)->request)
#define LassoDefederation_request_get(self) get_node(LASSO_PROFILE(self)->request)
#define LassoDefederation_set_request(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->request, (value))
#define LassoDefederation_request_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->request, (value))

/* response */
#define LassoDefederation_get_response(self) get_node(LASSO_PROFILE(self)->response)
#define LassoDefederation_response_get(self) get_node(LASSO_PROFILE(self)->response)
#define LassoDefederation_set_response(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->response, (value))
#define LassoDefederation_response_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->response, (value))

/* server */
#define LassoDefederation_get_server(self) get_node(LASSO_PROFILE(self)->server)
#define LassoDefederation_server_get(self) get_node(LASSO_PROFILE(self)->server)
#define LassoDefederation_set_server(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->server, (value))
#define LassoDefederation_server_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->server, (value))

/* session */
#define LassoDefederation_get_session(self) lasso_profile_get_session(LASSO_PROFILE(self))
#define LassoDefederation_session_get(self) lasso_profile_get_session(LASSO_PROFILE(self))
#define LassoDefederation_set_session(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->session, (value))
#define LassoDefederation_session_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->session, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoDefederation lasso_defederation_new
#define delete_LassoDefederation(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from Profile */

int LassoDefederation_setIdentityFromDump(LassoDefederation *self, char *dump) {
	return lasso_profile_set_identity_from_dump(LASSO_PROFILE(self), dump);
}

int LassoDefederation_setSessionFromDump(LassoDefederation *self, char *dump) {
	return lasso_profile_set_session_from_dump(LASSO_PROFILE(self), dump);
}

/* Methods implementations */

#define LassoDefederation_buildNotificationMsg lasso_defederation_build_notification_msg
#define LassoDefederation_initNotification lasso_defederation_init_notification
#define LassoDefederation_processNotificationMsg lasso_defederation_process_notification_msg
#define LassoDefederation_validateNotification lasso_defederation_validate_notification




/* Implementations of attributes inherited from Profile */

/* identity */
#define LassoLogin_get_identity(self) lasso_profile_get_identity(LASSO_PROFILE(self))
#define LassoLogin_identity_get(self) lasso_profile_get_identity(LASSO_PROFILE(self))
#define LassoLogin_set_identity(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->identity, (value))
#define LassoLogin_identity_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->identity, (value))

/* artifact */
#define LassoLogin_get_artifact(self) lasso_profile_get_artifact(LASSO_PROFILE(self))
#define LassoLogin_artifact_get(self) lasso_profile_get_artifact(LASSO_PROFILE(self))

/* artifactMessage */
#define LassoLogin_get_artifactMessage(self) lasso_profile_get_artifact_message(LASSO_PROFILE(self))
#define LassoLogin_artifactMessage_get(self) lasso_profile_get_artifact_message(LASSO_PROFILE(self))
#define LassoLogin_set_artifactMessage(self, value) lasso_profile_set_artifact_message(LASSO_PROFILE(self), value)
#define LassoLogin_artifactMessage_set(self, value) lasso_profile_set_artifact_message(LASSO_PROFILE(self), value)

/* isIdentityDirty */
#define LassoLogin_get_isIdentityDirty(self) lasso_profile_is_identity_dirty(LASSO_PROFILE(self))
#define LassoLogin_isIdentityDirty_get(self) lasso_profile_is_identity_dirty(LASSO_PROFILE(self))

/* isSessionDirty */
#define LassoLogin_get_isSessionDirty(self) lasso_profile_is_session_dirty(LASSO_PROFILE(self))
#define LassoLogin_isSessionDirty_get(self) lasso_profile_is_session_dirty(LASSO_PROFILE(self))

/* msgBody */
#define LassoLogin_get_msgBody(self) LASSO_PROFILE(self)->msg_body
#define LassoLogin_msgBody_get(self) LASSO_PROFILE(self)->msg_body

/* msgRelayState */
#define LassoLogin_get_msgRelayState(self) LASSO_PROFILE(self)->msg_relayState
#define LassoLogin_msgRelayState_get(self) LASSO_PROFILE(self)->msg_relayState

/* msgUrl */
#define LassoLogin_get_msgUrl(self) LASSO_PROFILE(self)->msg_url
#define LassoLogin_msgUrl_get(self) LASSO_PROFILE(self)->msg_url

/* nameIdentifier */
#define LassoLogin_get_nameIdentifier(self) get_node(LASSO_PROFILE(self)->nameIdentifier)
#define LassoLogin_nameIdentifier_get(self) get_node(LASSO_PROFILE(self)->nameIdentifier)
#define LassoLogin_set_nameIdentifier(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->nameIdentifier, (value))
#define LassoLogin_nameIdentifier_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->nameIdentifier, (value))

/* remoteProviderId */
#define LassoLogin_get_remoteProviderId(self) LASSO_PROFILE(self)->remote_providerID
#define LassoLogin_remoteProviderId_get(self) LASSO_PROFILE(self)->remote_providerID
#define LassoLogin_set_remoteProviderId(self, value) set_string(&LASSO_PROFILE(self)->remote_providerID, (value))
#define LassoLogin_remoteProviderId_set(self, value) set_string(&LASSO_PROFILE(self)->remote_providerID, (value))

/* request */
#define LassoLogin_get_request(self) get_node(LASSO_PROFILE(self)->request)
#define LassoLogin_request_get(self) get_node(LASSO_PROFILE(self)->request)
#define LassoLogin_set_request(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->request, (value))
#define LassoLogin_request_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->request, (value))

/* response */
#define LassoLogin_get_response(self) get_node(LASSO_PROFILE(self)->response)
#define LassoLogin_response_get(self) get_node(LASSO_PROFILE(self)->response)
#define LassoLogin_set_response(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->response, (value))
#define LassoLogin_response_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->response, (value))

/* server */
#define LassoLogin_get_server(self) get_node(LASSO_PROFILE(self)->server)
#define LassoLogin_server_get(self) get_node(LASSO_PROFILE(self)->server)
#define LassoLogin_set_server(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->server, (value))
#define LassoLogin_server_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->server, (value))

/* session */
#define LassoLogin_get_session(self) lasso_profile_get_session(LASSO_PROFILE(self))
#define LassoLogin_session_get(self) lasso_profile_get_session(LASSO_PROFILE(self))
#define LassoLogin_set_session(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->session, (value))
#define LassoLogin_session_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->session, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoLogin lasso_login_new
#define delete_LassoLogin(self) lasso_node_destroy(LASSO_NODE(self))
#define LassoLogin_newFromDump lasso_login_new_from_dump

/* Implementations of methods inherited from Profile */

int LassoLogin_setIdentityFromDump(LassoLogin *self, char *dump) {
	return lasso_profile_set_identity_from_dump(LASSO_PROFILE(self), dump);
}

int LassoLogin_setSessionFromDump(LassoLogin *self, char *dump) {
	return lasso_profile_set_session_from_dump(LASSO_PROFILE(self), dump);
}

/* Methods implementations */

#define LassoLogin_acceptSso lasso_login_accept_sso
#define LassoLogin_buildAssertion lasso_login_build_assertion
#define LassoLogin_buildArtifactMsg lasso_login_build_artifact_msg
#define LassoLogin_buildAuthnRequestMsg lasso_login_build_authn_request_msg
#define LassoLogin_buildAuthnResponseMsg lasso_login_build_authn_response_msg
#define LassoLogin_buildRequestMsg lasso_login_build_request_msg
#define LassoLogin_buildResponseMsg lasso_login_build_response_msg
#define LassoLogin_dump lasso_login_dump
#define LassoLogin_initAuthnRequest lasso_login_init_authn_request
#define LassoLogin_initRequest lasso_login_init_request
#define LassoLogin_initIdpInitiatedAuthnRequest lasso_login_init_idp_initiated_authn_request
#define LassoLogin_mustAskForConsent lasso_login_must_ask_for_consent
#define LassoLogin_mustAuthenticate lasso_login_must_authenticate
#define LassoLogin_processAuthnRequestMsg lasso_login_process_authn_request_msg
#define LassoLogin_processAuthnResponseMsg lasso_login_process_authn_response_msg
#define LassoLogin_processRequestMsg lasso_login_process_request_msg
#define LassoLogin_processResponseMsg lasso_login_process_response_msg
#define LassoLogin_setEncryptedResourceId lasso_login_set_encryptedResourceId 
#define LassoLogin_setResourceId lasso_login_set_resourceId
#define LassoLogin_validateRequestMsg lasso_login_validate_request_msg




/* Implementations of attributes inherited from Profile */

/* identity */
#define LassoLogout_get_identity(self) lasso_profile_get_identity(LASSO_PROFILE(self))
#define LassoLogout_identity_get(self) lasso_profile_get_identity(LASSO_PROFILE(self))
#define LassoLogout_set_identity(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->identity, (value))
#define LassoLogout_identity_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->identity, (value))

/* artifact */
#define LassoLogout_get_artifact(self) lasso_profile_get_artifact(LASSO_PROFILE(self))
#define LassoLogout_artifact_get(self) lasso_profile_get_artifact(LASSO_PROFILE(self))

/* artifactMessage */
#define LassoLogout_get_artifactMessage(self) lasso_profile_get_artifact_message(LASSO_PROFILE(self))
#define LassoLogout_artifactMessage_get(self) lasso_profile_get_artifact_message(LASSO_PROFILE(self))
#define LassoLogout_set_artifactMessage(self, value) lasso_profile_set_artifact_message(LASSO_PROFILE(self), value)
#define LassoLogout_artifactMessage_set(self, value) lasso_profile_set_artifact_message(LASSO_PROFILE(self), value)

/* isIdentityDirty */
#define LassoLogout_get_isIdentityDirty(self) lasso_profile_is_identity_dirty(LASSO_PROFILE(self))
#define LassoLogout_isIdentityDirty_get(self) lasso_profile_is_identity_dirty(LASSO_PROFILE(self))

/* isSessionDirty */
#define LassoLogout_get_isSessionDirty(self) lasso_profile_is_session_dirty(LASSO_PROFILE(self))
#define LassoLogout_isSessionDirty_get(self) lasso_profile_is_session_dirty(LASSO_PROFILE(self))

/* msgBody */
#define LassoLogout_get_msgBody(self) LASSO_PROFILE(self)->msg_body
#define LassoLogout_msgBody_get(self) LASSO_PROFILE(self)->msg_body

/* msgRelayState */
#define LassoLogout_get_msgRelayState(self) LASSO_PROFILE(self)->msg_relayState
#define LassoLogout_msgRelayState_get(self) LASSO_PROFILE(self)->msg_relayState

/* msgUrl */
#define LassoLogout_get_msgUrl(self) LASSO_PROFILE(self)->msg_url
#define LassoLogout_msgUrl_get(self) LASSO_PROFILE(self)->msg_url

/* nameIdentifier */
#define LassoLogout_get_nameIdentifier(self) get_node(LASSO_PROFILE(self)->nameIdentifier)
#define LassoLogout_nameIdentifier_get(self) get_node(LASSO_PROFILE(self)->nameIdentifier)
#define LassoLogout_set_nameIdentifier(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->nameIdentifier, (value))
#define LassoLogout_nameIdentifier_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->nameIdentifier, (value))

/* remoteProviderId */
#define LassoLogout_get_remoteProviderId(self) LASSO_PROFILE(self)->remote_providerID
#define LassoLogout_remoteProviderId_get(self) LASSO_PROFILE(self)->remote_providerID
#define LassoLogout_set_remoteProviderId(self, value) set_string(&LASSO_PROFILE(self)->remote_providerID, (value))
#define LassoLogout_remoteProviderId_set(self, value) set_string(&LASSO_PROFILE(self)->remote_providerID, (value))

/* request */
#define LassoLogout_get_request(self) get_node(LASSO_PROFILE(self)->request)
#define LassoLogout_request_get(self) get_node(LASSO_PROFILE(self)->request)
#define LassoLogout_set_request(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->request, (value))
#define LassoLogout_request_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->request, (value))

/* response */
#define LassoLogout_get_response(self) get_node(LASSO_PROFILE(self)->response)
#define LassoLogout_response_get(self) get_node(LASSO_PROFILE(self)->response)
#define LassoLogout_set_response(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->response, (value))
#define LassoLogout_response_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->response, (value))

/* server */
#define LassoLogout_get_server(self) get_node(LASSO_PROFILE(self)->server)
#define LassoLogout_server_get(self) get_node(LASSO_PROFILE(self)->server)
#define LassoLogout_set_server(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->server, (value))
#define LassoLogout_server_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->server, (value))

/* session */
#define LassoLogout_get_session(self) lasso_profile_get_session(LASSO_PROFILE(self))
#define LassoLogout_session_get(self) lasso_profile_get_session(LASSO_PROFILE(self))
#define LassoLogout_set_session(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->session, (value))
#define LassoLogout_session_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->session, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoLogout lasso_logout_new
#define delete_LassoLogout(self) lasso_node_destroy(LASSO_NODE(self))
#define LassoLogout_newFromDump lasso_logout_new_from_dump

/* Implementations of methods inherited from Profile */

int LassoLogout_setIdentityFromDump(LassoLogout *self, char *dump) {
	return lasso_profile_set_identity_from_dump(LASSO_PROFILE(self), dump);
}

int LassoLogout_setSessionFromDump(LassoLogout *self, char *dump) {
	return lasso_profile_set_session_from_dump(LASSO_PROFILE(self), dump);
}

/* Methods implementations */

#define LassoLogout_buildRequestMsg lasso_logout_build_request_msg
#define LassoLogout_buildResponseMsg lasso_logout_build_response_msg
#define LassoLogout_dump lasso_logout_dump
#define LassoLogout_getNextProviderId lasso_logout_get_next_providerID
#define LassoLogout_initRequest lasso_logout_init_request
#define LassoLogout_processRequestMsg lasso_logout_process_request_msg
#define LassoLogout_processResponseMsg lasso_logout_process_response_msg
#define LassoLogout_resetProviderIdIndex lasso_logout_reset_providerID_index
#define LassoLogout_validateRequest lasso_logout_validate_request




/* Implementations of attributes inherited from Profile */

/* identity */
#define LassoLecp_get_identity(self) lasso_profile_get_identity(LASSO_PROFILE(self))
#define LassoLecp_identity_get(self) lasso_profile_get_identity(LASSO_PROFILE(self))
#define LassoLecp_set_identity(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->identity, (value))
#define LassoLecp_identity_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->identity, (value))

/* artifact */
#define LassoLecp_get_artifact(self) lasso_profile_get_artifact(LASSO_PROFILE(self))
#define LassoLecp_artifact_get(self) lasso_profile_get_artifact(LASSO_PROFILE(self))

/* artifactMessage */
#define LassoLecp_get_artifactMessage(self) lasso_profile_get_artifact_message(LASSO_PROFILE(self))
#define LassoLecp_artifactMessage_get(self) lasso_profile_get_artifact_message(LASSO_PROFILE(self))
#define LassoLecp_set_artifactMessage(self, value) lasso_profile_set_artifact_message(LASSO_PROFILE(self), value)
#define LassoLecp_artifactMessage_set(self, value) lasso_profile_set_artifact_message(LASSO_PROFILE(self), value)

/* isIdentityDirty */
#define LassoLecp_get_isIdentityDirty(self) lasso_profile_is_identity_dirty(LASSO_PROFILE(self))
#define LassoLecp_isIdentityDirty_get(self) lasso_profile_is_identity_dirty(LASSO_PROFILE(self))

/* isSessionDirty */
#define LassoLecp_get_isSessionDirty(self) lasso_profile_is_session_dirty(LASSO_PROFILE(self))
#define LassoLecp_isSessionDirty_get(self) lasso_profile_is_session_dirty(LASSO_PROFILE(self))

/* msgBody */
#define LassoLecp_get_msgBody(self) LASSO_PROFILE(self)->msg_body
#define LassoLecp_msgBody_get(self) LASSO_PROFILE(self)->msg_body

/* msgRelayState */
#define LassoLecp_get_msgRelayState(self) LASSO_PROFILE(self)->msg_relayState
#define LassoLecp_msgRelayState_get(self) LASSO_PROFILE(self)->msg_relayState

/* msgUrl */
#define LassoLecp_get_msgUrl(self) LASSO_PROFILE(self)->msg_url
#define LassoLecp_msgUrl_get(self) LASSO_PROFILE(self)->msg_url

/* nameIdentifier */
#define LassoLecp_get_nameIdentifier(self) get_node(LASSO_PROFILE(self)->nameIdentifier)
#define LassoLecp_nameIdentifier_get(self) get_node(LASSO_PROFILE(self)->nameIdentifier)
#define LassoLecp_set_nameIdentifier(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->nameIdentifier, (value))
#define LassoLecp_nameIdentifier_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->nameIdentifier, (value))

/* remoteProviderId */
#define LassoLecp_get_remoteProviderId(self) LASSO_PROFILE(self)->remote_providerID
#define LassoLecp_remoteProviderId_get(self) LASSO_PROFILE(self)->remote_providerID
#define LassoLecp_set_remoteProviderId(self, value) set_string(&LASSO_PROFILE(self)->remote_providerID, (value))
#define LassoLecp_remoteProviderId_set(self, value) set_string(&LASSO_PROFILE(self)->remote_providerID, (value))

/* request */
#define LassoLecp_get_request(self) get_node(LASSO_PROFILE(self)->request)
#define LassoLecp_request_get(self) get_node(LASSO_PROFILE(self)->request)
#define LassoLecp_set_request(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->request, (value))
#define LassoLecp_request_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->request, (value))

/* response */
#define LassoLecp_get_response(self) get_node(LASSO_PROFILE(self)->response)
#define LassoLecp_response_get(self) get_node(LASSO_PROFILE(self)->response)
#define LassoLecp_set_response(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->response, (value))
#define LassoLecp_response_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->response, (value))

/* server */
#define LassoLecp_get_server(self) get_node(LASSO_PROFILE(self)->server)
#define LassoLecp_server_get(self) get_node(LASSO_PROFILE(self)->server)
#define LassoLecp_set_server(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->server, (value))
#define LassoLecp_server_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->server, (value))

/* session */
#define LassoLecp_get_session(self) lasso_profile_get_session(LASSO_PROFILE(self))
#define LassoLecp_session_get(self) lasso_profile_get_session(LASSO_PROFILE(self))
#define LassoLecp_set_session(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->session, (value))
#define LassoLecp_session_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->session, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoLecp lasso_lecp_new
#define delete_LassoLecp(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from Profile */

int LassoLecp_setIdentityFromDump(LassoLecp *self, char *dump) {
	return lasso_profile_set_identity_from_dump(LASSO_PROFILE(self), dump);
}

int LassoLecp_setSessionFromDump(LassoLecp *self, char *dump) {
	return lasso_profile_set_session_from_dump(LASSO_PROFILE(self), dump);
}

/* Implementations of methods inherited from Login */

int LassoLecp_buildAssertion(LassoLecp *self, char *authenticationMethod,
		char *authenticationInstant, char *reauthenticateOnOrAfter, char *notBefore,
		char *notOnOrAfter) {
	return lasso_login_build_assertion(LASSO_LOGIN(self), authenticationMethod,
			authenticationInstant, reauthenticateOnOrAfter, notBefore, notOnOrAfter);
}

#ifdef LASSO_WSF_ENABLED
int LassoLecp_setEncryptedResourceId(LassoLecp *self,
		LassoDiscoEncryptedResourceID *encryptedResourceId) {
	return lasso_login_set_encryptedResourceId(LASSO_LOGIN(self), encryptedResourceId);
}
#endif

int LassoLecp_setResourceId(LassoLecp *self, char *content) {
	return lasso_login_set_resourceId(LASSO_LOGIN(self), content);
}

int LassoLecp_validateRequestMsg(LassoLecp *self, gboolean authenticationResult,
		gboolean isConsentObtained) {
	return lasso_login_validate_request_msg(LASSO_LOGIN(self), authenticationResult,
			isConsentObtained);
}

/* Methods implementations */

#define LassoLecp_buildAuthnRequestEnvelopeMsg lasso_lecp_build_authn_request_envelope_msg
#define LassoLecp_buildAuthnRequestMsg lasso_lecp_build_authn_request_msg
#define LassoLecp_buildAuthnResponseEnvelopeMsg lasso_lecp_build_authn_response_envelope_msg
#define LassoLecp_buildAuthnResponseMsg lasso_lecp_build_authn_response_msg
#define LassoLecp_initAuthnRequest lasso_lecp_init_authn_request
#define LassoLecp_processAuthnRequestEnvelopeMsg lasso_lecp_process_authn_request_envelope_msg
#define LassoLecp_processAuthnRequestMsg lasso_lecp_process_authn_request_msg
#define LassoLecp_processAuthnResponseEnvelopeMsg lasso_lecp_process_authn_response_envelope_msg




/* Implementations of attributes inherited from Profile */

/* identity */
#define LassoNameIdentifierMapping_get_identity(self) lasso_profile_get_identity(LASSO_PROFILE(self))
#define LassoNameIdentifierMapping_identity_get(self) lasso_profile_get_identity(LASSO_PROFILE(self))
#define LassoNameIdentifierMapping_set_identity(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->identity, (value))
#define LassoNameIdentifierMapping_identity_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->identity, (value))

/* artifact */
#define LassoNameIdentifierMapping_get_artifact(self) lasso_profile_get_artifact(LASSO_PROFILE(self))
#define LassoNameIdentifierMapping_artifact_get(self) lasso_profile_get_artifact(LASSO_PROFILE(self))

/* artifactMessage */
#define LassoNameIdentifierMapping_get_artifactMessage(self) lasso_profile_get_artifact_message(LASSO_PROFILE(self))
#define LassoNameIdentifierMapping_artifactMessage_get(self) lasso_profile_get_artifact_message(LASSO_PROFILE(self))
#define LassoNameIdentifierMapping_set_artifactMessage(self, value) lasso_profile_set_artifact_message(LASSO_PROFILE(self), value)
#define LassoNameIdentifierMapping_artifactMessage_set(self, value) lasso_profile_set_artifact_message(LASSO_PROFILE(self), value)

/* isIdentityDirty */
#define LassoNameIdentifierMapping_get_isIdentityDirty(self) lasso_profile_is_identity_dirty(LASSO_PROFILE(self))
#define LassoNameIdentifierMapping_isIdentityDirty_get(self) lasso_profile_is_identity_dirty(LASSO_PROFILE(self))

/* isSessionDirty */
#define LassoNameIdentifierMapping_get_isSessionDirty(self) lasso_profile_is_session_dirty(LASSO_PROFILE(self))
#define LassoNameIdentifierMapping_isSessionDirty_get(self) lasso_profile_is_session_dirty(LASSO_PROFILE(self))

/* msgBody */
#define LassoNameIdentifierMapping_get_msgBody(self) LASSO_PROFILE(self)->msg_body
#define LassoNameIdentifierMapping_msgBody_get(self) LASSO_PROFILE(self)->msg_body

/* msgRelayState */
#define LassoNameIdentifierMapping_get_msgRelayState(self) LASSO_PROFILE(self)->msg_relayState
#define LassoNameIdentifierMapping_msgRelayState_get(self) LASSO_PROFILE(self)->msg_relayState

/* msgUrl */
#define LassoNameIdentifierMapping_get_msgUrl(self) LASSO_PROFILE(self)->msg_url
#define LassoNameIdentifierMapping_msgUrl_get(self) LASSO_PROFILE(self)->msg_url

/* nameIdentifier */
#define LassoNameIdentifierMapping_get_nameIdentifier(self) get_node(LASSO_PROFILE(self)->nameIdentifier)
#define LassoNameIdentifierMapping_nameIdentifier_get(self) get_node(LASSO_PROFILE(self)->nameIdentifier)
#define LassoNameIdentifierMapping_set_nameIdentifier(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->nameIdentifier, (value))
#define LassoNameIdentifierMapping_nameIdentifier_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->nameIdentifier, (value))

/* remoteProviderId */
#define LassoNameIdentifierMapping_get_remoteProviderId(self) LASSO_PROFILE(self)->remote_providerID
#define LassoNameIdentifierMapping_remoteProviderId_get(self) LASSO_PROFILE(self)->remote_providerID
#define LassoNameIdentifierMapping_set_remoteProviderId(self, value) set_string(&LASSO_PROFILE(self)->remote_providerID, (value))
#define LassoNameIdentifierMapping_remoteProviderId_set(self, value) set_string(&LASSO_PROFILE(self)->remote_providerID, (value))

/* request */
#define LassoNameIdentifierMapping_get_request(self) get_node(LASSO_PROFILE(self)->request)
#define LassoNameIdentifierMapping_request_get(self) get_node(LASSO_PROFILE(self)->request)
#define LassoNameIdentifierMapping_set_request(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->request, (value))
#define LassoNameIdentifierMapping_request_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->request, (value))

/* response */
#define LassoNameIdentifierMapping_get_response(self) get_node(LASSO_PROFILE(self)->response)
#define LassoNameIdentifierMapping_response_get(self) get_node(LASSO_PROFILE(self)->response)
#define LassoNameIdentifierMapping_set_response(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->response, (value))
#define LassoNameIdentifierMapping_response_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->response, (value))

/* server */
#define LassoNameIdentifierMapping_get_server(self) get_node(LASSO_PROFILE(self)->server)
#define LassoNameIdentifierMapping_server_get(self) get_node(LASSO_PROFILE(self)->server)
#define LassoNameIdentifierMapping_set_server(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->server, (value))
#define LassoNameIdentifierMapping_server_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->server, (value))

/* session */
#define LassoNameIdentifierMapping_get_session(self) lasso_profile_get_session(LASSO_PROFILE(self))
#define LassoNameIdentifierMapping_session_get(self) lasso_profile_get_session(LASSO_PROFILE(self))
#define LassoNameIdentifierMapping_set_session(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->session, (value))
#define LassoNameIdentifierMapping_session_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->session, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoNameIdentifierMapping lasso_name_identifier_mapping_new
#define delete_LassoNameIdentifierMapping(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from Profile */

int LassoNameIdentifierMapping_setIdentityFromDump(LassoNameIdentifierMapping *self, char *dump) {
	return lasso_profile_set_identity_from_dump(LASSO_PROFILE(self), dump);
}

int LassoNameIdentifierMapping_setSessionFromDump(LassoNameIdentifierMapping *self, char *dump) {
	return lasso_profile_set_session_from_dump(LASSO_PROFILE(self), dump);
}

/* Methods implementations */

#define LassoNameIdentifierMapping_buildRequestMsg lasso_name_identifier_mapping_build_request_msg
#define LassoNameIdentifierMapping_buildResponseMsg lasso_name_identifier_mapping_build_response_msg
#define LassoNameIdentifierMapping_initRequest lasso_name_identifier_mapping_init_request
#define LassoNameIdentifierMapping_processRequestMsg lasso_name_identifier_mapping_process_request_msg
#define LassoNameIdentifierMapping_processResponseMsg lasso_name_identifier_mapping_process_response_msg
#define LassoNameIdentifierMapping_validateRequest lasso_name_identifier_mapping_validate_request




/* Implementations of attributes inherited from Profile */

/* identity */
#define LassoNameRegistration_get_identity(self) lasso_profile_get_identity(LASSO_PROFILE(self))
#define LassoNameRegistration_identity_get(self) lasso_profile_get_identity(LASSO_PROFILE(self))
#define LassoNameRegistration_set_identity(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->identity, (value))
#define LassoNameRegistration_identity_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->identity, (value))

/* artifact */
#define LassoNameRegistration_get_artifact(self) lasso_profile_get_artifact(LASSO_PROFILE(self))
#define LassoNameRegistration_artifact_get(self) lasso_profile_get_artifact(LASSO_PROFILE(self))

/* artifactMessage */
#define LassoNameRegistration_get_artifactMessage(self) lasso_profile_get_artifact_message(LASSO_PROFILE(self))
#define LassoNameRegistration_artifactMessage_get(self) lasso_profile_get_artifact_message(LASSO_PROFILE(self))
#define LassoNameRegistration_set_artifactMessage(self, value) lasso_profile_set_artifact_message(LASSO_PROFILE(self), value)
#define LassoNameRegistration_artifactMessage_set(self, value) lasso_profile_set_artifact_message(LASSO_PROFILE(self), value)

/* isIdentityDirty */
#define LassoNameRegistration_get_isIdentityDirty(self) lasso_profile_is_identity_dirty(LASSO_PROFILE(self))
#define LassoNameRegistration_isIdentityDirty_get(self) lasso_profile_is_identity_dirty(LASSO_PROFILE(self))

/* isSessionDirty */
#define LassoNameRegistration_get_isSessionDirty(self) lasso_profile_is_session_dirty(LASSO_PROFILE(self))
#define LassoNameRegistration_isSessionDirty_get(self) lasso_profile_is_session_dirty(LASSO_PROFILE(self))

/* msgBody */
#define LassoNameRegistration_get_msgBody(self) LASSO_PROFILE(self)->msg_body
#define LassoNameRegistration_msgBody_get(self) LASSO_PROFILE(self)->msg_body

/* msgRelayState */
#define LassoNameRegistration_get_msgRelayState(self) LASSO_PROFILE(self)->msg_relayState
#define LassoNameRegistration_msgRelayState_get(self) LASSO_PROFILE(self)->msg_relayState

/* msgUrl */
#define LassoNameRegistration_get_msgUrl(self) LASSO_PROFILE(self)->msg_url
#define LassoNameRegistration_msgUrl_get(self) LASSO_PROFILE(self)->msg_url

/* nameIdentifier */
#define LassoNameRegistration_get_nameIdentifier(self) get_node(LASSO_PROFILE(self)->nameIdentifier)
#define LassoNameRegistration_nameIdentifier_get(self) get_node(LASSO_PROFILE(self)->nameIdentifier)
#define LassoNameRegistration_set_nameIdentifier(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->nameIdentifier, (value))
#define LassoNameRegistration_nameIdentifier_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->nameIdentifier, (value))

/* remoteProviderId */
#define LassoNameRegistration_get_remoteProviderId(self) LASSO_PROFILE(self)->remote_providerID
#define LassoNameRegistration_remoteProviderId_get(self) LASSO_PROFILE(self)->remote_providerID
#define LassoNameRegistration_set_remoteProviderId(self, value) set_string(&LASSO_PROFILE(self)->remote_providerID, (value))
#define LassoNameRegistration_remoteProviderId_set(self, value) set_string(&LASSO_PROFILE(self)->remote_providerID, (value))

/* request */
#define LassoNameRegistration_get_request(self) get_node(LASSO_PROFILE(self)->request)
#define LassoNameRegistration_request_get(self) get_node(LASSO_PROFILE(self)->request)
#define LassoNameRegistration_set_request(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->request, (value))
#define LassoNameRegistration_request_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->request, (value))

/* response */
#define LassoNameRegistration_get_response(self) get_node(LASSO_PROFILE(self)->response)
#define LassoNameRegistration_response_get(self) get_node(LASSO_PROFILE(self)->response)
#define LassoNameRegistration_set_response(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->response, (value))
#define LassoNameRegistration_response_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->response, (value))

/* server */
#define LassoNameRegistration_get_server(self) get_node(LASSO_PROFILE(self)->server)
#define LassoNameRegistration_server_get(self) get_node(LASSO_PROFILE(self)->server)
#define LassoNameRegistration_set_server(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->server, (value))
#define LassoNameRegistration_server_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->server, (value))

/* session */
#define LassoNameRegistration_get_session(self) lasso_profile_get_session(LASSO_PROFILE(self))
#define LassoNameRegistration_session_get(self) lasso_profile_get_session(LASSO_PROFILE(self))
#define LassoNameRegistration_set_session(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->session, (value))
#define LassoNameRegistration_session_set(self, value) set_node((gpointer *) &LASSO_PROFILE(self)->session, (value))

/* Attributes implementations */

/* oldNameIdentifier */
#define LassoNameRegistration_get_oldNameIdentifier(self) get_node((self)->oldNameIdentifier)
#define LassoNameRegistration_oldNameIdentifier_get(self) get_node((self)->oldNameIdentifier)
#define LassoNameRegistration_set_oldNameIdentifier(self, value) set_node((gpointer *) &(self)->oldNameIdentifier, (value))
#define LassoNameRegistration_oldNameIdentifier_set(self, value) set_node((gpointer *) &(self)->oldNameIdentifier, (value))

/* Constructors, destructors & static methods implementations */

#define new_LassoNameRegistration lasso_name_registration_new
#define delete_LassoNameRegistration(self) lasso_node_destroy(LASSO_NODE(self))
#define LassoNameRegistration_newFromDump lasso_name_registration_new_from_dump

/* Implementations of methods inherited from Profile */

int LassoNameRegistration_setIdentityFromDump(LassoNameRegistration *self, char *dump) {
	return lasso_profile_set_identity_from_dump(LASSO_PROFILE(self), dump);
}

int LassoNameRegistration_setSessionFromDump(LassoNameRegistration *self, char *dump) {
	return lasso_profile_set_session_from_dump(LASSO_PROFILE(self), dump);
}

/* Methods implementations */

#define LassoNameRegistration_buildRequestMsg lasso_name_registration_build_request_msg
#define LassoNameRegistration_buildResponseMsg lasso_name_registration_build_response_msg
#define LassoNameRegistration_dump lasso_name_registration_dump
#define LassoNameRegistration_initRequest lasso_name_registration_init_request
#define LassoNameRegistration_processRequestMsg lasso_name_registration_process_request_msg
#define LassoNameRegistration_processResponseMsg lasso_name_registration_process_response_msg
#define LassoNameRegistration_validateRequest lasso_name_registration_validate_request



#include <lasso/xml/saml-2.0/samlp2_name_id_policy.h>
#include <lasso/xml/saml-2.0/samlp2_requested_authn_context.h>
#include <lasso/xml/saml-2.0/saml2_assertion.h>
#include <lasso/xml/saml-2.0/samlp2_idp_list.h>
#include <lasso/xml/saml-2.0/saml2_key_info_confirmation_data.h>
#include <lasso/xml/saml-2.0/saml2_conditions.h>
#include <lasso/xml/saml-2.0/saml2_evidence.h>
#include <lasso/xml/saml-2.0/saml2_name_id.h>
#include <lasso/xml/saml-2.0/samlp2_status_code.h>
#include <lasso/xml/saml-2.0/samlp2_status.h>
#include <lasso/xml/saml-2.0/saml2_condition_abstract.h>
#include <lasso/xml/saml-2.0/saml2_one_time_use.h>
#include <lasso/xml/saml-2.0/saml2_advice.h>
#include <lasso/xml/saml-2.0/saml2_base_idabstract.h>
#include <lasso/xml/saml-2.0/saml2_authn_context.h>
#include <lasso/xml/saml-2.0/saml2_subject_locality.h>
#include <lasso/xml/saml-2.0/saml2_subject_confirmation_data.h>
#include <lasso/xml/saml-2.0/saml2_subject_confirmation.h>
#include <lasso/xml/saml-2.0/saml2_proxy_restriction.h>
#include <lasso/xml/saml-2.0/saml2_statement_abstract.h>
#include <lasso/xml/saml-2.0/saml2_authn_statement.h>
#include <lasso/xml/saml-2.0/saml2_attribute_statement.h>
#include <lasso/xml/saml-2.0/samlp2_idp_entry.h>
#include <lasso/xml/saml-2.0/samlp2_extensions.h>
#include <lasso/xml/saml-2.0/saml2_action.h>
#include <lasso/xml/saml-2.0/samlp2_status_response.h>
#include <lasso/xml/saml-2.0/samlp2_response.h>
#include <lasso/xml/saml-2.0/samlp2_artifact_response.h>
#include <lasso/xml/saml-2.0/samlp2_request_abstract.h>
#include <lasso/xml/saml-2.0/samlp2_assertion_idrequest.h>
#include <lasso/xml/saml-2.0/samlp2_artifact_resolve.h>
#include <lasso/xml/saml-2.0/samlp2_name_id_mapping_request.h>
#include <lasso/xml/saml-2.0/samlp2_authn_request.h>
#include <lasso/xml/saml-2.0/samlp2_subject_query_abstract.h>
#include <lasso/xml/saml-2.0/samlp2_authz_decision_query.h>
#include <lasso/xml/saml-2.0/samlp2_attribute_query.h>
#include <lasso/xml/saml-2.0/saml2_audience_restriction.h>
#include <lasso/xml/saml-2.0/samlp2_logout_request.h>
#include <lasso/xml/saml-2.0/samlp2_authn_query.h>
#include <lasso/xml/saml-2.0/saml2_attribute.h>
#include <lasso/xml/saml-2.0/samlp2_terminate.h>
#include <lasso/xml/saml-2.0/samlp2_status_detail.h>
#include <lasso/xml/saml-2.0/saml2_authz_decision_statement.h>
#include <lasso/xml/saml-2.0/samlp2_name_id_mapping_response.h>
#include <lasso/xml/saml-2.0/saml2_encrypted_element.h>
#include <lasso/xml/saml-2.0/samlp2_manage_name_id_request.h>
#include <lasso/xml/saml-2.0/samlp2_scoping.h>
#include <lasso/xml/saml-2.0/saml2_subject.h>




/* Constructors, destructors & static methods implementations */

#define new_LassoSamlp2NameIDPolicy lasso_samlp2_name_id_policy_new
#define delete_LassoSamlp2NameIDPolicy(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlp2NameIDPolicy_dump(self) lasso_node_dump(LASSO_NODE(self))





/* Constructors, destructors & static methods implementations */

#define new_LassoSamlp2RequestedAuthnContext lasso_samlp2_requested_authn_context_new
#define delete_LassoSamlp2RequestedAuthnContext(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlp2RequestedAuthnContext_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Issuer */

#define LassoSaml2Assertion_get_Issuer(self) get_node((self)->Issuer)
#define LassoSaml2Assertion_Issuer_get(self) get_node((self)->Issuer)
#define LassoSaml2Assertion_set_Issuer(self,value) set_node((gpointer*)&(self)->Issuer, (value))
#define LassoSaml2Assertion_Issuer_set(self,value) set_node((gpointer*)&(self)->Issuer, (value))
                    

/* Subject */

#define LassoSaml2Assertion_get_Subject(self) get_node((self)->Subject)
#define LassoSaml2Assertion_Subject_get(self) get_node((self)->Subject)
#define LassoSaml2Assertion_set_Subject(self,value) set_node((gpointer*)&(self)->Subject, (value))
#define LassoSaml2Assertion_Subject_set(self,value) set_node((gpointer*)&(self)->Subject, (value))
                    

/* Conditions */

#define LassoSaml2Assertion_get_Conditions(self) get_node((self)->Conditions)
#define LassoSaml2Assertion_Conditions_get(self) get_node((self)->Conditions)
#define LassoSaml2Assertion_set_Conditions(self,value) set_node((gpointer*)&(self)->Conditions, (value))
#define LassoSaml2Assertion_Conditions_set(self,value) set_node((gpointer*)&(self)->Conditions, (value))
                    

/* Advice */

#define LassoSaml2Assertion_get_Advice(self) get_node((self)->Advice)
#define LassoSaml2Assertion_Advice_get(self) get_node((self)->Advice)
#define LassoSaml2Assertion_set_Advice(self,value) set_node((gpointer*)&(self)->Advice, (value))
#define LassoSaml2Assertion_Advice_set(self,value) set_node((gpointer*)&(self)->Advice, (value))
                    


/* Constructors, destructors & static methods implementations */

#define new_LassoSaml2Assertion lasso_saml2_assertion_new
#define delete_LassoSaml2Assertion(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSaml2Assertion_dump(self) lasso_node_dump(LASSO_NODE(self))




/* IDPEntry */

#define LassoSamlp2IDPList_get_IDPEntry(self) get_node((self)->IDPEntry)
#define LassoSamlp2IDPList_IDPEntry_get(self) get_node((self)->IDPEntry)
#define LassoSamlp2IDPList_set_IDPEntry(self,value) set_node((gpointer*)&(self)->IDPEntry, (value))
#define LassoSamlp2IDPList_IDPEntry_set(self,value) set_node((gpointer*)&(self)->IDPEntry, (value))
                    


/* Constructors, destructors & static methods implementations */

#define new_LassoSamlp2IDPList lasso_samlp2_idp_list_new
#define delete_LassoSamlp2IDPList(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlp2IDPList_dump(self) lasso_node_dump(LASSO_NODE(self))





/* Constructors, destructors & static methods implementations */

#define new_LassoSaml2KeyInfoConfirmationData lasso_saml2_key_info_confirmation_data_new
#define delete_LassoSaml2KeyInfoConfirmationData(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSaml2KeyInfoConfirmationData_dump(self) lasso_node_dump(LASSO_NODE(self))





/* Constructors, destructors & static methods implementations */

#define new_LassoSaml2Conditions lasso_saml2_conditions_new
#define delete_LassoSaml2Conditions(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSaml2Conditions_dump(self) lasso_node_dump(LASSO_NODE(self))





/* Constructors, destructors & static methods implementations */

#define new_LassoSaml2Evidence lasso_saml2_evidence_new
#define delete_LassoSaml2Evidence(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSaml2Evidence_dump(self) lasso_node_dump(LASSO_NODE(self))





/* Constructors, destructors & static methods implementations */

#define new_LassoSaml2NameID lasso_saml2_name_id_new
#define delete_LassoSaml2NameID(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSaml2NameID_dump(self) lasso_node_dump(LASSO_NODE(self))




/* StatusCode */

#define LassoSamlp2StatusCode_get_StatusCode(self) get_node((self)->StatusCode)
#define LassoSamlp2StatusCode_StatusCode_get(self) get_node((self)->StatusCode)
#define LassoSamlp2StatusCode_set_StatusCode(self,value) set_node((gpointer*)&(self)->StatusCode, (value))
#define LassoSamlp2StatusCode_StatusCode_set(self,value) set_node((gpointer*)&(self)->StatusCode, (value))
                    


/* Constructors, destructors & static methods implementations */

#define new_LassoSamlp2StatusCode lasso_samlp2_status_code_new
#define delete_LassoSamlp2StatusCode(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlp2StatusCode_dump(self) lasso_node_dump(LASSO_NODE(self))




/* StatusCode */

#define LassoSamlp2Status_get_StatusCode(self) get_node((self)->StatusCode)
#define LassoSamlp2Status_StatusCode_get(self) get_node((self)->StatusCode)
#define LassoSamlp2Status_set_StatusCode(self,value) set_node((gpointer*)&(self)->StatusCode, (value))
#define LassoSamlp2Status_StatusCode_set(self,value) set_node((gpointer*)&(self)->StatusCode, (value))
                    

/* StatusDetail */

#define LassoSamlp2Status_get_StatusDetail(self) get_node((self)->StatusDetail)
#define LassoSamlp2Status_StatusDetail_get(self) get_node((self)->StatusDetail)
#define LassoSamlp2Status_set_StatusDetail(self,value) set_node((gpointer*)&(self)->StatusDetail, (value))
#define LassoSamlp2Status_StatusDetail_set(self,value) set_node((gpointer*)&(self)->StatusDetail, (value))
                    


/* Constructors, destructors & static methods implementations */

#define new_LassoSamlp2Status lasso_samlp2_status_new
#define delete_LassoSamlp2Status(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlp2Status_dump(self) lasso_node_dump(LASSO_NODE(self))





/* Constructors, destructors & static methods implementations */

#define new_LassoSaml2ConditionAbstract lasso_saml2_condition_abstract_new
#define delete_LassoSaml2ConditionAbstract(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSaml2ConditionAbstract_dump(self) lasso_node_dump(LASSO_NODE(self))





/* Constructors, destructors & static methods implementations */

#define new_LassoSaml2OneTimeUse lasso_saml2_one_time_use_new
#define delete_LassoSaml2OneTimeUse(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSaml2OneTimeUse_dump(self) lasso_node_dump(LASSO_NODE(self))





/* Constructors, destructors & static methods implementations */

#define new_LassoSaml2Advice lasso_saml2_advice_new
#define delete_LassoSaml2Advice(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSaml2Advice_dump(self) lasso_node_dump(LASSO_NODE(self))





/* Constructors, destructors & static methods implementations */

#define new_LassoSaml2BaseIDAbstract lasso_saml2_base_idabstract_new
#define delete_LassoSaml2BaseIDAbstract(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSaml2BaseIDAbstract_dump(self) lasso_node_dump(LASSO_NODE(self))





/* Constructors, destructors & static methods implementations */

#define new_LassoSaml2AuthnContext lasso_saml2_authn_context_new
#define delete_LassoSaml2AuthnContext(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSaml2AuthnContext_dump(self) lasso_node_dump(LASSO_NODE(self))





/* Constructors, destructors & static methods implementations */

#define new_LassoSaml2SubjectLocality lasso_saml2_subject_locality_new
#define delete_LassoSaml2SubjectLocality(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSaml2SubjectLocality_dump(self) lasso_node_dump(LASSO_NODE(self))





/* Constructors, destructors & static methods implementations */

#define new_LassoSaml2SubjectConfirmationData lasso_saml2_subject_confirmation_data_new
#define delete_LassoSaml2SubjectConfirmationData(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSaml2SubjectConfirmationData_dump(self) lasso_node_dump(LASSO_NODE(self))




/* BaseID */

#define LassoSaml2SubjectConfirmation_get_BaseID(self) get_node((self)->BaseID)
#define LassoSaml2SubjectConfirmation_BaseID_get(self) get_node((self)->BaseID)
#define LassoSaml2SubjectConfirmation_set_BaseID(self,value) set_node((gpointer*)&(self)->BaseID, (value))
#define LassoSaml2SubjectConfirmation_BaseID_set(self,value) set_node((gpointer*)&(self)->BaseID, (value))
                    

/* NameID */

#define LassoSaml2SubjectConfirmation_get_NameID(self) get_node((self)->NameID)
#define LassoSaml2SubjectConfirmation_NameID_get(self) get_node((self)->NameID)
#define LassoSaml2SubjectConfirmation_set_NameID(self,value) set_node((gpointer*)&(self)->NameID, (value))
#define LassoSaml2SubjectConfirmation_NameID_set(self,value) set_node((gpointer*)&(self)->NameID, (value))
                    

/* EncryptedID */

#define LassoSaml2SubjectConfirmation_get_EncryptedID(self) get_node((self)->EncryptedID)
#define LassoSaml2SubjectConfirmation_EncryptedID_get(self) get_node((self)->EncryptedID)
#define LassoSaml2SubjectConfirmation_set_EncryptedID(self,value) set_node((gpointer*)&(self)->EncryptedID, (value))
#define LassoSaml2SubjectConfirmation_EncryptedID_set(self,value) set_node((gpointer*)&(self)->EncryptedID, (value))
                    

/* SubjectConfirmationData */

#define LassoSaml2SubjectConfirmation_get_SubjectConfirmationData(self) get_node((self)->SubjectConfirmationData)
#define LassoSaml2SubjectConfirmation_SubjectConfirmationData_get(self) get_node((self)->SubjectConfirmationData)
#define LassoSaml2SubjectConfirmation_set_SubjectConfirmationData(self,value) set_node((gpointer*)&(self)->SubjectConfirmationData, (value))
#define LassoSaml2SubjectConfirmation_SubjectConfirmationData_set(self,value) set_node((gpointer*)&(self)->SubjectConfirmationData, (value))
                    


/* Constructors, destructors & static methods implementations */

#define new_LassoSaml2SubjectConfirmation lasso_saml2_subject_confirmation_new
#define delete_LassoSaml2SubjectConfirmation(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSaml2SubjectConfirmation_dump(self) lasso_node_dump(LASSO_NODE(self))





/* Constructors, destructors & static methods implementations */

#define new_LassoSaml2ProxyRestriction lasso_saml2_proxy_restriction_new
#define delete_LassoSaml2ProxyRestriction(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSaml2ProxyRestriction_dump(self) lasso_node_dump(LASSO_NODE(self))





/* Constructors, destructors & static methods implementations */

#define new_LassoSaml2StatementAbstract lasso_saml2_statement_abstract_new
#define delete_LassoSaml2StatementAbstract(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSaml2StatementAbstract_dump(self) lasso_node_dump(LASSO_NODE(self))




/* SubjectLocality */

#define LassoSaml2AuthnStatement_get_SubjectLocality(self) get_node((self)->SubjectLocality)
#define LassoSaml2AuthnStatement_SubjectLocality_get(self) get_node((self)->SubjectLocality)
#define LassoSaml2AuthnStatement_set_SubjectLocality(self,value) set_node((gpointer*)&(self)->SubjectLocality, (value))
#define LassoSaml2AuthnStatement_SubjectLocality_set(self,value) set_node((gpointer*)&(self)->SubjectLocality, (value))
                    

/* AuthnContext */

#define LassoSaml2AuthnStatement_get_AuthnContext(self) get_node((self)->AuthnContext)
#define LassoSaml2AuthnStatement_AuthnContext_get(self) get_node((self)->AuthnContext)
#define LassoSaml2AuthnStatement_set_AuthnContext(self,value) set_node((gpointer*)&(self)->AuthnContext, (value))
#define LassoSaml2AuthnStatement_AuthnContext_set(self,value) set_node((gpointer*)&(self)->AuthnContext, (value))
                    


/* Constructors, destructors & static methods implementations */

#define new_LassoSaml2AuthnStatement lasso_saml2_authn_statement_new
#define delete_LassoSaml2AuthnStatement(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSaml2AuthnStatement_dump(self) lasso_node_dump(LASSO_NODE(self))





/* Constructors, destructors & static methods implementations */

#define new_LassoSaml2AttributeStatement lasso_saml2_attribute_statement_new
#define delete_LassoSaml2AttributeStatement(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSaml2AttributeStatement_dump(self) lasso_node_dump(LASSO_NODE(self))





/* Constructors, destructors & static methods implementations */

#define new_LassoSamlp2IDPEntry lasso_samlp2_idp_entry_new
#define delete_LassoSamlp2IDPEntry(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlp2IDPEntry_dump(self) lasso_node_dump(LASSO_NODE(self))





/* Constructors, destructors & static methods implementations */

#define new_LassoSamlp2Extensions lasso_samlp2_extensions_new
#define delete_LassoSamlp2Extensions(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlp2Extensions_dump(self) lasso_node_dump(LASSO_NODE(self))





/* Constructors, destructors & static methods implementations */

#define new_LassoSaml2Action lasso_saml2_action_new
#define delete_LassoSaml2Action(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSaml2Action_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Issuer */

#define LassoSamlp2StatusResponse_get_Issuer(self) get_node((self)->Issuer)
#define LassoSamlp2StatusResponse_Issuer_get(self) get_node((self)->Issuer)
#define LassoSamlp2StatusResponse_set_Issuer(self,value) set_node((gpointer*)&(self)->Issuer, (value))
#define LassoSamlp2StatusResponse_Issuer_set(self,value) set_node((gpointer*)&(self)->Issuer, (value))
                    

/* Extensions */

#define LassoSamlp2StatusResponse_get_Extensions(self) get_node((self)->Extensions)
#define LassoSamlp2StatusResponse_Extensions_get(self) get_node((self)->Extensions)
#define LassoSamlp2StatusResponse_set_Extensions(self,value) set_node((gpointer*)&(self)->Extensions, (value))
#define LassoSamlp2StatusResponse_Extensions_set(self,value) set_node((gpointer*)&(self)->Extensions, (value))
                    

/* Status */

#define LassoSamlp2StatusResponse_get_Status(self) get_node((self)->Status)
#define LassoSamlp2StatusResponse_Status_get(self) get_node((self)->Status)
#define LassoSamlp2StatusResponse_set_Status(self,value) set_node((gpointer*)&(self)->Status, (value))
#define LassoSamlp2StatusResponse_Status_set(self,value) set_node((gpointer*)&(self)->Status, (value))
                    


/* Constructors, destructors & static methods implementations */

#define new_LassoSamlp2StatusResponse lasso_samlp2_status_response_new
#define delete_LassoSamlp2StatusResponse(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlp2StatusResponse_dump(self) lasso_node_dump(LASSO_NODE(self))




/* inherited from StatusResponse */

/* Issuer */

#define LassoSamlp2Response_get_Issuer(self) get_node(LASSO_SAMLP2_STATUS_RESPONSE(self)->Issuer)
#define LassoSamlp2Response_Issuer_get(self) get_node(LASSO_SAMLP2_STATUS_RESPONSE(self)->Issuer)
#define LassoSamlp2Response_set_Issuer(self,value) set_node((gpointer*)&LASSO_SAMLP2_STATUS_RESPONSE(self)->Issuer, (value))
#define LassoSamlp2Response_Issuer_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_STATUS_RESPONSE(self)->Issuer, (value))
                    

/* Extensions */

#define LassoSamlp2Response_get_Extensions(self) get_node(LASSO_SAMLP2_STATUS_RESPONSE(self)->Extensions)
#define LassoSamlp2Response_Extensions_get(self) get_node(LASSO_SAMLP2_STATUS_RESPONSE(self)->Extensions)
#define LassoSamlp2Response_set_Extensions(self,value) set_node((gpointer*)&LASSO_SAMLP2_STATUS_RESPONSE(self)->Extensions, (value))
#define LassoSamlp2Response_Extensions_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_STATUS_RESPONSE(self)->Extensions, (value))
                    

/* Status */

#define LassoSamlp2Response_get_Status(self) get_node(LASSO_SAMLP2_STATUS_RESPONSE(self)->Status)
#define LassoSamlp2Response_Status_get(self) get_node(LASSO_SAMLP2_STATUS_RESPONSE(self)->Status)
#define LassoSamlp2Response_set_Status(self,value) set_node((gpointer*)&LASSO_SAMLP2_STATUS_RESPONSE(self)->Status, (value))
#define LassoSamlp2Response_Status_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_STATUS_RESPONSE(self)->Status, (value))
                    

/* ID */

#define LassoSamlp2Response_get_ID(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->ID
#define LassoSamlp2Response_ID_get(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->ID

#define LassoSamlp2Response_set_ID(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->ID, (value))
#define LassoSamlp2Response_ID_set(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->ID, (value))

/* InResponseTo */

#define LassoSamlp2Response_get_InResponseTo(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->InResponseTo
#define LassoSamlp2Response_InResponseTo_get(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->InResponseTo

#define LassoSamlp2Response_set_InResponseTo(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->InResponseTo, (value))
#define LassoSamlp2Response_InResponseTo_set(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->InResponseTo, (value))

/* Version */

#define LassoSamlp2Response_get_Version(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->Version
#define LassoSamlp2Response_Version_get(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->Version

#define LassoSamlp2Response_set_Version(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->Version, (value))
#define LassoSamlp2Response_Version_set(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->Version, (value))

/* IssueInstant */

#define LassoSamlp2Response_get_IssueInstant(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->IssueInstant
#define LassoSamlp2Response_IssueInstant_get(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->IssueInstant

#define LassoSamlp2Response_set_IssueInstant(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->IssueInstant, (value))
#define LassoSamlp2Response_IssueInstant_set(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->IssueInstant, (value))

/* Destination */

#define LassoSamlp2Response_get_Destination(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->Destination
#define LassoSamlp2Response_Destination_get(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->Destination

#define LassoSamlp2Response_set_Destination(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->Destination, (value))
#define LassoSamlp2Response_Destination_set(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->Destination, (value))

/* Consent */

#define LassoSamlp2Response_get_Consent(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->Consent
#define LassoSamlp2Response_Consent_get(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->Consent

#define LassoSamlp2Response_set_Consent(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->Consent, (value))
#define LassoSamlp2Response_Consent_set(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->Consent, (value))


/* Constructors, destructors & static methods implementations */

#define new_LassoSamlp2Response lasso_samlp2_response_new
#define delete_LassoSamlp2Response(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlp2Response_dump(self) lasso_node_dump(LASSO_NODE(self))




/* any */

#define LassoSamlp2ArtifactResponse_get_any(self) get_node((self)->any)
#define LassoSamlp2ArtifactResponse_any_get(self) get_node((self)->any)
#define LassoSamlp2ArtifactResponse_set_any(self,value) set_node((gpointer*)&(self)->any, (value))
#define LassoSamlp2ArtifactResponse_any_set(self,value) set_node((gpointer*)&(self)->any, (value))
                    

/* inherited from StatusResponse */

/* Issuer */

#define LassoSamlp2ArtifactResponse_get_Issuer(self) get_node(LASSO_SAMLP2_STATUS_RESPONSE(self)->Issuer)
#define LassoSamlp2ArtifactResponse_Issuer_get(self) get_node(LASSO_SAMLP2_STATUS_RESPONSE(self)->Issuer)
#define LassoSamlp2ArtifactResponse_set_Issuer(self,value) set_node((gpointer*)&LASSO_SAMLP2_STATUS_RESPONSE(self)->Issuer, (value))
#define LassoSamlp2ArtifactResponse_Issuer_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_STATUS_RESPONSE(self)->Issuer, (value))
                    

/* Extensions */

#define LassoSamlp2ArtifactResponse_get_Extensions(self) get_node(LASSO_SAMLP2_STATUS_RESPONSE(self)->Extensions)
#define LassoSamlp2ArtifactResponse_Extensions_get(self) get_node(LASSO_SAMLP2_STATUS_RESPONSE(self)->Extensions)
#define LassoSamlp2ArtifactResponse_set_Extensions(self,value) set_node((gpointer*)&LASSO_SAMLP2_STATUS_RESPONSE(self)->Extensions, (value))
#define LassoSamlp2ArtifactResponse_Extensions_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_STATUS_RESPONSE(self)->Extensions, (value))
                    

/* Status */

#define LassoSamlp2ArtifactResponse_get_Status(self) get_node(LASSO_SAMLP2_STATUS_RESPONSE(self)->Status)
#define LassoSamlp2ArtifactResponse_Status_get(self) get_node(LASSO_SAMLP2_STATUS_RESPONSE(self)->Status)
#define LassoSamlp2ArtifactResponse_set_Status(self,value) set_node((gpointer*)&LASSO_SAMLP2_STATUS_RESPONSE(self)->Status, (value))
#define LassoSamlp2ArtifactResponse_Status_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_STATUS_RESPONSE(self)->Status, (value))
                    

/* ID */

#define LassoSamlp2ArtifactResponse_get_ID(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->ID
#define LassoSamlp2ArtifactResponse_ID_get(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->ID

#define LassoSamlp2ArtifactResponse_set_ID(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->ID, (value))
#define LassoSamlp2ArtifactResponse_ID_set(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->ID, (value))

/* InResponseTo */

#define LassoSamlp2ArtifactResponse_get_InResponseTo(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->InResponseTo
#define LassoSamlp2ArtifactResponse_InResponseTo_get(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->InResponseTo

#define LassoSamlp2ArtifactResponse_set_InResponseTo(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->InResponseTo, (value))
#define LassoSamlp2ArtifactResponse_InResponseTo_set(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->InResponseTo, (value))

/* Version */

#define LassoSamlp2ArtifactResponse_get_Version(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->Version
#define LassoSamlp2ArtifactResponse_Version_get(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->Version

#define LassoSamlp2ArtifactResponse_set_Version(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->Version, (value))
#define LassoSamlp2ArtifactResponse_Version_set(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->Version, (value))

/* IssueInstant */

#define LassoSamlp2ArtifactResponse_get_IssueInstant(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->IssueInstant
#define LassoSamlp2ArtifactResponse_IssueInstant_get(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->IssueInstant

#define LassoSamlp2ArtifactResponse_set_IssueInstant(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->IssueInstant, (value))
#define LassoSamlp2ArtifactResponse_IssueInstant_set(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->IssueInstant, (value))

/* Destination */

#define LassoSamlp2ArtifactResponse_get_Destination(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->Destination
#define LassoSamlp2ArtifactResponse_Destination_get(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->Destination

#define LassoSamlp2ArtifactResponse_set_Destination(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->Destination, (value))
#define LassoSamlp2ArtifactResponse_Destination_set(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->Destination, (value))

/* Consent */

#define LassoSamlp2ArtifactResponse_get_Consent(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->Consent
#define LassoSamlp2ArtifactResponse_Consent_get(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->Consent

#define LassoSamlp2ArtifactResponse_set_Consent(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->Consent, (value))
#define LassoSamlp2ArtifactResponse_Consent_set(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->Consent, (value))


/* Constructors, destructors & static methods implementations */

#define new_LassoSamlp2ArtifactResponse lasso_samlp2_artifact_response_new
#define delete_LassoSamlp2ArtifactResponse(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlp2ArtifactResponse_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Issuer */

#define LassoSamlp2RequestAbstract_get_Issuer(self) get_node((self)->Issuer)
#define LassoSamlp2RequestAbstract_Issuer_get(self) get_node((self)->Issuer)
#define LassoSamlp2RequestAbstract_set_Issuer(self,value) set_node((gpointer*)&(self)->Issuer, (value))
#define LassoSamlp2RequestAbstract_Issuer_set(self,value) set_node((gpointer*)&(self)->Issuer, (value))
                    

/* Extensions */

#define LassoSamlp2RequestAbstract_get_Extensions(self) get_node((self)->Extensions)
#define LassoSamlp2RequestAbstract_Extensions_get(self) get_node((self)->Extensions)
#define LassoSamlp2RequestAbstract_set_Extensions(self,value) set_node((gpointer*)&(self)->Extensions, (value))
#define LassoSamlp2RequestAbstract_Extensions_set(self,value) set_node((gpointer*)&(self)->Extensions, (value))
                    


/* Constructors, destructors & static methods implementations */

#define new_LassoSamlp2RequestAbstract lasso_samlp2_request_abstract_new
#define delete_LassoSamlp2RequestAbstract(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlp2RequestAbstract_dump(self) lasso_node_dump(LASSO_NODE(self))




/* inherited from RequestAbstract */

/* Issuer */

#define LassoSamlp2AssertionIDRequest_get_Issuer(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer)
#define LassoSamlp2AssertionIDRequest_Issuer_get(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer)
#define LassoSamlp2AssertionIDRequest_set_Issuer(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer, (value))
#define LassoSamlp2AssertionIDRequest_Issuer_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer, (value))
                    

/* Extensions */

#define LassoSamlp2AssertionIDRequest_get_Extensions(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions)
#define LassoSamlp2AssertionIDRequest_Extensions_get(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions)
#define LassoSamlp2AssertionIDRequest_set_Extensions(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions, (value))
#define LassoSamlp2AssertionIDRequest_Extensions_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions, (value))
                    

/* ID */

#define LassoSamlp2AssertionIDRequest_get_ID(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID
#define LassoSamlp2AssertionIDRequest_ID_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID

#define LassoSamlp2AssertionIDRequest_set_ID(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID, (value))
#define LassoSamlp2AssertionIDRequest_ID_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID, (value))

/* Version */

#define LassoSamlp2AssertionIDRequest_get_Version(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version
#define LassoSamlp2AssertionIDRequest_Version_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version

#define LassoSamlp2AssertionIDRequest_set_Version(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version, (value))
#define LassoSamlp2AssertionIDRequest_Version_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version, (value))

/* IssueInstant */

#define LassoSamlp2AssertionIDRequest_get_IssueInstant(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoSamlp2AssertionIDRequest_IssueInstant_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant

#define LassoSamlp2AssertionIDRequest_set_IssueInstant(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant, (value))
#define LassoSamlp2AssertionIDRequest_IssueInstant_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant, (value))

/* Destination */

#define LassoSamlp2AssertionIDRequest_get_Destination(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination
#define LassoSamlp2AssertionIDRequest_Destination_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination

#define LassoSamlp2AssertionIDRequest_set_Destination(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination, (value))
#define LassoSamlp2AssertionIDRequest_Destination_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination, (value))

/* Consent */

#define LassoSamlp2AssertionIDRequest_get_Consent(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent
#define LassoSamlp2AssertionIDRequest_Consent_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent

#define LassoSamlp2AssertionIDRequest_set_Consent(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent, (value))
#define LassoSamlp2AssertionIDRequest_Consent_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent, (value))


/* Constructors, destructors & static methods implementations */

#define new_LassoSamlp2AssertionIDRequest lasso_samlp2_assertion_idrequest_new
#define delete_LassoSamlp2AssertionIDRequest(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlp2AssertionIDRequest_dump(self) lasso_node_dump(LASSO_NODE(self))




/* inherited from RequestAbstract */

/* Issuer */

#define LassoSamlp2ArtifactResolve_get_Issuer(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer)
#define LassoSamlp2ArtifactResolve_Issuer_get(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer)
#define LassoSamlp2ArtifactResolve_set_Issuer(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer, (value))
#define LassoSamlp2ArtifactResolve_Issuer_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer, (value))
                    

/* Extensions */

#define LassoSamlp2ArtifactResolve_get_Extensions(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions)
#define LassoSamlp2ArtifactResolve_Extensions_get(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions)
#define LassoSamlp2ArtifactResolve_set_Extensions(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions, (value))
#define LassoSamlp2ArtifactResolve_Extensions_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions, (value))
                    

/* ID */

#define LassoSamlp2ArtifactResolve_get_ID(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID
#define LassoSamlp2ArtifactResolve_ID_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID

#define LassoSamlp2ArtifactResolve_set_ID(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID, (value))
#define LassoSamlp2ArtifactResolve_ID_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID, (value))

/* Version */

#define LassoSamlp2ArtifactResolve_get_Version(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version
#define LassoSamlp2ArtifactResolve_Version_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version

#define LassoSamlp2ArtifactResolve_set_Version(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version, (value))
#define LassoSamlp2ArtifactResolve_Version_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version, (value))

/* IssueInstant */

#define LassoSamlp2ArtifactResolve_get_IssueInstant(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoSamlp2ArtifactResolve_IssueInstant_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant

#define LassoSamlp2ArtifactResolve_set_IssueInstant(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant, (value))
#define LassoSamlp2ArtifactResolve_IssueInstant_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant, (value))

/* Destination */

#define LassoSamlp2ArtifactResolve_get_Destination(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination
#define LassoSamlp2ArtifactResolve_Destination_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination

#define LassoSamlp2ArtifactResolve_set_Destination(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination, (value))
#define LassoSamlp2ArtifactResolve_Destination_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination, (value))

/* Consent */

#define LassoSamlp2ArtifactResolve_get_Consent(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent
#define LassoSamlp2ArtifactResolve_Consent_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent

#define LassoSamlp2ArtifactResolve_set_Consent(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent, (value))
#define LassoSamlp2ArtifactResolve_Consent_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent, (value))


/* Constructors, destructors & static methods implementations */

#define new_LassoSamlp2ArtifactResolve lasso_samlp2_artifact_resolve_new
#define delete_LassoSamlp2ArtifactResolve(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlp2ArtifactResolve_dump(self) lasso_node_dump(LASSO_NODE(self))




/* BaseID */

#define LassoSamlp2NameIDMappingRequest_get_BaseID(self) get_node((self)->BaseID)
#define LassoSamlp2NameIDMappingRequest_BaseID_get(self) get_node((self)->BaseID)
#define LassoSamlp2NameIDMappingRequest_set_BaseID(self,value) set_node((gpointer*)&(self)->BaseID, (value))
#define LassoSamlp2NameIDMappingRequest_BaseID_set(self,value) set_node((gpointer*)&(self)->BaseID, (value))
                    

/* NameID */

#define LassoSamlp2NameIDMappingRequest_get_NameID(self) get_node((self)->NameID)
#define LassoSamlp2NameIDMappingRequest_NameID_get(self) get_node((self)->NameID)
#define LassoSamlp2NameIDMappingRequest_set_NameID(self,value) set_node((gpointer*)&(self)->NameID, (value))
#define LassoSamlp2NameIDMappingRequest_NameID_set(self,value) set_node((gpointer*)&(self)->NameID, (value))
                    

/* EncryptedID */

#define LassoSamlp2NameIDMappingRequest_get_EncryptedID(self) get_node((self)->EncryptedID)
#define LassoSamlp2NameIDMappingRequest_EncryptedID_get(self) get_node((self)->EncryptedID)
#define LassoSamlp2NameIDMappingRequest_set_EncryptedID(self,value) set_node((gpointer*)&(self)->EncryptedID, (value))
#define LassoSamlp2NameIDMappingRequest_EncryptedID_set(self,value) set_node((gpointer*)&(self)->EncryptedID, (value))
                    

/* NameIDPolicy */

#define LassoSamlp2NameIDMappingRequest_get_NameIDPolicy(self) get_node((self)->NameIDPolicy)
#define LassoSamlp2NameIDMappingRequest_NameIDPolicy_get(self) get_node((self)->NameIDPolicy)
#define LassoSamlp2NameIDMappingRequest_set_NameIDPolicy(self,value) set_node((gpointer*)&(self)->NameIDPolicy, (value))
#define LassoSamlp2NameIDMappingRequest_NameIDPolicy_set(self,value) set_node((gpointer*)&(self)->NameIDPolicy, (value))
                    

/* inherited from RequestAbstract */

/* Issuer */

#define LassoSamlp2NameIDMappingRequest_get_Issuer(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer)
#define LassoSamlp2NameIDMappingRequest_Issuer_get(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer)
#define LassoSamlp2NameIDMappingRequest_set_Issuer(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer, (value))
#define LassoSamlp2NameIDMappingRequest_Issuer_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer, (value))
                    

/* Extensions */

#define LassoSamlp2NameIDMappingRequest_get_Extensions(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions)
#define LassoSamlp2NameIDMappingRequest_Extensions_get(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions)
#define LassoSamlp2NameIDMappingRequest_set_Extensions(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions, (value))
#define LassoSamlp2NameIDMappingRequest_Extensions_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions, (value))
                    

/* ID */

#define LassoSamlp2NameIDMappingRequest_get_ID(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID
#define LassoSamlp2NameIDMappingRequest_ID_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID

#define LassoSamlp2NameIDMappingRequest_set_ID(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID, (value))
#define LassoSamlp2NameIDMappingRequest_ID_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID, (value))

/* Version */

#define LassoSamlp2NameIDMappingRequest_get_Version(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version
#define LassoSamlp2NameIDMappingRequest_Version_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version

#define LassoSamlp2NameIDMappingRequest_set_Version(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version, (value))
#define LassoSamlp2NameIDMappingRequest_Version_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version, (value))

/* IssueInstant */

#define LassoSamlp2NameIDMappingRequest_get_IssueInstant(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoSamlp2NameIDMappingRequest_IssueInstant_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant

#define LassoSamlp2NameIDMappingRequest_set_IssueInstant(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant, (value))
#define LassoSamlp2NameIDMappingRequest_IssueInstant_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant, (value))

/* Destination */

#define LassoSamlp2NameIDMappingRequest_get_Destination(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination
#define LassoSamlp2NameIDMappingRequest_Destination_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination

#define LassoSamlp2NameIDMappingRequest_set_Destination(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination, (value))
#define LassoSamlp2NameIDMappingRequest_Destination_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination, (value))

/* Consent */

#define LassoSamlp2NameIDMappingRequest_get_Consent(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent
#define LassoSamlp2NameIDMappingRequest_Consent_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent

#define LassoSamlp2NameIDMappingRequest_set_Consent(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent, (value))
#define LassoSamlp2NameIDMappingRequest_Consent_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent, (value))


/* Constructors, destructors & static methods implementations */

#define new_LassoSamlp2NameIDMappingRequest lasso_samlp2_name_id_mapping_request_new
#define delete_LassoSamlp2NameIDMappingRequest(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlp2NameIDMappingRequest_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Subject */

#define LassoSamlp2AuthnRequest_get_Subject(self) get_node((self)->Subject)
#define LassoSamlp2AuthnRequest_Subject_get(self) get_node((self)->Subject)
#define LassoSamlp2AuthnRequest_set_Subject(self,value) set_node((gpointer*)&(self)->Subject, (value))
#define LassoSamlp2AuthnRequest_Subject_set(self,value) set_node((gpointer*)&(self)->Subject, (value))
                    

/* NameIDPolicy */

#define LassoSamlp2AuthnRequest_get_NameIDPolicy(self) get_node((self)->NameIDPolicy)
#define LassoSamlp2AuthnRequest_NameIDPolicy_get(self) get_node((self)->NameIDPolicy)
#define LassoSamlp2AuthnRequest_set_NameIDPolicy(self,value) set_node((gpointer*)&(self)->NameIDPolicy, (value))
#define LassoSamlp2AuthnRequest_NameIDPolicy_set(self,value) set_node((gpointer*)&(self)->NameIDPolicy, (value))
                    

/* Conditions */

#define LassoSamlp2AuthnRequest_get_Conditions(self) get_node((self)->Conditions)
#define LassoSamlp2AuthnRequest_Conditions_get(self) get_node((self)->Conditions)
#define LassoSamlp2AuthnRequest_set_Conditions(self,value) set_node((gpointer*)&(self)->Conditions, (value))
#define LassoSamlp2AuthnRequest_Conditions_set(self,value) set_node((gpointer*)&(self)->Conditions, (value))
                    

/* RequestedAuthnContext */

#define LassoSamlp2AuthnRequest_get_RequestedAuthnContext(self) get_node((self)->RequestedAuthnContext)
#define LassoSamlp2AuthnRequest_RequestedAuthnContext_get(self) get_node((self)->RequestedAuthnContext)
#define LassoSamlp2AuthnRequest_set_RequestedAuthnContext(self,value) set_node((gpointer*)&(self)->RequestedAuthnContext, (value))
#define LassoSamlp2AuthnRequest_RequestedAuthnContext_set(self,value) set_node((gpointer*)&(self)->RequestedAuthnContext, (value))
                    

/* Scoping */

#define LassoSamlp2AuthnRequest_get_Scoping(self) get_node((self)->Scoping)
#define LassoSamlp2AuthnRequest_Scoping_get(self) get_node((self)->Scoping)
#define LassoSamlp2AuthnRequest_set_Scoping(self,value) set_node((gpointer*)&(self)->Scoping, (value))
#define LassoSamlp2AuthnRequest_Scoping_set(self,value) set_node((gpointer*)&(self)->Scoping, (value))
                    

/* inherited from RequestAbstract */

/* Issuer */

#define LassoSamlp2AuthnRequest_get_Issuer(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer)
#define LassoSamlp2AuthnRequest_Issuer_get(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer)
#define LassoSamlp2AuthnRequest_set_Issuer(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer, (value))
#define LassoSamlp2AuthnRequest_Issuer_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer, (value))
                    

/* Extensions */

#define LassoSamlp2AuthnRequest_get_Extensions(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions)
#define LassoSamlp2AuthnRequest_Extensions_get(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions)
#define LassoSamlp2AuthnRequest_set_Extensions(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions, (value))
#define LassoSamlp2AuthnRequest_Extensions_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions, (value))
                    

/* ID */

#define LassoSamlp2AuthnRequest_get_ID(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID
#define LassoSamlp2AuthnRequest_ID_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID

#define LassoSamlp2AuthnRequest_set_ID(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID, (value))
#define LassoSamlp2AuthnRequest_ID_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID, (value))

/* Version */

#define LassoSamlp2AuthnRequest_get_Version(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version
#define LassoSamlp2AuthnRequest_Version_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version

#define LassoSamlp2AuthnRequest_set_Version(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version, (value))
#define LassoSamlp2AuthnRequest_Version_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version, (value))

/* IssueInstant */

#define LassoSamlp2AuthnRequest_get_IssueInstant(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoSamlp2AuthnRequest_IssueInstant_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant

#define LassoSamlp2AuthnRequest_set_IssueInstant(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant, (value))
#define LassoSamlp2AuthnRequest_IssueInstant_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant, (value))

/* Destination */

#define LassoSamlp2AuthnRequest_get_Destination(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination
#define LassoSamlp2AuthnRequest_Destination_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination

#define LassoSamlp2AuthnRequest_set_Destination(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination, (value))
#define LassoSamlp2AuthnRequest_Destination_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination, (value))

/* Consent */

#define LassoSamlp2AuthnRequest_get_Consent(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent
#define LassoSamlp2AuthnRequest_Consent_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent

#define LassoSamlp2AuthnRequest_set_Consent(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent, (value))
#define LassoSamlp2AuthnRequest_Consent_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent, (value))


/* Constructors, destructors & static methods implementations */

#define new_LassoSamlp2AuthnRequest lasso_samlp2_authn_request_new
#define delete_LassoSamlp2AuthnRequest(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlp2AuthnRequest_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Subject */

#define LassoSamlp2SubjectQueryAbstract_get_Subject(self) get_node((self)->Subject)
#define LassoSamlp2SubjectQueryAbstract_Subject_get(self) get_node((self)->Subject)
#define LassoSamlp2SubjectQueryAbstract_set_Subject(self,value) set_node((gpointer*)&(self)->Subject, (value))
#define LassoSamlp2SubjectQueryAbstract_Subject_set(self,value) set_node((gpointer*)&(self)->Subject, (value))
                    

/* inherited from RequestAbstract */

/* Issuer */

#define LassoSamlp2SubjectQueryAbstract_get_Issuer(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer)
#define LassoSamlp2SubjectQueryAbstract_Issuer_get(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer)
#define LassoSamlp2SubjectQueryAbstract_set_Issuer(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer, (value))
#define LassoSamlp2SubjectQueryAbstract_Issuer_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer, (value))
                    

/* Extensions */

#define LassoSamlp2SubjectQueryAbstract_get_Extensions(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions)
#define LassoSamlp2SubjectQueryAbstract_Extensions_get(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions)
#define LassoSamlp2SubjectQueryAbstract_set_Extensions(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions, (value))
#define LassoSamlp2SubjectQueryAbstract_Extensions_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions, (value))
                    

/* ID */

#define LassoSamlp2SubjectQueryAbstract_get_ID(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID
#define LassoSamlp2SubjectQueryAbstract_ID_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID

#define LassoSamlp2SubjectQueryAbstract_set_ID(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID, (value))
#define LassoSamlp2SubjectQueryAbstract_ID_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID, (value))

/* Version */

#define LassoSamlp2SubjectQueryAbstract_get_Version(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version
#define LassoSamlp2SubjectQueryAbstract_Version_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version

#define LassoSamlp2SubjectQueryAbstract_set_Version(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version, (value))
#define LassoSamlp2SubjectQueryAbstract_Version_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version, (value))

/* IssueInstant */

#define LassoSamlp2SubjectQueryAbstract_get_IssueInstant(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoSamlp2SubjectQueryAbstract_IssueInstant_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant

#define LassoSamlp2SubjectQueryAbstract_set_IssueInstant(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant, (value))
#define LassoSamlp2SubjectQueryAbstract_IssueInstant_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant, (value))

/* Destination */

#define LassoSamlp2SubjectQueryAbstract_get_Destination(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination
#define LassoSamlp2SubjectQueryAbstract_Destination_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination

#define LassoSamlp2SubjectQueryAbstract_set_Destination(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination, (value))
#define LassoSamlp2SubjectQueryAbstract_Destination_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination, (value))

/* Consent */

#define LassoSamlp2SubjectQueryAbstract_get_Consent(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent
#define LassoSamlp2SubjectQueryAbstract_Consent_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent

#define LassoSamlp2SubjectQueryAbstract_set_Consent(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent, (value))
#define LassoSamlp2SubjectQueryAbstract_Consent_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent, (value))


/* Constructors, destructors & static methods implementations */

#define new_LassoSamlp2SubjectQueryAbstract lasso_samlp2_subject_query_abstract_new
#define delete_LassoSamlp2SubjectQueryAbstract(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlp2SubjectQueryAbstract_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Action */

#define LassoSamlp2AuthzDecisionQuery_get_Action(self) get_node((self)->Action)
#define LassoSamlp2AuthzDecisionQuery_Action_get(self) get_node((self)->Action)
#define LassoSamlp2AuthzDecisionQuery_set_Action(self,value) set_node((gpointer*)&(self)->Action, (value))
#define LassoSamlp2AuthzDecisionQuery_Action_set(self,value) set_node((gpointer*)&(self)->Action, (value))
                    

/* Evidence */

#define LassoSamlp2AuthzDecisionQuery_get_Evidence(self) get_node((self)->Evidence)
#define LassoSamlp2AuthzDecisionQuery_Evidence_get(self) get_node((self)->Evidence)
#define LassoSamlp2AuthzDecisionQuery_set_Evidence(self,value) set_node((gpointer*)&(self)->Evidence, (value))
#define LassoSamlp2AuthzDecisionQuery_Evidence_set(self,value) set_node((gpointer*)&(self)->Evidence, (value))
                    

/* inherited from SubjectQueryAbstract */

/* Subject */

#define LassoSamlp2AuthzDecisionQuery_get_Subject(self) get_node(LASSO_SAMLP2_SUBJECT_QUERY_ABSTRACT(self)->Subject)
#define LassoSamlp2AuthzDecisionQuery_Subject_get(self) get_node(LASSO_SAMLP2_SUBJECT_QUERY_ABSTRACT(self)->Subject)
#define LassoSamlp2AuthzDecisionQuery_set_Subject(self,value) set_node((gpointer*)&LASSO_SAMLP2_SUBJECT_QUERY_ABSTRACT(self)->Subject, (value))
#define LassoSamlp2AuthzDecisionQuery_Subject_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_SUBJECT_QUERY_ABSTRACT(self)->Subject, (value))
                    

/* inherited from RequestAbstract */

/* Issuer */

#define LassoSamlp2AuthzDecisionQuery_get_Issuer(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer)
#define LassoSamlp2AuthzDecisionQuery_Issuer_get(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer)
#define LassoSamlp2AuthzDecisionQuery_set_Issuer(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer, (value))
#define LassoSamlp2AuthzDecisionQuery_Issuer_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer, (value))
                    

/* Extensions */

#define LassoSamlp2AuthzDecisionQuery_get_Extensions(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions)
#define LassoSamlp2AuthzDecisionQuery_Extensions_get(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions)
#define LassoSamlp2AuthzDecisionQuery_set_Extensions(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions, (value))
#define LassoSamlp2AuthzDecisionQuery_Extensions_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions, (value))
                    

/* ID */

#define LassoSamlp2AuthzDecisionQuery_get_ID(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID
#define LassoSamlp2AuthzDecisionQuery_ID_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID

#define LassoSamlp2AuthzDecisionQuery_set_ID(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID, (value))
#define LassoSamlp2AuthzDecisionQuery_ID_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID, (value))

/* Version */

#define LassoSamlp2AuthzDecisionQuery_get_Version(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version
#define LassoSamlp2AuthzDecisionQuery_Version_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version

#define LassoSamlp2AuthzDecisionQuery_set_Version(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version, (value))
#define LassoSamlp2AuthzDecisionQuery_Version_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version, (value))

/* IssueInstant */

#define LassoSamlp2AuthzDecisionQuery_get_IssueInstant(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoSamlp2AuthzDecisionQuery_IssueInstant_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant

#define LassoSamlp2AuthzDecisionQuery_set_IssueInstant(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant, (value))
#define LassoSamlp2AuthzDecisionQuery_IssueInstant_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant, (value))

/* Destination */

#define LassoSamlp2AuthzDecisionQuery_get_Destination(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination
#define LassoSamlp2AuthzDecisionQuery_Destination_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination

#define LassoSamlp2AuthzDecisionQuery_set_Destination(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination, (value))
#define LassoSamlp2AuthzDecisionQuery_Destination_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination, (value))

/* Consent */

#define LassoSamlp2AuthzDecisionQuery_get_Consent(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent
#define LassoSamlp2AuthzDecisionQuery_Consent_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent

#define LassoSamlp2AuthzDecisionQuery_set_Consent(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent, (value))
#define LassoSamlp2AuthzDecisionQuery_Consent_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent, (value))


/* Constructors, destructors & static methods implementations */

#define new_LassoSamlp2AuthzDecisionQuery lasso_samlp2_authz_decision_query_new
#define delete_LassoSamlp2AuthzDecisionQuery(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlp2AuthzDecisionQuery_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Attribute */

#define LassoSamlp2AttributeQuery_get_Attribute(self) get_node((self)->Attribute)
#define LassoSamlp2AttributeQuery_Attribute_get(self) get_node((self)->Attribute)
#define LassoSamlp2AttributeQuery_set_Attribute(self,value) set_node((gpointer*)&(self)->Attribute, (value))
#define LassoSamlp2AttributeQuery_Attribute_set(self,value) set_node((gpointer*)&(self)->Attribute, (value))
                    

/* inherited from SubjectQueryAbstract */

/* Subject */

#define LassoSamlp2AttributeQuery_get_Subject(self) get_node(LASSO_SAMLP2_SUBJECT_QUERY_ABSTRACT(self)->Subject)
#define LassoSamlp2AttributeQuery_Subject_get(self) get_node(LASSO_SAMLP2_SUBJECT_QUERY_ABSTRACT(self)->Subject)
#define LassoSamlp2AttributeQuery_set_Subject(self,value) set_node((gpointer*)&LASSO_SAMLP2_SUBJECT_QUERY_ABSTRACT(self)->Subject, (value))
#define LassoSamlp2AttributeQuery_Subject_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_SUBJECT_QUERY_ABSTRACT(self)->Subject, (value))
                    

/* inherited from RequestAbstract */

/* Issuer */

#define LassoSamlp2AttributeQuery_get_Issuer(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer)
#define LassoSamlp2AttributeQuery_Issuer_get(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer)
#define LassoSamlp2AttributeQuery_set_Issuer(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer, (value))
#define LassoSamlp2AttributeQuery_Issuer_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer, (value))
                    

/* Extensions */

#define LassoSamlp2AttributeQuery_get_Extensions(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions)
#define LassoSamlp2AttributeQuery_Extensions_get(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions)
#define LassoSamlp2AttributeQuery_set_Extensions(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions, (value))
#define LassoSamlp2AttributeQuery_Extensions_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions, (value))
                    

/* ID */

#define LassoSamlp2AttributeQuery_get_ID(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID
#define LassoSamlp2AttributeQuery_ID_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID

#define LassoSamlp2AttributeQuery_set_ID(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID, (value))
#define LassoSamlp2AttributeQuery_ID_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID, (value))

/* Version */

#define LassoSamlp2AttributeQuery_get_Version(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version
#define LassoSamlp2AttributeQuery_Version_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version

#define LassoSamlp2AttributeQuery_set_Version(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version, (value))
#define LassoSamlp2AttributeQuery_Version_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version, (value))

/* IssueInstant */

#define LassoSamlp2AttributeQuery_get_IssueInstant(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoSamlp2AttributeQuery_IssueInstant_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant

#define LassoSamlp2AttributeQuery_set_IssueInstant(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant, (value))
#define LassoSamlp2AttributeQuery_IssueInstant_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant, (value))

/* Destination */

#define LassoSamlp2AttributeQuery_get_Destination(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination
#define LassoSamlp2AttributeQuery_Destination_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination

#define LassoSamlp2AttributeQuery_set_Destination(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination, (value))
#define LassoSamlp2AttributeQuery_Destination_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination, (value))

/* Consent */

#define LassoSamlp2AttributeQuery_get_Consent(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent
#define LassoSamlp2AttributeQuery_Consent_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent

#define LassoSamlp2AttributeQuery_set_Consent(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent, (value))
#define LassoSamlp2AttributeQuery_Consent_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent, (value))


/* Constructors, destructors & static methods implementations */

#define new_LassoSamlp2AttributeQuery lasso_samlp2_attribute_query_new
#define delete_LassoSamlp2AttributeQuery(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlp2AttributeQuery_dump(self) lasso_node_dump(LASSO_NODE(self))





/* Constructors, destructors & static methods implementations */

#define new_LassoSaml2AudienceRestriction lasso_saml2_audience_restriction_new
#define delete_LassoSaml2AudienceRestriction(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSaml2AudienceRestriction_dump(self) lasso_node_dump(LASSO_NODE(self))




/* BaseID */

#define LassoSamlp2LogoutRequest_get_BaseID(self) get_node((self)->BaseID)
#define LassoSamlp2LogoutRequest_BaseID_get(self) get_node((self)->BaseID)
#define LassoSamlp2LogoutRequest_set_BaseID(self,value) set_node((gpointer*)&(self)->BaseID, (value))
#define LassoSamlp2LogoutRequest_BaseID_set(self,value) set_node((gpointer*)&(self)->BaseID, (value))
                    

/* NameID */

#define LassoSamlp2LogoutRequest_get_NameID(self) get_node((self)->NameID)
#define LassoSamlp2LogoutRequest_NameID_get(self) get_node((self)->NameID)
#define LassoSamlp2LogoutRequest_set_NameID(self,value) set_node((gpointer*)&(self)->NameID, (value))
#define LassoSamlp2LogoutRequest_NameID_set(self,value) set_node((gpointer*)&(self)->NameID, (value))
                    

/* EncryptedID */

#define LassoSamlp2LogoutRequest_get_EncryptedID(self) get_node((self)->EncryptedID)
#define LassoSamlp2LogoutRequest_EncryptedID_get(self) get_node((self)->EncryptedID)
#define LassoSamlp2LogoutRequest_set_EncryptedID(self,value) set_node((gpointer*)&(self)->EncryptedID, (value))
#define LassoSamlp2LogoutRequest_EncryptedID_set(self,value) set_node((gpointer*)&(self)->EncryptedID, (value))
                    

/* inherited from RequestAbstract */

/* Issuer */

#define LassoSamlp2LogoutRequest_get_Issuer(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer)
#define LassoSamlp2LogoutRequest_Issuer_get(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer)
#define LassoSamlp2LogoutRequest_set_Issuer(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer, (value))
#define LassoSamlp2LogoutRequest_Issuer_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer, (value))
                    

/* Extensions */

#define LassoSamlp2LogoutRequest_get_Extensions(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions)
#define LassoSamlp2LogoutRequest_Extensions_get(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions)
#define LassoSamlp2LogoutRequest_set_Extensions(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions, (value))
#define LassoSamlp2LogoutRequest_Extensions_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions, (value))
                    

/* ID */

#define LassoSamlp2LogoutRequest_get_ID(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID
#define LassoSamlp2LogoutRequest_ID_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID

#define LassoSamlp2LogoutRequest_set_ID(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID, (value))
#define LassoSamlp2LogoutRequest_ID_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID, (value))

/* Version */

#define LassoSamlp2LogoutRequest_get_Version(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version
#define LassoSamlp2LogoutRequest_Version_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version

#define LassoSamlp2LogoutRequest_set_Version(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version, (value))
#define LassoSamlp2LogoutRequest_Version_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version, (value))

/* IssueInstant */

#define LassoSamlp2LogoutRequest_get_IssueInstant(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoSamlp2LogoutRequest_IssueInstant_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant

#define LassoSamlp2LogoutRequest_set_IssueInstant(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant, (value))
#define LassoSamlp2LogoutRequest_IssueInstant_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant, (value))

/* Destination */

#define LassoSamlp2LogoutRequest_get_Destination(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination
#define LassoSamlp2LogoutRequest_Destination_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination

#define LassoSamlp2LogoutRequest_set_Destination(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination, (value))
#define LassoSamlp2LogoutRequest_Destination_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination, (value))

/* Consent */

#define LassoSamlp2LogoutRequest_get_Consent(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent
#define LassoSamlp2LogoutRequest_Consent_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent

#define LassoSamlp2LogoutRequest_set_Consent(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent, (value))
#define LassoSamlp2LogoutRequest_Consent_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent, (value))


/* Constructors, destructors & static methods implementations */

#define new_LassoSamlp2LogoutRequest lasso_samlp2_logout_request_new
#define delete_LassoSamlp2LogoutRequest(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlp2LogoutRequest_dump(self) lasso_node_dump(LASSO_NODE(self))




/* RequestedAuthnContext */

#define LassoSamlp2AuthnQuery_get_RequestedAuthnContext(self) get_node((self)->RequestedAuthnContext)
#define LassoSamlp2AuthnQuery_RequestedAuthnContext_get(self) get_node((self)->RequestedAuthnContext)
#define LassoSamlp2AuthnQuery_set_RequestedAuthnContext(self,value) set_node((gpointer*)&(self)->RequestedAuthnContext, (value))
#define LassoSamlp2AuthnQuery_RequestedAuthnContext_set(self,value) set_node((gpointer*)&(self)->RequestedAuthnContext, (value))
                    

/* inherited from SubjectQueryAbstract */

/* Subject */

#define LassoSamlp2AuthnQuery_get_Subject(self) get_node(LASSO_SAMLP2_SUBJECT_QUERY_ABSTRACT(self)->Subject)
#define LassoSamlp2AuthnQuery_Subject_get(self) get_node(LASSO_SAMLP2_SUBJECT_QUERY_ABSTRACT(self)->Subject)
#define LassoSamlp2AuthnQuery_set_Subject(self,value) set_node((gpointer*)&LASSO_SAMLP2_SUBJECT_QUERY_ABSTRACT(self)->Subject, (value))
#define LassoSamlp2AuthnQuery_Subject_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_SUBJECT_QUERY_ABSTRACT(self)->Subject, (value))
                    

/* inherited from RequestAbstract */

/* Issuer */

#define LassoSamlp2AuthnQuery_get_Issuer(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer)
#define LassoSamlp2AuthnQuery_Issuer_get(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer)
#define LassoSamlp2AuthnQuery_set_Issuer(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer, (value))
#define LassoSamlp2AuthnQuery_Issuer_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer, (value))
                    

/* Extensions */

#define LassoSamlp2AuthnQuery_get_Extensions(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions)
#define LassoSamlp2AuthnQuery_Extensions_get(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions)
#define LassoSamlp2AuthnQuery_set_Extensions(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions, (value))
#define LassoSamlp2AuthnQuery_Extensions_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions, (value))
                    

/* ID */

#define LassoSamlp2AuthnQuery_get_ID(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID
#define LassoSamlp2AuthnQuery_ID_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID

#define LassoSamlp2AuthnQuery_set_ID(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID, (value))
#define LassoSamlp2AuthnQuery_ID_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID, (value))

/* Version */

#define LassoSamlp2AuthnQuery_get_Version(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version
#define LassoSamlp2AuthnQuery_Version_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version

#define LassoSamlp2AuthnQuery_set_Version(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version, (value))
#define LassoSamlp2AuthnQuery_Version_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version, (value))

/* IssueInstant */

#define LassoSamlp2AuthnQuery_get_IssueInstant(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoSamlp2AuthnQuery_IssueInstant_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant

#define LassoSamlp2AuthnQuery_set_IssueInstant(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant, (value))
#define LassoSamlp2AuthnQuery_IssueInstant_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant, (value))

/* Destination */

#define LassoSamlp2AuthnQuery_get_Destination(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination
#define LassoSamlp2AuthnQuery_Destination_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination

#define LassoSamlp2AuthnQuery_set_Destination(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination, (value))
#define LassoSamlp2AuthnQuery_Destination_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination, (value))

/* Consent */

#define LassoSamlp2AuthnQuery_get_Consent(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent
#define LassoSamlp2AuthnQuery_Consent_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent

#define LassoSamlp2AuthnQuery_set_Consent(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent, (value))
#define LassoSamlp2AuthnQuery_Consent_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent, (value))


/* Constructors, destructors & static methods implementations */

#define new_LassoSamlp2AuthnQuery lasso_samlp2_authn_query_new
#define delete_LassoSamlp2AuthnQuery(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlp2AuthnQuery_dump(self) lasso_node_dump(LASSO_NODE(self))





/* Constructors, destructors & static methods implementations */

#define new_LassoSaml2Attribute lasso_saml2_attribute_new
#define delete_LassoSaml2Attribute(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSaml2Attribute_dump(self) lasso_node_dump(LASSO_NODE(self))





/* Constructors, destructors & static methods implementations */

#define new_LassoSamlp2Terminate lasso_samlp2_terminate_new
#define delete_LassoSamlp2Terminate(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlp2Terminate_dump(self) lasso_node_dump(LASSO_NODE(self))





/* Constructors, destructors & static methods implementations */

#define new_LassoSamlp2StatusDetail lasso_samlp2_status_detail_new
#define delete_LassoSamlp2StatusDetail(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlp2StatusDetail_dump(self) lasso_node_dump(LASSO_NODE(self))




/* Action */

#define LassoSaml2AuthzDecisionStatement_get_Action(self) get_node((self)->Action)
#define LassoSaml2AuthzDecisionStatement_Action_get(self) get_node((self)->Action)
#define LassoSaml2AuthzDecisionStatement_set_Action(self,value) set_node((gpointer*)&(self)->Action, (value))
#define LassoSaml2AuthzDecisionStatement_Action_set(self,value) set_node((gpointer*)&(self)->Action, (value))
                    

/* Evidence */

#define LassoSaml2AuthzDecisionStatement_get_Evidence(self) get_node((self)->Evidence)
#define LassoSaml2AuthzDecisionStatement_Evidence_get(self) get_node((self)->Evidence)
#define LassoSaml2AuthzDecisionStatement_set_Evidence(self,value) set_node((gpointer*)&(self)->Evidence, (value))
#define LassoSaml2AuthzDecisionStatement_Evidence_set(self,value) set_node((gpointer*)&(self)->Evidence, (value))
                    


/* Constructors, destructors & static methods implementations */

#define new_LassoSaml2AuthzDecisionStatement lasso_saml2_authz_decision_statement_new
#define delete_LassoSaml2AuthzDecisionStatement(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSaml2AuthzDecisionStatement_dump(self) lasso_node_dump(LASSO_NODE(self))




/* NameID */

#define LassoSamlp2NameIDMappingResponse_get_NameID(self) get_node((self)->NameID)
#define LassoSamlp2NameIDMappingResponse_NameID_get(self) get_node((self)->NameID)
#define LassoSamlp2NameIDMappingResponse_set_NameID(self,value) set_node((gpointer*)&(self)->NameID, (value))
#define LassoSamlp2NameIDMappingResponse_NameID_set(self,value) set_node((gpointer*)&(self)->NameID, (value))
                    

/* EncryptedID */

#define LassoSamlp2NameIDMappingResponse_get_EncryptedID(self) get_node((self)->EncryptedID)
#define LassoSamlp2NameIDMappingResponse_EncryptedID_get(self) get_node((self)->EncryptedID)
#define LassoSamlp2NameIDMappingResponse_set_EncryptedID(self,value) set_node((gpointer*)&(self)->EncryptedID, (value))
#define LassoSamlp2NameIDMappingResponse_EncryptedID_set(self,value) set_node((gpointer*)&(self)->EncryptedID, (value))
                    

/* inherited from StatusResponse */

/* Issuer */

#define LassoSamlp2NameIDMappingResponse_get_Issuer(self) get_node(LASSO_SAMLP2_STATUS_RESPONSE(self)->Issuer)
#define LassoSamlp2NameIDMappingResponse_Issuer_get(self) get_node(LASSO_SAMLP2_STATUS_RESPONSE(self)->Issuer)
#define LassoSamlp2NameIDMappingResponse_set_Issuer(self,value) set_node((gpointer*)&LASSO_SAMLP2_STATUS_RESPONSE(self)->Issuer, (value))
#define LassoSamlp2NameIDMappingResponse_Issuer_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_STATUS_RESPONSE(self)->Issuer, (value))
                    

/* Extensions */

#define LassoSamlp2NameIDMappingResponse_get_Extensions(self) get_node(LASSO_SAMLP2_STATUS_RESPONSE(self)->Extensions)
#define LassoSamlp2NameIDMappingResponse_Extensions_get(self) get_node(LASSO_SAMLP2_STATUS_RESPONSE(self)->Extensions)
#define LassoSamlp2NameIDMappingResponse_set_Extensions(self,value) set_node((gpointer*)&LASSO_SAMLP2_STATUS_RESPONSE(self)->Extensions, (value))
#define LassoSamlp2NameIDMappingResponse_Extensions_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_STATUS_RESPONSE(self)->Extensions, (value))
                    

/* Status */

#define LassoSamlp2NameIDMappingResponse_get_Status(self) get_node(LASSO_SAMLP2_STATUS_RESPONSE(self)->Status)
#define LassoSamlp2NameIDMappingResponse_Status_get(self) get_node(LASSO_SAMLP2_STATUS_RESPONSE(self)->Status)
#define LassoSamlp2NameIDMappingResponse_set_Status(self,value) set_node((gpointer*)&LASSO_SAMLP2_STATUS_RESPONSE(self)->Status, (value))
#define LassoSamlp2NameIDMappingResponse_Status_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_STATUS_RESPONSE(self)->Status, (value))
                    

/* ID */

#define LassoSamlp2NameIDMappingResponse_get_ID(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->ID
#define LassoSamlp2NameIDMappingResponse_ID_get(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->ID

#define LassoSamlp2NameIDMappingResponse_set_ID(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->ID, (value))
#define LassoSamlp2NameIDMappingResponse_ID_set(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->ID, (value))

/* InResponseTo */

#define LassoSamlp2NameIDMappingResponse_get_InResponseTo(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->InResponseTo
#define LassoSamlp2NameIDMappingResponse_InResponseTo_get(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->InResponseTo

#define LassoSamlp2NameIDMappingResponse_set_InResponseTo(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->InResponseTo, (value))
#define LassoSamlp2NameIDMappingResponse_InResponseTo_set(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->InResponseTo, (value))

/* Version */

#define LassoSamlp2NameIDMappingResponse_get_Version(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->Version
#define LassoSamlp2NameIDMappingResponse_Version_get(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->Version

#define LassoSamlp2NameIDMappingResponse_set_Version(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->Version, (value))
#define LassoSamlp2NameIDMappingResponse_Version_set(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->Version, (value))

/* IssueInstant */

#define LassoSamlp2NameIDMappingResponse_get_IssueInstant(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->IssueInstant
#define LassoSamlp2NameIDMappingResponse_IssueInstant_get(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->IssueInstant

#define LassoSamlp2NameIDMappingResponse_set_IssueInstant(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->IssueInstant, (value))
#define LassoSamlp2NameIDMappingResponse_IssueInstant_set(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->IssueInstant, (value))

/* Destination */

#define LassoSamlp2NameIDMappingResponse_get_Destination(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->Destination
#define LassoSamlp2NameIDMappingResponse_Destination_get(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->Destination

#define LassoSamlp2NameIDMappingResponse_set_Destination(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->Destination, (value))
#define LassoSamlp2NameIDMappingResponse_Destination_set(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->Destination, (value))

/* Consent */

#define LassoSamlp2NameIDMappingResponse_get_Consent(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->Consent
#define LassoSamlp2NameIDMappingResponse_Consent_get(self) LASSO_SAMLP2_STATUS_RESPONSE(self)->Consent

#define LassoSamlp2NameIDMappingResponse_set_Consent(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->Consent, (value))
#define LassoSamlp2NameIDMappingResponse_Consent_set(self,value) set_string(&LASSO_SAMLP2_STATUS_RESPONSE(self)->Consent, (value))


/* Constructors, destructors & static methods implementations */

#define new_LassoSamlp2NameIDMappingResponse lasso_samlp2_name_id_mapping_response_new
#define delete_LassoSamlp2NameIDMappingResponse(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlp2NameIDMappingResponse_dump(self) lasso_node_dump(LASSO_NODE(self))





/* Constructors, destructors & static methods implementations */

#define new_LassoSaml2EncryptedElement lasso_saml2_encrypted_element_new
#define delete_LassoSaml2EncryptedElement(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSaml2EncryptedElement_dump(self) lasso_node_dump(LASSO_NODE(self))




/* NameID */

#define LassoSamlp2ManageNameIDRequest_get_NameID(self) get_node((self)->NameID)
#define LassoSamlp2ManageNameIDRequest_NameID_get(self) get_node((self)->NameID)
#define LassoSamlp2ManageNameIDRequest_set_NameID(self,value) set_node((gpointer*)&(self)->NameID, (value))
#define LassoSamlp2ManageNameIDRequest_NameID_set(self,value) set_node((gpointer*)&(self)->NameID, (value))
                    

/* EncryptedID */

#define LassoSamlp2ManageNameIDRequest_get_EncryptedID(self) get_node((self)->EncryptedID)
#define LassoSamlp2ManageNameIDRequest_EncryptedID_get(self) get_node((self)->EncryptedID)
#define LassoSamlp2ManageNameIDRequest_set_EncryptedID(self,value) set_node((gpointer*)&(self)->EncryptedID, (value))
#define LassoSamlp2ManageNameIDRequest_EncryptedID_set(self,value) set_node((gpointer*)&(self)->EncryptedID, (value))
                    

/* NewEncryptedID */

#define LassoSamlp2ManageNameIDRequest_get_NewEncryptedID(self) get_node((self)->NewEncryptedID)
#define LassoSamlp2ManageNameIDRequest_NewEncryptedID_get(self) get_node((self)->NewEncryptedID)
#define LassoSamlp2ManageNameIDRequest_set_NewEncryptedID(self,value) set_node((gpointer*)&(self)->NewEncryptedID, (value))
#define LassoSamlp2ManageNameIDRequest_NewEncryptedID_set(self,value) set_node((gpointer*)&(self)->NewEncryptedID, (value))
                    

/* Terminate */

#define LassoSamlp2ManageNameIDRequest_get_Terminate(self) get_node((self)->Terminate)
#define LassoSamlp2ManageNameIDRequest_Terminate_get(self) get_node((self)->Terminate)
#define LassoSamlp2ManageNameIDRequest_set_Terminate(self,value) set_node((gpointer*)&(self)->Terminate, (value))
#define LassoSamlp2ManageNameIDRequest_Terminate_set(self,value) set_node((gpointer*)&(self)->Terminate, (value))
                    

/* inherited from RequestAbstract */

/* Issuer */

#define LassoSamlp2ManageNameIDRequest_get_Issuer(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer)
#define LassoSamlp2ManageNameIDRequest_Issuer_get(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer)
#define LassoSamlp2ManageNameIDRequest_set_Issuer(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer, (value))
#define LassoSamlp2ManageNameIDRequest_Issuer_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Issuer, (value))
                    

/* Extensions */

#define LassoSamlp2ManageNameIDRequest_get_Extensions(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions)
#define LassoSamlp2ManageNameIDRequest_Extensions_get(self) get_node(LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions)
#define LassoSamlp2ManageNameIDRequest_set_Extensions(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions, (value))
#define LassoSamlp2ManageNameIDRequest_Extensions_set(self,value) set_node((gpointer*)&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Extensions, (value))
                    

/* ID */

#define LassoSamlp2ManageNameIDRequest_get_ID(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID
#define LassoSamlp2ManageNameIDRequest_ID_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID

#define LassoSamlp2ManageNameIDRequest_set_ID(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID, (value))
#define LassoSamlp2ManageNameIDRequest_ID_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->ID, (value))

/* Version */

#define LassoSamlp2ManageNameIDRequest_get_Version(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version
#define LassoSamlp2ManageNameIDRequest_Version_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version

#define LassoSamlp2ManageNameIDRequest_set_Version(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version, (value))
#define LassoSamlp2ManageNameIDRequest_Version_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Version, (value))

/* IssueInstant */

#define LassoSamlp2ManageNameIDRequest_get_IssueInstant(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant
#define LassoSamlp2ManageNameIDRequest_IssueInstant_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant

#define LassoSamlp2ManageNameIDRequest_set_IssueInstant(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant, (value))
#define LassoSamlp2ManageNameIDRequest_IssueInstant_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->IssueInstant, (value))

/* Destination */

#define LassoSamlp2ManageNameIDRequest_get_Destination(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination
#define LassoSamlp2ManageNameIDRequest_Destination_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination

#define LassoSamlp2ManageNameIDRequest_set_Destination(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination, (value))
#define LassoSamlp2ManageNameIDRequest_Destination_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Destination, (value))

/* Consent */

#define LassoSamlp2ManageNameIDRequest_get_Consent(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent
#define LassoSamlp2ManageNameIDRequest_Consent_get(self) LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent

#define LassoSamlp2ManageNameIDRequest_set_Consent(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent, (value))
#define LassoSamlp2ManageNameIDRequest_Consent_set(self,value) set_string(&LASSO_SAMLP2_REQUEST_ABSTRACT(self)->Consent, (value))


/* Constructors, destructors & static methods implementations */

#define new_LassoSamlp2ManageNameIDRequest lasso_samlp2_manage_name_id_request_new
#define delete_LassoSamlp2ManageNameIDRequest(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlp2ManageNameIDRequest_dump(self) lasso_node_dump(LASSO_NODE(self))




/* IDPList */

#define LassoSamlp2Scoping_get_IDPList(self) get_node((self)->IDPList)
#define LassoSamlp2Scoping_IDPList_get(self) get_node((self)->IDPList)
#define LassoSamlp2Scoping_set_IDPList(self,value) set_node((gpointer*)&(self)->IDPList, (value))
#define LassoSamlp2Scoping_IDPList_set(self,value) set_node((gpointer*)&(self)->IDPList, (value))
                    


/* Constructors, destructors & static methods implementations */

#define new_LassoSamlp2Scoping lasso_samlp2_scoping_new
#define delete_LassoSamlp2Scoping(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSamlp2Scoping_dump(self) lasso_node_dump(LASSO_NODE(self))




/* BaseID */

#define LassoSaml2Subject_get_BaseID(self) get_node((self)->BaseID)
#define LassoSaml2Subject_BaseID_get(self) get_node((self)->BaseID)
#define LassoSaml2Subject_set_BaseID(self,value) set_node((gpointer*)&(self)->BaseID, (value))
#define LassoSaml2Subject_BaseID_set(self,value) set_node((gpointer*)&(self)->BaseID, (value))
                    

/* NameID */

#define LassoSaml2Subject_get_NameID(self) get_node((self)->NameID)
#define LassoSaml2Subject_NameID_get(self) get_node((self)->NameID)
#define LassoSaml2Subject_set_NameID(self,value) set_node((gpointer*)&(self)->NameID, (value))
#define LassoSaml2Subject_NameID_set(self,value) set_node((gpointer*)&(self)->NameID, (value))
                    

/* EncryptedID */

#define LassoSaml2Subject_get_EncryptedID(self) get_node((self)->EncryptedID)
#define LassoSaml2Subject_EncryptedID_get(self) get_node((self)->EncryptedID)
#define LassoSaml2Subject_set_EncryptedID(self,value) set_node((gpointer*)&(self)->EncryptedID, (value))
#define LassoSaml2Subject_EncryptedID_set(self,value) set_node((gpointer*)&(self)->EncryptedID, (value))
                    

/* SubjectConfirmation */

#define LassoSaml2Subject_get_SubjectConfirmation(self) get_node((self)->SubjectConfirmation)
#define LassoSaml2Subject_SubjectConfirmation_get(self) get_node((self)->SubjectConfirmation)
#define LassoSaml2Subject_set_SubjectConfirmation(self,value) set_node((gpointer*)&(self)->SubjectConfirmation, (value))
#define LassoSaml2Subject_SubjectConfirmation_set(self,value) set_node((gpointer*)&(self)->SubjectConfirmation, (value))
                    


/* Constructors, destructors & static methods implementations */

#define new_LassoSaml2Subject lasso_saml2_subject_new
#define delete_LassoSaml2Subject(self) lasso_node_destroy(LASSO_NODE(self))

/* Implementations of methods inherited from LassoNode */

#define LassoSaml2Subject_dump(self) lasso_node_dump(LASSO_NODE(self))



#ifdef __cplusplus
extern "C" {
#endif

JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_WSF_1SUPPORT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) 0;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_SAML2_1SUPPORT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) 1;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SAML2_1NAME_1IDENTIFIER_1FORMAT_1PERSISTENT_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SAML2_1NAME_1IDENTIFIER_1FORMAT_1TRANSIENT_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "urn:oasis:names:tc:SAML:2.0:nameid-format:transient";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jobject JNICALL Java_com_entrouvert_lasso_lassoJNI_downcast_1node(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jobject jresult = 0 ;
  LassoNode *arg1 = (LassoNode *) 0 ;
  DowncastableNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNode **)(void *)&jarg1; 
  result = (DowncastableNode *)downcast_node(arg1);
  
  {
    char classPath[256];
    jclass clazz;
    char *name;
    
    name = (char *) G_OBJECT_TYPE_NAME(result);
    name += 5; /* Skip "Lasso" prefix. */
    sprintf(classPath, "com/entrouvert/lasso/%s", name);
    clazz = (*jenv)->FindClass(jenv, classPath);
    if (clazz) {
      jmethodID mid = (*jenv)->GetMethodID(jenv, clazz, "<init>", "(JZ)V");
      if (mid)
      *(void**)&jresult = (*jenv)->NewObject(jenv, clazz, mid, result, false);
    }
  }
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_HTTP_1METHOD_1NONE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoHttpMethod result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoHttpMethod)LASSO_HTTP_METHOD_NONE;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_HTTP_1METHOD_1ANY_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoHttpMethod result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoHttpMethod)LASSO_HTTP_METHOD_ANY;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_HTTP_1METHOD_1IDP_1INITIATED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoHttpMethod result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoHttpMethod)LASSO_HTTP_METHOD_IDP_INITIATED;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_HTTP_1METHOD_1GET_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoHttpMethod result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoHttpMethod)LASSO_HTTP_METHOD_GET;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_HTTP_1METHOD_1POST_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoHttpMethod result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoHttpMethod)LASSO_HTTP_METHOD_POST;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_HTTP_1METHOD_1REDIRECT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoHttpMethod result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoHttpMethod)LASSO_HTTP_METHOD_REDIRECT;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_HTTP_1METHOD_1SOAP_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoHttpMethod result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoHttpMethod)LASSO_HTTP_METHOD_SOAP;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_HTTP_1METHOD_1ARTIFACT_1GET_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoHttpMethod result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoHttpMethod)LASSO_HTTP_METHOD_ARTIFACT_GET;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_HTTP_1METHOD_1ARTIFACT_1POST_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoHttpMethod result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoHttpMethod)LASSO_HTTP_METHOD_ARTIFACT_POST;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_MD_1PROTOCOL_1TYPE_1FEDERATION_1TERMINATION_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoMdProtocolType result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoMdProtocolType)LASSO_MD_PROTOCOL_TYPE_FEDERATION_TERMINATION;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_MD_1PROTOCOL_1TYPE_1NAME_1IDENTIFIER_1MAPPING_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoMdProtocolType result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoMdProtocolType)LASSO_MD_PROTOCOL_TYPE_NAME_IDENTIFIER_MAPPING;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_MD_1PROTOCOL_1TYPE_1REGISTER_1NAME_1IDENTIFIER_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoMdProtocolType result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoMdProtocolType)LASSO_MD_PROTOCOL_TYPE_REGISTER_NAME_IDENTIFIER;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_MD_1PROTOCOL_1TYPE_1SINGLE_1LOGOUT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoMdProtocolType result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoMdProtocolType)LASSO_MD_PROTOCOL_TYPE_SINGLE_LOGOUT;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_MD_1PROTOCOL_1TYPE_1SINGLE_1SIGN_1ON_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoMdProtocolType result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoMdProtocolType)LASSO_MD_PROTOCOL_TYPE_SINGLE_SIGN_ON;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_MD_1PROTOCOL_1TYPE_1ARTIFACT_1RESOLUTION_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoMdProtocolType result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoMdProtocolType)LASSO_MD_PROTOCOL_TYPE_ARTIFACT_RESOLUTION;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_MD_1PROTOCOL_1TYPE_1MANAGE_1NAME_1ID_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoMdProtocolType result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoMdProtocolType)LASSO_MD_PROTOCOL_TYPE_MANAGE_NAME_ID;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LASSO_1MD_1PROTOCOL_1TYPE_1ASSERTION_1ID_1REQUEST_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoMdProtocolType result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoMdProtocolType)LASSO_MD_PROTOCOL_TYPE_ASSERTION_ID_REQUEST;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1CONSENT_1OBTAINED_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "urn:liberty:consent:obtained";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1CONSENT_1OBTAINED_1PRIOR_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "urn:liberty:consent:obtained:prior";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1CONSENT_1OBTAINED_1CURRENT_1IMPLICIT_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "urn:liberty:consent:obtained:current:implicit";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1CONSENT_1OBTAINED_1CURRENT_1EXPLICIT_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "urn:liberty:consent:obtained:current:explicit";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1CONSENT_1UNAVAILABLE_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "urn:liberty:consent:unavailable";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1CONSENT_1INAPPLICABLE_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "urn:liberty:consent:inapplicable";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1NAMEID_1POLICY_1TYPE_1NONE_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "none";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1NAMEID_1POLICY_1TYPE_1ONE_1TIME_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "onetime";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1NAMEID_1POLICY_1TYPE_1FEDERATED_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "federated";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1NAMEID_1POLICY_1TYPE_1ANY_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "any";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1PROTOCOL_1PROFILE_1BRWS_1ART_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://projectliberty.org/profiles/brws-art";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1PROTOCOL_1PROFILE_1BRWS_1POST_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://projectliberty.org/profiles/brws-post";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1PROTOCOL_1PROFILE_1BRWS_1LECP_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://projectliberty.org/profiles/lecp";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1PROTOCOL_1PROFILE_1FED_1TERM_1IDP_1HTTP_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://projectliberty.org/profiles/fedterm-idp-http";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1PROTOCOL_1PROFILE_1FED_1TERM_1IDP_1SOAP_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://projectliberty.org/profiles/fedterm-idp-soap";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1PROTOCOL_1PROFILE_1FED_1TERM_1SP_1HTTP_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://projectliberty.org/profiles/fedterm-sp-http";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1PROTOCOL_1PROFILE_1FED_1TERM_1SP_1SOAP_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://projectliberty.org/profiles/fedterm-sp-soap";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1PROTOCOL_1PROFILE_1RNI_1IDP_1HTTP_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://projectliberty.org/profiles/rni-idp-http";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1PROTOCOL_1PROFILE_1RNI_1IDP_1SOAP_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://projectliberty.org/profiles/rni-idp-soap";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1PROTOCOL_1PROFILE_1RNI_1SP_1HTTP_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://projectliberty.org/profiles/rni-sp-http";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1PROTOCOL_1PROFILE_1RNI_1SP_1SOAP_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://projectliberty.org/profiles/rni-sp-soap";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1PROTOCOL_1PROFILE_1SLO_1IDP_1HTTP_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://projectliberty.org/profiles/slo-idp-http";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1PROTOCOL_1PROFILE_1SLO_1IDP_1SOAP_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://projectliberty.org/profiles/slo-idp-soap";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1PROTOCOL_1PROFILE_1SLO_1SP_1HTTP_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://projectliberty.org/profiles/slo-sp-http";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1PROTOCOL_1PROFILE_1SLO_1SP_1SOAP_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://projectliberty.org/profiles/slo-sp-soap";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LOGIN_1PROTOCOL_1PROFILE_1BRWS_1ART_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoLoginProtocolProfile result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoLoginProtocolProfile)LASSO_LOGIN_PROTOCOL_PROFILE_BRWS_ART;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LOGIN_1PROTOCOL_1PROFILE_1BRWS_1POST_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoLoginProtocolProfile result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoLoginProtocolProfile)LASSO_LOGIN_PROTOCOL_PROFILE_BRWS_POST;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LOGIN_1PROTOCOL_1PROFILE_1BRWS_1LECP_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoLoginProtocolProfile result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoLoginProtocolProfile)LASSO_LOGIN_PROTOCOL_PROFILE_BRWS_LECP;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PROVIDER_1ROLE_1NONE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoProviderRole result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoProviderRole)LASSO_PROVIDER_ROLE_NONE;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PROVIDER_1ROLE_1SP_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoProviderRole result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoProviderRole)LASSO_PROVIDER_ROLE_SP;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PROVIDER_1ROLE_1IDP_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoProviderRole result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoProviderRole)LASSO_PROVIDER_ROLE_IDP;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PROTOCOL_1LIBERTY_11_10_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoProtocolConformance result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoProtocolConformance)LASSO_PROTOCOL_LIBERTY_1_0;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PROTOCOL_1LIBERTY_11_11_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoProtocolConformance result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoProtocolConformance)LASSO_PROTOCOL_LIBERTY_1_1;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PROTOCOL_1LIBERTY_11_12_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoProtocolConformance result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoProtocolConformance)LASSO_PROTOCOL_LIBERTY_1_2;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PROTOCOL_1SAML_12_10_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoProtocolConformance result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoProtocolConformance)LASSO_PROTOCOL_SAML_2_0;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_REQUEST_1TYPE_1INVALID_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoRequestType result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoRequestType)LASSO_REQUEST_TYPE_INVALID;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_REQUEST_1TYPE_1LOGIN_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoRequestType result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoRequestType)LASSO_REQUEST_TYPE_LOGIN;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_REQUEST_1TYPE_1LOGOUT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoRequestType result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoRequestType)LASSO_REQUEST_TYPE_LOGOUT;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_REQUEST_1TYPE_1DEFEDERATION_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoRequestType result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoRequestType)LASSO_REQUEST_TYPE_DEFEDERATION;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_REQUEST_1TYPE_1NAME_1REGISTRATION_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoRequestType result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoRequestType)LASSO_REQUEST_TYPE_NAME_REGISTRATION;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_REQUEST_1TYPE_1NAME_1IDENTIFIER_1MAPPING_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoRequestType result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoRequestType)LASSO_REQUEST_TYPE_NAME_IDENTIFIER_MAPPING;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_REQUEST_1TYPE_1LECP_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoRequestType result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoRequestType)LASSO_REQUEST_TYPE_LECP;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_REQUEST_1TYPE_1DISCO_1QUERY_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoRequestType result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoRequestType)LASSO_REQUEST_TYPE_DISCO_QUERY;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_REQUEST_1TYPE_1DISCO_1MODIFY_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoRequestType result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoRequestType)LASSO_REQUEST_TYPE_DISCO_MODIFY;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_REQUEST_1TYPE_1DST_1QUERY_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoRequestType result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoRequestType)LASSO_REQUEST_TYPE_DST_QUERY;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_REQUEST_1TYPE_1DST_1MODIFY_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoRequestType result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoRequestType)LASSO_REQUEST_TYPE_DST_MODIFY;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_REQUEST_1TYPE_1SASL_1REQUEST_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoRequestType result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoRequestType)LASSO_REQUEST_TYPE_SASL_REQUEST;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1AUTHN_1CONTEXT_1CLASS_1REF_1INTERNET_1PROTOCOL_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://www.projectliberty.org/schemas/authctx/classes/InternetProtocol";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1AUTHN_1CONTEXT_1CLASS_1REF_1INTERNET_1PROTOCOL_1PASSWORD_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://www.projectliberty.org/schemas/authctx/classes/InternetProtocolPassword";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1AUTHN_1CONTEXT_1CLASS_1REF_1MOBILE_1ONE_1FACTOR_1UNREGISTERED_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://www.projectliberty.org/schemas/authctx/classes/MobileOneFactorUnregistered";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1AUTHN_1CONTEXT_1CLASS_1REF_1MOBILE_1TWO_1FACTOR_1UNREGISTERED_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://www.projectliberty.org/schemas/authctx/classes/MobileTwoFactorUnregistered";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1AUTHN_1CONTEXT_1CLASS_1REF_1MOBILE_1ONE_1FACTOR_1CONTRACT_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://www.projectliberty.org/schemas/authctx/classes/MobileOneFactorContract";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1AUTHN_1CONTEXT_1CLASS_1REF_1MOBILE_1TWO_1FACTOR_1CONTRACT_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://www.projectliberty.org/schemas/authctx/classes/MobileTwoFactorContract";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1AUTHN_1CONTEXT_1CLASS_1REF_1PASSWORD_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://www.projectliberty.org/schemas/authctx/classes/Password";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1AUTHN_1CONTEXT_1CLASS_1REF_1PASSWORD_1PROTECTED_1TRANSPORT_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://www.projectliberty.org/schemas/authctx/classes/PasswordProtectedTransport";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1AUTHN_1CONTEXT_1CLASS_1REF_1PREVIOUS_1SESSION_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://www.projectliberty.org/schemas/authctx/classes/PreviousSession";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1AUTHN_1CONTEXT_1CLASS_1REF_1SMARTCARD_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://www.projectliberty.org/schemas/authctx/classes/Smartcard";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1AUTHN_1CONTEXT_1CLASS_1REF_1SMARTCARD_1PKI_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://www.projectliberty.org/schemas/authctx/classes/SmartcardPKI";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1AUTHN_1CONTEXT_1CLASS_1REF_1SOFTWARE_1PKI_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://www.projectliberty.org/schemas/authctx/classes/SoftwarePKI";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1AUTHN_1CONTEXT_1CLASS_1REF_1TIME_1SYNC_1TOKEN_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "http://www.projectliberty.org/schemas/authctx/classes/TimeSyncToken";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1AUTHN_1CONTEXT_1COMPARISON_1EXACT_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "exact";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1AUTHN_1CONTEXT_1COMPARISON_1MINIMUM_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "minimum";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1AUTHN_1CONTEXT_1COMPARISON_1MAXIMUM_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "maximum";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LIB_1AUTHN_1CONTEXT_1COMPARISON_1BETTER_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "better";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SAML_1AUTHENTICATION_1METHOD_1PASSWORD_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "urn:oasis:names:tc:SAML:1.0:am:password";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SAML_1AUTHENTICATION_1METHOD_1KERBEROS_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "urn:ietf:rfc:1510";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SAML_1AUTHENTICATION_1METHOD_1SECURE_1REMOTE_1PASSWORD_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "urn:ietf:rfc:2945";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SAML_1AUTHENTICATION_1METHOD_1HARDWARE_1TOKEN_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "urn:oasis:names:tc:SAML:1.0:am:HardwareToken";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SAML_1AUTHENTICATION_1METHOD_1SMARTCARD_1PKI_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "urn:ietf:rfc:2246";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SAML_1AUTHENTICATION_1METHOD_1SOFTWARE_1PKI_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "urn:oasis:names:tc:SAML:1.0:am:X509-PKI";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SAML_1AUTHENTICATION_1METHOD_1PGP_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "urn:oasis:names:tc:SAML:1.0:am:PGP";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SAML_1AUTHENTICATION_1METHODS_1PKI_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "urn:oasis:names:tc:SAML:1.0:am:SPKI";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SAML_1AUTHENTICATION_1METHOD_1XKMS_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "urn:oasis:names:tc:SAML:1.0:am:XKMS";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SAML_1AUTHENTICATION_1METHOD_1XMLD_1SIG_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "urn:ietf:rfc:3075";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SAML_1AUTHENTICATION_1METHOD_1UNSPECIFIED_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "urn:oasis:names:tc:SAML:1.0:am:unspecified";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SAML_1AUTHENTICATION_1METHOD_1LIBERTY_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "urn:liberty:ac:2003-08";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_SIGNATURE_1METHOD_1RSA_1SHA1_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoSignatureMethod result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSignatureMethod)LASSO_SIGNATURE_METHOD_RSA_SHA1;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_SIGNATURE_1METHOD_1DSA_1SHA1_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoSignatureMethod result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSignatureMethod)LASSO_SIGNATURE_METHOD_DSA_SHA1;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_ERROR_1UNDEFINED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -1;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_ERROR_1UNIMPLEMENTED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -2;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_XML_1ERROR_1NODE_1NOT_1FOUND_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -10;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_XML_1ERROR_1NODE_1CONTENT_1NOT_1FOUND_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -11;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_XML_1ERROR_1ATTR_1NOT_1FOUND_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -12;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_XML_1ERROR_1ATTR_1VALUE_1NOT_1FOUND_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -13;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_DS_1ERROR_1SIGNATURE_1NOT_1FOUND_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) 101;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_DS_1ERROR_1INVALID_1SIGNATURE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) 102;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_DS_1ERROR_1SIGNATURE_1TMPL_1CREATION_1FAILED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -103;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_DS_1ERROR_1CONTEXT_1CREATION_1FAILED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -104;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_DS_1ERROR_1PUBLIC_1KEY_1LOAD_1FAILED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -105;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_DS_1ERROR_1PRIVATE_1KEY_1LOAD_1FAILED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -106;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_DS_1ERROR_1CERTIFICATE_1LOAD_1FAILED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -107;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_DS_1ERROR_1SIGNATURE_1FAILED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -108;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_DS_1ERROR_1KEYS_1MNGR_1CREATION_1FAILED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -109;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_DS_1ERROR_1KEYS_1MNGR_1INIT_1FAILED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -110;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_DS_1ERROR_1SIGNATURE_1VERIFICATION_1FAILED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -111;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_DS_1ERROR_1CA_1CERT_1CHAIN_1LOAD_1FAILED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -112;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_DS_1ERROR_1INVALID_1SIGALG_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -113;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_DS_1ERROR_1DIGEST_1COMPUTE_1FAILED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -114;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LASSO_1DS_1ERROR_1SIGNATURE_1TEMPLATE_1NOT_1FOUND_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -115;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_SERVER_1ERROR_1PROVIDER_1NOT_1FOUND_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -201;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_SERVER_1ERROR_1ADD_1PROVIDER_1FAILED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -202;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LASSO_1SERVER_1ERROR_1ADD_1PROVIDER_1PROTOCOL_1MISMATCH_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -203;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LOGOUT_1ERROR_1UNSUPPORTED_1PROFILE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -301;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LOGOUT_1ERROR_1REQUEST_1DENIED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) 302;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PROFILE_1ERROR_1INVALID_1QUERY_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -401;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PROFILE_1ERROR_1INVALID_1POST_1MSG_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -402;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PROFILE_1ERROR_1INVALID_1SOAP_1MSG_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -403;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PROFILE_1ERROR_1MISSING_1REQUEST_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -404;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PROFILE_1ERROR_1INVALID_1HTTP_1METHOD_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -405;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PROFILE_1ERROR_1INVALID_1PROTOCOLPROFILE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -406;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PROFILE_1ERROR_1INVALID_1MSG_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -407;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PROFILE_1ERROR_1MISSING_1REMOTE_1PROVIDERID_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -408;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PROFILE_1ERROR_1UNSUPPORTED_1PROFILE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -409;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PROFILE_1ERROR_1UNKNOWN_1PROFILE_1URL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -410;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PROFILE_1ERROR_1IDENTITY_1NOT_1FOUND_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -411;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PROFILE_1ERROR_1FEDERATION_1NOT_1FOUND_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -412;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PROFILE_1ERROR_1NAME_1IDENTIFIER_1NOT_1FOUND_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -413;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PROFILE_1ERROR_1BUILDING_1QUERY_1FAILED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -414;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PROFILE_1ERROR_1BUILDING_1REQUEST_1FAILED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -415;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PROFILE_1ERROR_1BUILDING_1MESSAGE_1FAILED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -416;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PROFILE_1ERROR_1BUILDING_1RESPONSE_1FAILED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -417;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PROFILE_1ERROR_1SESSION_1NOT_1FOUND_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -418;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PROFILE_1ERROR_1BAD_1IDENTITY_1DUMP_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -419;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PROFILE_1ERROR_1BAD_1SESSION_1DUMP_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -420;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LASSO_1PARAM_1ERROR_1BAD_1TYPE_1OR_1NULL_1OBJ_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -501;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_PARAM_1ERROR_1INVALID_1VALUE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -502;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LASSO_1PARAM_1ERROR_1CHECK_1FAILED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -503;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LOGIN_1ERROR_1FEDERATION_1NOT_1FOUND_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) 601;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LOGIN_1ERROR_1CONSENT_1NOT_1OBTAINED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) 602;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LOGIN_1ERROR_1INVALID_1NAMEIDPOLICY_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -603;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LOGIN_1ERROR_1REQUEST_1DENIED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) 604;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LOGIN_1ERROR_1INVALID_1SIGNATURE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) 605;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LOGIN_1ERROR_1UNSIGNED_1AUTHN_1REQUEST_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) 606;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LOGIN_1ERROR_1STATUS_1NOT_1SUCCESS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) 607;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LOGIN_1ERROR_1UNKNOWN_1PRINCIPAL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) 608;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_DEFEDERATION_1ERROR_1MISSING_1NAME_1IDENTIFIER_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) -700;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LASSO_1SOAP_1FAULT_1REDIRECT_1REQUEST_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) 800;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_init(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lasso_init();
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_shutdown(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lasso_shutdown();
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_CHECK_1VERSION_1EXACT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoCheckVersionMode result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoCheckVersionMode)LASSO_CHECK_VERSION_EXACT;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_CHECK_1VERSIONABI_1COMPATIBLE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoCheckVersionMode result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoCheckVersionMode)LASSO_CHECK_VERSIONABI_COMPATIBLE;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_CHECK_1VERSION_1NUMERIC_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  LassoCheckVersionMode result;
  
  (void)jenv;
  (void)jcls;
  result = (LassoCheckVersionMode)LASSO_CHECK_VERSION_NUMERIC;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_checkVersion(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3, jint jarg4) {
  jint jresult = 0 ;
  int arg1 ;
  int arg2 ;
  int arg3 ;
  LassoCheckVersionMode arg4 = (LassoCheckVersionMode) LASSO_CHECK_VERSION_NUMERIC ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (LassoCheckVersionMode)jarg4; 
  result = (int)lasso_check_version(arg1,arg2,arg3,arg4);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_registerDstService(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
    if (!arg1) return ;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  lasso_register_dst_service((char const *)arg1,(char const *)arg2);
  
  if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1);
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Node(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoNode *)new_LassoNode();
  
  *(LassoNode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Node(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoNode *arg1 = (LassoNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNode **)(void *)&jarg1; 
  delete_LassoNode(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Node_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoNode *arg1 = (LassoNode *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNode **)(void *)&jarg1; 
  result = (char *)LassoNode_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1NodeList(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoNodeList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoNodeList *)new_LassoNodeList();
  
  *(LassoNodeList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1NodeList(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoNodeList *arg1 = (LassoNodeList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNodeList **)(void *)&jarg1; 
  delete_LassoNodeList(arg1);
  
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_NodeList_1append(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoNodeList *arg1 = (LassoNodeList *) 0 ;
  LassoNode *arg2 = (LassoNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNodeList **)(void *)&jarg1; 
  arg2 = *(LassoNode **)(void *)&jarg2; 
  LassoNodeList_append(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_NodeList_1cast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoNodeList *arg1 = (LassoNodeList *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNodeList **)(void *)&jarg1; 
  result = (void *)LassoNodeList_cast(arg1);
  
  *(void **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_NodeList_1frompointer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  void *arg1 = (void *) 0 ;
  LassoNodeList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)(void *)&jarg1; 
  result = (LassoNodeList *)LassoNodeList_frompointer(arg1);
  
  *(LassoNodeList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_NodeList_1getItem(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  LassoNodeList *arg1 = (LassoNodeList *) 0 ;
  int arg2 ;
  LassoNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNodeList **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  {
    if (arg2 < 0 || arg2 >= arg1->len) {
      char errorMsg[256];
      sprintf(errorMsg, "%d", arg2);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, SWIG_IndexError, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
    result = (LassoNode *)LassoNodeList_getItem(arg1,arg2);
    
  }
  *(LassoNode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NodeList_1length(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoNodeList *arg1 = (LassoNodeList *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNodeList **)(void *)&jarg1; 
  result = (int)LassoNodeList_length(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_NodeList_1setItem(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
  LassoNodeList *arg1 = (LassoNodeList *) 0 ;
  int arg2 ;
  LassoNode *arg3 = (LassoNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNodeList **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(LassoNode **)(void *)&jarg3; 
  {
    if (arg2 < 0 || arg2 >= arg1->len) {
      char errorMsg[256];
      sprintf(errorMsg, "%d", arg2);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, SWIG_IndexError, errorMsg);
        return ;
      }
      /*@SWIG@*/;
    }
    LassoNodeList_setItem(arg1,arg2,arg3);
    
  }
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1StringList(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoStringList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoStringList *)new_LassoStringList();
  
  *(LassoStringList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1StringList(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoStringList *arg1 = (LassoStringList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoStringList **)(void *)&jarg1; 
  delete_LassoStringList(arg1);
  
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_StringList_1append(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoStringList *arg1 = (LassoStringList *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoStringList **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoStringList_append(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_StringList_1cast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoStringList *arg1 = (LassoStringList *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoStringList **)(void *)&jarg1; 
  result = (void *)LassoStringList_cast(arg1);
  
  *(void **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_StringList_1frompointer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  void *arg1 = (void *) 0 ;
  LassoStringList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)(void *)&jarg1; 
  result = (LassoStringList *)LassoStringList_frompointer(arg1);
  
  *(LassoStringList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_StringList_1getItem(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jstring jresult = 0 ;
  LassoStringList *arg1 = (LassoStringList *) 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoStringList **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  {
    if (arg2 < 0 || arg2 >= arg1->len) {
      char errorMsg[256];
      sprintf(errorMsg, "%d", arg2);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, SWIG_IndexError, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
    result = (char *)LassoStringList_getItem(arg1,arg2);
    
  }
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_StringList_1length(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoStringList *arg1 = (LassoStringList *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoStringList **)(void *)&jarg1; 
  result = (int)LassoStringList_length(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_StringList_1setItem(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3) {
  LassoStringList *arg1 = (LassoStringList *) 0 ;
  int arg2 ;
  char *arg3 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoStringList **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return ;
  }
  {
    if (arg2 < 0 || arg2 >= arg1->len) {
      char errorMsg[256];
      sprintf(errorMsg, "%d", arg2);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, SWIG_IndexError, errorMsg);
        return ;
      }
      /*@SWIG@*/;
    }
    LassoStringList_setItem(arg1,arg2,arg3);
    
  }
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAdvice_1assertion_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlAdvice *arg1 = (LassoSamlAdvice *) 0 ;
  LassoSamlAssertion *arg2 = (LassoSamlAssertion *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAdvice **)(void *)&jarg1; 
  arg2 = *(LassoSamlAssertion **)(void *)&jarg2; 
  LassoSamlAdvice_Assertion_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAdvice_1assertion_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlAdvice *arg1 = (LassoSamlAdvice *) 0 ;
  LassoSamlAssertion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAdvice **)(void *)&jarg1; 
  result = (LassoSamlAssertion *)LassoSamlAdvice_Assertion_get(arg1);
  
  *(LassoSamlAssertion **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAdvice_1assertionIdReference_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlAdvice *arg1 = (LassoSamlAdvice *) 0 ;
  LassoStringList *arg2 = (LassoStringList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAdvice **)(void *)&jarg1; 
  arg2 = *(LassoStringList **)(void *)&jarg2; 
  LassoSamlAdvice_assertionIdReference_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAdvice_1assertionIdReference_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlAdvice *arg1 = (LassoSamlAdvice *) 0 ;
  LassoStringList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAdvice **)(void *)&jarg1; 
  result = (LassoStringList *)LassoSamlAdvice_assertionIdReference_get(arg1);
  
  *(LassoStringList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlAdvice(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlAdvice *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlAdvice *)new_LassoSamlAdvice();
  
  *(LassoSamlAdvice **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlAdvice(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlAdvice *arg1 = (LassoSamlAdvice *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAdvice **)(void *)&jarg1; 
  delete_LassoSamlAdvice(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAdvice_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlAdvice *arg1 = (LassoSamlAdvice *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAdvice **)(void *)&jarg1; 
  result = (char *)LassoSamlAdvice_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1assertionId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->AssertionID) free((char*)arg1->AssertionID);
    if (arg2) {
      arg1->AssertionID = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->AssertionID,arg2);
    } else {
      arg1->AssertionID = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1assertionId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  result = (char *) ((arg1)->AssertionID);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1certificateFile_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->certificate_file) free((char*)arg1->certificate_file);
    if (arg2) {
      arg1->certificate_file = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->certificate_file,arg2);
    } else {
      arg1->certificate_file = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1certificateFile_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  result = (char *) ((arg1)->certificate_file);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1issueInstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->IssueInstant) free((char*)arg1->IssueInstant);
    if (arg2) {
      arg1->IssueInstant = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->IssueInstant,arg2);
    } else {
      arg1->IssueInstant = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1issueInstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  result = (char *) ((arg1)->IssueInstant);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1issuer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Issuer) free((char*)arg1->Issuer);
    if (arg2) {
      arg1->Issuer = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Issuer,arg2);
    } else {
      arg1->Issuer = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1issuer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  result = (char *) ((arg1)->Issuer);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1majorVersion_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->MajorVersion = arg2;
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1majorVersion_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  result = (int) ((arg1)->MajorVersion);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1minorVersion_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->MinorVersion = arg2;
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1minorVersion_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  result = (int) ((arg1)->MinorVersion);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1privateKeyFile_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->private_key_file) free((char*)arg1->private_key_file);
    if (arg2) {
      arg1->private_key_file = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->private_key_file,arg2);
    } else {
      arg1->private_key_file = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1privateKeyFile_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  result = (char *) ((arg1)->private_key_file);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1signMethod_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  LassoSignatureMethod arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  arg2 = (LassoSignatureMethod)jarg2; 
  if (arg1) (arg1)->sign_method = arg2;
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1signMethod_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  LassoSignatureMethod result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  result = (LassoSignatureMethod) ((arg1)->sign_method);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1signType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  LassoSignatureType arg2 ;
  LassoSignatureType *argp2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  argp2 = *(LassoSignatureType **)(void *)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
    return ;
  }
  arg2 = *argp2; 
  if (arg1) (arg1)->sign_type = arg2;
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1signType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  LassoSignatureType result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  result =  ((arg1)->sign_type);
  
  {
    LassoSignatureType * resultptr = (LassoSignatureType *) malloc(sizeof(LassoSignatureType));
    memmove(resultptr, &result, sizeof(LassoSignatureType));
    *(LassoSignatureType **)(void *)&jresult = resultptr;
  }
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1advice_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  LassoSamlAdvice *arg2 = (LassoSamlAdvice *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  arg2 = *(LassoSamlAdvice **)(void *)&jarg2; 
  LassoSamlAssertion_Advice_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1advice_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  LassoSamlAdvice *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  result = (LassoSamlAdvice *)LassoSamlAssertion_Advice_get(arg1);
  
  *(LassoSamlAdvice **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1attributeStatement_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  LassoSamlAttributeStatement *arg2 = (LassoSamlAttributeStatement *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  arg2 = *(LassoSamlAttributeStatement **)(void *)&jarg2; 
  LassoSamlAssertion_AttributeStatement_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1attributeStatement_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  LassoSamlAttributeStatement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  result = (LassoSamlAttributeStatement *)LassoSamlAssertion_AttributeStatement_get(arg1);
  
  *(LassoSamlAttributeStatement **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1authenticationStatement_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  LassoSamlAuthenticationStatement *arg2 = (LassoSamlAuthenticationStatement *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  arg2 = *(LassoSamlAuthenticationStatement **)(void *)&jarg2; 
  LassoSamlAssertion_AuthenticationStatement_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1authenticationStatement_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  LassoSamlAuthenticationStatement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  result = (LassoSamlAuthenticationStatement *)LassoSamlAssertion_AuthenticationStatement_get(arg1);
  
  *(LassoSamlAuthenticationStatement **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1conditions_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  LassoSamlConditions *arg2 = (LassoSamlConditions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  arg2 = *(LassoSamlConditions **)(void *)&jarg2; 
  LassoSamlAssertion_Conditions_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1conditions_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  LassoSamlConditions *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  result = (LassoSamlConditions *)LassoSamlAssertion_Conditions_get(arg1);
  
  *(LassoSamlConditions **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1subjectStatement_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  LassoSamlSubjectStatement *arg2 = (LassoSamlSubjectStatement *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  arg2 = *(LassoSamlSubjectStatement **)(void *)&jarg2; 
  LassoSamlAssertion_SubjectStatement_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1subjectStatement_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  LassoSamlSubjectStatement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  result = (LassoSamlSubjectStatement *)LassoSamlAssertion_SubjectStatement_get(arg1);
  
  *(LassoSamlSubjectStatement **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlAssertion(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlAssertion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlAssertion *)new_LassoSamlAssertion();
  
  *(LassoSamlAssertion **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlAssertion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  delete_LassoSamlAssertion(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAssertion_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlAssertion *arg1 = (LassoSamlAssertion *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAssertion **)(void *)&jarg1; 
  result = (char *)LassoSamlAssertion_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAttribute_1attributeName_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlAttribute *arg1 = (LassoSamlAttribute *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAttribute **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlAttribute_AttributeName_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAttribute_1attributeName_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlAttribute *arg1 = (LassoSamlAttribute *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAttribute **)(void *)&jarg1; 
  result = (char *)LassoSamlAttribute_AttributeName_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAttribute_1attributeNamespace_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlAttribute *arg1 = (LassoSamlAttribute *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAttribute **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlAttribute_AttributeNamespace_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAttribute_1attributeNamespace_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlAttribute *arg1 = (LassoSamlAttribute *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAttribute **)(void *)&jarg1; 
  result = (char *)LassoSamlAttribute_AttributeNamespace_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAttribute_1attributeValue_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlAttribute *arg1 = (LassoSamlAttribute *) 0 ;
  LassoNodeList *arg2 = (LassoNodeList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAttribute **)(void *)&jarg1; 
  arg2 = *(LassoNodeList **)(void *)&jarg2; 
  LassoSamlAttribute_AttributeValue_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAttribute_1attributeValue_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlAttribute *arg1 = (LassoSamlAttribute *) 0 ;
  LassoNodeList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAttribute **)(void *)&jarg1; 
  result = (LassoNodeList *)LassoSamlAttribute_AttributeValue_get(arg1);
  
  *(LassoNodeList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlAttribute(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlAttribute *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlAttribute *)new_LassoSamlAttribute();
  
  *(LassoSamlAttribute **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlAttribute(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlAttribute *arg1 = (LassoSamlAttribute *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAttribute **)(void *)&jarg1; 
  delete_LassoSamlAttribute(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAttribute_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlAttribute *arg1 = (LassoSamlAttribute *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAttribute **)(void *)&jarg1; 
  result = (char *)LassoSamlAttribute_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAttributeDesignator_1attributeName_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlAttributeDesignator *arg1 = (LassoSamlAttributeDesignator *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAttributeDesignator **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->AttributeName) free((char*)arg1->AttributeName);
    if (arg2) {
      arg1->AttributeName = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->AttributeName,arg2);
    } else {
      arg1->AttributeName = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAttributeDesignator_1attributeName_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlAttributeDesignator *arg1 = (LassoSamlAttributeDesignator *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAttributeDesignator **)(void *)&jarg1; 
  result = (char *) ((arg1)->AttributeName);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAttributeDesignator_1attributeNamespace_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlAttributeDesignator *arg1 = (LassoSamlAttributeDesignator *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAttributeDesignator **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->AttributeNamespace) free((char*)arg1->AttributeNamespace);
    if (arg2) {
      arg1->AttributeNamespace = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->AttributeNamespace,arg2);
    } else {
      arg1->AttributeNamespace = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAttributeDesignator_1attributeNamespace_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlAttributeDesignator *arg1 = (LassoSamlAttributeDesignator *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAttributeDesignator **)(void *)&jarg1; 
  result = (char *) ((arg1)->AttributeNamespace);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlAttributeDesignator(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlAttributeDesignator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlAttributeDesignator *)new_LassoSamlAttributeDesignator();
  
  *(LassoSamlAttributeDesignator **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlAttributeDesignator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlAttributeDesignator *arg1 = (LassoSamlAttributeDesignator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAttributeDesignator **)(void *)&jarg1; 
  delete_LassoSamlAttributeDesignator(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAttributeDesignator_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlAttributeDesignator *arg1 = (LassoSamlAttributeDesignator *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAttributeDesignator **)(void *)&jarg1; 
  result = (char *)LassoSamlAttributeDesignator_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAttributeStatement_1subject_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlAttributeStatement *arg1 = (LassoSamlAttributeStatement *) 0 ;
  LassoSamlSubject *arg2 = (LassoSamlSubject *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAttributeStatement **)(void *)&jarg1; 
  arg2 = *(LassoSamlSubject **)(void *)&jarg2; 
  LassoSamlAttributeStatement_Subject_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAttributeStatement_1subject_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlAttributeStatement *arg1 = (LassoSamlAttributeStatement *) 0 ;
  LassoSamlSubject *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAttributeStatement **)(void *)&jarg1; 
  result = (LassoSamlSubject *)LassoSamlAttributeStatement_Subject_get(arg1);
  
  *(LassoSamlSubject **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAttributeStatement_1attribute_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlAttributeStatement *arg1 = (LassoSamlAttributeStatement *) 0 ;
  LassoNodeList *arg2 = (LassoNodeList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAttributeStatement **)(void *)&jarg1; 
  arg2 = *(LassoNodeList **)(void *)&jarg2; 
  LassoSamlAttributeStatement_Attribute_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAttributeStatement_1attribute_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlAttributeStatement *arg1 = (LassoSamlAttributeStatement *) 0 ;
  LassoNodeList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAttributeStatement **)(void *)&jarg1; 
  result = (LassoNodeList *)LassoSamlAttributeStatement_Attribute_get(arg1);
  
  *(LassoNodeList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlAttributeStatement(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlAttributeStatement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlAttributeStatement *)new_LassoSamlAttributeStatement();
  
  *(LassoSamlAttributeStatement **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlAttributeStatement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlAttributeStatement *arg1 = (LassoSamlAttributeStatement *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAttributeStatement **)(void *)&jarg1; 
  delete_LassoSamlAttributeStatement(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAttributeStatement_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlAttributeStatement *arg1 = (LassoSamlAttributeStatement *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAttributeStatement **)(void *)&jarg1; 
  result = (char *)LassoSamlAttributeStatement_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAttributeValue_1any_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlAttributeValue *arg1 = (LassoSamlAttributeValue *) 0 ;
  LassoNodeList *arg2 = (LassoNodeList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAttributeValue **)(void *)&jarg1; 
  arg2 = *(LassoNodeList **)(void *)&jarg2; 
  LassoSamlAttributeValue_any_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAttributeValue_1any_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlAttributeValue *arg1 = (LassoSamlAttributeValue *) 0 ;
  LassoNodeList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAttributeValue **)(void *)&jarg1; 
  result = (LassoNodeList *)LassoSamlAttributeValue_any_get(arg1);
  
  *(LassoNodeList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlAttributeValue(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlAttributeValue *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlAttributeValue *)new_LassoSamlAttributeValue();
  
  *(LassoSamlAttributeValue **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlAttributeValue(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlAttributeValue *arg1 = (LassoSamlAttributeValue *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAttributeValue **)(void *)&jarg1; 
  delete_LassoSamlAttributeValue(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAttributeValue_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlAttributeValue *arg1 = (LassoSamlAttributeValue *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAttributeValue **)(void *)&jarg1; 
  result = (char *)LassoSamlAttributeValue_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAudienceRestrictionCondition_1audience_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlAudienceRestrictionCondition *arg1 = (LassoSamlAudienceRestrictionCondition *) 0 ;
  LassoStringList *arg2 = (LassoStringList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAudienceRestrictionCondition **)(void *)&jarg1; 
  arg2 = *(LassoStringList **)(void *)&jarg2; 
  LassoSamlAudienceRestrictionCondition_audience_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAudienceRestrictionCondition_1audience_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlAudienceRestrictionCondition *arg1 = (LassoSamlAudienceRestrictionCondition *) 0 ;
  LassoStringList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAudienceRestrictionCondition **)(void *)&jarg1; 
  result = (LassoStringList *)LassoSamlAudienceRestrictionCondition_audience_get(arg1);
  
  *(LassoStringList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlAudienceRestrictionCondition(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlAudienceRestrictionCondition *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlAudienceRestrictionCondition *)new_LassoSamlAudienceRestrictionCondition();
  
  *(LassoSamlAudienceRestrictionCondition **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlAudienceRestrictionCondition(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlAudienceRestrictionCondition *arg1 = (LassoSamlAudienceRestrictionCondition *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAudienceRestrictionCondition **)(void *)&jarg1; 
  delete_LassoSamlAudienceRestrictionCondition(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAudienceRestrictionCondition_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlAudienceRestrictionCondition *arg1 = (LassoSamlAudienceRestrictionCondition *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAudienceRestrictionCondition **)(void *)&jarg1; 
  result = (char *)LassoSamlAudienceRestrictionCondition_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAuthenticationStatement_1authenticationInstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlAuthenticationStatement *arg1 = (LassoSamlAuthenticationStatement *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAuthenticationStatement **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->AuthenticationInstant) free((char*)arg1->AuthenticationInstant);
    if (arg2) {
      arg1->AuthenticationInstant = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->AuthenticationInstant,arg2);
    } else {
      arg1->AuthenticationInstant = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAuthenticationStatement_1authenticationInstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlAuthenticationStatement *arg1 = (LassoSamlAuthenticationStatement *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAuthenticationStatement **)(void *)&jarg1; 
  result = (char *) ((arg1)->AuthenticationInstant);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAuthenticationStatement_1authenticationMethod_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlAuthenticationStatement *arg1 = (LassoSamlAuthenticationStatement *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAuthenticationStatement **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->AuthenticationMethod) free((char*)arg1->AuthenticationMethod);
    if (arg2) {
      arg1->AuthenticationMethod = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->AuthenticationMethod,arg2);
    } else {
      arg1->AuthenticationMethod = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAuthenticationStatement_1authenticationMethod_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlAuthenticationStatement *arg1 = (LassoSamlAuthenticationStatement *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAuthenticationStatement **)(void *)&jarg1; 
  result = (char *) ((arg1)->AuthenticationMethod);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAuthenticationStatement_1authorityBinding_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlAuthenticationStatement *arg1 = (LassoSamlAuthenticationStatement *) 0 ;
  LassoNodeList *arg2 = (LassoNodeList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAuthenticationStatement **)(void *)&jarg1; 
  arg2 = *(LassoNodeList **)(void *)&jarg2; 
  LassoSamlAuthenticationStatement_AuthorityBinding_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAuthenticationStatement_1authorityBinding_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlAuthenticationStatement *arg1 = (LassoSamlAuthenticationStatement *) 0 ;
  LassoNodeList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAuthenticationStatement **)(void *)&jarg1; 
  result = (LassoNodeList *)LassoSamlAuthenticationStatement_AuthorityBinding_get(arg1);
  
  *(LassoNodeList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAuthenticationStatement_1subjectLocality_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlAuthenticationStatement *arg1 = (LassoSamlAuthenticationStatement *) 0 ;
  LassoSamlSubjectLocality *arg2 = (LassoSamlSubjectLocality *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAuthenticationStatement **)(void *)&jarg1; 
  arg2 = *(LassoSamlSubjectLocality **)(void *)&jarg2; 
  LassoSamlAuthenticationStatement_SubjectLocality_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAuthenticationStatement_1subjectLocality_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlAuthenticationStatement *arg1 = (LassoSamlAuthenticationStatement *) 0 ;
  LassoSamlSubjectLocality *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAuthenticationStatement **)(void *)&jarg1; 
  result = (LassoSamlSubjectLocality *)LassoSamlAuthenticationStatement_SubjectLocality_get(arg1);
  
  *(LassoSamlSubjectLocality **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlAuthenticationStatement(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlAuthenticationStatement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlAuthenticationStatement *)new_LassoSamlAuthenticationStatement();
  
  *(LassoSamlAuthenticationStatement **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlAuthenticationStatement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlAuthenticationStatement *arg1 = (LassoSamlAuthenticationStatement *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAuthenticationStatement **)(void *)&jarg1; 
  delete_LassoSamlAuthenticationStatement(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAuthenticationStatement_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlAuthenticationStatement *arg1 = (LassoSamlAuthenticationStatement *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAuthenticationStatement **)(void *)&jarg1; 
  result = (char *)LassoSamlAuthenticationStatement_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAuthorityBinding_1authorityKind_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlAuthorityBinding *arg1 = (LassoSamlAuthorityBinding *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAuthorityBinding **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->AuthorityKind) free((char*)arg1->AuthorityKind);
    if (arg2) {
      arg1->AuthorityKind = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->AuthorityKind,arg2);
    } else {
      arg1->AuthorityKind = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAuthorityBinding_1authorityKind_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlAuthorityBinding *arg1 = (LassoSamlAuthorityBinding *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAuthorityBinding **)(void *)&jarg1; 
  result = (char *) ((arg1)->AuthorityKind);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAuthorityBinding_1location_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlAuthorityBinding *arg1 = (LassoSamlAuthorityBinding *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAuthorityBinding **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Location) free((char*)arg1->Location);
    if (arg2) {
      arg1->Location = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Location,arg2);
    } else {
      arg1->Location = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAuthorityBinding_1location_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlAuthorityBinding *arg1 = (LassoSamlAuthorityBinding *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAuthorityBinding **)(void *)&jarg1; 
  result = (char *) ((arg1)->Location);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAuthorityBinding_1binding_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlAuthorityBinding *arg1 = (LassoSamlAuthorityBinding *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAuthorityBinding **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Binding) free((char*)arg1->Binding);
    if (arg2) {
      arg1->Binding = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Binding,arg2);
    } else {
      arg1->Binding = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAuthorityBinding_1binding_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlAuthorityBinding *arg1 = (LassoSamlAuthorityBinding *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAuthorityBinding **)(void *)&jarg1; 
  result = (char *) ((arg1)->Binding);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlAuthorityBinding(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlAuthorityBinding *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlAuthorityBinding *)new_LassoSamlAuthorityBinding();
  
  *(LassoSamlAuthorityBinding **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlAuthorityBinding(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlAuthorityBinding *arg1 = (LassoSamlAuthorityBinding *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAuthorityBinding **)(void *)&jarg1; 
  delete_LassoSamlAuthorityBinding(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlAuthorityBinding_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlAuthorityBinding *arg1 = (LassoSamlAuthorityBinding *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlAuthorityBinding **)(void *)&jarg1; 
  result = (char *)LassoSamlAuthorityBinding_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlConditionAbstract_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlConditionAbstract *arg1 = (LassoSamlConditionAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlConditionAbstract **)(void *)&jarg1; 
  result = (char *)LassoSamlConditionAbstract_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlConditions_1notBefore_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlConditions *arg1 = (LassoSamlConditions *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlConditions **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->NotBefore) free((char*)arg1->NotBefore);
    if (arg2) {
      arg1->NotBefore = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->NotBefore,arg2);
    } else {
      arg1->NotBefore = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlConditions_1notBefore_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlConditions *arg1 = (LassoSamlConditions *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlConditions **)(void *)&jarg1; 
  result = (char *) ((arg1)->NotBefore);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlConditions_1notOnOrAfter_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlConditions *arg1 = (LassoSamlConditions *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlConditions **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->NotOnOrAfter) free((char*)arg1->NotOnOrAfter);
    if (arg2) {
      arg1->NotOnOrAfter = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->NotOnOrAfter,arg2);
    } else {
      arg1->NotOnOrAfter = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlConditions_1notOnOrAfter_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlConditions *arg1 = (LassoSamlConditions *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlConditions **)(void *)&jarg1; 
  result = (char *) ((arg1)->NotOnOrAfter);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlConditions_1audienceRestrictionCondition_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlConditions *arg1 = (LassoSamlConditions *) 0 ;
  LassoNodeList *arg2 = (LassoNodeList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlConditions **)(void *)&jarg1; 
  arg2 = *(LassoNodeList **)(void *)&jarg2; 
  LassoSamlConditions_AudienceRestrictionCondition_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlConditions_1audienceRestrictionCondition_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlConditions *arg1 = (LassoSamlConditions *) 0 ;
  LassoNodeList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlConditions **)(void *)&jarg1; 
  result = (LassoNodeList *)LassoSamlConditions_AudienceRestrictionCondition_get(arg1);
  
  *(LassoNodeList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlConditions_1condition_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlConditions *arg1 = (LassoSamlConditions *) 0 ;
  LassoNodeList *arg2 = (LassoNodeList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlConditions **)(void *)&jarg1; 
  arg2 = *(LassoNodeList **)(void *)&jarg2; 
  LassoSamlConditions_Condition_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlConditions_1condition_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlConditions *arg1 = (LassoSamlConditions *) 0 ;
  LassoNodeList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlConditions **)(void *)&jarg1; 
  result = (LassoNodeList *)LassoSamlConditions_Condition_get(arg1);
  
  *(LassoNodeList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlConditions(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlConditions *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlConditions *)new_LassoSamlConditions();
  
  *(LassoSamlConditions **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlConditions(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlConditions *arg1 = (LassoSamlConditions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlConditions **)(void *)&jarg1; 
  delete_LassoSamlConditions(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlConditions_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlConditions *arg1 = (LassoSamlConditions *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlConditions **)(void *)&jarg1; 
  result = (char *)LassoSamlConditions_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlNameIdentifier_1content_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlNameIdentifier *arg1 = (LassoSamlNameIdentifier *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlNameIdentifier **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->content) free((char*)arg1->content);
    if (arg2) {
      arg1->content = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->content,arg2);
    } else {
      arg1->content = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlNameIdentifier_1content_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlNameIdentifier *arg1 = (LassoSamlNameIdentifier *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlNameIdentifier **)(void *)&jarg1; 
  result = (char *) ((arg1)->content);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlNameIdentifier_1format_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlNameIdentifier *arg1 = (LassoSamlNameIdentifier *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlNameIdentifier **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Format) free((char*)arg1->Format);
    if (arg2) {
      arg1->Format = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Format,arg2);
    } else {
      arg1->Format = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlNameIdentifier_1format_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlNameIdentifier *arg1 = (LassoSamlNameIdentifier *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlNameIdentifier **)(void *)&jarg1; 
  result = (char *) ((arg1)->Format);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlNameIdentifier_1nameQualifier_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlNameIdentifier *arg1 = (LassoSamlNameIdentifier *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlNameIdentifier **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->NameQualifier) free((char*)arg1->NameQualifier);
    if (arg2) {
      arg1->NameQualifier = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->NameQualifier,arg2);
    } else {
      arg1->NameQualifier = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlNameIdentifier_1nameQualifier_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlNameIdentifier *arg1 = (LassoSamlNameIdentifier *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlNameIdentifier **)(void *)&jarg1; 
  result = (char *) ((arg1)->NameQualifier);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlNameIdentifier(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlNameIdentifier *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlNameIdentifier *)new_LassoSamlNameIdentifier();
  
  *(LassoSamlNameIdentifier **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlNameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlNameIdentifier *arg1 = (LassoSamlNameIdentifier *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlNameIdentifier **)(void *)&jarg1; 
  delete_LassoSamlNameIdentifier(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlNameIdentifier_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlNameIdentifier *arg1 = (LassoSamlNameIdentifier *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlNameIdentifier **)(void *)&jarg1; 
  result = (char *)LassoSamlNameIdentifier_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlStatementAbstract_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlStatementAbstract *arg1 = (LassoSamlStatementAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlStatementAbstract **)(void *)&jarg1; 
  result = (char *)LassoSamlStatementAbstract_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlSubject_1nameIdentifier_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlSubject *arg1 = (LassoSamlSubject *) 0 ;
  LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlSubject **)(void *)&jarg1; 
  arg2 = *(LassoSamlNameIdentifier **)(void *)&jarg2; 
  LassoSamlSubject_NameIdentifier_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlSubject_1nameIdentifier_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlSubject *arg1 = (LassoSamlSubject *) 0 ;
  LassoSamlNameIdentifier *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlSubject **)(void *)&jarg1; 
  result = (LassoSamlNameIdentifier *)LassoSamlSubject_NameIdentifier_get(arg1);
  
  *(LassoSamlNameIdentifier **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlSubject_1subjectConfirmation_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlSubject *arg1 = (LassoSamlSubject *) 0 ;
  LassoSamlSubjectConfirmation *arg2 = (LassoSamlSubjectConfirmation *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlSubject **)(void *)&jarg1; 
  arg2 = *(LassoSamlSubjectConfirmation **)(void *)&jarg2; 
  LassoSamlSubject_SubjectConfirmation_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlSubject_1subjectConfirmation_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlSubject *arg1 = (LassoSamlSubject *) 0 ;
  LassoSamlSubjectConfirmation *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlSubject **)(void *)&jarg1; 
  result = (LassoSamlSubjectConfirmation *)LassoSamlSubject_SubjectConfirmation_get(arg1);
  
  *(LassoSamlSubjectConfirmation **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlSubject(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlSubject *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlSubject *)new_LassoSamlSubject();
  
  *(LassoSamlSubject **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlSubject(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlSubject *arg1 = (LassoSamlSubject *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlSubject **)(void *)&jarg1; 
  delete_LassoSamlSubject(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlSubject_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlSubject *arg1 = (LassoSamlSubject *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlSubject **)(void *)&jarg1; 
  result = (char *)LassoSamlSubject_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlSubjectConfirmation_1subjectConfirmationData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlSubjectConfirmation *arg1 = (LassoSamlSubjectConfirmation *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlSubjectConfirmation **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->SubjectConfirmationData) free((char*)arg1->SubjectConfirmationData);
    if (arg2) {
      arg1->SubjectConfirmationData = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->SubjectConfirmationData,arg2);
    } else {
      arg1->SubjectConfirmationData = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlSubjectConfirmation_1subjectConfirmationData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlSubjectConfirmation *arg1 = (LassoSamlSubjectConfirmation *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlSubjectConfirmation **)(void *)&jarg1; 
  result = (char *) ((arg1)->SubjectConfirmationData);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlSubjectConfirmation_1confirmationMethod_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlSubjectConfirmation *arg1 = (LassoSamlSubjectConfirmation *) 0 ;
  LassoStringList *arg2 = (LassoStringList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlSubjectConfirmation **)(void *)&jarg1; 
  arg2 = *(LassoStringList **)(void *)&jarg2; 
  LassoSamlSubjectConfirmation_confirmationMethod_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlSubjectConfirmation_1confirmationMethod_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlSubjectConfirmation *arg1 = (LassoSamlSubjectConfirmation *) 0 ;
  LassoStringList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlSubjectConfirmation **)(void *)&jarg1; 
  result = (LassoStringList *)LassoSamlSubjectConfirmation_confirmationMethod_get(arg1);
  
  *(LassoStringList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlSubjectConfirmation(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlSubjectConfirmation *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlSubjectConfirmation *)new_LassoSamlSubjectConfirmation();
  
  *(LassoSamlSubjectConfirmation **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlSubjectConfirmation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlSubjectConfirmation *arg1 = (LassoSamlSubjectConfirmation *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlSubjectConfirmation **)(void *)&jarg1; 
  delete_LassoSamlSubjectConfirmation(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlSubjectConfirmation_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlSubjectConfirmation *arg1 = (LassoSamlSubjectConfirmation *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlSubjectConfirmation **)(void *)&jarg1; 
  result = (char *)LassoSamlSubjectConfirmation_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlSubjectLocality_1dnsAddress_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlSubjectLocality *arg1 = (LassoSamlSubjectLocality *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlSubjectLocality **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->DNSAddress) free((char*)arg1->DNSAddress);
    if (arg2) {
      arg1->DNSAddress = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->DNSAddress,arg2);
    } else {
      arg1->DNSAddress = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlSubjectLocality_1dnsAddress_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlSubjectLocality *arg1 = (LassoSamlSubjectLocality *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlSubjectLocality **)(void *)&jarg1; 
  result = (char *) ((arg1)->DNSAddress);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlSubjectLocality_1ipAddress_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlSubjectLocality *arg1 = (LassoSamlSubjectLocality *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlSubjectLocality **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->IPAddress) free((char*)arg1->IPAddress);
    if (arg2) {
      arg1->IPAddress = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->IPAddress,arg2);
    } else {
      arg1->IPAddress = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlSubjectLocality_1ipAddress_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlSubjectLocality *arg1 = (LassoSamlSubjectLocality *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlSubjectLocality **)(void *)&jarg1; 
  result = (char *) ((arg1)->IPAddress);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlSubjectLocality(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlSubjectLocality *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlSubjectLocality *)new_LassoSamlSubjectLocality();
  
  *(LassoSamlSubjectLocality **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlSubjectLocality(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlSubjectLocality *arg1 = (LassoSamlSubjectLocality *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlSubjectLocality **)(void *)&jarg1; 
  delete_LassoSamlSubjectLocality(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlSubjectLocality_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlSubjectLocality *arg1 = (LassoSamlSubjectLocality *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlSubjectLocality **)(void *)&jarg1; 
  result = (char *)LassoSamlSubjectLocality_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlSubjectStatement_1subject_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlSubjectStatement *arg1 = (LassoSamlSubjectStatement *) 0 ;
  LassoSamlSubject *arg2 = (LassoSamlSubject *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlSubjectStatement **)(void *)&jarg1; 
  arg2 = *(LassoSamlSubject **)(void *)&jarg2; 
  LassoSamlSubjectStatement_Subject_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlSubjectStatement_1subject_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlSubjectStatement *arg1 = (LassoSamlSubjectStatement *) 0 ;
  LassoSamlSubject *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlSubjectStatement **)(void *)&jarg1; 
  result = (LassoSamlSubject *)LassoSamlSubjectStatement_Subject_get(arg1);
  
  *(LassoSamlSubject **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlSubjectStatement(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlSubjectStatement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlSubjectStatement *)new_LassoSamlSubjectStatement();
  
  *(LassoSamlSubjectStatement **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlSubjectStatement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlSubjectStatement *arg1 = (LassoSamlSubjectStatement *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlSubjectStatement **)(void *)&jarg1; 
  delete_LassoSamlSubjectStatement(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlSubjectStatement_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlSubjectStatement *arg1 = (LassoSamlSubjectStatement *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlSubjectStatement **)(void *)&jarg1; 
  result = (char *)LassoSamlSubjectStatement_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlSubjectStatementAbstract_1subject_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlSubjectStatementAbstract *arg1 = (LassoSamlSubjectStatementAbstract *) 0 ;
  LassoSamlSubject *arg2 = (LassoSamlSubject *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlSubjectStatementAbstract **)(void *)&jarg1; 
  arg2 = *(LassoSamlSubject **)(void *)&jarg2; 
  LassoSamlSubjectStatementAbstract_Subject_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlSubjectStatementAbstract_1subject_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlSubjectStatementAbstract *arg1 = (LassoSamlSubjectStatementAbstract *) 0 ;
  LassoSamlSubject *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlSubjectStatementAbstract **)(void *)&jarg1; 
  result = (LassoSamlSubject *)LassoSamlSubjectStatementAbstract_Subject_get(arg1);
  
  *(LassoSamlSubject **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlSubjectStatementAbstract_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlSubjectStatementAbstract *arg1 = (LassoSamlSubjectStatementAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlSubjectStatementAbstract **)(void *)&jarg1; 
  result = (char *)LassoSamlSubjectStatementAbstract_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequest_1assertionArtifact_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->AssertionArtifact) free((char*)arg1->AssertionArtifact);
    if (arg2) {
      arg1->AssertionArtifact = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->AssertionArtifact,arg2);
    } else {
      arg1->AssertionArtifact = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequest_1assertionArtifact_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequest **)(void *)&jarg1; 
  result = (char *) ((arg1)->AssertionArtifact);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequest_1certificateFile_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlpRequest_certificate_file_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequest_1certificateFile_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlpRequest_certificate_file_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequest_1issueInstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlpRequest_IssueInstant_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequest_1issueInstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlpRequest_IssueInstant_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequest_1majorVersion_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequest **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  LassoSamlpRequest_MajorVersion_set(arg1,arg2);
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequest_1majorVersion_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequest **)(void *)&jarg1; 
  result = (int)LassoSamlpRequest_MajorVersion_get(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequest_1minorVersion_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequest **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  LassoSamlpRequest_MinorVersion_set(arg1,arg2);
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequest_1minorVersion_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequest **)(void *)&jarg1; 
  result = (int)LassoSamlpRequest_MinorVersion_get(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequest_1privateKeyFile_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlpRequest_private_key_file_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequest_1privateKeyFile_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlpRequest_private_key_file_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequest_1requestId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlpRequest_RequestID_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequest_1requestId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlpRequest_RequestID_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequest_1respondWith_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
  LassoStringList *arg2 = (LassoStringList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequest **)(void *)&jarg1; 
  arg2 = *(LassoStringList **)(void *)&jarg2; 
  LassoSamlpRequest_RespondWith_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequest_1respondWith_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
  LassoStringList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequest **)(void *)&jarg1; 
  result = (LassoStringList *)LassoSamlpRequest_RespondWith_get(arg1);
  
  *(LassoStringList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequest_1signMethod_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
  LassoSignatureMethod arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequest **)(void *)&jarg1; 
  arg2 = (LassoSignatureMethod)jarg2; 
  LassoSamlpRequest_sign_method_set(arg1,arg2);
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequest_1signMethod_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
  LassoSignatureMethod result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequest **)(void *)&jarg1; 
  result = (LassoSignatureMethod)LassoSamlpRequest_sign_method_get(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequest_1signType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
  LassoSignatureType arg2 ;
  LassoSignatureType *argp2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequest **)(void *)&jarg1; 
  argp2 = *(LassoSignatureType **)(void *)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
    return ;
  }
  arg2 = *argp2; 
  LassoSamlpRequest_sign_type_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequest_1signType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
  LassoSignatureType result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequest **)(void *)&jarg1; 
  result = LassoSamlpRequest_sign_type_get(arg1);
  
  {
    LassoSignatureType * resultptr = (LassoSignatureType *) malloc(sizeof(LassoSignatureType));
    memmove(resultptr, &result, sizeof(LassoSignatureType));
    *(LassoSignatureType **)(void *)&jresult = resultptr;
  }
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlpRequest(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlpRequest *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlpRequest *)new_LassoSamlpRequest();
  
  *(LassoSamlpRequest **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlpRequest(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequest **)(void *)&jarg1; 
  delete_LassoSamlpRequest(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequest_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpRequest *arg1 = (LassoSamlpRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlpRequest_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequestAbstract_1certificateFile_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequestAbstract **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->certificate_file) free((char*)arg1->certificate_file);
    if (arg2) {
      arg1->certificate_file = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->certificate_file,arg2);
    } else {
      arg1->certificate_file = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequestAbstract_1certificateFile_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequestAbstract **)(void *)&jarg1; 
  result = (char *) ((arg1)->certificate_file);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequestAbstract_1issueInstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequestAbstract **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->IssueInstant) free((char*)arg1->IssueInstant);
    if (arg2) {
      arg1->IssueInstant = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->IssueInstant,arg2);
    } else {
      arg1->IssueInstant = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequestAbstract_1issueInstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequestAbstract **)(void *)&jarg1; 
  result = (char *) ((arg1)->IssueInstant);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequestAbstract_1majorVersion_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequestAbstract **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->MajorVersion = arg2;
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequestAbstract_1majorVersion_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequestAbstract **)(void *)&jarg1; 
  result = (int) ((arg1)->MajorVersion);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequestAbstract_1minorVersion_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequestAbstract **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->MinorVersion = arg2;
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequestAbstract_1minorVersion_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequestAbstract **)(void *)&jarg1; 
  result = (int) ((arg1)->MinorVersion);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequestAbstract_1privateKeyFile_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequestAbstract **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->private_key_file) free((char*)arg1->private_key_file);
    if (arg2) {
      arg1->private_key_file = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->private_key_file,arg2);
    } else {
      arg1->private_key_file = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequestAbstract_1privateKeyFile_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequestAbstract **)(void *)&jarg1; 
  result = (char *) ((arg1)->private_key_file);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequestAbstract_1requestId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequestAbstract **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->RequestID) free((char*)arg1->RequestID);
    if (arg2) {
      arg1->RequestID = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->RequestID,arg2);
    } else {
      arg1->RequestID = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequestAbstract_1requestId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequestAbstract **)(void *)&jarg1; 
  result = (char *) ((arg1)->RequestID);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequestAbstract_1signMethod_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
  LassoSignatureMethod arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequestAbstract **)(void *)&jarg1; 
  arg2 = (LassoSignatureMethod)jarg2; 
  if (arg1) (arg1)->sign_method = arg2;
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequestAbstract_1signMethod_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
  LassoSignatureMethod result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequestAbstract **)(void *)&jarg1; 
  result = (LassoSignatureMethod) ((arg1)->sign_method);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequestAbstract_1signType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
  LassoSignatureType arg2 ;
  LassoSignatureType *argp2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequestAbstract **)(void *)&jarg1; 
  argp2 = *(LassoSignatureType **)(void *)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
    return ;
  }
  arg2 = *argp2; 
  if (arg1) (arg1)->sign_type = arg2;
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequestAbstract_1signType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
  LassoSignatureType result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequestAbstract **)(void *)&jarg1; 
  result =  ((arg1)->sign_type);
  
  {
    LassoSignatureType * resultptr = (LassoSignatureType *) malloc(sizeof(LassoSignatureType));
    memmove(resultptr, &result, sizeof(LassoSignatureType));
    *(LassoSignatureType **)(void *)&jresult = resultptr;
  }
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequestAbstract_1respondWith_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
  LassoStringList *arg2 = (LassoStringList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequestAbstract **)(void *)&jarg1; 
  arg2 = *(LassoStringList **)(void *)&jarg2; 
  LassoSamlpRequestAbstract_RespondWith_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequestAbstract_1respondWith_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
  LassoStringList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequestAbstract **)(void *)&jarg1; 
  result = (LassoStringList *)LassoSamlpRequestAbstract_RespondWith_get(arg1);
  
  *(LassoStringList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpRequestAbstract_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpRequestAbstract *arg1 = (LassoSamlpRequestAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpRequestAbstract **)(void *)&jarg1; 
  result = (char *)LassoSamlpRequestAbstract_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponse_1certificateFile_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlpResponse_certificate_file_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponse_1certificateFile_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponse **)(void *)&jarg1; 
  result = (char *)LassoSamlpResponse_certificate_file_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponse_1inResponseTo_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlpResponse_InResponseTo_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponse_1inResponseTo_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponse **)(void *)&jarg1; 
  result = (char *)LassoSamlpResponse_InResponseTo_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponse_1issueInstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlpResponse_IssueInstant_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponse_1issueInstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponse **)(void *)&jarg1; 
  result = (char *)LassoSamlpResponse_IssueInstant_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponse_1majorVersion_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponse **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  LassoSamlpResponse_MajorVersion_set(arg1,arg2);
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponse_1majorVersion_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponse **)(void *)&jarg1; 
  result = (int)LassoSamlpResponse_MajorVersion_get(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponse_1minorVersion_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponse **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  LassoSamlpResponse_MinorVersion_set(arg1,arg2);
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponse_1minorVersion_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponse **)(void *)&jarg1; 
  result = (int)LassoSamlpResponse_MinorVersion_get(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponse_1privateKeyFile_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlpResponse_private_key_file_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponse_1privateKeyFile_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponse **)(void *)&jarg1; 
  result = (char *)LassoSamlpResponse_private_key_file_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponse_1recipient_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlpResponse_Recipient_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponse_1recipient_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponse **)(void *)&jarg1; 
  result = (char *)LassoSamlpResponse_Recipient_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponse_1responseId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlpResponse_ResponseID_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponse_1responseId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponse **)(void *)&jarg1; 
  result = (char *)LassoSamlpResponse_ResponseID_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponse_1signMethod_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
  LassoSignatureMethod arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponse **)(void *)&jarg1; 
  arg2 = (LassoSignatureMethod)jarg2; 
  LassoSamlpResponse_sign_method_set(arg1,arg2);
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponse_1signMethod_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
  LassoSignatureMethod result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponse **)(void *)&jarg1; 
  result = (LassoSignatureMethod)LassoSamlpResponse_sign_method_get(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponse_1signType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
  LassoSignatureType arg2 ;
  LassoSignatureType *argp2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponse **)(void *)&jarg1; 
  argp2 = *(LassoSignatureType **)(void *)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
    return ;
  }
  arg2 = *argp2; 
  LassoSamlpResponse_sign_type_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponse_1signType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
  LassoSignatureType result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponse **)(void *)&jarg1; 
  result = LassoSamlpResponse_sign_type_get(arg1);
  
  {
    LassoSignatureType * resultptr = (LassoSignatureType *) malloc(sizeof(LassoSignatureType));
    memmove(resultptr, &result, sizeof(LassoSignatureType));
    *(LassoSignatureType **)(void *)&jresult = resultptr;
  }
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponse_1assertion_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
  LassoNodeList *arg2 = (LassoNodeList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponse **)(void *)&jarg1; 
  arg2 = *(LassoNodeList **)(void *)&jarg2; 
  LassoSamlpResponse_Assertion_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponse_1assertion_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
  LassoNodeList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponse **)(void *)&jarg1; 
  result = (LassoNodeList *)LassoSamlpResponse_Assertion_get(arg1);
  
  *(LassoNodeList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponse_1status_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
  LassoSamlpStatus *arg2 = (LassoSamlpStatus *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponse **)(void *)&jarg1; 
  arg2 = *(LassoSamlpStatus **)(void *)&jarg2; 
  LassoSamlpResponse_Status_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponse_1status_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
  LassoSamlpStatus *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponse **)(void *)&jarg1; 
  result = (LassoSamlpStatus *)LassoSamlpResponse_Status_get(arg1);
  
  *(LassoSamlpStatus **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlpResponse(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlpResponse *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlpResponse *)new_LassoSamlpResponse();
  
  *(LassoSamlpResponse **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlpResponse(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponse **)(void *)&jarg1; 
  delete_LassoSamlpResponse(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponse_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpResponse *arg1 = (LassoSamlpResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponse **)(void *)&jarg1; 
  result = (char *)LassoSamlpResponse_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponseAbstract_1certificateFile_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponseAbstract **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->certificate_file) free((char*)arg1->certificate_file);
    if (arg2) {
      arg1->certificate_file = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->certificate_file,arg2);
    } else {
      arg1->certificate_file = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponseAbstract_1certificateFile_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponseAbstract **)(void *)&jarg1; 
  result = (char *) ((arg1)->certificate_file);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponseAbstract_1inResponseTo_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponseAbstract **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->InResponseTo) free((char*)arg1->InResponseTo);
    if (arg2) {
      arg1->InResponseTo = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->InResponseTo,arg2);
    } else {
      arg1->InResponseTo = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponseAbstract_1inResponseTo_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponseAbstract **)(void *)&jarg1; 
  result = (char *) ((arg1)->InResponseTo);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponseAbstract_1issueInstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponseAbstract **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->IssueInstant) free((char*)arg1->IssueInstant);
    if (arg2) {
      arg1->IssueInstant = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->IssueInstant,arg2);
    } else {
      arg1->IssueInstant = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponseAbstract_1issueInstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponseAbstract **)(void *)&jarg1; 
  result = (char *) ((arg1)->IssueInstant);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponseAbstract_1majorVersion_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponseAbstract **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->MajorVersion = arg2;
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponseAbstract_1majorVersion_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponseAbstract **)(void *)&jarg1; 
  result = (int) ((arg1)->MajorVersion);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponseAbstract_1minorVersion_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponseAbstract **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->MinorVersion = arg2;
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponseAbstract_1minorVersion_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponseAbstract **)(void *)&jarg1; 
  result = (int) ((arg1)->MinorVersion);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponseAbstract_1privateKeyFile_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponseAbstract **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->private_key_file) free((char*)arg1->private_key_file);
    if (arg2) {
      arg1->private_key_file = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->private_key_file,arg2);
    } else {
      arg1->private_key_file = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponseAbstract_1privateKeyFile_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponseAbstract **)(void *)&jarg1; 
  result = (char *) ((arg1)->private_key_file);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponseAbstract_1recipient_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponseAbstract **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Recipient) free((char*)arg1->Recipient);
    if (arg2) {
      arg1->Recipient = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Recipient,arg2);
    } else {
      arg1->Recipient = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponseAbstract_1recipient_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponseAbstract **)(void *)&jarg1; 
  result = (char *) ((arg1)->Recipient);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponseAbstract_1responseId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponseAbstract **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->ResponseID) free((char*)arg1->ResponseID);
    if (arg2) {
      arg1->ResponseID = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->ResponseID,arg2);
    } else {
      arg1->ResponseID = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponseAbstract_1responseId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponseAbstract **)(void *)&jarg1; 
  result = (char *) ((arg1)->ResponseID);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponseAbstract_1signMethod_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
  LassoSignatureMethod arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponseAbstract **)(void *)&jarg1; 
  arg2 = (LassoSignatureMethod)jarg2; 
  if (arg1) (arg1)->sign_method = arg2;
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponseAbstract_1signMethod_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
  LassoSignatureMethod result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponseAbstract **)(void *)&jarg1; 
  result = (LassoSignatureMethod) ((arg1)->sign_method);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponseAbstract_1signType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
  LassoSignatureType arg2 ;
  LassoSignatureType *argp2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponseAbstract **)(void *)&jarg1; 
  argp2 = *(LassoSignatureType **)(void *)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
    return ;
  }
  arg2 = *argp2; 
  if (arg1) (arg1)->sign_type = arg2;
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponseAbstract_1signType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
  LassoSignatureType result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponseAbstract **)(void *)&jarg1; 
  result =  ((arg1)->sign_type);
  
  {
    LassoSignatureType * resultptr = (LassoSignatureType *) malloc(sizeof(LassoSignatureType));
    memmove(resultptr, &result, sizeof(LassoSignatureType));
    *(LassoSignatureType **)(void *)&jresult = resultptr;
  }
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpResponseAbstract_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpResponseAbstract *arg1 = (LassoSamlpResponseAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpResponseAbstract **)(void *)&jarg1; 
  result = (char *)LassoSamlpResponseAbstract_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpStatus_1statusMessage_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlpStatus *arg1 = (LassoSamlpStatus *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpStatus **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->StatusMessage) free((char*)arg1->StatusMessage);
    if (arg2) {
      arg1->StatusMessage = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->StatusMessage,arg2);
    } else {
      arg1->StatusMessage = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpStatus_1statusMessage_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpStatus *arg1 = (LassoSamlpStatus *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpStatus **)(void *)&jarg1; 
  result = (char *) ((arg1)->StatusMessage);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpStatus_1statusCode_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlpStatus *arg1 = (LassoSamlpStatus *) 0 ;
  LassoSamlpStatusCode *arg2 = (LassoSamlpStatusCode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpStatus **)(void *)&jarg1; 
  arg2 = *(LassoSamlpStatusCode **)(void *)&jarg2; 
  LassoSamlpStatus_StatusCode_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpStatus_1statusCode_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlpStatus *arg1 = (LassoSamlpStatus *) 0 ;
  LassoSamlpStatusCode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpStatus **)(void *)&jarg1; 
  result = (LassoSamlpStatusCode *)LassoSamlpStatus_StatusCode_get(arg1);
  
  *(LassoSamlpStatusCode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlpStatus(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlpStatus *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlpStatus *)new_LassoSamlpStatus();
  
  *(LassoSamlpStatus **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlpStatus(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlpStatus *arg1 = (LassoSamlpStatus *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpStatus **)(void *)&jarg1; 
  delete_LassoSamlpStatus(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpStatus_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpStatus *arg1 = (LassoSamlpStatus *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpStatus **)(void *)&jarg1; 
  result = (char *)LassoSamlpStatus_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpStatusCode_1value_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlpStatusCode *arg1 = (LassoSamlpStatusCode *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpStatusCode **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Value) free((char*)arg1->Value);
    if (arg2) {
      arg1->Value = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Value,arg2);
    } else {
      arg1->Value = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpStatusCode_1value_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpStatusCode *arg1 = (LassoSamlpStatusCode *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpStatusCode **)(void *)&jarg1; 
  result = (char *) ((arg1)->Value);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpStatusCode_1statusCode_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlpStatusCode *arg1 = (LassoSamlpStatusCode *) 0 ;
  LassoSamlpStatusCode *arg2 = (LassoSamlpStatusCode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpStatusCode **)(void *)&jarg1; 
  arg2 = *(LassoSamlpStatusCode **)(void *)&jarg2; 
  LassoSamlpStatusCode_StatusCode_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpStatusCode_1statusCode_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlpStatusCode *arg1 = (LassoSamlpStatusCode *) 0 ;
  LassoSamlpStatusCode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpStatusCode **)(void *)&jarg1; 
  result = (LassoSamlpStatusCode *)LassoSamlpStatusCode_StatusCode_get(arg1);
  
  *(LassoSamlpStatusCode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1SamlpStatusCode(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlpStatusCode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlpStatusCode *)new_LassoSamlpStatusCode();
  
  *(LassoSamlpStatusCode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1SamlpStatusCode(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlpStatusCode *arg1 = (LassoSamlpStatusCode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpStatusCode **)(void *)&jarg1; 
  delete_LassoSamlpStatusCode(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_SamlpStatusCode_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlpStatusCode *arg1 = (LassoSamlpStatusCode *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlpStatusCode **)(void *)&jarg1; 
  result = (char *)LassoSamlpStatusCode_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1advice_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  LassoSamlAdvice *arg2 = (LassoSamlAdvice *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  arg2 = *(LassoSamlAdvice **)(void *)&jarg2; 
  LassoLibAssertion_Advice_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1advice_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  LassoSamlAdvice *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  result = (LassoSamlAdvice *)LassoLibAssertion_Advice_get(arg1);
  
  *(LassoSamlAdvice **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1assertionId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLibAssertion_AssertionID_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1assertionId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  result = (char *)LassoLibAssertion_AssertionID_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1attributeStatement_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  LassoSamlAttributeStatement *arg2 = (LassoSamlAttributeStatement *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  arg2 = *(LassoSamlAttributeStatement **)(void *)&jarg2; 
  LassoLibAssertion_AttributeStatement_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1attributeStatement_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  LassoSamlAttributeStatement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  result = (LassoSamlAttributeStatement *)LassoLibAssertion_AttributeStatement_get(arg1);
  
  *(LassoSamlAttributeStatement **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1authenticationStatement_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  LassoSamlAuthenticationStatement *arg2 = (LassoSamlAuthenticationStatement *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  arg2 = *(LassoSamlAuthenticationStatement **)(void *)&jarg2; 
  LassoLibAssertion_AuthenticationStatement_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1authenticationStatement_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  LassoSamlAuthenticationStatement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  result = (LassoSamlAuthenticationStatement *)LassoLibAssertion_AuthenticationStatement_get(arg1);
  
  *(LassoSamlAuthenticationStatement **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1certificateFile_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLibAssertion_certificate_file_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1certificateFile_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  result = (char *)LassoLibAssertion_certificate_file_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1conditions_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  LassoSamlConditions *arg2 = (LassoSamlConditions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  arg2 = *(LassoSamlConditions **)(void *)&jarg2; 
  LassoLibAssertion_Conditions_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1conditions_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  LassoSamlConditions *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  result = (LassoSamlConditions *)LassoLibAssertion_Conditions_get(arg1);
  
  *(LassoSamlConditions **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1issueInstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLibAssertion_IssueInstant_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1issueInstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  result = (char *)LassoLibAssertion_IssueInstant_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1issuer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLibAssertion_Issuer_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1issuer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  result = (char *)LassoLibAssertion_Issuer_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1majorVersion_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  LassoLibAssertion_MajorVersion_set(arg1,arg2);
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1majorVersion_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  result = (int)LassoLibAssertion_MajorVersion_get(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1minorVersion_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  LassoLibAssertion_MinorVersion_set(arg1,arg2);
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1minorVersion_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  result = (int)LassoLibAssertion_MinorVersion_get(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1privateKeyFile_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLibAssertion_private_key_file_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1privateKeyFile_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  result = (char *)LassoLibAssertion_private_key_file_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1signMethod_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  LassoSignatureMethod arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  arg2 = (LassoSignatureMethod)jarg2; 
  LassoLibAssertion_sign_method_set(arg1,arg2);
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1signMethod_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  LassoSignatureMethod result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  result = (LassoSignatureMethod)LassoLibAssertion_sign_method_get(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1signType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  LassoSignatureType arg2 ;
  LassoSignatureType *argp2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  argp2 = *(LassoSignatureType **)(void *)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
    return ;
  }
  arg2 = *argp2; 
  LassoLibAssertion_sign_type_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1signType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  LassoSignatureType result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  result = LassoLibAssertion_sign_type_get(arg1);
  
  {
    LassoSignatureType * resultptr = (LassoSignatureType *) malloc(sizeof(LassoSignatureType));
    memmove(resultptr, &result, sizeof(LassoSignatureType));
    *(LassoSignatureType **)(void *)&jresult = resultptr;
  }
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1subjectStatement_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  LassoSamlSubjectStatement *arg2 = (LassoSamlSubjectStatement *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  arg2 = *(LassoSamlSubjectStatement **)(void *)&jarg2; 
  LassoLibAssertion_SubjectStatement_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1subjectStatement_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  LassoSamlSubjectStatement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  result = (LassoSamlSubjectStatement *)LassoLibAssertion_SubjectStatement_get(arg1);
  
  *(LassoSamlSubjectStatement **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1LibAssertion(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoLibAssertion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoLibAssertion *)new_LassoLibAssertion();
  
  *(LassoLibAssertion **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1LibAssertion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  delete_LassoLibAssertion(arg1);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1newFull(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jstring jarg3, jstring jarg4, jstring jarg5) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  char *arg5 = (char *) 0 ;
  LassoLibAssertion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg5, 0);
    if (!arg5) return 0;
  }
  result = (LassoLibAssertion *)LassoLibAssertion_newFull(arg1,arg2,arg3,arg4,arg5);
  
  *(LassoLibAssertion **)(void *)&jresult = result; 
  if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1);
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4);
  if (arg5) (*jenv)->ReleaseStringUTFChars(jenv, jarg5, arg5);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAssertion_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibAssertion *arg1 = (LassoLibAssertion *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAssertion **)(void *)&jarg1; 
  result = (char *)LassoLibAssertion_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1affiliationId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->AffiliationID) free((char*)arg1->AffiliationID);
    if (arg2) {
      arg1->AffiliationID = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->AffiliationID,arg2);
    } else {
      arg1->AffiliationID = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1affiliationId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  result = (char *) ((arg1)->AffiliationID);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1assertionConsumerServiceId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->AssertionConsumerServiceID) free((char*)arg1->AssertionConsumerServiceID);
    if (arg2) {
      arg1->AssertionConsumerServiceID = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->AssertionConsumerServiceID,arg2);
    } else {
      arg1->AssertionConsumerServiceID = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1assertionConsumerServiceId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  result = (char *) ((arg1)->AssertionConsumerServiceID);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1consent_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->consent) free((char*)arg1->consent);
    if (arg2) {
      arg1->consent = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->consent,arg2);
    } else {
      arg1->consent = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1consent_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  result = (char *) ((arg1)->consent);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1forceAuthn_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2) {
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->ForceAuthn = arg2;
  
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1forceAuthn_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  result = (bool) ((arg1)->ForceAuthn);
  
  jresult = (jboolean)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1isPassive_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2) {
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->IsPassive = arg2;
  
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1isPassive_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  result = (bool) ((arg1)->IsPassive);
  
  jresult = (jboolean)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1nameIdPolicy_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->NameIDPolicy) free((char*)arg1->NameIDPolicy);
    if (arg2) {
      arg1->NameIDPolicy = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->NameIDPolicy,arg2);
    } else {
      arg1->NameIDPolicy = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1nameIdPolicy_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  result = (char *) ((arg1)->NameIDPolicy);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1protocolProfile_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->ProtocolProfile) free((char*)arg1->ProtocolProfile);
    if (arg2) {
      arg1->ProtocolProfile = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->ProtocolProfile,arg2);
    } else {
      arg1->ProtocolProfile = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1protocolProfile_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  result = (char *) ((arg1)->ProtocolProfile);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1providerId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->ProviderID) free((char*)arg1->ProviderID);
    if (arg2) {
      arg1->ProviderID = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->ProviderID,arg2);
    } else {
      arg1->ProviderID = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1providerId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  result = (char *) ((arg1)->ProviderID);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1relayState_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->RelayState) free((char*)arg1->RelayState);
    if (arg2) {
      arg1->RelayState = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->RelayState,arg2);
    } else {
      arg1->RelayState = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1relayState_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  result = (char *) ((arg1)->RelayState);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1certificateFile_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLibAuthnRequest_certificate_file_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1certificateFile_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  result = (char *)LassoLibAuthnRequest_certificate_file_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1issueInstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLibAuthnRequest_IssueInstant_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1issueInstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  result = (char *)LassoLibAuthnRequest_IssueInstant_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1majorVersion_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  LassoLibAuthnRequest_MajorVersion_set(arg1,arg2);
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1majorVersion_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  result = (int)LassoLibAuthnRequest_MajorVersion_get(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1minorVersion_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  LassoLibAuthnRequest_MinorVersion_set(arg1,arg2);
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1minorVersion_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  result = (int)LassoLibAuthnRequest_MinorVersion_get(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1privateKeyFile_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLibAuthnRequest_private_key_file_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1privateKeyFile_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  result = (char *)LassoLibAuthnRequest_private_key_file_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1requestId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLibAuthnRequest_RequestID_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1requestId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  result = (char *)LassoLibAuthnRequest_RequestID_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1respondWith_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  LassoStringList *arg2 = (LassoStringList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  arg2 = *(LassoStringList **)(void *)&jarg2; 
  LassoLibAuthnRequest_RespondWith_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1respondWith_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  LassoStringList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  result = (LassoStringList *)LassoLibAuthnRequest_RespondWith_get(arg1);
  
  *(LassoStringList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1signMethod_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  LassoSignatureMethod arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  arg2 = (LassoSignatureMethod)jarg2; 
  LassoLibAuthnRequest_sign_method_set(arg1,arg2);
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1signMethod_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  LassoSignatureMethod result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  result = (LassoSignatureMethod)LassoLibAuthnRequest_sign_method_get(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1signType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  LassoSignatureType arg2 ;
  LassoSignatureType *argp2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  argp2 = *(LassoSignatureType **)(void *)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
    return ;
  }
  arg2 = *argp2; 
  LassoLibAuthnRequest_sign_type_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1signType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  LassoSignatureType result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  result = LassoLibAuthnRequest_sign_type_get(arg1);
  
  {
    LassoSignatureType * resultptr = (LassoSignatureType *) malloc(sizeof(LassoSignatureType));
    memmove(resultptr, &result, sizeof(LassoSignatureType));
    *(LassoSignatureType **)(void *)&jresult = resultptr;
  }
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1extension_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  LassoStringList *arg2 = (LassoStringList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  arg2 = *(LassoStringList **)(void *)&jarg2; 
  LassoLibAuthnRequest_Extension_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1extension_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  LassoStringList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  result = (LassoStringList *)LassoLibAuthnRequest_Extension_get(arg1);
  
  *(LassoStringList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1requestAuthnContext_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  LassoLibRequestAuthnContext *arg2 = (LassoLibRequestAuthnContext *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  arg2 = *(LassoLibRequestAuthnContext **)(void *)&jarg2; 
  LassoLibAuthnRequest_RequestAuthnContext_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1requestAuthnContext_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  LassoLibRequestAuthnContext *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  result = (LassoLibRequestAuthnContext *)LassoLibAuthnRequest_RequestAuthnContext_get(arg1);
  
  *(LassoLibRequestAuthnContext **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1LibAuthnRequest(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoLibAuthnRequest *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoLibAuthnRequest *)new_LassoLibAuthnRequest();
  
  *(LassoLibAuthnRequest **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1LibAuthnRequest(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  delete_LassoLibAuthnRequest(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnRequest_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibAuthnRequest *arg1 = (LassoLibAuthnRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnRequest **)(void *)&jarg1; 
  result = (char *)LassoLibAuthnRequest_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnResponse_1consent_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibAuthnResponse *arg1 = (LassoLibAuthnResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->consent) free((char*)arg1->consent);
    if (arg2) {
      arg1->consent = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->consent,arg2);
    } else {
      arg1->consent = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnResponse_1consent_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibAuthnResponse *arg1 = (LassoLibAuthnResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnResponse **)(void *)&jarg1; 
  result = (char *) ((arg1)->consent);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnResponse_1providerId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibAuthnResponse *arg1 = (LassoLibAuthnResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->ProviderID) free((char*)arg1->ProviderID);
    if (arg2) {
      arg1->ProviderID = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->ProviderID,arg2);
    } else {
      arg1->ProviderID = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnResponse_1providerId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibAuthnResponse *arg1 = (LassoLibAuthnResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnResponse **)(void *)&jarg1; 
  result = (char *) ((arg1)->ProviderID);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnResponse_1relayState_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibAuthnResponse *arg1 = (LassoLibAuthnResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->RelayState) free((char*)arg1->RelayState);
    if (arg2) {
      arg1->RelayState = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->RelayState,arg2);
    } else {
      arg1->RelayState = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnResponse_1relayState_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibAuthnResponse *arg1 = (LassoLibAuthnResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnResponse **)(void *)&jarg1; 
  result = (char *) ((arg1)->RelayState);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnResponse_1extension_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibAuthnResponse *arg1 = (LassoLibAuthnResponse *) 0 ;
  LassoStringList *arg2 = (LassoStringList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnResponse **)(void *)&jarg1; 
  arg2 = *(LassoStringList **)(void *)&jarg2; 
  LassoLibAuthnResponse_Extension_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnResponse_1extension_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibAuthnResponse *arg1 = (LassoLibAuthnResponse *) 0 ;
  LassoStringList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnResponse **)(void *)&jarg1; 
  result = (LassoStringList *)LassoLibAuthnResponse_Extension_get(arg1);
  
  *(LassoStringList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnResponse_1status_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibAuthnResponse *arg1 = (LassoLibAuthnResponse *) 0 ;
  LassoSamlpStatus *arg2 = (LassoSamlpStatus *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnResponse **)(void *)&jarg1; 
  arg2 = *(LassoSamlpStatus **)(void *)&jarg2; 
  LassoLibAuthnResponse_Status_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnResponse_1status_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibAuthnResponse *arg1 = (LassoLibAuthnResponse *) 0 ;
  LassoSamlpStatus *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnResponse **)(void *)&jarg1; 
  result = (LassoSamlpStatus *)LassoLibAuthnResponse_Status_get(arg1);
  
  *(LassoSamlpStatus **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1LibAuthnResponse(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  LassoLibAuthnRequest *arg2 = (LassoLibAuthnRequest *) 0 ;
  LassoLibAuthnResponse *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(LassoLibAuthnRequest **)(void *)&jarg2; 
  result = (LassoLibAuthnResponse *)new_LassoLibAuthnResponse(arg1,arg2);
  
  *(LassoLibAuthnResponse **)(void *)&jresult = result; 
  if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1LibAuthnResponse(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoLibAuthnResponse *arg1 = (LassoLibAuthnResponse *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnResponse **)(void *)&jarg1; 
  delete_LassoLibAuthnResponse(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibAuthnResponse_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibAuthnResponse *arg1 = (LassoLibAuthnResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibAuthnResponse **)(void *)&jarg1; 
  result = (char *)LassoLibAuthnResponse_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1consent_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->consent) free((char*)arg1->consent);
    if (arg2) {
      arg1->consent = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->consent,arg2);
    } else {
      arg1->consent = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1consent_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  result = (char *) ((arg1)->consent);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1providerId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->ProviderID) free((char*)arg1->ProviderID);
    if (arg2) {
      arg1->ProviderID = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->ProviderID,arg2);
    } else {
      arg1->ProviderID = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1providerId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  result = (char *) ((arg1)->ProviderID);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1relayState_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->RelayState) free((char*)arg1->RelayState);
    if (arg2) {
      arg1->RelayState = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->RelayState,arg2);
    } else {
      arg1->RelayState = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1relayState_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  result = (char *) ((arg1)->RelayState);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1certificateFile_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLibFederationTerminationNotification_certificate_file_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1certificateFile_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  result = (char *)LassoLibFederationTerminationNotification_certificate_file_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1issueInstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLibFederationTerminationNotification_IssueInstant_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1issueInstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  result = (char *)LassoLibFederationTerminationNotification_IssueInstant_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1majorVersion_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  LassoLibFederationTerminationNotification_MajorVersion_set(arg1,arg2);
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1majorVersion_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  result = (int)LassoLibFederationTerminationNotification_MajorVersion_get(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1minorVersion_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  LassoLibFederationTerminationNotification_MinorVersion_set(arg1,arg2);
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1minorVersion_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  result = (int)LassoLibFederationTerminationNotification_MinorVersion_get(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1privateKeyFile_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLibFederationTerminationNotification_private_key_file_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1privateKeyFile_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  result = (char *)LassoLibFederationTerminationNotification_private_key_file_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1requestId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLibFederationTerminationNotification_RequestID_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1requestId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  result = (char *)LassoLibFederationTerminationNotification_RequestID_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1respondWith_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  LassoStringList *arg2 = (LassoStringList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  arg2 = *(LassoStringList **)(void *)&jarg2; 
  LassoLibFederationTerminationNotification_RespondWith_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1respondWith_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  LassoStringList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  result = (LassoStringList *)LassoLibFederationTerminationNotification_RespondWith_get(arg1);
  
  *(LassoStringList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1signMethod_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  LassoSignatureMethod arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  arg2 = (LassoSignatureMethod)jarg2; 
  LassoLibFederationTerminationNotification_sign_method_set(arg1,arg2);
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1signMethod_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  LassoSignatureMethod result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  result = (LassoSignatureMethod)LassoLibFederationTerminationNotification_sign_method_get(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1signType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  LassoSignatureType arg2 ;
  LassoSignatureType *argp2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  argp2 = *(LassoSignatureType **)(void *)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
    return ;
  }
  arg2 = *argp2; 
  LassoLibFederationTerminationNotification_sign_type_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1signType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  LassoSignatureType result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  result = LassoLibFederationTerminationNotification_sign_type_get(arg1);
  
  {
    LassoSignatureType * resultptr = (LassoSignatureType *) malloc(sizeof(LassoSignatureType));
    memmove(resultptr, &result, sizeof(LassoSignatureType));
    *(LassoSignatureType **)(void *)&jresult = resultptr;
  }
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1extension_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  LassoStringList *arg2 = (LassoStringList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  arg2 = *(LassoStringList **)(void *)&jarg2; 
  LassoLibFederationTerminationNotification_Extension_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1extension_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  LassoStringList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  result = (LassoStringList *)LassoLibFederationTerminationNotification_Extension_get(arg1);
  
  *(LassoStringList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1nameIdentifier_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  arg2 = *(LassoSamlNameIdentifier **)(void *)&jarg2; 
  LassoLibFederationTerminationNotification_NameIdentifier_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1nameIdentifier_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  LassoSamlNameIdentifier *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  result = (LassoSamlNameIdentifier *)LassoLibFederationTerminationNotification_NameIdentifier_get(arg1);
  
  *(LassoSamlNameIdentifier **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1LibFederationTerminationNotification(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoLibFederationTerminationNotification *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoLibFederationTerminationNotification *)new_LassoLibFederationTerminationNotification();
  
  *(LassoLibFederationTerminationNotification **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1LibFederationTerminationNotification(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  delete_LassoLibFederationTerminationNotification(arg1);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1newFull(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3, jint jarg4) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
  LassoSignatureType arg3 ;
  LassoSignatureMethod arg4 ;
  LassoLibFederationTerminationNotification *result = 0 ;
  LassoSignatureType *argp3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(LassoSamlNameIdentifier **)(void *)&jarg2; 
  argp3 = *(LassoSignatureType **)(void *)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
    return 0;
  }
  arg3 = *argp3; 
  arg4 = (LassoSignatureMethod)jarg4; 
  result = (LassoLibFederationTerminationNotification *)LassoLibFederationTerminationNotification_newFull(arg1,arg2,arg3,arg4);
  
  *(LassoLibFederationTerminationNotification **)(void *)&jresult = result; 
  if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibFederationTerminationNotification_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibFederationTerminationNotification *arg1 = (LassoLibFederationTerminationNotification *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibFederationTerminationNotification **)(void *)&jarg1; 
  result = (char *)LassoLibFederationTerminationNotification_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1consent_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->consent) free((char*)arg1->consent);
    if (arg2) {
      arg1->consent = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->consent,arg2);
    } else {
      arg1->consent = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1consent_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  result = (char *) ((arg1)->consent);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1notOnOrAfter_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->NotOnOrAfter) free((char*)arg1->NotOnOrAfter);
    if (arg2) {
      arg1->NotOnOrAfter = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->NotOnOrAfter,arg2);
    } else {
      arg1->NotOnOrAfter = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1notOnOrAfter_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  result = (char *) ((arg1)->NotOnOrAfter);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1providerId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->ProviderID) free((char*)arg1->ProviderID);
    if (arg2) {
      arg1->ProviderID = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->ProviderID,arg2);
    } else {
      arg1->ProviderID = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1providerId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  result = (char *) ((arg1)->ProviderID);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1relayState_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->RelayState) free((char*)arg1->RelayState);
    if (arg2) {
      arg1->RelayState = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->RelayState,arg2);
    } else {
      arg1->RelayState = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1relayState_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  result = (char *) ((arg1)->RelayState);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1sessionIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->SessionIndex) free((char*)arg1->SessionIndex);
    if (arg2) {
      arg1->SessionIndex = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->SessionIndex,arg2);
    } else {
      arg1->SessionIndex = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1sessionIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  result = (char *) ((arg1)->SessionIndex);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1certificateFile_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLibLogoutRequest_certificate_file_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1certificateFile_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  result = (char *)LassoLibLogoutRequest_certificate_file_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1issueInstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLibLogoutRequest_IssueInstant_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1issueInstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  result = (char *)LassoLibLogoutRequest_IssueInstant_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1majorVersion_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  LassoLibLogoutRequest_MajorVersion_set(arg1,arg2);
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1majorVersion_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  result = (int)LassoLibLogoutRequest_MajorVersion_get(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1minorVersion_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  LassoLibLogoutRequest_MinorVersion_set(arg1,arg2);
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1minorVersion_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  result = (int)LassoLibLogoutRequest_MinorVersion_get(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1privateKeyFile_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLibLogoutRequest_private_key_file_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1privateKeyFile_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  result = (char *)LassoLibLogoutRequest_private_key_file_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1requestId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLibLogoutRequest_RequestID_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1requestId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  result = (char *)LassoLibLogoutRequest_RequestID_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1respondWith_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  LassoStringList *arg2 = (LassoStringList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  arg2 = *(LassoStringList **)(void *)&jarg2; 
  LassoLibLogoutRequest_RespondWith_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1respondWith_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  LassoStringList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  result = (LassoStringList *)LassoLibLogoutRequest_RespondWith_get(arg1);
  
  *(LassoStringList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1signMethod_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  LassoSignatureMethod arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  arg2 = (LassoSignatureMethod)jarg2; 
  LassoLibLogoutRequest_sign_method_set(arg1,arg2);
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1signMethod_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  LassoSignatureMethod result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  result = (LassoSignatureMethod)LassoLibLogoutRequest_sign_method_get(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1signType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  LassoSignatureType arg2 ;
  LassoSignatureType *argp2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  argp2 = *(LassoSignatureType **)(void *)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
    return ;
  }
  arg2 = *argp2; 
  LassoLibLogoutRequest_sign_type_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1signType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  LassoSignatureType result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  result = LassoLibLogoutRequest_sign_type_get(arg1);
  
  {
    LassoSignatureType * resultptr = (LassoSignatureType *) malloc(sizeof(LassoSignatureType));
    memmove(resultptr, &result, sizeof(LassoSignatureType));
    *(LassoSignatureType **)(void *)&jresult = resultptr;
  }
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1extension_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  LassoStringList *arg2 = (LassoStringList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  arg2 = *(LassoStringList **)(void *)&jarg2; 
  LassoLibLogoutRequest_Extension_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1extension_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  LassoStringList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  result = (LassoStringList *)LassoLibLogoutRequest_Extension_get(arg1);
  
  *(LassoStringList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1nameIdentifier_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  arg2 = *(LassoSamlNameIdentifier **)(void *)&jarg2; 
  LassoLibLogoutRequest_NameIdentifier_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1nameIdentifier_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  LassoSamlNameIdentifier *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  result = (LassoSamlNameIdentifier *)LassoLibLogoutRequest_NameIdentifier_get(arg1);
  
  *(LassoSamlNameIdentifier **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1LibLogoutRequest(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoLibLogoutRequest *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoLibLogoutRequest *)new_LassoLibLogoutRequest();
  
  *(LassoLibLogoutRequest **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1LibLogoutRequest(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  delete_LassoLibLogoutRequest(arg1);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1newFull(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3, jint jarg4) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
  LassoSignatureType arg3 ;
  LassoSignatureMethod arg4 ;
  LassoLibLogoutRequest *result = 0 ;
  LassoSignatureType *argp3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(LassoSamlNameIdentifier **)(void *)&jarg2; 
  argp3 = *(LassoSignatureType **)(void *)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
    return 0;
  }
  arg3 = *argp3; 
  arg4 = (LassoSignatureMethod)jarg4; 
  result = (LassoLibLogoutRequest *)LassoLibLogoutRequest_newFull(arg1,arg2,arg3,arg4);
  
  *(LassoLibLogoutRequest **)(void *)&jresult = result; 
  if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutRequest_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibLogoutRequest *arg1 = (LassoLibLogoutRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutRequest **)(void *)&jarg1; 
  result = (char *)LassoLibLogoutRequest_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutResponse_1extension_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibLogoutResponse *arg1 = (LassoLibLogoutResponse *) 0 ;
  LassoStringList *arg2 = (LassoStringList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutResponse **)(void *)&jarg1; 
  arg2 = *(LassoStringList **)(void *)&jarg2; 
  LassoLibLogoutResponse_Extension_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutResponse_1extension_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibLogoutResponse *arg1 = (LassoLibLogoutResponse *) 0 ;
  LassoStringList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutResponse **)(void *)&jarg1; 
  result = (LassoStringList *)LassoLibLogoutResponse_Extension_get(arg1);
  
  *(LassoStringList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutResponse_1providerId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibLogoutResponse *arg1 = (LassoLibLogoutResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLibLogoutResponse_ProviderID_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutResponse_1providerId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibLogoutResponse *arg1 = (LassoLibLogoutResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutResponse **)(void *)&jarg1; 
  result = (char *)LassoLibLogoutResponse_ProviderID_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutResponse_1relayState_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibLogoutResponse *arg1 = (LassoLibLogoutResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLibLogoutResponse_RelayState_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutResponse_1relayState_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibLogoutResponse *arg1 = (LassoLibLogoutResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutResponse **)(void *)&jarg1; 
  result = (char *)LassoLibLogoutResponse_RelayState_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutResponse_1status_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibLogoutResponse *arg1 = (LassoLibLogoutResponse *) 0 ;
  LassoSamlpStatus *arg2 = (LassoSamlpStatus *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutResponse **)(void *)&jarg1; 
  arg2 = *(LassoSamlpStatus **)(void *)&jarg2; 
  LassoLibLogoutResponse_Status_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutResponse_1status_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibLogoutResponse *arg1 = (LassoLibLogoutResponse *) 0 ;
  LassoSamlpStatus *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutResponse **)(void *)&jarg1; 
  result = (LassoSamlpStatus *)LassoLibLogoutResponse_Status_get(arg1);
  
  *(LassoSamlpStatus **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1LibLogoutResponse(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoLibLogoutResponse *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoLibLogoutResponse *)new_LassoLibLogoutResponse();
  
  *(LassoLibLogoutResponse **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1LibLogoutResponse(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoLibLogoutResponse *arg1 = (LassoLibLogoutResponse *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutResponse **)(void *)&jarg1; 
  delete_LassoLibLogoutResponse(arg1);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutResponse_1newFull(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jlong jarg3, jlong jarg4, jint jarg5) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  LassoLibLogoutRequest *arg3 = (LassoLibLogoutRequest *) 0 ;
  LassoSignatureType arg4 ;
  LassoSignatureMethod arg5 ;
  LassoLibLogoutResponse *result = 0 ;
  LassoSignatureType *argp4 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(LassoLibLogoutRequest **)(void *)&jarg3; 
  argp4 = *(LassoSignatureType **)(void *)&jarg4; 
  if (!argp4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
    return 0;
  }
  arg4 = *argp4; 
  arg5 = (LassoSignatureMethod)jarg5; 
  result = (LassoLibLogoutResponse *)LassoLibLogoutResponse_newFull(arg1,(char const *)arg2,arg3,arg4,arg5);
  
  *(LassoLibLogoutResponse **)(void *)&jresult = result; 
  if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1);
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibLogoutResponse_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibLogoutResponse *arg1 = (LassoLibLogoutResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibLogoutResponse **)(void *)&jarg1; 
  result = (char *)LassoLibLogoutResponse_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1providerId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->ProviderID) free((char*)arg1->ProviderID);
    if (arg2) {
      arg1->ProviderID = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->ProviderID,arg2);
    } else {
      arg1->ProviderID = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1providerId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  result = (char *) ((arg1)->ProviderID);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1relayState_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->RelayState) free((char*)arg1->RelayState);
    if (arg2) {
      arg1->RelayState = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->RelayState,arg2);
    } else {
      arg1->RelayState = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1relayState_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  result = (char *) ((arg1)->RelayState);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1certificateFile_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLibRegisterNameIdentifierRequest_certificate_file_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1certificateFile_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  result = (char *)LassoLibRegisterNameIdentifierRequest_certificate_file_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1issueInstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLibRegisterNameIdentifierRequest_IssueInstant_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1issueInstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  result = (char *)LassoLibRegisterNameIdentifierRequest_IssueInstant_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1majorVersion_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  LassoLibRegisterNameIdentifierRequest_MajorVersion_set(arg1,arg2);
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1majorVersion_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  result = (int)LassoLibRegisterNameIdentifierRequest_MajorVersion_get(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1minorVersion_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  LassoLibRegisterNameIdentifierRequest_MinorVersion_set(arg1,arg2);
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1minorVersion_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  result = (int)LassoLibRegisterNameIdentifierRequest_MinorVersion_get(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1privateKeyFile_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLibRegisterNameIdentifierRequest_private_key_file_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1privateKeyFile_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  result = (char *)LassoLibRegisterNameIdentifierRequest_private_key_file_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1requestId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLibRegisterNameIdentifierRequest_RequestID_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1requestId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  result = (char *)LassoLibRegisterNameIdentifierRequest_RequestID_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1respondWith_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  LassoStringList *arg2 = (LassoStringList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  arg2 = *(LassoStringList **)(void *)&jarg2; 
  LassoLibRegisterNameIdentifierRequest_RespondWith_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1respondWith_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  LassoStringList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  result = (LassoStringList *)LassoLibRegisterNameIdentifierRequest_RespondWith_get(arg1);
  
  *(LassoStringList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1signMethod_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  LassoSignatureMethod arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  arg2 = (LassoSignatureMethod)jarg2; 
  LassoLibRegisterNameIdentifierRequest_sign_method_set(arg1,arg2);
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1signMethod_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  LassoSignatureMethod result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  result = (LassoSignatureMethod)LassoLibRegisterNameIdentifierRequest_sign_method_get(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1signType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  LassoSignatureType arg2 ;
  LassoSignatureType *argp2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  argp2 = *(LassoSignatureType **)(void *)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
    return ;
  }
  arg2 = *argp2; 
  LassoLibRegisterNameIdentifierRequest_sign_type_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1signType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  LassoSignatureType result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  result = LassoLibRegisterNameIdentifierRequest_sign_type_get(arg1);
  
  {
    LassoSignatureType * resultptr = (LassoSignatureType *) malloc(sizeof(LassoSignatureType));
    memmove(resultptr, &result, sizeof(LassoSignatureType));
    *(LassoSignatureType **)(void *)&jresult = resultptr;
  }
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1extension_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  LassoStringList *arg2 = (LassoStringList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  arg2 = *(LassoStringList **)(void *)&jarg2; 
  LassoLibRegisterNameIdentifierRequest_Extension_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1extension_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  LassoStringList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  result = (LassoStringList *)LassoLibRegisterNameIdentifierRequest_Extension_get(arg1);
  
  *(LassoStringList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1idpProvidedNameIdentifier_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  arg2 = *(LassoSamlNameIdentifier **)(void *)&jarg2; 
  LassoLibRegisterNameIdentifierRequest_IDPProvidedNameIdentifier_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1idpProvidedNameIdentifier_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  LassoSamlNameIdentifier *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  result = (LassoSamlNameIdentifier *)LassoLibRegisterNameIdentifierRequest_IDPProvidedNameIdentifier_get(arg1);
  
  *(LassoSamlNameIdentifier **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1oldProvidedNameIdentifier_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  arg2 = *(LassoSamlNameIdentifier **)(void *)&jarg2; 
  LassoLibRegisterNameIdentifierRequest_OldProvidedNameIdentifier_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1oldProvidedNameIdentifier_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  LassoSamlNameIdentifier *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  result = (LassoSamlNameIdentifier *)LassoLibRegisterNameIdentifierRequest_OldProvidedNameIdentifier_get(arg1);
  
  *(LassoSamlNameIdentifier **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1spProvidedNameIdentifier_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  arg2 = *(LassoSamlNameIdentifier **)(void *)&jarg2; 
  LassoLibRegisterNameIdentifierRequest_SPProvidedNameIdentifier_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1spProvidedNameIdentifier_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  LassoSamlNameIdentifier *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  result = (LassoSamlNameIdentifier *)LassoLibRegisterNameIdentifierRequest_SPProvidedNameIdentifier_get(arg1);
  
  *(LassoSamlNameIdentifier **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1LibRegisterNameIdentifierRequest(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoLibRegisterNameIdentifierRequest *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoLibRegisterNameIdentifierRequest *)new_LassoLibRegisterNameIdentifierRequest();
  
  *(LassoLibRegisterNameIdentifierRequest **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1LibRegisterNameIdentifierRequest(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  delete_LassoLibRegisterNameIdentifierRequest(arg1);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1newFull(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jint jarg6) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
  LassoSamlNameIdentifier *arg3 = (LassoSamlNameIdentifier *) 0 ;
  LassoSamlNameIdentifier *arg4 = (LassoSamlNameIdentifier *) 0 ;
  LassoSignatureType arg5 ;
  LassoSignatureMethod arg6 ;
  LassoLibRegisterNameIdentifierRequest *result = 0 ;
  LassoSignatureType *argp5 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(LassoSamlNameIdentifier **)(void *)&jarg2; 
  arg3 = *(LassoSamlNameIdentifier **)(void *)&jarg3; 
  arg4 = *(LassoSamlNameIdentifier **)(void *)&jarg4; 
  argp5 = *(LassoSignatureType **)(void *)&jarg5; 
  if (!argp5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
    return 0;
  }
  arg5 = *argp5; 
  arg6 = (LassoSignatureMethod)jarg6; 
  result = (LassoLibRegisterNameIdentifierRequest *)LassoLibRegisterNameIdentifierRequest_newFull(arg1,arg2,arg3,arg4,arg5,arg6);
  
  *(LassoLibRegisterNameIdentifierRequest **)(void *)&jresult = result; 
  if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierRequest_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibRegisterNameIdentifierRequest *arg1 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg1; 
  result = (char *)LassoLibRegisterNameIdentifierRequest_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierResponse_1extension_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibRegisterNameIdentifierResponse *arg1 = (LassoLibRegisterNameIdentifierResponse *) 0 ;
  LassoStringList *arg2 = (LassoStringList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierResponse **)(void *)&jarg1; 
  arg2 = *(LassoStringList **)(void *)&jarg2; 
  LassoLibRegisterNameIdentifierResponse_Extension_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierResponse_1extension_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibRegisterNameIdentifierResponse *arg1 = (LassoLibRegisterNameIdentifierResponse *) 0 ;
  LassoStringList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierResponse **)(void *)&jarg1; 
  result = (LassoStringList *)LassoLibRegisterNameIdentifierResponse_Extension_get(arg1);
  
  *(LassoStringList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierResponse_1providerId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibRegisterNameIdentifierResponse *arg1 = (LassoLibRegisterNameIdentifierResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLibRegisterNameIdentifierResponse_ProviderID_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierResponse_1providerId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibRegisterNameIdentifierResponse *arg1 = (LassoLibRegisterNameIdentifierResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierResponse **)(void *)&jarg1; 
  result = (char *)LassoLibRegisterNameIdentifierResponse_ProviderID_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierResponse_1relayState_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibRegisterNameIdentifierResponse *arg1 = (LassoLibRegisterNameIdentifierResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLibRegisterNameIdentifierResponse_RelayState_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierResponse_1relayState_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibRegisterNameIdentifierResponse *arg1 = (LassoLibRegisterNameIdentifierResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierResponse **)(void *)&jarg1; 
  result = (char *)LassoLibRegisterNameIdentifierResponse_RelayState_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierResponse_1status_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibRegisterNameIdentifierResponse *arg1 = (LassoLibRegisterNameIdentifierResponse *) 0 ;
  LassoSamlpStatus *arg2 = (LassoSamlpStatus *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierResponse **)(void *)&jarg1; 
  arg2 = *(LassoSamlpStatus **)(void *)&jarg2; 
  LassoLibRegisterNameIdentifierResponse_Status_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierResponse_1status_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibRegisterNameIdentifierResponse *arg1 = (LassoLibRegisterNameIdentifierResponse *) 0 ;
  LassoSamlpStatus *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierResponse **)(void *)&jarg1; 
  result = (LassoSamlpStatus *)LassoLibRegisterNameIdentifierResponse_Status_get(arg1);
  
  *(LassoSamlpStatus **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1LibRegisterNameIdentifierResponse(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoLibRegisterNameIdentifierResponse *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoLibRegisterNameIdentifierResponse *)new_LassoLibRegisterNameIdentifierResponse();
  
  *(LassoLibRegisterNameIdentifierResponse **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1LibRegisterNameIdentifierResponse(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoLibRegisterNameIdentifierResponse *arg1 = (LassoLibRegisterNameIdentifierResponse *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierResponse **)(void *)&jarg1; 
  delete_LassoLibRegisterNameIdentifierResponse(arg1);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierResponse_1newFull(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jlong jarg3, jlong jarg4, jint jarg5) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  LassoLibRegisterNameIdentifierRequest *arg3 = (LassoLibRegisterNameIdentifierRequest *) 0 ;
  LassoSignatureType arg4 ;
  LassoSignatureMethod arg5 ;
  LassoLibRegisterNameIdentifierResponse *result = 0 ;
  LassoSignatureType *argp4 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(LassoLibRegisterNameIdentifierRequest **)(void *)&jarg3; 
  argp4 = *(LassoSignatureType **)(void *)&jarg4; 
  if (!argp4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null LassoSignatureType");
    return 0;
  }
  arg4 = *argp4; 
  arg5 = (LassoSignatureMethod)jarg5; 
  result = (LassoLibRegisterNameIdentifierResponse *)LassoLibRegisterNameIdentifierResponse_newFull(arg1,arg2,arg3,arg4,arg5);
  
  *(LassoLibRegisterNameIdentifierResponse **)(void *)&jresult = result; 
  if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1);
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRegisterNameIdentifierResponse_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibRegisterNameIdentifierResponse *arg1 = (LassoLibRegisterNameIdentifierResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRegisterNameIdentifierResponse **)(void *)&jarg1; 
  result = (char *)LassoLibRegisterNameIdentifierResponse_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRequestAuthnContext_1authnContextComparison_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibRequestAuthnContext *arg1 = (LassoLibRequestAuthnContext *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRequestAuthnContext **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->AuthnContextComparison) free((char*)arg1->AuthnContextComparison);
    if (arg2) {
      arg1->AuthnContextComparison = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->AuthnContextComparison,arg2);
    } else {
      arg1->AuthnContextComparison = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRequestAuthnContext_1authnContextComparison_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibRequestAuthnContext *arg1 = (LassoLibRequestAuthnContext *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRequestAuthnContext **)(void *)&jarg1; 
  result = (char *) ((arg1)->AuthnContextComparison);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRequestAuthnContext_1authnContextClassRef_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibRequestAuthnContext *arg1 = (LassoLibRequestAuthnContext *) 0 ;
  LassoStringList *arg2 = (LassoStringList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRequestAuthnContext **)(void *)&jarg1; 
  arg2 = *(LassoStringList **)(void *)&jarg2; 
  LassoLibRequestAuthnContext_authnContextClassRef_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRequestAuthnContext_1authnContextClassRef_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibRequestAuthnContext *arg1 = (LassoLibRequestAuthnContext *) 0 ;
  LassoStringList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRequestAuthnContext **)(void *)&jarg1; 
  result = (LassoStringList *)LassoLibRequestAuthnContext_authnContextClassRef_get(arg1);
  
  *(LassoStringList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRequestAuthnContext_1authnContextStatementRef_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibRequestAuthnContext *arg1 = (LassoLibRequestAuthnContext *) 0 ;
  LassoStringList *arg2 = (LassoStringList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRequestAuthnContext **)(void *)&jarg1; 
  arg2 = *(LassoStringList **)(void *)&jarg2; 
  LassoLibRequestAuthnContext_authnContextStatementRef_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRequestAuthnContext_1authnContextStatementRef_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibRequestAuthnContext *arg1 = (LassoLibRequestAuthnContext *) 0 ;
  LassoStringList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRequestAuthnContext **)(void *)&jarg1; 
  result = (LassoStringList *)LassoLibRequestAuthnContext_authnContextStatementRef_get(arg1);
  
  *(LassoStringList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1LibRequestAuthnContext(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoLibRequestAuthnContext *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoLibRequestAuthnContext *)new_LassoLibRequestAuthnContext();
  
  *(LassoLibRequestAuthnContext **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1LibRequestAuthnContext(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoLibRequestAuthnContext *arg1 = (LassoLibRequestAuthnContext *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRequestAuthnContext **)(void *)&jarg1; 
  delete_LassoLibRequestAuthnContext(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibRequestAuthnContext_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibRequestAuthnContext *arg1 = (LassoLibRequestAuthnContext *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibRequestAuthnContext **)(void *)&jarg1; 
  result = (char *)LassoLibRequestAuthnContext_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibStatusResponse_1providerId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibStatusResponse *arg1 = (LassoLibStatusResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibStatusResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->ProviderID) free((char*)arg1->ProviderID);
    if (arg2) {
      arg1->ProviderID = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->ProviderID,arg2);
    } else {
      arg1->ProviderID = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibStatusResponse_1providerId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibStatusResponse *arg1 = (LassoLibStatusResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibStatusResponse **)(void *)&jarg1; 
  result = (char *) ((arg1)->ProviderID);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibStatusResponse_1relayState_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLibStatusResponse *arg1 = (LassoLibStatusResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibStatusResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->RelayState) free((char*)arg1->RelayState);
    if (arg2) {
      arg1->RelayState = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->RelayState,arg2);
    } else {
      arg1->RelayState = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibStatusResponse_1relayState_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibStatusResponse *arg1 = (LassoLibStatusResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibStatusResponse **)(void *)&jarg1; 
  result = (char *) ((arg1)->RelayState);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibStatusResponse_1extension_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibStatusResponse *arg1 = (LassoLibStatusResponse *) 0 ;
  LassoStringList *arg2 = (LassoStringList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibStatusResponse **)(void *)&jarg1; 
  arg2 = *(LassoStringList **)(void *)&jarg2; 
  LassoLibStatusResponse_Extension_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibStatusResponse_1extension_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibStatusResponse *arg1 = (LassoLibStatusResponse *) 0 ;
  LassoStringList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibStatusResponse **)(void *)&jarg1; 
  result = (LassoStringList *)LassoLibStatusResponse_Extension_get(arg1);
  
  *(LassoStringList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_LibStatusResponse_1status_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLibStatusResponse *arg1 = (LassoLibStatusResponse *) 0 ;
  LassoSamlpStatus *arg2 = (LassoSamlpStatus *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibStatusResponse **)(void *)&jarg1; 
  arg2 = *(LassoSamlpStatus **)(void *)&jarg2; 
  LassoLibStatusResponse_Status_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_LibStatusResponse_1status_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLibStatusResponse *arg1 = (LassoLibStatusResponse *) 0 ;
  LassoSamlpStatus *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibStatusResponse **)(void *)&jarg1; 
  result = (LassoSamlpStatus *)LassoLibStatusResponse_Status_get(arg1);
  
  *(LassoSamlpStatus **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1LibStatusResponse(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoLibStatusResponse *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoLibStatusResponse *)new_LassoLibStatusResponse();
  
  *(LassoLibStatusResponse **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1LibStatusResponse(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoLibStatusResponse *arg1 = (LassoLibStatusResponse *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibStatusResponse **)(void *)&jarg1; 
  delete_LassoLibStatusResponse(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_LibStatusResponse_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLibStatusResponse *arg1 = (LassoLibStatusResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLibStatusResponse **)(void *)&jarg1; 
  result = (char *)LassoLibStatusResponse_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1caCertChain_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoProvider *arg1 = (LassoProvider *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoProvider **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->ca_cert_chain) free((char*)arg1->ca_cert_chain);
    if (arg2) {
      arg1->ca_cert_chain = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->ca_cert_chain,arg2);
    } else {
      arg1->ca_cert_chain = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1caCertChain_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoProvider *arg1 = (LassoProvider *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoProvider **)(void *)&jarg1; 
  result = (char *) ((arg1)->ca_cert_chain);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1metadataFilename_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoProvider *arg1 = (LassoProvider *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoProvider **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->metadata_filename) free((char*)arg1->metadata_filename);
    if (arg2) {
      arg1->metadata_filename = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->metadata_filename,arg2);
    } else {
      arg1->metadata_filename = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1metadataFilename_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoProvider *arg1 = (LassoProvider *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoProvider **)(void *)&jarg1; 
  result = (char *) ((arg1)->metadata_filename);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1providerId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoProvider *arg1 = (LassoProvider *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoProvider **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->ProviderID) free((char*)arg1->ProviderID);
    if (arg2) {
      arg1->ProviderID = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->ProviderID,arg2);
    } else {
      arg1->ProviderID = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1providerId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoProvider *arg1 = (LassoProvider *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoProvider **)(void *)&jarg1; 
  result = (char *) ((arg1)->ProviderID);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1publicKey_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoProvider *arg1 = (LassoProvider *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoProvider **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->public_key) free((char*)arg1->public_key);
    if (arg2) {
      arg1->public_key = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->public_key,arg2);
    } else {
      arg1->public_key = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1publicKey_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoProvider *arg1 = (LassoProvider *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoProvider **)(void *)&jarg1; 
  result = (char *) ((arg1)->public_key);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1role_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoProvider *arg1 = (LassoProvider *) 0 ;
  LassoProviderRole arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoProvider **)(void *)&jarg1; 
  arg2 = (LassoProviderRole)jarg2; 
  if (arg1) (arg1)->role = arg2;
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1role_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoProvider *arg1 = (LassoProvider *) 0 ;
  LassoProviderRole result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoProvider **)(void *)&jarg1; 
  result = (LassoProviderRole) ((arg1)->role);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Provider(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jstring jarg3, jstring jarg4) {
  jlong jresult = 0 ;
  LassoProviderRole arg1 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  LassoProvider *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (LassoProviderRole)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return 0;
  }
  result = (LassoProvider *)new_LassoProvider(arg1,(char const *)arg2,(char const *)arg3,(char const *)arg4);
  
  *(LassoProvider **)(void *)&jresult = result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Provider(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoProvider *arg1 = (LassoProvider *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoProvider **)(void *)&jarg1; 
  delete_LassoProvider(arg1);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1newFromDump(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  LassoProvider *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
    if (!arg1) return 0;
  }
  result = (LassoProvider *)LassoProvider_newFromDump(arg1);
  
  *(LassoProvider **)(void *)&jresult = result; 
  if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoProvider *arg1 = (LassoProvider *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoProvider **)(void *)&jarg1; 
  result = (char *)LassoProvider_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1acceptHttpMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jint jarg4, jboolean jarg5) {
  jboolean jresult = 0 ;
  LassoProvider *arg1 = (LassoProvider *) 0 ;
  LassoProvider *arg2 = (LassoProvider *) 0 ;
  LassoMdProtocolType arg3 ;
  LassoHttpMethod arg4 ;
  bool arg5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoProvider **)(void *)&jarg1; 
  arg2 = *(LassoProvider **)(void *)&jarg2; 
  arg3 = (LassoMdProtocolType)jarg3; 
  arg4 = (LassoHttpMethod)jarg4; 
  arg5 = jarg5 ? true : false; 
  result = (bool)LassoProvider_acceptHttpMethod(arg1,arg2,arg3,arg4,arg5);
  
  jresult = (jboolean)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1getAssertionConsumerServiceUrl(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jstring jresult = 0 ;
  LassoProvider *arg1 = (LassoProvider *) 0 ;
  char *arg2 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoProvider **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  result = (char *)LassoProvider_getAssertionConsumerServiceUrl(arg1,arg2);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  g_free(result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1getBase64SuccinctId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoProvider *arg1 = (LassoProvider *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoProvider **)(void *)&jarg1; 
  result = (char *)LassoProvider_getBase64SuccinctId(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1getOrganization(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoProvider *arg1 = (LassoProvider *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoProvider **)(void *)&jarg1; 
  result = (char *)LassoProvider_getOrganization(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1getFirstHttpMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jint jresult = 0 ;
  LassoProvider *arg1 = (LassoProvider *) 0 ;
  LassoProvider *arg2 = (LassoProvider *) 0 ;
  int arg3 ;
  LassoHttpMethod result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoProvider **)(void *)&jarg1; 
  arg2 = *(LassoProvider **)(void *)&jarg2; 
  arg3 = (int)jarg3; 
  result = (LassoHttpMethod)LassoProvider_getFirstHttpMethod(arg1,arg2,arg3);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1getMetadataOne(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jstring jresult = 0 ;
  LassoProvider *arg1 = (LassoProvider *) 0 ;
  char *arg2 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoProvider **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  result = (char *)LassoProvider_getMetadataOne(arg1,arg2);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  g_free(result);
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1hasProtocolProfile(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3) {
  jboolean jresult = 0 ;
  LassoProvider *arg1 = (LassoProvider *) 0 ;
  LassoMdProtocolType arg2 ;
  char *arg3 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoProvider **)(void *)&jarg1; 
  arg2 = (LassoMdProtocolType)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  result = (bool)LassoProvider_hasProtocolProfile(arg1,arg2,arg3);
  
  jresult = (jboolean)result; 
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Provider_1getProtocolConformance(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoProvider *arg1 = (LassoProvider *) 0 ;
  LassoProtocolConformance result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoProvider **)(void *)&jarg1; 
  result = (LassoProtocolConformance)LassoProvider_getProtocolConformance(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1certificate_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoServer *arg1 = (LassoServer *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->certificate) free((char*)arg1->certificate);
    if (arg2) {
      arg1->certificate = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->certificate,arg2);
    } else {
      arg1->certificate = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1certificate_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  result = (char *) ((arg1)->certificate);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1privateKey_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoServer *arg1 = (LassoServer *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->private_key) free((char*)arg1->private_key);
    if (arg2) {
      arg1->private_key = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->private_key,arg2);
    } else {
      arg1->private_key = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1privateKey_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  result = (char *) ((arg1)->private_key);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1privateKeyPassword_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoServer *arg1 = (LassoServer *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->private_key_password) free((char*)arg1->private_key_password);
    if (arg2) {
      arg1->private_key_password = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->private_key_password,arg2);
    } else {
      arg1->private_key_password = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1privateKeyPassword_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  result = (char *) ((arg1)->private_key_password);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1signatureMethod_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoServer *arg1 = (LassoServer *) 0 ;
  LassoSignatureMethod arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  arg2 = (LassoSignatureMethod)jarg2; 
  if (arg1) (arg1)->signature_method = arg2;
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1signatureMethod_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  LassoSignatureMethod result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  result = (LassoSignatureMethod) ((arg1)->signature_method);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1caCertChain_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoServer *arg1 = (LassoServer *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoServer_ca_cert_chain_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1caCertChain_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  result = (char *)LassoServer_ca_cert_chain_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1metadataFilename_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoServer *arg1 = (LassoServer *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoServer_metadata_filename_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1metadataFilename_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  result = (char *)LassoServer_metadata_filename_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1providerId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoServer *arg1 = (LassoServer *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoServer_ProviderID_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1providerId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  result = (char *)LassoServer_ProviderID_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1publicKey_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoServer *arg1 = (LassoServer *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoServer_public_key_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1publicKey_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  result = (char *)LassoServer_public_key_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1role_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoServer *arg1 = (LassoServer *) 0 ;
  LassoProviderRole arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  arg2 = (LassoProviderRole)jarg2; 
  LassoServer_role_set(arg1,arg2);
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1role_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  LassoProviderRole result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  result = (LassoProviderRole)LassoServer_role_get(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1providerIds_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  LassoStringList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  result = (LassoStringList *)LassoServer_providerIds_get(arg1);
  
  *(LassoStringList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Server(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jstring jarg3, jstring jarg4) {
  jlong jresult = 0 ;
  char *arg1 = (char *) NULL ;
  char *arg2 = (char *) NULL ;
  char *arg3 = (char *) NULL ;
  char *arg4 = (char *) NULL ;
  LassoServer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return 0;
  }
  result = (LassoServer *)new_LassoServer(arg1,arg2,arg3,arg4);
  
  *(LassoServer **)(void *)&jresult = result; 
  if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1);
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Server(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoServer *arg1 = (LassoServer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  delete_LassoServer(arg1);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1newFromDump(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  LassoServer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
    if (!arg1) return 0;
  }
  result = (LassoServer *)LassoServer_newFromDump(arg1);
  
  *(LassoServer **)(void *)&jresult = result; 
  if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1);
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1acceptHttpMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jint jarg4, jboolean jarg5) {
  jboolean jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  LassoProvider *arg2 = (LassoProvider *) 0 ;
  LassoMdProtocolType arg3 ;
  LassoHttpMethod arg4 ;
  bool arg5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  arg2 = *(LassoProvider **)(void *)&jarg2; 
  arg3 = (LassoMdProtocolType)jarg3; 
  arg4 = (LassoHttpMethod)jarg4; 
  arg5 = jarg5 ? true : false; 
  result = (bool)LassoServer_acceptHttpMethod(arg1,arg2,arg3,arg4,arg5);
  
  jresult = (jboolean)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1getAssertionConsumerServiceUrl(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jstring jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  char *arg2 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  result = (char *)LassoServer_getAssertionConsumerServiceUrl(arg1,arg2);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  g_free(result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1getBase64SuccinctId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  result = (char *)LassoServer_getBase64SuccinctId(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1getOrganization(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  result = (char *)LassoServer_getOrganization(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1getFirstHttpMethod(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jint jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  LassoProvider *arg2 = (LassoProvider *) 0 ;
  int arg3 ;
  LassoHttpMethod result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  arg2 = *(LassoProvider **)(void *)&jarg2; 
  arg3 = (int)jarg3; 
  result = (LassoHttpMethod)LassoServer_getFirstHttpMethod(arg1,arg2,arg3);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1getMetadataOne(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jstring jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  char *arg2 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  result = (char *)LassoServer_getMetadataOne(arg1,arg2);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  g_free(result);
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1hasProtocolProfile(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3) {
  jboolean jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  LassoMdProtocolType arg2 ;
  char *arg3 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  arg2 = (LassoMdProtocolType)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  result = (bool)LassoServer_hasProtocolProfile(arg1,arg2,arg3);
  
  jresult = (jboolean)result; 
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1getProtocolConformance(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  LassoProtocolConformance result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  result = (LassoProtocolConformance)LassoServer_getProtocolConformance(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1addProvider(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3, jstring jarg4, jstring jarg5) {
  jint jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  LassoProviderRole arg2 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) NULL ;
  char *arg5 = (char *) NULL ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  arg2 = (LassoProviderRole)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg5, 0);
    if (!arg5) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoServer_addProvider(arg1,arg2,arg3,arg4,arg5);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4);
  if (arg5) (*jenv)->ReleaseStringUTFChars(jenv, jarg5, arg5);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  result = (char *)LassoServer_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Server_1getProvider(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  char *arg2 = (char *) 0 ;
  LassoProvider *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  result = (LassoProvider *)LassoServer_getProvider(arg1,arg2);
  
  *(LassoProvider **)(void *)&jresult = result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Federation_1remoteProviderId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoFederation *arg1 = (LassoFederation *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoFederation **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->remote_providerID) free((char*)arg1->remote_providerID);
    if (arg2) {
      arg1->remote_providerID = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->remote_providerID,arg2);
    } else {
      arg1->remote_providerID = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Federation_1remoteProviderId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoFederation *arg1 = (LassoFederation *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoFederation **)(void *)&jarg1; 
  result = (char *) ((arg1)->remote_providerID);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Federation_1localNameIdentifier_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoFederation *arg1 = (LassoFederation *) 0 ;
  LassoNode *arg2 = (LassoNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoFederation **)(void *)&jarg1; 
  arg2 = *(LassoNode **)(void *)&jarg2; 
  LassoFederation_local_nameIdentifier_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Federation_1localNameIdentifier_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoFederation *arg1 = (LassoFederation *) 0 ;
  LassoNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoFederation **)(void *)&jarg1; 
  result = (LassoNode *)LassoFederation_local_nameIdentifier_get(arg1);
  
  *(LassoNode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Federation_1remoteNameIdentifier_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoFederation *arg1 = (LassoFederation *) 0 ;
  LassoNode *arg2 = (LassoNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoFederation **)(void *)&jarg1; 
  arg2 = *(LassoNode **)(void *)&jarg2; 
  LassoFederation_remote_nameIdentifier_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Federation_1remoteNameIdentifier_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoFederation *arg1 = (LassoFederation *) 0 ;
  LassoNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoFederation **)(void *)&jarg1; 
  result = (LassoNode *)LassoFederation_remote_nameIdentifier_get(arg1);
  
  *(LassoNode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Federation(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  LassoFederation *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
    if (!arg1) return 0;
  }
  result = (LassoFederation *)new_LassoFederation(arg1);
  
  *(LassoFederation **)(void *)&jresult = result; 
  if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Federation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoFederation *arg1 = (LassoFederation *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoFederation **)(void *)&jarg1; 
  delete_LassoFederation(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Federation_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoFederation *arg1 = (LassoFederation *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoFederation **)(void *)&jarg1; 
  result = (char *)LassoFederation_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Federation_1buildLocalNameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4) {
  LassoFederation *arg1 = (LassoFederation *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoFederation **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return ;
  }
  LassoFederation_buildLocalNameIdentifier(arg1,arg2,arg3,arg4);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4);
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Federation_1verifyNameIdentifier(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  LassoFederation *arg1 = (LassoFederation *) 0 ;
  LassoNode *arg2 = (LassoNode *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoFederation **)(void *)&jarg1; 
  arg2 = *(LassoNode **)(void *)&jarg2; 
  result = (bool)LassoFederation_verifyNameIdentifier(arg1,arg2);
  
  jresult = (jboolean)result; 
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Identity_1isDirty_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  LassoIdentity *arg1 = (LassoIdentity *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoIdentity **)(void *)&jarg1; 
  result = (bool) ((arg1)->is_dirty);
  
  jresult = (jboolean)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Identity_1providerIds_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoIdentity *arg1 = (LassoIdentity *) 0 ;
  LassoStringList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoIdentity **)(void *)&jarg1; 
  result = (LassoStringList *)LassoIdentity_providerIds_get(arg1);
  
  *(LassoStringList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Identity(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoIdentity *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoIdentity *)new_LassoIdentity();
  
  *(LassoIdentity **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Identity(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoIdentity *arg1 = (LassoIdentity *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoIdentity **)(void *)&jarg1; 
  delete_LassoIdentity(arg1);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Identity_1newFromDump(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  LassoIdentity *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
    if (!arg1) return 0;
  }
  result = (LassoIdentity *)LassoIdentity_newFromDump(arg1);
  
  *(LassoIdentity **)(void *)&jresult = result; 
  if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Identity_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoIdentity *arg1 = (LassoIdentity *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoIdentity **)(void *)&jarg1; 
  result = (char *)LassoIdentity_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Identity_1getFederation(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  LassoIdentity *arg1 = (LassoIdentity *) 0 ;
  char *arg2 = (char *) 0 ;
  LassoFederation *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoIdentity **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  result = (LassoFederation *)LassoIdentity_getFederation(arg1,arg2);
  
  *(LassoFederation **)(void *)&jresult = result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Session_1isDirty_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  LassoSession *arg1 = (LassoSession *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSession **)(void *)&jarg1; 
  result = (bool) ((arg1)->is_dirty);
  
  jresult = (jboolean)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Session_1providerIds_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSession *arg1 = (LassoSession *) 0 ;
  LassoStringList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSession **)(void *)&jarg1; 
  result = (LassoStringList *)LassoSession_providerIds_get(arg1);
  
  *(LassoStringList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Session(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSession *)new_LassoSession();
  
  *(LassoSession **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Session(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSession *arg1 = (LassoSession *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSession **)(void *)&jarg1; 
  delete_LassoSession(arg1);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Session_1newFromDump(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  LassoSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
    if (!arg1) return 0;
  }
  result = (LassoSession *)LassoSession_newFromDump(arg1);
  
  *(LassoSession **)(void *)&jresult = result; 
  if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Session_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSession *arg1 = (LassoSession *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSession **)(void *)&jarg1; 
  result = (char *)LassoSession_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Session_1getAssertions(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  LassoSession *arg1 = (LassoSession *) 0 ;
  char *arg2 = (char *) 0 ;
  LassoNodeList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSession **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  result = (LassoNodeList *)LassoSession_getAssertions(arg1,arg2);
  
  *(LassoNodeList **)(void *)&jresult = result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_getRequestTypeFromSoapMsg(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  LassoRequestType result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
    if (!arg1) return 0;
  }
  result = (LassoRequestType)lasso_profile_get_request_type_from_soap_msg(arg1);
  
  jresult = (jint)result; 
  if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1);
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_isLibertyQuery(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
    if (!arg1) return 0;
  }
  result = (bool)lasso_profile_is_liberty_query(arg1);
  
  jresult = (jboolean)result; 
  if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1artifact_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  result = (char *)LassoDefederation_artifact_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1artifactMessage_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoDefederation_artifactMessage_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1artifactMessage_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  result = (char *)LassoDefederation_artifactMessage_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1identity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  LassoIdentity *arg2 = (LassoIdentity *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  arg2 = *(LassoIdentity **)(void *)&jarg2; 
  LassoDefederation_identity_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1identity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  LassoIdentity *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  result = (LassoIdentity *)LassoDefederation_identity_get(arg1);
  
  *(LassoIdentity **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1isIdentityDirty_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  result = (bool)LassoDefederation_isIdentityDirty_get(arg1);
  
  jresult = (jboolean)result; 
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1isSessionDirty_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  result = (bool)LassoDefederation_isSessionDirty_get(arg1);
  
  jresult = (jboolean)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1msgBody_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  result = (char *)LassoDefederation_msgBody_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1msgRelayState_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  result = (char *)LassoDefederation_msgRelayState_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1msgUrl_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  result = (char *)LassoDefederation_msgUrl_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1nameIdentifier_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  LassoNode *arg2 = (LassoNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  arg2 = *(LassoNode **)(void *)&jarg2; 
  LassoDefederation_nameIdentifier_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1nameIdentifier_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  LassoNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  result = (LassoNode *)LassoDefederation_nameIdentifier_get(arg1);
  
  *(LassoNode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1remoteProviderId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoDefederation_remoteProviderId_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1remoteProviderId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  result = (char *)LassoDefederation_remoteProviderId_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1request_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  LassoNode *arg2 = (LassoNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  arg2 = *(LassoNode **)(void *)&jarg2; 
  LassoDefederation_request_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1request_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  LassoNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  result = (LassoNode *)LassoDefederation_request_get(arg1);
  
  *(LassoNode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1response_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  LassoNode *arg2 = (LassoNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  arg2 = *(LassoNode **)(void *)&jarg2; 
  LassoDefederation_response_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1response_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  LassoNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  result = (LassoNode *)LassoDefederation_response_get(arg1);
  
  *(LassoNode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1server_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  LassoServer *arg2 = (LassoServer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  arg2 = *(LassoServer **)(void *)&jarg2; 
  LassoDefederation_server_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1server_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  LassoServer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  result = (LassoServer *)LassoDefederation_server_get(arg1);
  
  *(LassoServer **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1session_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  LassoSession *arg2 = (LassoSession *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  arg2 = *(LassoSession **)(void *)&jarg2; 
  LassoDefederation_session_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1session_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  LassoSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  result = (LassoSession *)LassoDefederation_session_get(arg1);
  
  *(LassoSession **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Defederation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  LassoDefederation *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  result = (LassoDefederation *)new_LassoDefederation(arg1);
  
  *(LassoDefederation **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Defederation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  delete_LassoDefederation(arg1);
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1setIdentityFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoDefederation_setIdentityFromDump(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1setSessionFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoDefederation_setSessionFromDump(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1buildNotificationMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  {
    int errorCode;
    errorCode = result = (int)LassoDefederation_buildNotificationMsg(arg1);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1initNotification(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
  jint jresult = 0 ;
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  char *arg2 = (char *) NULL ;
  LassoHttpMethod arg3 = (LassoHttpMethod) LASSO_HTTP_METHOD_ANY ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (LassoHttpMethod)jarg3; 
  {
    int errorCode;
    errorCode = result = (int)LassoDefederation_initNotification(arg1,arg2,arg3);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1processNotificationMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoDefederation_processNotificationMsg(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Defederation_1validateNotification(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoDefederation *arg1 = (LassoDefederation *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoDefederation **)(void *)&jarg1; 
  {
    int errorCode;
    errorCode = result = (int)LassoDefederation_validateNotification(arg1);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1assertionArtifact_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  result = (char *) ((arg1)->assertionArtifact);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1protocolProfile_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  LassoLoginProtocolProfile result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  result = (LassoLoginProtocolProfile) ((arg1)->protocolProfile);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1artifact_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  result = (char *)LassoLogin_artifact_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1artifactMessage_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLogin_artifactMessage_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1artifactMessage_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  result = (char *)LassoLogin_artifactMessage_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1identity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  LassoIdentity *arg2 = (LassoIdentity *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  arg2 = *(LassoIdentity **)(void *)&jarg2; 
  LassoLogin_identity_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1identity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  LassoIdentity *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  result = (LassoIdentity *)LassoLogin_identity_get(arg1);
  
  *(LassoIdentity **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1isIdentityDirty_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  result = (bool)LassoLogin_isIdentityDirty_get(arg1);
  
  jresult = (jboolean)result; 
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1isSessionDirty_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  result = (bool)LassoLogin_isSessionDirty_get(arg1);
  
  jresult = (jboolean)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1msgBody_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  result = (char *)LassoLogin_msgBody_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1msgRelayState_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  result = (char *)LassoLogin_msgRelayState_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1msgUrl_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  result = (char *)LassoLogin_msgUrl_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1nameIdentifier_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  LassoNode *arg2 = (LassoNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  arg2 = *(LassoNode **)(void *)&jarg2; 
  LassoLogin_nameIdentifier_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1nameIdentifier_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  LassoNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  result = (LassoNode *)LassoLogin_nameIdentifier_get(arg1);
  
  *(LassoNode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1remoteProviderId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLogin_remoteProviderId_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1remoteProviderId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  result = (char *)LassoLogin_remoteProviderId_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1request_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  LassoNode *arg2 = (LassoNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  arg2 = *(LassoNode **)(void *)&jarg2; 
  LassoLogin_request_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1request_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  LassoNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  result = (LassoNode *)LassoLogin_request_get(arg1);
  
  *(LassoNode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1response_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  LassoNode *arg2 = (LassoNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  arg2 = *(LassoNode **)(void *)&jarg2; 
  LassoLogin_response_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1response_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  LassoNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  result = (LassoNode *)LassoLogin_response_get(arg1);
  
  *(LassoNode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1server_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  LassoServer *arg2 = (LassoServer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  arg2 = *(LassoServer **)(void *)&jarg2; 
  LassoLogin_server_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1server_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  LassoServer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  result = (LassoServer *)LassoLogin_server_get(arg1);
  
  *(LassoServer **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1session_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  LassoSession *arg2 = (LassoSession *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  arg2 = *(LassoSession **)(void *)&jarg2; 
  LassoLogin_session_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1session_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  LassoSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  result = (LassoSession *)LassoLogin_session_get(arg1);
  
  *(LassoSession **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Login(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  LassoLogin *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  result = (LassoLogin *)new_LassoLogin(arg1);
  
  *(LassoLogin **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Login(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  delete_LassoLogin(arg1);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1newFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  char *arg2 = (char *) 0 ;
  LassoLogin *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  result = (LassoLogin *)LassoLogin_newFromDump(arg1,arg2);
  
  *(LassoLogin **)(void *)&jresult = result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1setIdentityFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoLogin_setIdentityFromDump(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1setSessionFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoLogin_setSessionFromDump(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1acceptSso(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  {
    int errorCode;
    errorCode = result = (int)LassoLogin_acceptSso(arg1);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1buildArtifactMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  LassoHttpMethod arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  arg2 = (LassoHttpMethod)jarg2; 
  {
    int errorCode;
    errorCode = result = (int)LassoLogin_buildArtifactMsg(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1buildAssertion(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jstring jarg6) {
  jint jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  char *arg5 = (char *) 0 ;
  char *arg6 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg5, 0);
    if (!arg5) return 0;
  }
  arg6 = 0;
  if (jarg6) {
    arg6 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg6, 0);
    if (!arg6) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoLogin_buildAssertion(arg1,arg2,arg3,arg4,arg5,arg6);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4);
  if (arg5) (*jenv)->ReleaseStringUTFChars(jenv, jarg5, arg5);
  if (arg6) (*jenv)->ReleaseStringUTFChars(jenv, jarg6, arg6);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1buildAuthnRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  {
    int errorCode;
    errorCode = result = (int)LassoLogin_buildAuthnRequestMsg(arg1);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1buildAuthnResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  {
    int errorCode;
    errorCode = result = (int)LassoLogin_buildAuthnResponseMsg(arg1);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1buildRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  {
    int errorCode;
    errorCode = result = (int)LassoLogin_buildRequestMsg(arg1);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1buildResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoLogin_buildResponseMsg(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  result = (char *)LassoLogin_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1initAuthnRequest(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
  jint jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  char *arg2 = (char *) NULL ;
  LassoHttpMethod arg3 = (LassoHttpMethod) LASSO_HTTP_METHOD_REDIRECT ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (LassoHttpMethod)jarg3; 
  {
    int errorCode;
    errorCode = result = (int)LassoLogin_initAuthnRequest(arg1,arg2,arg3);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1initRequest(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
  jint jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  char *arg2 = (char *) 0 ;
  LassoHttpMethod arg3 = (LassoHttpMethod) LASSO_HTTP_METHOD_REDIRECT ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (LassoHttpMethod)jarg3; 
  {
    int errorCode;
    errorCode = result = (int)LassoLogin_initRequest(arg1,arg2,arg3);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1initIdpInitiatedAuthnRequest(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  char *arg2 = (char *) NULL ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoLogin_initIdpInitiatedAuthnRequest(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1mustAskForConsent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  result = (bool)LassoLogin_mustAskForConsent(arg1);
  
  jresult = (jboolean)result; 
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1mustAuthenticate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  result = (bool)LassoLogin_mustAuthenticate(arg1);
  
  jresult = (jboolean)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1processAuthnRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoLogin_processAuthnRequestMsg(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1processAuthnResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoLogin_processAuthnResponseMsg(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1processRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoLogin_processRequestMsg(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1processResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoLogin_processResponseMsg(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1setResourceId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoLogin_setResourceId(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Login_1validateRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2, jboolean jarg3) {
  jint jresult = 0 ;
  LassoLogin *arg1 = (LassoLogin *) 0 ;
  bool arg2 ;
  bool arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogin **)(void *)&jarg1; 
  arg2 = jarg2 ? true : false; 
  arg3 = jarg3 ? true : false; 
  {
    int errorCode;
    errorCode = result = (int)LassoLogin_validateRequestMsg(arg1,arg2,arg3);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1artifact_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  result = (char *)LassoLogout_artifact_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1artifactMessage_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLogout_artifactMessage_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1artifactMessage_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  result = (char *)LassoLogout_artifactMessage_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1identity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  LassoIdentity *arg2 = (LassoIdentity *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  arg2 = *(LassoIdentity **)(void *)&jarg2; 
  LassoLogout_identity_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1identity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  LassoIdentity *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  result = (LassoIdentity *)LassoLogout_identity_get(arg1);
  
  *(LassoIdentity **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1isIdentityDirty_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  result = (bool)LassoLogout_isIdentityDirty_get(arg1);
  
  jresult = (jboolean)result; 
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1isSessionDirty_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  result = (bool)LassoLogout_isSessionDirty_get(arg1);
  
  jresult = (jboolean)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1msgBody_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  result = (char *)LassoLogout_msgBody_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1msgRelayState_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  result = (char *)LassoLogout_msgRelayState_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1msgUrl_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  result = (char *)LassoLogout_msgUrl_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1nameIdentifier_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  LassoNode *arg2 = (LassoNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  arg2 = *(LassoNode **)(void *)&jarg2; 
  LassoLogout_nameIdentifier_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1nameIdentifier_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  LassoNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  result = (LassoNode *)LassoLogout_nameIdentifier_get(arg1);
  
  *(LassoNode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1remoteProviderId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLogout_remoteProviderId_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1remoteProviderId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  result = (char *)LassoLogout_remoteProviderId_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1request_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  LassoNode *arg2 = (LassoNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  arg2 = *(LassoNode **)(void *)&jarg2; 
  LassoLogout_request_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1request_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  LassoNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  result = (LassoNode *)LassoLogout_request_get(arg1);
  
  *(LassoNode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1response_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  LassoNode *arg2 = (LassoNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  arg2 = *(LassoNode **)(void *)&jarg2; 
  LassoLogout_response_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1response_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  LassoNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  result = (LassoNode *)LassoLogout_response_get(arg1);
  
  *(LassoNode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1server_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  LassoServer *arg2 = (LassoServer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  arg2 = *(LassoServer **)(void *)&jarg2; 
  LassoLogout_server_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1server_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  LassoServer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  result = (LassoServer *)LassoLogout_server_get(arg1);
  
  *(LassoServer **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1session_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  LassoSession *arg2 = (LassoSession *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  arg2 = *(LassoSession **)(void *)&jarg2; 
  LassoLogout_session_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1session_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  LassoSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  result = (LassoSession *)LassoLogout_session_get(arg1);
  
  *(LassoSession **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Logout(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  LassoLogout *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  result = (LassoLogout *)new_LassoLogout(arg1);
  
  *(LassoLogout **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Logout(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  delete_LassoLogout(arg1);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1newFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  char *arg2 = (char *) 0 ;
  LassoLogout *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  result = (LassoLogout *)LassoLogout_newFromDump(arg1,arg2);
  
  *(LassoLogout **)(void *)&jresult = result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1setIdentityFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoLogout_setIdentityFromDump(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1setSessionFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoLogout_setSessionFromDump(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1buildRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  {
    int errorCode;
    errorCode = result = (int)LassoLogout_buildRequestMsg(arg1);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1buildResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  {
    int errorCode;
    errorCode = result = (int)LassoLogout_buildResponseMsg(arg1);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  result = (char *)LassoLogout_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1getNextProviderId(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  result = (char *)LassoLogout_getNextProviderId(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1initRequest(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
  jint jresult = 0 ;
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  char *arg2 = (char *) NULL ;
  LassoHttpMethod arg3 = (LassoHttpMethod) LASSO_HTTP_METHOD_ANY ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (LassoHttpMethod)jarg3; 
  {
    int errorCode;
    errorCode = result = (int)LassoLogout_initRequest(arg1,arg2,arg3);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1processRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoLogout_processRequestMsg(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1processResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoLogout_processResponseMsg(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1resetProviderIdIndex(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  {
    int errorCode;
    errorCode = result = (int)LassoLogout_resetProviderIdIndex(arg1);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Logout_1validateRequest(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLogout *arg1 = (LassoLogout *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLogout **)(void *)&jarg1; 
  {
    int errorCode;
    errorCode = result = (int)LassoLogout_validateRequest(arg1);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1artifact_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  result = (char *)LassoLecp_artifact_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1artifactMessage_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLecp_artifactMessage_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1artifactMessage_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  result = (char *)LassoLecp_artifactMessage_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1identity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  LassoIdentity *arg2 = (LassoIdentity *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  arg2 = *(LassoIdentity **)(void *)&jarg2; 
  LassoLecp_identity_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1identity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  LassoIdentity *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  result = (LassoIdentity *)LassoLecp_identity_get(arg1);
  
  *(LassoIdentity **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1isIdentityDirty_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  result = (bool)LassoLecp_isIdentityDirty_get(arg1);
  
  jresult = (jboolean)result; 
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1isSessionDirty_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  result = (bool)LassoLecp_isSessionDirty_get(arg1);
  
  jresult = (jboolean)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1msgBody_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  result = (char *)LassoLecp_msgBody_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1msgRelayState_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  result = (char *)LassoLecp_msgRelayState_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1msgUrl_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  result = (char *)LassoLecp_msgUrl_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1nameIdentifier_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  LassoNode *arg2 = (LassoNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  arg2 = *(LassoNode **)(void *)&jarg2; 
  LassoLecp_nameIdentifier_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1nameIdentifier_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  LassoNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  result = (LassoNode *)LassoLecp_nameIdentifier_get(arg1);
  
  *(LassoNode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1remoteProviderId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoLecp_remoteProviderId_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1remoteProviderId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  result = (char *)LassoLecp_remoteProviderId_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1request_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  LassoNode *arg2 = (LassoNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  arg2 = *(LassoNode **)(void *)&jarg2; 
  LassoLecp_request_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1request_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  LassoNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  result = (LassoNode *)LassoLecp_request_get(arg1);
  
  *(LassoNode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1response_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  LassoNode *arg2 = (LassoNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  arg2 = *(LassoNode **)(void *)&jarg2; 
  LassoLecp_response_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1response_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  LassoNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  result = (LassoNode *)LassoLecp_response_get(arg1);
  
  *(LassoNode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1server_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  LassoServer *arg2 = (LassoServer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  arg2 = *(LassoServer **)(void *)&jarg2; 
  LassoLecp_server_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1server_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  LassoServer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  result = (LassoServer *)LassoLecp_server_get(arg1);
  
  *(LassoServer **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1session_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  LassoSession *arg2 = (LassoSession *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  arg2 = *(LassoSession **)(void *)&jarg2; 
  LassoLecp_session_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1session_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  LassoSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  result = (LassoSession *)LassoLecp_session_get(arg1);
  
  *(LassoSession **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Lecp(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  LassoLecp *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  result = (LassoLecp *)new_LassoLecp(arg1);
  
  *(LassoLecp **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Lecp(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  delete_LassoLecp(arg1);
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1setIdentityFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoLecp_setIdentityFromDump(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1setSessionFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoLecp_setSessionFromDump(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1buildAssertion(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jstring jarg6) {
  jint jresult = 0 ;
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  char *arg5 = (char *) 0 ;
  char *arg6 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg5, 0);
    if (!arg5) return 0;
  }
  arg6 = 0;
  if (jarg6) {
    arg6 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg6, 0);
    if (!arg6) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoLecp_buildAssertion(arg1,arg2,arg3,arg4,arg5,arg6);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4);
  if (arg5) (*jenv)->ReleaseStringUTFChars(jenv, jarg5, arg5);
  if (arg6) (*jenv)->ReleaseStringUTFChars(jenv, jarg6, arg6);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1setResourceId(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoLecp_setResourceId(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1validateRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2, jboolean jarg3) {
  jint jresult = 0 ;
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  bool arg2 ;
  bool arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  arg2 = jarg2 ? true : false; 
  arg3 = jarg3 ? true : false; 
  {
    int errorCode;
    errorCode = result = (int)LassoLecp_validateRequestMsg(arg1,arg2,arg3);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1buildAuthnRequestEnvelopeMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  {
    int errorCode;
    errorCode = result = (int)LassoLecp_buildAuthnRequestEnvelopeMsg(arg1);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1buildAuthnRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  {
    int errorCode;
    errorCode = result = (int)LassoLecp_buildAuthnRequestMsg(arg1);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1buildAuthnResponseEnvelopeMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  {
    int errorCode;
    errorCode = result = (int)LassoLecp_buildAuthnResponseEnvelopeMsg(arg1);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1buildAuthnResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  {
    int errorCode;
    errorCode = result = (int)LassoLecp_buildAuthnResponseMsg(arg1);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1initAuthnRequest(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  char *arg2 = (char *) NULL ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoLecp_initAuthnRequest(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1processAuthnRequestEnvelopeMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoLecp_processAuthnRequestEnvelopeMsg(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1processAuthnRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoLecp_processAuthnRequestMsg(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Lecp_1processAuthnResponseEnvelopeMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoLecp *arg1 = (LassoLecp *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoLecp **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoLecp_processAuthnResponseEnvelopeMsg(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1targetNameIdentifier_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  result = (char *) ((arg1)->targetNameIdentifier);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1artifact_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  result = (char *)LassoNameIdentifierMapping_artifact_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1artifactMessage_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoNameIdentifierMapping_artifactMessage_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1artifactMessage_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  result = (char *)LassoNameIdentifierMapping_artifactMessage_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1identity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  LassoIdentity *arg2 = (LassoIdentity *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  arg2 = *(LassoIdentity **)(void *)&jarg2; 
  LassoNameIdentifierMapping_identity_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1identity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  LassoIdentity *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  result = (LassoIdentity *)LassoNameIdentifierMapping_identity_get(arg1);
  
  *(LassoIdentity **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1isIdentityDirty_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  result = (bool)LassoNameIdentifierMapping_isIdentityDirty_get(arg1);
  
  jresult = (jboolean)result; 
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1isSessionDirty_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  result = (bool)LassoNameIdentifierMapping_isSessionDirty_get(arg1);
  
  jresult = (jboolean)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1msgBody_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  result = (char *)LassoNameIdentifierMapping_msgBody_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1msgUrl_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  result = (char *)LassoNameIdentifierMapping_msgUrl_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1nameIdentifier_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  LassoNode *arg2 = (LassoNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  arg2 = *(LassoNode **)(void *)&jarg2; 
  LassoNameIdentifierMapping_nameIdentifier_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1nameIdentifier_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  LassoNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  result = (LassoNode *)LassoNameIdentifierMapping_nameIdentifier_get(arg1);
  
  *(LassoNode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1remoteProviderId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoNameIdentifierMapping_remoteProviderId_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1remoteProviderId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  result = (char *)LassoNameIdentifierMapping_remoteProviderId_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1request_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  LassoNode *arg2 = (LassoNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  arg2 = *(LassoNode **)(void *)&jarg2; 
  LassoNameIdentifierMapping_request_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1request_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  LassoNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  result = (LassoNode *)LassoNameIdentifierMapping_request_get(arg1);
  
  *(LassoNode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1response_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  LassoNode *arg2 = (LassoNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  arg2 = *(LassoNode **)(void *)&jarg2; 
  LassoNameIdentifierMapping_response_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1response_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  LassoNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  result = (LassoNode *)LassoNameIdentifierMapping_response_get(arg1);
  
  *(LassoNode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1server_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  LassoServer *arg2 = (LassoServer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  arg2 = *(LassoServer **)(void *)&jarg2; 
  LassoNameIdentifierMapping_server_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1server_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  LassoServer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  result = (LassoServer *)LassoNameIdentifierMapping_server_get(arg1);
  
  *(LassoServer **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1session_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  LassoSession *arg2 = (LassoSession *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  arg2 = *(LassoSession **)(void *)&jarg2; 
  LassoNameIdentifierMapping_session_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1session_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  LassoSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  result = (LassoSession *)LassoNameIdentifierMapping_session_get(arg1);
  
  *(LassoSession **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1NameIdentifierMapping(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  LassoNameIdentifierMapping *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  result = (LassoNameIdentifierMapping *)new_LassoNameIdentifierMapping(arg1);
  
  *(LassoNameIdentifierMapping **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1NameIdentifierMapping(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  delete_LassoNameIdentifierMapping(arg1);
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1setIdentityFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoNameIdentifierMapping_setIdentityFromDump(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1setSessionFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoNameIdentifierMapping_setSessionFromDump(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1buildRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  {
    int errorCode;
    errorCode = result = (int)LassoNameIdentifierMapping_buildRequestMsg(arg1);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1buildResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  {
    int errorCode;
    errorCode = result = (int)LassoNameIdentifierMapping_buildResponseMsg(arg1);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1initRequest(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
  jint jresult = 0 ;
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) NULL ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoNameIdentifierMapping_initRequest(arg1,arg2,arg3);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1processRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoNameIdentifierMapping_processRequestMsg(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1processResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoNameIdentifierMapping_processResponseMsg(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameIdentifierMapping_1validateRequest(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoNameIdentifierMapping *arg1 = (LassoNameIdentifierMapping *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameIdentifierMapping **)(void *)&jarg1; 
  {
    int errorCode;
    errorCode = result = (int)LassoNameIdentifierMapping_validateRequest(arg1);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1artifact_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  result = (char *)LassoNameRegistration_artifact_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1artifactMessage_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoNameRegistration_artifactMessage_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1artifactMessage_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  result = (char *)LassoNameRegistration_artifactMessage_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1identity_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  LassoIdentity *arg2 = (LassoIdentity *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  arg2 = *(LassoIdentity **)(void *)&jarg2; 
  LassoNameRegistration_identity_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1identity_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  LassoIdentity *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  result = (LassoIdentity *)LassoNameRegistration_identity_get(arg1);
  
  *(LassoIdentity **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1isIdentityDirty_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  result = (bool)LassoNameRegistration_isIdentityDirty_get(arg1);
  
  jresult = (jboolean)result; 
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1isSessionDirty_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  result = (bool)LassoNameRegistration_isSessionDirty_get(arg1);
  
  jresult = (jboolean)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1msgBody_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  result = (char *)LassoNameRegistration_msgBody_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1msgRelayState_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  result = (char *)LassoNameRegistration_msgRelayState_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1msgUrl_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  result = (char *)LassoNameRegistration_msgUrl_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1nameIdentifier_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  LassoNode *arg2 = (LassoNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  arg2 = *(LassoNode **)(void *)&jarg2; 
  LassoNameRegistration_nameIdentifier_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1nameIdentifier_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  LassoNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  result = (LassoNode *)LassoNameRegistration_nameIdentifier_get(arg1);
  
  *(LassoNode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1remoteProviderId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoNameRegistration_remoteProviderId_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1remoteProviderId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  result = (char *)LassoNameRegistration_remoteProviderId_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1request_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  LassoNode *arg2 = (LassoNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  arg2 = *(LassoNode **)(void *)&jarg2; 
  LassoNameRegistration_request_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1request_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  LassoNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  result = (LassoNode *)LassoNameRegistration_request_get(arg1);
  
  *(LassoNode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1response_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  LassoNode *arg2 = (LassoNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  arg2 = *(LassoNode **)(void *)&jarg2; 
  LassoNameRegistration_response_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1response_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  LassoNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  result = (LassoNode *)LassoNameRegistration_response_get(arg1);
  
  *(LassoNode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1server_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  LassoServer *arg2 = (LassoServer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  arg2 = *(LassoServer **)(void *)&jarg2; 
  LassoNameRegistration_server_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1server_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  LassoServer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  result = (LassoServer *)LassoNameRegistration_server_get(arg1);
  
  *(LassoServer **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1session_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  LassoSession *arg2 = (LassoSession *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  arg2 = *(LassoSession **)(void *)&jarg2; 
  LassoNameRegistration_session_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1session_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  LassoSession *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  result = (LassoSession *)LassoNameRegistration_session_get(arg1);
  
  *(LassoSession **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1oldNameIdentifier_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  LassoSamlNameIdentifier *arg2 = (LassoSamlNameIdentifier *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  arg2 = *(LassoSamlNameIdentifier **)(void *)&jarg2; 
  LassoNameRegistration_oldNameIdentifier_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1oldNameIdentifier_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  LassoSamlNameIdentifier *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  result = (LassoSamlNameIdentifier *)LassoNameRegistration_oldNameIdentifier_get(arg1);
  
  *(LassoSamlNameIdentifier **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1NameRegistration(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  LassoNameRegistration *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  result = (LassoNameRegistration *)new_LassoNameRegistration(arg1);
  
  *(LassoNameRegistration **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1NameRegistration(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  delete_LassoNameRegistration(arg1);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1newFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  LassoServer *arg1 = (LassoServer *) 0 ;
  char *arg2 = (char *) 0 ;
  LassoNameRegistration *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoServer **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  result = (LassoNameRegistration *)LassoNameRegistration_newFromDump(arg1,arg2);
  
  *(LassoNameRegistration **)(void *)&jresult = result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1setIdentityFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoNameRegistration_setIdentityFromDump(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1setSessionFromDump(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoNameRegistration_setSessionFromDump(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1buildRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  {
    int errorCode;
    errorCode = result = (int)LassoNameRegistration_buildRequestMsg(arg1);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1buildResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  {
    int errorCode;
    errorCode = result = (int)LassoNameRegistration_buildResponseMsg(arg1);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  result = (char *)LassoNameRegistration_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1initRequest(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
  jint jresult = 0 ;
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  char *arg2 = (char *) 0 ;
  LassoHttpMethod arg3 = (LassoHttpMethod) LASSO_HTTP_METHOD_ANY ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (LassoHttpMethod)jarg3; 
  {
    int errorCode;
    errorCode = result = (int)LassoNameRegistration_initRequest(arg1,arg2,arg3);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1processRequestMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoNameRegistration_processRequestMsg(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1processResponseMsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int errorCode;
    errorCode = result = (int)LassoNameRegistration_processResponseMsg(arg1,arg2);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_NameRegistration_1validateRequest(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoNameRegistration *arg1 = (LassoNameRegistration *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoNameRegistration **)(void *)&jarg1; 
  {
    int errorCode;
    errorCode = result = (int)LassoNameRegistration_validateRequest(arg1);
    
    if (errorCode) {
      char errorMsg[256];
      int swig_error = SWIG_RuntimeError;
      if (errorCode == -501 || 
        errorCode == -501) {
        swig_error = SWIG_ValueError;
      }
      build_exception_msg(errorCode, errorMsg);
      /*@SWIG:SWIG_exception@*/
      {
        SWIG_JavaException(jenv, swig_error, errorMsg);
        return 0;
      }
      /*@SWIG@*/;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDPolicy_1format_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2NameIDPolicy *arg1 = (LassoSamlp2NameIDPolicy *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDPolicy **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Format) free((char*)arg1->Format);
    if (arg2) {
      arg1->Format = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Format,arg2);
    } else {
      arg1->Format = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDPolicy_1format_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2NameIDPolicy *arg1 = (LassoSamlp2NameIDPolicy *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDPolicy **)(void *)&jarg1; 
  result = (char *) ((arg1)->Format);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDPolicy_1SPNameQualifier_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2NameIDPolicy *arg1 = (LassoSamlp2NameIDPolicy *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDPolicy **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->SPNameQualifier) free((char*)arg1->SPNameQualifier);
    if (arg2) {
      arg1->SPNameQualifier = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->SPNameQualifier,arg2);
    } else {
      arg1->SPNameQualifier = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDPolicy_1SPNameQualifier_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2NameIDPolicy *arg1 = (LassoSamlp2NameIDPolicy *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDPolicy **)(void *)&jarg1; 
  result = (char *) ((arg1)->SPNameQualifier);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDPolicy_1allowCreate_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2) {
  LassoSamlp2NameIDPolicy *arg1 = (LassoSamlp2NameIDPolicy *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDPolicy **)(void *)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->AllowCreate = arg2;
  
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDPolicy_1allowCreate_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  LassoSamlp2NameIDPolicy *arg1 = (LassoSamlp2NameIDPolicy *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDPolicy **)(void *)&jarg1; 
  result = (bool) ((arg1)->AllowCreate);
  
  jresult = (jboolean)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Samlp2NameIDPolicy(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlp2NameIDPolicy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlp2NameIDPolicy *)new_LassoSamlp2NameIDPolicy();
  
  *(LassoSamlp2NameIDPolicy **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Samlp2NameIDPolicy(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlp2NameIDPolicy *arg1 = (LassoSamlp2NameIDPolicy *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDPolicy **)(void *)&jarg1; 
  delete_LassoSamlp2NameIDPolicy(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDPolicy_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2NameIDPolicy *arg1 = (LassoSamlp2NameIDPolicy *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDPolicy **)(void *)&jarg1; 
  result = (char *)LassoSamlp2NameIDPolicy_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2RequestedAuthnContext_1AuthnContextClassRef_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2RequestedAuthnContext *arg1 = (LassoSamlp2RequestedAuthnContext *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2RequestedAuthnContext **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->AuthnContextClassRef) free((char*)arg1->AuthnContextClassRef);
    if (arg2) {
      arg1->AuthnContextClassRef = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->AuthnContextClassRef,arg2);
    } else {
      arg1->AuthnContextClassRef = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2RequestedAuthnContext_1AuthnContextClassRef_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2RequestedAuthnContext *arg1 = (LassoSamlp2RequestedAuthnContext *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2RequestedAuthnContext **)(void *)&jarg1; 
  result = (char *) ((arg1)->AuthnContextClassRef);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2RequestedAuthnContext_1AuthnContextDeclRef_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2RequestedAuthnContext *arg1 = (LassoSamlp2RequestedAuthnContext *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2RequestedAuthnContext **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->AuthnContextDeclRef) free((char*)arg1->AuthnContextDeclRef);
    if (arg2) {
      arg1->AuthnContextDeclRef = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->AuthnContextDeclRef,arg2);
    } else {
      arg1->AuthnContextDeclRef = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2RequestedAuthnContext_1AuthnContextDeclRef_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2RequestedAuthnContext *arg1 = (LassoSamlp2RequestedAuthnContext *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2RequestedAuthnContext **)(void *)&jarg1; 
  result = (char *) ((arg1)->AuthnContextDeclRef);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2RequestedAuthnContext_1Comparison_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2RequestedAuthnContext *arg1 = (LassoSamlp2RequestedAuthnContext *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2RequestedAuthnContext **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Comparison) free((char*)arg1->Comparison);
    if (arg2) {
      arg1->Comparison = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Comparison,arg2);
    } else {
      arg1->Comparison = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2RequestedAuthnContext_1Comparison_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2RequestedAuthnContext *arg1 = (LassoSamlp2RequestedAuthnContext *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2RequestedAuthnContext **)(void *)&jarg1; 
  result = (char *) ((arg1)->Comparison);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Samlp2RequestedAuthnContext(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlp2RequestedAuthnContext *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlp2RequestedAuthnContext *)new_LassoSamlp2RequestedAuthnContext();
  
  *(LassoSamlp2RequestedAuthnContext **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Samlp2RequestedAuthnContext(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlp2RequestedAuthnContext *arg1 = (LassoSamlp2RequestedAuthnContext *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2RequestedAuthnContext **)(void *)&jarg1; 
  delete_LassoSamlp2RequestedAuthnContext(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2RequestedAuthnContext_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2RequestedAuthnContext *arg1 = (LassoSamlp2RequestedAuthnContext *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2RequestedAuthnContext **)(void *)&jarg1; 
  result = (char *)LassoSamlp2RequestedAuthnContext_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Assertion_1Version_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2Assertion *arg1 = (LassoSaml2Assertion *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Assertion **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Version) free((char*)arg1->Version);
    if (arg2) {
      arg1->Version = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Version,arg2);
    } else {
      arg1->Version = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Assertion_1Version_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2Assertion *arg1 = (LassoSaml2Assertion *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Assertion **)(void *)&jarg1; 
  result = (char *) ((arg1)->Version);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Assertion_1ID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2Assertion *arg1 = (LassoSaml2Assertion *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Assertion **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->ID) free((char*)arg1->ID);
    if (arg2) {
      arg1->ID = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->ID,arg2);
    } else {
      arg1->ID = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Assertion_1ID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2Assertion *arg1 = (LassoSaml2Assertion *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Assertion **)(void *)&jarg1; 
  result = (char *) ((arg1)->ID);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Assertion_1issueInstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2Assertion *arg1 = (LassoSaml2Assertion *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Assertion **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->IssueInstant) free((char*)arg1->IssueInstant);
    if (arg2) {
      arg1->IssueInstant = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->IssueInstant,arg2);
    } else {
      arg1->IssueInstant = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Assertion_1issueInstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2Assertion *arg1 = (LassoSaml2Assertion *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Assertion **)(void *)&jarg1; 
  result = (char *) ((arg1)->IssueInstant);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Assertion_1issuer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSaml2Assertion *arg1 = (LassoSaml2Assertion *) 0 ;
  LassoSaml2NameID *arg2 = (LassoSaml2NameID *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Assertion **)(void *)&jarg1; 
  arg2 = *(LassoSaml2NameID **)(void *)&jarg2; 
  LassoSaml2Assertion_Issuer_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Assertion_1issuer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSaml2Assertion *arg1 = (LassoSaml2Assertion *) 0 ;
  LassoSaml2NameID *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Assertion **)(void *)&jarg1; 
  result = (LassoSaml2NameID *)LassoSaml2Assertion_Issuer_get(arg1);
  
  *(LassoSaml2NameID **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Assertion_1subject_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSaml2Assertion *arg1 = (LassoSaml2Assertion *) 0 ;
  LassoSaml2Subject *arg2 = (LassoSaml2Subject *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Assertion **)(void *)&jarg1; 
  arg2 = *(LassoSaml2Subject **)(void *)&jarg2; 
  LassoSaml2Assertion_Subject_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Assertion_1subject_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSaml2Assertion *arg1 = (LassoSaml2Assertion *) 0 ;
  LassoSaml2Subject *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Assertion **)(void *)&jarg1; 
  result = (LassoSaml2Subject *)LassoSaml2Assertion_Subject_get(arg1);
  
  *(LassoSaml2Subject **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Assertion_1conditions_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSaml2Assertion *arg1 = (LassoSaml2Assertion *) 0 ;
  LassoSaml2Conditions *arg2 = (LassoSaml2Conditions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Assertion **)(void *)&jarg1; 
  arg2 = *(LassoSaml2Conditions **)(void *)&jarg2; 
  LassoSaml2Assertion_Conditions_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Assertion_1conditions_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSaml2Assertion *arg1 = (LassoSaml2Assertion *) 0 ;
  LassoSaml2Conditions *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Assertion **)(void *)&jarg1; 
  result = (LassoSaml2Conditions *)LassoSaml2Assertion_Conditions_get(arg1);
  
  *(LassoSaml2Conditions **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Assertion_1advice_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSaml2Assertion *arg1 = (LassoSaml2Assertion *) 0 ;
  LassoSaml2Advice *arg2 = (LassoSaml2Advice *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Assertion **)(void *)&jarg1; 
  arg2 = *(LassoSaml2Advice **)(void *)&jarg2; 
  LassoSaml2Assertion_Advice_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Assertion_1advice_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSaml2Assertion *arg1 = (LassoSaml2Assertion *) 0 ;
  LassoSaml2Advice *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Assertion **)(void *)&jarg1; 
  result = (LassoSaml2Advice *)LassoSaml2Assertion_Advice_get(arg1);
  
  *(LassoSaml2Advice **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Saml2Assertion(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSaml2Assertion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSaml2Assertion *)new_LassoSaml2Assertion();
  
  *(LassoSaml2Assertion **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Saml2Assertion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSaml2Assertion *arg1 = (LassoSaml2Assertion *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Assertion **)(void *)&jarg1; 
  delete_LassoSaml2Assertion(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Assertion_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2Assertion *arg1 = (LassoSaml2Assertion *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Assertion **)(void *)&jarg1; 
  result = (char *)LassoSaml2Assertion_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2IDPList_1GetComplete_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2IDPList *arg1 = (LassoSamlp2IDPList *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2IDPList **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->GetComplete) free((char*)arg1->GetComplete);
    if (arg2) {
      arg1->GetComplete = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->GetComplete,arg2);
    } else {
      arg1->GetComplete = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2IDPList_1GetComplete_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2IDPList *arg1 = (LassoSamlp2IDPList *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2IDPList **)(void *)&jarg1; 
  result = (char *) ((arg1)->GetComplete);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2IDPList_1iDPEntry_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2IDPList *arg1 = (LassoSamlp2IDPList *) 0 ;
  LassoSamlp2IDPEntry *arg2 = (LassoSamlp2IDPEntry *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2IDPList **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2IDPEntry **)(void *)&jarg2; 
  LassoSamlp2IDPList_IDPEntry_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2IDPList_1iDPEntry_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2IDPList *arg1 = (LassoSamlp2IDPList *) 0 ;
  LassoSamlp2IDPEntry *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2IDPList **)(void *)&jarg1; 
  result = (LassoSamlp2IDPEntry *)LassoSamlp2IDPList_IDPEntry_get(arg1);
  
  *(LassoSamlp2IDPEntry **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Samlp2IDPList(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlp2IDPList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlp2IDPList *)new_LassoSamlp2IDPList();
  
  *(LassoSamlp2IDPList **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Samlp2IDPList(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlp2IDPList *arg1 = (LassoSamlp2IDPList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2IDPList **)(void *)&jarg1; 
  delete_LassoSamlp2IDPList(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2IDPList_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2IDPList *arg1 = (LassoSamlp2IDPList *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2IDPList **)(void *)&jarg1; 
  result = (char *)LassoSamlp2IDPList_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Saml2KeyInfoConfirmationData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSaml2KeyInfoConfirmationData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSaml2KeyInfoConfirmationData *)new_LassoSaml2KeyInfoConfirmationData();
  
  *(LassoSaml2KeyInfoConfirmationData **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Saml2KeyInfoConfirmationData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSaml2KeyInfoConfirmationData *arg1 = (LassoSaml2KeyInfoConfirmationData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2KeyInfoConfirmationData **)(void *)&jarg1; 
  delete_LassoSaml2KeyInfoConfirmationData(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2KeyInfoConfirmationData_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2KeyInfoConfirmationData *arg1 = (LassoSaml2KeyInfoConfirmationData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2KeyInfoConfirmationData **)(void *)&jarg1; 
  result = (char *)LassoSaml2KeyInfoConfirmationData_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Conditions_1notBefore_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2Conditions *arg1 = (LassoSaml2Conditions *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Conditions **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->NotBefore) free((char*)arg1->NotBefore);
    if (arg2) {
      arg1->NotBefore = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->NotBefore,arg2);
    } else {
      arg1->NotBefore = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Conditions_1notBefore_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2Conditions *arg1 = (LassoSaml2Conditions *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Conditions **)(void *)&jarg1; 
  result = (char *) ((arg1)->NotBefore);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Conditions_1notOnOrAfter_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2Conditions *arg1 = (LassoSaml2Conditions *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Conditions **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->NotOnOrAfter) free((char*)arg1->NotOnOrAfter);
    if (arg2) {
      arg1->NotOnOrAfter = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->NotOnOrAfter,arg2);
    } else {
      arg1->NotOnOrAfter = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Conditions_1notOnOrAfter_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2Conditions *arg1 = (LassoSaml2Conditions *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Conditions **)(void *)&jarg1; 
  result = (char *) ((arg1)->NotOnOrAfter);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Saml2Conditions(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSaml2Conditions *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSaml2Conditions *)new_LassoSaml2Conditions();
  
  *(LassoSaml2Conditions **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Saml2Conditions(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSaml2Conditions *arg1 = (LassoSaml2Conditions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Conditions **)(void *)&jarg1; 
  delete_LassoSaml2Conditions(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Conditions_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2Conditions *arg1 = (LassoSaml2Conditions *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Conditions **)(void *)&jarg1; 
  result = (char *)LassoSaml2Conditions_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Saml2Evidence(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSaml2Evidence *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSaml2Evidence *)new_LassoSaml2Evidence();
  
  *(LassoSaml2Evidence **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Saml2Evidence(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSaml2Evidence *arg1 = (LassoSaml2Evidence *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Evidence **)(void *)&jarg1; 
  delete_LassoSaml2Evidence(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Evidence_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2Evidence *arg1 = (LassoSaml2Evidence *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Evidence **)(void *)&jarg1; 
  result = (char *)LassoSaml2Evidence_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2NameID_1content_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2NameID *arg1 = (LassoSaml2NameID *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2NameID **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->content) free((char*)arg1->content);
    if (arg2) {
      arg1->content = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->content,arg2);
    } else {
      arg1->content = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2NameID_1content_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2NameID *arg1 = (LassoSaml2NameID *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2NameID **)(void *)&jarg1; 
  result = (char *) ((arg1)->content);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2NameID_1format_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2NameID *arg1 = (LassoSaml2NameID *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2NameID **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Format) free((char*)arg1->Format);
    if (arg2) {
      arg1->Format = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Format,arg2);
    } else {
      arg1->Format = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2NameID_1format_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2NameID *arg1 = (LassoSaml2NameID *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2NameID **)(void *)&jarg1; 
  result = (char *) ((arg1)->Format);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2NameID_1SPProvidedID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2NameID *arg1 = (LassoSaml2NameID *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2NameID **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->SPProvidedID) free((char*)arg1->SPProvidedID);
    if (arg2) {
      arg1->SPProvidedID = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->SPProvidedID,arg2);
    } else {
      arg1->SPProvidedID = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2NameID_1SPProvidedID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2NameID *arg1 = (LassoSaml2NameID *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2NameID **)(void *)&jarg1; 
  result = (char *) ((arg1)->SPProvidedID);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2NameID_1nameQualifier_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2NameID *arg1 = (LassoSaml2NameID *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2NameID **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->NameQualifier) free((char*)arg1->NameQualifier);
    if (arg2) {
      arg1->NameQualifier = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->NameQualifier,arg2);
    } else {
      arg1->NameQualifier = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2NameID_1nameQualifier_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2NameID *arg1 = (LassoSaml2NameID *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2NameID **)(void *)&jarg1; 
  result = (char *) ((arg1)->NameQualifier);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2NameID_1SPNameQualifier_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2NameID *arg1 = (LassoSaml2NameID *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2NameID **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->SPNameQualifier) free((char*)arg1->SPNameQualifier);
    if (arg2) {
      arg1->SPNameQualifier = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->SPNameQualifier,arg2);
    } else {
      arg1->SPNameQualifier = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2NameID_1SPNameQualifier_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2NameID *arg1 = (LassoSaml2NameID *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2NameID **)(void *)&jarg1; 
  result = (char *) ((arg1)->SPNameQualifier);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Saml2NameID(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSaml2NameID *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSaml2NameID *)new_LassoSaml2NameID();
  
  *(LassoSaml2NameID **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Saml2NameID(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSaml2NameID *arg1 = (LassoSaml2NameID *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2NameID **)(void *)&jarg1; 
  delete_LassoSaml2NameID(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2NameID_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2NameID *arg1 = (LassoSaml2NameID *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2NameID **)(void *)&jarg1; 
  result = (char *)LassoSaml2NameID_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2StatusCode_1value_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2StatusCode *arg1 = (LassoSamlp2StatusCode *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusCode **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Value) free((char*)arg1->Value);
    if (arg2) {
      arg1->Value = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Value,arg2);
    } else {
      arg1->Value = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2StatusCode_1value_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2StatusCode *arg1 = (LassoSamlp2StatusCode *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusCode **)(void *)&jarg1; 
  result = (char *) ((arg1)->Value);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2StatusCode_1statusCode_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2StatusCode *arg1 = (LassoSamlp2StatusCode *) 0 ;
  LassoSamlp2StatusCode *arg2 = (LassoSamlp2StatusCode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusCode **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2StatusCode **)(void *)&jarg2; 
  LassoSamlp2StatusCode_StatusCode_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2StatusCode_1statusCode_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2StatusCode *arg1 = (LassoSamlp2StatusCode *) 0 ;
  LassoSamlp2StatusCode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusCode **)(void *)&jarg1; 
  result = (LassoSamlp2StatusCode *)LassoSamlp2StatusCode_StatusCode_get(arg1);
  
  *(LassoSamlp2StatusCode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Samlp2StatusCode(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlp2StatusCode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlp2StatusCode *)new_LassoSamlp2StatusCode();
  
  *(LassoSamlp2StatusCode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Samlp2StatusCode(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlp2StatusCode *arg1 = (LassoSamlp2StatusCode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusCode **)(void *)&jarg1; 
  delete_LassoSamlp2StatusCode(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2StatusCode_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2StatusCode *arg1 = (LassoSamlp2StatusCode *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusCode **)(void *)&jarg1; 
  result = (char *)LassoSamlp2StatusCode_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Status_1statusMessage_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2Status *arg1 = (LassoSamlp2Status *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Status **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->StatusMessage) free((char*)arg1->StatusMessage);
    if (arg2) {
      arg1->StatusMessage = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->StatusMessage,arg2);
    } else {
      arg1->StatusMessage = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Status_1statusMessage_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2Status *arg1 = (LassoSamlp2Status *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Status **)(void *)&jarg1; 
  result = (char *) ((arg1)->StatusMessage);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Status_1statusCode_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2Status *arg1 = (LassoSamlp2Status *) 0 ;
  LassoSamlp2StatusCode *arg2 = (LassoSamlp2StatusCode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Status **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2StatusCode **)(void *)&jarg2; 
  LassoSamlp2Status_StatusCode_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Status_1statusCode_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2Status *arg1 = (LassoSamlp2Status *) 0 ;
  LassoSamlp2StatusCode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Status **)(void *)&jarg1; 
  result = (LassoSamlp2StatusCode *)LassoSamlp2Status_StatusCode_get(arg1);
  
  *(LassoSamlp2StatusCode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Status_1statusDetail_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2Status *arg1 = (LassoSamlp2Status *) 0 ;
  LassoSamlp2StatusDetail *arg2 = (LassoSamlp2StatusDetail *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Status **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2StatusDetail **)(void *)&jarg2; 
  LassoSamlp2Status_StatusDetail_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Status_1statusDetail_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2Status *arg1 = (LassoSamlp2Status *) 0 ;
  LassoSamlp2StatusDetail *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Status **)(void *)&jarg1; 
  result = (LassoSamlp2StatusDetail *)LassoSamlp2Status_StatusDetail_get(arg1);
  
  *(LassoSamlp2StatusDetail **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Samlp2Status(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlp2Status *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlp2Status *)new_LassoSamlp2Status();
  
  *(LassoSamlp2Status **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Samlp2Status(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlp2Status *arg1 = (LassoSamlp2Status *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Status **)(void *)&jarg1; 
  delete_LassoSamlp2Status(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Status_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2Status *arg1 = (LassoSamlp2Status *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Status **)(void *)&jarg1; 
  result = (char *)LassoSamlp2Status_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Saml2ConditionAbstract(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSaml2ConditionAbstract *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSaml2ConditionAbstract *)new_LassoSaml2ConditionAbstract();
  
  *(LassoSaml2ConditionAbstract **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Saml2ConditionAbstract(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSaml2ConditionAbstract *arg1 = (LassoSaml2ConditionAbstract *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2ConditionAbstract **)(void *)&jarg1; 
  delete_LassoSaml2ConditionAbstract(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2ConditionAbstract_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2ConditionAbstract *arg1 = (LassoSaml2ConditionAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2ConditionAbstract **)(void *)&jarg1; 
  result = (char *)LassoSaml2ConditionAbstract_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Saml2OneTimeUse(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSaml2OneTimeUse *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSaml2OneTimeUse *)new_LassoSaml2OneTimeUse();
  
  *(LassoSaml2OneTimeUse **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Saml2OneTimeUse(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSaml2OneTimeUse *arg1 = (LassoSaml2OneTimeUse *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2OneTimeUse **)(void *)&jarg1; 
  delete_LassoSaml2OneTimeUse(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2OneTimeUse_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2OneTimeUse *arg1 = (LassoSaml2OneTimeUse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2OneTimeUse **)(void *)&jarg1; 
  result = (char *)LassoSaml2OneTimeUse_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Saml2Advice(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSaml2Advice *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSaml2Advice *)new_LassoSaml2Advice();
  
  *(LassoSaml2Advice **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Saml2Advice(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSaml2Advice *arg1 = (LassoSaml2Advice *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Advice **)(void *)&jarg1; 
  delete_LassoSaml2Advice(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Advice_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2Advice *arg1 = (LassoSaml2Advice *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Advice **)(void *)&jarg1; 
  result = (char *)LassoSaml2Advice_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2BaseIDAbstract_1nameQualifier_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2BaseIDAbstract *arg1 = (LassoSaml2BaseIDAbstract *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2BaseIDAbstract **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->NameQualifier) free((char*)arg1->NameQualifier);
    if (arg2) {
      arg1->NameQualifier = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->NameQualifier,arg2);
    } else {
      arg1->NameQualifier = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2BaseIDAbstract_1nameQualifier_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2BaseIDAbstract *arg1 = (LassoSaml2BaseIDAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2BaseIDAbstract **)(void *)&jarg1; 
  result = (char *) ((arg1)->NameQualifier);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2BaseIDAbstract_1SPNameQualifier_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2BaseIDAbstract *arg1 = (LassoSaml2BaseIDAbstract *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2BaseIDAbstract **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->SPNameQualifier) free((char*)arg1->SPNameQualifier);
    if (arg2) {
      arg1->SPNameQualifier = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->SPNameQualifier,arg2);
    } else {
      arg1->SPNameQualifier = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2BaseIDAbstract_1SPNameQualifier_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2BaseIDAbstract *arg1 = (LassoSaml2BaseIDAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2BaseIDAbstract **)(void *)&jarg1; 
  result = (char *) ((arg1)->SPNameQualifier);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Saml2BaseIDAbstract(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSaml2BaseIDAbstract *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSaml2BaseIDAbstract *)new_LassoSaml2BaseIDAbstract();
  
  *(LassoSaml2BaseIDAbstract **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Saml2BaseIDAbstract(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSaml2BaseIDAbstract *arg1 = (LassoSaml2BaseIDAbstract *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2BaseIDAbstract **)(void *)&jarg1; 
  delete_LassoSaml2BaseIDAbstract(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2BaseIDAbstract_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2BaseIDAbstract *arg1 = (LassoSaml2BaseIDAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2BaseIDAbstract **)(void *)&jarg1; 
  result = (char *)LassoSaml2BaseIDAbstract_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AuthnContext_1AuthnContextClassRef_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2AuthnContext *arg1 = (LassoSaml2AuthnContext *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthnContext **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->AuthnContextClassRef) free((char*)arg1->AuthnContextClassRef);
    if (arg2) {
      arg1->AuthnContextClassRef = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->AuthnContextClassRef,arg2);
    } else {
      arg1->AuthnContextClassRef = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AuthnContext_1AuthnContextClassRef_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2AuthnContext *arg1 = (LassoSaml2AuthnContext *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthnContext **)(void *)&jarg1; 
  result = (char *) ((arg1)->AuthnContextClassRef);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AuthnContext_1AuthnContextDeclRef_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2AuthnContext *arg1 = (LassoSaml2AuthnContext *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthnContext **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->AuthnContextDeclRef) free((char*)arg1->AuthnContextDeclRef);
    if (arg2) {
      arg1->AuthnContextDeclRef = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->AuthnContextDeclRef,arg2);
    } else {
      arg1->AuthnContextDeclRef = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AuthnContext_1AuthnContextDeclRef_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2AuthnContext *arg1 = (LassoSaml2AuthnContext *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthnContext **)(void *)&jarg1; 
  result = (char *) ((arg1)->AuthnContextDeclRef);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AuthnContext_1AuthenticatingAuthority_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2AuthnContext *arg1 = (LassoSaml2AuthnContext *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthnContext **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->AuthenticatingAuthority) free((char*)arg1->AuthenticatingAuthority);
    if (arg2) {
      arg1->AuthenticatingAuthority = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->AuthenticatingAuthority,arg2);
    } else {
      arg1->AuthenticatingAuthority = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AuthnContext_1AuthenticatingAuthority_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2AuthnContext *arg1 = (LassoSaml2AuthnContext *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthnContext **)(void *)&jarg1; 
  result = (char *) ((arg1)->AuthenticatingAuthority);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Saml2AuthnContext(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSaml2AuthnContext *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSaml2AuthnContext *)new_LassoSaml2AuthnContext();
  
  *(LassoSaml2AuthnContext **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Saml2AuthnContext(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSaml2AuthnContext *arg1 = (LassoSaml2AuthnContext *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthnContext **)(void *)&jarg1; 
  delete_LassoSaml2AuthnContext(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AuthnContext_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2AuthnContext *arg1 = (LassoSaml2AuthnContext *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthnContext **)(void *)&jarg1; 
  result = (char *)LassoSaml2AuthnContext_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2SubjectLocality_1Address_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2SubjectLocality *arg1 = (LassoSaml2SubjectLocality *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectLocality **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Address) free((char*)arg1->Address);
    if (arg2) {
      arg1->Address = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Address,arg2);
    } else {
      arg1->Address = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2SubjectLocality_1Address_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2SubjectLocality *arg1 = (LassoSaml2SubjectLocality *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectLocality **)(void *)&jarg1; 
  result = (char *) ((arg1)->Address);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2SubjectLocality_1DNSName_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2SubjectLocality *arg1 = (LassoSaml2SubjectLocality *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectLocality **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->DNSName) free((char*)arg1->DNSName);
    if (arg2) {
      arg1->DNSName = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->DNSName,arg2);
    } else {
      arg1->DNSName = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2SubjectLocality_1DNSName_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2SubjectLocality *arg1 = (LassoSaml2SubjectLocality *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectLocality **)(void *)&jarg1; 
  result = (char *) ((arg1)->DNSName);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Saml2SubjectLocality(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSaml2SubjectLocality *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSaml2SubjectLocality *)new_LassoSaml2SubjectLocality();
  
  *(LassoSaml2SubjectLocality **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Saml2SubjectLocality(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSaml2SubjectLocality *arg1 = (LassoSaml2SubjectLocality *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectLocality **)(void *)&jarg1; 
  delete_LassoSaml2SubjectLocality(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2SubjectLocality_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2SubjectLocality *arg1 = (LassoSaml2SubjectLocality *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectLocality **)(void *)&jarg1; 
  result = (char *)LassoSaml2SubjectLocality_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2SubjectConfirmationData_1notBefore_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2SubjectConfirmationData *arg1 = (LassoSaml2SubjectConfirmationData *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectConfirmationData **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->NotBefore) free((char*)arg1->NotBefore);
    if (arg2) {
      arg1->NotBefore = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->NotBefore,arg2);
    } else {
      arg1->NotBefore = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2SubjectConfirmationData_1notBefore_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2SubjectConfirmationData *arg1 = (LassoSaml2SubjectConfirmationData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectConfirmationData **)(void *)&jarg1; 
  result = (char *) ((arg1)->NotBefore);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2SubjectConfirmationData_1notOnOrAfter_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2SubjectConfirmationData *arg1 = (LassoSaml2SubjectConfirmationData *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectConfirmationData **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->NotOnOrAfter) free((char*)arg1->NotOnOrAfter);
    if (arg2) {
      arg1->NotOnOrAfter = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->NotOnOrAfter,arg2);
    } else {
      arg1->NotOnOrAfter = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2SubjectConfirmationData_1notOnOrAfter_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2SubjectConfirmationData *arg1 = (LassoSaml2SubjectConfirmationData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectConfirmationData **)(void *)&jarg1; 
  result = (char *) ((arg1)->NotOnOrAfter);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2SubjectConfirmationData_1recipient_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2SubjectConfirmationData *arg1 = (LassoSaml2SubjectConfirmationData *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectConfirmationData **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Recipient) free((char*)arg1->Recipient);
    if (arg2) {
      arg1->Recipient = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Recipient,arg2);
    } else {
      arg1->Recipient = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2SubjectConfirmationData_1recipient_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2SubjectConfirmationData *arg1 = (LassoSaml2SubjectConfirmationData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectConfirmationData **)(void *)&jarg1; 
  result = (char *) ((arg1)->Recipient);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2SubjectConfirmationData_1inResponseTo_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2SubjectConfirmationData *arg1 = (LassoSaml2SubjectConfirmationData *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectConfirmationData **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->InResponseTo) free((char*)arg1->InResponseTo);
    if (arg2) {
      arg1->InResponseTo = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->InResponseTo,arg2);
    } else {
      arg1->InResponseTo = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2SubjectConfirmationData_1inResponseTo_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2SubjectConfirmationData *arg1 = (LassoSaml2SubjectConfirmationData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectConfirmationData **)(void *)&jarg1; 
  result = (char *) ((arg1)->InResponseTo);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2SubjectConfirmationData_1Address_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2SubjectConfirmationData *arg1 = (LassoSaml2SubjectConfirmationData *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectConfirmationData **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Address) free((char*)arg1->Address);
    if (arg2) {
      arg1->Address = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Address,arg2);
    } else {
      arg1->Address = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2SubjectConfirmationData_1Address_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2SubjectConfirmationData *arg1 = (LassoSaml2SubjectConfirmationData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectConfirmationData **)(void *)&jarg1; 
  result = (char *) ((arg1)->Address);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Saml2SubjectConfirmationData(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSaml2SubjectConfirmationData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSaml2SubjectConfirmationData *)new_LassoSaml2SubjectConfirmationData();
  
  *(LassoSaml2SubjectConfirmationData **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Saml2SubjectConfirmationData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSaml2SubjectConfirmationData *arg1 = (LassoSaml2SubjectConfirmationData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectConfirmationData **)(void *)&jarg1; 
  delete_LassoSaml2SubjectConfirmationData(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2SubjectConfirmationData_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2SubjectConfirmationData *arg1 = (LassoSaml2SubjectConfirmationData *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectConfirmationData **)(void *)&jarg1; 
  result = (char *)LassoSaml2SubjectConfirmationData_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2SubjectConfirmation_1Method_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2SubjectConfirmation *arg1 = (LassoSaml2SubjectConfirmation *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectConfirmation **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Method) free((char*)arg1->Method);
    if (arg2) {
      arg1->Method = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Method,arg2);
    } else {
      arg1->Method = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2SubjectConfirmation_1Method_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2SubjectConfirmation *arg1 = (LassoSaml2SubjectConfirmation *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectConfirmation **)(void *)&jarg1; 
  result = (char *) ((arg1)->Method);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2SubjectConfirmation_1baseID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSaml2SubjectConfirmation *arg1 = (LassoSaml2SubjectConfirmation *) 0 ;
  LassoSaml2BaseIDAbstract *arg2 = (LassoSaml2BaseIDAbstract *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectConfirmation **)(void *)&jarg1; 
  arg2 = *(LassoSaml2BaseIDAbstract **)(void *)&jarg2; 
  LassoSaml2SubjectConfirmation_BaseID_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2SubjectConfirmation_1baseID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSaml2SubjectConfirmation *arg1 = (LassoSaml2SubjectConfirmation *) 0 ;
  LassoSaml2BaseIDAbstract *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectConfirmation **)(void *)&jarg1; 
  result = (LassoSaml2BaseIDAbstract *)LassoSaml2SubjectConfirmation_BaseID_get(arg1);
  
  *(LassoSaml2BaseIDAbstract **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2SubjectConfirmation_1nameID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSaml2SubjectConfirmation *arg1 = (LassoSaml2SubjectConfirmation *) 0 ;
  LassoSaml2NameID *arg2 = (LassoSaml2NameID *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectConfirmation **)(void *)&jarg1; 
  arg2 = *(LassoSaml2NameID **)(void *)&jarg2; 
  LassoSaml2SubjectConfirmation_NameID_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2SubjectConfirmation_1nameID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSaml2SubjectConfirmation *arg1 = (LassoSaml2SubjectConfirmation *) 0 ;
  LassoSaml2NameID *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectConfirmation **)(void *)&jarg1; 
  result = (LassoSaml2NameID *)LassoSaml2SubjectConfirmation_NameID_get(arg1);
  
  *(LassoSaml2NameID **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2SubjectConfirmation_1encryptedID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSaml2SubjectConfirmation *arg1 = (LassoSaml2SubjectConfirmation *) 0 ;
  LassoSaml2EncryptedElement *arg2 = (LassoSaml2EncryptedElement *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectConfirmation **)(void *)&jarg1; 
  arg2 = *(LassoSaml2EncryptedElement **)(void *)&jarg2; 
  LassoSaml2SubjectConfirmation_EncryptedID_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2SubjectConfirmation_1encryptedID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSaml2SubjectConfirmation *arg1 = (LassoSaml2SubjectConfirmation *) 0 ;
  LassoSaml2EncryptedElement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectConfirmation **)(void *)&jarg1; 
  result = (LassoSaml2EncryptedElement *)LassoSaml2SubjectConfirmation_EncryptedID_get(arg1);
  
  *(LassoSaml2EncryptedElement **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2SubjectConfirmation_1subjectConfirmationData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSaml2SubjectConfirmation *arg1 = (LassoSaml2SubjectConfirmation *) 0 ;
  LassoSaml2SubjectConfirmationData *arg2 = (LassoSaml2SubjectConfirmationData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectConfirmation **)(void *)&jarg1; 
  arg2 = *(LassoSaml2SubjectConfirmationData **)(void *)&jarg2; 
  LassoSaml2SubjectConfirmation_SubjectConfirmationData_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2SubjectConfirmation_1subjectConfirmationData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSaml2SubjectConfirmation *arg1 = (LassoSaml2SubjectConfirmation *) 0 ;
  LassoSaml2SubjectConfirmationData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectConfirmation **)(void *)&jarg1; 
  result = (LassoSaml2SubjectConfirmationData *)LassoSaml2SubjectConfirmation_SubjectConfirmationData_get(arg1);
  
  *(LassoSaml2SubjectConfirmationData **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Saml2SubjectConfirmation(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSaml2SubjectConfirmation *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSaml2SubjectConfirmation *)new_LassoSaml2SubjectConfirmation();
  
  *(LassoSaml2SubjectConfirmation **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Saml2SubjectConfirmation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSaml2SubjectConfirmation *arg1 = (LassoSaml2SubjectConfirmation *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectConfirmation **)(void *)&jarg1; 
  delete_LassoSaml2SubjectConfirmation(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2SubjectConfirmation_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2SubjectConfirmation *arg1 = (LassoSaml2SubjectConfirmation *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2SubjectConfirmation **)(void *)&jarg1; 
  result = (char *)LassoSaml2SubjectConfirmation_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2ProxyRestriction_1Audience_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2ProxyRestriction *arg1 = (LassoSaml2ProxyRestriction *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2ProxyRestriction **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Audience) free((char*)arg1->Audience);
    if (arg2) {
      arg1->Audience = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Audience,arg2);
    } else {
      arg1->Audience = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2ProxyRestriction_1Audience_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2ProxyRestriction *arg1 = (LassoSaml2ProxyRestriction *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2ProxyRestriction **)(void *)&jarg1; 
  result = (char *) ((arg1)->Audience);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2ProxyRestriction_1Count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2ProxyRestriction *arg1 = (LassoSaml2ProxyRestriction *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2ProxyRestriction **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Count) free((char*)arg1->Count);
    if (arg2) {
      arg1->Count = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Count,arg2);
    } else {
      arg1->Count = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2ProxyRestriction_1Count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2ProxyRestriction *arg1 = (LassoSaml2ProxyRestriction *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2ProxyRestriction **)(void *)&jarg1; 
  result = (char *) ((arg1)->Count);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Saml2ProxyRestriction(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSaml2ProxyRestriction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSaml2ProxyRestriction *)new_LassoSaml2ProxyRestriction();
  
  *(LassoSaml2ProxyRestriction **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Saml2ProxyRestriction(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSaml2ProxyRestriction *arg1 = (LassoSaml2ProxyRestriction *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2ProxyRestriction **)(void *)&jarg1; 
  delete_LassoSaml2ProxyRestriction(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2ProxyRestriction_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2ProxyRestriction *arg1 = (LassoSaml2ProxyRestriction *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2ProxyRestriction **)(void *)&jarg1; 
  result = (char *)LassoSaml2ProxyRestriction_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Saml2StatementAbstract(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSaml2StatementAbstract *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSaml2StatementAbstract *)new_LassoSaml2StatementAbstract();
  
  *(LassoSaml2StatementAbstract **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Saml2StatementAbstract(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSaml2StatementAbstract *arg1 = (LassoSaml2StatementAbstract *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2StatementAbstract **)(void *)&jarg1; 
  delete_LassoSaml2StatementAbstract(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2StatementAbstract_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2StatementAbstract *arg1 = (LassoSaml2StatementAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2StatementAbstract **)(void *)&jarg1; 
  result = (char *)LassoSaml2StatementAbstract_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AuthnStatement_1AuthnInstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2AuthnStatement *arg1 = (LassoSaml2AuthnStatement *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthnStatement **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->AuthnInstant) free((char*)arg1->AuthnInstant);
    if (arg2) {
      arg1->AuthnInstant = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->AuthnInstant,arg2);
    } else {
      arg1->AuthnInstant = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AuthnStatement_1AuthnInstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2AuthnStatement *arg1 = (LassoSaml2AuthnStatement *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthnStatement **)(void *)&jarg1; 
  result = (char *) ((arg1)->AuthnInstant);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AuthnStatement_1sessionIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2AuthnStatement *arg1 = (LassoSaml2AuthnStatement *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthnStatement **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->SessionIndex) free((char*)arg1->SessionIndex);
    if (arg2) {
      arg1->SessionIndex = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->SessionIndex,arg2);
    } else {
      arg1->SessionIndex = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AuthnStatement_1sessionIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2AuthnStatement *arg1 = (LassoSaml2AuthnStatement *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthnStatement **)(void *)&jarg1; 
  result = (char *) ((arg1)->SessionIndex);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AuthnStatement_1SessionNotOnOrAfter_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2AuthnStatement *arg1 = (LassoSaml2AuthnStatement *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthnStatement **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->SessionNotOnOrAfter) free((char*)arg1->SessionNotOnOrAfter);
    if (arg2) {
      arg1->SessionNotOnOrAfter = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->SessionNotOnOrAfter,arg2);
    } else {
      arg1->SessionNotOnOrAfter = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AuthnStatement_1SessionNotOnOrAfter_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2AuthnStatement *arg1 = (LassoSaml2AuthnStatement *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthnStatement **)(void *)&jarg1; 
  result = (char *) ((arg1)->SessionNotOnOrAfter);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AuthnStatement_1subjectLocality_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSaml2AuthnStatement *arg1 = (LassoSaml2AuthnStatement *) 0 ;
  LassoSaml2SubjectLocality *arg2 = (LassoSaml2SubjectLocality *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthnStatement **)(void *)&jarg1; 
  arg2 = *(LassoSaml2SubjectLocality **)(void *)&jarg2; 
  LassoSaml2AuthnStatement_SubjectLocality_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AuthnStatement_1subjectLocality_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSaml2AuthnStatement *arg1 = (LassoSaml2AuthnStatement *) 0 ;
  LassoSaml2SubjectLocality *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthnStatement **)(void *)&jarg1; 
  result = (LassoSaml2SubjectLocality *)LassoSaml2AuthnStatement_SubjectLocality_get(arg1);
  
  *(LassoSaml2SubjectLocality **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AuthnStatement_1authnContext_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSaml2AuthnStatement *arg1 = (LassoSaml2AuthnStatement *) 0 ;
  LassoSaml2AuthnContext *arg2 = (LassoSaml2AuthnContext *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthnStatement **)(void *)&jarg1; 
  arg2 = *(LassoSaml2AuthnContext **)(void *)&jarg2; 
  LassoSaml2AuthnStatement_AuthnContext_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AuthnStatement_1authnContext_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSaml2AuthnStatement *arg1 = (LassoSaml2AuthnStatement *) 0 ;
  LassoSaml2AuthnContext *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthnStatement **)(void *)&jarg1; 
  result = (LassoSaml2AuthnContext *)LassoSaml2AuthnStatement_AuthnContext_get(arg1);
  
  *(LassoSaml2AuthnContext **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Saml2AuthnStatement(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSaml2AuthnStatement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSaml2AuthnStatement *)new_LassoSaml2AuthnStatement();
  
  *(LassoSaml2AuthnStatement **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Saml2AuthnStatement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSaml2AuthnStatement *arg1 = (LassoSaml2AuthnStatement *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthnStatement **)(void *)&jarg1; 
  delete_LassoSaml2AuthnStatement(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AuthnStatement_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2AuthnStatement *arg1 = (LassoSaml2AuthnStatement *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthnStatement **)(void *)&jarg1; 
  result = (char *)LassoSaml2AuthnStatement_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Saml2AttributeStatement(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSaml2AttributeStatement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSaml2AttributeStatement *)new_LassoSaml2AttributeStatement();
  
  *(LassoSaml2AttributeStatement **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Saml2AttributeStatement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSaml2AttributeStatement *arg1 = (LassoSaml2AttributeStatement *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AttributeStatement **)(void *)&jarg1; 
  delete_LassoSaml2AttributeStatement(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AttributeStatement_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2AttributeStatement *arg1 = (LassoSaml2AttributeStatement *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AttributeStatement **)(void *)&jarg1; 
  result = (char *)LassoSaml2AttributeStatement_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2IDPEntry_1providerId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2IDPEntry *arg1 = (LassoSamlp2IDPEntry *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2IDPEntry **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->ProviderID) free((char*)arg1->ProviderID);
    if (arg2) {
      arg1->ProviderID = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->ProviderID,arg2);
    } else {
      arg1->ProviderID = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2IDPEntry_1providerId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2IDPEntry *arg1 = (LassoSamlp2IDPEntry *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2IDPEntry **)(void *)&jarg1; 
  result = (char *) ((arg1)->ProviderID);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2IDPEntry_1Name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2IDPEntry *arg1 = (LassoSamlp2IDPEntry *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2IDPEntry **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Name) free((char*)arg1->Name);
    if (arg2) {
      arg1->Name = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Name,arg2);
    } else {
      arg1->Name = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2IDPEntry_1Name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2IDPEntry *arg1 = (LassoSamlp2IDPEntry *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2IDPEntry **)(void *)&jarg1; 
  result = (char *) ((arg1)->Name);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2IDPEntry_1Loc_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2IDPEntry *arg1 = (LassoSamlp2IDPEntry *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2IDPEntry **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Loc) free((char*)arg1->Loc);
    if (arg2) {
      arg1->Loc = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Loc,arg2);
    } else {
      arg1->Loc = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2IDPEntry_1Loc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2IDPEntry *arg1 = (LassoSamlp2IDPEntry *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2IDPEntry **)(void *)&jarg1; 
  result = (char *) ((arg1)->Loc);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Samlp2IDPEntry(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlp2IDPEntry *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlp2IDPEntry *)new_LassoSamlp2IDPEntry();
  
  *(LassoSamlp2IDPEntry **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Samlp2IDPEntry(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlp2IDPEntry *arg1 = (LassoSamlp2IDPEntry *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2IDPEntry **)(void *)&jarg1; 
  delete_LassoSamlp2IDPEntry(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2IDPEntry_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2IDPEntry *arg1 = (LassoSamlp2IDPEntry *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2IDPEntry **)(void *)&jarg1; 
  result = (char *)LassoSamlp2IDPEntry_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Samlp2Extensions(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlp2Extensions *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlp2Extensions *)new_LassoSamlp2Extensions();
  
  *(LassoSamlp2Extensions **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Samlp2Extensions(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlp2Extensions *arg1 = (LassoSamlp2Extensions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Extensions **)(void *)&jarg1; 
  delete_LassoSamlp2Extensions(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Extensions_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2Extensions *arg1 = (LassoSamlp2Extensions *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Extensions **)(void *)&jarg1; 
  result = (char *)LassoSamlp2Extensions_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Action_1content_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2Action *arg1 = (LassoSaml2Action *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Action **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->content) free((char*)arg1->content);
    if (arg2) {
      arg1->content = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->content,arg2);
    } else {
      arg1->content = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Action_1content_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2Action *arg1 = (LassoSaml2Action *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Action **)(void *)&jarg1; 
  result = (char *) ((arg1)->content);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Action_1Namespace_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2Action *arg1 = (LassoSaml2Action *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Action **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Namespace) free((char*)arg1->Namespace);
    if (arg2) {
      arg1->Namespace = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Namespace,arg2);
    } else {
      arg1->Namespace = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Action_1Namespace_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2Action *arg1 = (LassoSaml2Action *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Action **)(void *)&jarg1; 
  result = (char *) ((arg1)->Namespace);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Saml2Action(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSaml2Action *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSaml2Action *)new_LassoSaml2Action();
  
  *(LassoSaml2Action **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Saml2Action(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSaml2Action *arg1 = (LassoSaml2Action *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Action **)(void *)&jarg1; 
  delete_LassoSaml2Action(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Action_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2Action *arg1 = (LassoSaml2Action *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Action **)(void *)&jarg1; 
  result = (char *)LassoSaml2Action_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2StatusResponse_1ID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2StatusResponse *arg1 = (LassoSamlp2StatusResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->ID) free((char*)arg1->ID);
    if (arg2) {
      arg1->ID = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->ID,arg2);
    } else {
      arg1->ID = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2StatusResponse_1ID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2StatusResponse *arg1 = (LassoSamlp2StatusResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusResponse **)(void *)&jarg1; 
  result = (char *) ((arg1)->ID);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2StatusResponse_1inResponseTo_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2StatusResponse *arg1 = (LassoSamlp2StatusResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->InResponseTo) free((char*)arg1->InResponseTo);
    if (arg2) {
      arg1->InResponseTo = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->InResponseTo,arg2);
    } else {
      arg1->InResponseTo = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2StatusResponse_1inResponseTo_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2StatusResponse *arg1 = (LassoSamlp2StatusResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusResponse **)(void *)&jarg1; 
  result = (char *) ((arg1)->InResponseTo);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2StatusResponse_1Version_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2StatusResponse *arg1 = (LassoSamlp2StatusResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Version) free((char*)arg1->Version);
    if (arg2) {
      arg1->Version = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Version,arg2);
    } else {
      arg1->Version = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2StatusResponse_1Version_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2StatusResponse *arg1 = (LassoSamlp2StatusResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusResponse **)(void *)&jarg1; 
  result = (char *) ((arg1)->Version);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2StatusResponse_1issueInstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2StatusResponse *arg1 = (LassoSamlp2StatusResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->IssueInstant) free((char*)arg1->IssueInstant);
    if (arg2) {
      arg1->IssueInstant = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->IssueInstant,arg2);
    } else {
      arg1->IssueInstant = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2StatusResponse_1issueInstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2StatusResponse *arg1 = (LassoSamlp2StatusResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusResponse **)(void *)&jarg1; 
  result = (char *) ((arg1)->IssueInstant);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2StatusResponse_1Destination_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2StatusResponse *arg1 = (LassoSamlp2StatusResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Destination) free((char*)arg1->Destination);
    if (arg2) {
      arg1->Destination = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Destination,arg2);
    } else {
      arg1->Destination = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2StatusResponse_1Destination_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2StatusResponse *arg1 = (LassoSamlp2StatusResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusResponse **)(void *)&jarg1; 
  result = (char *) ((arg1)->Destination);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2StatusResponse_1Consent_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2StatusResponse *arg1 = (LassoSamlp2StatusResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Consent) free((char*)arg1->Consent);
    if (arg2) {
      arg1->Consent = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Consent,arg2);
    } else {
      arg1->Consent = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2StatusResponse_1Consent_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2StatusResponse *arg1 = (LassoSamlp2StatusResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusResponse **)(void *)&jarg1; 
  result = (char *) ((arg1)->Consent);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2StatusResponse_1issuer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2StatusResponse *arg1 = (LassoSamlp2StatusResponse *) 0 ;
  LassoSaml2NameID *arg2 = (LassoSaml2NameID *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusResponse **)(void *)&jarg1; 
  arg2 = *(LassoSaml2NameID **)(void *)&jarg2; 
  LassoSamlp2StatusResponse_Issuer_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2StatusResponse_1issuer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2StatusResponse *arg1 = (LassoSamlp2StatusResponse *) 0 ;
  LassoSaml2NameID *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusResponse **)(void *)&jarg1; 
  result = (LassoSaml2NameID *)LassoSamlp2StatusResponse_Issuer_get(arg1);
  
  *(LassoSaml2NameID **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2StatusResponse_1extensions_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2StatusResponse *arg1 = (LassoSamlp2StatusResponse *) 0 ;
  LassoSamlp2Extensions *arg2 = (LassoSamlp2Extensions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusResponse **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2Extensions **)(void *)&jarg2; 
  LassoSamlp2StatusResponse_Extensions_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2StatusResponse_1extensions_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2StatusResponse *arg1 = (LassoSamlp2StatusResponse *) 0 ;
  LassoSamlp2Extensions *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusResponse **)(void *)&jarg1; 
  result = (LassoSamlp2Extensions *)LassoSamlp2StatusResponse_Extensions_get(arg1);
  
  *(LassoSamlp2Extensions **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2StatusResponse_1status_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2StatusResponse *arg1 = (LassoSamlp2StatusResponse *) 0 ;
  LassoSamlp2Status *arg2 = (LassoSamlp2Status *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusResponse **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2Status **)(void *)&jarg2; 
  LassoSamlp2StatusResponse_Status_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2StatusResponse_1status_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2StatusResponse *arg1 = (LassoSamlp2StatusResponse *) 0 ;
  LassoSamlp2Status *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusResponse **)(void *)&jarg1; 
  result = (LassoSamlp2Status *)LassoSamlp2StatusResponse_Status_get(arg1);
  
  *(LassoSamlp2Status **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Samlp2StatusResponse(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlp2StatusResponse *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlp2StatusResponse *)new_LassoSamlp2StatusResponse();
  
  *(LassoSamlp2StatusResponse **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Samlp2StatusResponse(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlp2StatusResponse *arg1 = (LassoSamlp2StatusResponse *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusResponse **)(void *)&jarg1; 
  delete_LassoSamlp2StatusResponse(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2StatusResponse_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2StatusResponse *arg1 = (LassoSamlp2StatusResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusResponse **)(void *)&jarg1; 
  result = (char *)LassoSamlp2StatusResponse_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Response_1issuer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2Response *arg1 = (LassoSamlp2Response *) 0 ;
  LassoSaml2NameID *arg2 = (LassoSaml2NameID *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Response **)(void *)&jarg1; 
  arg2 = *(LassoSaml2NameID **)(void *)&jarg2; 
  LassoSamlp2Response_Issuer_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Response_1issuer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2Response *arg1 = (LassoSamlp2Response *) 0 ;
  LassoSaml2NameID *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Response **)(void *)&jarg1; 
  result = (LassoSaml2NameID *)LassoSamlp2Response_Issuer_get(arg1);
  
  *(LassoSaml2NameID **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Response_1Extensions_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2Response *arg1 = (LassoSamlp2Response *) 0 ;
  LassoSamlp2Extensions *arg2 = (LassoSamlp2Extensions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Response **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2Extensions **)(void *)&jarg2; 
  LassoSamlp2Response_Extensions_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Response_1Extensions_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2Response *arg1 = (LassoSamlp2Response *) 0 ;
  LassoSamlp2Extensions *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Response **)(void *)&jarg1; 
  result = (LassoSamlp2Extensions *)LassoSamlp2Response_Extensions_get(arg1);
  
  *(LassoSamlp2Extensions **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Response_1Status_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2Response *arg1 = (LassoSamlp2Response *) 0 ;
  LassoSamlp2Status *arg2 = (LassoSamlp2Status *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Response **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2Status **)(void *)&jarg2; 
  LassoSamlp2Response_Status_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Response_1Status_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2Response *arg1 = (LassoSamlp2Response *) 0 ;
  LassoSamlp2Status *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Response **)(void *)&jarg1; 
  result = (LassoSamlp2Status *)LassoSamlp2Response_Status_get(arg1);
  
  *(LassoSamlp2Status **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Response_1ID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2Response *arg1 = (LassoSamlp2Response *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Response **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2Response_ID_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Response_1ID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2Response *arg1 = (LassoSamlp2Response *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Response **)(void *)&jarg1; 
  result = (char *)LassoSamlp2Response_ID_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Response_1inResponseTo_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2Response *arg1 = (LassoSamlp2Response *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Response **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2Response_InResponseTo_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Response_1inResponseTo_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2Response *arg1 = (LassoSamlp2Response *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Response **)(void *)&jarg1; 
  result = (char *)LassoSamlp2Response_InResponseTo_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Response_1Version_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2Response *arg1 = (LassoSamlp2Response *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Response **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2Response_Version_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Response_1Version_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2Response *arg1 = (LassoSamlp2Response *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Response **)(void *)&jarg1; 
  result = (char *)LassoSamlp2Response_Version_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Response_1issueInstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2Response *arg1 = (LassoSamlp2Response *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Response **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2Response_IssueInstant_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Response_1issueInstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2Response *arg1 = (LassoSamlp2Response *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Response **)(void *)&jarg1; 
  result = (char *)LassoSamlp2Response_IssueInstant_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Response_1Destination_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2Response *arg1 = (LassoSamlp2Response *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Response **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2Response_Destination_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Response_1Destination_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2Response *arg1 = (LassoSamlp2Response *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Response **)(void *)&jarg1; 
  result = (char *)LassoSamlp2Response_Destination_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Response_1Consent_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2Response *arg1 = (LassoSamlp2Response *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Response **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2Response_Consent_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Response_1Consent_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2Response *arg1 = (LassoSamlp2Response *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Response **)(void *)&jarg1; 
  result = (char *)LassoSamlp2Response_Consent_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Samlp2Response(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlp2Response *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlp2Response *)new_LassoSamlp2Response();
  
  *(LassoSamlp2Response **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Samlp2Response(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlp2Response *arg1 = (LassoSamlp2Response *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Response **)(void *)&jarg1; 
  delete_LassoSamlp2Response(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Response_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2Response *arg1 = (LassoSamlp2Response *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Response **)(void *)&jarg1; 
  result = (char *)LassoSamlp2Response_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResponse_1any_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2ArtifactResponse *arg1 = (LassoSamlp2ArtifactResponse *) 0 ;
  LassoNode *arg2 = (LassoNode *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResponse **)(void *)&jarg1; 
  arg2 = *(LassoNode **)(void *)&jarg2; 
  LassoSamlp2ArtifactResponse_any_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResponse_1any_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2ArtifactResponse *arg1 = (LassoSamlp2ArtifactResponse *) 0 ;
  LassoNode *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResponse **)(void *)&jarg1; 
  result = (LassoNode *)LassoSamlp2ArtifactResponse_any_get(arg1);
  
  *(LassoNode **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResponse_1issuer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2ArtifactResponse *arg1 = (LassoSamlp2ArtifactResponse *) 0 ;
  LassoSaml2NameID *arg2 = (LassoSaml2NameID *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResponse **)(void *)&jarg1; 
  arg2 = *(LassoSaml2NameID **)(void *)&jarg2; 
  LassoSamlp2ArtifactResponse_Issuer_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResponse_1issuer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2ArtifactResponse *arg1 = (LassoSamlp2ArtifactResponse *) 0 ;
  LassoSaml2NameID *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResponse **)(void *)&jarg1; 
  result = (LassoSaml2NameID *)LassoSamlp2ArtifactResponse_Issuer_get(arg1);
  
  *(LassoSaml2NameID **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResponse_1Extensions_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2ArtifactResponse *arg1 = (LassoSamlp2ArtifactResponse *) 0 ;
  LassoSamlp2Extensions *arg2 = (LassoSamlp2Extensions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResponse **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2Extensions **)(void *)&jarg2; 
  LassoSamlp2ArtifactResponse_Extensions_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResponse_1Extensions_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2ArtifactResponse *arg1 = (LassoSamlp2ArtifactResponse *) 0 ;
  LassoSamlp2Extensions *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResponse **)(void *)&jarg1; 
  result = (LassoSamlp2Extensions *)LassoSamlp2ArtifactResponse_Extensions_get(arg1);
  
  *(LassoSamlp2Extensions **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResponse_1Status_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2ArtifactResponse *arg1 = (LassoSamlp2ArtifactResponse *) 0 ;
  LassoSamlp2Status *arg2 = (LassoSamlp2Status *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResponse **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2Status **)(void *)&jarg2; 
  LassoSamlp2ArtifactResponse_Status_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResponse_1Status_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2ArtifactResponse *arg1 = (LassoSamlp2ArtifactResponse *) 0 ;
  LassoSamlp2Status *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResponse **)(void *)&jarg1; 
  result = (LassoSamlp2Status *)LassoSamlp2ArtifactResponse_Status_get(arg1);
  
  *(LassoSamlp2Status **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResponse_1ID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2ArtifactResponse *arg1 = (LassoSamlp2ArtifactResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2ArtifactResponse_ID_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResponse_1ID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2ArtifactResponse *arg1 = (LassoSamlp2ArtifactResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResponse **)(void *)&jarg1; 
  result = (char *)LassoSamlp2ArtifactResponse_ID_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResponse_1inResponseTo_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2ArtifactResponse *arg1 = (LassoSamlp2ArtifactResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2ArtifactResponse_InResponseTo_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResponse_1inResponseTo_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2ArtifactResponse *arg1 = (LassoSamlp2ArtifactResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResponse **)(void *)&jarg1; 
  result = (char *)LassoSamlp2ArtifactResponse_InResponseTo_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResponse_1Version_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2ArtifactResponse *arg1 = (LassoSamlp2ArtifactResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2ArtifactResponse_Version_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResponse_1Version_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2ArtifactResponse *arg1 = (LassoSamlp2ArtifactResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResponse **)(void *)&jarg1; 
  result = (char *)LassoSamlp2ArtifactResponse_Version_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResponse_1issueInstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2ArtifactResponse *arg1 = (LassoSamlp2ArtifactResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2ArtifactResponse_IssueInstant_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResponse_1issueInstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2ArtifactResponse *arg1 = (LassoSamlp2ArtifactResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResponse **)(void *)&jarg1; 
  result = (char *)LassoSamlp2ArtifactResponse_IssueInstant_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResponse_1Destination_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2ArtifactResponse *arg1 = (LassoSamlp2ArtifactResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2ArtifactResponse_Destination_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResponse_1Destination_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2ArtifactResponse *arg1 = (LassoSamlp2ArtifactResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResponse **)(void *)&jarg1; 
  result = (char *)LassoSamlp2ArtifactResponse_Destination_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResponse_1Consent_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2ArtifactResponse *arg1 = (LassoSamlp2ArtifactResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2ArtifactResponse_Consent_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResponse_1Consent_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2ArtifactResponse *arg1 = (LassoSamlp2ArtifactResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResponse **)(void *)&jarg1; 
  result = (char *)LassoSamlp2ArtifactResponse_Consent_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Samlp2ArtifactResponse(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlp2ArtifactResponse *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlp2ArtifactResponse *)new_LassoSamlp2ArtifactResponse();
  
  *(LassoSamlp2ArtifactResponse **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Samlp2ArtifactResponse(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlp2ArtifactResponse *arg1 = (LassoSamlp2ArtifactResponse *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResponse **)(void *)&jarg1; 
  delete_LassoSamlp2ArtifactResponse(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResponse_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2ArtifactResponse *arg1 = (LassoSamlp2ArtifactResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResponse **)(void *)&jarg1; 
  result = (char *)LassoSamlp2ArtifactResponse_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2RequestAbstract_1ID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2RequestAbstract *arg1 = (LassoSamlp2RequestAbstract *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2RequestAbstract **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->ID) free((char*)arg1->ID);
    if (arg2) {
      arg1->ID = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->ID,arg2);
    } else {
      arg1->ID = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2RequestAbstract_1ID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2RequestAbstract *arg1 = (LassoSamlp2RequestAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2RequestAbstract **)(void *)&jarg1; 
  result = (char *) ((arg1)->ID);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2RequestAbstract_1Version_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2RequestAbstract *arg1 = (LassoSamlp2RequestAbstract *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2RequestAbstract **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Version) free((char*)arg1->Version);
    if (arg2) {
      arg1->Version = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Version,arg2);
    } else {
      arg1->Version = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2RequestAbstract_1Version_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2RequestAbstract *arg1 = (LassoSamlp2RequestAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2RequestAbstract **)(void *)&jarg1; 
  result = (char *) ((arg1)->Version);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2RequestAbstract_1issueInstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2RequestAbstract *arg1 = (LassoSamlp2RequestAbstract *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2RequestAbstract **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->IssueInstant) free((char*)arg1->IssueInstant);
    if (arg2) {
      arg1->IssueInstant = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->IssueInstant,arg2);
    } else {
      arg1->IssueInstant = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2RequestAbstract_1issueInstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2RequestAbstract *arg1 = (LassoSamlp2RequestAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2RequestAbstract **)(void *)&jarg1; 
  result = (char *) ((arg1)->IssueInstant);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2RequestAbstract_1Destination_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2RequestAbstract *arg1 = (LassoSamlp2RequestAbstract *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2RequestAbstract **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Destination) free((char*)arg1->Destination);
    if (arg2) {
      arg1->Destination = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Destination,arg2);
    } else {
      arg1->Destination = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2RequestAbstract_1Destination_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2RequestAbstract *arg1 = (LassoSamlp2RequestAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2RequestAbstract **)(void *)&jarg1; 
  result = (char *) ((arg1)->Destination);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2RequestAbstract_1Consent_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2RequestAbstract *arg1 = (LassoSamlp2RequestAbstract *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2RequestAbstract **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Consent) free((char*)arg1->Consent);
    if (arg2) {
      arg1->Consent = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Consent,arg2);
    } else {
      arg1->Consent = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2RequestAbstract_1Consent_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2RequestAbstract *arg1 = (LassoSamlp2RequestAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2RequestAbstract **)(void *)&jarg1; 
  result = (char *) ((arg1)->Consent);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2RequestAbstract_1issuer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2RequestAbstract *arg1 = (LassoSamlp2RequestAbstract *) 0 ;
  LassoSaml2NameID *arg2 = (LassoSaml2NameID *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2RequestAbstract **)(void *)&jarg1; 
  arg2 = *(LassoSaml2NameID **)(void *)&jarg2; 
  LassoSamlp2RequestAbstract_Issuer_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2RequestAbstract_1issuer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2RequestAbstract *arg1 = (LassoSamlp2RequestAbstract *) 0 ;
  LassoSaml2NameID *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2RequestAbstract **)(void *)&jarg1; 
  result = (LassoSaml2NameID *)LassoSamlp2RequestAbstract_Issuer_get(arg1);
  
  *(LassoSaml2NameID **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2RequestAbstract_1extensions_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2RequestAbstract *arg1 = (LassoSamlp2RequestAbstract *) 0 ;
  LassoSamlp2Extensions *arg2 = (LassoSamlp2Extensions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2RequestAbstract **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2Extensions **)(void *)&jarg2; 
  LassoSamlp2RequestAbstract_Extensions_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2RequestAbstract_1extensions_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2RequestAbstract *arg1 = (LassoSamlp2RequestAbstract *) 0 ;
  LassoSamlp2Extensions *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2RequestAbstract **)(void *)&jarg1; 
  result = (LassoSamlp2Extensions *)LassoSamlp2RequestAbstract_Extensions_get(arg1);
  
  *(LassoSamlp2Extensions **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Samlp2RequestAbstract(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlp2RequestAbstract *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlp2RequestAbstract *)new_LassoSamlp2RequestAbstract();
  
  *(LassoSamlp2RequestAbstract **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Samlp2RequestAbstract(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlp2RequestAbstract *arg1 = (LassoSamlp2RequestAbstract *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2RequestAbstract **)(void *)&jarg1; 
  delete_LassoSamlp2RequestAbstract(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2RequestAbstract_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2RequestAbstract *arg1 = (LassoSamlp2RequestAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2RequestAbstract **)(void *)&jarg1; 
  result = (char *)LassoSamlp2RequestAbstract_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AssertionIDRequest_1AssertionIDRef_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AssertionIDRequest *arg1 = (LassoSamlp2AssertionIDRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AssertionIDRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->AssertionIDRef) free((char*)arg1->AssertionIDRef);
    if (arg2) {
      arg1->AssertionIDRef = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->AssertionIDRef,arg2);
    } else {
      arg1->AssertionIDRef = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AssertionIDRequest_1AssertionIDRef_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AssertionIDRequest *arg1 = (LassoSamlp2AssertionIDRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AssertionIDRequest **)(void *)&jarg1; 
  result = (char *) ((arg1)->AssertionIDRef);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AssertionIDRequest_1issuer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2AssertionIDRequest *arg1 = (LassoSamlp2AssertionIDRequest *) 0 ;
  LassoSaml2NameID *arg2 = (LassoSaml2NameID *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AssertionIDRequest **)(void *)&jarg1; 
  arg2 = *(LassoSaml2NameID **)(void *)&jarg2; 
  LassoSamlp2AssertionIDRequest_Issuer_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AssertionIDRequest_1issuer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2AssertionIDRequest *arg1 = (LassoSamlp2AssertionIDRequest *) 0 ;
  LassoSaml2NameID *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AssertionIDRequest **)(void *)&jarg1; 
  result = (LassoSaml2NameID *)LassoSamlp2AssertionIDRequest_Issuer_get(arg1);
  
  *(LassoSaml2NameID **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AssertionIDRequest_1Extensions_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2AssertionIDRequest *arg1 = (LassoSamlp2AssertionIDRequest *) 0 ;
  LassoSamlp2Extensions *arg2 = (LassoSamlp2Extensions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AssertionIDRequest **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2Extensions **)(void *)&jarg2; 
  LassoSamlp2AssertionIDRequest_Extensions_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AssertionIDRequest_1Extensions_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2AssertionIDRequest *arg1 = (LassoSamlp2AssertionIDRequest *) 0 ;
  LassoSamlp2Extensions *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AssertionIDRequest **)(void *)&jarg1; 
  result = (LassoSamlp2Extensions *)LassoSamlp2AssertionIDRequest_Extensions_get(arg1);
  
  *(LassoSamlp2Extensions **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AssertionIDRequest_1ID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AssertionIDRequest *arg1 = (LassoSamlp2AssertionIDRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AssertionIDRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2AssertionIDRequest_ID_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AssertionIDRequest_1ID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AssertionIDRequest *arg1 = (LassoSamlp2AssertionIDRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AssertionIDRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AssertionIDRequest_ID_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AssertionIDRequest_1Version_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AssertionIDRequest *arg1 = (LassoSamlp2AssertionIDRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AssertionIDRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2AssertionIDRequest_Version_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AssertionIDRequest_1Version_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AssertionIDRequest *arg1 = (LassoSamlp2AssertionIDRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AssertionIDRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AssertionIDRequest_Version_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AssertionIDRequest_1issueInstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AssertionIDRequest *arg1 = (LassoSamlp2AssertionIDRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AssertionIDRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2AssertionIDRequest_IssueInstant_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AssertionIDRequest_1issueInstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AssertionIDRequest *arg1 = (LassoSamlp2AssertionIDRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AssertionIDRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AssertionIDRequest_IssueInstant_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AssertionIDRequest_1Destination_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AssertionIDRequest *arg1 = (LassoSamlp2AssertionIDRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AssertionIDRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2AssertionIDRequest_Destination_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AssertionIDRequest_1Destination_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AssertionIDRequest *arg1 = (LassoSamlp2AssertionIDRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AssertionIDRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AssertionIDRequest_Destination_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AssertionIDRequest_1Consent_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AssertionIDRequest *arg1 = (LassoSamlp2AssertionIDRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AssertionIDRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2AssertionIDRequest_Consent_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AssertionIDRequest_1Consent_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AssertionIDRequest *arg1 = (LassoSamlp2AssertionIDRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AssertionIDRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AssertionIDRequest_Consent_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Samlp2AssertionIDRequest(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlp2AssertionIDRequest *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlp2AssertionIDRequest *)new_LassoSamlp2AssertionIDRequest();
  
  *(LassoSamlp2AssertionIDRequest **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Samlp2AssertionIDRequest(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlp2AssertionIDRequest *arg1 = (LassoSamlp2AssertionIDRequest *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AssertionIDRequest **)(void *)&jarg1; 
  delete_LassoSamlp2AssertionIDRequest(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AssertionIDRequest_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AssertionIDRequest *arg1 = (LassoSamlp2AssertionIDRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AssertionIDRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AssertionIDRequest_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResolve_1Artifact_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2ArtifactResolve *arg1 = (LassoSamlp2ArtifactResolve *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResolve **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Artifact) free((char*)arg1->Artifact);
    if (arg2) {
      arg1->Artifact = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Artifact,arg2);
    } else {
      arg1->Artifact = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResolve_1Artifact_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2ArtifactResolve *arg1 = (LassoSamlp2ArtifactResolve *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResolve **)(void *)&jarg1; 
  result = (char *) ((arg1)->Artifact);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResolve_1issuer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2ArtifactResolve *arg1 = (LassoSamlp2ArtifactResolve *) 0 ;
  LassoSaml2NameID *arg2 = (LassoSaml2NameID *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResolve **)(void *)&jarg1; 
  arg2 = *(LassoSaml2NameID **)(void *)&jarg2; 
  LassoSamlp2ArtifactResolve_Issuer_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResolve_1issuer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2ArtifactResolve *arg1 = (LassoSamlp2ArtifactResolve *) 0 ;
  LassoSaml2NameID *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResolve **)(void *)&jarg1; 
  result = (LassoSaml2NameID *)LassoSamlp2ArtifactResolve_Issuer_get(arg1);
  
  *(LassoSaml2NameID **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResolve_1Extensions_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2ArtifactResolve *arg1 = (LassoSamlp2ArtifactResolve *) 0 ;
  LassoSamlp2Extensions *arg2 = (LassoSamlp2Extensions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResolve **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2Extensions **)(void *)&jarg2; 
  LassoSamlp2ArtifactResolve_Extensions_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResolve_1Extensions_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2ArtifactResolve *arg1 = (LassoSamlp2ArtifactResolve *) 0 ;
  LassoSamlp2Extensions *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResolve **)(void *)&jarg1; 
  result = (LassoSamlp2Extensions *)LassoSamlp2ArtifactResolve_Extensions_get(arg1);
  
  *(LassoSamlp2Extensions **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResolve_1ID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2ArtifactResolve *arg1 = (LassoSamlp2ArtifactResolve *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResolve **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2ArtifactResolve_ID_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResolve_1ID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2ArtifactResolve *arg1 = (LassoSamlp2ArtifactResolve *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResolve **)(void *)&jarg1; 
  result = (char *)LassoSamlp2ArtifactResolve_ID_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResolve_1Version_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2ArtifactResolve *arg1 = (LassoSamlp2ArtifactResolve *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResolve **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2ArtifactResolve_Version_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResolve_1Version_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2ArtifactResolve *arg1 = (LassoSamlp2ArtifactResolve *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResolve **)(void *)&jarg1; 
  result = (char *)LassoSamlp2ArtifactResolve_Version_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResolve_1issueInstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2ArtifactResolve *arg1 = (LassoSamlp2ArtifactResolve *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResolve **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2ArtifactResolve_IssueInstant_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResolve_1issueInstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2ArtifactResolve *arg1 = (LassoSamlp2ArtifactResolve *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResolve **)(void *)&jarg1; 
  result = (char *)LassoSamlp2ArtifactResolve_IssueInstant_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResolve_1Destination_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2ArtifactResolve *arg1 = (LassoSamlp2ArtifactResolve *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResolve **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2ArtifactResolve_Destination_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResolve_1Destination_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2ArtifactResolve *arg1 = (LassoSamlp2ArtifactResolve *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResolve **)(void *)&jarg1; 
  result = (char *)LassoSamlp2ArtifactResolve_Destination_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResolve_1Consent_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2ArtifactResolve *arg1 = (LassoSamlp2ArtifactResolve *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResolve **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2ArtifactResolve_Consent_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResolve_1Consent_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2ArtifactResolve *arg1 = (LassoSamlp2ArtifactResolve *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResolve **)(void *)&jarg1; 
  result = (char *)LassoSamlp2ArtifactResolve_Consent_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Samlp2ArtifactResolve(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlp2ArtifactResolve *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlp2ArtifactResolve *)new_LassoSamlp2ArtifactResolve();
  
  *(LassoSamlp2ArtifactResolve **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Samlp2ArtifactResolve(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlp2ArtifactResolve *arg1 = (LassoSamlp2ArtifactResolve *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResolve **)(void *)&jarg1; 
  delete_LassoSamlp2ArtifactResolve(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ArtifactResolve_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2ArtifactResolve *arg1 = (LassoSamlp2ArtifactResolve *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ArtifactResolve **)(void *)&jarg1; 
  result = (char *)LassoSamlp2ArtifactResolve_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingRequest_1baseID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2NameIDMappingRequest *arg1 = (LassoSamlp2NameIDMappingRequest *) 0 ;
  LassoSaml2BaseIDAbstract *arg2 = (LassoSaml2BaseIDAbstract *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingRequest **)(void *)&jarg1; 
  arg2 = *(LassoSaml2BaseIDAbstract **)(void *)&jarg2; 
  LassoSamlp2NameIDMappingRequest_BaseID_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingRequest_1baseID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2NameIDMappingRequest *arg1 = (LassoSamlp2NameIDMappingRequest *) 0 ;
  LassoSaml2BaseIDAbstract *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingRequest **)(void *)&jarg1; 
  result = (LassoSaml2BaseIDAbstract *)LassoSamlp2NameIDMappingRequest_BaseID_get(arg1);
  
  *(LassoSaml2BaseIDAbstract **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingRequest_1nameID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2NameIDMappingRequest *arg1 = (LassoSamlp2NameIDMappingRequest *) 0 ;
  LassoSaml2NameID *arg2 = (LassoSaml2NameID *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingRequest **)(void *)&jarg1; 
  arg2 = *(LassoSaml2NameID **)(void *)&jarg2; 
  LassoSamlp2NameIDMappingRequest_NameID_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingRequest_1nameID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2NameIDMappingRequest *arg1 = (LassoSamlp2NameIDMappingRequest *) 0 ;
  LassoSaml2NameID *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingRequest **)(void *)&jarg1; 
  result = (LassoSaml2NameID *)LassoSamlp2NameIDMappingRequest_NameID_get(arg1);
  
  *(LassoSaml2NameID **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingRequest_1encryptedID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2NameIDMappingRequest *arg1 = (LassoSamlp2NameIDMappingRequest *) 0 ;
  LassoSaml2EncryptedElement *arg2 = (LassoSaml2EncryptedElement *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingRequest **)(void *)&jarg1; 
  arg2 = *(LassoSaml2EncryptedElement **)(void *)&jarg2; 
  LassoSamlp2NameIDMappingRequest_EncryptedID_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingRequest_1encryptedID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2NameIDMappingRequest *arg1 = (LassoSamlp2NameIDMappingRequest *) 0 ;
  LassoSaml2EncryptedElement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingRequest **)(void *)&jarg1; 
  result = (LassoSaml2EncryptedElement *)LassoSamlp2NameIDMappingRequest_EncryptedID_get(arg1);
  
  *(LassoSaml2EncryptedElement **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingRequest_1nameIDPolicy_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2NameIDMappingRequest *arg1 = (LassoSamlp2NameIDMappingRequest *) 0 ;
  LassoSamlp2NameIDPolicy *arg2 = (LassoSamlp2NameIDPolicy *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingRequest **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2NameIDPolicy **)(void *)&jarg2; 
  LassoSamlp2NameIDMappingRequest_NameIDPolicy_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingRequest_1nameIDPolicy_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2NameIDMappingRequest *arg1 = (LassoSamlp2NameIDMappingRequest *) 0 ;
  LassoSamlp2NameIDPolicy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingRequest **)(void *)&jarg1; 
  result = (LassoSamlp2NameIDPolicy *)LassoSamlp2NameIDMappingRequest_NameIDPolicy_get(arg1);
  
  *(LassoSamlp2NameIDPolicy **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingRequest_1issuer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2NameIDMappingRequest *arg1 = (LassoSamlp2NameIDMappingRequest *) 0 ;
  LassoSaml2NameID *arg2 = (LassoSaml2NameID *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingRequest **)(void *)&jarg1; 
  arg2 = *(LassoSaml2NameID **)(void *)&jarg2; 
  LassoSamlp2NameIDMappingRequest_Issuer_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingRequest_1issuer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2NameIDMappingRequest *arg1 = (LassoSamlp2NameIDMappingRequest *) 0 ;
  LassoSaml2NameID *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingRequest **)(void *)&jarg1; 
  result = (LassoSaml2NameID *)LassoSamlp2NameIDMappingRequest_Issuer_get(arg1);
  
  *(LassoSaml2NameID **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingRequest_1Extensions_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2NameIDMappingRequest *arg1 = (LassoSamlp2NameIDMappingRequest *) 0 ;
  LassoSamlp2Extensions *arg2 = (LassoSamlp2Extensions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingRequest **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2Extensions **)(void *)&jarg2; 
  LassoSamlp2NameIDMappingRequest_Extensions_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingRequest_1Extensions_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2NameIDMappingRequest *arg1 = (LassoSamlp2NameIDMappingRequest *) 0 ;
  LassoSamlp2Extensions *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingRequest **)(void *)&jarg1; 
  result = (LassoSamlp2Extensions *)LassoSamlp2NameIDMappingRequest_Extensions_get(arg1);
  
  *(LassoSamlp2Extensions **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingRequest_1ID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2NameIDMappingRequest *arg1 = (LassoSamlp2NameIDMappingRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2NameIDMappingRequest_ID_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingRequest_1ID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2NameIDMappingRequest *arg1 = (LassoSamlp2NameIDMappingRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlp2NameIDMappingRequest_ID_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingRequest_1Version_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2NameIDMappingRequest *arg1 = (LassoSamlp2NameIDMappingRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2NameIDMappingRequest_Version_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingRequest_1Version_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2NameIDMappingRequest *arg1 = (LassoSamlp2NameIDMappingRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlp2NameIDMappingRequest_Version_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingRequest_1issueInstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2NameIDMappingRequest *arg1 = (LassoSamlp2NameIDMappingRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2NameIDMappingRequest_IssueInstant_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingRequest_1issueInstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2NameIDMappingRequest *arg1 = (LassoSamlp2NameIDMappingRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlp2NameIDMappingRequest_IssueInstant_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingRequest_1Destination_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2NameIDMappingRequest *arg1 = (LassoSamlp2NameIDMappingRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2NameIDMappingRequest_Destination_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingRequest_1Destination_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2NameIDMappingRequest *arg1 = (LassoSamlp2NameIDMappingRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlp2NameIDMappingRequest_Destination_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingRequest_1Consent_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2NameIDMappingRequest *arg1 = (LassoSamlp2NameIDMappingRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2NameIDMappingRequest_Consent_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingRequest_1Consent_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2NameIDMappingRequest *arg1 = (LassoSamlp2NameIDMappingRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlp2NameIDMappingRequest_Consent_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Samlp2NameIDMappingRequest(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlp2NameIDMappingRequest *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlp2NameIDMappingRequest *)new_LassoSamlp2NameIDMappingRequest();
  
  *(LassoSamlp2NameIDMappingRequest **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Samlp2NameIDMappingRequest(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlp2NameIDMappingRequest *arg1 = (LassoSamlp2NameIDMappingRequest *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingRequest **)(void *)&jarg1; 
  delete_LassoSamlp2NameIDMappingRequest(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingRequest_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2NameIDMappingRequest *arg1 = (LassoSamlp2NameIDMappingRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlp2NameIDMappingRequest_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1forceAuthn_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2) {
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->ForceAuthn = arg2;
  
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1forceAuthn_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  result = (bool) ((arg1)->ForceAuthn);
  
  jresult = (jboolean)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1isPassive_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jboolean jarg2) {
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->IsPassive = arg2;
  
}


JNIEXPORT jboolean JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1isPassive_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  result = (bool) ((arg1)->IsPassive);
  
  jresult = (jboolean)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1ProtocolBinding_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->ProtocolBinding) free((char*)arg1->ProtocolBinding);
    if (arg2) {
      arg1->ProtocolBinding = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->ProtocolBinding,arg2);
    } else {
      arg1->ProtocolBinding = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1ProtocolBinding_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  result = (char *) ((arg1)->ProtocolBinding);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1assertionConsumerServiceIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->AssertionConsumerServiceIndex = arg2;
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1assertionConsumerServiceIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  result = (int) ((arg1)->AssertionConsumerServiceIndex);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1AssertionConsumerServiceURL_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->AssertionConsumerServiceURL) free((char*)arg1->AssertionConsumerServiceURL);
    if (arg2) {
      arg1->AssertionConsumerServiceURL = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->AssertionConsumerServiceURL,arg2);
    } else {
      arg1->AssertionConsumerServiceURL = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1AssertionConsumerServiceURL_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  result = (char *) ((arg1)->AssertionConsumerServiceURL);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1attributeConsumingServiceIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->AttributeConsumingServiceIndex = arg2;
  
}


JNIEXPORT jint JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1attributeConsumingServiceIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  result = (int) ((arg1)->AttributeConsumingServiceIndex);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1ProviderName_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->ProviderName) free((char*)arg1->ProviderName);
    if (arg2) {
      arg1->ProviderName = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->ProviderName,arg2);
    } else {
      arg1->ProviderName = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1ProviderName_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  result = (char *) ((arg1)->ProviderName);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1subject_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  LassoSaml2Subject *arg2 = (LassoSaml2Subject *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  arg2 = *(LassoSaml2Subject **)(void *)&jarg2; 
  LassoSamlp2AuthnRequest_Subject_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1subject_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  LassoSaml2Subject *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  result = (LassoSaml2Subject *)LassoSamlp2AuthnRequest_Subject_get(arg1);
  
  *(LassoSaml2Subject **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1nameIDPolicy_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  LassoSamlp2NameIDPolicy *arg2 = (LassoSamlp2NameIDPolicy *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2NameIDPolicy **)(void *)&jarg2; 
  LassoSamlp2AuthnRequest_NameIDPolicy_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1nameIDPolicy_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  LassoSamlp2NameIDPolicy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  result = (LassoSamlp2NameIDPolicy *)LassoSamlp2AuthnRequest_NameIDPolicy_get(arg1);
  
  *(LassoSamlp2NameIDPolicy **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1conditions_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  LassoSaml2Conditions *arg2 = (LassoSaml2Conditions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  arg2 = *(LassoSaml2Conditions **)(void *)&jarg2; 
  LassoSamlp2AuthnRequest_Conditions_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1conditions_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  LassoSaml2Conditions *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  result = (LassoSaml2Conditions *)LassoSamlp2AuthnRequest_Conditions_get(arg1);
  
  *(LassoSaml2Conditions **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1requestedAuthnContext_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  LassoSamlp2RequestedAuthnContext *arg2 = (LassoSamlp2RequestedAuthnContext *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2RequestedAuthnContext **)(void *)&jarg2; 
  LassoSamlp2AuthnRequest_RequestedAuthnContext_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1requestedAuthnContext_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  LassoSamlp2RequestedAuthnContext *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  result = (LassoSamlp2RequestedAuthnContext *)LassoSamlp2AuthnRequest_RequestedAuthnContext_get(arg1);
  
  *(LassoSamlp2RequestedAuthnContext **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1scoping_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  LassoSamlp2Scoping *arg2 = (LassoSamlp2Scoping *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2Scoping **)(void *)&jarg2; 
  LassoSamlp2AuthnRequest_Scoping_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1scoping_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  LassoSamlp2Scoping *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  result = (LassoSamlp2Scoping *)LassoSamlp2AuthnRequest_Scoping_get(arg1);
  
  *(LassoSamlp2Scoping **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1issuer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  LassoSaml2NameID *arg2 = (LassoSaml2NameID *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  arg2 = *(LassoSaml2NameID **)(void *)&jarg2; 
  LassoSamlp2AuthnRequest_Issuer_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1issuer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  LassoSaml2NameID *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  result = (LassoSaml2NameID *)LassoSamlp2AuthnRequest_Issuer_get(arg1);
  
  *(LassoSaml2NameID **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1Extensions_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  LassoSamlp2Extensions *arg2 = (LassoSamlp2Extensions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2Extensions **)(void *)&jarg2; 
  LassoSamlp2AuthnRequest_Extensions_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1Extensions_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  LassoSamlp2Extensions *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  result = (LassoSamlp2Extensions *)LassoSamlp2AuthnRequest_Extensions_get(arg1);
  
  *(LassoSamlp2Extensions **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1ID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2AuthnRequest_ID_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1ID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AuthnRequest_ID_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1Version_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2AuthnRequest_Version_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1Version_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AuthnRequest_Version_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1issueInstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2AuthnRequest_IssueInstant_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1issueInstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AuthnRequest_IssueInstant_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1Destination_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2AuthnRequest_Destination_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1Destination_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AuthnRequest_Destination_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1Consent_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2AuthnRequest_Consent_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1Consent_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AuthnRequest_Consent_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Samlp2AuthnRequest(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlp2AuthnRequest *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlp2AuthnRequest *)new_LassoSamlp2AuthnRequest();
  
  *(LassoSamlp2AuthnRequest **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Samlp2AuthnRequest(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  delete_LassoSamlp2AuthnRequest(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnRequest_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AuthnRequest *arg1 = (LassoSamlp2AuthnRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AuthnRequest_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2SubjectQueryAbstract_1subject_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2SubjectQueryAbstract *arg1 = (LassoSamlp2SubjectQueryAbstract *) 0 ;
  LassoSaml2Subject *arg2 = (LassoSaml2Subject *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2SubjectQueryAbstract **)(void *)&jarg1; 
  arg2 = *(LassoSaml2Subject **)(void *)&jarg2; 
  LassoSamlp2SubjectQueryAbstract_Subject_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2SubjectQueryAbstract_1subject_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2SubjectQueryAbstract *arg1 = (LassoSamlp2SubjectQueryAbstract *) 0 ;
  LassoSaml2Subject *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2SubjectQueryAbstract **)(void *)&jarg1; 
  result = (LassoSaml2Subject *)LassoSamlp2SubjectQueryAbstract_Subject_get(arg1);
  
  *(LassoSaml2Subject **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2SubjectQueryAbstract_1issuer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2SubjectQueryAbstract *arg1 = (LassoSamlp2SubjectQueryAbstract *) 0 ;
  LassoSaml2NameID *arg2 = (LassoSaml2NameID *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2SubjectQueryAbstract **)(void *)&jarg1; 
  arg2 = *(LassoSaml2NameID **)(void *)&jarg2; 
  LassoSamlp2SubjectQueryAbstract_Issuer_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2SubjectQueryAbstract_1issuer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2SubjectQueryAbstract *arg1 = (LassoSamlp2SubjectQueryAbstract *) 0 ;
  LassoSaml2NameID *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2SubjectQueryAbstract **)(void *)&jarg1; 
  result = (LassoSaml2NameID *)LassoSamlp2SubjectQueryAbstract_Issuer_get(arg1);
  
  *(LassoSaml2NameID **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2SubjectQueryAbstract_1Extensions_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2SubjectQueryAbstract *arg1 = (LassoSamlp2SubjectQueryAbstract *) 0 ;
  LassoSamlp2Extensions *arg2 = (LassoSamlp2Extensions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2SubjectQueryAbstract **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2Extensions **)(void *)&jarg2; 
  LassoSamlp2SubjectQueryAbstract_Extensions_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2SubjectQueryAbstract_1Extensions_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2SubjectQueryAbstract *arg1 = (LassoSamlp2SubjectQueryAbstract *) 0 ;
  LassoSamlp2Extensions *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2SubjectQueryAbstract **)(void *)&jarg1; 
  result = (LassoSamlp2Extensions *)LassoSamlp2SubjectQueryAbstract_Extensions_get(arg1);
  
  *(LassoSamlp2Extensions **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2SubjectQueryAbstract_1ID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2SubjectQueryAbstract *arg1 = (LassoSamlp2SubjectQueryAbstract *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2SubjectQueryAbstract **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2SubjectQueryAbstract_ID_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2SubjectQueryAbstract_1ID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2SubjectQueryAbstract *arg1 = (LassoSamlp2SubjectQueryAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2SubjectQueryAbstract **)(void *)&jarg1; 
  result = (char *)LassoSamlp2SubjectQueryAbstract_ID_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2SubjectQueryAbstract_1Version_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2SubjectQueryAbstract *arg1 = (LassoSamlp2SubjectQueryAbstract *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2SubjectQueryAbstract **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2SubjectQueryAbstract_Version_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2SubjectQueryAbstract_1Version_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2SubjectQueryAbstract *arg1 = (LassoSamlp2SubjectQueryAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2SubjectQueryAbstract **)(void *)&jarg1; 
  result = (char *)LassoSamlp2SubjectQueryAbstract_Version_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2SubjectQueryAbstract_1issueInstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2SubjectQueryAbstract *arg1 = (LassoSamlp2SubjectQueryAbstract *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2SubjectQueryAbstract **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2SubjectQueryAbstract_IssueInstant_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2SubjectQueryAbstract_1issueInstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2SubjectQueryAbstract *arg1 = (LassoSamlp2SubjectQueryAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2SubjectQueryAbstract **)(void *)&jarg1; 
  result = (char *)LassoSamlp2SubjectQueryAbstract_IssueInstant_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2SubjectQueryAbstract_1Destination_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2SubjectQueryAbstract *arg1 = (LassoSamlp2SubjectQueryAbstract *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2SubjectQueryAbstract **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2SubjectQueryAbstract_Destination_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2SubjectQueryAbstract_1Destination_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2SubjectQueryAbstract *arg1 = (LassoSamlp2SubjectQueryAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2SubjectQueryAbstract **)(void *)&jarg1; 
  result = (char *)LassoSamlp2SubjectQueryAbstract_Destination_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2SubjectQueryAbstract_1Consent_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2SubjectQueryAbstract *arg1 = (LassoSamlp2SubjectQueryAbstract *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2SubjectQueryAbstract **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2SubjectQueryAbstract_Consent_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2SubjectQueryAbstract_1Consent_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2SubjectQueryAbstract *arg1 = (LassoSamlp2SubjectQueryAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2SubjectQueryAbstract **)(void *)&jarg1; 
  result = (char *)LassoSamlp2SubjectQueryAbstract_Consent_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Samlp2SubjectQueryAbstract(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlp2SubjectQueryAbstract *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlp2SubjectQueryAbstract *)new_LassoSamlp2SubjectQueryAbstract();
  
  *(LassoSamlp2SubjectQueryAbstract **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Samlp2SubjectQueryAbstract(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlp2SubjectQueryAbstract *arg1 = (LassoSamlp2SubjectQueryAbstract *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2SubjectQueryAbstract **)(void *)&jarg1; 
  delete_LassoSamlp2SubjectQueryAbstract(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2SubjectQueryAbstract_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2SubjectQueryAbstract *arg1 = (LassoSamlp2SubjectQueryAbstract *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2SubjectQueryAbstract **)(void *)&jarg1; 
  result = (char *)LassoSamlp2SubjectQueryAbstract_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthzDecisionQuery_1Resource_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AuthzDecisionQuery *arg1 = (LassoSamlp2AuthzDecisionQuery *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthzDecisionQuery **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Resource) free((char*)arg1->Resource);
    if (arg2) {
      arg1->Resource = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Resource,arg2);
    } else {
      arg1->Resource = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthzDecisionQuery_1Resource_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AuthzDecisionQuery *arg1 = (LassoSamlp2AuthzDecisionQuery *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthzDecisionQuery **)(void *)&jarg1; 
  result = (char *) ((arg1)->Resource);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthzDecisionQuery_1action_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2AuthzDecisionQuery *arg1 = (LassoSamlp2AuthzDecisionQuery *) 0 ;
  LassoSaml2Action *arg2 = (LassoSaml2Action *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthzDecisionQuery **)(void *)&jarg1; 
  arg2 = *(LassoSaml2Action **)(void *)&jarg2; 
  LassoSamlp2AuthzDecisionQuery_Action_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthzDecisionQuery_1action_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2AuthzDecisionQuery *arg1 = (LassoSamlp2AuthzDecisionQuery *) 0 ;
  LassoSaml2Action *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthzDecisionQuery **)(void *)&jarg1; 
  result = (LassoSaml2Action *)LassoSamlp2AuthzDecisionQuery_Action_get(arg1);
  
  *(LassoSaml2Action **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthzDecisionQuery_1evidence_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2AuthzDecisionQuery *arg1 = (LassoSamlp2AuthzDecisionQuery *) 0 ;
  LassoSaml2Evidence *arg2 = (LassoSaml2Evidence *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthzDecisionQuery **)(void *)&jarg1; 
  arg2 = *(LassoSaml2Evidence **)(void *)&jarg2; 
  LassoSamlp2AuthzDecisionQuery_Evidence_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthzDecisionQuery_1evidence_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2AuthzDecisionQuery *arg1 = (LassoSamlp2AuthzDecisionQuery *) 0 ;
  LassoSaml2Evidence *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthzDecisionQuery **)(void *)&jarg1; 
  result = (LassoSaml2Evidence *)LassoSamlp2AuthzDecisionQuery_Evidence_get(arg1);
  
  *(LassoSaml2Evidence **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthzDecisionQuery_1Subject_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2AuthzDecisionQuery *arg1 = (LassoSamlp2AuthzDecisionQuery *) 0 ;
  LassoSaml2Subject *arg2 = (LassoSaml2Subject *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthzDecisionQuery **)(void *)&jarg1; 
  arg2 = *(LassoSaml2Subject **)(void *)&jarg2; 
  LassoSamlp2AuthzDecisionQuery_Subject_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthzDecisionQuery_1Subject_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2AuthzDecisionQuery *arg1 = (LassoSamlp2AuthzDecisionQuery *) 0 ;
  LassoSaml2Subject *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthzDecisionQuery **)(void *)&jarg1; 
  result = (LassoSaml2Subject *)LassoSamlp2AuthzDecisionQuery_Subject_get(arg1);
  
  *(LassoSaml2Subject **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthzDecisionQuery_1issuer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2AuthzDecisionQuery *arg1 = (LassoSamlp2AuthzDecisionQuery *) 0 ;
  LassoSaml2NameID *arg2 = (LassoSaml2NameID *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthzDecisionQuery **)(void *)&jarg1; 
  arg2 = *(LassoSaml2NameID **)(void *)&jarg2; 
  LassoSamlp2AuthzDecisionQuery_Issuer_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthzDecisionQuery_1issuer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2AuthzDecisionQuery *arg1 = (LassoSamlp2AuthzDecisionQuery *) 0 ;
  LassoSaml2NameID *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthzDecisionQuery **)(void *)&jarg1; 
  result = (LassoSaml2NameID *)LassoSamlp2AuthzDecisionQuery_Issuer_get(arg1);
  
  *(LassoSaml2NameID **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthzDecisionQuery_1Extensions_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2AuthzDecisionQuery *arg1 = (LassoSamlp2AuthzDecisionQuery *) 0 ;
  LassoSamlp2Extensions *arg2 = (LassoSamlp2Extensions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthzDecisionQuery **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2Extensions **)(void *)&jarg2; 
  LassoSamlp2AuthzDecisionQuery_Extensions_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthzDecisionQuery_1Extensions_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2AuthzDecisionQuery *arg1 = (LassoSamlp2AuthzDecisionQuery *) 0 ;
  LassoSamlp2Extensions *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthzDecisionQuery **)(void *)&jarg1; 
  result = (LassoSamlp2Extensions *)LassoSamlp2AuthzDecisionQuery_Extensions_get(arg1);
  
  *(LassoSamlp2Extensions **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthzDecisionQuery_1ID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AuthzDecisionQuery *arg1 = (LassoSamlp2AuthzDecisionQuery *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthzDecisionQuery **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2AuthzDecisionQuery_ID_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthzDecisionQuery_1ID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AuthzDecisionQuery *arg1 = (LassoSamlp2AuthzDecisionQuery *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthzDecisionQuery **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AuthzDecisionQuery_ID_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthzDecisionQuery_1Version_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AuthzDecisionQuery *arg1 = (LassoSamlp2AuthzDecisionQuery *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthzDecisionQuery **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2AuthzDecisionQuery_Version_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthzDecisionQuery_1Version_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AuthzDecisionQuery *arg1 = (LassoSamlp2AuthzDecisionQuery *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthzDecisionQuery **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AuthzDecisionQuery_Version_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthzDecisionQuery_1issueInstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AuthzDecisionQuery *arg1 = (LassoSamlp2AuthzDecisionQuery *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthzDecisionQuery **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2AuthzDecisionQuery_IssueInstant_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthzDecisionQuery_1issueInstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AuthzDecisionQuery *arg1 = (LassoSamlp2AuthzDecisionQuery *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthzDecisionQuery **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AuthzDecisionQuery_IssueInstant_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthzDecisionQuery_1Destination_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AuthzDecisionQuery *arg1 = (LassoSamlp2AuthzDecisionQuery *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthzDecisionQuery **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2AuthzDecisionQuery_Destination_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthzDecisionQuery_1Destination_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AuthzDecisionQuery *arg1 = (LassoSamlp2AuthzDecisionQuery *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthzDecisionQuery **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AuthzDecisionQuery_Destination_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthzDecisionQuery_1Consent_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AuthzDecisionQuery *arg1 = (LassoSamlp2AuthzDecisionQuery *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthzDecisionQuery **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2AuthzDecisionQuery_Consent_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthzDecisionQuery_1Consent_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AuthzDecisionQuery *arg1 = (LassoSamlp2AuthzDecisionQuery *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthzDecisionQuery **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AuthzDecisionQuery_Consent_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Samlp2AuthzDecisionQuery(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlp2AuthzDecisionQuery *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlp2AuthzDecisionQuery *)new_LassoSamlp2AuthzDecisionQuery();
  
  *(LassoSamlp2AuthzDecisionQuery **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Samlp2AuthzDecisionQuery(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlp2AuthzDecisionQuery *arg1 = (LassoSamlp2AuthzDecisionQuery *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthzDecisionQuery **)(void *)&jarg1; 
  delete_LassoSamlp2AuthzDecisionQuery(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthzDecisionQuery_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AuthzDecisionQuery *arg1 = (LassoSamlp2AuthzDecisionQuery *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthzDecisionQuery **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AuthzDecisionQuery_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AttributeQuery_1attribute_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2AttributeQuery *arg1 = (LassoSamlp2AttributeQuery *) 0 ;
  LassoSaml2Attribute *arg2 = (LassoSaml2Attribute *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AttributeQuery **)(void *)&jarg1; 
  arg2 = *(LassoSaml2Attribute **)(void *)&jarg2; 
  LassoSamlp2AttributeQuery_Attribute_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AttributeQuery_1attribute_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2AttributeQuery *arg1 = (LassoSamlp2AttributeQuery *) 0 ;
  LassoSaml2Attribute *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AttributeQuery **)(void *)&jarg1; 
  result = (LassoSaml2Attribute *)LassoSamlp2AttributeQuery_Attribute_get(arg1);
  
  *(LassoSaml2Attribute **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AttributeQuery_1Subject_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2AttributeQuery *arg1 = (LassoSamlp2AttributeQuery *) 0 ;
  LassoSaml2Subject *arg2 = (LassoSaml2Subject *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AttributeQuery **)(void *)&jarg1; 
  arg2 = *(LassoSaml2Subject **)(void *)&jarg2; 
  LassoSamlp2AttributeQuery_Subject_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AttributeQuery_1Subject_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2AttributeQuery *arg1 = (LassoSamlp2AttributeQuery *) 0 ;
  LassoSaml2Subject *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AttributeQuery **)(void *)&jarg1; 
  result = (LassoSaml2Subject *)LassoSamlp2AttributeQuery_Subject_get(arg1);
  
  *(LassoSaml2Subject **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AttributeQuery_1issuer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2AttributeQuery *arg1 = (LassoSamlp2AttributeQuery *) 0 ;
  LassoSaml2NameID *arg2 = (LassoSaml2NameID *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AttributeQuery **)(void *)&jarg1; 
  arg2 = *(LassoSaml2NameID **)(void *)&jarg2; 
  LassoSamlp2AttributeQuery_Issuer_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AttributeQuery_1issuer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2AttributeQuery *arg1 = (LassoSamlp2AttributeQuery *) 0 ;
  LassoSaml2NameID *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AttributeQuery **)(void *)&jarg1; 
  result = (LassoSaml2NameID *)LassoSamlp2AttributeQuery_Issuer_get(arg1);
  
  *(LassoSaml2NameID **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AttributeQuery_1Extensions_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2AttributeQuery *arg1 = (LassoSamlp2AttributeQuery *) 0 ;
  LassoSamlp2Extensions *arg2 = (LassoSamlp2Extensions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AttributeQuery **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2Extensions **)(void *)&jarg2; 
  LassoSamlp2AttributeQuery_Extensions_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AttributeQuery_1Extensions_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2AttributeQuery *arg1 = (LassoSamlp2AttributeQuery *) 0 ;
  LassoSamlp2Extensions *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AttributeQuery **)(void *)&jarg1; 
  result = (LassoSamlp2Extensions *)LassoSamlp2AttributeQuery_Extensions_get(arg1);
  
  *(LassoSamlp2Extensions **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AttributeQuery_1ID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AttributeQuery *arg1 = (LassoSamlp2AttributeQuery *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AttributeQuery **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2AttributeQuery_ID_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AttributeQuery_1ID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AttributeQuery *arg1 = (LassoSamlp2AttributeQuery *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AttributeQuery **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AttributeQuery_ID_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AttributeQuery_1Version_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AttributeQuery *arg1 = (LassoSamlp2AttributeQuery *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AttributeQuery **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2AttributeQuery_Version_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AttributeQuery_1Version_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AttributeQuery *arg1 = (LassoSamlp2AttributeQuery *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AttributeQuery **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AttributeQuery_Version_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AttributeQuery_1issueInstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AttributeQuery *arg1 = (LassoSamlp2AttributeQuery *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AttributeQuery **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2AttributeQuery_IssueInstant_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AttributeQuery_1issueInstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AttributeQuery *arg1 = (LassoSamlp2AttributeQuery *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AttributeQuery **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AttributeQuery_IssueInstant_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AttributeQuery_1Destination_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AttributeQuery *arg1 = (LassoSamlp2AttributeQuery *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AttributeQuery **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2AttributeQuery_Destination_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AttributeQuery_1Destination_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AttributeQuery *arg1 = (LassoSamlp2AttributeQuery *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AttributeQuery **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AttributeQuery_Destination_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AttributeQuery_1Consent_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AttributeQuery *arg1 = (LassoSamlp2AttributeQuery *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AttributeQuery **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2AttributeQuery_Consent_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AttributeQuery_1Consent_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AttributeQuery *arg1 = (LassoSamlp2AttributeQuery *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AttributeQuery **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AttributeQuery_Consent_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Samlp2AttributeQuery(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlp2AttributeQuery *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlp2AttributeQuery *)new_LassoSamlp2AttributeQuery();
  
  *(LassoSamlp2AttributeQuery **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Samlp2AttributeQuery(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlp2AttributeQuery *arg1 = (LassoSamlp2AttributeQuery *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AttributeQuery **)(void *)&jarg1; 
  delete_LassoSamlp2AttributeQuery(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AttributeQuery_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AttributeQuery *arg1 = (LassoSamlp2AttributeQuery *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AttributeQuery **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AttributeQuery_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AudienceRestriction_1Audience_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2AudienceRestriction *arg1 = (LassoSaml2AudienceRestriction *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AudienceRestriction **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Audience) free((char*)arg1->Audience);
    if (arg2) {
      arg1->Audience = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Audience,arg2);
    } else {
      arg1->Audience = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AudienceRestriction_1Audience_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2AudienceRestriction *arg1 = (LassoSaml2AudienceRestriction *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AudienceRestriction **)(void *)&jarg1; 
  result = (char *) ((arg1)->Audience);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Saml2AudienceRestriction(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSaml2AudienceRestriction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSaml2AudienceRestriction *)new_LassoSaml2AudienceRestriction();
  
  *(LassoSaml2AudienceRestriction **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Saml2AudienceRestriction(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSaml2AudienceRestriction *arg1 = (LassoSaml2AudienceRestriction *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AudienceRestriction **)(void *)&jarg1; 
  delete_LassoSaml2AudienceRestriction(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AudienceRestriction_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2AudienceRestriction *arg1 = (LassoSaml2AudienceRestriction *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AudienceRestriction **)(void *)&jarg1; 
  result = (char *)LassoSaml2AudienceRestriction_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2LogoutRequest_1sessionIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->SessionIndex) free((char*)arg1->SessionIndex);
    if (arg2) {
      arg1->SessionIndex = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->SessionIndex,arg2);
    } else {
      arg1->SessionIndex = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2LogoutRequest_1sessionIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  result = (char *) ((arg1)->SessionIndex);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2LogoutRequest_1Reason_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Reason) free((char*)arg1->Reason);
    if (arg2) {
      arg1->Reason = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Reason,arg2);
    } else {
      arg1->Reason = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2LogoutRequest_1Reason_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  result = (char *) ((arg1)->Reason);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2LogoutRequest_1notOnOrAfter_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->NotOnOrAfter) free((char*)arg1->NotOnOrAfter);
    if (arg2) {
      arg1->NotOnOrAfter = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->NotOnOrAfter,arg2);
    } else {
      arg1->NotOnOrAfter = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2LogoutRequest_1notOnOrAfter_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  result = (char *) ((arg1)->NotOnOrAfter);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2LogoutRequest_1baseID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  LassoSaml2BaseIDAbstract *arg2 = (LassoSaml2BaseIDAbstract *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  arg2 = *(LassoSaml2BaseIDAbstract **)(void *)&jarg2; 
  LassoSamlp2LogoutRequest_BaseID_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2LogoutRequest_1baseID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  LassoSaml2BaseIDAbstract *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  result = (LassoSaml2BaseIDAbstract *)LassoSamlp2LogoutRequest_BaseID_get(arg1);
  
  *(LassoSaml2BaseIDAbstract **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2LogoutRequest_1nameID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  LassoSaml2NameID *arg2 = (LassoSaml2NameID *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  arg2 = *(LassoSaml2NameID **)(void *)&jarg2; 
  LassoSamlp2LogoutRequest_NameID_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2LogoutRequest_1nameID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  LassoSaml2NameID *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  result = (LassoSaml2NameID *)LassoSamlp2LogoutRequest_NameID_get(arg1);
  
  *(LassoSaml2NameID **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2LogoutRequest_1encryptedID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  LassoSaml2EncryptedElement *arg2 = (LassoSaml2EncryptedElement *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  arg2 = *(LassoSaml2EncryptedElement **)(void *)&jarg2; 
  LassoSamlp2LogoutRequest_EncryptedID_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2LogoutRequest_1encryptedID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  LassoSaml2EncryptedElement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  result = (LassoSaml2EncryptedElement *)LassoSamlp2LogoutRequest_EncryptedID_get(arg1);
  
  *(LassoSaml2EncryptedElement **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2LogoutRequest_1issuer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  LassoSaml2NameID *arg2 = (LassoSaml2NameID *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  arg2 = *(LassoSaml2NameID **)(void *)&jarg2; 
  LassoSamlp2LogoutRequest_Issuer_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2LogoutRequest_1issuer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  LassoSaml2NameID *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  result = (LassoSaml2NameID *)LassoSamlp2LogoutRequest_Issuer_get(arg1);
  
  *(LassoSaml2NameID **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2LogoutRequest_1Extensions_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  LassoSamlp2Extensions *arg2 = (LassoSamlp2Extensions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2Extensions **)(void *)&jarg2; 
  LassoSamlp2LogoutRequest_Extensions_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2LogoutRequest_1Extensions_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  LassoSamlp2Extensions *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  result = (LassoSamlp2Extensions *)LassoSamlp2LogoutRequest_Extensions_get(arg1);
  
  *(LassoSamlp2Extensions **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2LogoutRequest_1ID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2LogoutRequest_ID_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2LogoutRequest_1ID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlp2LogoutRequest_ID_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2LogoutRequest_1Version_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2LogoutRequest_Version_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2LogoutRequest_1Version_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlp2LogoutRequest_Version_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2LogoutRequest_1issueInstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2LogoutRequest_IssueInstant_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2LogoutRequest_1issueInstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlp2LogoutRequest_IssueInstant_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2LogoutRequest_1Destination_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2LogoutRequest_Destination_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2LogoutRequest_1Destination_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlp2LogoutRequest_Destination_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2LogoutRequest_1Consent_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2LogoutRequest_Consent_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2LogoutRequest_1Consent_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlp2LogoutRequest_Consent_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Samlp2LogoutRequest(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlp2LogoutRequest *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlp2LogoutRequest *)new_LassoSamlp2LogoutRequest();
  
  *(LassoSamlp2LogoutRequest **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Samlp2LogoutRequest(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  delete_LassoSamlp2LogoutRequest(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2LogoutRequest_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2LogoutRequest *arg1 = (LassoSamlp2LogoutRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2LogoutRequest **)(void *)&jarg1; 
  result = (char *)LassoSamlp2LogoutRequest_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnQuery_1sessionIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AuthnQuery *arg1 = (LassoSamlp2AuthnQuery *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnQuery **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->SessionIndex) free((char*)arg1->SessionIndex);
    if (arg2) {
      arg1->SessionIndex = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->SessionIndex,arg2);
    } else {
      arg1->SessionIndex = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnQuery_1sessionIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AuthnQuery *arg1 = (LassoSamlp2AuthnQuery *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnQuery **)(void *)&jarg1; 
  result = (char *) ((arg1)->SessionIndex);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnQuery_1requestedAuthnContext_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2AuthnQuery *arg1 = (LassoSamlp2AuthnQuery *) 0 ;
  LassoSamlp2RequestedAuthnContext *arg2 = (LassoSamlp2RequestedAuthnContext *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnQuery **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2RequestedAuthnContext **)(void *)&jarg2; 
  LassoSamlp2AuthnQuery_RequestedAuthnContext_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnQuery_1requestedAuthnContext_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2AuthnQuery *arg1 = (LassoSamlp2AuthnQuery *) 0 ;
  LassoSamlp2RequestedAuthnContext *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnQuery **)(void *)&jarg1; 
  result = (LassoSamlp2RequestedAuthnContext *)LassoSamlp2AuthnQuery_RequestedAuthnContext_get(arg1);
  
  *(LassoSamlp2RequestedAuthnContext **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnQuery_1Subject_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2AuthnQuery *arg1 = (LassoSamlp2AuthnQuery *) 0 ;
  LassoSaml2Subject *arg2 = (LassoSaml2Subject *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnQuery **)(void *)&jarg1; 
  arg2 = *(LassoSaml2Subject **)(void *)&jarg2; 
  LassoSamlp2AuthnQuery_Subject_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnQuery_1Subject_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2AuthnQuery *arg1 = (LassoSamlp2AuthnQuery *) 0 ;
  LassoSaml2Subject *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnQuery **)(void *)&jarg1; 
  result = (LassoSaml2Subject *)LassoSamlp2AuthnQuery_Subject_get(arg1);
  
  *(LassoSaml2Subject **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnQuery_1issuer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2AuthnQuery *arg1 = (LassoSamlp2AuthnQuery *) 0 ;
  LassoSaml2NameID *arg2 = (LassoSaml2NameID *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnQuery **)(void *)&jarg1; 
  arg2 = *(LassoSaml2NameID **)(void *)&jarg2; 
  LassoSamlp2AuthnQuery_Issuer_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnQuery_1issuer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2AuthnQuery *arg1 = (LassoSamlp2AuthnQuery *) 0 ;
  LassoSaml2NameID *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnQuery **)(void *)&jarg1; 
  result = (LassoSaml2NameID *)LassoSamlp2AuthnQuery_Issuer_get(arg1);
  
  *(LassoSaml2NameID **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnQuery_1Extensions_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2AuthnQuery *arg1 = (LassoSamlp2AuthnQuery *) 0 ;
  LassoSamlp2Extensions *arg2 = (LassoSamlp2Extensions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnQuery **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2Extensions **)(void *)&jarg2; 
  LassoSamlp2AuthnQuery_Extensions_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnQuery_1Extensions_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2AuthnQuery *arg1 = (LassoSamlp2AuthnQuery *) 0 ;
  LassoSamlp2Extensions *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnQuery **)(void *)&jarg1; 
  result = (LassoSamlp2Extensions *)LassoSamlp2AuthnQuery_Extensions_get(arg1);
  
  *(LassoSamlp2Extensions **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnQuery_1ID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AuthnQuery *arg1 = (LassoSamlp2AuthnQuery *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnQuery **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2AuthnQuery_ID_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnQuery_1ID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AuthnQuery *arg1 = (LassoSamlp2AuthnQuery *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnQuery **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AuthnQuery_ID_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnQuery_1Version_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AuthnQuery *arg1 = (LassoSamlp2AuthnQuery *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnQuery **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2AuthnQuery_Version_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnQuery_1Version_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AuthnQuery *arg1 = (LassoSamlp2AuthnQuery *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnQuery **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AuthnQuery_Version_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnQuery_1issueInstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AuthnQuery *arg1 = (LassoSamlp2AuthnQuery *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnQuery **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2AuthnQuery_IssueInstant_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnQuery_1issueInstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AuthnQuery *arg1 = (LassoSamlp2AuthnQuery *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnQuery **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AuthnQuery_IssueInstant_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnQuery_1Destination_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AuthnQuery *arg1 = (LassoSamlp2AuthnQuery *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnQuery **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2AuthnQuery_Destination_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnQuery_1Destination_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AuthnQuery *arg1 = (LassoSamlp2AuthnQuery *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnQuery **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AuthnQuery_Destination_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnQuery_1Consent_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2AuthnQuery *arg1 = (LassoSamlp2AuthnQuery *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnQuery **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2AuthnQuery_Consent_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnQuery_1Consent_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AuthnQuery *arg1 = (LassoSamlp2AuthnQuery *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnQuery **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AuthnQuery_Consent_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Samlp2AuthnQuery(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlp2AuthnQuery *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlp2AuthnQuery *)new_LassoSamlp2AuthnQuery();
  
  *(LassoSamlp2AuthnQuery **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Samlp2AuthnQuery(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlp2AuthnQuery *arg1 = (LassoSamlp2AuthnQuery *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnQuery **)(void *)&jarg1; 
  delete_LassoSamlp2AuthnQuery(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2AuthnQuery_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2AuthnQuery *arg1 = (LassoSamlp2AuthnQuery *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2AuthnQuery **)(void *)&jarg1; 
  result = (char *)LassoSamlp2AuthnQuery_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Attribute_1Name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2Attribute *arg1 = (LassoSaml2Attribute *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Attribute **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Name) free((char*)arg1->Name);
    if (arg2) {
      arg1->Name = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Name,arg2);
    } else {
      arg1->Name = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Attribute_1Name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2Attribute *arg1 = (LassoSaml2Attribute *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Attribute **)(void *)&jarg1; 
  result = (char *) ((arg1)->Name);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Attribute_1NameFormat_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2Attribute *arg1 = (LassoSaml2Attribute *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Attribute **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->NameFormat) free((char*)arg1->NameFormat);
    if (arg2) {
      arg1->NameFormat = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->NameFormat,arg2);
    } else {
      arg1->NameFormat = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Attribute_1NameFormat_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2Attribute *arg1 = (LassoSaml2Attribute *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Attribute **)(void *)&jarg1; 
  result = (char *) ((arg1)->NameFormat);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Attribute_1FriendlyName_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2Attribute *arg1 = (LassoSaml2Attribute *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Attribute **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->FriendlyName) free((char*)arg1->FriendlyName);
    if (arg2) {
      arg1->FriendlyName = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->FriendlyName,arg2);
    } else {
      arg1->FriendlyName = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Attribute_1FriendlyName_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2Attribute *arg1 = (LassoSaml2Attribute *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Attribute **)(void *)&jarg1; 
  result = (char *) ((arg1)->FriendlyName);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Saml2Attribute(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSaml2Attribute *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSaml2Attribute *)new_LassoSaml2Attribute();
  
  *(LassoSaml2Attribute **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Saml2Attribute(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSaml2Attribute *arg1 = (LassoSaml2Attribute *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Attribute **)(void *)&jarg1; 
  delete_LassoSaml2Attribute(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2Attribute_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2Attribute *arg1 = (LassoSaml2Attribute *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2Attribute **)(void *)&jarg1; 
  result = (char *)LassoSaml2Attribute_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Samlp2Terminate(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlp2Terminate *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlp2Terminate *)new_LassoSamlp2Terminate();
  
  *(LassoSamlp2Terminate **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Samlp2Terminate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlp2Terminate *arg1 = (LassoSamlp2Terminate *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Terminate **)(void *)&jarg1; 
  delete_LassoSamlp2Terminate(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2Terminate_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2Terminate *arg1 = (LassoSamlp2Terminate *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2Terminate **)(void *)&jarg1; 
  result = (char *)LassoSamlp2Terminate_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Samlp2StatusDetail(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlp2StatusDetail *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlp2StatusDetail *)new_LassoSamlp2StatusDetail();
  
  *(LassoSamlp2StatusDetail **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Samlp2StatusDetail(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlp2StatusDetail *arg1 = (LassoSamlp2StatusDetail *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusDetail **)(void *)&jarg1; 
  delete_LassoSamlp2StatusDetail(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2StatusDetail_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2StatusDetail *arg1 = (LassoSamlp2StatusDetail *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2StatusDetail **)(void *)&jarg1; 
  result = (char *)LassoSamlp2StatusDetail_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AuthzDecisionStatement_1Resource_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2AuthzDecisionStatement *arg1 = (LassoSaml2AuthzDecisionStatement *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthzDecisionStatement **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Resource) free((char*)arg1->Resource);
    if (arg2) {
      arg1->Resource = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Resource,arg2);
    } else {
      arg1->Resource = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AuthzDecisionStatement_1Resource_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2AuthzDecisionStatement *arg1 = (LassoSaml2AuthzDecisionStatement *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthzDecisionStatement **)(void *)&jarg1; 
  result = (char *) ((arg1)->Resource);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AuthzDecisionStatement_1Decision_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSaml2AuthzDecisionStatement *arg1 = (LassoSaml2AuthzDecisionStatement *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthzDecisionStatement **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->Decision) free((char*)arg1->Decision);
    if (arg2) {
      arg1->Decision = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->Decision,arg2);
    } else {
      arg1->Decision = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AuthzDecisionStatement_1Decision_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2AuthzDecisionStatement *arg1 = (LassoSaml2AuthzDecisionStatement *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthzDecisionStatement **)(void *)&jarg1; 
  result = (char *) ((arg1)->Decision);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AuthzDecisionStatement_1action_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSaml2AuthzDecisionStatement *arg1 = (LassoSaml2AuthzDecisionStatement *) 0 ;
  LassoSaml2Action *arg2 = (LassoSaml2Action *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthzDecisionStatement **)(void *)&jarg1; 
  arg2 = *(LassoSaml2Action **)(void *)&jarg2; 
  LassoSaml2AuthzDecisionStatement_Action_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AuthzDecisionStatement_1action_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSaml2AuthzDecisionStatement *arg1 = (LassoSaml2AuthzDecisionStatement *) 0 ;
  LassoSaml2Action *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthzDecisionStatement **)(void *)&jarg1; 
  result = (LassoSaml2Action *)LassoSaml2AuthzDecisionStatement_Action_get(arg1);
  
  *(LassoSaml2Action **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AuthzDecisionStatement_1evidence_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSaml2AuthzDecisionStatement *arg1 = (LassoSaml2AuthzDecisionStatement *) 0 ;
  LassoSaml2Evidence *arg2 = (LassoSaml2Evidence *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthzDecisionStatement **)(void *)&jarg1; 
  arg2 = *(LassoSaml2Evidence **)(void *)&jarg2; 
  LassoSaml2AuthzDecisionStatement_Evidence_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AuthzDecisionStatement_1evidence_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSaml2AuthzDecisionStatement *arg1 = (LassoSaml2AuthzDecisionStatement *) 0 ;
  LassoSaml2Evidence *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthzDecisionStatement **)(void *)&jarg1; 
  result = (LassoSaml2Evidence *)LassoSaml2AuthzDecisionStatement_Evidence_get(arg1);
  
  *(LassoSaml2Evidence **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Saml2AuthzDecisionStatement(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSaml2AuthzDecisionStatement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSaml2AuthzDecisionStatement *)new_LassoSaml2AuthzDecisionStatement();
  
  *(LassoSaml2AuthzDecisionStatement **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Saml2AuthzDecisionStatement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSaml2AuthzDecisionStatement *arg1 = (LassoSaml2AuthzDecisionStatement *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthzDecisionStatement **)(void *)&jarg1; 
  delete_LassoSaml2AuthzDecisionStatement(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2AuthzDecisionStatement_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2AuthzDecisionStatement *arg1 = (LassoSaml2AuthzDecisionStatement *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2AuthzDecisionStatement **)(void *)&jarg1; 
  result = (char *)LassoSaml2AuthzDecisionStatement_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingResponse_1nameID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2NameIDMappingResponse *arg1 = (LassoSamlp2NameIDMappingResponse *) 0 ;
  LassoSaml2NameID *arg2 = (LassoSaml2NameID *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingResponse **)(void *)&jarg1; 
  arg2 = *(LassoSaml2NameID **)(void *)&jarg2; 
  LassoSamlp2NameIDMappingResponse_NameID_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingResponse_1nameID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2NameIDMappingResponse *arg1 = (LassoSamlp2NameIDMappingResponse *) 0 ;
  LassoSaml2NameID *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingResponse **)(void *)&jarg1; 
  result = (LassoSaml2NameID *)LassoSamlp2NameIDMappingResponse_NameID_get(arg1);
  
  *(LassoSaml2NameID **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingResponse_1encryptedID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2NameIDMappingResponse *arg1 = (LassoSamlp2NameIDMappingResponse *) 0 ;
  LassoSaml2EncryptedElement *arg2 = (LassoSaml2EncryptedElement *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingResponse **)(void *)&jarg1; 
  arg2 = *(LassoSaml2EncryptedElement **)(void *)&jarg2; 
  LassoSamlp2NameIDMappingResponse_EncryptedID_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingResponse_1encryptedID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2NameIDMappingResponse *arg1 = (LassoSamlp2NameIDMappingResponse *) 0 ;
  LassoSaml2EncryptedElement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingResponse **)(void *)&jarg1; 
  result = (LassoSaml2EncryptedElement *)LassoSamlp2NameIDMappingResponse_EncryptedID_get(arg1);
  
  *(LassoSaml2EncryptedElement **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingResponse_1issuer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2NameIDMappingResponse *arg1 = (LassoSamlp2NameIDMappingResponse *) 0 ;
  LassoSaml2NameID *arg2 = (LassoSaml2NameID *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingResponse **)(void *)&jarg1; 
  arg2 = *(LassoSaml2NameID **)(void *)&jarg2; 
  LassoSamlp2NameIDMappingResponse_Issuer_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingResponse_1issuer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2NameIDMappingResponse *arg1 = (LassoSamlp2NameIDMappingResponse *) 0 ;
  LassoSaml2NameID *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingResponse **)(void *)&jarg1; 
  result = (LassoSaml2NameID *)LassoSamlp2NameIDMappingResponse_Issuer_get(arg1);
  
  *(LassoSaml2NameID **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingResponse_1Extensions_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2NameIDMappingResponse *arg1 = (LassoSamlp2NameIDMappingResponse *) 0 ;
  LassoSamlp2Extensions *arg2 = (LassoSamlp2Extensions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingResponse **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2Extensions **)(void *)&jarg2; 
  LassoSamlp2NameIDMappingResponse_Extensions_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingResponse_1Extensions_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2NameIDMappingResponse *arg1 = (LassoSamlp2NameIDMappingResponse *) 0 ;
  LassoSamlp2Extensions *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingResponse **)(void *)&jarg1; 
  result = (LassoSamlp2Extensions *)LassoSamlp2NameIDMappingResponse_Extensions_get(arg1);
  
  *(LassoSamlp2Extensions **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingResponse_1Status_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2NameIDMappingResponse *arg1 = (LassoSamlp2NameIDMappingResponse *) 0 ;
  LassoSamlp2Status *arg2 = (LassoSamlp2Status *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingResponse **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2Status **)(void *)&jarg2; 
  LassoSamlp2NameIDMappingResponse_Status_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingResponse_1Status_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2NameIDMappingResponse *arg1 = (LassoSamlp2NameIDMappingResponse *) 0 ;
  LassoSamlp2Status *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingResponse **)(void *)&jarg1; 
  result = (LassoSamlp2Status *)LassoSamlp2NameIDMappingResponse_Status_get(arg1);
  
  *(LassoSamlp2Status **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingResponse_1ID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2NameIDMappingResponse *arg1 = (LassoSamlp2NameIDMappingResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2NameIDMappingResponse_ID_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingResponse_1ID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2NameIDMappingResponse *arg1 = (LassoSamlp2NameIDMappingResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingResponse **)(void *)&jarg1; 
  result = (char *)LassoSamlp2NameIDMappingResponse_ID_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingResponse_1inResponseTo_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2NameIDMappingResponse *arg1 = (LassoSamlp2NameIDMappingResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2NameIDMappingResponse_InResponseTo_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingResponse_1inResponseTo_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2NameIDMappingResponse *arg1 = (LassoSamlp2NameIDMappingResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingResponse **)(void *)&jarg1; 
  result = (char *)LassoSamlp2NameIDMappingResponse_InResponseTo_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingResponse_1Version_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2NameIDMappingResponse *arg1 = (LassoSamlp2NameIDMappingResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2NameIDMappingResponse_Version_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingResponse_1Version_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2NameIDMappingResponse *arg1 = (LassoSamlp2NameIDMappingResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingResponse **)(void *)&jarg1; 
  result = (char *)LassoSamlp2NameIDMappingResponse_Version_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingResponse_1issueInstant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2NameIDMappingResponse *arg1 = (LassoSamlp2NameIDMappingResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2NameIDMappingResponse_IssueInstant_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingResponse_1issueInstant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2NameIDMappingResponse *arg1 = (LassoSamlp2NameIDMappingResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingResponse **)(void *)&jarg1; 
  result = (char *)LassoSamlp2NameIDMappingResponse_IssueInstant_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingResponse_1Destination_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2NameIDMappingResponse *arg1 = (LassoSamlp2NameIDMappingResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2NameIDMappingResponse_Destination_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingResponse_1Destination_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2NameIDMappingResponse *arg1 = (LassoSamlp2NameIDMappingResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingResponse **)(void *)&jarg1; 
  result = (char *)LassoSamlp2NameIDMappingResponse_Destination_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingResponse_1Consent_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2NameIDMappingResponse *arg1 = (LassoSamlp2NameIDMappingResponse *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingResponse **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  LassoSamlp2NameIDMappingResponse_Consent_set(arg1,arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingResponse_1Consent_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2NameIDMappingResponse *arg1 = (LassoSamlp2NameIDMappingResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingResponse **)(void *)&jarg1; 
  result = (char *)LassoSamlp2NameIDMappingResponse_Consent_get(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Samlp2NameIDMappingResponse(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSamlp2NameIDMappingResponse *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSamlp2NameIDMappingResponse *)new_LassoSamlp2NameIDMappingResponse();
  
  *(LassoSamlp2NameIDMappingResponse **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Samlp2NameIDMappingResponse(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSamlp2NameIDMappingResponse *arg1 = (LassoSamlp2NameIDMappingResponse *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingResponse **)(void *)&jarg1; 
  delete_LassoSamlp2NameIDMappingResponse(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2NameIDMappingResponse_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2NameIDMappingResponse *arg1 = (LassoSamlp2NameIDMappingResponse *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2NameIDMappingResponse **)(void *)&jarg1; 
  result = (char *)LassoSamlp2NameIDMappingResponse_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_new_1Saml2EncryptedElement(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LassoSaml2EncryptedElement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (LassoSaml2EncryptedElement *)new_LassoSaml2EncryptedElement();
  
  *(LassoSaml2EncryptedElement **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_delete_1Saml2EncryptedElement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LassoSaml2EncryptedElement *arg1 = (LassoSaml2EncryptedElement *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2EncryptedElement **)(void *)&jarg1; 
  delete_LassoSaml2EncryptedElement(arg1);
  
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Saml2EncryptedElement_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSaml2EncryptedElement *arg1 = (LassoSaml2EncryptedElement *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSaml2EncryptedElement **)(void *)&jarg1; 
  result = (char *)LassoSaml2EncryptedElement_dump(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  g_free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ManageNameIDRequest_1NewID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  LassoSamlp2ManageNameIDRequest *arg1 = (LassoSamlp2ManageNameIDRequest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ManageNameIDRequest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg1->NewID) free((char*)arg1->NewID);
    if (arg2) {
      arg1->NewID = (char *) malloc(strlen(arg2)+1);
      strcpy((char*)arg1->NewID,arg2);
    } else {
      arg1->NewID = 0;
    }
  }
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jstring JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ManageNameIDRequest_1NewID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  LassoSamlp2ManageNameIDRequest *arg1 = (LassoSamlp2ManageNameIDRequest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ManageNameIDRequest **)(void *)&jarg1; 
  result = (char *) ((arg1)->NewID);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ManageNameIDRequest_1nameID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2ManageNameIDRequest *arg1 = (LassoSamlp2ManageNameIDRequest *) 0 ;
  LassoSaml2NameID *arg2 = (LassoSaml2NameID *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ManageNameIDRequest **)(void *)&jarg1; 
  arg2 = *(LassoSaml2NameID **)(void *)&jarg2; 
  LassoSamlp2ManageNameIDRequest_NameID_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ManageNameIDRequest_1nameID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2ManageNameIDRequest *arg1 = (LassoSamlp2ManageNameIDRequest *) 0 ;
  LassoSaml2NameID *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ManageNameIDRequest **)(void *)&jarg1; 
  result = (LassoSaml2NameID *)LassoSamlp2ManageNameIDRequest_NameID_get(arg1);
  
  *(LassoSaml2NameID **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ManageNameIDRequest_1encryptedID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2ManageNameIDRequest *arg1 = (LassoSamlp2ManageNameIDRequest *) 0 ;
  LassoSaml2EncryptedElement *arg2 = (LassoSaml2EncryptedElement *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ManageNameIDRequest **)(void *)&jarg1; 
  arg2 = *(LassoSaml2EncryptedElement **)(void *)&jarg2; 
  LassoSamlp2ManageNameIDRequest_EncryptedID_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ManageNameIDRequest_1encryptedID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2ManageNameIDRequest *arg1 = (LassoSamlp2ManageNameIDRequest *) 0 ;
  LassoSaml2EncryptedElement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ManageNameIDRequest **)(void *)&jarg1; 
  result = (LassoSaml2EncryptedElement *)LassoSamlp2ManageNameIDRequest_EncryptedID_get(arg1);
  
  *(LassoSaml2EncryptedElement **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ManageNameIDRequest_1newEncryptedID_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2ManageNameIDRequest *arg1 = (LassoSamlp2ManageNameIDRequest *) 0 ;
  LassoSaml2EncryptedElement *arg2 = (LassoSaml2EncryptedElement *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ManageNameIDRequest **)(void *)&jarg1; 
  arg2 = *(LassoSaml2EncryptedElement **)(void *)&jarg2; 
  LassoSamlp2ManageNameIDRequest_NewEncryptedID_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ManageNameIDRequest_1newEncryptedID_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2ManageNameIDRequest *arg1 = (LassoSamlp2ManageNameIDRequest *) 0 ;
  LassoSaml2EncryptedElement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ManageNameIDRequest **)(void *)&jarg1; 
  result = (LassoSaml2EncryptedElement *)LassoSamlp2ManageNameIDRequest_NewEncryptedID_get(arg1);
  
  *(LassoSaml2EncryptedElement **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ManageNameIDRequest_1terminate_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2ManageNameIDRequest *arg1 = (LassoSamlp2ManageNameIDRequest *) 0 ;
  LassoSamlp2Terminate *arg2 = (LassoSamlp2Terminate *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ManageNameIDRequest **)(void *)&jarg1; 
  arg2 = *(LassoSamlp2Terminate **)(void *)&jarg2; 
  LassoSamlp2ManageNameIDRequest_Terminate_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ManageNameIDRequest_1terminate_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2ManageNameIDRequest *arg1 = (LassoSamlp2ManageNameIDRequest *) 0 ;
  LassoSamlp2Terminate *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ManageNameIDRequest **)(void *)&jarg1; 
  result = (LassoSamlp2Terminate *)LassoSamlp2ManageNameIDRequest_Terminate_get(arg1);
  
  *(LassoSamlp2Terminate **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ManageNameIDRequest_1issuer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  LassoSamlp2ManageNameIDRequest *arg1 = (LassoSamlp2ManageNameIDRequest *) 0 ;
  LassoSaml2NameID *arg2 = (LassoSaml2NameID *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ManageNameIDRequest **)(void *)&jarg1; 
  arg2 = *(LassoSaml2NameID **)(void *)&jarg2; 
  LassoSamlp2ManageNameIDRequest_Issuer_set(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_com_entrouvert_lasso_lassoJNI_Samlp2ManageNameIDRequest_1issuer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  LassoSamlp2ManageNameIDRequest *arg1 = (LassoSamlp2ManageNameIDRequest *) 0 ;
  LassoSaml2NameID *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LassoSamlp2ManageNameIDRequest **)(void *)&jarg1; 
  result = (LassoSaml2NameID *)LassoSamlp2ManageNameIDRequest_Issuer_get(arg1);
  
  *(LassoSaml2NameID **)(void *)&jresult = result; 
  retur