//
// The contents of this file are subject to the Mozilla Public License
// Version 1.0 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License
// at http://www.mozilla.org/MPL/
// 
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
// the License for the specific language governing rights and
// limitations under the License.
//
// This software was developed as part of the legOS project.
//
// Contributor: Pat Welch (legOS@mousebrains.com)

#include <c++/MotorPair.H>
#include <c++/LightSensor.H>
#include <conio.h>
#include <unistd.h>

//
// This is a naive example of a rover which follows a dark line
//

int 
main(int argc, 
     char **argv) 
{
  MotorPair m(Motor::A, Motor::C);
  LightSensor l(LightSensor::S2);

  const int speed = (m.max + m.min) / 3;
  m.Off();

  unsigned int lightLevel(l.sample());
  unsigned int threshold(lightLevel + 5);

  cputw (lightLevel);
  sleep(2);

  while (1) {
    m.Forward(speed);
    while (1) {
      const unsigned int value(l.get());
      cputw(value);
      if (value > threshold) 
	break;
    }
    m.Brake(100);
    m.Left(m.max);
    while (1) {
      const unsigned int value(l.get());
      cputw(value);
      if (value < threshold) 
	break;
    }
    m.Brake(100);
  }
  return 0;
}
