/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -  This software is distributed in the hope that it will be
 -  useful, but with NO WARRANTY OF ANY KIND.
 -  No author or distributor accepts responsibility to anyone for the
 -  consequences of using this software, or for whether it serves any
 -  particular purpose or works at all, unless he or she says so in
 -  writing.  Everyone is granted permission to copy, modify and
 -  redistribute this source code, for commercial or non-commercial
 -  purposes, with the following restrictions: (1) the origin of this
 -  source code must not be misrepresented; (2) modified versions must
 -  be plainly marked as such; and (3) this notice may not be removed
 -  or altered from any source or modified source distribution.
 *====================================================================*/

/*
 * rotate90test.c
 *
 *    Tests and timings:
 *        rotate90test filein direction fileout
 *      where
 *        direction = 1 for cw; -1 for ccw
 */

#include <stdio.h>
#include <stdlib.h>
#include "allheaders.h"

#define  NTIMES   10


main(int    argc,
     char **argv)
{
l_int32      i, w, h, zero, count, dir;
PIX         *pixs, *pixd, *pixt;
l_float32    pops;
char        *filein, *fileout;
static char  mainName[] = "rotate90test";

    if (argc != 4)
	exit(ERROR_INT(" Syntax:  rotate90test filein direction fileout",
	       mainName, 1));

    filein = argv[1];
    dir = atoi(argv[2]);
    fileout = argv[3];

    if ((pixs = pixRead(filein)) == NULL)
	exit(ERROR_INT("pix not made", mainName, 1));

#if 1
	/* time it */
	/* N.B.: allocating & destroying each time */
    startTimer();
    w = pixGetWidth(pixs);
    h = pixGetHeight(pixs);
    for (i = 0; i < NTIMES; i++) {
	pixd = pixRotate90(pixs, dir);
	pixDestroy(&pixd);
    }
    pops = (l_float32)(w * h * NTIMES) / stopTimer();
    fprintf(stderr, "MPops: %7.3f\n", pops / 1000000.);
    pixd = pixRotate90(pixs, dir);
#endif

#if 0
	    /* test 4 successive rots */
	pixt = pixRotate90(pixs, dir);
	pixd = pixRotate90(pixt, dir);
	pixDestroy(&pixt);
	pixt = pixRotate90(pixd, dir);
	pixDestroy(&pixd);
	pixd = pixRotate90(pixt, dir);
	pixDestroy(&pixt);
	pixXor(pixd, pixd, pixs);
	pixZero(pixd, &zero);
	if (zero)
	    fprintf(stderr, "4 rots gives I\n");
	else {
	    pixCountPixels(pixd, &count, NULL);
	    fprintf(stderr, "4 rots fail to give I; count = %d\n", count);
	}
#endif

    if (pixGetDepth(pixd) < 8)
	pixWrite(fileout, pixd, IFF_PNG);
    else
	pixWrite(fileout, pixd, IFF_JFIF_JPEG);

    pixDestroy(&pixs);
    pixDestroy(&pixd);
    exit(0);
}

