/***************************************************************************
                          pack_info.c  -  description
                             -------------------
    begin                : Thu Jul 19 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "tools.h"
#include "file.h"
#include "pack_info.h"

/*
====================================================================
Load a package information from the SRC_DIR/packages and return it.
====================================================================
*/
Pack_Info* load_pack_info( char *file_name )
{
    Pack_Info *info = 0;
    FILE *file = 0;
    char path[512];

    /* open file */
    sprintf( path, "%s/packages/%s", SRC_DIR, file_name );
    printf( "parsing: packages/%s\n", file_name );
    if ( ( file = file_open( path ) ) == 0 ) return 0;

    /* get mem */
    info = calloc( 1, sizeof( Pack_Info ) );

    /* campaign name */
    if ( ( info->title = get_arg( file, "title", RESET_FILE_POS ) ) == 0 )
         info->title = strdup( "No Title" );
    /* description */
    if ( ( info->desc = get_arg( file, "desc", RESET_FILE_POS ) ) == 0 )
        info->desc = strdup( "No Description" );
    /* authors */
    if ( ( info->authors = get_arg( file, "authors", RESET_FILE_POS ) ) == 0 )
        info->authors = strdup( "unknown" );
    /* file list */
    info->file_list = get_arg_cluster( file, "files", &info->file_count, RESET_FILE_POS, WARNING );

    return info;
}

/*
====================================================================
Delete this package info.
====================================================================
*/
void delete_pack_info( Pack_Info *info )
{
    int i;

    if ( !info ) return;

    if ( info->title ) free( info->title );
    if ( info->authors ) free( info->authors );
    if ( info->desc ) free( info->desc );
    if ( info->file_list ) {
        for ( i = 0; i < info->file_count; i++ )
            if ( info->file_list[i] )
                free( info->file_list[i] );
        free( info->file_list );
    }
}
