/*!!***************************************************************************
 *!! FILE NAME
 *!!	$Source: /var/cvs/pub/repository/LinCVS/src/CmdThread.h,v $
 *!!
 *!! AUTHOR
 *!!	$Author: joseh $
 *!!
 *!! DATE, REVISION AND STATE
 *!!	$Date: 2001/10/10 21:13:24 $
 *!!	$Revision: 1.2 $
 *!!	$State: Exp $
 *!!
 *!! DESCRIPTION
 *!!
 *!!	Copyright (C) 2001 The LinCVS development team.
 *!!    Tilo Riemer <riemer@lincvs.org>
 *!!    Falk Brettschneider <gigafalk@yahoo.com>
 *!!    Wim Delvaux <wim.delvaux@chello.be>
 *!!    Jose Hernandez <joseh@tesco.net>
 *!!    Helmut Koll <HelmutKoll@web.de>
 *!!    Sven Trogisch <trogisch@iapp.de>
 *!!
 *!!	This program is free software; you can redistribute it and/or modify
 *!!	it under the terms of the GNU General Public License as published by
 *!!	the Free Software Foundation; either version 2, or (at your option)
 *!!	any later version.
 *!!
 *!!	This program is distributed in the hope that it will be useful,
 *!!	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *!!	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *!!	GNU General Public License for more details.
 *!!
 *!!**************************************************************************/


#ifndef CMDTHREAD_H
#define CMDTHREAD_H


#include "config.h"
#include "ac_system_defs.h"


#include <stdio.h>
#include <qstring.h>
#include <qstringlist.h>


#ifdef QT_THREAD_SUPPORT

#include <qthread.h>

#else

#include "PosixThread.h"

class QThread : public PosixThread
{
public:
	QThread() {};
	~QThread() {};
};


class QMutex : public PosixMutex
{
public:
	QMutex() {};
	~QMutex() {};
};


#endif // QT_THREAD_SUPPORT


class CmdThread : public QThread
{
public:
	CmdThread (QString cmdstr);
	virtual ~CmdThread ();

	virtual void run ();
	QString& getCommand ();

	QStringList m_outputQueue;
	void lockOutputQueue ();
	void unlockOutputQueue ();

private:
	QString m_command;
	FILE *m_pCvs;
	QMutex m_outputQueueMutex;
};


#endif // CMDTHREAD_H
