/*!!***************************************************************************
 *!! FILE NAME
 *!!	$Source: /var/cvs/pub/repository/LinCVS/src/SettingsDialogImpl.cpp,v $
 *!!
 *!! AUTHOR
 *!!	$Author: joseh $
 *!!
 *!! DATE, REVISION AND STATE
 *!!	$Date: 2001/10/15 22:39:48 $
 *!!	$Revision: 1.2 $
 *!!	$State: Exp $
 *!!
 *!! DESCRIPTION
 *!!
 *!!	Copyright (C) 2001 Jose Hernandez.
 *!!	This program is free software; you can redistribute it and/or modify
 *!!	it under the terms of the GNU General Public License as published by
 *!!	the Free Software Foundation; either version 2, or (at your option)
 *!!	any later version.
 *!!
 *!!	This program is distributed in the hope that it will be useful,
 *!!	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *!!	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *!!	GNU General Public License for more details.
 *!!
 *!!**************************************************************************/


#include <qapplication.h>
#include <qbuttongroup.h>
#include <qcombobox.h>
#include <qfont.h>
#include <qfontdialog.h>
#include <qlineedit.h>
#include <qslider.h>
#include <qspinbox.h>
#include <qcheckbox.h>

#include <qplatinumstyle.h>
#include <qwindowsstyle.h>
#include <qmotifstyle.h>
#include <qmotifplusstyle.h> 
#include <qcdestyle.h>
#include <qsgistyle.h>
#include "jfcstyle.h"
#include "stepstyle.h"
#include "wood.h"
#include "metal.h"

#include "globals.h"
#include "SettingsDialogImpl.h"
#include "cfg.h"


extern Config *conf;


/* 
 *  Constructs a SettingsDialogImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
SettingsDialogImpl::SettingsDialogImpl( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : SettingsDialog( parent, name, true, fl )
{
	// Set value on GUI to current compresion level
	m_CompressionLevel->setValue(COMPRESSION);

	// External text editor
	m_editor->setText(EDITOR);

	// Set value on GUI to current theme  
	m_theme->setCurrentItem(stringToNumericStyle(CVSSTYLE));

	// Set application font
	m_AppFont = QApplication::font();

#ifdef KDE2
	// KDE version of LinCVS  disables the style combo box as
	// its not really relevant for KDE executables.
	m_StyleGroup->setEnabled(false);
#endif

	// set the timer slider value
	WBUpdateSlider->setValue(CHECKSTATUSINTERVALL / 1000);

	// set remote shell
	m_RemoteShell->setText(cvsRsh);

	// set External diff program
	m_ExternalDiffUse->setChecked(bUseExternalDiffForSideBySide);
	m_ExternalDiffEdit->setText(externalDiffProgram);

	// set confirm propmt on exit
	m_AskForQuitCheck->setChecked(bAskForQuit);
}

/*  
 *  Destroys the object and frees any allocated resources
 */
SettingsDialogImpl::~SettingsDialogImpl()
{
    // no need to delete child widgets, Qt does it all for us
}


void SettingsDialogImpl::setStyle (APPSTYLE style)
{
	switch (style)
	{
	case APPSTYLE_CDE:
		qApp->setStyle(new QCDEStyle(true));
		CVSSTYLE = "QCDEStyle";
		break;

	case APPSTYLE_JFC:
		qApp->setStyle(new JFCStyle());
		CVSSTYLE = "JFCStyle";
		break;

	case APPSTYLE_METAL:
		qApp->setStyle(new MetalStyle());
		CVSSTYLE = "MetalStyle";
		break;

	case APPSTYLE_MOTIF:
		qApp->setStyle(new QMotifStyle(true));
		CVSSTYLE = "QMotifStyle";
		break;

	case APPSTYLE_MOTIFPLUS:
		qApp->setStyle(new QMotifPlusStyle(true));
		CVSSTYLE = "QMotifPlusStyle";
		break;

	case APPSTYLE_NORWEGIANWOOD:
		qApp->setStyle(new NorwegianWoodStyle());
		CVSSTYLE = "NorwegianWoodStyle";
		break;

	case APPSTYLE_PLATINUM:
		qApp->setStyle(new QPlatinumStyle());
		CVSSTYLE = "QPlatinumStyle";
		break;

	case APPSTYLE_SGI:
		qApp->setStyle(new QSGIStyle());
		CVSSTYLE = "SGIStyle";
		break;

	case APPSTYLE_STEP:
		qApp->setStyle(new StepStyle());
		CVSSTYLE = "StepStyle";
		break;

	case APPSTYLE_WINDOWS:
		qApp->setStyle(new QWindowsStyle());
		CVSSTYLE = "QWindowsStyle";
		break;
	}
}


SettingsDialogImpl::APPSTYLE SettingsDialogImpl::stringToNumericStyle (QString style)
{
	if (style == tr("QCDEStyle"))
		return (APPSTYLE_CDE);
	else if (style == tr("JFCStyle"))
		return (APPSTYLE_JFC);
	else if (style == tr("QMotifStyle"))
		return (APPSTYLE_MOTIF);
	else if (style == tr("QMotifPlusStyle"))
		return (APPSTYLE_MOTIFPLUS);
	else if (style == tr("MetalStyle"))
		return (APPSTYLE_METAL);
	else if (style == tr("NorwegianWoodStyle"))
		return (APPSTYLE_NORWEGIANWOOD);
	else if (style == tr("QPlatinumStyle"))
		return (APPSTYLE_PLATINUM);
	else if (style == tr("SGIStyle"))
		return (APPSTYLE_SGI);
	else if (style == tr("StepStyle"))
		return (APPSTYLE_STEP);
	else if (style == tr("QWindowsStyle"))
		return (APPSTYLE_WINDOWS);
}


void SettingsDialogImpl::setStyle (QString style)
{
	setStyle (stringToNumericStyle(style));
}


// protected slot
void SettingsDialogImpl::accept()
{
	apply();
	QDialog::accept();
}


// protected slot
void SettingsDialogImpl::apply()
{
	// Set value on GUI to current compresion level
	COMPRESSION = m_CompressionLevel->value();

	// External text editor
	EDITOR = m_editor->text();

	// Application font settings
	QApplication::setFont(m_AppFont, true);
	CVSFONT.NAME = m_AppFont.family();
	CVSFONT.POINTSIZE = m_AppFont.pointSize();
	CVSFONT.WEIGHT = m_AppFont.weight();
	CVSFONT.ITALIC = m_AppFont.italic();
	CVSFONT.CHARSET = m_AppFont.charSet();

	// Window theme
	setStyle (static_cast<APPSTYLE>(m_theme->currentItem()));

	// timer interval
	int sec = WBUpdateSlider->value();
	CHECKSTATUSINTERVALL = sec * 1000;

	// Remote shell
	cvsRsh = m_RemoteShell->text();

	// External diff program
	bUseExternalDiffForSideBySide = m_ExternalDiffUse->isChecked();
	externalDiffProgram = m_ExternalDiffEdit->text();

	// Show confirm prompt on exit
	bAskForQuit = m_AskForQuitCheck->isChecked();

	// ...and now save configuration
	conf->putCfgFile();
}


// protected slot
void SettingsDialogImpl::setAppFont()
{
	bool ok;
	QFont LocalFont = QFontDialog::getFont (&ok, m_AppFont, this);

	// did the user select a valid font?
	if (ok)
		m_AppFont = LocalFont;
}
