/****************************************************************************
**
** $Id: dialogs.cpp,v 1.32 2001/08/16 00:55:59 riemer Exp $
**
** Copyright (C) 2001 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/

#include "config.h"
#include "ac_system_defs.h"

#include <qfiledialog.h>
#include <PixmapCache.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qgroupbox.h> 
#include <qcombobox.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qmultilineedit.h>
#include <qcheckbox.h> 
#include <qtooltip.h> 
#include <qtimer.h> 
#include <qwidget.h>

//----------------------------------------------------------------------------

#include "dialogs.h"
#include "getCvsMod.h"
#include "cfg.h"

//----------------------------------------------------------------------------
extern Config *conf;
//extern QStringList  m_coLinCVSProfile;

CheckOutAndImportDlg::CheckOutAndImportDlg(int *lastAccessMethod,
   QStringList *userList,
   QStringList *moduleList,
   QStringList *serverList,
   QStringList *repositoryList,
   QStringList *localDirList,
   QStringList *profileList,
   QStringList *vendorTagList,
   QStringList *releaseTagList,
   QString *lastComment,
   QStringList *tagList, 
   bool checkoutImport01, QString caption, QWidget *parent, 
   const char *name, bool modal, WFlags f)
: QDialog(parent, name, modal, f)
{
   m_pLastAccessMethod = lastAccessMethod;
   m_pUserList = userList;
   m_pModuleList = moduleList;
   m_pServerList = serverList;
   m_pRepositoryList = repositoryList;
   m_pLocalDirList = localDirList;
   m_pProfileList  = profileList;
   m_pVendorTagList = vendorTagList;
   m_pReleaseTagList = releaseTagList;
   m_pLastComment = lastComment;

   setCaption(caption);


//--------------------------------------------------------------

   
   m_pTagCtl = 0;
   
   QBoxLayout *topLayer = new QVBoxLayout(this, 5);
   QGridLayout *gridLayer;

   if(checkoutImport01) {//import
      gridLayer = new QGridLayout(topLayer, 11, 2, 5);
   }
   else {
      gridLayer = new QGridLayout(topLayer, 7, 2, 5);
   }
   
   //create background widget and layer for "CVS mod"
   QWidget *wm = new QWidget(this);
   gridLayer->addWidget(wm, 2, 1);
   QBoxLayout *cvsmodLayer = new QHBoxLayout(wm);
   m_pLineModule = new QComboBox(true, wm);
   cvsmodLayer->addWidget(m_pLineModule, 3);
   cvsmodLayer->addSpacing(3);
   QPushButton *choiceCVS = new QPushButton("...", wm);
   cvsmodLayer->addWidget(choiceCVS, 1);
   connect(choiceCVS, SIGNAL(clicked()), this, SLOT(getModule()));

   //create labels
   QLabel *label;
   label = new QLabel(tr("Method:"), this);   
   gridLayer->addWidget(label, 0, 0);
   label = new QLabel(tr("User:"), this);   
   gridLayer->addWidget(label, 1, 0);
   label = new QLabel(tr("CVS Module:"), this);   
   gridLayer->addWidget(label, 2, 0);
   label = new QLabel(tr("CVS Server:"), this);   
   gridLayer->addWidget(label, 3, 0);
   label = new QLabel(tr("CVS Repository:"), this);   
   gridLayer->addWidget(label, 4, 0);
   label = new QLabel(tr("Local Directory:"), this);   
   gridLayer->addWidget(label, 5, 0);
   label = new QLabel(tr("Profile:"), this);   
   gridLayer->addWidget(label, 6, 0);


   //combo for mode
   m_pMode = new QComboBox(false, this);
   m_pMode->insertItem(tr("Password"));
   m_pMode->insertItem(tr("Remote Shell"));
   m_pMode->insertItem(tr("Local/NFS"));
   connect(m_pMode, SIGNAL(activated(int)), this, SLOT(chooseMode(int)));
   gridLayer->addWidget(m_pMode, 0, 1);

   m_mode = MODE_PSERVER;

   //create background widget and layer for "local dir"
   QWidget *w = new QWidget(this);
   gridLayer->addWidget(w, 5, 1);
   QBoxLayout *dirLayer = new QHBoxLayout(w);
   
   //create input fields
   m_pUser = new QComboBox(true, this);
   m_pLineServer = new QComboBox(true, this);
   m_pRepository = new QComboBox(true, this);
   m_pLineLocalDir = new QComboBox(true, w);
   m_pLineLocalDir->setMinimumWidth(250);

   m_pProfile = new QComboBox(this);
   m_pProfile->setAutoCompletion ( TRUE );
   m_pProfile->setInsertionPolicy ( QComboBox::NoInsertion );
   connect(m_pProfile, SIGNAL (activated ( const QString & ) ), 
           this, SLOT (updateComboBoxes(const QString &  )) );

   gridLayer->addWidget(m_pUser, 1, 1);
   gridLayer->addWidget(m_pLineServer, 3, 1);
   gridLayer->addWidget(m_pRepository, 4, 1);
   gridLayer->addWidget(m_pProfile, 6, 1);
   
   unsigned int i;
   for(i = 0; i < m_pUserList->count(); i++) m_pUser->insertItem((*m_pUserList)[i]);
   for(i = 0; i < m_pModuleList->count(); i++) m_pLineModule->insertItem((*m_pModuleList)[i]);
   for(i = 0; i < m_pServerList->count(); i++) m_pLineServer->insertItem((*m_pServerList)[i]);
   for(i = 0; i < m_pRepositoryList->count(); i++) m_pRepository->insertItem((*m_pRepositoryList)[i]);
   for(i = 0; i < m_pLocalDirList->count(); i++) m_pLineLocalDir->insertItem((*m_pLocalDirList)[i]);
   m_pProfile->insertStringList((*m_pProfileList));


   dirLayer->addWidget(m_pLineLocalDir, 3);
   dirLayer->addSpacing(3);
   QPushButton *choiceDir = new QPushButton("...", w);
   dirLayer->addWidget(choiceDir, 1);
   connect(choiceDir, SIGNAL(clicked()), this, SLOT(showDirOpenDlg()));

   //rsh-zusatzparameter-controls
   topLayer->addSpacing(10);

   m_pRshBox = new QButtonGroup(2, Vertical, this);
   m_pRshBox->setExclusive(true);
   topLayer->addWidget(m_pRshBox);

   QWidget *extBg = new QWidget(m_pRshBox);
   QBoxLayout *extLayer = new QHBoxLayout(extBg);
   
   m_pExt = new QRadioButton(tr("use external rsh program (default is rsh)"), extBg);
   extLayer->addWidget(m_pExt);
   m_pRshBox->insert(m_pExt);
   extLayer->addSpacing(15);
   m_pExt->setChecked(true);   //default
   connect(m_pExt, SIGNAL(toggled(bool)), this, SLOT(chooseRshMethod(bool)));

   m_pRshLine = new QLineEdit(extBg);
   extLayer->addWidget(m_pRshLine);
   m_pRshLine->setText(getenv("CVS_RSH"));
   m_pServer = new QRadioButton(
                   tr("use internal rsh client (supported only by some CVS ports)"), m_pRshBox);
   connect(m_pServer, SIGNAL(toggled(bool)), this, SLOT(chooseRshMethod(bool)));


   //analyze CVSROOT
   QString connectMethod;
   QString userName;
   QString host;
   QString rootDir;

   if(*m_pLastAccessMethod > -1 ) {
      m_pMode->setCurrentItem(*m_pLastAccessMethod);
      m_mode = *m_pLastAccessMethod;
      if (m_mode == MODE_LOCAL) {
         m_pLineServer->setEnabled(false);
         m_pUser->setEnabled(false);
      } else {
         m_pLineServer->setEnabled(true);
         m_pUser->setEnabled(true);
      }
      if (m_mode == MODE_RSH) {
         m_pRshBox->show();
         int result = analyzeCVSROOT(connectMethod, userName, host, rootDir);
         //jetzt rsh-zusatzparameter initialisieren und anzeigen, sonst verstecken
         if((result & ~7) == RSH_EXT) {//ext
            m_pExt->setChecked(true);
            m_pRshLine->setEnabled(true);
         } else {//server
            m_pServer->setChecked(true);
            m_pRshLine->setEnabled(false);
         }
      } else m_pRshBox->hide();
   }
   else {
      int result = analyzeCVSROOT(connectMethod, userName, host, rootDir);
      int res_3bits = (result & 7);   

      if(res_3bits == ACCESS_LOCAL) {//local
         m_pMode->setCurrentItem(2);
         m_pUser->insertItem(userName);
         m_pLineServer->insertItem(host);
//         if (rootDir.length() > 0) m_pRepository->insertItem(rootDir);
         insertRootDir(rootDir);
         m_pLineServer->setEnabled(false);
         m_pUser->setEnabled(false);
         m_mode = MODE_LOCAL;
         m_pRshBox->hide();
      } else if(res_3bits == ACCESS_PSERVER) {//pserver
         m_pMode->setCurrentItem(0);
         m_pUser->insertItem(userName);
         m_pLineServer->insertItem(host);
//         if (rootDir.length() > 0) m_pRepository->insertItem(rootDir);
         insertRootDir(rootDir);
         m_pLineServer->setEnabled(true);
         m_pUser->setEnabled(true);
         m_mode = MODE_PSERVER;
         m_pRshBox->hide();
      } else if(res_3bits == ACCESS_RSH) {//remote shell
         m_pMode->setCurrentItem(1);
         m_pUser->insertItem(userName);
         m_pLineServer->insertItem(host);
//         if (rootDir.length() > 0) m_pRepository->insertItem(rootDir);
         insertRootDir(rootDir);
         m_pLineServer->setEnabled(true);
         m_pUser->setEnabled(true);
         m_mode = MODE_RSH;

         m_pRshBox->show();
      
         //jetzt rsh-zusatzparameter initialisieren und anzeigen, sonst verstecken
         if((result & ~7) == RSH_EXT) {//ext
            m_pExt->setChecked(true);
            m_pRshLine->setEnabled(true);
         } else {//server
            m_pServer->setChecked(true);
            m_pRshLine->setEnabled(false);
         }
      }
   }

   m_checkoutImport01 = checkoutImport01;
   if(m_checkoutImport01) {//import
      QFrame *line = new QFrame(this);
      line->setFrameStyle ( QFrame::Sunken | QFrame::HLine );
      gridLayer->addMultiCellWidget(line, 7, 7, 0, 2);
      label = new QLabel(tr("Vendor Tag:"), this);   
      gridLayer->addWidget(label, 8, 0);
      label = new QLabel(tr("Release Tag:"), this);   
      gridLayer->addWidget(label, 9, 0);
      label = new QLabel(tr("Comment:"), this);   
      gridLayer->addWidget(label, 10, 0);
   
      m_pTag1 = new QComboBox(true, this);
      m_pTag2 = new QComboBox(true, this);
      m_pComment = new QMultiLineEdit(this);
      gridLayer->addWidget(m_pTag1, 8, 1);
      gridLayer->addWidget(m_pTag2, 9, 1);
      gridLayer->addWidget(m_pComment, 10, 1);

      for(i = 0; i < m_pVendorTagList->count(); i++) m_pTag1->insertItem((*m_pVendorTagList)[i]);
      for(i = 0; i < m_pReleaseTagList->count(); i++) m_pTag2->insertItem((*m_pReleaseTagList)[i]);

      m_pComment->setText(*m_pLastComment);
   }
   else {//Checkout
      topLayer->addSpacing(15);
      m_pTagCtl = new TagOperationControl(tagList, 
                      tr("use tag, revision or date"), this, false, false);
      topLayer->addWidget(m_pTagCtl);
   }

   topLayer->addSpacing(15);

   //create background widget and layer for "ok" and "cancel"
   w = new QWidget(this);
   topLayer->addWidget(w);
   QBoxLayout *buttonLayer = new QHBoxLayout(w);
   buttonLayer->addStretch();
   
   //ok and cancel
   QPushButton *ok = new QPushButton(w);
   ok->setText(tr("OK"));
   ok->setDefault(true);
   buttonLayer->addWidget(ok);
   buttonLayer->addStretch();
   QPushButton *cancel = new QPushButton(w);
   cancel->setText(tr("Cancel"));
   buttonLayer->addWidget(cancel);
   buttonLayer->addStretch();

   connect(ok, SIGNAL(clicked()), this, SLOT(accept()));
   connect(cancel, SIGNAL(clicked()), this, SLOT(reject()));

   
   if(!m_checkoutImport01) {//checkout
      QTimer::singleShot(500, this, SLOT(setMaximumHeightSlot()));
   }
   
   QToolTip::add(m_pMode, tr("Choose the access mode") );
   QToolTip::add(m_pUser, tr("Enter your login name on CVS server") );
   QToolTip::add(m_pLineModule, tr("Enter module name, for instance LinCVS") );
   QToolTip::add(m_pLineServer, tr("Enter name or IP address of CVS server, for instance www.kde-devel.org") );
   QToolTip::add(m_pRepository, tr("Enter path to the repository on CVS server, for instance /usr/share/cvs/repository") );
   QToolTip::add(m_pLineLocalDir, tr("Enter directory for your local copy, for instance /home/anyuser/projects") );
   QToolTip::add(choiceCVS, tr("Click to open a module browser") );
   QToolTip::add(choiceDir, tr("Click to open a directory browser") );
   QToolTip::add(m_pProfile, tr("Choose stored settings for Method - User - CVS Server - CVS Repository") );
}

//----------------------------------------------------------------------------

void CheckOutAndImportDlg::chooseRshMethod(bool)
{
   if(m_pExt->isChecked())
      m_pRshLine->setEnabled(true);
   else
      m_pRshLine->setEnabled(false);
}

QString CheckOutAndImportDlg::user() {
	return m_pUser->currentText();
}

QString CheckOutAndImportDlg::module() {
	return m_pLineModule->currentText();
}

QString CheckOutAndImportDlg::server() {
	return m_pLineServer->currentText();
}

QString CheckOutAndImportDlg::repository() {
	return m_pRepository->currentText();
}

QString CheckOutAndImportDlg::localDir() {
	return m_pLineLocalDir->currentText();
}
  
QString CheckOutAndImportDlg::comment() {
	return m_pComment->text();
}
  
QString CheckOutAndImportDlg::tag1() {
	return m_pTag1->currentText();
}
  
QString CheckOutAndImportDlg::tag2() {
	return m_pTag2->currentText();
}  


//----------------------------------------------------------------------------

void CheckOutAndImportDlg::showDirOpenDlg()
{
   QString fn = QFileDialog::getExistingDirectory (QString::null, this, NULL,
						   tr("Choose target directory"),
						   true);

   if (!fn.isEmpty ())
   {
	   m_pLineLocalDir->insertItem (fn, 0);
   }
}

//----------------------------------------------------------------------------

void CheckOutAndImportDlg::chooseMode(int m)
{
   switch(m)
   {
      case MODE_PSERVER:
         m_mode = MODE_PSERVER;
         m_pLineServer->setEnabled(true);
         m_pUser->setEnabled(true);
         m_pRshBox->hide();
         if(!m_checkoutImport01) {//checkout
            QTimer::singleShot(500, this, SLOT(setMaximumHeightSlot()));
         }
         break;
      case MODE_RSH:
         m_mode = MODE_RSH;
         m_pLineServer->setEnabled(true);
         m_pUser->setEnabled(true);
         m_pRshBox->show();
         if(!m_checkoutImport01) {//checkout
            QTimer::singleShot(500, this, SLOT(setMaximumHeightSlot()));
         }
         break;
      case MODE_LOCAL:
         m_mode = MODE_LOCAL;
         m_pLineServer->setEnabled(false);
         m_pUser->setEnabled(false);
         m_pRshBox->hide();
         if(!m_checkoutImport01) {//checkout
            QTimer::singleShot(500, this, SLOT(setMaximumHeightSlot()));
         }
         break;
   }
}

//----------------------------------------------------------------------------

int CheckOutAndImportDlg::rshMode()
{
   if(m_pExt->isChecked())
      return RSH_EXT;
   else
      return RSH_SERVER;
}

//----------------------------------------------------------------------------

QString CheckOutAndImportDlg::cvsParameter()
{
   if(m_pTagCtl) {
      return m_pTagCtl->cvsParameter();
   }
   else return QString::null;
}

//----------------------------------------------------------------------------

void CheckOutAndImportDlg::setMaximumHeightSlot()
{
   setMaximumHeight(sizeHint().height());
   resize(width(), sizeHint().height());
}

//----------------------------------------------------------------------------

void CheckOutAndImportDlg::adaptStatePointer()
{
   *m_pLastAccessMethod = m_mode;

   updateComboBoxList (m_pUserList,       m_pUser);
   updateComboBoxList (m_pModuleList,     m_pLineModule);
   updateComboBoxList (m_pServerList,     m_pLineServer);
   updateComboBoxList (m_pRepositoryList, m_pRepository);
   updateComboBoxList (m_pLocalDirList,   m_pLineLocalDir);
   updateComboBoxList (m_pProfileList,    m_pProfile);
   if (m_checkoutImport01) {
     updateComboBoxList (m_pVendorTagList,  m_pTag1);
     updateComboBoxList (m_pReleaseTagList, m_pTag2);
     *m_pLastComment = m_pComment->text();
   }
}


void CheckOutAndImportDlg::updateComboBoxList(QStringList *plist, QComboBox *pbox)
{
   if(plist->findIndex(pbox->currentText()) == -1) {//text isnt in list
      plist->prepend ( pbox->currentText());
   }
   else 
   if(plist->findIndex(pbox->currentText()) > 0) {//text isnt the first item in list
      plist->remove (pbox->currentText());
      plist->prepend(pbox->currentText());
   }
}




/*---------------------------------------------------------------------------*/
/*!
\fn			void CheckOutAndImportDlg::getModule(void)
\brief		Select a CVS module from a directory dialog. Check if file is
  in repository and remove extension.

<BR><HR>*/
/*---------------------------------------------------------------------------*/

void CheckOutAndImportDlg::getModule(void)
{
  QString connectMethod;
  QString userName;
  QString host;
  QString rootDir;

  analyzeCVSROOT(connectMethod, userName, host, rootDir);

  getCvsModule *mBrowser = new getCvsModule(((QString)rootDir)+"/");
  connect (mBrowser, SIGNAL (cvsModuleSelected( const QString & )), 
           SLOT (insertModule(const QString &)));
  
  mBrowser->resize( 500, 400 );
  mBrowser->setCaption( "CVS Module Browser" );
  mBrowser->exec();
   
}


/*---------------------------------------------------------------------------*/
/*!
\fn			void CheckOutAndImportDlg::insertModule(const QString& cvsMod)
\brief		Puts selected name  in var.

\param		cvsMod		

<BR><HR>*/
/*---------------------------------------------------------------------------*/

void CheckOutAndImportDlg::insertModule(const QString& cvsMod)
{
  m_pLineModule->insertItem(cvsMod, 0);
}


/*---------------------------------------------------------------------------*/
/*!
\fn			CheckOutAndImportDlg::insertRootDir(QString rootDir)
\brief		Check if rootDir is already in list, if not -> append.

\param		rootDir		

\return		
<BR><HR>*/
/*---------------------------------------------------------------------------*/

void CheckOutAndImportDlg::insertRootDir(QString rootDir)
{
  bool found = FALSE;

  if (rootDir.length() > 0){
    for(unsigned int i=0; i < m_pRepositoryList->count(); i++){
      if ((*m_pRepositoryList)[i] == rootDir) found = TRUE;
    }
    if (!found){
      m_pRepositoryList->prepend(rootDir);
      m_pRepository->insertItem(rootDir, 0);
    }
  }

}



/*---------------------------------------------------------------------------*/
/*!
\fn			void CheckOutAndImportDlg::updateComboBoxes(const QString &item)
\brief		updates the comboboxes : Method - User - CVS Server - CVS Repository
          in reference to the setting of profile. 

\param		&item		

<BR><HR>*/
/*---------------------------------------------------------------------------*/

void CheckOutAndImportDlg::updateComboBoxes(const QString &item)
{
  lincvsProfile *profile;

/*! search index in qlist */
  for ( profile=conf->list.first(); profile != 0; profile=conf->list.next() )
  {
    if (profile->name().stripWhiteSpace() == item.stripWhiteSpace() )
    {
      break;
    }
  }
    
/*! search item in combobox user */
  m_pUser->setCurrentItem( 
    findlistIndex(m_pUserList, profile->user()) );

/*! search item in combobox server */
   m_pLineServer->setCurrentItem( 
    findlistIndex(m_pServerList, profile->server()) );

/*! search item in combobox repository */
  m_pRepository->setCurrentItem( 
    findlistIndex(m_pRepositoryList, profile->repository()) );

/*! set item in combobox method */
  m_pMode->setCurrentItem( profile->method() );
}



/*---------------------------------------------------------------------------*/
/*!
\fn			int CheckOutAndImportDlg::findlistIndex(QStringList *list, QString item)
\brief		searches the 'item' in the QStringList 'list' and returns the index if
          found. Otherwise return 0.

\param		*list		
\param		item		

\return		
<BR><HR>*/
/*---------------------------------------------------------------------------*/

int CheckOutAndImportDlg::findlistIndex(QStringList *list, const QString item)
{
  int idx;
  idx = 0;
  
  for ( QStringList::Iterator it = list->begin(); it != list->end(); ++it )
  {
    if ( (*it).stripWhiteSpace()==item.stripWhiteSpace() )
    {
      return idx;
    }
    idx++;  
  }
  return 0;
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

TagUpdateDlg::TagUpdateDlg(QStringList *tagList, QString caption, QWidget *parent, 
   const char *name, bool modal, WFlags f)
: QDialog(parent, name, modal, f)
{
   setCaption(caption);

   if (bUseSmallIcons) setIcon (findEmbeddedPixmap ("Tag16x16"));
   else setIcon (findEmbeddedPixmap ("Tag32x32"));
   
   QBoxLayout *topLayer = new QVBoxLayout(this, 5);

   m_pTagCtl = new TagOperationControl(tagList, 
                   tr("use tag, revision or date instead working copy"), this);
   topLayer->addWidget(m_pTagCtl);

   topLayer->addSpacing(15);
   QBoxLayout *buttonLayer = new QHBoxLayout(topLayer, 5);
   buttonLayer->addStretch();
   QPushButton *ok = new QPushButton(this);
   ok->setText(tr("Update"));
   ok->setDefault(true);
   buttonLayer->addWidget(ok);
   buttonLayer->addStretch();
   QPushButton *cancel = new QPushButton(this);
   cancel->setText(tr("Cancel"));
   buttonLayer->addWidget(cancel);
   buttonLayer->addStretch();
   
   //hier die connects zum tag-slot
   connect(ok, SIGNAL(clicked()), this, SLOT(accept()));
   connect(cancel, SIGNAL(clicked()), this, SLOT(reject()));
   
   QTimer::singleShot(500, this, SLOT(setMaximumHeightSlot()));
}

//----------------------------------------------------------------------------

QString TagUpdateDlg::cvsParameter()
{
   return m_pTagCtl->cvsParameter();
}

//----------------------------------------------------------------------------

void TagUpdateDlg::setMaximumHeightSlot()
{
   setMaximumHeight(sizeHint().height());
   resize(width(), sizeHint().height());
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

WarningDlg::WarningDlg(QString title, QString text, QWidget *parent)
: QDialog(parent, title, true)
{
   setCaption(title);
   QBoxLayout *topLayer = new QVBoxLayout(this, 5);

   QLabel *label = new QLabel(text, this);
   topLayer->addWidget(label);
   topLayer->addSpacing(10);

   m_pCheckBox = new QCheckBox(tr("Show warning next time"), this);
   m_pCheckBox->setChecked(true);
   topLayer->addWidget(m_pCheckBox);
   topLayer->addSpacing(15);

   QBoxLayout *buttonLayer = new QHBoxLayout(topLayer, 5);
   buttonLayer->addStretch();
   QPushButton *ok = new QPushButton(this);
   ok->setText(tr("Continue"));
   ok->setDefault(true);
   buttonLayer->addWidget(ok);
   buttonLayer->addStretch();
   QPushButton *cancel = new QPushButton(this);
   cancel->setText(tr("Cancel"));
   buttonLayer->addWidget(cancel);
   buttonLayer->addStretch();
   
   connect(ok, SIGNAL(clicked()), this, SLOT(accept()));
   connect(cancel, SIGNAL(clicked()), this, SLOT(reject()));
}

//----------------------------------------------------------------------------

bool WarningDlg::showWarningNextTime() {
	return m_pCheckBox->isChecked();
}

//----------------------------------------------------------------------------
