/****************************************************************************
**
** $Id: lincvs.h,v 1.20 2001/11/01 09:13:07 riemer Exp $
**
** Copyright (C) 2001 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/


#ifndef LINCVS_H_20010626
#define LINCVS_H_20010626

#include "config.h"
#include "ac_system_defs.h"


#ifdef KDE2
#include "config.h"
#include <kmainwindow.h>
#include <kmenubar.h>
#include <kpopupmenu.h>
#else
#include <qmenubar.h>
#include <qpopupmenu.h>
#include "dummykmainwindow.h"
#endif

#include <qtimer.h>
#include <qpixmap.h>

#include <qlist.h>

#include "globals.h"
#include "cvstoolbar.h"
#include "CommitDialog.h"
#include "cfg.h"

class QTabWidget;
class KToolBar;
class QToolButton;
class QMultiLineEdit;
class QListViewItem;
class QListView;
class QPixMap;
class QString;
class QStringList;
class QDialog;
class QLabel;
class CvsDirListView;
class NonCvsListView;
class CvsListView;
class Directory;
class CmdThread;
class QListView;
class ColorTabWidget;
class QSplitter;



class ApplicationWindow: public KMainWindow
{
   Q_OBJECT
public:
   ApplicationWindow();
   ~ApplicationWindow();

   QTimer   m_timer;
 
   void addProject(const char * fileName = 0, bool expand = false);

public slots:

	 void addProjectSlot();
	 void removeProjectSlot();
	 void checkStatus();

protected:

	 void closeEvent( QCloseEvent* );
	 void initMenuAndToolbar();
	 void initComponents();
	 void writeCfg();
	 void finishCheckOut();
	 void finishImport();
	 void startCvsCall(QString& command, 
			   int evaluateCommand = 0, 
			   QStringList *updateFileList = 0,
			   int Synchronous = 0);
	 void setIdle();
	 QString getNamesOfSelectedFiles();
	 QString getNameOfFirstSelectedFile();
	 void addSelectedFiles(bool bAsBinary);

	 void updateDir(bool query);
	 void updateFile(bool query);

	 void mergeDir();
	 void mergeFile();

	 void annotateDir();
	 void annotateFile();

	 void annotateGrepLineDir();
	 void annotateGrepLinesDir();
	 void annotateGrepLineFile();
	 void annotateGrepLinesFile();

protected slots:
	 void removeDirFromRep();
	 void removeDirFromRepAndDisk();
	 void checkOut();
	 void import();
	 void rereadProject();
	 void stopCurAction();
	 void killCoThread();
	 void killImportThread();
	 void killCvsThread();
	 void showDirProperties();
	 void checkCvsCallResult();
	 void checkCoResult();
	 void checkImportResult();
	 void statusDir();
	 void updateAny();
	 void mergeAny();
	 void editFile( QString);
	 void updateDir();
	 void queryUpdateDir();
	 void updateRevDir();
	 void commitAny();
	 void commitDir();
	 void annotateAny();
	 void annotateGrepLine();
	 void annotateGrepLines();
	 void tagDir();
	 void logDir();
	 void historyDir();
	 void loginDir();
	 void addFiles();
	 void addSelectedFiles();
	 void addSelectedBinFiles();
	 void statusFile();
	 void diffFile();
	 void diffFileSideBySide();
	 void renameFile();
	 void updateFile();
	 void queryUpdateFile();
	 void updateRevFile();
	 void commitFile();
	 void tagFile();
	 void logFile();
	 void historyFile();
	 void removeFile();
	 void removeFileFromRep();
	 void removeFileFromDisk();
	 void removeNonCvsFileFromDisk();
	 void progress();
	 void updateColor( int ct );
	 void AppSettings();
	 void initialDirScanning();

	 void watchAdd();
	 void watchRemove();
	 void watchOn();
	 void watchOff();
	 void cvsEditFile();
	 void cvsUneditFile();

	 void about();
	 void help();
	 void aboutQt();
    
	 void disableProjectSlot();
	 void enableProjectSlot();
	 void enableProject();
	 void startCheckStat();
	 void profiles();
   
private:

   // since this function removes the project tree, the
   // returned entry is the new allocated entry for the dir
   // with the same fullpath as the Dir argument
   Directory * rereadProjectOfDir( Directory * Dir ) ;
   void doRemoveFileFromRepOrDisk (int FromRem, int FromDisk, bool bNonCvsFile = false);
   void performRereadProject( QString S );

   QMultiLineEdit *m_pMessages;
   QSplitter *m_pHorzSplitter;
   QWidget *m_pWorkBenchPane;
   CvsDirListView *m_pWorkBenchTree;
   QSplitter *m_pVertSplitter;
   QWidget *m_pWorkFilePane;
   ColorTabWidget *m_pFileViews;
   CvsListView *m_pCvsFileList;
   NonCvsListView *m_pNonCvsFileList;

   QString          m_lastOpenedDir;
   QStringList      m_tagList;
   
   //state of checkout-import-dlg
   int              m_coImportLastAccessMethod;
   QStringList      m_coImportUser;
   QStringList      m_coImportModule;
   QStringList      m_coImportServer;
   QStringList      m_coImportRepository;
   QStringList      m_coImportLocalDir;
   QStringList      m_coImportVendorTag;
   QStringList      m_coImportReleaseTag;
   QStringList      m_coLinCVSProfile;
   QString          m_coImportLastComment;
   
   CommitDialog     *m_pCommitDlg;
   
   bool             m_uninterruptible;
   bool             m_stopAction;
   bool             m_showWarning;
   bool             m_cvsThreadIsRunning;
   bool             m_coThreadIsRunning;
   bool             m_importThreadIsRunning;

   bool             m_bExternalDiffIsRunning;  // is true if diff runs using external program for diff
   QString          m_curDiffFileName;      //used for external diff
   QString          m_curTmpDiffFileName;   //used for external diff

   Directory *m_pCurCvsDir;
   
   QTimer           m_checkCvsResultTimer;
   QTimer           m_checkCoResultTimer;
   QTimer           m_checkImportResultTimer;
   
   QLabel           *m_pStatusBarLabel;
   QLabel           *m_pProgressWidget;
   
   CmdThread        *m_pCoImportThread;
   QString          m_coImportLocalDirectory;   //for checkout
   QString          m_coModule;
   cvsToolbar       *m_pTools;
   
   QString          m_curCommentFileName;

   // Progress image related stuff
   static const unsigned int NUM_ANIM_PICS = 4;
   QPixmap m_progressIcon [NUM_ANIM_PICS];   
   int m_curPic;
   QTimer m_progressTimer;
};

//----------------------------------------------------------------------------

#endif   //LINCVS_H_20010626
