/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#ifndef LOGLIST_H_20010626
#define LOGLIST_H_20010626

#include "config.h"
#include "ac_system_defs.h"

#include <qlistview.h>
#include <qheader.h>

#include <iostream.h>


class LogListView : public QListView
{
    Q_OBJECT
    
public:
    LogListView( QWidget *parent=0, const char *name=0 );
    
    void addRevision(QString rev, QString author,
		     QString comment, QString date);

    void setSelectedPair(QString selectionA, QString selectionB);
    void setSelectionColor (const unsigned char selection, const QColor &color);
    QColor getSelectionColor (const unsigned char selection) const;

signals:
    void revisionClicked(QString rev, bool rmb);

protected:
	virtual void contentsMousePressEvent(QMouseEvent *e);

private:
	static QColor SelColor [2];
};

#endif //LOGLIST_H_20010626
