#include <syslog.h>
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>

#include "cmd_lcp3.h"
#include "lcp3.h"
#include "global_vars.h"
#include "syslog_call_from.h"

void handle_syslog_call_from()
{
	#define LINE_BUF_SIZE 1000
	static FILE* var_log_messages;
	static char vlm_name[] = "/var/log/messages";
	static char first_call = 1;
	static char *linebuf;
	static struct t_lcp3_info_isdn isdninfo = { "", "unknown", "", "", "", "" };
	char *idx;
	struct tm *ctm;
	time_t now;
	if ( !server->syslog_call_from ) return;
	if ( first_call )
	{
		first_call = 0;
		if ( !(var_log_messages = fopen(vlm_name, "r")) )
		{
			syslog(LOG_WARNING, "Unable to open %s for reading. Caller reporting disabled.", vlm_name);
			server->syslog_call_from = 0;
			return;
		}
		else
		{
			fseek(var_log_messages, 0, SEEK_END);
		}
		if ( !(linebuf = malloc(LINE_BUF_SIZE)) )
		{
			syslog(LOG_WARNING, "Unable to get %d bytes of memory. Caller reporting disabled.", LINE_BUF_SIZE);
			server->syslog_call_from = 0;
			return;
		}
	}
	while ( fgets(linebuf, LINE_BUF_SIZE, var_log_messages) )
	{
		if ( !(idx = strstr(linebuf, "call from")) ) continue;
		// get the callers number...
		*isdninfo.caller = 0;
		sscanf(idx, "call from %29s", isdninfo.caller);
		if ( !*isdninfo.caller ) continue;
		now = time(NULL);
		ctm = localtime(&now);
		snprintf(isdninfo.time, 9, "%2d:%2d:%2d", ctm->tm_hour, ctm->tm_min, ctm->tm_sec);
		snprintf(isdninfo.day, 4, "%d", ctm->tm_mday);
		snprintf(isdninfo.month, 4, "%d", ctm->tm_mon);
		snprintf(isdninfo.year, 5, "%d", ctm->tm_year);
		lcp3_cmd_broadcast(CBR3_ISDNACT, &isdninfo, sizeof(struct t_lcp3_info_isdn), NULL);
	}
}
