/***************************************************************************
                          cdemodulator.h  -  description
                             -------------------
    begin                : Sat Jun 2 2001
    copyright            : (C) 2001 by Volker Schroer
    email                : dl1ksv@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef CDEMODULATOR_H
#define CDEMODULATOR_H

#include <qobject.h>
#include <complex.h>

/**Base class for all possible types of demodulators
  *@author Volker Schroer
  */

class CDemodulator : public QObject
 {
 Q_OBJECT
public: 
	 CDemodulator();
	
	virtual ~CDemodulator();
  /** processes the input */
  virtual void ProcessInput(double *input) = 0;
	/** gets the selected frequency */
	double getRxFrequency(void);
	/** Initialises something */
	virtual bool Init(double,int) = 0;

protected:
	/** Status of AFC */
	bool UseAfc;
	/** Frequency to be received */
	double RxFrequency;

public slots: //Slots
  /** enables/ disables the use of AFC */
	virtual void	setAfc(bool);
  /** sets the frequency for the demodulator */
  virtual void setRxFrequency(double);

	
signals: // Signals
  /** Signal will be emitted if a new character was detected */
  void newSymbol(char);
	/** FastSquelch ?? */
	void setFastSquelch(bool);
	/** SquelchLevel */
	void setSquelchValue(int);
	/** Signal will be emitted if AFC is on and the RxFrequency has changed */
	void rxFrequencyChanged(double);
	/** Send Phase Value */
	void newPhaseValue(int,float_complex);
	
};

#endif
