/***************************************************************************
                          linpskview.cpp  -  description
                             -------------------
    begin                : Sat Mar  4 22:29:25 /etc/localtime 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *    based on the work of  Moe Wheatly, AE4JY                             *  
 ***************************************************************************/
#include <stdio.h>

#include "linpskview.h"
#include "fircoeffs.h"
#include "bpskdemodulator.h"
#include "pskmod.h"

LinPskView::LinPskView(QWidget *parent) : QWidget(parent)
{
QString s;
processingMacros = false;
//Preparing the use of Function Keys
functions = new QAccel(this);

// Constructing StatusBar

 statusBar=new QStatusBar(parent);
 statusBar->setFixedHeight(settings.StatusBarHeight);

//Messages
	msg=new QLabel(statusBar);
	statusBar->addWidget(msg,2,true);
	msg->setText(tr("Ready"));
//AFC- Debugging
#ifdef AFC_DEBUG
	Error = new QLabel(statusBar);
	statusBar -> addWidget(Error,1,true);
	Df = new QLabel(statusBar);
	statusBar -> addWidget(Df,1,true);
	Dp = new QLabel(statusBar);
	statusBar -> addWidget(Dp,1,true);
#endif		
	
// IMD
	IMD = new QLabel(statusBar);
	statusBar -> addWidget(IMD,1,true);
	  	

//Clockadjust
#ifndef AFC_DEBUG
	clockadj=new QLabel(statusBar);
	clockadj->setText("CLK ppm = 0");
	statusBar->addWidget(clockadj,1,true);
#endif	

// Time
	zeit=new QLabel(statusBar);
	statusBar->addWidget(zeit,1,true);

// date
  datum=new QLabel(statusBar);
	statusBar ->addWidget(datum,1,true);
  setclock();


	QTimer *clock=new QTimer(this);
 	connect(clock,SIGNAL(timeout()),SLOT(setclock()));
  clock->start(60000,false);


  controls = new CPanel(this); // Controlpanel
// Executing Macros

	connect(controls->Macros,SIGNAL(clicked(int)),this,SLOT(executeMacro(int)));
// Constructing the Tx - Display, has to be done before initializing the rx- Channels
	tx = new CTxdisplay(this);  //Editorfeld fuer tx


// Constructing the different Demodulator Channels
// and depending Rx - Windows
	initRxChannels(0,settings.RxChannels);

// Connect the active (that is the displayed) Demodulator 	to the phase display
	connect(demodulator[settings.actChannel],SIGNAL(newPhaseValue(int,float_complex)),
						controls->display,SLOT(newPhaseValue(int,float_complex)));
	 // Changing RX-Frequency by clicking in Display
   connect(controls->display,SIGNAL(rxFreqChanged(int)),this,SLOT(rxfreqchanged(int)));

//Theircall or Name
  connect(rx[settings.actChannel]->rxwindow,SIGNAL(theircallChanged(const QString &)),
  						controls,SLOT(setString(const QString &)));


// Timer
 	rxtimer = new QTimer(this);
	connect(rxtimer,SIGNAL(timeout()),this,SLOT(process_rxdata()));
	txtimer = new QTimer(this);
	connect(txtimer,SIGNAL(timeout()),this,SLOT(process_txdata()));
// For switching XMIT/RX  in Macros
//	pPSKMod=new CPSKMod();
//	connect(pPSKMod,SIGNAL(finished()),this,SLOT(start_process_loop()));

	Modulator = NULL;

// Start Receiving /Transmitting
	connect(tx->start,SIGNAL(clicked()),this,SLOT(start_process_loop()));
  functions->connectItem(functions->insertItem(Key_F5),this,SLOT(start_process_loop()));

// Tune
	connect(controls->Tune,SIGNAL(clicked()),this,SLOT(Tune()));
// Tie F8 to Tune
	functions->connectItem(functions->insertItem(Key_F8),this,SLOT(Tune()));

// Send CW ID
	connect(controls->CWID,SIGNAL(clicked()),this,SLOT(SendCWid()));
	functions->connectItem(functions->insertItem(Key_F6),this,SLOT(SendCWid()));
// Clear RxWindow
  connect(controls->Clear,SIGNAL(clicked()),rx[0],SLOT(clearWindow()));


// Tie F11 to Macro 0 (QSO- Start)
	functions->connectItem(functions->insertItem(Key_F11),this,SLOT(executeMacro0()));
// Tie F12 to Macro 1 (BTU)
	functions->connectItem(functions->insertItem(Key_F12),this,SLOT(executeMacro1()));
//Initialisation of some Variabels
			inbuf= new double[sizeof(double)*BUF_SIZE];
			dec2fir = new double[sizeof(double)*DEC2_LPFIR_LENGTH];
   		outbuf = new double[sizeof(double)*BUF_SIZE];
			if (settings.DemoMode)
				{
					if (settings.DemoTypeNumber == 1)
						sound = new WaveInput(-1);
					else
						sound = new TextInput(-1);
				}			
			else	
				sound = new CSound(settings.serial);
//			controls->display->inputdata = inbuf;
			controls->display->inputdata = outbuf;

// Sizing
		
}

LinPskView::~LinPskView()
{
}

/** Starting receiving */
void LinPskView::start_process_loop()
{

int time;
QString errorstring;


switch (settings.status)
	{
	case TX_SENDING_STATE:
	case TX_PREAMBLE_STATE:
			if ( processingMacros ) // If Processing Macros, we shouldn't switch
						return;
			
		  tx->txwindow->insertCntrlChar(TXOFF_CODE);
			break;
			
	case TX_END_STATE:
				settings.status = TX_OFF_STATE;
	case TX_POSTAMBLE_STATE:
	case TX_CWID_STATE:   // Sending CW - ID;
	case TX_TUNE_STATE:		// Tuning
											 // Stop xmitting

 			{
//				rxwindows[settings.actChannel]->updaterx('\n');
				txtimer->stop();
				
				tx->clearFocus();
				sound->close_Device();
				sound->PTT(false); //PTT off

				if (Modulator != NULL )    // Delete Modulator Class , if exists
					  {
							delete Modulator;
							Modulator = NULL;
            }
				tx->start->setStatus(OFF);
				if(settings.net &&  (rx[settings.actChannel]->getRxFrequency() != tx->getTxFrequency()))
					{
						rx[settings.actChannel]->changerxfreq(tx->getTxFrequency());

					}
				
 				
				}
    		m_pDec2InPtr=dec2fir;

				for (int i=0; i <DEC2_LPFIR_LENGTH;i++)
					dec2fir[i] = 0.0; // fill delay buffer with zero
			


				if ( sound->open_Device_read(settings.inputFilename))
					{
						if(settings.DemoMode)
		    			time= 350; // In Demomode we should get realistic Timing;
						else
							time =160;
						if (!sound->setParams(&errorstring))
							{
							QMessageBox::information(0,"LinPsk",errorstring);
						 	return;
							}
						tx->SelectRxWindow->show();		
   					rxtimer->start(time,false);		// Every 371 ms we shoud get BUF_SIZE samples in DemoMode
						msg->setText(tr("Receiving"));                             // Or we poll the soundcard
						settings.status=TX_OFF_STATE;
						tx->start->setText("TX\n(F5)");
						IMD->show();
          }

				else														//Something went wrong in Opening Input File
 						{
							msg->setText(tr("Error Starting Receiving"));
            	if (settings.DemoMode)
							QMessageBox::information(0,"LinPsk","No Samplefile for Demo selected or no File found\nPlease select File in File Menu");
    					else
							{
  							QMessageBox::critical(0,"LinPsk","Input Device not available\nProgram is terminating");
    					emit abbruch();
    					}
 						}
					
					break;

			case TX_OFF_STATE:          //Change to Xmitting;
				{
					tx->SelectRxWindow->hide();					
					rxtimer->stop();
          sound->close_Device();
					if(settings.net && (rx[settings.actChannel]->getRxFrequency() != tx->getTxFrequency()))
													tx->changetxfreq(rx[settings.actChannel]->getRxFrequency());
							
							
						
				
					sound->open_Device_write(settings.inputFilename);
					if (!sound->setParams(&errorstring))
						{
							QMessageBox::information(0,"LinPsk",errorstring);
						 	return;
						}
					
					settings.status=TX_PREAMBLE_STATE;
					switch (settings.DemodulatorType[settings.actChannel])
						{
							case BPSK:
							case QPSK:
									Modulator = new PSKModulator(11025,float(tx->getTxFrequency()),tx);
									Modulator->setMode(rx[settings.actChannel]->mode);
									break;
							case RTTY:
									Modulator = new RTTYModulator(11025,float(tx->getTxFrequency()),tx);
									break;	
						}				  	
						connect(Modulator,SIGNAL(charSend(char)),rx[settings.actChannel]->rxwindow,
																SLOT(updaterx(char))); 						
							connect(Modulator,SIGNAL(finished()),this,SLOT(start_process_loop()));
						
       		m_pDec2InPtr=dec2fir;
					for (int i=0; i <DEC2_LPFIR_LENGTH;i++)
							dec2fir[i] = 0.0; // fill delay buffer with zero
					// We should save remote call and name if return was'nt pressed
					msg->setText(tr("Transmitting"));
					
					tx->start->setText("RX\n(F5)");
					tx->start->setStatus(ON);
					tx->txwindow->setFocus();
					txtimer->start(300,false);
					txcount=BUF_SIZE;
				  sound->PTT(true);
					IMD->hide();

				}
				
				break;

				case TX_PAUSED_STATE:

				break;

	}
}

/** Reading and processing Data from
input source */

void LinPskView::process_rxdata()

{
QString s;

 if (sound->getSamples(inbuf,BUF_SIZE) == 0)
		return; 														// No sample available, try later
//if (settings.DemoMode)
//	 AddGaussian(inbuf,BUF_SIZE,5000.0);

//ProcDec2Fir( inbuf, inbuf , BUF_SIZE);	// 2uS per sample

ProcDec2Fir( inbuf, outbuf , BUF_SIZE);	// 2uS per sample
for (int channel=0;channel<settings.RxChannels;channel++)
	{
		demodulator[channel]->setRxFrequency(rx[channel]->getRxFrequency());
		if(settings.DemodulatorType[channel] != RTTY)		
			demodulator[channel]->ProcessInput(outbuf);
		else
			demodulator[channel]->ProcessInput(inbuf);
		
	}
#ifndef AFC_DEBUG	
s.sprintf(" Clk ppm = %6d",settings.clockerror);
clockadj->setText(s);
clockadj->update();
if (settings.DemodulatorType[settings.actChannel] != RTTY )
			s.sprintf(" IMD = %6.2f dB",controls->display->calcIMD());
else
	s="";

		IMD->setText(s);
		IMD->update();
	
#endif



#ifdef AFC_DEBUG
s.sprintf(" Dp0 = %6.2f dB",demodulator[settings.actChannel]->m_QFreqError);
IMD->setText(s);
IMD->update();
s.sprintf("Total=%8.5f",demodulator[settings.actChannel]->m_FreqError);
Error->setText(s);
Error->update();
s.sprintf("df=%8.5f",demodulator[settings.actChannel]->ferror);
Df->setText(s);
Df->update();
s.sprintf("dp=%8.5f",demodulator[settings.actChannel]->dp);
Dp->setText(s);
Dp->update();
#endif
controls->display->repaint(false);
}
/** Get next sample to process */

/**
Decimate by 2 FIR filter on 'BlockSize' samples.
pIn == pointer to input array of double's (can be same buffer as pOut )
pOut == pointer to output array of double's
Blocksize == number of samples to process
 */
void LinPskView::ProcDec2Fir(double *pIn, double *pOut,int BlockSize)
{
int i,j;
double acc;				
const double* Kptr;
double* Firptr;
double* Qptr;
double* Inptr;
	Inptr = m_pDec2InPtr;	//use automatic copies of member variables
	Qptr =  dec2fir;			// for better speed.
	j = 0;
	for( i = 0; i<BlockSize; i++ )	// put new samples into Queue
	{
		if( --Inptr < Qptr )		//deal with wraparound
			Inptr = Qptr+DEC2_LPFIR_LENGTH-1;
		*Inptr = pIn[i];
		if( i&1 )		//calculate MAC's every other time for decimation by 2
		{
			acc = 0.0;
			Firptr = Inptr;
			Kptr = Dec2LPCoef;
			while( Kptr < (Dec2LPCoef + DEC2_LPFIR_LENGTH) )	//do the MAC's
			{
				acc += ( (*Firptr++)*(*Kptr++) );
				if( Firptr >= Qptr+DEC2_LPFIR_LENGTH )	//deal with wraparound
					Firptr = Qptr;
			}
			pOut[j++] = acc;		//save output sample
		}
	}
	m_pDec2InPtr = Inptr;		// save position in circular delay line
}

/////////////////////////////////////////////////////////////////
// Adds n gaussian random doubles with 0 mean and std_dev = RMS = std
//    to the specified buffer
//////////////////////////////////////////////////////////////////
void LinPskView::AddGaussian(double * pData, int n, double std)
{
int i = 0;
double rad;
double r;
double u1;
double u2;
	while( i<n )
	{
// Generate two uniform random numbers between -1 and +1
// that are inside the unit circle
		do {
			u1 = 1.0 - 2.0 * (double)rand()/(double)RAND_MAX ;
			u2 = 1.0 - 2.0 * (double)rand()/(double)RAND_MAX ;
			r = u1*u1 + u2*u2;
		} while(r >= 1.0 || r == 0.0);
		rad = sqrt(-2.0*log(r)/r);
		pData[i++] += (std*u1*rad);
		pData[i++] += (std*u2*rad);
	}
}

void LinPskView::setclock()
{
	QCString s;
  QDateTime t;
  t=QDateTime::currentDateTime();
	t=t.addSecs(settings.timeoffset*3600);
	s.sprintf(" %2d:%2d UTC",t.time().hour(),t.time().minute());
	s.replace(QRegExp(": "),":0");
	zeit->setText(s);
	zeit->update();
	s.sprintf("%2d.  %s. %4d",t.date().day(),t.date().monthName(t.date().month()).data(),t.date().year());
	datum->setText(s);

}

void LinPskView::process_txdata()
{
int length;

if (txcount >0)
	length = Modulator->CalcSignal(inbuf,BUF_SIZE);
else
length = BUF_SIZE;

txcount=sound->putSamples(inbuf,length);
if (txcount >0)
	{
		ProcDec2Fir( inbuf, inbuf , BUF_SIZE);
		for (int i=0; i < BUF_SIZE/2; i++)
	 			controls->display->inputdata[i]=*(inbuf+i);
				controls->display->repaint(false);
	}
}

void LinPskView::executeMacro(int macro)
{

QString txstring;

 QFile TextFile;


switch(macro)
	{
		case 0:				// QSO Start

			if (settings.status != TX_OFF_STATE) return; // Macro switches the state
																									 //therefor we should be receiving	


				if (settings.theircall.isEmpty())
					return;    // Can only start is theircall is set

						txstring=prepareMacro(settings.Macro0);
						if (txstring.length() == 0)						// txstring empty, error in Macro?
							return;

						processingMacros=true;

						start_process_loop();
						
     				tx->txwindow->clear();
						
						sendString(txstring.data());
				
         		tx->txwindow->insertCntrlChar(TXOFF_CODE);

						break;
		case 1:         			//BTU

     				if (settings.theircall.isEmpty())
							return;    // Can only start is theircall is set
						if (settings.status != TX_SENDING_STATE) // We should be in TX- mode
							return;
							tx->txwindow->clear();
							txstring=prepareMacro(settings.Macro1);
							if (txstring.length() == 0)						// txstring empty, error in Macro?
								return;

							sendString(txstring.data());
							tx->txwindow->insertCntrlChar(TXOFF_CODE);

							break;

		case 2:					//QSO Final
						txstring=prepareMacro(settings.Macro2);
						if (txstring.length() == 0)							// txstring empty, nothing to do
							return;
            processingMacros = true;
						if ( settings.status ==  TX_OFF_STATE )
							start_process_loop();
							sendString(txstring.data());
							tx->txwindow->insertCntrlChar(TXOFF_CODE);

							break;


		case 3:				//CQ

				if (settings.status != TX_OFF_STATE) return; // Macro switches the state
																										 //therefor we should be receiving	


				if (settings.callsign ==  "")
				{
					QMessageBox::information(0,"LinPsk","Callsign not set.\n Please set your Callsign!");
					return;
				}
				processingMacros = true;
				start_process_loop();
				//tx->insertCntrlChar(TXTOG_CODE);
				txstring=prepareMacro(settings.Macro3);
				if (txstring.length() == 0)						// txstring empty, error in Macro?
							{
								processingMacros = false;
								return;
							 }

				tx->txwindow->clear();
				sendString(txstring.data());
				tx->txwindow->insertCntrlChar(TXOFF_CODE);
		//			settings.status=TX_POSTAMBLE_STATE;
			break;

	case 4:			//Send Station Text - File
				if (settings.status != TX_SENDING_STATE) // We should be in TX- mode
							return;
				processingMacros = true;
        TextFile.setName(settings.StationFile);
				if (TextFile.open(IO_ReadOnly) )
						{
							tx->txwindow->clear();
           		QTextStream line(&TextFile);
							while(!line.eof())
								{
									txstring=line.readLine();
									txstring.append("\n");
									sendString(txstring.data());
								}
							TextFile.close();
						}
             else
             QMessageBox::information(0,"LinPsk","Couldn't open StationFile");
				break;

	case 5:		//Execute UserFile

				if (settings.status != TX_SENDING_STATE) return; // We should be in TX- mode
																										
        processingMacros = true;
        TextFile.setName(settings.ButtonFile);
				if (TextFile.open(IO_ReadOnly) )
						{
							tx->txwindow->clear();

           		QTextStream line(&TextFile);
							while(!line.eof())
								{
									txstring=line.readLine();
									txstring.append("\n");
									sendString(txstring.data());
								}
							TextFile.close();
						}
             else
             QMessageBox::information(0,"LinPsk","Couldn't open UserFile");
				break;


		default:
			break;	
	}
processingMacros = false;
}

void LinPskView::sendString(const char *c)
{

int len,j,i;

						len=strlen(c);
						j=0;
						while ( (i=tx->txwindow->insertTxChar(c+j,len)) <len)
							{
								qApp->processEvents(100);
								j +=i;
								len -=i;
							}	
}


void LinPskView::executeMacro0()
{
executeMacro(0);
}
void LinPskView::executeMacro1()
{
executeMacro(1);
}

QString LinPskView::prepareMacro(QString Macro)
{

int anzahl;
int i,indexvon,indexbis;
unsigned int len;
QString s;
QString token;

// Replace possible \n

anzahl=Macro.contains("\\n",false);
indexvon=0;
for (i=0;i < anzahl; i++)
	{
	indexvon=Macro.find("\\n",indexvon,false);
	Macro.replace(indexvon,2,"\n");
	}

anzahl=Macro.contains('@',true);

if( (anzahl/2)*2 != anzahl )
	{
		s="Syntaxerror in Macro\n";
		s.append(Macro.data());
		QMessageBox::information(0,"LinPsk",s.data());
		s="";
  }
if ( anzahl == 0)
	s=Macro.copy();
else
	{
		anzahl = anzahl/2;
		indexvon = 0;
		s="";
		indexbis = Macro.find('@',indexvon,true);
		for (i=0;i < anzahl; i++)
			{
				len= indexbis-indexvon;
				if (len >0 )
					s.append(Macro.mid(indexvon,len));
				indexvon=indexbis+1;
				indexbis = Macro.find('@',indexvon,true);
				len = indexbis-indexvon;
        token = Macro.mid(indexvon,len);
				if (len >0)
					{
						if ( strcmp(token.data(),"CALLSIGN") == 0)
							s +=settings.callsign;
						if ( strcmp(token.data(),"THEIRCALL") == 0)
							s +=settings.theircall;
						if ( token == "NAME")
							s +=settings.Name;	
						if (token == "CWID" )
							settings.NeedCWid= true;
						indexvon =indexbis+1;
						indexbis = Macro.find("@",indexvon,true);	
							
					}
			}
		s.append(Macro.mid(indexvon,10000));	// Append rest of string
	}
	
return s;
}

void LinPskView::SendCWid()
{
settings.NeedCWid = true;
if (settings.status == TX_OFF_STATE )
	start_process_loop() ;
settings.status = TX_CWID_STATE;
}

void LinPskView::Tune()
{
if (settings.status == TX_OFF_STATE )
		start_process_loop();
settings.status= TX_TUNE_STATE;
}

void LinPskView::resizeEvent(QResizeEvent *e)

{

int control_height; /** Height of ControlPanel */
int rx_height; /** Height of RX- Panel */
int tx_height; /** Height of TX- Panel */
int width; /** witdh of all (Sub-) Panels */


width=this->width()-20;
control_height=(height()*38)/100; // 38% of hole height
																	// but 210 is Minimum Size for Readability of Controls
if (control_height <200)
		 control_height = 200;
		
tx_height=(height()-control_height)*30/100;
if (tx_height > 80 )
		tx_height =80; // Should be enough for TX- Window
rx_height=height()-control_height-tx_height-15;


for (int i=0;i<settings.RxChannels;i++)
 {
		rx[i]->resize(width,rx_height);

		if ( i != settings.actChannel)
		 rx[i]->hide();
	}	

tx->resize(width,tx_height);
tx->move(10,rx_height+8);

controls->setGeometry(10,tx->y()+tx->height()+7,width,control_height);

}

void LinPskView::selectRxWindow(int window)

{
if (settings.status != TX_OFF_STATE) return; // If we are not in RX- State we should not switch
																						 // the selected RX- Window 	
if (window!= settings.actChannel)
 {
	 	rx[settings.actChannel]->hide();
	 	rx[settings.actChannel]->setTheirCall(settings.theircall); // Save Call
	 	rx[settings.actChannel]->setName(settings.Name);					 // Save Name	
	 	controls->Clear->disconnect(SIGNAL(clicked()));
	 	demodulator[settings.actChannel]->disconnect(SIGNAL(newPhaseValue(int,float_complex)));
 //Theircall
	  rx[settings.actChannel]->rxwindow->disconnect(controls);
 		 connect(rx[window]->rxwindow,SIGNAL(theircallChanged(const QString &)),
  						controls,SLOT(setString(const QString &)));
	
// restore Call and Name in Panel
		controls->theircall->setText(rx[window]->theircall);
		controls->Name->setText(rx[window]->Name);		
	 	rx[window]->show();
	 	settings.actChannel=window;
	 	connect(demodulator[window],SIGNAL(newPhaseValue(int,float_complex)),
	 		controls->display,SLOT(newPhaseValue(int,float_complex)));
	 	connect(controls->Clear,SIGNAL(clicked()),rx[window],SLOT(clearWindow()));	
		controls->display->setMode(settings.DemodulatorType[window]);
	
	}
}		 	

void LinPskView::rxfreqchanged(int freq)
{
rx[settings.actChannel]->setRxFrequency(freq);
}

void LinPskView::initRxChannels(int from, int to)
{
	for (int i=from;i<to;i++)
		{
		 demodulator[i] = new BPskDemodulator();	

		 demodulator[i]->Init(double(5512.5),BUF_SIZE/2); // Should changed later to adjusted Samplerate
		 settings.DemodulatorType[i] = BPSK;
		 rx[i] = new CRxdisplay(this,i);
		 	
		 demodulator[i]->setRxFrequency(rx[i]->getRxFrequency());
		 		
			connect(demodulator[i],SIGNAL(newSymbol(char)),rx[i],SLOT(showchar(char)));
			connect(demodulator[i],SIGNAL(setFastSquelch(bool)),rx[i],SLOT(setFastSquelch(bool)));
			connect(demodulator[i],SIGNAL(setSquelchValue(int)),rx[i],SLOT(setSquelchValue(int)));
  	  connect(demodulator[i],SIGNAL(rxFrequencyChanged(double)),rx[i],SLOT(setRxFrequency(double)));

			connect(rx[i],SIGNAL(ModeChanged(Mode,int)),this,SLOT(setMode(Mode,int)));
			connect(rx[i],SIGNAL(toggleAfc(bool)),demodulator[i],SLOT(setAfc(bool)));
			// Connect the Triggers to select the appropriate Rx- Window
			connect(rx[i],SIGNAL(triggeredWindow(int)),tx->SelectRxWindow,SLOT(selectRxWindow(int)));
			// Taking the rxfrequency from the  RX- Window to the Display
			connect(rx[i],SIGNAL(rxFrequencyChanged(int,int)),controls->display,SLOT(setRxFrequency(int,int)));												

			demodulator[i]->setAfc(true);
	
		}
}
void LinPskView::stopAll()
{
txtimer->stop();
rxtimer->stop();
msg->setText("Ready");
settings.status=TX_POSTAMBLE_STATE;
if (sound != 0)
	{
				sound->close_Device();
				sound->PTT(false); //PTT off
	}			
tx->start->setStatus(OFF);

}
/** changes the Demodulator to the new Mode */
void LinPskView::setMode(Mode modus,int channel)
{
double usedFrequency;


if (demodulator[channel] != 0)
	{
		
		demodulator[channel]->disconnect();
		delete demodulator[channel];
	}
usedFrequency = rx[channel]->getRxFrequency();
switch (modus)
	{
		case QPSK:
			demodulator[channel] = new QPskDemodulator();
			break;
		case RTTY:
			demodulator[channel] = new RTTYDemodulator();
			break;	
		default:
			demodulator[channel] = new BPskDemodulator();
			break;	
	}
	settings.DemodulatorType[channel]= modus;
	controls->display->setMode(modus);
	if ( modus != RTTY )
		demodulator[channel]->Init(double(5512.5),BUF_SIZE/2);
	else
		demodulator[channel]->Init(double(11025),BUF_SIZE);
//		demodulator[channel]->Init(double(5512.5),BUF_SIZE/2);
		
	connect(demodulator[channel],SIGNAL(newSymbol(char)),rx[channel],SLOT(showchar(char)));
	connect(demodulator[channel],SIGNAL(setFastSquelch(bool)),rx[channel],SLOT(setFastSquelch(bool)));
	connect(demodulator[channel],SIGNAL(setSquelchValue(int)),rx[channel],SLOT(setSquelchValue(int)));
  connect(demodulator[channel],SIGNAL(rxFrequencyChanged(double)),rx[channel],SLOT(setRxFrequency(double)));
	connect(demodulator[channel],SIGNAL(newPhaseValue(int,float_complex)),
						controls->display,SLOT(newPhaseValue(int,float_complex)));

	connect(rx[channel],SIGNAL(toggleAfc(bool)),demodulator[channel],SLOT(setAfc(bool)));	
// Set the correct RxFrequency
	demodulator[channel]->setRxFrequency(usedFrequency);
	demodulator[channel]->setAfc(rx[channel]->getAFCsetting());
	controls->display->setRxFrequency(channel,(int)usedFrequency);
}
