/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/
#include <portaudio.h>
#include <qmessagebox.h>
#include <qwidget.h>
#include <qdir.h>
#include <qstringlist.h>

extern Parameter settings;

Parameter GeneralSettings::getSettings()
{
LocalSettings.callsign=Callsign->text();
if(Demomode->isOn() )
 {
   LocalSettings.DemoMode=true;
   LocalSettings.DemoTypeNumber=Fileformat->id(Fileformat->selected());
   LocalSettings.inputFilename="";
  }
else
   LocalSettings.DemoMode=false;
  
LocalSettings.timeoffset=UTC->value();
if( SlashedZero->isOn())
  LocalSettings.slashed0=true;
else
  LocalSettings.slashed0=false;
LocalSettings.SerialDevice=SelectedDevice->text();
LocalSettings.QSOFileName=QsoFile->text();
return LocalSettings;
}

void GeneralSettings::init()
{
PaDeviceInfo DeviceInfo;
QString Directory;
QDir dir;
//connect(Output,SIGNAL(valueChanged(int)),this,SIGNAL(OutputLevelChanged(int)));
LocalSettings = settings;    


Callsign->setText(LocalSettings.callsign);
UTC->setValue(LocalSettings.timeoffset);
SlashedZero->setChecked(LocalSettings.slashed0);

Demomode->setChecked(LocalSettings.DemoMode);

Fileformat->setButton(LocalSettings.DemoTypeNumber);
if (Demomode->isOn())
    Fileformat->show();
else
    Fileformat->hide();

//PTT
SelectedDevice->setText(LocalSettings.SerialDevice);
// First look in the /dev Directory
Directory="/dev/";

dir.setPath(Directory);
#ifndef LINPSK_FOR_MAC
QStringList Files=dir.entryList("ttyS*",QDir::Files|QDir::System,QDir::Name);
#else
QStringList Files=dir.entryList("*usbserial*",QDir::Files|QDir::System,QDir::Name);
#endif
for(QStringList::iterator Name=Files.begin();Name !=Files.end(); Name++)
 AvailableDevices->insertItem(Directory + *Name); 
#ifdef LINPSK_FOR_MAC
Files=dir.entryList("cu.*",QDir::Files|QDir::System,QDir::Name);
for(QStringList::iterator Name=Files.begin();Name !=Files.end(); Name++)
 AvailableDevices->insertItem(Directory + *Name); 
#endif
// Now check for usb devices 
Directory="/dev/usb/tts/";
dir.setPath(Directory);
Files=dir.entryList(QDir::Files|QDir::System,QDir::Name); 
 
for(QStringList::iterator Name=Files.begin();Name !=Files.end(); Name++)
 AvailableDevices->insertItem(Directory + *Name); 
InputDeviceList->setFixedHeight(60);          
if (LocalSettings.NumberofInputDevices > 0 )
 {
  for (int i=0; i < LocalSettings.NumberofInputDevices; i++)
   {
    DeviceInfo = *Pa_GetDeviceInfo( LocalSettings.InputDevices[i] );
    QString DeviceName=QString(DeviceInfo.name);
    InputDeviceList->insertItem(DeviceName);
   }
   if( LocalSettings.ActualInputDevice >=0 )
   InputDeviceList->setSelected(LocalSettings.ActualInputDevice,true); 
 }
OutputDeviceList->setFixedHeight(60); 
if (LocalSettings.NumberofOutputDevices > 0 )
 {
  for (int i=0; i < LocalSettings.NumberofOutputDevices; i++)
   {
    DeviceInfo = *Pa_GetDeviceInfo( LocalSettings.OutputDevices[i] );
    QString DeviceName=QString(DeviceInfo.name);
    OutputDeviceList->insertItem(DeviceName);
   }
   if( LocalSettings.ActualOutputDevice >=0 )
    OutputDeviceList->setSelected(LocalSettings.ActualOutputDevice,true); 
   
 }

//Output->setValue(LocalSettings.OutputVolume);
//Input->setValue(LocalSettings.InputVolume);
QsoFile->setText(LocalSettings.QSOFileName);
selectDemomode();
InputL->hide();
Input->hide();
OutputL->hide();
Output->hide();
}


void GeneralSettings::GeneralSettings_destroyed( QObject * )
{

}


void GeneralSettings::selectDemomode()
{
if (Demomode->isOn())
    {
     Fileformat->show();
     InputSection->hide();
     OutputSection->hide();
     
    } 
else
    {
     InputSection->show();
     OutputSection->show();
     Fileformat->hide();
    } 
}

void GeneralSettings::SelectInputSource( int Device )
{
LocalSettings.ActualInputDevice = Device;	
}
/**
void GeneralSettings::setInputLevel( int Level )
{
LocalSettings.InputVolume = Level;
if (LocalSettings.ActualInputDevice >= 0)
	if(setVolume(LocalSettings.InputDevices[LocalSettings.ActualInputDevice],true, Level ) !=0 )
	   QMessageBox::critical(0," Error Mixer Device for Input","Can't set Input Volume.\nCheck Permissions or use Mixer Application"); 
}

void GeneralSettings::setOutputLevel( int Level )
{
LocalSettings.OutputVolume=Level;

if (LocalSettings.ActualOutputDevice >= 0)
	if( setVolume(LocalSettings.OutputDevices[LocalSettings.ActualOutputDevice],false, Level ) != 0)
	   QMessageBox::critical(0," Error Mixer Device for Output","Can't set Output Volume.\nCheck Permissions or use Mixer Application"); 
}
**/

void GeneralSettings::selectComPort(const QString &s)
{


SelectedDevice->clear();
SelectedDevice->setText(s);
}



void GeneralSettings::SelectOutputSource(int Device)
{
LocalSettings.ActualOutputDevice=Device;
}
