#pragma interface
#ifndef IPSTUFF_H
#define IPSTUFF_H

#ifndef MISC_H
	#include "misc.h"
#endif

class IP_ADDR: public SSTRING{
protected:
	int a[4];	// By using int instead of unsigned char
			// we can differentiate network number such as
			// 10.0.0 and 10.0
	/*~PROTOBEG~ IP_ADDR */
public:
	IP_ADDR (const IP_ADDR&adr);
	IP_ADDR (const SSTRING&str);
	IP_ADDR (void);
	int cmp (const IP_ADDR *p);
	int cmp (const char *str);
	char *copyword (const char *pt);
	void increm (void);
	int is_valid (void);
	void merge (IP_ADDR&partial);
	void reformat (void);
	void reverse (void);
	void setfrom (const char *pt);
	void setrev (char *str);
	void shift (void);
	void shift_right (void);
	/*~PROTOEND~ IP_ADDR */
};

class IP_ADDRS: public ARRAY{
	/*~PROTOBEG~ IP_ADDRS */
public:
	IP_ADDR *getitem (int no)const;
	void sort (void);
	/*~PROTOEND~ IP_ADDRS */
};

class IPMAP: public ARRAY_OBJ{
	friend class IPMAPS;
	SSTRING iprange;
	IP_ADDR minimum;	// iprange is convert into a minimum/maximum
	IP_ADDR maximum;
	IP_ADDR avail;		// First available IP number in the range
	int over;			// No IP number available in the range
	SSTRING comment;
	/*~PROTOBEG~ IPMAP */
public:
	IPMAP (const char *line);
	IPMAP (void);
	const char *getcur (void);
	int next (void);
	void reset (void);
	int setup (void);
	void setuse (const IP_ADDR *adr);
	/*~PROTOEND~ IPMAP */
};


#endif

