#ifndef DHCP_API_H
#define DHCP_API_H	

#include <module_apis/dhcp_apidef.h>
static const char DHCP_API_KEY[]="dhcp";
static const char DHCP_API_REV=1;


inline DHCP_API *dhcp_api_init(const char *client)
{
	return (DHCP_API*)module_get_api (DHCP_API_KEY,DHCP_API_REV,client);
}

inline void dhcp_api_end(DHCP_API *api)
{
	module_release_api (DHCP_API_KEY,(void*)api);
}
inline bool dhcp_api_available(const char *client)
{
	return module_api_available (DHCP_API_KEY,DHCP_API_REV,client);
}

#endif

