#include <string.h>
#include <sys/stat.h>
#include "../paths.h"
#include <misc.h>
#include "xconf.h"
#include "xconf.m"


static HELP_FILE help_xconf ("xconf","intro");
static CONFIG_FILE xfconf (ETC_XF86CONFIG,help_xconf
	,CONFIGF_PROBED | CONFIGF_OPTIONNAL);
static CONFIG_FILE xfconf_x11 (ETC_X11_XF86CONFIG,help_xconf
	,CONFIGF_PROBED | CONFIGF_OPTIONNAL);
static CONFIG_FILE xaccel (ETC_XACCEL_INI,help_xconf
	,CONFIGF_PROBED | CONFIGF_OPTIONNAL);
static CONFIG_FILE xmetro (ETC_X11_XMETROCONFIG,help_xconf
	,CONFIGF_PROBED | CONFIGF_OPTIONNAL);

/*
	Try to find out if the graphic mode is minimally configured
	Return != 0 if so.
	
	status contain some explanation on what is missing.
*/
int xconf_xok (char *status)
{
	struct stat buf;
	int ret = 0;
	status[0] = '\0';
	if (!xfconf.exist()
		&& !xaccel.exist()
		&& !xfconf_x11.exist()
		&& !xmetro.exist()){
		sprintf (status,MSG_U(E_MISSCONF,"%s nor %s nor %s do exist\n")
			,xfconf.getpath(),xaccel.getpath(),xfconf_x11.getpath());
	}else if (stat(USR_BIN_X11_X,&buf)==-1){
		sprintf (status,MSG_U(E_MISSDIR,"%s or %s exist, but %s does not\n")
			,xfconf.getpath(),xaccel.getpath()
			,USR_BIN_X11_X);
	}else{
		ret = 1;
	}
	return ret;
}	
