/*b
 * Copyright (C) 2001,2002  Rick Richardson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Rick Richardson <rickr@mn.rr.com>
b*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <ncurses.h>
#include <panel.h>
#include <errno.h>
#include <time.h>
#include <sys/time.h>
#include <ctype.h>
#include <pthread.h>
#include "error.h"
#include "rc.h"
#include "streamer.h"
#include "curse.h"
#include "linuxtrade.h"
#include "minihtml.h"
#include "exthours.h"

/*
 * TODO. Oh yeah, there's bugs in here.
 */
static WINDOW	*Win;
static WINDOW	*Subwin;
static PANEL	*Panel;

static int	Cursor;		// Article line number at top of display
static int	MaxCursor;	// Maximum value for above
static int	NumLines;	// Number of lines in the article
static time_t	LastDocPoll;	// Last time we grabbed the data
static int	ValDocPoll;
static int	PageNum = 1;
static char	*Sym;
static char	*Period;
static int	NextOK;

#define	PADLINES	700

//
// TODO: make this asynchronous
//

static void
display_more(void)
{
	mvwaddch(Win, 1, getmaxx(Win)-1,
		Cursor ? ACS_UARROW : ACS_VLINE);

	mvwaddch(Win, getmaxy(Win)-2, getmaxx(Win)-1,
		(Cursor < MaxCursor) ? ACS_DARROW : ACS_VLINE);
}

static void
display_page(void)
{
	char	buf[128];

	sprintf(buf, "Page %d", PageNum);

	wattrset(Subwin, A_BOLD);
	mvwcenter(Subwin, 0, buf);
	wattrset(Subwin, A_NORMAL);
}

#define	NUMCOL	11

static TBLCOL	Col1[NUMCOL] =
{
	{  0, 99999},
	{  0, 78 },	//label
	{  0, 78 },	//
	{ 26, 26 },	//
	{ 28, 45 },	//
	{ 47, 54 },	//
	{ 54, 54 },	//
	{ 56, 73 },	//
	{ 75, 78 },	//
	{ 78, 78 },	//
	{ 0, 99999 }
};

static TBLCOL	Col2[NUMCOL] =
{
	{  0, 99999},
	{  0,  8 },	//label
	{ 10, 20 },	//value
	{ 20, 20 },	//blank
	{ 22, 30 },	//label
	{ 32, 42 },	//value
	{ 42, 42 },	//blank
	{ 44, 52 },	//label
	{ 54, 64 },	//value
	{ 64, 64 },	//blank
	{ 0, 99999 }
};

static TBLCOL	Col3[NUMCOL] =
{
	{  0, 99999},
	{  0, 21 },	//Time
	{ 23, 41 },	//Price
	{ 43, 66 },	//Volume
	{ 67, 78 },
	{ 67, 78 },
	{ 67, 78 },
	{ 67, 78 },
	{ 67, 78 },
	{ 0, 99999 },
	{ 0, 99999 }
};

static TBLCOL	*Col;

static int
prewordhook(int *tblcolp, char *wbuf,int wlen)
{
	if (Col == Col2 && strcmp(wbuf, "Pre-Market") == 0)
		return 0;
	if (Col == Col2 && strcmp(wbuf, "After") == 0)
		return 0;
	if (Col == Col2 && strcmp(wbuf, "Hours") == 0)
		return 0;
	if (*tblcolp == 1 && strcmp(wbuf, "Next") == 0)
		NextOK = TRUE;
	return wlen;
}

static int
tablehook(int tblcnt, TBLCOL **colsp, int *numcolp, int slash)
{
	if (slash)
		return tblcnt;

	switch (tblcnt)
	{
	default:
	case 1: case 2:
		//fprintf(stderr, "1st TABLE\n");
		*colsp = Col = Col1;
		break;
	case 3: case 4:
		//fprintf(stderr, "2nd TABLE\n");
		*colsp = Col = Col2;
		break;
	case 5:
		minihtml_newline(Subwin);
		//fprintf(stderr, "3rd TABLE\n");
		*colsp = Col = Col3;
		break;
	}

	return tblcnt;
}

static void
get_exthours(char *sym, char *period)
{
	FILE	*fp;
	char	buf[BUFSIZ];
	char	wbuf[BUFSIZ];
	char	*url = "http://afterhours.nasdaq-amex-online.com/asp/"
			"quotes_afterhours_frame_paging.asp?"
			"symbol=%s&selected=%s&exchange=19"
			"&pageno=%d&mktcls=&mkttype=%s";

	sprintf(wbuf, url, sym, sym, PageNum, period);
	if (Debug)
		fprintf(stderr, "URL: <%s>\n", wbuf);
	sprintf(buf, "%s \"%s\"", SUCKURL, wbuf);

	fp = popen(buf, "r");
	if (!fp)
	{
		mvwprintw(Subwin, getmaxy(Subwin)/2, 20,
				"Can't access exthours");
		touchwin(Win);
		LastDocPoll = time(NULL);
		return;
	}

	/*
	 * Eat lines until we see the table
	 */
	minihtml_skip_past_line(fp, "<body ");

	/*
	 * Parse HTML
	 */
	Col = Col1;
	NextOK = FALSE;

	minihtml_parse(Subwin, fp, Col, NUMCOL, MHP_DEFAULT,
			prewordhook, NULL, NULL, tablehook);

	pclose(fp);

	LastDocPoll = time(NULL);

	Cursor = 0;
	NumLines = getcury(Subwin) + 1;
	MaxCursor = NumLines - (getmaxy(Win) - 2);
	if (MaxCursor < 0)
		MaxCursor = 0;

	display_more();
	display_page();

	copywin(Subwin, Win,
			Cursor, 0,
			1, 1,
			getmaxy(Win)-2, getmaxx(Win)-2,
			FALSE);
	move(LINES-1, CursorX);
	update_panels();
	doupdate();
}

void
exthours_poll(void)
{
	time_t	now;

	if (!Win || !ValDocPoll)
		return;

	now = time(NULL);

	if (ValDocPoll && !Cursor && PageNum == 1
			&& now >= (LastDocPoll + ValDocPoll))
	{
		if (0)
		{
			if (strcmp(Period, "after"))
				Period = "after";
			else
				Period = "pre";
		}
		get_exthours(Sym, Period);
	}
}

void
exthours_popup(char *sym, char *period)
{
	int	n;
	int	cols;

	// Clear alert, if any
	mvprintw(1, 7, "      ");

	n = LINES - 4 - 2 - NumStock - 12;
	if (n < 24)
		n = 24;
	Win = bestwin(n);
	if (!Win)
		error(1, "Can't create exthours window\n");

	cols = getmaxx(Win);

	wbkgd(Win, Reverse ? A_REVERSE : A_NORMAL);

	box(Win, 0, 0);
	mvwcenter(Win, 0, "nasdaq.com extended hours");
	if (strcmp(period, "after") == 0)
		mvwcenter(Win, getmaxy(Win)-1, "15 minute delayed");

	//
	// Turns out, this works best for most news articles and an 80
	// column xterm. We will clip columns 78 and 79, but there are
	// only blanks there in the news articles I've seen.  For smaller
	// displays, we are screwed anyway.
	//
	Subwin = newpad(PADLINES, cols - 2);
	if (!Subwin)
		error(1, "Can't create exthours pad\n");
	wbkgd(Subwin, Reverse ? A_REVERSE : A_NORMAL);

	Panel = new_panel(Win);

	// Paint empty frame to give user some feedback
	clearok(Win, TRUE);
	update_panels(); doupdate();

	// Number of seconds between polls
	ValDocPoll = atoi(get_rc_value(RcFile, "exthours_poll"));

	PageNum = 1;
	get_exthours(Sym = sym, Period = period);
}

static void
popdown(void)
{
	hide_panel(Panel);
	update_panels();
	del_panel(Panel);
	delwin(Subwin);
	delwin(Win);
	Win = 0;
	Subwin = 0;
}

int
exthours_command(int c, STREAMER sr)
{
	MEVENT	m;

	switch (c)
	{
	case '\f':
		move(LINES-1, CursorX);
		wrefresh(curscr);
		return -1;
	case 'j':
	case KEY_DOWN:
		if (++Cursor > MaxCursor)
		{
			--Cursor;
			beep();
			break;
		}
		break;
	case 'k':
	case KEY_UP:
		if (--Cursor < 0)
		{
			++Cursor;
			beep();
			break;
		}
		break;
	case '-':
	case KEY_PPAGE:
		if (Cursor == 0)
		{
			if (PageNum > 1)
			{
				--PageNum;
				goto getnew;
			}
			else
			{
				beep();
				break;
			}
		}
		Cursor -= getmaxy(Win) - 2 - 1;
		if (Cursor < 0)
			Cursor = 0;
		break;
	case '+':
	case ' ':
	case KEY_NPAGE:
		if (Cursor == MaxCursor)
		{
			if (!NextOK)
			{
				beep();
				break;
			}
			++PageNum;
		getnew:
			Cursor = 0;
			werase(Subwin);
			copywin(Subwin, Win,
				Cursor, 0,
				1, 1,
				getmaxy(Win)-2, getmaxx(Win)-2,
				FALSE);
			// display_title();
			move(LINES-1, CursorX);
			update_panels();
			doupdate();
			get_exthours(Sym, Period);
			break;
		}
		Cursor += getmaxy(Win) - 2 - 1;
		if (Cursor > MaxCursor)
			Cursor = MaxCursor;
		break;
	case '0':
	case KEY_HOME:
		Cursor = 0;
		break;
	case '$':
	case KEY_END:
		Cursor = MaxCursor;
		break;

	case KEY_F(11):
		print_rect_troff(getbegy(Win), getbegx(Win),
				getmaxy(Win), getmaxx(Win),
				NULL, "screen.tr");
		break;
	case KEY_F(12):
	case CTRL('P'):
	case KEY_PRINT:
		print_window(Subwin, NumLines,
				get_rc_value(RcFile, "print_cmd"));
		break;

		// Change stocklist on main screen
	case '1': case '2': case '3': case '4': case '5':
	case '6': case '7': case '8': case '9':
		return 3;

	case KEY_MOUSE:
		if (getmouse(&m) != OK)
			break;

		// Ignore clicks in our window
		if (m.y >= getbegy(Win)
			&& m.y < getbegy(Win) + getmaxy(Win))
			break;

		// popdown and reprocess clicks in main window
		if (ungetmouse(&m) == OK)
			Ungetch = 1;
		popdown();
		return 2;

		// Quick switches to another popup
	case 'p':
	case 'e':
		popdown();
		return 1;

		// Regular exit
	case 033:
	case 'q':
	case 'x':
		popdown();
		return 2;
	default:
		beep();
		break;
	}

	display_more();
	copywin(Subwin, Win,
			Cursor, 0,
			1, 1,
			getmaxy(Win)-2, getmaxx(Win)-2,
			FALSE);
	move(LINES-1, CursorX);
	update_panels();
	doupdate();

	return (-1);
}
