/*b
 * Copyright (C) 2001,2002  Rick Richardson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Rick Richardson <rickr@mn.rr.com>
b*/

#define PROGNAMESTR	"linuxtrade"

// #define	SUCKURL	"wget -q -O-"
#define	SUCKURL	"curl -s -m15 " \
		"-A \"Mozilla/4.0 (compatible; MSIE 5.5; Windows 98)\""

#define	SYMLEN	15

/*
 * Alert record
 */
typedef struct
{
	char	sym[SYMLEN+1];
	int	alstate;
		#define	ALERT_DIS	0
		#define	ALERT_EN	1
		#define	ALERT_TRIG	2
	char	var;	// b=bid, a=ask, l=last, L=low, H=hi, v=vol
	char	op;	// '<' '>' '='
	float	val;	// trigger
	int	act;	// action
		#define ALERT_TERM	1
		#define	ALERT_EMAIL	2
		#define	ALERT_EXT	4
} ALERT;

#define	NUMALERT	6

/*
 * Format of a generic streamer quote record
 */
typedef struct
{
	char		sym[SYMLEN+1];
	float		bid;
	float		ask;
	float		last;
	float		close;
	unsigned int	bid_size;
	unsigned int	ask_size;
	char		bid_id;
	char		ask_id;
	long		volume;
	unsigned int	last_size;
	long		time;		// Time in seconds since midnight
	float		high, low;
	char		bid_tick;
	int		delayed;

	double		scale;		// needed by esignal.com
} QUOTE;

/*
 * Format of a generic quick quote record
 */
typedef struct
{
	char	sym[SYMLEN+1];
	float	bid, ask, last, high, low;
	int	volume, timetrade, bid_size, ask_size;
	char	bid_id, ask_id;
	float	prev_close;
	int	last_size, last_tick;
       	char	cusip[256];
	char	fullname[256];
	char	exchange;
	int	sharesout;
	char	description[256];
	int	annualdiv, divYY, divMM, divDD;
	float	high52, low52;
	int	last_eps, cur_eps, year_eps;
} QUICKQUOTE;

/*
 * Format of a generic live quote record
 */
typedef struct
{
	char	sym[SYMLEN+1];
	float	last;
	float	close;
} LIVEQUOTE;

/*
 * Format of a generic top10 record
 */
typedef struct
{
	char	sym[SYMLEN+1];
	char	market;
	int	type;
		enum {
		TOP_VOL		=	1,
		TOP_NETGAIN	=	2,
		TOP_NETLOSS	=	3,
		TOP_PCTGAIN	=	4,
		TOP_PCTLOSS	=	5
		} fodder_for_gcc_322_1;
	int	rank;
	int	volume;

	double	prev;
	double	curr;
	double	change;
} TOP10;

/*
 * Format of a generic marketmovers record
 */
typedef struct
{
	char	sym[SYMLEN+1];
	double	last;			// Last price
	double	change;			// Price change
	int	time;			// Time
	int	hilo;
		enum {
			HI_DAILY =	1,
			LO_DAILY =	2,
			HI_52 =		3,
			LO_52 =		4,
			NEAR_HI =	5,
			NEAR_LO =	6,
			NEAR_HI_52 =	7,
			NEAR_LO_52 =	8,
		} fodder_for_gcc_322_2;
	char	market;			// Market
	int	count;			// Daily count
} MKTMOVER;

/*
 * Format of a generic option chain record
 */
typedef struct
{
	char	sym[SYMLEN+1];
	int	index;
	int	count;
	char	optsym[SYMLEN+1];
	int	type;
	char	date[256];
	float	price;
} OPTCHAIN;

/*
 * Format of a generic chart record
 */

/*
 * Housekeeping records for each stock
 */
#define COMLEN	128
typedef struct
{
	char	sym[SYMLEN+1];
	int	y;
	QUOTE	old;
	QUOTE	cur;
	int	nquotes;

	// Time and Sales...
	int	tsdisplay;
	WINDOW	*tswin;
	WINDOW	*tssub;
	PANEL	*tspanel;

	// Alerts...
	ALERT	*alert[NUMALERT];
	int	nalert;
	int	alerting;

	// Holdings...
	int	nshares;		// Number of shares
	double	cost;			// Total cost

	char	comment[COMLEN+1];

	// Pressure...
	char	press_pipe[30];
	int	press_in;
	int	press_buy;
	int	press_sell;
} STOCK;

/*
 * This number MUST be kept at 128 or less. It is an abuse of the streamers
 * to increase it.
 */
#define	NUMSTOCK	128

extern STOCK	Stock[NUMSTOCK];
extern int	NumStock;
extern int	StockCursor;
extern char	StockListName[64];
extern char	StockList0Name[64];

extern char	List0[NUMSTOCK * (SYMLEN+1) + 1];
extern char	List0Comments[NUMSTOCK * (COMLEN+1) + 1];

extern int	ListNum;

extern RCFILE	RcFile[];

extern int	CursorX;
extern int	Debug;
extern int	Reverse;
extern attr_t	RevOrBold;
extern int	Ungetch;		// There is an ungotten keystroke
extern int	CursesInitted;		// Curses is running

extern int	NewStreamer;

extern int	ToolMode;
		#define	TOOL_ONECONN	1
		#define	TOOL_PERSIST	2
		#define	TOOL_ROTATE	3
		#define	TOOL_ONEQUOTE	4
		#define	TOOL_NEWS	0x10

extern	time_t	DemoTime;
extern	time_t	StDemoTime;

extern	FILE	*WriteFile;
extern	FILE	*ReadFile;

/*
 * Functions
 */
void	qfmt_init(void);
char	*volfmt6(long val);
char	*volfmt6b(long val);
char	*dolfmt9(double val);
char	*dolfmt11(double val);
char	*pctfmt7(double numer, double denom);
char	*qfmt(double val);
char	*qfmt_etime(time_t dt);

long int lrint(double x);	// Should be in math.h, but isn't

void	set_timezone(void);

STOCK	*add_from_stocklist(char *symbols, int scroll);
STOCK	*find_stock(char *sym);
int	del_stock(char *sym);
void	new_stocklist(STREAMER sr, int num, char *list, char *label);
void	copy_quote(QUOTE *qs, QUOTE *qd, QUICKQUOTE *qq, LIVEQUOTE *lq);
void	display_ts(void);
int	TsDisplayed;

WINDOW	*minmaxwin(int minh, int maxh, int anchorbot, int right);
WINDOW	*bestwin(int lines);
WINDOW	*bestrightwin(int lines, int anchorbot);

void	display_title(void);
void	display_alert(STOCK *sp, int on);
void	display_msg(attr_t attr, char *fmt, ...);
void	display_prompt(attr_t attr, char *fmt, ...);
void	display_stock_cursor(STOCK *sp, int on);
void	display_status(STREAMER sr, int online);

void	set_color(int y, int x, int wid, double new, double old,
		attr_t ahigh, attr_t aequal, attr_t alow);

void	leave_cursor(void);

void	external_msg(char *prog, char *sym, char *arg);

void	launch_url(char *url_pref, char *sym);

void	all_charts_from_list(char *options, char *list);
void	all_charts_from_array(char *options);
void	add_comments(char *comments);

/*
 * Display a quote value
 *
 * tradetype:
 * 	0 = nosale
 * 	1 = regular sale
 * 	2 = offhours sale???
 */
void	display_quote(QUOTE *q, int tradetype);
void	display_top10(TOP10 *t10);
void	display_mktmover(MKTMOVER *mm);
void	display_scrollnews(char *sym, char *link, char *headline,
				time_t tim, char *src, int insertat);

void	display_livequote(LIVEQUOTE *lqp);

#ifndef max
	#define max(A,B)	( ((A) > (B)) ? (A) : (B) )
#endif

#ifndef asizeof
	#define asizeof(A)	( sizeof(A)/sizeof(A[0]) )
#endif

/*
 * Colors
 */
#define	GREENonBG	1	// Is green or blue, depending on BG
#define	REDonBG		2
#define	YELLOWonBLACK	3
#define	GREENonRED	4
#define	REDonGREEN	5
#define	CYANonBLACK	6
#define	REDonWHITE	7
#define	BLUEonWHITE	8
#define	REDonBLACK	9
#define	BLACKonGREEN	10
#define	BLACKonRED	11
#define	BLACKonYELLOW	12
#define	BLACKonCYAN	13
