/*b
 * Copyright (C) 2001,2002  Rick Richardson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Rick Richardson <rickr@mn.rr.com>
b*/

/*
 * Display the Quotemedia Level II book
 *
 * Incomplete.
 *
 * TODO: replace the linear search/insert/delete with a linked list
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <ncurses.h>
#include <panel.h>
#include <errno.h>
#include <time.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include "curse.h"
#include "error.h"
#include "rc.h"
#include "streamer.h"
#include "linuxtrade.h"
#include "qml2.h"
#include "p2open.h"
#include "util.h"

static WINDOW	*Win;
static WINDOW	*Hdrwin;
static WINDOW	*Subwin;
static PANEL	*Panel;
static char	Symbol[SYMLEN+1];

/*
 * Book
 */
#define MMLEN	8

typedef struct
{
	char	mmid[MMLEN+1];
	double	price;
	int	size;
	int	tick;
} BOOKE;

#define		NUMBOOK	2000
#define		NUMSET	5

typedef struct
{
	int	num;
	int	size;
} SET;

typedef struct
{
	int	num;		// num orders
	int	total;		// total size
	SET	set[NUMSET];
	BOOKE	ent[NUMBOOK];
} BOOK;

static BOOK	Ask, Bid;

static attr_t SetColors[NUMSET] =
{
	COLOR_PAIR(BLACKonGREEN),
	COLOR_PAIR(BLACKonYELLOW),
	COLOR_PAIR(BLACKonCYAN),
	A_REVERSE|COLOR_PAIR(REDonWHITE),
	A_REVERSE|COLOR_PAIR(BLUEonWHITE)
};

/*
 * Stream buffer
 */
static int	Fd = -1;
static FILE	*Fp[2] = {NULL,NULL};
static int	DataState = 0;
static int	TsNum;
static int	BidCnt, AskCnt, TsCnt;

int
qml2_open(void)
{
	int	rc;

	rc = p2open("/bin/bash", PROGNAMESTR ".qm L2 2>/dev/null", Fp);
	if (rc < 0)
	{
		if (Debug)
			fprintf(stderr, "qml2_open failed\n");
		return (-1);
	}
	if (Debug)
		fprintf(stderr, "qml2_open OK\n");

	fprintf(Fp[1], "rcfile\n");
	fprintf(Fp[1], "%s\n", Symbol);
	fflush(Fp[1]);

	Fd = fileno(Fp[0]);

	Bid.num = Ask.num = 0;
	DataState = 0;

	return (Fd);
}

int
qml2_fd(void)
{
	return (Fd);
}

static void
calc_bar(BOOK *b)
{
	int	i;
	int	n = -1;
	double	lastprice = -1;

	b->total = 0;
	for (i = 0; i < b->num; ++i)
	{
		BOOKE	*e = &b->ent[i];

		b->total += e->size * 100;
		if (n < (NUMSET-1) && e->price != lastprice)
		{
			++n;
			lastprice = e->price;
			b->set[n].size = e->size*100;
			b->set[n].num = 1;
		}
		else
		{
			b->set[n].size += e->size*100;
			++b->set[n].num;
		}
	}
	while (++n < NUMSET)
	{
		b->set[n].size = 0;
		b->set[n].num = 0;
	}
}

static void
disp_bar(void)
{
	int	i, x;
	int	total;
	int	barcols = (getmaxx(Hdrwin) - 1) & ~1;
	int	bidcols, askcols;

	calc_bar(&Ask);
	calc_bar(&Bid);

	total = Ask.total + Bid.total;

	wblankrect(Hdrwin, 1, 0, 1, getmaxx(Hdrwin)-1, FALSE);
	if (total == 0)
	{
		return;
	}
	else if (Ask.total == 0)
	{
		askcols = 0;
		bidcols = barcols;
	}
	else if (Bid.total == 0)
	{
		bidcols = 0;
		askcols = barcols;
	}
	else
	{
		bidcols = lrint((double)barcols * Bid.total / total);
		askcols = lrint((double)barcols * Ask.total / total);
	}

	wattrset(Hdrwin, A_REVERSE);
	mvwaddch(Hdrwin, 1, bidcols, ACS_VLINE);

	if (bidcols)
	{
		x = bidcols;
		for (i = 0; i < NUMSET; ++i)
		{
			int	cols;

			cols = lrint((double)bidcols * Bid.set[i].size
							/ Bid.total);
			if (cols == 0 && Bid.set[i].size)
				cols = 1;

			wattrset(Hdrwin, SetColors[i]);
			while (cols--)
				mvwaddch(Hdrwin, 1, --x, ' ');
		}
	}

	if (askcols)
	{
		x = bidcols;
		for (i = 0; i < NUMSET; ++i)
		{
			int	cols;

			cols = lrint((double)askcols * Ask.set[i].size
							/ Ask.total);
			if (cols == 0 && Ask.set[i].size)
				cols = 1;

			wattrset(Hdrwin, SetColors[i]);
			while (cols--)
				mvwaddch(Hdrwin, 1, ++x, ' ');
		}
	}
	wattrset(Hdrwin, A_NORMAL);
}

static void
disp_book(BOOK *b)
{
	int	y, x;
	int	maxy = getmaxy(Subwin) - 1;
	int	n = -1;
	double	lastprice = -1;
	int	incnt = 0;
	int	insize = 0;
	int	remain = 0;

	x = (b == &Bid) ? 0 : getmaxx(Subwin)/3;

	for (y = 0; y <= maxy; ++y)
	{
		BOOKE	*e = &b->ent[y];

		remain = b->num - maxy;
		if (y == maxy && remain > 1)
			break;

		if (y < b->num)
		{
			if (e->price != lastprice)
			{
				if (++n == NUMSET) n = NUMSET - 1;
				lastprice = e->price;
			}
			if (n == 0)
			{
				++incnt;
				insize += e->size;
			}
			wattrset(Subwin, SetColors[n]);
			if (e->price < 1.0)
				mvwprintw(Subwin, y, x,
					"%-5.5s %7.3f %4d",
					e->mmid, e->price, e->size);
			else
				mvwprintw(Subwin, y, x,
					"%-5.5s %7.2f %4d",
					e->mmid, e->price, e->size);
		}
		else
			mvwprintw(Subwin, y, x, "%*s", getmaxx(Subwin)/2, "");
		wattrset(Subwin, A_NORMAL);
	}

	if (remain > 0)
		mvwprintw(Subwin, y, x, "%d more", remain);
	else
		mvwprintw(Subwin, y, x, "          ");

	disp_bar();
}

void
qml2_data(void)
{
	char	buf[BUFSIZ];
	char	*p;
	int	rc;

	char	mmid[32];
	char	time[32];
	double	price;
	int	size;
	int	tick;
	int	unk;

	if (Fd < 0 || !Fp[0])
		return;

	for (;;)
	{
again:
		if (fgets(buf, sizeof(buf), Fp[0]) == NULL)
		{
			mvwprintw(Hdrwin, 2, 0, "Error reading qml2");
			p2kill(Fp);
			Fd = -1;
			Fp[0] = Fp[1] = NULL;
			goto out;
		}
		p = strchr(buf, '\n'); if (p) *p = 0;
		p = strchr(buf, '\r'); if (p) *p = 0;

		if (Debug >= 5)
		{
			fprintf(stderr, "%d:	<%s>\n", DataState, buf);
		}

		if (strncmp(buf, "MARKER", 6) == 0)
		{
			if (0)
				mvwprintw(Win, getmaxy(Win)-1, getmaxx(Win)-10,
				buf[6] ? "delayed " : "realtime");
			DataState = 0;
			if (!FRcnt(Fp[0]))
				break;
			else
				goto again;
		}

		switch (DataState)
		{
		case 0:
			// First line is current quote...
			// SYM,???,
			// SUNW,0,5.010,5.010,0.000,0.000,0.000,0.000,0
			DataState = 1;
			break;
		case 1:
			// Second line is counts
			rc = sscanf(buf, "%d,%d,%d",
					&Bid.num, &Ask.num, &TsNum);
			if (rc != 3)
			{
			eatem:
				DataState = 99;
				break;
			}
			DataState = 2;
			BidCnt = AskCnt = TsCnt = 0;
			break;
		case 2:
			// Bid lines
			rc = sscanf(buf, "%[^,],%lf,%d,%d",
					mmid, &price, &size, &tick);
			if (rc != 4)
				goto eatem;
			if (BidCnt < NUMBOOK)
			{
				strncpy(Bid.ent[BidCnt].mmid, mmid, MMLEN);
				Bid.ent[BidCnt].mmid[MMLEN] = 0;
				Bid.ent[BidCnt].price = price;
				Bid.ent[BidCnt].size = size;
				Bid.ent[BidCnt].tick = tick;
			}
			if (++BidCnt == Bid.num)
				DataState = 3;
			break;
		case 3:
			// Ask lines
			rc = sscanf(buf, "%[^,],%lf,%d,%d",
					mmid, &price, &size, &tick);
			if (rc != 4)
				goto eatem;
			if (AskCnt < NUMBOOK)
			{
				strncpy(Ask.ent[AskCnt].mmid, mmid, MMLEN);
				Bid.ent[AskCnt].mmid[MMLEN] = 0;
				Ask.ent[AskCnt].price = price;
				Ask.ent[AskCnt].size = size;
				Ask.ent[AskCnt].tick = tick;
			}
			if (++AskCnt == Ask.num)
			{
				DataState = 4;
				disp_book(&Bid);
				disp_book(&Ask);
			}
			break;
		case 4:
			// T&S lines
			// PRICE,TICK,SIZE,DATE,UNK
			rc = sscanf(buf, "%lf,%d,%d,%[^,],%d",
					&price, &tick, &size, time, &unk);
			if (rc != 5)
				goto eatem;

			if (tick > 0)
				wattrset(Subwin, COLOR_PAIR(1) | A_NORMAL);
			else if (tick < 0)
				wattrset(Subwin, COLOR_PAIR(2) | A_NORMAL);
			else
				wattrset(Subwin, A_NORMAL);

			qfmt_init();
			if (price < 1.0)
				mvwprintw(Subwin, TsCnt, getmaxx(Subwin)*2/3,
					"%7.3f %-6.6s %8.8s",
					price, volfmt6b(size), time);
			else
				mvwprintw(Subwin, TsCnt, getmaxx(Subwin)*2/3,
					"%7.2f %-6.6s %8.8s",
					price, volfmt6b(size), time);

			if (++TsCnt == TsNum)
				DataState = 99;
			break;
		case 99:
			// Eat lines until MARKER
			break;
		}

		// If stdio has no more data in its buffers, then
		// return.  The next select() will call us later.
		if (!FRcnt(Fp[0]))
			break;
	}

out:
	touchwin(Win);
	update_panels(); refresh(); // doupdate();
}

void
qml2_popup(STOCK *sp)
{
	char	*title = "quotemedia.com Level II";

	Win = bestwin(36);
	if (!Win)
		error(1, "Can't create qml2 window\n");

	wbkgd(Win, Reverse ? A_REVERSE : A_NORMAL);

	box(Win, 0, 0);

	wattrset(Win, A_BOLD);
	mvwprintw(Win, 0, 3, "%s", sp->sym);
	mvwprintw(Win, 0, getmaxx(Win)-strlen(title)-3, title);
	wattrset(Win, A_NORMAL);

	Hdrwin = derwin(Win, 4, getmaxx(Win) - 2, 1, 1);
	if (!Hdrwin)
		error(1, "Can't create qml2 hdrwindow\n");

	Subwin = derwin(Win,
			getmaxy(Win) - 2 - getmaxy(Hdrwin), getmaxx(Win) - 2,
			1 + getmaxy(Hdrwin), 1);
	if (!Subwin)
		error(1, "Can't create qml2 subwindow\n");

	strcpy(Symbol, sp->sym);

	wattrset(Hdrwin, A_BOLD);
	mvwprintw(Hdrwin, getmaxy(Hdrwin) - 1, 0,
			"MMID BidPrice Size");
	mvwprintw(Hdrwin, getmaxy(Hdrwin) - 1, getmaxx(Hdrwin)/3,
			"MMID AskPrice Size");
	mvwprintw(Hdrwin, getmaxy(Hdrwin) - 1, 2*getmaxx(Hdrwin)/3,
			"  Price   Size Time....");
	wattrset(Hdrwin, A_NORMAL);

	Panel = new_panel(Win);

	attrset(A_BOLD);
	mvprintw(LINES-1, 0,
		"*** Please Wait - opening connection to qml2.  ");
	attrset(A_NORMAL);
	update_panels(); refresh(); // doupdate();

	Fd = qml2_open();
	if (Fd < 0)
	{
		mvwprintw(Subwin, 1, 0, "Can't open qml2 streamer");
		goto out;
	}
	if (Debug)
		fprintf(stderr, "qml2 fd = %d\n", qml2_fd());

out:
	blankrect(LINES-1, 0, LINES-1, COLS-1, 0);
	touchwin(Win);
}

static void
popdown(void)
{
	if (Fd >= 0)
	{
		p2kill(Fp);
		Fd = -1;
		Fp[0] = Fp[1] = NULL;
	}

	hide_panel(Panel);
	update_panels();
	del_panel(Panel);
	delwin(Hdrwin);
	delwin(Subwin);
	delwin(Win);
}

int
qml2_command(int c, STREAMER sr)
{
	MEVENT	m;

	switch (c)
	{
	case KEY_MOUSE:
		if (getmouse(&m) != OK)
			break;

		// Ignore clicks in our window
		if (m.y >= getbegy(Win)
			&& m.y < getbegy(Win) + getmaxy(Win))
			break;

		// popdown and reprocess clicks in main window
		if (ungetmouse(&m) == OK)
			Ungetch = 1;
		popdown();
		return 2;

	case KEY_F(11):
		if (1) print_rect_troff(getbegy(Win), getbegx(Win),
				getmaxy(Win), getmaxx(Win),
				NULL, "screen.tr");
		break;

	default:
		popdown();
		return 2;
	}
	return 0;
}
