/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/*****************************************************************************/
/* Liquid War is a unique multiplayer wargame                                */
/* Copyright (C) 1998-2002 Christian Mauduit                                 */
/*                                                                           */
/* This program is free software; you can redistribute it and/or modify      */
/* it under the terms of the GNU General Public License as published by      */
/* the Free Software Foundation; either version 2 of the License, or         */
/* (at your option) any later version.                                       */
/*                                                                           */
/* This program is distributed in the hope that it will be useful,           */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/* GNU General Public License for more details.                              */
/*                                                                           */
/* You should have received a copy of the GNU General Public License         */
/* along with this program; if not, write to the Free Software               */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
/*                                                                           */
/* Liquid War homepage : http://www.ufoot.org/liquidwar                      */
/* Contact author      : ufoot@ufoot.org                                     */
/*****************************************************************************/

/********************************************************************/
/* name          : netgame.c                                        */
/* contenu       : netgame menu, where the client joins the server  */
/* last update   : April 15th 2001                                  */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <stdio.h>

#include "back.h"
#include "base.h"
#include "config.h"
#include "decal.h"
#include "dialog.h"
#include "help.h"
#include "menu.h"
#include "play.h"
#include "disk.h"
#include "protocol.h"
#include "sockgen.h"
#include "server.h"
#include "network.h"
#include "keyexch.h"
#include "error.h"

/*==================================================================*/
/* globals                                                          */
/*==================================================================*/

/*==================================================================*/
/* static functions                                                 */
/*==================================================================*/

static int connect_on_server(int *sock, char *ip, int port);

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
int network_game (void)
{
  DIALOG d[15];
  int choix=4,retour=0;
  char bufport[BUFFER_EDIT_NUMBER +1];
  int sock;

  sprintf(bufport,"%d",CONFIG_SERVER_PORT);
  while (retour==0)
    {
      standard_button (d+4,0,0,1,6);
      standard_button (d+5,0,2,2,6);
      standard_button (d+6,0,4,2,6);
      standard_button (d+7,0,5,2,6);
      standard_button (d+8,1,2,2,6);
      standard_button (d+9,1,4,2,6);
      standard_button (d+10,1,5,2,6);
      standard_button (d+11,1,2,2,6);
      standard_button (d+12,1,4,2,6);
      standard_button (d+13,1,5,2,6);

      quick_buttons(d);
      d[4].dp="Start game";
      d[5].dp="Nickname";
      d[5].proc=my_textbox_proc;
      d[6].dp="Server addr";
      d[6].proc=my_textbox_proc;
      d[7].dp="Server port";
      d[7].proc=my_textbox_proc;
      d[8].dp="";
      d[8].proc=my_textbox_proc;
      d[9].dp="";
      d[9].proc=my_textbox_proc;
      d[10].dp="";
      d[10].proc=my_textbox_proc;
      d[11].dp=CONFIG_NICKNAME;
      d[11].d1=NICKNAME_SIZE;
      d[11].x++;
      d[11].y++;
      d[11].w-=2;
      d[11].h-=2;
      d[11].proc=my_edit_proc;
      d[12].dp=CONFIG_SERVER_ADDRESS;
      d[12].d1=SERVER_ADDRESS_SIZE;
      d[12].proc=my_edit_proc;
      d[12].x++;
      d[12].y++;
      d[12].w-=2;
      d[12].h-=2;
      d[13].dp=bufport;
      d[13].d1=BUFFER_EDIT_NUMBER;
      d[13].proc=my_edit_proc;
      d[13].x++;
      d[13].y++;
      d[13].w-=2;
      d[13].h-=2;
      d[11].d2=d[12].d2=d[13].d2=0;
      d[14].proc=0;

      choix=my_do_dialog (d,choix);

      CONFIG_SERVER_PORT=atoi(bufport);

      switch (choix)
	{
	case -1:
	case MENU_QUICK_BACK:
	  retour=1;
	  break;
	case MENU_QUICK_MAIN:
	  retour=MENU_TOP;
	  break;
	case MENU_QUICK_QUIT:
	  if (confirm_quit())
	    retour=MENU_EXIT;
	  else
	    display_back_image();
	  break;
	case MENU_QUICK_HELP:
	  retour=display_help (HELP_TEXT_NETGAME);
	  display_back_image ();
	  break;
	case 4:
	  if (connect_on_server(&sock,
				CONFIG_SERVER_ADDRESS,
				CONFIG_SERVER_PORT))
	    {
	      LW_NETWORK_ON=1;
	      lw_network_attribute_colors();
	      lw_network_attribute_parts();
	      retour=play_sequence ();
	      LW_NETWORK_ON=0;
	      lw_sock_close(sock);
	    }
	  else
	    retour=0;
	  break;
	}
    }

  if (retour>0)
    retour--;

  return retour;
}

/*------------------------------------------------------------------*/
/*
 * Opens the socket on the server, sends some messages to the server,
 * and displays message boxes to the player so that he has an idea
 * of what's going on.
 */
static int connect_on_server(int *sock, char *address, int port)
{
  int result=0;
  int free_teams;
  int i;

  (*sock)=-1;

  display_center_message ("Connect...");
  if (!lw_sock_connect(sock,address,port))
    {
      error_unable_to_connect();
    }
  else
    {
      display_center_message ("Setup 1/2.");
      if (!lw_protocol_do_ping(*sock))
	{
	  error_not_a_liquidwar_server();
	}
      else
	{
	  display_center_message ("Setup 1/2..");
	  if (!lw_protocol_tell_program(*sock,LW_PROGRAM))
	    {
	      error_not_a_liquidwar_server();
	    }
	  else
	    {
	      display_center_message ("Setup 1/2...");
	      if (!lw_protocol_tell_version(*sock,LW_VERSION))
		{
		  error_wrong_version();
		}
	      else
		{
		  display_center_message ("Setup 1/2....");
		  if (!lw_protocol_tell_nickname(*sock,CONFIG_NICKNAME))
		    {
		      error_network_problem();
		    }
		  else
		    {
		      display_center_message ("Setup 1/2.....");
		      if (!lw_protocol_ask_free_teams(*sock,&free_teams))
			{
			  error_network_problem();
			}
		      else
			{
			  result=1;

			  display_center_message ("Setup 1/2......");
			  for (i=0;i<NB_TEAMS && free_teams>0 && result==1;++i)
			    {
			      if (CONFIG_TEAM_COLOR[i]>0)
				{
				  if (lw_protocol_reserve_team(*sock,i))
				    {
				      free_teams--;
				    }
				  else
				    {
				      result=0;
				      error_network_problem();
				    }
				}
			    }

			  if (result==1)
			    {
			      display_center_message ("Setup 1/2.......");
			      if (!lw_protocol_send_config
				  (*sock))
				{
				  result=0;
				  error_network_problem();
				}
			    }

			  if (result==1)
			    {
			      display_center_message ("Send map...");
			      if (!lw_protocol_send_map
				  (*sock,RAW_MAP_ORDERED[CONFIG_LEVEL_MAP]))
				{
				  result=0;
				  error_cant_send_map();
				}
			    }

			  if (result==1)
			    {
			      display_center_message ("Waiting...");
			      if (!lw_protocol_i_am_ready(*sock))
				{
				  result=0;
				  error_network_problem();
				}
			      else
				{
				  display_center_message ("Setup 2/2.");
				  for (i=0;i<NB_TEAMS && result==1;++i)
				    {
				      if (!lw_protocol_ask_who
					  (*sock,i,&(LW_NETWORK_INFO[i])))
					{
					  result=0;
					  error_network_problem();
					}
				    }

				  display_center_message ("Setup 2/2..");
				  if (result==1)
				    {
				      if (!lw_protocol_recv_config
					  (*sock))
					{
					  result=0;
					  error_network_problem();
					}
				    }

				  display_center_message ("Receive map...");
				  if (result==1)
				    {
				      if (!lw_protocol_recv_map
					  (*sock,&LW_NETWORK_RAW_MAP))
					{
					  result=0;
					  error_cant_receive_map();
					}
				    }

				  if (result==1)
				    {
				      display_center_message ("Waiting...");
				      if (!lw_protocol_i_am_ready(*sock))
					{
					  result=0;
					  error_network_problem();
					}
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }

  /*
   * if the operation succeded, we set the global value LW_KEYEXCH_SOCK
   * to the right socket, otherwise functions from lw_keyech won't work...
   */
  if (result)
    {
      LW_KEYEXCH_SOCK=*sock;
    }
  else
    {
      lw_sock_close(*sock);
    }
  

  return result;
}
