// RUN: llvm-mc -triple x86_64-unknown-unknown -mcpu=knl -mattr=+avx512vbmi2 -mattr=+avx512vl --show-encoding < %s | FileCheck %s

// CHECK: vpexpandb %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0x7d,0x08,0x62,0xcb]
          vpexpandb %xmm3, %xmm1

// CHECK: vpexpandw %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0xfd,0x08,0x62,0xcb]
          vpexpandw %xmm3, %xmm1

// CHECK: vpexpandb %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0x7d,0x08,0x62,0xef]
          vpexpandb %xmm23, %xmm21

// CHECK: vpexpandw %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0xfd,0x08,0x62,0xef]
          vpexpandw %xmm23, %xmm21

// CHECK: vpexpandb %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x7d,0x0a,0x62,0xcb]
          vpexpandb %xmm3, %xmm1 {%k2}

// CHECK: vpexpandw %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xfd,0x0a,0x62,0xcb]
          vpexpandw %xmm3, %xmm1 {%k2}

// CHECK: vpexpandb %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x0a,0x62,0xef]
          vpexpandb %xmm23, %xmm21 {%k2}

// CHECK: vpexpandw %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x0a,0x62,0xef]
          vpexpandw %xmm23, %xmm21 {%k2}

// CHECK: vpexpandb  (%rcx), %xmm1
// CHECK: encoding: [0x62,0xf2,0x7d,0x08,0x62,0x09]
          vpexpandb  (%rcx), %xmm1

// CHECK: vpexpandb  -4(%rsp), %xmm1
// CHECK: encoding: [0x62,0xf2,0x7d,0x08,0x62,0x4c,0x24,0xfc]
          vpexpandb  -4(%rsp), %xmm1

// CHECK: vpexpandb  4(%rsp), %xmm1
// CHECK: encoding: [0x62,0xf2,0x7d,0x08,0x62,0x4c,0x24,0x04]
          vpexpandb  4(%rsp), %xmm1

// CHECK: vpexpandb  268435456(%rcx,%r14,8), %xmm1
// CHECK: encoding: [0x62,0xb2,0x7d,0x08,0x62,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpexpandb  268435456(%rcx,%r14,8), %xmm1

// CHECK: vpexpandb  -536870912(%rcx,%r14,8), %xmm1
// CHECK: encoding: [0x62,0xb2,0x7d,0x08,0x62,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpexpandb  -536870912(%rcx,%r14,8), %xmm1

// CHECK: vpexpandb  -536870910(%rcx,%r14,8), %xmm1
// CHECK: encoding: [0x62,0xb2,0x7d,0x08,0x62,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpexpandb  -536870910(%rcx,%r14,8), %xmm1

// CHECK: vpexpandw  (%rcx), %xmm1
// CHECK: encoding: [0x62,0xf2,0xfd,0x08,0x62,0x09]
          vpexpandw  (%rcx), %xmm1

// CHECK: vpexpandw  -8(%rsp), %xmm1
// CHECK: encoding: [0x62,0xf2,0xfd,0x08,0x62,0x4c,0x24,0xfc]
          vpexpandw  -8(%rsp), %xmm1

// CHECK: vpexpandw  8(%rsp), %xmm1
// CHECK: encoding: [0x62,0xf2,0xfd,0x08,0x62,0x4c,0x24,0x04]
          vpexpandw  8(%rsp), %xmm1

// CHECK: vpexpandw  268435456(%rcx,%r14,8), %xmm1
// CHECK: encoding: [0x62,0xb2,0xfd,0x08,0x62,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpexpandw  268435456(%rcx,%r14,8), %xmm1

// CHECK: vpexpandw  -536870912(%rcx,%r14,8), %xmm1
// CHECK: encoding: [0x62,0xb2,0xfd,0x08,0x62,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpexpandw  -536870912(%rcx,%r14,8), %xmm1

// CHECK: vpexpandw  -536870910(%rcx,%r14,8), %xmm1
// CHECK: encoding: [0x62,0xb2,0xfd,0x08,0x62,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpexpandw  -536870910(%rcx,%r14,8), %xmm1

// CHECK: vpexpandb  (%rcx), %xmm21
// CHECK: encoding: [0x62,0xe2,0x7d,0x08,0x62,0x29]
          vpexpandb  (%rcx), %xmm21

// CHECK: vpexpandb  -4(%rsp), %xmm21
// CHECK: encoding: [0x62,0xe2,0x7d,0x08,0x62,0x6c,0x24,0xfc]
          vpexpandb  -4(%rsp), %xmm21

// CHECK: vpexpandb  4(%rsp), %xmm21
// CHECK: encoding: [0x62,0xe2,0x7d,0x08,0x62,0x6c,0x24,0x04]
          vpexpandb  4(%rsp), %xmm21

// CHECK: vpexpandb  268435456(%rcx,%r14,8), %xmm21
// CHECK: encoding: [0x62,0xa2,0x7d,0x08,0x62,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpexpandb  268435456(%rcx,%r14,8), %xmm21

// CHECK: vpexpandb  -536870912(%rcx,%r14,8), %xmm21
// CHECK: encoding: [0x62,0xa2,0x7d,0x08,0x62,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpexpandb  -536870912(%rcx,%r14,8), %xmm21

// CHECK: vpexpandb  -536870910(%rcx,%r14,8), %xmm21
// CHECK: encoding: [0x62,0xa2,0x7d,0x08,0x62,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpexpandb  -536870910(%rcx,%r14,8), %xmm21

// CHECK: vpexpandw  (%rcx), %xmm21
// CHECK: encoding: [0x62,0xe2,0xfd,0x08,0x62,0x29]
          vpexpandw  (%rcx), %xmm21

// CHECK: vpexpandw  -8(%rsp), %xmm21
// CHECK: encoding: [0x62,0xe2,0xfd,0x08,0x62,0x6c,0x24,0xfc]
          vpexpandw  -8(%rsp), %xmm21

// CHECK: vpexpandw  8(%rsp), %xmm21
// CHECK: encoding: [0x62,0xe2,0xfd,0x08,0x62,0x6c,0x24,0x04]
          vpexpandw  8(%rsp), %xmm21

// CHECK: vpexpandw  268435456(%rcx,%r14,8), %xmm21
// CHECK: encoding: [0x62,0xa2,0xfd,0x08,0x62,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpexpandw  268435456(%rcx,%r14,8), %xmm21

// CHECK: vpexpandw  -536870912(%rcx,%r14,8), %xmm21
// CHECK: encoding: [0x62,0xa2,0xfd,0x08,0x62,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpexpandw  -536870912(%rcx,%r14,8), %xmm21

// CHECK: vpexpandw  -536870910(%rcx,%r14,8), %xmm21
// CHECK: encoding: [0x62,0xa2,0xfd,0x08,0x62,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpexpandw  -536870910(%rcx,%r14,8), %xmm21

// CHECK: vpexpandb  (%rcx), %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x7d,0x0a,0x62,0x09]
          vpexpandb  (%rcx), %xmm1 {%k2}

// CHECK: vpexpandb  -4(%rsp), %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x7d,0x0a,0x62,0x4c,0x24,0xfc]
          vpexpandb  -4(%rsp), %xmm1 {%k2}

// CHECK: vpexpandb  4(%rsp), %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x7d,0x0a,0x62,0x4c,0x24,0x04]
          vpexpandb  4(%rsp), %xmm1 {%k2}

// CHECK: vpexpandb  268435456(%rcx,%r14,8), %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0x7d,0x0a,0x62,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpexpandb  268435456(%rcx,%r14,8), %xmm1 {%k2}

// CHECK: vpexpandb  -536870912(%rcx,%r14,8), %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0x7d,0x0a,0x62,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpexpandb  -536870912(%rcx,%r14,8), %xmm1 {%k2}

// CHECK: vpexpandb  -536870910(%rcx,%r14,8), %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0x7d,0x0a,0x62,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpexpandb  -536870910(%rcx,%r14,8), %xmm1 {%k2}

// CHECK: vpexpandw  (%rcx), %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xfd,0x0a,0x62,0x09]
          vpexpandw  (%rcx), %xmm1 {%k2}

// CHECK: vpexpandw  -8(%rsp), %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xfd,0x0a,0x62,0x4c,0x24,0xfc]
          vpexpandw  -8(%rsp), %xmm1 {%k2}

// CHECK: vpexpandw  8(%rsp), %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xfd,0x0a,0x62,0x4c,0x24,0x04]
          vpexpandw  8(%rsp), %xmm1 {%k2}

// CHECK: vpexpandw  268435456(%rcx,%r14,8), %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xfd,0x0a,0x62,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpexpandw  268435456(%rcx,%r14,8), %xmm1 {%k2}

// CHECK: vpexpandw  -536870912(%rcx,%r14,8), %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xfd,0x0a,0x62,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpexpandw  -536870912(%rcx,%r14,8), %xmm1 {%k2}

// CHECK: vpexpandw  -536870910(%rcx,%r14,8), %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xfd,0x0a,0x62,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpexpandw  -536870910(%rcx,%r14,8), %xmm1 {%k2}

// CHECK: vpexpandb  (%rcx), %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0x7d,0x0a,0x62,0x29]
          vpexpandb  (%rcx), %xmm21 {%k2}

// CHECK: vpexpandb  -4(%rsp), %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0x7d,0x0a,0x62,0x6c,0x24,0xfc]
          vpexpandb  -4(%rsp), %xmm21 {%k2}

// CHECK: vpexpandb  4(%rsp), %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0x7d,0x0a,0x62,0x6c,0x24,0x04]
          vpexpandb  4(%rsp), %xmm21 {%k2}

// CHECK: vpexpandb  268435456(%rcx,%r14,8), %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x0a,0x62,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpexpandb  268435456(%rcx,%r14,8), %xmm21 {%k2}

// CHECK: vpexpandb  -536870912(%rcx,%r14,8), %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x0a,0x62,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpexpandb  -536870912(%rcx,%r14,8), %xmm21 {%k2}

// CHECK: vpexpandb  -536870910(%rcx,%r14,8), %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x0a,0x62,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpexpandb  -536870910(%rcx,%r14,8), %xmm21 {%k2}

// CHECK: vpexpandw  (%rcx), %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xfd,0x0a,0x62,0x29]
          vpexpandw  (%rcx), %xmm21 {%k2}

// CHECK: vpexpandw  -8(%rsp), %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xfd,0x0a,0x62,0x6c,0x24,0xfc]
          vpexpandw  -8(%rsp), %xmm21 {%k2}

// CHECK: vpexpandw  8(%rsp), %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xfd,0x0a,0x62,0x6c,0x24,0x04]
          vpexpandw  8(%rsp), %xmm21 {%k2}

// CHECK: vpexpandw  268435456(%rcx,%r14,8), %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x0a,0x62,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpexpandw  268435456(%rcx,%r14,8), %xmm21 {%k2}

// CHECK: vpexpandw  -536870912(%rcx,%r14,8), %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x0a,0x62,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpexpandw  -536870912(%rcx,%r14,8), %xmm21 {%k2}

// CHECK: vpexpandw  -536870910(%rcx,%r14,8), %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x0a,0x62,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpexpandw  -536870910(%rcx,%r14,8), %xmm21 {%k2}

// CHECK: vpexpandb %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0x7d,0x28,0x62,0xcb]
          vpexpandb %ymm3, %ymm1

// CHECK: vpexpandw %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0xfd,0x28,0x62,0xcb]
          vpexpandw %ymm3, %ymm1

// CHECK: vpexpandb %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0x7d,0x28,0x62,0xef]
          vpexpandb %ymm23, %ymm21

// CHECK: vpexpandw %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0xfd,0x28,0x62,0xef]
          vpexpandw %ymm23, %ymm21

// CHECK: vpexpandb %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x7d,0x2a,0x62,0xcb]
          vpexpandb %ymm3, %ymm1 {%k2}

// CHECK: vpexpandw %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xfd,0x2a,0x62,0xcb]
          vpexpandw %ymm3, %ymm1 {%k2}

// CHECK: vpexpandb %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x2a,0x62,0xef]
          vpexpandb %ymm23, %ymm21 {%k2}

// CHECK: vpexpandw %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x2a,0x62,0xef]
          vpexpandw %ymm23, %ymm21 {%k2}

// CHECK: vpexpandb  (%rcx), %ymm1
// CHECK: encoding: [0x62,0xf2,0x7d,0x28,0x62,0x09]
          vpexpandb  (%rcx), %ymm1

// CHECK: vpexpandb  -4(%rsp), %ymm1
// CHECK: encoding: [0x62,0xf2,0x7d,0x28,0x62,0x4c,0x24,0xfc]
          vpexpandb  -4(%rsp), %ymm1

// CHECK: vpexpandb  4(%rsp), %ymm1
// CHECK: encoding: [0x62,0xf2,0x7d,0x28,0x62,0x4c,0x24,0x04]
          vpexpandb  4(%rsp), %ymm1

// CHECK: vpexpandb  268435456(%rcx,%r14,8), %ymm1
// CHECK: encoding: [0x62,0xb2,0x7d,0x28,0x62,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpexpandb  268435456(%rcx,%r14,8), %ymm1

// CHECK: vpexpandb  -536870912(%rcx,%r14,8), %ymm1
// CHECK: encoding: [0x62,0xb2,0x7d,0x28,0x62,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpexpandb  -536870912(%rcx,%r14,8), %ymm1

// CHECK: vpexpandb  -536870910(%rcx,%r14,8), %ymm1
// CHECK: encoding: [0x62,0xb2,0x7d,0x28,0x62,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpexpandb  -536870910(%rcx,%r14,8), %ymm1

// CHECK: vpexpandw  (%rcx), %ymm1
// CHECK: encoding: [0x62,0xf2,0xfd,0x28,0x62,0x09]
          vpexpandw  (%rcx), %ymm1

// CHECK: vpexpandw  -8(%rsp), %ymm1
// CHECK: encoding: [0x62,0xf2,0xfd,0x28,0x62,0x4c,0x24,0xfc]
          vpexpandw  -8(%rsp), %ymm1

// CHECK: vpexpandw  8(%rsp), %ymm1
// CHECK: encoding: [0x62,0xf2,0xfd,0x28,0x62,0x4c,0x24,0x04]
          vpexpandw  8(%rsp), %ymm1

// CHECK: vpexpandw  268435456(%rcx,%r14,8), %ymm1
// CHECK: encoding: [0x62,0xb2,0xfd,0x28,0x62,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpexpandw  268435456(%rcx,%r14,8), %ymm1

// CHECK: vpexpandw  -536870912(%rcx,%r14,8), %ymm1
// CHECK: encoding: [0x62,0xb2,0xfd,0x28,0x62,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpexpandw  -536870912(%rcx,%r14,8), %ymm1

// CHECK: vpexpandw  -536870910(%rcx,%r14,8), %ymm1
// CHECK: encoding: [0x62,0xb2,0xfd,0x28,0x62,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpexpandw  -536870910(%rcx,%r14,8), %ymm1

// CHECK: vpexpandb  (%rcx), %ymm21
// CHECK: encoding: [0x62,0xe2,0x7d,0x28,0x62,0x29]
          vpexpandb  (%rcx), %ymm21

// CHECK: vpexpandb  -4(%rsp), %ymm21
// CHECK: encoding: [0x62,0xe2,0x7d,0x28,0x62,0x6c,0x24,0xfc]
          vpexpandb  -4(%rsp), %ymm21

// CHECK: vpexpandb  4(%rsp), %ymm21
// CHECK: encoding: [0x62,0xe2,0x7d,0x28,0x62,0x6c,0x24,0x04]
          vpexpandb  4(%rsp), %ymm21

// CHECK: vpexpandb  268435456(%rcx,%r14,8), %ymm21
// CHECK: encoding: [0x62,0xa2,0x7d,0x28,0x62,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpexpandb  268435456(%rcx,%r14,8), %ymm21

// CHECK: vpexpandb  -536870912(%rcx,%r14,8), %ymm21
// CHECK: encoding: [0x62,0xa2,0x7d,0x28,0x62,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpexpandb  -536870912(%rcx,%r14,8), %ymm21

// CHECK: vpexpandb  -536870910(%rcx,%r14,8), %ymm21
// CHECK: encoding: [0x62,0xa2,0x7d,0x28,0x62,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpexpandb  -536870910(%rcx,%r14,8), %ymm21

// CHECK: vpexpandw  (%rcx), %ymm21
// CHECK: encoding: [0x62,0xe2,0xfd,0x28,0x62,0x29]
          vpexpandw  (%rcx), %ymm21

// CHECK: vpexpandw  -8(%rsp), %ymm21
// CHECK: encoding: [0x62,0xe2,0xfd,0x28,0x62,0x6c,0x24,0xfc]
          vpexpandw  -8(%rsp), %ymm21

// CHECK: vpexpandw  8(%rsp), %ymm21
// CHECK: encoding: [0x62,0xe2,0xfd,0x28,0x62,0x6c,0x24,0x04]
          vpexpandw  8(%rsp), %ymm21

// CHECK: vpexpandw  268435456(%rcx,%r14,8), %ymm21
// CHECK: encoding: [0x62,0xa2,0xfd,0x28,0x62,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpexpandw  268435456(%rcx,%r14,8), %ymm21

// CHECK: vpexpandw  -536870912(%rcx,%r14,8), %ymm21
// CHECK: encoding: [0x62,0xa2,0xfd,0x28,0x62,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpexpandw  -536870912(%rcx,%r14,8), %ymm21

// CHECK: vpexpandw  -536870910(%rcx,%r14,8), %ymm21
// CHECK: encoding: [0x62,0xa2,0xfd,0x28,0x62,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpexpandw  -536870910(%rcx,%r14,8), %ymm21

// CHECK: vpexpandb  (%rcx), %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x7d,0x2a,0x62,0x09]
          vpexpandb  (%rcx), %ymm1 {%k2}

// CHECK: vpexpandb  -4(%rsp), %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x7d,0x2a,0x62,0x4c,0x24,0xfc]
          vpexpandb  -4(%rsp), %ymm1 {%k2}

// CHECK: vpexpandb  4(%rsp), %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x7d,0x2a,0x62,0x4c,0x24,0x04]
          vpexpandb  4(%rsp), %ymm1 {%k2}

// CHECK: vpexpandb  268435456(%rcx,%r14,8), %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0x7d,0x2a,0x62,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpexpandb  268435456(%rcx,%r14,8), %ymm1 {%k2}

// CHECK: vpexpandb  -536870912(%rcx,%r14,8), %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0x7d,0x2a,0x62,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpexpandb  -536870912(%rcx,%r14,8), %ymm1 {%k2}

// CHECK: vpexpandb  -536870910(%rcx,%r14,8), %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0x7d,0x2a,0x62,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpexpandb  -536870910(%rcx,%r14,8), %ymm1 {%k2}

// CHECK: vpexpandw  (%rcx), %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xfd,0x2a,0x62,0x09]
          vpexpandw  (%rcx), %ymm1 {%k2}

// CHECK: vpexpandw  -8(%rsp), %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xfd,0x2a,0x62,0x4c,0x24,0xfc]
          vpexpandw  -8(%rsp), %ymm1 {%k2}

// CHECK: vpexpandw  8(%rsp), %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xfd,0x2a,0x62,0x4c,0x24,0x04]
          vpexpandw  8(%rsp), %ymm1 {%k2}

// CHECK: vpexpandw  268435456(%rcx,%r14,8), %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xfd,0x2a,0x62,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpexpandw  268435456(%rcx,%r14,8), %ymm1 {%k2}

// CHECK: vpexpandw  -536870912(%rcx,%r14,8), %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xfd,0x2a,0x62,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpexpandw  -536870912(%rcx,%r14,8), %ymm1 {%k2}

// CHECK: vpexpandw  -536870910(%rcx,%r14,8), %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xfd,0x2a,0x62,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpexpandw  -536870910(%rcx,%r14,8), %ymm1 {%k2}

// CHECK: vpexpandb  (%rcx), %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0x7d,0x2a,0x62,0x29]
          vpexpandb  (%rcx), %ymm21 {%k2}

// CHECK: vpexpandb  -4(%rsp), %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0x7d,0x2a,0x62,0x6c,0x24,0xfc]
          vpexpandb  -4(%rsp), %ymm21 {%k2}

// CHECK: vpexpandb  4(%rsp), %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0x7d,0x2a,0x62,0x6c,0x24,0x04]
          vpexpandb  4(%rsp), %ymm21 {%k2}

// CHECK: vpexpandb  268435456(%rcx,%r14,8), %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x2a,0x62,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpexpandb  268435456(%rcx,%r14,8), %ymm21 {%k2}

// CHECK: vpexpandb  -536870912(%rcx,%r14,8), %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x2a,0x62,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpexpandb  -536870912(%rcx,%r14,8), %ymm21 {%k2}

// CHECK: vpexpandb  -536870910(%rcx,%r14,8), %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x2a,0x62,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpexpandb  -536870910(%rcx,%r14,8), %ymm21 {%k2}

// CHECK: vpexpandw  (%rcx), %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xfd,0x2a,0x62,0x29]
          vpexpandw  (%rcx), %ymm21 {%k2}

// CHECK: vpexpandw  -8(%rsp), %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xfd,0x2a,0x62,0x6c,0x24,0xfc]
          vpexpandw  -8(%rsp), %ymm21 {%k2}

// CHECK: vpexpandw  8(%rsp), %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xfd,0x2a,0x62,0x6c,0x24,0x04]
          vpexpandw  8(%rsp), %ymm21 {%k2}

// CHECK: vpexpandw  268435456(%rcx,%r14,8), %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x2a,0x62,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpexpandw  268435456(%rcx,%r14,8), %ymm21 {%k2}

// CHECK: vpexpandw  -536870912(%rcx,%r14,8), %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x2a,0x62,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpexpandw  -536870912(%rcx,%r14,8), %ymm21 {%k2}

// CHECK: vpexpandw  -536870910(%rcx,%r14,8), %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x2a,0x62,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpexpandw  -536870910(%rcx,%r14,8), %ymm21 {%k2}

// CHECK: vpcompressb %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0x7d,0x08,0x63,0xd9]
          vpcompressb %xmm3, %xmm1

// CHECK: vpcompressw %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0xfd,0x08,0x63,0xd9]
          vpcompressw %xmm3, %xmm1

// CHECK: vpcompressb %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0x7d,0x08,0x63,0xfd]
          vpcompressb %xmm23, %xmm21

// CHECK: vpcompressw %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0xfd,0x08,0x63,0xfd]
          vpcompressw %xmm23, %xmm21

// CHECK: vpcompressb %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x7d,0x0a,0x63,0xd9]
          vpcompressb %xmm3, %xmm1 {%k2}

// CHECK: vpcompressw %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xfd,0x0a,0x63,0xd9]
          vpcompressw %xmm3, %xmm1 {%k2}

// CHECK: vpcompressb %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x0a,0x63,0xfd]
          vpcompressb %xmm23, %xmm21 {%k2}

// CHECK: vpcompressw %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x0a,0x63,0xfd]
          vpcompressw %xmm23, %xmm21 {%k2}

// CHECK: vpcompressb  %xmm1, (%rcx)
// CHECK: encoding: [0x62,0xf2,0x7d,0x08,0x63,0x09]
          vpcompressb  %xmm1, (%rcx)

// CHECK: vpcompressb  %xmm1, -4(%rsp)
// CHECK: encoding: [0x62,0xf2,0x7d,0x08,0x63,0x4c,0x24,0xfc]
          vpcompressb  %xmm1, -4(%rsp)

// CHECK: vpcompressb  %xmm1, 4(%rsp)
// CHECK: encoding: [0x62,0xf2,0x7d,0x08,0x63,0x4c,0x24,0x04]
          vpcompressb  %xmm1, 4(%rsp)

// CHECK: vpcompressb  %xmm1, 268435456(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0x7d,0x08,0x63,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpcompressb  %xmm1, 268435456(%rcx,%r14,8)

// CHECK: vpcompressb  %xmm1, -536870912(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0x7d,0x08,0x63,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpcompressb  %xmm1, -536870912(%rcx,%r14,8)

// CHECK: vpcompressb  %xmm1, -536870910(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0x7d,0x08,0x63,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpcompressb  %xmm1, -536870910(%rcx,%r14,8)

// CHECK: vpcompressw  %xmm1, (%rcx)
// CHECK: encoding: [0x62,0xf2,0xfd,0x08,0x63,0x09]
          vpcompressw  %xmm1, (%rcx)

// CHECK: vpcompressw  %xmm1, -8(%rsp)
// CHECK: encoding: [0x62,0xf2,0xfd,0x08,0x63,0x4c,0x24,0xfc]
          vpcompressw  %xmm1, -8(%rsp)

// CHECK: vpcompressw  %xmm1, 8(%rsp)
// CHECK: encoding: [0x62,0xf2,0xfd,0x08,0x63,0x4c,0x24,0x04]
          vpcompressw  %xmm1, 8(%rsp)

// CHECK: vpcompressw  %xmm1, 268435456(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0xfd,0x08,0x63,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpcompressw  %xmm1, 268435456(%rcx,%r14,8)

// CHECK: vpcompressw  %xmm1, -536870912(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0xfd,0x08,0x63,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpcompressw  %xmm1, -536870912(%rcx,%r14,8)

// CHECK: vpcompressw  %xmm1, -536870910(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0xfd,0x08,0x63,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpcompressw  %xmm1, -536870910(%rcx,%r14,8)

// CHECK: vpcompressb  %xmm21, (%rcx) {%k2}
// CHECK: encoding: [0x62,0xe2,0x7d,0x0a,0x63,0x29]
          vpcompressb  %xmm21, (%rcx) {%k2}

// CHECK: vpcompressb  %xmm21, -4(%rsp) {%k2}
// CHECK: encoding: [0x62,0xe2,0x7d,0x0a,0x63,0x6c,0x24,0xfc]
          vpcompressb  %xmm21, -4(%rsp) {%k2}

// CHECK: vpcompressb  %xmm21, 4(%rsp) {%k2}
// CHECK: encoding: [0x62,0xe2,0x7d,0x0a,0x63,0x6c,0x24,0x04]
          vpcompressb  %xmm21, 4(%rsp) {%k2}

// CHECK: vpcompressb  %xmm21, 268435456(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x0a,0x63,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpcompressb  %xmm21, 268435456(%rcx,%r14,8) {%k2}

// CHECK: vpcompressb  %xmm21, -536870912(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x0a,0x63,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpcompressb  %xmm21, -536870912(%rcx,%r14,8) {%k2}

// CHECK: vpcompressb  %xmm21, -536870910(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x0a,0x63,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpcompressb  %xmm21, -536870910(%rcx,%r14,8) {%k2}

// CHECK: vpcompressw  %xmm21, (%rcx) {%k2}
// CHECK: encoding: [0x62,0xe2,0xfd,0x0a,0x63,0x29]
          vpcompressw  %xmm21, (%rcx) {%k2}

// CHECK: vpcompressw  %xmm21, -8(%rsp) {%k2}
// CHECK: encoding: [0x62,0xe2,0xfd,0x0a,0x63,0x6c,0x24,0xfc]
          vpcompressw  %xmm21, -8(%rsp) {%k2}

// CHECK: vpcompressw  %xmm21, 8(%rsp) {%k2}
// CHECK: encoding: [0x62,0xe2,0xfd,0x0a,0x63,0x6c,0x24,0x04]
          vpcompressw  %xmm21, 8(%rsp) {%k2}

// CHECK: vpcompressw  %xmm21, 268435456(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x0a,0x63,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpcompressw  %xmm21, 268435456(%rcx,%r14,8) {%k2}

// CHECK: vpcompressw  %xmm21, -536870912(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x0a,0x63,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpcompressw  %xmm21, -536870912(%rcx,%r14,8) {%k2}

// CHECK: vpcompressw  %xmm21, -536870910(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x0a,0x63,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpcompressw  %xmm21, -536870910(%rcx,%r14,8) {%k2}

// CHECK: vpcompressb  %xmm1, (%rcx)
// CHECK: encoding: [0x62,0xf2,0x7d,0x08,0x63,0x09]
          vpcompressb  %xmm1, (%rcx)

// CHECK: vpcompressb  %xmm1, -4(%rsp)
// CHECK: encoding: [0x62,0xf2,0x7d,0x08,0x63,0x4c,0x24,0xfc]
          vpcompressb  %xmm1, -4(%rsp)

// CHECK: vpcompressb  %xmm1, 4(%rsp)
// CHECK: encoding: [0x62,0xf2,0x7d,0x08,0x63,0x4c,0x24,0x04]
          vpcompressb  %xmm1, 4(%rsp)

// CHECK: vpcompressb  %xmm1, 268435456(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0x7d,0x08,0x63,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpcompressb  %xmm1, 268435456(%rcx,%r14,8)

// CHECK: vpcompressb  %xmm1, -536870912(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0x7d,0x08,0x63,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpcompressb  %xmm1, -536870912(%rcx,%r14,8)

// CHECK: vpcompressb  %xmm1, -536870910(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0x7d,0x08,0x63,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpcompressb  %xmm1, -536870910(%rcx,%r14,8)

// CHECK: vpcompressw  %xmm1, (%rcx)
// CHECK: encoding: [0x62,0xf2,0xfd,0x08,0x63,0x09]
          vpcompressw  %xmm1, (%rcx)

// CHECK: vpcompressw  %xmm1, -8(%rsp)
// CHECK: encoding: [0x62,0xf2,0xfd,0x08,0x63,0x4c,0x24,0xfc]
          vpcompressw  %xmm1, -8(%rsp)

// CHECK: vpcompressw  %xmm1, 8(%rsp)
// CHECK: encoding: [0x62,0xf2,0xfd,0x08,0x63,0x4c,0x24,0x04]
          vpcompressw  %xmm1, 8(%rsp)

// CHECK: vpcompressw  %xmm1, 268435456(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0xfd,0x08,0x63,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpcompressw  %xmm1, 268435456(%rcx,%r14,8)

// CHECK: vpcompressw  %xmm1, -536870912(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0xfd,0x08,0x63,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpcompressw  %xmm1, -536870912(%rcx,%r14,8)

// CHECK: vpcompressw  %xmm1, -536870910(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0xfd,0x08,0x63,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpcompressw  %xmm1, -536870910(%rcx,%r14,8)

// CHECK: vpcompressb  %xmm21, (%rcx) {%k2}
// CHECK: encoding: [0x62,0xe2,0x7d,0x0a,0x63,0x29]
          vpcompressb  %xmm21, (%rcx) {%k2}

// CHECK: vpcompressb  %xmm21, -4(%rsp) {%k2}
// CHECK: encoding: [0x62,0xe2,0x7d,0x0a,0x63,0x6c,0x24,0xfc]
          vpcompressb  %xmm21, -4(%rsp) {%k2}

// CHECK: vpcompressb  %xmm21, 4(%rsp) {%k2}
// CHECK: encoding: [0x62,0xe2,0x7d,0x0a,0x63,0x6c,0x24,0x04]
          vpcompressb  %xmm21, 4(%rsp) {%k2}

// CHECK: vpcompressb  %xmm21, 268435456(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x0a,0x63,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpcompressb  %xmm21, 268435456(%rcx,%r14,8) {%k2}

// CHECK: vpcompressb  %xmm21, -536870912(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x0a,0x63,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpcompressb  %xmm21, -536870912(%rcx,%r14,8) {%k2}

// CHECK: vpcompressb  %xmm21, -536870910(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x0a,0x63,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpcompressb  %xmm21, -536870910(%rcx,%r14,8) {%k2}

// CHECK: vpcompressw  %xmm21, (%rcx) {%k2}
// CHECK: encoding: [0x62,0xe2,0xfd,0x0a,0x63,0x29]
          vpcompressw  %xmm21, (%rcx) {%k2}

// CHECK: vpcompressw  %xmm21, -8(%rsp) {%k2}
// CHECK: encoding: [0x62,0xe2,0xfd,0x0a,0x63,0x6c,0x24,0xfc]
          vpcompressw  %xmm21, -8(%rsp) {%k2}

// CHECK: vpcompressw  %xmm21, 8(%rsp) {%k2}
// CHECK: encoding: [0x62,0xe2,0xfd,0x0a,0x63,0x6c,0x24,0x04]
          vpcompressw  %xmm21, 8(%rsp) {%k2}

// CHECK: vpcompressw  %xmm21, 268435456(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x0a,0x63,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpcompressw  %xmm21, 268435456(%rcx,%r14,8) {%k2}

// CHECK: vpcompressw  %xmm21, -536870912(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x0a,0x63,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpcompressw  %xmm21, -536870912(%rcx,%r14,8) {%k2}

// CHECK: vpcompressw  %xmm21, -536870910(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x0a,0x63,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpcompressw  %xmm21, -536870910(%rcx,%r14,8) {%k2}

// CHECK: vpcompressb %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0x7d,0x28,0x63,0xd9]
          vpcompressb %ymm3, %ymm1

// CHECK: vpcompressw %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0xfd,0x28,0x63,0xd9]
          vpcompressw %ymm3, %ymm1

// CHECK: vpcompressb %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0x7d,0x28,0x63,0xfd]
          vpcompressb %ymm23, %ymm21

// CHECK: vpcompressw %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0xfd,0x28,0x63,0xfd]
          vpcompressw %ymm23, %ymm21

// CHECK: vpcompressb %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x7d,0x2a,0x63,0xd9]
          vpcompressb %ymm3, %ymm1 {%k2}

// CHECK: vpcompressw %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xfd,0x2a,0x63,0xd9]
          vpcompressw %ymm3, %ymm1 {%k2}

// CHECK: vpcompressb %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x2a,0x63,0xfd]
          vpcompressb %ymm23, %ymm21 {%k2}

// CHECK: vpcompressw %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x2a,0x63,0xfd]
          vpcompressw %ymm23, %ymm21 {%k2}

// CHECK: vpcompressb  %ymm1, (%rcx)
// CHECK: encoding: [0x62,0xf2,0x7d,0x28,0x63,0x09]
          vpcompressb  %ymm1, (%rcx)

// CHECK: vpcompressb  %ymm1, -4(%rsp)
// CHECK: encoding: [0x62,0xf2,0x7d,0x28,0x63,0x4c,0x24,0xfc]
          vpcompressb  %ymm1, -4(%rsp)

// CHECK: vpcompressb  %ymm1, 4(%rsp)
// CHECK: encoding: [0x62,0xf2,0x7d,0x28,0x63,0x4c,0x24,0x04]
          vpcompressb  %ymm1, 4(%rsp)

// CHECK: vpcompressb  %ymm1, 268435456(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0x7d,0x28,0x63,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpcompressb  %ymm1, 268435456(%rcx,%r14,8)

// CHECK: vpcompressb  %ymm1, -536870912(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0x7d,0x28,0x63,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpcompressb  %ymm1, -536870912(%rcx,%r14,8)

// CHECK: vpcompressb  %ymm1, -536870910(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0x7d,0x28,0x63,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpcompressb  %ymm1, -536870910(%rcx,%r14,8)

// CHECK: vpcompressw  %ymm1, (%rcx)
// CHECK: encoding: [0x62,0xf2,0xfd,0x28,0x63,0x09]
          vpcompressw  %ymm1, (%rcx)

// CHECK: vpcompressw  %ymm1, -8(%rsp)
// CHECK: encoding: [0x62,0xf2,0xfd,0x28,0x63,0x4c,0x24,0xfc]
          vpcompressw  %ymm1, -8(%rsp)

// CHECK: vpcompressw  %ymm1, 8(%rsp)
// CHECK: encoding: [0x62,0xf2,0xfd,0x28,0x63,0x4c,0x24,0x04]
          vpcompressw  %ymm1, 8(%rsp)

// CHECK: vpcompressw  %ymm1, 268435456(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0xfd,0x28,0x63,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpcompressw  %ymm1, 268435456(%rcx,%r14,8)

// CHECK: vpcompressw  %ymm1, -536870912(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0xfd,0x28,0x63,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpcompressw  %ymm1, -536870912(%rcx,%r14,8)

// CHECK: vpcompressw  %ymm1, -536870910(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0xfd,0x28,0x63,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpcompressw  %ymm1, -536870910(%rcx,%r14,8)

// CHECK: vpcompressb  %ymm21, (%rcx) {%k2}
// CHECK: encoding: [0x62,0xe2,0x7d,0x2a,0x63,0x29]
          vpcompressb  %ymm21, (%rcx) {%k2}

// CHECK: vpcompressb  %ymm21, -4(%rsp) {%k2}
// CHECK: encoding: [0x62,0xe2,0x7d,0x2a,0x63,0x6c,0x24,0xfc]
          vpcompressb  %ymm21, -4(%rsp) {%k2}

// CHECK: vpcompressb  %ymm21, 4(%rsp) {%k2}
// CHECK: encoding: [0x62,0xe2,0x7d,0x2a,0x63,0x6c,0x24,0x04]
          vpcompressb  %ymm21, 4(%rsp) {%k2}

// CHECK: vpcompressb  %ymm21, 268435456(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x2a,0x63,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpcompressb  %ymm21, 268435456(%rcx,%r14,8) {%k2}

// CHECK: vpcompressb  %ymm21, -536870912(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x2a,0x63,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpcompressb  %ymm21, -536870912(%rcx,%r14,8) {%k2}

// CHECK: vpcompressb  %ymm21, -536870910(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x2a,0x63,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpcompressb  %ymm21, -536870910(%rcx,%r14,8) {%k2}

// CHECK: vpcompressw  %ymm21, (%rcx) {%k2}
// CHECK: encoding: [0x62,0xe2,0xfd,0x2a,0x63,0x29]
          vpcompressw  %ymm21, (%rcx) {%k2}

// CHECK: vpcompressw  %ymm21, -8(%rsp) {%k2}
// CHECK: encoding: [0x62,0xe2,0xfd,0x2a,0x63,0x6c,0x24,0xfc]
          vpcompressw  %ymm21, -8(%rsp) {%k2}

// CHECK: vpcompressw  %ymm21, 8(%rsp) {%k2}
// CHECK: encoding: [0x62,0xe2,0xfd,0x2a,0x63,0x6c,0x24,0x04]
          vpcompressw  %ymm21, 8(%rsp) {%k2}

// CHECK: vpcompressw  %ymm21, 268435456(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x2a,0x63,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpcompressw  %ymm21, 268435456(%rcx,%r14,8) {%k2}

// CHECK: vpcompressw  %ymm21, -536870912(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x2a,0x63,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpcompressw  %ymm21, -536870912(%rcx,%r14,8) {%k2}

// CHECK: vpcompressw  %ymm21, -536870910(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x2a,0x63,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpcompressw  %ymm21, -536870910(%rcx,%r14,8) {%k2}

// CHECK: vpcompressb  %ymm1, (%rcx)
// CHECK: encoding: [0x62,0xf2,0x7d,0x28,0x63,0x09]
          vpcompressb  %ymm1, (%rcx)

// CHECK: vpcompressb  %ymm1, -4(%rsp)
// CHECK: encoding: [0x62,0xf2,0x7d,0x28,0x63,0x4c,0x24,0xfc]
          vpcompressb  %ymm1, -4(%rsp)

// CHECK: vpcompressb  %ymm1, 4(%rsp)
// CHECK: encoding: [0x62,0xf2,0x7d,0x28,0x63,0x4c,0x24,0x04]
          vpcompressb  %ymm1, 4(%rsp)

// CHECK: vpcompressb  %ymm1, 268435456(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0x7d,0x28,0x63,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpcompressb  %ymm1, 268435456(%rcx,%r14,8)

// CHECK: vpcompressb  %ymm1, -536870912(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0x7d,0x28,0x63,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpcompressb  %ymm1, -536870912(%rcx,%r14,8)

// CHECK: vpcompressb  %ymm1, -536870910(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0x7d,0x28,0x63,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpcompressb  %ymm1, -536870910(%rcx,%r14,8)

// CHECK: vpcompressw  %ymm1, (%rcx)
// CHECK: encoding: [0x62,0xf2,0xfd,0x28,0x63,0x09]
          vpcompressw  %ymm1, (%rcx)

// CHECK: vpcompressw  %ymm1, -8(%rsp)
// CHECK: encoding: [0x62,0xf2,0xfd,0x28,0x63,0x4c,0x24,0xfc]
          vpcompressw  %ymm1, -8(%rsp)

// CHECK: vpcompressw  %ymm1, 8(%rsp)
// CHECK: encoding: [0x62,0xf2,0xfd,0x28,0x63,0x4c,0x24,0x04]
          vpcompressw  %ymm1, 8(%rsp)

// CHECK: vpcompressw  %ymm1, 268435456(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0xfd,0x28,0x63,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpcompressw  %ymm1, 268435456(%rcx,%r14,8)

// CHECK: vpcompressw  %ymm1, -536870912(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0xfd,0x28,0x63,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpcompressw  %ymm1, -536870912(%rcx,%r14,8)

// CHECK: vpcompressw  %ymm1, -536870910(%rcx,%r14,8)
// CHECK: encoding: [0x62,0xb2,0xfd,0x28,0x63,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpcompressw  %ymm1, -536870910(%rcx,%r14,8)

// CHECK: vpcompressb  %ymm21, (%rcx) {%k2}
// CHECK: encoding: [0x62,0xe2,0x7d,0x2a,0x63,0x29]
          vpcompressb  %ymm21, (%rcx) {%k2}

// CHECK: vpcompressb  %ymm21, -4(%rsp) {%k2}
// CHECK: encoding: [0x62,0xe2,0x7d,0x2a,0x63,0x6c,0x24,0xfc]
          vpcompressb  %ymm21, -4(%rsp) {%k2}

// CHECK: vpcompressb  %ymm21, 4(%rsp) {%k2}
// CHECK: encoding: [0x62,0xe2,0x7d,0x2a,0x63,0x6c,0x24,0x04]
          vpcompressb  %ymm21, 4(%rsp) {%k2}

// CHECK: vpcompressb  %ymm21, 268435456(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x2a,0x63,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpcompressb  %ymm21, 268435456(%rcx,%r14,8) {%k2}

// CHECK: vpcompressb  %ymm21, -536870912(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x2a,0x63,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpcompressb  %ymm21, -536870912(%rcx,%r14,8) {%k2}

// CHECK: vpcompressb  %ymm21, -536870910(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0x7d,0x2a,0x63,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpcompressb  %ymm21, -536870910(%rcx,%r14,8) {%k2}

// CHECK: vpcompressw  %ymm21, (%rcx) {%k2}
// CHECK: encoding: [0x62,0xe2,0xfd,0x2a,0x63,0x29]
          vpcompressw  %ymm21, (%rcx) {%k2}

// CHECK: vpcompressw  %ymm21, -8(%rsp) {%k2}
// CHECK: encoding: [0x62,0xe2,0xfd,0x2a,0x63,0x6c,0x24,0xfc]
          vpcompressw  %ymm21, -8(%rsp) {%k2}

// CHECK: vpcompressw  %ymm21, 8(%rsp) {%k2}
// CHECK: encoding: [0x62,0xe2,0xfd,0x2a,0x63,0x6c,0x24,0x04]
          vpcompressw  %ymm21, 8(%rsp) {%k2}

// CHECK: vpcompressw  %ymm21, 268435456(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x2a,0x63,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpcompressw  %ymm21, 268435456(%rcx,%r14,8) {%k2}

// CHECK: vpcompressw  %ymm21, -536870912(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x2a,0x63,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpcompressw  %ymm21, -536870912(%rcx,%r14,8) {%k2}

// CHECK: vpcompressw  %ymm21, -536870910(%rcx,%r14,8) {%k2}
// CHECK: encoding: [0x62,0xa2,0xfd,0x2a,0x63,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpcompressw  %ymm21, -536870910(%rcx,%r14,8) {%k2}

// CHECK: vpshldw $7, %xmm3, %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x08,0x70,0xcb,0x07]
          vpshldw $7, %xmm3, %xmm3, %xmm1

// CHECK: vpshldd $7, %xmm3, %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf3,0x65,0x08,0x71,0xcb,0x07]
          vpshldd $7, %xmm3, %xmm3, %xmm1

// CHECK: vpshldq $7, %xmm3, %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x08,0x71,0xcb,0x07]
          vpshldq $7, %xmm3, %xmm3, %xmm1

// CHECK: vpshrdw $7, %xmm3, %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x08,0x72,0xcb,0x07]
          vpshrdw $7, %xmm3, %xmm3, %xmm1

// CHECK: vpshrdd $7, %xmm3, %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf3,0x65,0x08,0x73,0xcb,0x07]
          vpshrdd $7, %xmm3, %xmm3, %xmm1

// CHECK: vpshrdq $7, %xmm3, %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x08,0x73,0xcb,0x07]
          vpshrdq $7, %xmm3, %xmm3, %xmm1

// CHECK: vpshldw $7, %xmm23, %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x00,0x70,0xef,0x07]
          vpshldw $7, %xmm23, %xmm23, %xmm21

// CHECK: vpshldd $7, %xmm23, %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa3,0x45,0x00,0x71,0xef,0x07]
          vpshldd $7, %xmm23, %xmm23, %xmm21

// CHECK: vpshldq $7, %xmm23, %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x00,0x71,0xef,0x07]
          vpshldq $7, %xmm23, %xmm23, %xmm21

// CHECK: vpshrdw $7, %xmm23, %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x00,0x72,0xef,0x07]
          vpshrdw $7, %xmm23, %xmm23, %xmm21

// CHECK: vpshrdd $7, %xmm23, %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa3,0x45,0x00,0x73,0xef,0x07]
          vpshrdd $7, %xmm23, %xmm23, %xmm21

// CHECK: vpshrdq $7, %xmm23, %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x00,0x73,0xef,0x07]
          vpshrdq $7, %xmm23, %xmm23, %xmm21

// CHECK: vpshldw $7, %xmm3, %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x0a,0x70,0xcb,0x07]
          vpshldw $7, %xmm3, %xmm3, %xmm1 {%k2}

// CHECK: vpshldd $7, %xmm3, %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0x65,0x0a,0x71,0xcb,0x07]
          vpshldd $7, %xmm3, %xmm3, %xmm1 {%k2}

// CHECK: vpshldq $7, %xmm3, %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x0a,0x71,0xcb,0x07]
          vpshldq $7, %xmm3, %xmm3, %xmm1 {%k2}

// CHECK: vpshrdw $7, %xmm3, %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x0a,0x72,0xcb,0x07]
          vpshrdw $7, %xmm3, %xmm3, %xmm1 {%k2}

// CHECK: vpshrdd $7, %xmm3, %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0x65,0x0a,0x73,0xcb,0x07]
          vpshrdd $7, %xmm3, %xmm3, %xmm1 {%k2}

// CHECK: vpshrdq $7, %xmm3, %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x0a,0x73,0xcb,0x07]
          vpshrdq $7, %xmm3, %xmm3, %xmm1 {%k2}

// CHECK: vpshldw $7, %xmm23, %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x02,0x70,0xef,0x07]
          vpshldw $7, %xmm23, %xmm23, %xmm21 {%k2}

// CHECK: vpshldd $7, %xmm23, %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0x45,0x02,0x71,0xef,0x07]
          vpshldd $7, %xmm23, %xmm23, %xmm21 {%k2}

// CHECK: vpshldq $7, %xmm23, %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x02,0x71,0xef,0x07]
          vpshldq $7, %xmm23, %xmm23, %xmm21 {%k2}

// CHECK: vpshrdw $7, %xmm23, %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x02,0x72,0xef,0x07]
          vpshrdw $7, %xmm23, %xmm23, %xmm21 {%k2}

// CHECK: vpshrdd $7, %xmm23, %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0x45,0x02,0x73,0xef,0x07]
          vpshrdd $7, %xmm23, %xmm23, %xmm21 {%k2}

// CHECK: vpshrdq $7, %xmm23, %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x02,0x73,0xef,0x07]
          vpshrdq $7, %xmm23, %xmm23, %xmm21 {%k2}

// CHECK: vpshldw  $7, (%rcx), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x08,0x70,0x09,0x07]
          vpshldw  $7, (%rcx), %xmm3, %xmm1

// CHECK: vpshldw  $7, -64(%rsp), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x08,0x70,0x4c,0x24,0xfc,0x07]
          vpshldw  $7, -64(%rsp), %xmm3, %xmm1

// CHECK: vpshldw  $7, 64(%rsp), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x08,0x70,0x4c,0x24,0x04,0x07]
          vpshldw  $7, 64(%rsp), %xmm3, %xmm1

// CHECK: vpshldw  $7, 268435456(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x08,0x70,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldw  $7, 268435456(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshldw  $7, -536870912(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x08,0x70,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldw  $7, -536870912(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshldw  $7, -536870910(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x08,0x70,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldw  $7, -536870910(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshldd  $7, (%rcx), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf3,0x65,0x08,0x71,0x09,0x07]
          vpshldd  $7, (%rcx), %xmm3, %xmm1

// CHECK: vpshldd  $7, -64(%rsp), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf3,0x65,0x08,0x71,0x4c,0x24,0xfc,0x07]
          vpshldd  $7, -64(%rsp), %xmm3, %xmm1

// CHECK: vpshldd  $7, 64(%rsp), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf3,0x65,0x08,0x71,0x4c,0x24,0x04,0x07]
          vpshldd  $7, 64(%rsp), %xmm3, %xmm1

// CHECK: vpshldd  $7, 268435456(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb3,0x65,0x08,0x71,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldd  $7, 268435456(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshldd  $7, -536870912(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb3,0x65,0x08,0x71,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldd  $7, -536870912(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshldd  $7, -536870910(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb3,0x65,0x08,0x71,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldd  $7, -536870910(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshldq  $7, (%rcx), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x08,0x71,0x09,0x07]
          vpshldq  $7, (%rcx), %xmm3, %xmm1

// CHECK: vpshldq  $7, -64(%rsp), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x08,0x71,0x4c,0x24,0xfc,0x07]
          vpshldq  $7, -64(%rsp), %xmm3, %xmm1

// CHECK: vpshldq  $7, 64(%rsp), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x08,0x71,0x4c,0x24,0x04,0x07]
          vpshldq  $7, 64(%rsp), %xmm3, %xmm1

// CHECK: vpshldq  $7, 268435456(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x08,0x71,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldq  $7, 268435456(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshldq  $7, -536870912(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x08,0x71,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldq  $7, -536870912(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshldq  $7, -536870910(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x08,0x71,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldq  $7, -536870910(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshrdw  $7, (%rcx), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x08,0x72,0x09,0x07]
          vpshrdw  $7, (%rcx), %xmm3, %xmm1

// CHECK: vpshrdw  $7, -64(%rsp), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x08,0x72,0x4c,0x24,0xfc,0x07]
          vpshrdw  $7, -64(%rsp), %xmm3, %xmm1

// CHECK: vpshrdw  $7, 64(%rsp), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x08,0x72,0x4c,0x24,0x04,0x07]
          vpshrdw  $7, 64(%rsp), %xmm3, %xmm1

// CHECK: vpshrdw  $7, 268435456(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x08,0x72,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdw  $7, 268435456(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshrdw  $7, -536870912(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x08,0x72,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdw  $7, -536870912(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshrdw  $7, -536870910(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x08,0x72,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdw  $7, -536870910(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshrdd  $7, (%rcx), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf3,0x65,0x08,0x73,0x09,0x07]
          vpshrdd  $7, (%rcx), %xmm3, %xmm1

// CHECK: vpshrdd  $7, -64(%rsp), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf3,0x65,0x08,0x73,0x4c,0x24,0xfc,0x07]
          vpshrdd  $7, -64(%rsp), %xmm3, %xmm1

// CHECK: vpshrdd  $7, 64(%rsp), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf3,0x65,0x08,0x73,0x4c,0x24,0x04,0x07]
          vpshrdd  $7, 64(%rsp), %xmm3, %xmm1

// CHECK: vpshrdd  $7, 268435456(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb3,0x65,0x08,0x73,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdd  $7, 268435456(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshrdd  $7, -536870912(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb3,0x65,0x08,0x73,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdd  $7, -536870912(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshrdd  $7, -536870910(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb3,0x65,0x08,0x73,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdd  $7, -536870910(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshrdq  $7, (%rcx), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x08,0x73,0x09,0x07]
          vpshrdq  $7, (%rcx), %xmm3, %xmm1

// CHECK: vpshrdq  $7, -64(%rsp), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x08,0x73,0x4c,0x24,0xfc,0x07]
          vpshrdq  $7, -64(%rsp), %xmm3, %xmm1

// CHECK: vpshrdq  $7, 64(%rsp), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x08,0x73,0x4c,0x24,0x04,0x07]
          vpshrdq  $7, 64(%rsp), %xmm3, %xmm1

// CHECK: vpshrdq  $7, 268435456(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x08,0x73,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdq  $7, 268435456(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshrdq  $7, -536870912(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x08,0x73,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdq  $7, -536870912(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshrdq  $7, -536870910(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x08,0x73,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdq  $7, -536870910(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshldw  $7, (%rcx), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x00,0x70,0x29,0x07]
          vpshldw  $7, (%rcx), %xmm23, %xmm21

// CHECK: vpshldw  $7, -64(%rsp), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x00,0x70,0x6c,0x24,0xfc,0x07]
          vpshldw  $7, -64(%rsp), %xmm23, %xmm21

// CHECK: vpshldw  $7, 64(%rsp), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x00,0x70,0x6c,0x24,0x04,0x07]
          vpshldw  $7, 64(%rsp), %xmm23, %xmm21

// CHECK: vpshldw  $7, 268435456(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x00,0x70,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldw  $7, 268435456(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshldw  $7, -536870912(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x00,0x70,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldw  $7, -536870912(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshldw  $7, -536870910(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x00,0x70,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldw  $7, -536870910(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshldd  $7, (%rcx), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe3,0x45,0x00,0x71,0x29,0x07]
          vpshldd  $7, (%rcx), %xmm23, %xmm21

// CHECK: vpshldd  $7, -64(%rsp), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe3,0x45,0x00,0x71,0x6c,0x24,0xfc,0x07]
          vpshldd  $7, -64(%rsp), %xmm23, %xmm21

// CHECK: vpshldd  $7, 64(%rsp), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe3,0x45,0x00,0x71,0x6c,0x24,0x04,0x07]
          vpshldd  $7, 64(%rsp), %xmm23, %xmm21

// CHECK: vpshldd  $7, 268435456(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa3,0x45,0x00,0x71,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldd  $7, 268435456(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshldd  $7, -536870912(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa3,0x45,0x00,0x71,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldd  $7, -536870912(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshldd  $7, -536870910(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa3,0x45,0x00,0x71,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldd  $7, -536870910(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshldq  $7, (%rcx), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x00,0x71,0x29,0x07]
          vpshldq  $7, (%rcx), %xmm23, %xmm21

// CHECK: vpshldq  $7, -64(%rsp), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x00,0x71,0x6c,0x24,0xfc,0x07]
          vpshldq  $7, -64(%rsp), %xmm23, %xmm21

// CHECK: vpshldq  $7, 64(%rsp), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x00,0x71,0x6c,0x24,0x04,0x07]
          vpshldq  $7, 64(%rsp), %xmm23, %xmm21

// CHECK: vpshldq  $7, 268435456(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x00,0x71,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldq  $7, 268435456(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshldq  $7, -536870912(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x00,0x71,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldq  $7, -536870912(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshldq  $7, -536870910(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x00,0x71,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldq  $7, -536870910(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshrdw  $7, (%rcx), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x00,0x72,0x29,0x07]
          vpshrdw  $7, (%rcx), %xmm23, %xmm21

// CHECK: vpshrdw  $7, -64(%rsp), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x00,0x72,0x6c,0x24,0xfc,0x07]
          vpshrdw  $7, -64(%rsp), %xmm23, %xmm21

// CHECK: vpshrdw  $7, 64(%rsp), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x00,0x72,0x6c,0x24,0x04,0x07]
          vpshrdw  $7, 64(%rsp), %xmm23, %xmm21

// CHECK: vpshrdw  $7, 268435456(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x00,0x72,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdw  $7, 268435456(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshrdw  $7, -536870912(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x00,0x72,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdw  $7, -536870912(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshrdw  $7, -536870910(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x00,0x72,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdw  $7, -536870910(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshrdd  $7, (%rcx), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe3,0x45,0x00,0x73,0x29,0x07]
          vpshrdd  $7, (%rcx), %xmm23, %xmm21

// CHECK: vpshrdd  $7, -64(%rsp), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe3,0x45,0x00,0x73,0x6c,0x24,0xfc,0x07]
          vpshrdd  $7, -64(%rsp), %xmm23, %xmm21

// CHECK: vpshrdd  $7, 64(%rsp), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe3,0x45,0x00,0x73,0x6c,0x24,0x04,0x07]
          vpshrdd  $7, 64(%rsp), %xmm23, %xmm21

// CHECK: vpshrdd  $7, 268435456(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa3,0x45,0x00,0x73,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdd  $7, 268435456(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshrdd  $7, -536870912(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa3,0x45,0x00,0x73,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdd  $7, -536870912(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshrdd  $7, -536870910(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa3,0x45,0x00,0x73,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdd  $7, -536870910(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshrdq  $7, (%rcx), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x00,0x73,0x29,0x07]
          vpshrdq  $7, (%rcx), %xmm23, %xmm21

// CHECK: vpshrdq  $7, -64(%rsp), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x00,0x73,0x6c,0x24,0xfc,0x07]
          vpshrdq  $7, -64(%rsp), %xmm23, %xmm21

// CHECK: vpshrdq  $7, 64(%rsp), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x00,0x73,0x6c,0x24,0x04,0x07]
          vpshrdq  $7, 64(%rsp), %xmm23, %xmm21

// CHECK: vpshrdq  $7, 268435456(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x00,0x73,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdq  $7, 268435456(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshrdq  $7, -536870912(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x00,0x73,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdq  $7, -536870912(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshrdq  $7, -536870910(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x00,0x73,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdq  $7, -536870910(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshldw  $7, (%rcx), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x0a,0x70,0x09,0x07]
          vpshldw  $7, (%rcx), %xmm3, %xmm1 {%k2}

// CHECK: vpshldw  $7, -64(%rsp), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x0a,0x70,0x4c,0x24,0xfc,0x07]
          vpshldw  $7, -64(%rsp), %xmm3, %xmm1 {%k2}

// CHECK: vpshldw  $7, 64(%rsp), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x0a,0x70,0x4c,0x24,0x04,0x07]
          vpshldw  $7, 64(%rsp), %xmm3, %xmm1 {%k2}

// CHECK: vpshldw  $7, 268435456(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x0a,0x70,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldw  $7, 268435456(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshldw  $7, -536870912(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x0a,0x70,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldw  $7, -536870912(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshldw  $7, -536870910(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x0a,0x70,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldw  $7, -536870910(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshldd  $7, (%rcx), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0x65,0x0a,0x71,0x09,0x07]
          vpshldd  $7, (%rcx), %xmm3, %xmm1 {%k2}

// CHECK: vpshldd  $7, -64(%rsp), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0x65,0x0a,0x71,0x4c,0x24,0xfc,0x07]
          vpshldd  $7, -64(%rsp), %xmm3, %xmm1 {%k2}

// CHECK: vpshldd  $7, 64(%rsp), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0x65,0x0a,0x71,0x4c,0x24,0x04,0x07]
          vpshldd  $7, 64(%rsp), %xmm3, %xmm1 {%k2}

// CHECK: vpshldd  $7, 268435456(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0x65,0x0a,0x71,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldd  $7, 268435456(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshldd  $7, -536870912(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0x65,0x0a,0x71,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldd  $7, -536870912(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshldd  $7, -536870910(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0x65,0x0a,0x71,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldd  $7, -536870910(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshldq  $7, (%rcx), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x0a,0x71,0x09,0x07]
          vpshldq  $7, (%rcx), %xmm3, %xmm1 {%k2}

// CHECK: vpshldq  $7, -64(%rsp), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x0a,0x71,0x4c,0x24,0xfc,0x07]
          vpshldq  $7, -64(%rsp), %xmm3, %xmm1 {%k2}

// CHECK: vpshldq  $7, 64(%rsp), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x0a,0x71,0x4c,0x24,0x04,0x07]
          vpshldq  $7, 64(%rsp), %xmm3, %xmm1 {%k2}

// CHECK: vpshldq  $7, 268435456(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x0a,0x71,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldq  $7, 268435456(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshldq  $7, -536870912(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x0a,0x71,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldq  $7, -536870912(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshldq  $7, -536870910(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x0a,0x71,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldq  $7, -536870910(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdw  $7, (%rcx), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x0a,0x72,0x09,0x07]
          vpshrdw  $7, (%rcx), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdw  $7, -64(%rsp), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x0a,0x72,0x4c,0x24,0xfc,0x07]
          vpshrdw  $7, -64(%rsp), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdw  $7, 64(%rsp), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x0a,0x72,0x4c,0x24,0x04,0x07]
          vpshrdw  $7, 64(%rsp), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdw  $7, 268435456(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x0a,0x72,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdw  $7, 268435456(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdw  $7, -536870912(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x0a,0x72,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdw  $7, -536870912(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdw  $7, -536870910(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x0a,0x72,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdw  $7, -536870910(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdd  $7, (%rcx), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0x65,0x0a,0x73,0x09,0x07]
          vpshrdd  $7, (%rcx), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdd  $7, -64(%rsp), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0x65,0x0a,0x73,0x4c,0x24,0xfc,0x07]
          vpshrdd  $7, -64(%rsp), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdd  $7, 64(%rsp), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0x65,0x0a,0x73,0x4c,0x24,0x04,0x07]
          vpshrdd  $7, 64(%rsp), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdd  $7, 268435456(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0x65,0x0a,0x73,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdd  $7, 268435456(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdd  $7, -536870912(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0x65,0x0a,0x73,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdd  $7, -536870912(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdd  $7, -536870910(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0x65,0x0a,0x73,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdd  $7, -536870910(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdq  $7, (%rcx), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x0a,0x73,0x09,0x07]
          vpshrdq  $7, (%rcx), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdq  $7, -64(%rsp), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x0a,0x73,0x4c,0x24,0xfc,0x07]
          vpshrdq  $7, -64(%rsp), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdq  $7, 64(%rsp), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x0a,0x73,0x4c,0x24,0x04,0x07]
          vpshrdq  $7, 64(%rsp), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdq  $7, 268435456(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x0a,0x73,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdq  $7, 268435456(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdq  $7, -536870912(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x0a,0x73,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdq  $7, -536870912(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdq  $7, -536870910(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x0a,0x73,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdq  $7, -536870910(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshldw  $7, (%rcx), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x02,0x70,0x29,0x07]
          vpshldw  $7, (%rcx), %xmm23, %xmm21 {%k2}

// CHECK: vpshldw  $7, -64(%rsp), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x02,0x70,0x6c,0x24,0xfc,0x07]
          vpshldw  $7, -64(%rsp), %xmm23, %xmm21 {%k2}

// CHECK: vpshldw  $7, 64(%rsp), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x02,0x70,0x6c,0x24,0x04,0x07]
          vpshldw  $7, 64(%rsp), %xmm23, %xmm21 {%k2}

// CHECK: vpshldw  $7, 268435456(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x02,0x70,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldw  $7, 268435456(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshldw  $7, -536870912(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x02,0x70,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldw  $7, -536870912(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshldw  $7, -536870910(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x02,0x70,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldw  $7, -536870910(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshldd  $7, (%rcx), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0x45,0x02,0x71,0x29,0x07]
          vpshldd  $7, (%rcx), %xmm23, %xmm21 {%k2}

// CHECK: vpshldd  $7, -64(%rsp), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0x45,0x02,0x71,0x6c,0x24,0xfc,0x07]
          vpshldd  $7, -64(%rsp), %xmm23, %xmm21 {%k2}

// CHECK: vpshldd  $7, 64(%rsp), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0x45,0x02,0x71,0x6c,0x24,0x04,0x07]
          vpshldd  $7, 64(%rsp), %xmm23, %xmm21 {%k2}

// CHECK: vpshldd  $7, 268435456(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0x45,0x02,0x71,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldd  $7, 268435456(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshldd  $7, -536870912(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0x45,0x02,0x71,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldd  $7, -536870912(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshldd  $7, -536870910(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0x45,0x02,0x71,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldd  $7, -536870910(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshldq  $7, (%rcx), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x02,0x71,0x29,0x07]
          vpshldq  $7, (%rcx), %xmm23, %xmm21 {%k2}

// CHECK: vpshldq  $7, -64(%rsp), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x02,0x71,0x6c,0x24,0xfc,0x07]
          vpshldq  $7, -64(%rsp), %xmm23, %xmm21 {%k2}

// CHECK: vpshldq  $7, 64(%rsp), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x02,0x71,0x6c,0x24,0x04,0x07]
          vpshldq  $7, 64(%rsp), %xmm23, %xmm21 {%k2}

// CHECK: vpshldq  $7, 268435456(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x02,0x71,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldq  $7, 268435456(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshldq  $7, -536870912(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x02,0x71,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldq  $7, -536870912(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshldq  $7, -536870910(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x02,0x71,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldq  $7, -536870910(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdw  $7, (%rcx), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x02,0x72,0x29,0x07]
          vpshrdw  $7, (%rcx), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdw  $7, -64(%rsp), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x02,0x72,0x6c,0x24,0xfc,0x07]
          vpshrdw  $7, -64(%rsp), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdw  $7, 64(%rsp), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x02,0x72,0x6c,0x24,0x04,0x07]
          vpshrdw  $7, 64(%rsp), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdw  $7, 268435456(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x02,0x72,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdw  $7, 268435456(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdw  $7, -536870912(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x02,0x72,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdw  $7, -536870912(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdw  $7, -536870910(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x02,0x72,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdw  $7, -536870910(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdd  $7, (%rcx), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0x45,0x02,0x73,0x29,0x07]
          vpshrdd  $7, (%rcx), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdd  $7, -64(%rsp), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0x45,0x02,0x73,0x6c,0x24,0xfc,0x07]
          vpshrdd  $7, -64(%rsp), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdd  $7, 64(%rsp), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0x45,0x02,0x73,0x6c,0x24,0x04,0x07]
          vpshrdd  $7, 64(%rsp), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdd  $7, 268435456(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0x45,0x02,0x73,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdd  $7, 268435456(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdd  $7, -536870912(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0x45,0x02,0x73,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdd  $7, -536870912(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdd  $7, -536870910(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0x45,0x02,0x73,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdd  $7, -536870910(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdq  $7, (%rcx), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x02,0x73,0x29,0x07]
          vpshrdq  $7, (%rcx), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdq  $7, -64(%rsp), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x02,0x73,0x6c,0x24,0xfc,0x07]
          vpshrdq  $7, -64(%rsp), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdq  $7, 64(%rsp), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x02,0x73,0x6c,0x24,0x04,0x07]
          vpshrdq  $7, 64(%rsp), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdq  $7, 268435456(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x02,0x73,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdq  $7, 268435456(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdq  $7, -536870912(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x02,0x73,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdq  $7, -536870912(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdq  $7, -536870910(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x02,0x73,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdq  $7, -536870910(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshldw $7, %ymm3, %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x28,0x70,0xcb,0x07]
          vpshldw $7, %ymm3, %ymm3, %ymm1

// CHECK: vpshldd $7, %ymm3, %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf3,0x65,0x28,0x71,0xcb,0x07]
          vpshldd $7, %ymm3, %ymm3, %ymm1

// CHECK: vpshldq $7, %ymm3, %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x28,0x71,0xcb,0x07]
          vpshldq $7, %ymm3, %ymm3, %ymm1

// CHECK: vpshrdw $7, %ymm3, %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x28,0x72,0xcb,0x07]
          vpshrdw $7, %ymm3, %ymm3, %ymm1

// CHECK: vpshrdd $7, %ymm3, %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf3,0x65,0x28,0x73,0xcb,0x07]
          vpshrdd $7, %ymm3, %ymm3, %ymm1

// CHECK: vpshrdq $7, %ymm3, %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x28,0x73,0xcb,0x07]
          vpshrdq $7, %ymm3, %ymm3, %ymm1

// CHECK: vpshldw $7, %ymm23, %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x20,0x70,0xef,0x07]
          vpshldw $7, %ymm23, %ymm23, %ymm21

// CHECK: vpshldd $7, %ymm23, %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa3,0x45,0x20,0x71,0xef,0x07]
          vpshldd $7, %ymm23, %ymm23, %ymm21

// CHECK: vpshldq $7, %ymm23, %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x20,0x71,0xef,0x07]
          vpshldq $7, %ymm23, %ymm23, %ymm21

// CHECK: vpshrdw $7, %ymm23, %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x20,0x72,0xef,0x07]
          vpshrdw $7, %ymm23, %ymm23, %ymm21

// CHECK: vpshrdd $7, %ymm23, %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa3,0x45,0x20,0x73,0xef,0x07]
          vpshrdd $7, %ymm23, %ymm23, %ymm21

// CHECK: vpshrdq $7, %ymm23, %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x20,0x73,0xef,0x07]
          vpshrdq $7, %ymm23, %ymm23, %ymm21

// CHECK: vpshldw $7, %ymm3, %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x2a,0x70,0xcb,0x07]
          vpshldw $7, %ymm3, %ymm3, %ymm1 {%k2}

// CHECK: vpshldd $7, %ymm3, %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0x65,0x2a,0x71,0xcb,0x07]
          vpshldd $7, %ymm3, %ymm3, %ymm1 {%k2}

// CHECK: vpshldq $7, %ymm3, %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x2a,0x71,0xcb,0x07]
          vpshldq $7, %ymm3, %ymm3, %ymm1 {%k2}

// CHECK: vpshrdw $7, %ymm3, %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x2a,0x72,0xcb,0x07]
          vpshrdw $7, %ymm3, %ymm3, %ymm1 {%k2}

// CHECK: vpshrdd $7, %ymm3, %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0x65,0x2a,0x73,0xcb,0x07]
          vpshrdd $7, %ymm3, %ymm3, %ymm1 {%k2}

// CHECK: vpshrdq $7, %ymm3, %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x2a,0x73,0xcb,0x07]
          vpshrdq $7, %ymm3, %ymm3, %ymm1 {%k2}

// CHECK: vpshldw $7, %ymm23, %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x22,0x70,0xef,0x07]
          vpshldw $7, %ymm23, %ymm23, %ymm21 {%k2}

// CHECK: vpshldd $7, %ymm23, %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0x45,0x22,0x71,0xef,0x07]
          vpshldd $7, %ymm23, %ymm23, %ymm21 {%k2}

// CHECK: vpshldq $7, %ymm23, %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x22,0x71,0xef,0x07]
          vpshldq $7, %ymm23, %ymm23, %ymm21 {%k2}

// CHECK: vpshrdw $7, %ymm23, %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x22,0x72,0xef,0x07]
          vpshrdw $7, %ymm23, %ymm23, %ymm21 {%k2}

// CHECK: vpshrdd $7, %ymm23, %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0x45,0x22,0x73,0xef,0x07]
          vpshrdd $7, %ymm23, %ymm23, %ymm21 {%k2}

// CHECK: vpshrdq $7, %ymm23, %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x22,0x73,0xef,0x07]
          vpshrdq $7, %ymm23, %ymm23, %ymm21 {%k2}

// CHECK: vpshldw  $7, (%rcx), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x28,0x70,0x09,0x07]
          vpshldw  $7, (%rcx), %ymm3, %ymm1

// CHECK: vpshldw  $7, -128(%rsp), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x28,0x70,0x4c,0x24,0xfc,0x07]
          vpshldw  $7, -128(%rsp), %ymm3, %ymm1

// CHECK: vpshldw  $7, 128(%rsp), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x28,0x70,0x4c,0x24,0x04,0x07]
          vpshldw  $7, 128(%rsp), %ymm3, %ymm1

// CHECK: vpshldw  $7, 268435456(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x28,0x70,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldw  $7, 268435456(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshldw  $7, -536870912(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x28,0x70,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldw  $7, -536870912(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshldw  $7, -536870910(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x28,0x70,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldw  $7, -536870910(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshldd  $7, (%rcx), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf3,0x65,0x28,0x71,0x09,0x07]
          vpshldd  $7, (%rcx), %ymm3, %ymm1

// CHECK: vpshldd  $7, -128(%rsp), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf3,0x65,0x28,0x71,0x4c,0x24,0xfc,0x07]
          vpshldd  $7, -128(%rsp), %ymm3, %ymm1

// CHECK: vpshldd  $7, 128(%rsp), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf3,0x65,0x28,0x71,0x4c,0x24,0x04,0x07]
          vpshldd  $7, 128(%rsp), %ymm3, %ymm1

// CHECK: vpshldd  $7, 268435456(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb3,0x65,0x28,0x71,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldd  $7, 268435456(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshldd  $7, -536870912(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb3,0x65,0x28,0x71,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldd  $7, -536870912(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshldd  $7, -536870910(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb3,0x65,0x28,0x71,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldd  $7, -536870910(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshldq  $7, (%rcx), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x28,0x71,0x09,0x07]
          vpshldq  $7, (%rcx), %ymm3, %ymm1

// CHECK: vpshldq  $7, -128(%rsp), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x28,0x71,0x4c,0x24,0xfc,0x07]
          vpshldq  $7, -128(%rsp), %ymm3, %ymm1

// CHECK: vpshldq  $7, 128(%rsp), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x28,0x71,0x4c,0x24,0x04,0x07]
          vpshldq  $7, 128(%rsp), %ymm3, %ymm1

// CHECK: vpshldq  $7, 268435456(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x28,0x71,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldq  $7, 268435456(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshldq  $7, -536870912(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x28,0x71,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldq  $7, -536870912(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshldq  $7, -536870910(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x28,0x71,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldq  $7, -536870910(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshrdw  $7, (%rcx), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x28,0x72,0x09,0x07]
          vpshrdw  $7, (%rcx), %ymm3, %ymm1

// CHECK: vpshrdw  $7, -128(%rsp), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x28,0x72,0x4c,0x24,0xfc,0x07]
          vpshrdw  $7, -128(%rsp), %ymm3, %ymm1

// CHECK: vpshrdw  $7, 128(%rsp), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x28,0x72,0x4c,0x24,0x04,0x07]
          vpshrdw  $7, 128(%rsp), %ymm3, %ymm1

// CHECK: vpshrdw  $7, 268435456(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x28,0x72,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdw  $7, 268435456(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshrdw  $7, -536870912(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x28,0x72,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdw  $7, -536870912(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshrdw  $7, -536870910(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x28,0x72,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdw  $7, -536870910(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshrdd  $7, (%rcx), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf3,0x65,0x28,0x73,0x09,0x07]
          vpshrdd  $7, (%rcx), %ymm3, %ymm1

// CHECK: vpshrdd  $7, -128(%rsp), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf3,0x65,0x28,0x73,0x4c,0x24,0xfc,0x07]
          vpshrdd  $7, -128(%rsp), %ymm3, %ymm1

// CHECK: vpshrdd  $7, 128(%rsp), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf3,0x65,0x28,0x73,0x4c,0x24,0x04,0x07]
          vpshrdd  $7, 128(%rsp), %ymm3, %ymm1

// CHECK: vpshrdd  $7, 268435456(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb3,0x65,0x28,0x73,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdd  $7, 268435456(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshrdd  $7, -536870912(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb3,0x65,0x28,0x73,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdd  $7, -536870912(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshrdd  $7, -536870910(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb3,0x65,0x28,0x73,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdd  $7, -536870910(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshrdq  $7, (%rcx), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x28,0x73,0x09,0x07]
          vpshrdq  $7, (%rcx), %ymm3, %ymm1

// CHECK: vpshrdq  $7, -128(%rsp), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x28,0x73,0x4c,0x24,0xfc,0x07]
          vpshrdq  $7, -128(%rsp), %ymm3, %ymm1

// CHECK: vpshrdq  $7, 128(%rsp), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf3,0xe5,0x28,0x73,0x4c,0x24,0x04,0x07]
          vpshrdq  $7, 128(%rsp), %ymm3, %ymm1

// CHECK: vpshrdq  $7, 268435456(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x28,0x73,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdq  $7, 268435456(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshrdq  $7, -536870912(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x28,0x73,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdq  $7, -536870912(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshrdq  $7, -536870910(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb3,0xe5,0x28,0x73,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdq  $7, -536870910(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshldw  $7, (%rcx), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x20,0x70,0x29,0x07]
          vpshldw  $7, (%rcx), %ymm23, %ymm21

// CHECK: vpshldw  $7, -128(%rsp), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x20,0x70,0x6c,0x24,0xfc,0x07]
          vpshldw  $7, -128(%rsp), %ymm23, %ymm21

// CHECK: vpshldw  $7, 128(%rsp), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x20,0x70,0x6c,0x24,0x04,0x07]
          vpshldw  $7, 128(%rsp), %ymm23, %ymm21

// CHECK: vpshldw  $7, 268435456(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x20,0x70,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldw  $7, 268435456(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshldw  $7, -536870912(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x20,0x70,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldw  $7, -536870912(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshldw  $7, -536870910(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x20,0x70,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldw  $7, -536870910(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshldd  $7, (%rcx), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe3,0x45,0x20,0x71,0x29,0x07]
          vpshldd  $7, (%rcx), %ymm23, %ymm21

// CHECK: vpshldd  $7, -128(%rsp), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe3,0x45,0x20,0x71,0x6c,0x24,0xfc,0x07]
          vpshldd  $7, -128(%rsp), %ymm23, %ymm21

// CHECK: vpshldd  $7, 128(%rsp), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe3,0x45,0x20,0x71,0x6c,0x24,0x04,0x07]
          vpshldd  $7, 128(%rsp), %ymm23, %ymm21

// CHECK: vpshldd  $7, 268435456(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa3,0x45,0x20,0x71,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldd  $7, 268435456(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshldd  $7, -536870912(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa3,0x45,0x20,0x71,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldd  $7, -536870912(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshldd  $7, -536870910(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa3,0x45,0x20,0x71,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldd  $7, -536870910(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshldq  $7, (%rcx), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x20,0x71,0x29,0x07]
          vpshldq  $7, (%rcx), %ymm23, %ymm21

// CHECK: vpshldq  $7, -128(%rsp), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x20,0x71,0x6c,0x24,0xfc,0x07]
          vpshldq  $7, -128(%rsp), %ymm23, %ymm21

// CHECK: vpshldq  $7, 128(%rsp), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x20,0x71,0x6c,0x24,0x04,0x07]
          vpshldq  $7, 128(%rsp), %ymm23, %ymm21

// CHECK: vpshldq  $7, 268435456(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x20,0x71,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldq  $7, 268435456(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshldq  $7, -536870912(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x20,0x71,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldq  $7, -536870912(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshldq  $7, -536870910(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x20,0x71,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldq  $7, -536870910(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshrdw  $7, (%rcx), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x20,0x72,0x29,0x07]
          vpshrdw  $7, (%rcx), %ymm23, %ymm21

// CHECK: vpshrdw  $7, -128(%rsp), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x20,0x72,0x6c,0x24,0xfc,0x07]
          vpshrdw  $7, -128(%rsp), %ymm23, %ymm21

// CHECK: vpshrdw  $7, 128(%rsp), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x20,0x72,0x6c,0x24,0x04,0x07]
          vpshrdw  $7, 128(%rsp), %ymm23, %ymm21

// CHECK: vpshrdw  $7, 268435456(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x20,0x72,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdw  $7, 268435456(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshrdw  $7, -536870912(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x20,0x72,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdw  $7, -536870912(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshrdw  $7, -536870910(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x20,0x72,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdw  $7, -536870910(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshrdd  $7, (%rcx), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe3,0x45,0x20,0x73,0x29,0x07]
          vpshrdd  $7, (%rcx), %ymm23, %ymm21

// CHECK: vpshrdd  $7, -128(%rsp), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe3,0x45,0x20,0x73,0x6c,0x24,0xfc,0x07]
          vpshrdd  $7, -128(%rsp), %ymm23, %ymm21

// CHECK: vpshrdd  $7, 128(%rsp), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe3,0x45,0x20,0x73,0x6c,0x24,0x04,0x07]
          vpshrdd  $7, 128(%rsp), %ymm23, %ymm21

// CHECK: vpshrdd  $7, 268435456(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa3,0x45,0x20,0x73,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdd  $7, 268435456(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshrdd  $7, -536870912(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa3,0x45,0x20,0x73,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdd  $7, -536870912(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshrdd  $7, -536870910(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa3,0x45,0x20,0x73,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdd  $7, -536870910(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshrdq  $7, (%rcx), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x20,0x73,0x29,0x07]
          vpshrdq  $7, (%rcx), %ymm23, %ymm21

// CHECK: vpshrdq  $7, -128(%rsp), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x20,0x73,0x6c,0x24,0xfc,0x07]
          vpshrdq  $7, -128(%rsp), %ymm23, %ymm21

// CHECK: vpshrdq  $7, 128(%rsp), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe3,0xc5,0x20,0x73,0x6c,0x24,0x04,0x07]
          vpshrdq  $7, 128(%rsp), %ymm23, %ymm21

// CHECK: vpshrdq  $7, 268435456(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x20,0x73,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdq  $7, 268435456(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshrdq  $7, -536870912(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x20,0x73,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdq  $7, -536870912(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshrdq  $7, -536870910(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa3,0xc5,0x20,0x73,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdq  $7, -536870910(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshldw  $7, (%rcx), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x2a,0x70,0x09,0x07]
          vpshldw  $7, (%rcx), %ymm3, %ymm1 {%k2}

// CHECK: vpshldw  $7, -128(%rsp), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x2a,0x70,0x4c,0x24,0xfc,0x07]
          vpshldw  $7, -128(%rsp), %ymm3, %ymm1 {%k2}

// CHECK: vpshldw  $7, 128(%rsp), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x2a,0x70,0x4c,0x24,0x04,0x07]
          vpshldw  $7, 128(%rsp), %ymm3, %ymm1 {%k2}

// CHECK: vpshldw  $7, 268435456(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x2a,0x70,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldw  $7, 268435456(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshldw  $7, -536870912(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x2a,0x70,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldw  $7, -536870912(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshldw  $7, -536870910(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x2a,0x70,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldw  $7, -536870910(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshldd  $7, (%rcx), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0x65,0x2a,0x71,0x09,0x07]
          vpshldd  $7, (%rcx), %ymm3, %ymm1 {%k2}

// CHECK: vpshldd  $7, -128(%rsp), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0x65,0x2a,0x71,0x4c,0x24,0xfc,0x07]
          vpshldd  $7, -128(%rsp), %ymm3, %ymm1 {%k2}

// CHECK: vpshldd  $7, 128(%rsp), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0x65,0x2a,0x71,0x4c,0x24,0x04,0x07]
          vpshldd  $7, 128(%rsp), %ymm3, %ymm1 {%k2}

// CHECK: vpshldd  $7, 268435456(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0x65,0x2a,0x71,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldd  $7, 268435456(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshldd  $7, -536870912(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0x65,0x2a,0x71,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldd  $7, -536870912(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshldd  $7, -536870910(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0x65,0x2a,0x71,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldd  $7, -536870910(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshldq  $7, (%rcx), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x2a,0x71,0x09,0x07]
          vpshldq  $7, (%rcx), %ymm3, %ymm1 {%k2}

// CHECK: vpshldq  $7, -128(%rsp), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x2a,0x71,0x4c,0x24,0xfc,0x07]
          vpshldq  $7, -128(%rsp), %ymm3, %ymm1 {%k2}

// CHECK: vpshldq  $7, 128(%rsp), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x2a,0x71,0x4c,0x24,0x04,0x07]
          vpshldq  $7, 128(%rsp), %ymm3, %ymm1 {%k2}

// CHECK: vpshldq  $7, 268435456(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x2a,0x71,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldq  $7, 268435456(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshldq  $7, -536870912(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x2a,0x71,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldq  $7, -536870912(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshldq  $7, -536870910(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x2a,0x71,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldq  $7, -536870910(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdw  $7, (%rcx), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x2a,0x72,0x09,0x07]
          vpshrdw  $7, (%rcx), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdw  $7, -128(%rsp), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x2a,0x72,0x4c,0x24,0xfc,0x07]
          vpshrdw  $7, -128(%rsp), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdw  $7, 128(%rsp), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x2a,0x72,0x4c,0x24,0x04,0x07]
          vpshrdw  $7, 128(%rsp), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdw  $7, 268435456(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x2a,0x72,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdw  $7, 268435456(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdw  $7, -536870912(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x2a,0x72,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdw  $7, -536870912(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdw  $7, -536870910(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x2a,0x72,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdw  $7, -536870910(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdd  $7, (%rcx), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0x65,0x2a,0x73,0x09,0x07]
          vpshrdd  $7, (%rcx), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdd  $7, -128(%rsp), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0x65,0x2a,0x73,0x4c,0x24,0xfc,0x07]
          vpshrdd  $7, -128(%rsp), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdd  $7, 128(%rsp), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0x65,0x2a,0x73,0x4c,0x24,0x04,0x07]
          vpshrdd  $7, 128(%rsp), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdd  $7, 268435456(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0x65,0x2a,0x73,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdd  $7, 268435456(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdd  $7, -536870912(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0x65,0x2a,0x73,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdd  $7, -536870912(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdd  $7, -536870910(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0x65,0x2a,0x73,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdd  $7, -536870910(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdq  $7, (%rcx), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x2a,0x73,0x09,0x07]
          vpshrdq  $7, (%rcx), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdq  $7, -128(%rsp), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x2a,0x73,0x4c,0x24,0xfc,0x07]
          vpshrdq  $7, -128(%rsp), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdq  $7, 128(%rsp), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf3,0xe5,0x2a,0x73,0x4c,0x24,0x04,0x07]
          vpshrdq  $7, 128(%rsp), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdq  $7, 268435456(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x2a,0x73,0x8c,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdq  $7, 268435456(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdq  $7, -536870912(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x2a,0x73,0x8c,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdq  $7, -536870912(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdq  $7, -536870910(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb3,0xe5,0x2a,0x73,0x8c,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdq  $7, -536870910(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshldw  $7, (%rcx), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x22,0x70,0x29,0x07]
          vpshldw  $7, (%rcx), %ymm23, %ymm21 {%k2}

// CHECK: vpshldw  $7, -128(%rsp), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x22,0x70,0x6c,0x24,0xfc,0x07]
          vpshldw  $7, -128(%rsp), %ymm23, %ymm21 {%k2}

// CHECK: vpshldw  $7, 128(%rsp), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x22,0x70,0x6c,0x24,0x04,0x07]
          vpshldw  $7, 128(%rsp), %ymm23, %ymm21 {%k2}

// CHECK: vpshldw  $7, 268435456(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x22,0x70,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldw  $7, 268435456(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshldw  $7, -536870912(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x22,0x70,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldw  $7, -536870912(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshldw  $7, -536870910(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x22,0x70,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldw  $7, -536870910(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshldd  $7, (%rcx), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0x45,0x22,0x71,0x29,0x07]
          vpshldd  $7, (%rcx), %ymm23, %ymm21 {%k2}

// CHECK: vpshldd  $7, -128(%rsp), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0x45,0x22,0x71,0x6c,0x24,0xfc,0x07]
          vpshldd  $7, -128(%rsp), %ymm23, %ymm21 {%k2}

// CHECK: vpshldd  $7, 128(%rsp), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0x45,0x22,0x71,0x6c,0x24,0x04,0x07]
          vpshldd  $7, 128(%rsp), %ymm23, %ymm21 {%k2}

// CHECK: vpshldd  $7, 268435456(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0x45,0x22,0x71,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldd  $7, 268435456(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshldd  $7, -536870912(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0x45,0x22,0x71,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldd  $7, -536870912(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshldd  $7, -536870910(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0x45,0x22,0x71,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldd  $7, -536870910(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshldq  $7, (%rcx), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x22,0x71,0x29,0x07]
          vpshldq  $7, (%rcx), %ymm23, %ymm21 {%k2}

// CHECK: vpshldq  $7, -128(%rsp), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x22,0x71,0x6c,0x24,0xfc,0x07]
          vpshldq  $7, -128(%rsp), %ymm23, %ymm21 {%k2}

// CHECK: vpshldq  $7, 128(%rsp), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x22,0x71,0x6c,0x24,0x04,0x07]
          vpshldq  $7, 128(%rsp), %ymm23, %ymm21 {%k2}

// CHECK: vpshldq  $7, 268435456(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x22,0x71,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshldq  $7, 268435456(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshldq  $7, -536870912(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x22,0x71,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshldq  $7, -536870912(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshldq  $7, -536870910(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x22,0x71,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshldq  $7, -536870910(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdw  $7, (%rcx), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x22,0x72,0x29,0x07]
          vpshrdw  $7, (%rcx), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdw  $7, -128(%rsp), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x22,0x72,0x6c,0x24,0xfc,0x07]
          vpshrdw  $7, -128(%rsp), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdw  $7, 128(%rsp), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x22,0x72,0x6c,0x24,0x04,0x07]
          vpshrdw  $7, 128(%rsp), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdw  $7, 268435456(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x22,0x72,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdw  $7, 268435456(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdw  $7, -536870912(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x22,0x72,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdw  $7, -536870912(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdw  $7, -536870910(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x22,0x72,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdw  $7, -536870910(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdd  $7, (%rcx), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0x45,0x22,0x73,0x29,0x07]
          vpshrdd  $7, (%rcx), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdd  $7, -128(%rsp), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0x45,0x22,0x73,0x6c,0x24,0xfc,0x07]
          vpshrdd  $7, -128(%rsp), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdd  $7, 128(%rsp), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0x45,0x22,0x73,0x6c,0x24,0x04,0x07]
          vpshrdd  $7, 128(%rsp), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdd  $7, 268435456(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0x45,0x22,0x73,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdd  $7, 268435456(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdd  $7, -536870912(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0x45,0x22,0x73,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdd  $7, -536870912(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdd  $7, -536870910(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0x45,0x22,0x73,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdd  $7, -536870910(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdq  $7, (%rcx), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x22,0x73,0x29,0x07]
          vpshrdq  $7, (%rcx), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdq  $7, -128(%rsp), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x22,0x73,0x6c,0x24,0xfc,0x07]
          vpshrdq  $7, -128(%rsp), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdq  $7, 128(%rsp), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe3,0xc5,0x22,0x73,0x6c,0x24,0x04,0x07]
          vpshrdq  $7, 128(%rsp), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdq  $7, 268435456(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x22,0x73,0xac,0xf1,0x00,0x00,0x00,0x10,0x07]
          vpshrdq  $7, 268435456(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdq  $7, -536870912(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x22,0x73,0xac,0xf1,0x00,0x00,0x00,0xe0,0x07]
          vpshrdq  $7, -536870912(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdq  $7, -536870910(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa3,0xc5,0x22,0x73,0xac,0xf1,0x02,0x00,0x00,0xe0,0x07]
          vpshrdq  $7, -536870910(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshldvw %xmm3, %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x08,0x70,0xcb]
          vpshldvw %xmm3, %xmm3, %xmm1

// CHECK: vpshldvd %xmm3, %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0x65,0x08,0x71,0xcb]
          vpshldvd %xmm3, %xmm3, %xmm1

// CHECK: vpshldvq %xmm3, %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x08,0x71,0xcb]
          vpshldvq %xmm3, %xmm3, %xmm1

// CHECK: vpshrdvw %xmm3, %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x08,0x72,0xcb]
          vpshrdvw %xmm3, %xmm3, %xmm1

// CHECK: vpshrdvd %xmm3, %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0x65,0x08,0x73,0xcb]
          vpshrdvd %xmm3, %xmm3, %xmm1

// CHECK: vpshrdvq %xmm3, %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x08,0x73,0xcb]
          vpshrdvq %xmm3, %xmm3, %xmm1

// CHECK: vpshldvw %xmm23, %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x00,0x70,0xef]
          vpshldvw %xmm23, %xmm23, %xmm21

// CHECK: vpshldvd %xmm23, %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0x45,0x00,0x71,0xef]
          vpshldvd %xmm23, %xmm23, %xmm21

// CHECK: vpshldvq %xmm23, %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x00,0x71,0xef]
          vpshldvq %xmm23, %xmm23, %xmm21

// CHECK: vpshrdvw %xmm23, %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x00,0x72,0xef]
          vpshrdvw %xmm23, %xmm23, %xmm21

// CHECK: vpshrdvd %xmm23, %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0x45,0x00,0x73,0xef]
          vpshrdvd %xmm23, %xmm23, %xmm21

// CHECK: vpshrdvq %xmm23, %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x00,0x73,0xef]
          vpshrdvq %xmm23, %xmm23, %xmm21

// CHECK: vpshldvw %xmm3, %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x0a,0x70,0xcb]
          vpshldvw %xmm3, %xmm3, %xmm1 {%k2}

// CHECK: vpshldvd %xmm3, %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x65,0x0a,0x71,0xcb]
          vpshldvd %xmm3, %xmm3, %xmm1 {%k2}

// CHECK: vpshldvq %xmm3, %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x0a,0x71,0xcb]
          vpshldvq %xmm3, %xmm3, %xmm1 {%k2}

// CHECK: vpshrdvw %xmm3, %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x0a,0x72,0xcb]
          vpshrdvw %xmm3, %xmm3, %xmm1 {%k2}

// CHECK: vpshrdvd %xmm3, %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x65,0x0a,0x73,0xcb]
          vpshrdvd %xmm3, %xmm3, %xmm1 {%k2}

// CHECK: vpshrdvq %xmm3, %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x0a,0x73,0xcb]
          vpshrdvq %xmm3, %xmm3, %xmm1 {%k2}

// CHECK: vpshldvw %xmm23, %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x02,0x70,0xef]
          vpshldvw %xmm23, %xmm23, %xmm21 {%k2}

// CHECK: vpshldvd %xmm23, %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x45,0x02,0x71,0xef]
          vpshldvd %xmm23, %xmm23, %xmm21 {%k2}

// CHECK: vpshldvq %xmm23, %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x02,0x71,0xef]
          vpshldvq %xmm23, %xmm23, %xmm21 {%k2}

// CHECK: vpshrdvw %xmm23, %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x02,0x72,0xef]
          vpshrdvw %xmm23, %xmm23, %xmm21 {%k2}

// CHECK: vpshrdvd %xmm23, %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x45,0x02,0x73,0xef]
          vpshrdvd %xmm23, %xmm23, %xmm21 {%k2}

// CHECK: vpshrdvq %xmm23, %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x02,0x73,0xef]
          vpshrdvq %xmm23, %xmm23, %xmm21 {%k2}

// CHECK: vpshldvw  (%rcx), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x08,0x70,0x09]
          vpshldvw  (%rcx), %xmm3, %xmm1

// CHECK: vpshldvw  -64(%rsp), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x08,0x70,0x4c,0x24,0xfc]
          vpshldvw  -64(%rsp), %xmm3, %xmm1

// CHECK: vpshldvw  64(%rsp), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x08,0x70,0x4c,0x24,0x04]
          vpshldvw  64(%rsp), %xmm3, %xmm1

// CHECK: vpshldvw  268435456(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x08,0x70,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshldvw  268435456(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshldvw  -536870912(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x08,0x70,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvw  -536870912(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshldvw  -536870910(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x08,0x70,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvw  -536870910(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshldvd  (%rcx), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0x65,0x08,0x71,0x09]
          vpshldvd  (%rcx), %xmm3, %xmm1

// CHECK: vpshldvd  -64(%rsp), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0x65,0x08,0x71,0x4c,0x24,0xfc]
          vpshldvd  -64(%rsp), %xmm3, %xmm1

// CHECK: vpshldvd  64(%rsp), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0x65,0x08,0x71,0x4c,0x24,0x04]
          vpshldvd  64(%rsp), %xmm3, %xmm1

// CHECK: vpshldvd  268435456(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb2,0x65,0x08,0x71,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshldvd  268435456(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshldvd  -536870912(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb2,0x65,0x08,0x71,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvd  -536870912(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshldvd  -536870910(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb2,0x65,0x08,0x71,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvd  -536870910(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshldvq  (%rcx), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x08,0x71,0x09]
          vpshldvq  (%rcx), %xmm3, %xmm1

// CHECK: vpshldvq  -64(%rsp), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x08,0x71,0x4c,0x24,0xfc]
          vpshldvq  -64(%rsp), %xmm3, %xmm1

// CHECK: vpshldvq  64(%rsp), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x08,0x71,0x4c,0x24,0x04]
          vpshldvq  64(%rsp), %xmm3, %xmm1

// CHECK: vpshldvq  268435456(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x08,0x71,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshldvq  268435456(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshldvq  -536870912(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x08,0x71,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvq  -536870912(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshldvq  -536870910(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x08,0x71,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvq  -536870910(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshrdvw  (%rcx), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x08,0x72,0x09]
          vpshrdvw  (%rcx), %xmm3, %xmm1

// CHECK: vpshrdvw  -64(%rsp), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x08,0x72,0x4c,0x24,0xfc]
          vpshrdvw  -64(%rsp), %xmm3, %xmm1

// CHECK: vpshrdvw  64(%rsp), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x08,0x72,0x4c,0x24,0x04]
          vpshrdvw  64(%rsp), %xmm3, %xmm1

// CHECK: vpshrdvw  268435456(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x08,0x72,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvw  268435456(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshrdvw  -536870912(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x08,0x72,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvw  -536870912(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshrdvw  -536870910(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x08,0x72,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvw  -536870910(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshrdvd  (%rcx), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0x65,0x08,0x73,0x09]
          vpshrdvd  (%rcx), %xmm3, %xmm1

// CHECK: vpshrdvd  -64(%rsp), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0x65,0x08,0x73,0x4c,0x24,0xfc]
          vpshrdvd  -64(%rsp), %xmm3, %xmm1

// CHECK: vpshrdvd  64(%rsp), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0x65,0x08,0x73,0x4c,0x24,0x04]
          vpshrdvd  64(%rsp), %xmm3, %xmm1

// CHECK: vpshrdvd  268435456(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb2,0x65,0x08,0x73,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvd  268435456(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshrdvd  -536870912(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb2,0x65,0x08,0x73,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvd  -536870912(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshrdvd  -536870910(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb2,0x65,0x08,0x73,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvd  -536870910(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshrdvq  (%rcx), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x08,0x73,0x09]
          vpshrdvq  (%rcx), %xmm3, %xmm1

// CHECK: vpshrdvq  -64(%rsp), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x08,0x73,0x4c,0x24,0xfc]
          vpshrdvq  -64(%rsp), %xmm3, %xmm1

// CHECK: vpshrdvq  64(%rsp), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x08,0x73,0x4c,0x24,0x04]
          vpshrdvq  64(%rsp), %xmm3, %xmm1

// CHECK: vpshrdvq  268435456(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x08,0x73,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvq  268435456(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshrdvq  -536870912(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x08,0x73,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvq  -536870912(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshrdvq  -536870910(%rcx,%r14,8), %xmm3, %xmm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x08,0x73,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvq  -536870910(%rcx,%r14,8), %xmm3, %xmm1

// CHECK: vpshldvw  (%rcx), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x00,0x70,0x29]
          vpshldvw  (%rcx), %xmm23, %xmm21

// CHECK: vpshldvw  -64(%rsp), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x00,0x70,0x6c,0x24,0xfc]
          vpshldvw  -64(%rsp), %xmm23, %xmm21

// CHECK: vpshldvw  64(%rsp), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x00,0x70,0x6c,0x24,0x04]
          vpshldvw  64(%rsp), %xmm23, %xmm21

// CHECK: vpshldvw  268435456(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x00,0x70,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshldvw  268435456(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshldvw  -536870912(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x00,0x70,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvw  -536870912(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshldvw  -536870910(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x00,0x70,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvw  -536870910(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshldvd  (%rcx), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe2,0x45,0x00,0x71,0x29]
          vpshldvd  (%rcx), %xmm23, %xmm21

// CHECK: vpshldvd  -64(%rsp), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe2,0x45,0x00,0x71,0x6c,0x24,0xfc]
          vpshldvd  -64(%rsp), %xmm23, %xmm21

// CHECK: vpshldvd  64(%rsp), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe2,0x45,0x00,0x71,0x6c,0x24,0x04]
          vpshldvd  64(%rsp), %xmm23, %xmm21

// CHECK: vpshldvd  268435456(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0x45,0x00,0x71,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshldvd  268435456(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshldvd  -536870912(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0x45,0x00,0x71,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvd  -536870912(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshldvd  -536870910(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0x45,0x00,0x71,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvd  -536870910(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshldvq  (%rcx), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x00,0x71,0x29]
          vpshldvq  (%rcx), %xmm23, %xmm21

// CHECK: vpshldvq  -64(%rsp), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x00,0x71,0x6c,0x24,0xfc]
          vpshldvq  -64(%rsp), %xmm23, %xmm21

// CHECK: vpshldvq  64(%rsp), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x00,0x71,0x6c,0x24,0x04]
          vpshldvq  64(%rsp), %xmm23, %xmm21

// CHECK: vpshldvq  268435456(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x00,0x71,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshldvq  268435456(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshldvq  -536870912(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x00,0x71,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvq  -536870912(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshldvq  -536870910(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x00,0x71,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvq  -536870910(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshrdvw  (%rcx), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x00,0x72,0x29]
          vpshrdvw  (%rcx), %xmm23, %xmm21

// CHECK: vpshrdvw  -64(%rsp), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x00,0x72,0x6c,0x24,0xfc]
          vpshrdvw  -64(%rsp), %xmm23, %xmm21

// CHECK: vpshrdvw  64(%rsp), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x00,0x72,0x6c,0x24,0x04]
          vpshrdvw  64(%rsp), %xmm23, %xmm21

// CHECK: vpshrdvw  268435456(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x00,0x72,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvw  268435456(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshrdvw  -536870912(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x00,0x72,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvw  -536870912(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshrdvw  -536870910(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x00,0x72,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvw  -536870910(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshrdvd  (%rcx), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe2,0x45,0x00,0x73,0x29]
          vpshrdvd  (%rcx), %xmm23, %xmm21

// CHECK: vpshrdvd  -64(%rsp), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe2,0x45,0x00,0x73,0x6c,0x24,0xfc]
          vpshrdvd  -64(%rsp), %xmm23, %xmm21

// CHECK: vpshrdvd  64(%rsp), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe2,0x45,0x00,0x73,0x6c,0x24,0x04]
          vpshrdvd  64(%rsp), %xmm23, %xmm21

// CHECK: vpshrdvd  268435456(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0x45,0x00,0x73,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvd  268435456(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshrdvd  -536870912(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0x45,0x00,0x73,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvd  -536870912(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshrdvd  -536870910(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0x45,0x00,0x73,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvd  -536870910(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshrdvq  (%rcx), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x00,0x73,0x29]
          vpshrdvq  (%rcx), %xmm23, %xmm21

// CHECK: vpshrdvq  -64(%rsp), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x00,0x73,0x6c,0x24,0xfc]
          vpshrdvq  -64(%rsp), %xmm23, %xmm21

// CHECK: vpshrdvq  64(%rsp), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x00,0x73,0x6c,0x24,0x04]
          vpshrdvq  64(%rsp), %xmm23, %xmm21

// CHECK: vpshrdvq  268435456(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x00,0x73,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvq  268435456(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshrdvq  -536870912(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x00,0x73,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvq  -536870912(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshrdvq  -536870910(%rcx,%r14,8), %xmm23, %xmm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x00,0x73,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvq  -536870910(%rcx,%r14,8), %xmm23, %xmm21

// CHECK: vpshldvw  (%rcx), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x0a,0x70,0x09]
          vpshldvw  (%rcx), %xmm3, %xmm1 {%k2}

// CHECK: vpshldvw  -64(%rsp), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x0a,0x70,0x4c,0x24,0xfc]
          vpshldvw  -64(%rsp), %xmm3, %xmm1 {%k2}

// CHECK: vpshldvw  64(%rsp), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x0a,0x70,0x4c,0x24,0x04]
          vpshldvw  64(%rsp), %xmm3, %xmm1 {%k2}

// CHECK: vpshldvw  268435456(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x0a,0x70,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshldvw  268435456(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshldvw  -536870912(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x0a,0x70,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvw  -536870912(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshldvw  -536870910(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x0a,0x70,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvw  -536870910(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshldvd  (%rcx), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x65,0x0a,0x71,0x09]
          vpshldvd  (%rcx), %xmm3, %xmm1 {%k2}

// CHECK: vpshldvd  -64(%rsp), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x65,0x0a,0x71,0x4c,0x24,0xfc]
          vpshldvd  -64(%rsp), %xmm3, %xmm1 {%k2}

// CHECK: vpshldvd  64(%rsp), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x65,0x0a,0x71,0x4c,0x24,0x04]
          vpshldvd  64(%rsp), %xmm3, %xmm1 {%k2}

// CHECK: vpshldvd  268435456(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0x65,0x0a,0x71,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshldvd  268435456(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshldvd  -536870912(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0x65,0x0a,0x71,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvd  -536870912(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshldvd  -536870910(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0x65,0x0a,0x71,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvd  -536870910(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshldvq  (%rcx), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x0a,0x71,0x09]
          vpshldvq  (%rcx), %xmm3, %xmm1 {%k2}

// CHECK: vpshldvq  -64(%rsp), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x0a,0x71,0x4c,0x24,0xfc]
          vpshldvq  -64(%rsp), %xmm3, %xmm1 {%k2}

// CHECK: vpshldvq  64(%rsp), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x0a,0x71,0x4c,0x24,0x04]
          vpshldvq  64(%rsp), %xmm3, %xmm1 {%k2}

// CHECK: vpshldvq  268435456(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x0a,0x71,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshldvq  268435456(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshldvq  -536870912(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x0a,0x71,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvq  -536870912(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshldvq  -536870910(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x0a,0x71,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvq  -536870910(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdvw  (%rcx), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x0a,0x72,0x09]
          vpshrdvw  (%rcx), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdvw  -64(%rsp), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x0a,0x72,0x4c,0x24,0xfc]
          vpshrdvw  -64(%rsp), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdvw  64(%rsp), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x0a,0x72,0x4c,0x24,0x04]
          vpshrdvw  64(%rsp), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdvw  268435456(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x0a,0x72,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvw  268435456(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdvw  -536870912(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x0a,0x72,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvw  -536870912(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdvw  -536870910(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x0a,0x72,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvw  -536870910(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdvd  (%rcx), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x65,0x0a,0x73,0x09]
          vpshrdvd  (%rcx), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdvd  -64(%rsp), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x65,0x0a,0x73,0x4c,0x24,0xfc]
          vpshrdvd  -64(%rsp), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdvd  64(%rsp), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x65,0x0a,0x73,0x4c,0x24,0x04]
          vpshrdvd  64(%rsp), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdvd  268435456(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0x65,0x0a,0x73,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvd  268435456(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdvd  -536870912(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0x65,0x0a,0x73,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvd  -536870912(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdvd  -536870910(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0x65,0x0a,0x73,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvd  -536870910(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdvq  (%rcx), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x0a,0x73,0x09]
          vpshrdvq  (%rcx), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdvq  -64(%rsp), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x0a,0x73,0x4c,0x24,0xfc]
          vpshrdvq  -64(%rsp), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdvq  64(%rsp), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x0a,0x73,0x4c,0x24,0x04]
          vpshrdvq  64(%rsp), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdvq  268435456(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x0a,0x73,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvq  268435456(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdvq  -536870912(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x0a,0x73,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvq  -536870912(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshrdvq  -536870910(%rcx,%r14,8), %xmm3, %xmm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x0a,0x73,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvq  -536870910(%rcx,%r14,8), %xmm3, %xmm1 {%k2}

// CHECK: vpshldvw  (%rcx), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x02,0x70,0x29]
          vpshldvw  (%rcx), %xmm23, %xmm21 {%k2}

// CHECK: vpshldvw  -64(%rsp), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x02,0x70,0x6c,0x24,0xfc]
          vpshldvw  -64(%rsp), %xmm23, %xmm21 {%k2}

// CHECK: vpshldvw  64(%rsp), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x02,0x70,0x6c,0x24,0x04]
          vpshldvw  64(%rsp), %xmm23, %xmm21 {%k2}

// CHECK: vpshldvw  268435456(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x02,0x70,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshldvw  268435456(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshldvw  -536870912(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x02,0x70,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvw  -536870912(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshldvw  -536870910(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x02,0x70,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvw  -536870910(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshldvd  (%rcx), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0x45,0x02,0x71,0x29]
          vpshldvd  (%rcx), %xmm23, %xmm21 {%k2}

// CHECK: vpshldvd  -64(%rsp), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0x45,0x02,0x71,0x6c,0x24,0xfc]
          vpshldvd  -64(%rsp), %xmm23, %xmm21 {%k2}

// CHECK: vpshldvd  64(%rsp), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0x45,0x02,0x71,0x6c,0x24,0x04]
          vpshldvd  64(%rsp), %xmm23, %xmm21 {%k2}

// CHECK: vpshldvd  268435456(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x45,0x02,0x71,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshldvd  268435456(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshldvd  -536870912(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x45,0x02,0x71,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvd  -536870912(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshldvd  -536870910(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x45,0x02,0x71,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvd  -536870910(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshldvq  (%rcx), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x02,0x71,0x29]
          vpshldvq  (%rcx), %xmm23, %xmm21 {%k2}

// CHECK: vpshldvq  -64(%rsp), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x02,0x71,0x6c,0x24,0xfc]
          vpshldvq  -64(%rsp), %xmm23, %xmm21 {%k2}

// CHECK: vpshldvq  64(%rsp), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x02,0x71,0x6c,0x24,0x04]
          vpshldvq  64(%rsp), %xmm23, %xmm21 {%k2}

// CHECK: vpshldvq  268435456(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x02,0x71,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshldvq  268435456(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshldvq  -536870912(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x02,0x71,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvq  -536870912(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshldvq  -536870910(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x02,0x71,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvq  -536870910(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdvw  (%rcx), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x02,0x72,0x29]
          vpshrdvw  (%rcx), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdvw  -64(%rsp), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x02,0x72,0x6c,0x24,0xfc]
          vpshrdvw  -64(%rsp), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdvw  64(%rsp), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x02,0x72,0x6c,0x24,0x04]
          vpshrdvw  64(%rsp), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdvw  268435456(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x02,0x72,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvw  268435456(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdvw  -536870912(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x02,0x72,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvw  -536870912(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdvw  -536870910(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x02,0x72,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvw  -536870910(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdvd  (%rcx), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0x45,0x02,0x73,0x29]
          vpshrdvd  (%rcx), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdvd  -64(%rsp), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0x45,0x02,0x73,0x6c,0x24,0xfc]
          vpshrdvd  -64(%rsp), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdvd  64(%rsp), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0x45,0x02,0x73,0x6c,0x24,0x04]
          vpshrdvd  64(%rsp), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdvd  268435456(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x45,0x02,0x73,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvd  268435456(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdvd  -536870912(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x45,0x02,0x73,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvd  -536870912(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdvd  -536870910(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x45,0x02,0x73,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvd  -536870910(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdvq  (%rcx), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x02,0x73,0x29]
          vpshrdvq  (%rcx), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdvq  -64(%rsp), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x02,0x73,0x6c,0x24,0xfc]
          vpshrdvq  -64(%rsp), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdvq  64(%rsp), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x02,0x73,0x6c,0x24,0x04]
          vpshrdvq  64(%rsp), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdvq  268435456(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x02,0x73,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvq  268435456(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdvq  -536870912(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x02,0x73,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvq  -536870912(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshrdvq  -536870910(%rcx,%r14,8), %xmm23, %xmm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x02,0x73,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvq  -536870910(%rcx,%r14,8), %xmm23, %xmm21 {%k2}

// CHECK: vpshldvw %ymm3, %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x28,0x70,0xcb]
          vpshldvw %ymm3, %ymm3, %ymm1

// CHECK: vpshldvd %ymm3, %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0x65,0x28,0x71,0xcb]
          vpshldvd %ymm3, %ymm3, %ymm1

// CHECK: vpshldvq %ymm3, %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x28,0x71,0xcb]
          vpshldvq %ymm3, %ymm3, %ymm1

// CHECK: vpshrdvw %ymm3, %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x28,0x72,0xcb]
          vpshrdvw %ymm3, %ymm3, %ymm1

// CHECK: vpshrdvd %ymm3, %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0x65,0x28,0x73,0xcb]
          vpshrdvd %ymm3, %ymm3, %ymm1

// CHECK: vpshrdvq %ymm3, %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x28,0x73,0xcb]
          vpshrdvq %ymm3, %ymm3, %ymm1

// CHECK: vpshldvw %ymm23, %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x20,0x70,0xef]
          vpshldvw %ymm23, %ymm23, %ymm21

// CHECK: vpshldvd %ymm23, %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0x45,0x20,0x71,0xef]
          vpshldvd %ymm23, %ymm23, %ymm21

// CHECK: vpshldvq %ymm23, %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x20,0x71,0xef]
          vpshldvq %ymm23, %ymm23, %ymm21

// CHECK: vpshrdvw %ymm23, %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x20,0x72,0xef]
          vpshrdvw %ymm23, %ymm23, %ymm21

// CHECK: vpshrdvd %ymm23, %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0x45,0x20,0x73,0xef]
          vpshrdvd %ymm23, %ymm23, %ymm21

// CHECK: vpshrdvq %ymm23, %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x20,0x73,0xef]
          vpshrdvq %ymm23, %ymm23, %ymm21

// CHECK: vpshldvw %ymm3, %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x2a,0x70,0xcb]
          vpshldvw %ymm3, %ymm3, %ymm1 {%k2}

// CHECK: vpshldvd %ymm3, %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x65,0x2a,0x71,0xcb]
          vpshldvd %ymm3, %ymm3, %ymm1 {%k2}

// CHECK: vpshldvq %ymm3, %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x2a,0x71,0xcb]
          vpshldvq %ymm3, %ymm3, %ymm1 {%k2}

// CHECK: vpshrdvw %ymm3, %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x2a,0x72,0xcb]
          vpshrdvw %ymm3, %ymm3, %ymm1 {%k2}

// CHECK: vpshrdvd %ymm3, %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x65,0x2a,0x73,0xcb]
          vpshrdvd %ymm3, %ymm3, %ymm1 {%k2}

// CHECK: vpshrdvq %ymm3, %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x2a,0x73,0xcb]
          vpshrdvq %ymm3, %ymm3, %ymm1 {%k2}

// CHECK: vpshldvw %ymm23, %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x22,0x70,0xef]
          vpshldvw %ymm23, %ymm23, %ymm21 {%k2}

// CHECK: vpshldvd %ymm23, %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x45,0x22,0x71,0xef]
          vpshldvd %ymm23, %ymm23, %ymm21 {%k2}

// CHECK: vpshldvq %ymm23, %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x22,0x71,0xef]
          vpshldvq %ymm23, %ymm23, %ymm21 {%k2}

// CHECK: vpshrdvw %ymm23, %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x22,0x72,0xef]
          vpshrdvw %ymm23, %ymm23, %ymm21 {%k2}

// CHECK: vpshrdvd %ymm23, %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x45,0x22,0x73,0xef]
          vpshrdvd %ymm23, %ymm23, %ymm21 {%k2}

// CHECK: vpshrdvq %ymm23, %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x22,0x73,0xef]
          vpshrdvq %ymm23, %ymm23, %ymm21 {%k2}

// CHECK: vpshldvw  (%rcx), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x28,0x70,0x09]
          vpshldvw  (%rcx), %ymm3, %ymm1

// CHECK: vpshldvw  -128(%rsp), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x28,0x70,0x4c,0x24,0xfc]
          vpshldvw  -128(%rsp), %ymm3, %ymm1

// CHECK: vpshldvw  128(%rsp), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x28,0x70,0x4c,0x24,0x04]
          vpshldvw  128(%rsp), %ymm3, %ymm1

// CHECK: vpshldvw  268435456(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x28,0x70,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshldvw  268435456(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshldvw  -536870912(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x28,0x70,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvw  -536870912(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshldvw  -536870910(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x28,0x70,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvw  -536870910(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshldvd  (%rcx), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0x65,0x28,0x71,0x09]
          vpshldvd  (%rcx), %ymm3, %ymm1

// CHECK: vpshldvd  -128(%rsp), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0x65,0x28,0x71,0x4c,0x24,0xfc]
          vpshldvd  -128(%rsp), %ymm3, %ymm1

// CHECK: vpshldvd  128(%rsp), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0x65,0x28,0x71,0x4c,0x24,0x04]
          vpshldvd  128(%rsp), %ymm3, %ymm1

// CHECK: vpshldvd  268435456(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb2,0x65,0x28,0x71,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshldvd  268435456(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshldvd  -536870912(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb2,0x65,0x28,0x71,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvd  -536870912(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshldvd  -536870910(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb2,0x65,0x28,0x71,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvd  -536870910(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshldvq  (%rcx), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x28,0x71,0x09]
          vpshldvq  (%rcx), %ymm3, %ymm1

// CHECK: vpshldvq  -128(%rsp), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x28,0x71,0x4c,0x24,0xfc]
          vpshldvq  -128(%rsp), %ymm3, %ymm1

// CHECK: vpshldvq  128(%rsp), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x28,0x71,0x4c,0x24,0x04]
          vpshldvq  128(%rsp), %ymm3, %ymm1

// CHECK: vpshldvq  268435456(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x28,0x71,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshldvq  268435456(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshldvq  -536870912(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x28,0x71,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvq  -536870912(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshldvq  -536870910(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x28,0x71,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvq  -536870910(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshrdvw  (%rcx), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x28,0x72,0x09]
          vpshrdvw  (%rcx), %ymm3, %ymm1

// CHECK: vpshrdvw  -128(%rsp), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x28,0x72,0x4c,0x24,0xfc]
          vpshrdvw  -128(%rsp), %ymm3, %ymm1

// CHECK: vpshrdvw  128(%rsp), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x28,0x72,0x4c,0x24,0x04]
          vpshrdvw  128(%rsp), %ymm3, %ymm1

// CHECK: vpshrdvw  268435456(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x28,0x72,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvw  268435456(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshrdvw  -536870912(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x28,0x72,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvw  -536870912(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshrdvw  -536870910(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x28,0x72,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvw  -536870910(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshrdvd  (%rcx), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0x65,0x28,0x73,0x09]
          vpshrdvd  (%rcx), %ymm3, %ymm1

// CHECK: vpshrdvd  -128(%rsp), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0x65,0x28,0x73,0x4c,0x24,0xfc]
          vpshrdvd  -128(%rsp), %ymm3, %ymm1

// CHECK: vpshrdvd  128(%rsp), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0x65,0x28,0x73,0x4c,0x24,0x04]
          vpshrdvd  128(%rsp), %ymm3, %ymm1

// CHECK: vpshrdvd  268435456(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb2,0x65,0x28,0x73,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvd  268435456(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshrdvd  -536870912(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb2,0x65,0x28,0x73,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvd  -536870912(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshrdvd  -536870910(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb2,0x65,0x28,0x73,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvd  -536870910(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshrdvq  (%rcx), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x28,0x73,0x09]
          vpshrdvq  (%rcx), %ymm3, %ymm1

// CHECK: vpshrdvq  -128(%rsp), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x28,0x73,0x4c,0x24,0xfc]
          vpshrdvq  -128(%rsp), %ymm3, %ymm1

// CHECK: vpshrdvq  128(%rsp), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xf2,0xe5,0x28,0x73,0x4c,0x24,0x04]
          vpshrdvq  128(%rsp), %ymm3, %ymm1

// CHECK: vpshrdvq  268435456(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x28,0x73,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvq  268435456(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshrdvq  -536870912(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x28,0x73,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvq  -536870912(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshrdvq  -536870910(%rcx,%r14,8), %ymm3, %ymm1
// CHECK: encoding: [0x62,0xb2,0xe5,0x28,0x73,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvq  -536870910(%rcx,%r14,8), %ymm3, %ymm1

// CHECK: vpshldvw  (%rcx), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x20,0x70,0x29]
          vpshldvw  (%rcx), %ymm23, %ymm21

// CHECK: vpshldvw  -128(%rsp), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x20,0x70,0x6c,0x24,0xfc]
          vpshldvw  -128(%rsp), %ymm23, %ymm21

// CHECK: vpshldvw  128(%rsp), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x20,0x70,0x6c,0x24,0x04]
          vpshldvw  128(%rsp), %ymm23, %ymm21

// CHECK: vpshldvw  268435456(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x20,0x70,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshldvw  268435456(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshldvw  -536870912(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x20,0x70,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvw  -536870912(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshldvw  -536870910(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x20,0x70,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvw  -536870910(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshldvd  (%rcx), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe2,0x45,0x20,0x71,0x29]
          vpshldvd  (%rcx), %ymm23, %ymm21

// CHECK: vpshldvd  -128(%rsp), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe2,0x45,0x20,0x71,0x6c,0x24,0xfc]
          vpshldvd  -128(%rsp), %ymm23, %ymm21

// CHECK: vpshldvd  128(%rsp), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe2,0x45,0x20,0x71,0x6c,0x24,0x04]
          vpshldvd  128(%rsp), %ymm23, %ymm21

// CHECK: vpshldvd  268435456(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0x45,0x20,0x71,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshldvd  268435456(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshldvd  -536870912(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0x45,0x20,0x71,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvd  -536870912(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshldvd  -536870910(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0x45,0x20,0x71,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvd  -536870910(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshldvq  (%rcx), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x20,0x71,0x29]
          vpshldvq  (%rcx), %ymm23, %ymm21

// CHECK: vpshldvq  -128(%rsp), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x20,0x71,0x6c,0x24,0xfc]
          vpshldvq  -128(%rsp), %ymm23, %ymm21

// CHECK: vpshldvq  128(%rsp), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x20,0x71,0x6c,0x24,0x04]
          vpshldvq  128(%rsp), %ymm23, %ymm21

// CHECK: vpshldvq  268435456(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x20,0x71,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshldvq  268435456(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshldvq  -536870912(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x20,0x71,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvq  -536870912(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshldvq  -536870910(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x20,0x71,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvq  -536870910(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshrdvw  (%rcx), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x20,0x72,0x29]
          vpshrdvw  (%rcx), %ymm23, %ymm21

// CHECK: vpshrdvw  -128(%rsp), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x20,0x72,0x6c,0x24,0xfc]
          vpshrdvw  -128(%rsp), %ymm23, %ymm21

// CHECK: vpshrdvw  128(%rsp), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x20,0x72,0x6c,0x24,0x04]
          vpshrdvw  128(%rsp), %ymm23, %ymm21

// CHECK: vpshrdvw  268435456(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x20,0x72,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvw  268435456(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshrdvw  -536870912(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x20,0x72,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvw  -536870912(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshrdvw  -536870910(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x20,0x72,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvw  -536870910(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshrdvd  (%rcx), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe2,0x45,0x20,0x73,0x29]
          vpshrdvd  (%rcx), %ymm23, %ymm21

// CHECK: vpshrdvd  -128(%rsp), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe2,0x45,0x20,0x73,0x6c,0x24,0xfc]
          vpshrdvd  -128(%rsp), %ymm23, %ymm21

// CHECK: vpshrdvd  128(%rsp), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe2,0x45,0x20,0x73,0x6c,0x24,0x04]
          vpshrdvd  128(%rsp), %ymm23, %ymm21

// CHECK: vpshrdvd  268435456(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0x45,0x20,0x73,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvd  268435456(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshrdvd  -536870912(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0x45,0x20,0x73,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvd  -536870912(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshrdvd  -536870910(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0x45,0x20,0x73,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvd  -536870910(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshrdvq  (%rcx), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x20,0x73,0x29]
          vpshrdvq  (%rcx), %ymm23, %ymm21

// CHECK: vpshrdvq  -128(%rsp), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x20,0x73,0x6c,0x24,0xfc]
          vpshrdvq  -128(%rsp), %ymm23, %ymm21

// CHECK: vpshrdvq  128(%rsp), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xe2,0xc5,0x20,0x73,0x6c,0x24,0x04]
          vpshrdvq  128(%rsp), %ymm23, %ymm21

// CHECK: vpshrdvq  268435456(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x20,0x73,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvq  268435456(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshrdvq  -536870912(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x20,0x73,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvq  -536870912(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshrdvq  -536870910(%rcx,%r14,8), %ymm23, %ymm21
// CHECK: encoding: [0x62,0xa2,0xc5,0x20,0x73,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvq  -536870910(%rcx,%r14,8), %ymm23, %ymm21

// CHECK: vpshldvw  (%rcx), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x2a,0x70,0x09]
          vpshldvw  (%rcx), %ymm3, %ymm1 {%k2}

// CHECK: vpshldvw  -128(%rsp), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x2a,0x70,0x4c,0x24,0xfc]
          vpshldvw  -128(%rsp), %ymm3, %ymm1 {%k2}

// CHECK: vpshldvw  128(%rsp), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x2a,0x70,0x4c,0x24,0x04]
          vpshldvw  128(%rsp), %ymm3, %ymm1 {%k2}

// CHECK: vpshldvw  268435456(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x2a,0x70,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshldvw  268435456(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshldvw  -536870912(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x2a,0x70,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvw  -536870912(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshldvw  -536870910(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x2a,0x70,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvw  -536870910(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshldvd  (%rcx), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x65,0x2a,0x71,0x09]
          vpshldvd  (%rcx), %ymm3, %ymm1 {%k2}

// CHECK: vpshldvd  -128(%rsp), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x65,0x2a,0x71,0x4c,0x24,0xfc]
          vpshldvd  -128(%rsp), %ymm3, %ymm1 {%k2}

// CHECK: vpshldvd  128(%rsp), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x65,0x2a,0x71,0x4c,0x24,0x04]
          vpshldvd  128(%rsp), %ymm3, %ymm1 {%k2}

// CHECK: vpshldvd  268435456(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0x65,0x2a,0x71,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshldvd  268435456(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshldvd  -536870912(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0x65,0x2a,0x71,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvd  -536870912(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshldvd  -536870910(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0x65,0x2a,0x71,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvd  -536870910(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshldvq  (%rcx), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x2a,0x71,0x09]
          vpshldvq  (%rcx), %ymm3, %ymm1 {%k2}

// CHECK: vpshldvq  -128(%rsp), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x2a,0x71,0x4c,0x24,0xfc]
          vpshldvq  -128(%rsp), %ymm3, %ymm1 {%k2}

// CHECK: vpshldvq  128(%rsp), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x2a,0x71,0x4c,0x24,0x04]
          vpshldvq  128(%rsp), %ymm3, %ymm1 {%k2}

// CHECK: vpshldvq  268435456(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x2a,0x71,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshldvq  268435456(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshldvq  -536870912(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x2a,0x71,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvq  -536870912(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshldvq  -536870910(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x2a,0x71,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvq  -536870910(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdvw  (%rcx), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x2a,0x72,0x09]
          vpshrdvw  (%rcx), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdvw  -128(%rsp), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x2a,0x72,0x4c,0x24,0xfc]
          vpshrdvw  -128(%rsp), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdvw  128(%rsp), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x2a,0x72,0x4c,0x24,0x04]
          vpshrdvw  128(%rsp), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdvw  268435456(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x2a,0x72,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvw  268435456(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdvw  -536870912(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x2a,0x72,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvw  -536870912(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdvw  -536870910(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x2a,0x72,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvw  -536870910(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdvd  (%rcx), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x65,0x2a,0x73,0x09]
          vpshrdvd  (%rcx), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdvd  -128(%rsp), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x65,0x2a,0x73,0x4c,0x24,0xfc]
          vpshrdvd  -128(%rsp), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdvd  128(%rsp), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0x65,0x2a,0x73,0x4c,0x24,0x04]
          vpshrdvd  128(%rsp), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdvd  268435456(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0x65,0x2a,0x73,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvd  268435456(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdvd  -536870912(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0x65,0x2a,0x73,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvd  -536870912(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdvd  -536870910(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0x65,0x2a,0x73,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvd  -536870910(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdvq  (%rcx), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x2a,0x73,0x09]
          vpshrdvq  (%rcx), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdvq  -128(%rsp), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x2a,0x73,0x4c,0x24,0xfc]
          vpshrdvq  -128(%rsp), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdvq  128(%rsp), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xf2,0xe5,0x2a,0x73,0x4c,0x24,0x04]
          vpshrdvq  128(%rsp), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdvq  268435456(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x2a,0x73,0x8c,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvq  268435456(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdvq  -536870912(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x2a,0x73,0x8c,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvq  -536870912(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshrdvq  -536870910(%rcx,%r14,8), %ymm3, %ymm1 {%k2}
// CHECK: encoding: [0x62,0xb2,0xe5,0x2a,0x73,0x8c,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvq  -536870910(%rcx,%r14,8), %ymm3, %ymm1 {%k2}

// CHECK: vpshldvw  (%rcx), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x22,0x70,0x29]
          vpshldvw  (%rcx), %ymm23, %ymm21 {%k2}

// CHECK: vpshldvw  -128(%rsp), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x22,0x70,0x6c,0x24,0xfc]
          vpshldvw  -128(%rsp), %ymm23, %ymm21 {%k2}

// CHECK: vpshldvw  128(%rsp), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x22,0x70,0x6c,0x24,0x04]
          vpshldvw  128(%rsp), %ymm23, %ymm21 {%k2}

// CHECK: vpshldvw  268435456(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x22,0x70,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshldvw  268435456(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshldvw  -536870912(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x22,0x70,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvw  -536870912(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshldvw  -536870910(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x22,0x70,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvw  -536870910(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshldvd  (%rcx), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0x45,0x22,0x71,0x29]
          vpshldvd  (%rcx), %ymm23, %ymm21 {%k2}

// CHECK: vpshldvd  -128(%rsp), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0x45,0x22,0x71,0x6c,0x24,0xfc]
          vpshldvd  -128(%rsp), %ymm23, %ymm21 {%k2}

// CHECK: vpshldvd  128(%rsp), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0x45,0x22,0x71,0x6c,0x24,0x04]
          vpshldvd  128(%rsp), %ymm23, %ymm21 {%k2}

// CHECK: vpshldvd  268435456(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x45,0x22,0x71,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshldvd  268435456(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshldvd  -536870912(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x45,0x22,0x71,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvd  -536870912(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshldvd  -536870910(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x45,0x22,0x71,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvd  -536870910(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshldvq  (%rcx), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x22,0x71,0x29]
          vpshldvq  (%rcx), %ymm23, %ymm21 {%k2}

// CHECK: vpshldvq  -128(%rsp), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x22,0x71,0x6c,0x24,0xfc]
          vpshldvq  -128(%rsp), %ymm23, %ymm21 {%k2}

// CHECK: vpshldvq  128(%rsp), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x22,0x71,0x6c,0x24,0x04]
          vpshldvq  128(%rsp), %ymm23, %ymm21 {%k2}

// CHECK: vpshldvq  268435456(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x22,0x71,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshldvq  268435456(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshldvq  -536870912(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x22,0x71,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshldvq  -536870912(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshldvq  -536870910(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x22,0x71,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshldvq  -536870910(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdvw  (%rcx), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x22,0x72,0x29]
          vpshrdvw  (%rcx), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdvw  -128(%rsp), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x22,0x72,0x6c,0x24,0xfc]
          vpshrdvw  -128(%rsp), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdvw  128(%rsp), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x22,0x72,0x6c,0x24,0x04]
          vpshrdvw  128(%rsp), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdvw  268435456(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x22,0x72,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvw  268435456(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdvw  -536870912(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x22,0x72,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvw  -536870912(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdvw  -536870910(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x22,0x72,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvw  -536870910(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdvd  (%rcx), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0x45,0x22,0x73,0x29]
          vpshrdvd  (%rcx), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdvd  -128(%rsp), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0x45,0x22,0x73,0x6c,0x24,0xfc]
          vpshrdvd  -128(%rsp), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdvd  128(%rsp), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0x45,0x22,0x73,0x6c,0x24,0x04]
          vpshrdvd  128(%rsp), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdvd  268435456(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x45,0x22,0x73,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvd  268435456(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdvd  -536870912(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x45,0x22,0x73,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvd  -536870912(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdvd  -536870910(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0x45,0x22,0x73,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvd  -536870910(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdvq  (%rcx), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x22,0x73,0x29]
          vpshrdvq  (%rcx), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdvq  -128(%rsp), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x22,0x73,0x6c,0x24,0xfc]
          vpshrdvq  -128(%rsp), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdvq  128(%rsp), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xe2,0xc5,0x22,0x73,0x6c,0x24,0x04]
          vpshrdvq  128(%rsp), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdvq  268435456(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x22,0x73,0xac,0xf1,0x00,0x00,0x00,0x10]
          vpshrdvq  268435456(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdvq  -536870912(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x22,0x73,0xac,0xf1,0x00,0x00,0x00,0xe0]
          vpshrdvq  -536870912(%rcx,%r14,8), %ymm23, %ymm21 {%k2}

// CHECK: vpshrdvq  -536870910(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
// CHECK: encoding: [0x62,0xa2,0xc5,0x22,0x73,0xac,0xf1,0x02,0x00,0x00,0xe0]
          vpshrdvq  -536870910(%rcx,%r14,8), %ymm23, %ymm21 {%k2}
