/* LogJam, a GTK LiveJournal client.
 * Copyright (C) 2000,2001 Evan Martin <evan@livejournal.com>
 * vim:ts=4:sw=4:
 *
 * $Id: security.h,v 1.2 2001/07/14 05:56:17 martine Exp $
 */

#ifndef __SECURITY_H__
#define __SECURITY_H__

#include <gtk/gtkbutton.h>

typedef enum {
	SECURITY_PUBLIC = 0,
	SECURITY_PRIVATE,
	SECURITY_FRIENDS,
	SECURITY_CUSTOM
} SecurityType;

typedef struct {
	SecurityType type;
	unsigned int allowmask;
} security_data;

void security_append_to_request(security_data *security, GHashTable *request);
void security_load(security_data *security, char *sectext, char *allowmask);
void security_load_from_request(security_data *security, GHashTable *request);

/* in a vain attempt to write clean code,
 * i've written this as a gtk widget.
 */

#define SECMGR(obj)          GTK_CHECK_CAST (obj, secmgr_get_type (), SecMgr)
#define SECMGR_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, secmgr_get_type (), SecMgrClass)
#define IS_SECMGR(obj)       GTK_CHECK_TYPE (obj, secmgr_get_type ())

typedef struct _SecMgr       SecMgr;
typedef struct _SecMgrClass  SecMgrClass;

struct _SecMgr
{
	GtkButton button;
	security_data *security;
};

struct _SecMgrClass
{
	GtkButtonClass parent_class;
};

guint          secmgr_get_type        (void);
GtkWidget*     secmgr_new             (security_data *security);

void           secmgr_set_data        (SecMgr *sm, security_data *security);

#endif /* __SECURITY_H__ */
